#include "stralloc.h"
#include "sig.h"
#include "exit.h"
#include "str.h"
#include "fmt.h"
#include "httpdate.h"
#include "timeoutread.h"
#include "timeoutwrite.h"
#include "buffer.h"
#include "getln.h"
#include "droproot.h"

#define FATAL "echo-httpd: fatal: "

int safewrite(int fd,char *buf,int len)
{
  int r;
  r = timeoutwrite(60,fd,buf,len);
  if (r <= 0) _exit(0);
  return r;
}

char outbuf[1024];
buffer out = BUFFER_INIT(safewrite,1,outbuf,sizeof outbuf);

void out_put(char *s,int len)
{
  buffer_put(&out,s,len);
}

void out_puts(char *s)
{
  buffer_puts(&out,s);
}

void out_flush(void)
{
  buffer_flush(&out);
}

char strnum[FMT_ULONG];

struct tai now;
stralloc nowstr = {0};

void header(char *code,char *message)
{
  out_puts("HTTP/1.0 ");
  out_puts(code);
  out_puts(message);
  out_puts("\r\nServer: echo-httpd\r\nDate:");
  tai_now(&now);
  if (!httpdate(&nowstr,&now)) _exit(21);
  out_put(nowstr.s,nowstr.len);
  out_puts("\r\n");
}

stralloc line = {0};

int saferead(int fd,char *buf,int len)
{
  int r;
  r = timeoutread(10,fd,buf,len);
  if (r <= 0) _exit(0);
  return r;
}

char inbuf[512];
buffer in = BUFFER_INIT(saferead,0,inbuf,sizeof inbuf);

main ()
{
  int match;

  droproot(FATAL);

  sig_ignore(sig_pipe);

  header("200 ","OK");
  out_puts("\r\n");
  out_flush();

  for (;;) {
    if (getln(&in,&line,&match,'\n') == -1) _exit(21);
    if (!line.len) _exit(0);
    out_put(line.s,line.len);
    out_flush();
    if (!match) _exit(0);
  }
}
