#include <sys/types.h>
#include <sys/stat.h>
#include <pwd.h>
#include "strerr.h"
#include "buffer.h"
#include "open.h"
#include "readwrite.h"
#include "exit.h"
#include "auto_home.h"
#include "generic-conf.h"
#include "fmt.h"

#define FATAL "constant-config: fatal: "

char strnum[FMT_ULONG];

void usage(void)
{
  strerr_die1x(100,"constant-config: usage: constant-config user loguser dir port file");
}

char *dir;
char *fn;
char buf[1024];
int fd;
buffer ss;

char *user;
char *port;
char *loguser;
char *file;
struct passwd *pw;

main(int argc,char **argv)
{
  user = *++argv;
  if (!user) usage();
  loguser = *++argv;
  if (!loguser) usage();
  dir = *++argv;
  if (!dir) usage();
  if (dir[0] != '/') usage();
  port = *++argv;
  if (!port) usage();
  file = *++argv;
  if (!file) usage();

  pw = getpwnam(loguser);
  if (!pw)
    strerr_die3x(111,FATAL,"unknown account ",loguser);

  init(dir,FATAL);
  makelog(loguser,pw->pw_uid,pw->pw_gid);

  pw = getpwnam(user);
  if (!pw)
    strerr_die3x(111,FATAL,"unknown account ",loguser);

  start("run");
  outs("#!/bin/sh\nexec 2>&1\nexec envdir "); outs(dir);
  outs("/env softlimit -o20 -d50000 tcpserver -vDRHl0 -b50 -c100 0 ");
  outs(port); outs(" "); outs(auto_home); outs("/bin/constant-httpd ");
  outs(file); outs("\n");
  finish();
  perm(0755);

  makedir("env");
  perm(02755);

  start("env/ROOT");
  outs(dir); outs("/root\n");
  finish();
  perm(0644);

  start("env/UID");
  out(strnum,fmt_ulong(strnum,pw->pw_uid));
  finish();
  perm(0644);

  start("env/GID");
  out(strnum,fmt_ulong(strnum,pw->pw_gid));
  finish();
  perm(0644);

  start("env/REQUESTHOST");
  finish();
  perm(0644);

  makedir("root");
  perm(02755);

  _exit(0);
}
