/*
 * This file is part of sudognu.
 *
 * Copyright (C) 2007 Jens Baaran, Germany.
 ******************************************************************************/

#include <stdio.h>
#include "sudoku.h"

/*
 ******************************************************************************/
int block_line(t_sudoku *sudoku, int doElim, int verbosity) {
	
	int size = sudoku->size;
	int br, bc, r, c, sr, sc, bbr, bbc, cc, nc, nr, ccc[SIZE], rrr[SIZE];
	int nelim, nlb = 0;
	char estr[512];
	
	// loop over blocks
	for (br=0; br<SIZE; br++) {
		for (bc=0; bc<SIZE; bc++) {
			// for all candidates check, in how many rows of that block they appear
			for (cc=0; cc < size; cc++) {
				for (r=0; r<SIZE; r++) ccc[r] = rrr[r] = -1;
				for (r=br*SIZE, bbr=0; r<(br+1)*SIZE; r++, bbr++) {
					for (c=bc*SIZE, bbc=0; c<(bc+1)*SIZE; c++, bbc++) {
						if (sudoku->grid[r][c].cand[cc] > 0) {
							ccc[bbc] = c;
							rrr[bbr] = r;
						}
					}
				}
				for (nc = nr = bbr = 0; bbr<SIZE; bbr++) {
					if (rrr[bbr] >= 0) sr = rrr[bbr], nr++;
					if (ccc[bbr] >= 0) sc = ccc[bbr], nc++;
				}
				// if candidate appears only in 1 row, eliminate candidates
				// in other blocks along that row
				nelim = 0;
				if (nr == 1) {
					for (bbc=0; bbc<bc; bbc++) {
						for (c=bbc*SIZE; c<(bbc+1)*SIZE; c++) {
							if (sudoku->grid[sr][c].cand[cc] > 0) {
								if (doElim == 1) {
									nelim++;
									sudoku->grid[sr][c].cand[cc] = 0;
									sudoku->grid[sr][c].ncand -= 1;
								} else {
									nlb++;
									goto check_column;
								}
							}
						}
					}
					for (bbc=bc+1; bbc<SIZE; bbc++) {
						for (c=bbc*SIZE; c<(bbc+1)*SIZE; c++) {
							if (sudoku->grid[sr][c].cand[cc] > 0) {
								if (doElim == 1) {
									nelim++;
									sudoku->grid[sr][c].cand[cc] = 0;
									sudoku->grid[sr][c].ncand -= 1;
								} else {
									nlb++;
									goto check_column;
								}
							}
						}
					}
					if (nelim > 0) {
						snprintf(estr,511,"b  b%d%dr%d, (%d) block-row -%d candidates",br+1,bc+1,sr+1,cc+1,nelim);
						estr[511] = '\0';
						fprint_explain(estr,*sudoku,verbosity);
						return(nelim);
					}
				}
				
				check_column:
				// if candidate appears only in 1 column, eliminate candidates
				// in other blocks along that column
				if (nc == 1) {
					for (bbr=0; bbr<br; bbr++) {
						for (r=bbr*SIZE; r<(bbr+1)*SIZE; r++) {
							if (sudoku->grid[r][sc].cand[cc] > 0) {
								if (doElim == 1) {
									nelim++;
									sudoku->grid[r][sc].cand[cc] = 0;
									sudoku->grid[r][sc].ncand -= 1;
								} else {
									nlb++;
									goto next_candidate;
								}
							}
						}
					}
					for (bbr=br+1; bbr<SIZE; bbr++) {
						for (r=bbr*SIZE; r<(bbr+1)*SIZE; r++) {
							if (sudoku->grid[r][sc].cand[cc] > 0) {
								if (doElim == 1) {
									nelim++;
									sudoku->grid[r][sc].cand[cc] = 0;
									sudoku->grid[r][sc].ncand -= 1;
								} else {
									nlb++;
									goto next_candidate;
								}
							}
						}
					}
					if (nelim > 0) {
						snprintf(estr,511,"b  b%d%dc%d, (%d) block-column -%d candidates",br+1,bc+1,sc+1,cc+1,nelim);
						estr[511] = '\0';
						fprint_explain(estr,*sudoku,verbosity);
						return(nelim);
					}
				}
				next_candidate: continue;
			}
		}
	}
	return(nlb); // nlb is 0 for doElim == 1
}

/*
 ******************************************************************************/
int line_block(t_sudoku *sudoku, int doElim, int verbosity) {
	
	int size = sudoku->size;
	int r, c, b, bc, r0, c0, row, col, cc, nbc, blkc[SIZE];
	int nelim = 0, nlb = 0;
	char estr[512];

	// loop over rows / columns
	for (c = 0; c < size; c++) {
		// for all candidates
		for (cc=0; cc < size; cc++) {

			// check columns
			for (nbc = b = 0; b < SIZE; b++) {
				blkc[b] = 0;
				for (bc = 0; bc < SIZE; bc++) {
					if (sudoku->grid[b*SIZE+bc][c].cand[cc] > 0) {
						blkc[b] = 1;
						nbc++;
						break;
					}
				}
			}

			// if candidate appears in only one block within column look for same
			// candidate in other columns of that block & eliminate them
			c0 = (c / SIZE) * SIZE;
			if (nbc == 1) {
				for (b = 0; b < SIZE; b++) {
					if (blkc[b] == 1) {
						r0 = b * SIZE;
						for (r=0; r<size; r++) {
							row = r0 + r / SIZE;
							col = c0 + r % SIZE;
							if ((col != c) && (sudoku->grid[row][col].cand[cc]) != 0) {
								if (doElim == 1) {
									nelim++;
									sudoku->grid[row][col].cand[cc] = 0;
									sudoku->grid[row][col].ncand -= 1;
								} else {
									nlb++;
									goto check_rows;
								}
							}
						}
					}
				}
				
				// if candidates were eliminated, return
				if (nelim > 0) {
					snprintf(estr,511,"B  c%db%d%d, (%d) column-block -%d candidates",c+1,r0/SIZE+1,c0/SIZE+1,cc+1,nelim);
					estr[511] = '\0';
					fprint_explain(estr,*sudoku,verbosity);
					return(nelim);
				}
			}

			// check rows
			check_rows:
			for (nbc = b = 0; b < SIZE; b++) {
				blkc[b] = 0;
				for (bc = 0; bc < SIZE; bc++) {
					if (sudoku->grid[c][b*SIZE+bc].cand[cc] > 0) {
						blkc[b] = 1;
						nbc++;
						break;
					}
				}
			}

			// if candidate appears in only one block within row look for same
			// candidate in other rows of that block & eliminate them
			r0 = (c / SIZE) * SIZE;
			if (nbc == 1) {
				for (b = 0; b < SIZE; b++) {
					if (blkc[b] == 1) {
						c0 = b * SIZE;
						for (r=0; r<size; r++) {
							row = r0 + r / SIZE;
							col = c0 + r % SIZE;
							if ((row != c) && (sudoku->grid[row][col].cand[cc]) != 0) {
								if (doElim == 1) {
									nelim++;
									sudoku->grid[row][col].cand[cc] = 0;
									sudoku->grid[row][col].ncand -= 1;
								} else {
									nlb++;
									goto next_candidate;
								}
							}
						}
					}
				}
				
				// if candidates were eliminated, return
				if (nelim > 0) {
					snprintf(estr,511,"B  r%db%d%d, (%d) column-block -%d candidates",c+1,r0/SIZE+1,c0/SIZE+1,cc+1,nelim);
					estr[511] = '\0';
					fprint_explain(estr,*sudoku,verbosity);
					return(nelim);
				}
			}
			next_candidate: continue;
		}
	}
	return(nlb); // nlb is 0 for doElim == 1
}

