/*
 * sisctrl - SiS Display Control Panel
 * for the SiS XFree86/X.org driver
 *
 * Public interface routines for SISCTRL extension - definitions
 *
 * (C) 2003-2005 Thomas Winischhofer <thomas@winischhofer.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef _SISCTRLSTR_H_
#define _SISCTRLSTR_H_

#include <X11/Xfuncproto.h>

#define X_SiSCtrlQueryVersion	0
#define X_SiSCtrlCommand	1

#define SISCTRL_PROTOCOL_NAME	"SISCTRL"

#define SISCTRL_MAJOR_VERSION	0	/* current version numbers */
#define SISCTRL_MINOR_VERSION	1

#define SDC_NUM_PARM_RESULT	20	/* Fixed for this version */

#ifdef SISCTRL_PRIVATE /* ---------------------- private ------------------ */

#define SISCTRL_MAX_SCREENS	32

typedef struct _SiSCtrlQueryVersion {
    CARD8	reqType;		/* always SiSCtrlReqCode */
    CARD8	SiSCtrlReqType;		/* always SiSCtrl_SiSCtrlQueryVersion */
    CARD16	length B16;
} xSiSCtrlQueryVersionReq;
#define sz_xSiSCtrlQueryVersionReq	4

typedef struct {
    BYTE	type;			/* X_Reply */
    BOOL	pad1;
    CARD16	sequenceNumber B16;
    CARD32	length B32;
    CARD16	majorVersion B16;	/* major version of SISCTRL */
    CARD16	minorVersion B16;	/* minor version of SISCTRL */
    CARD32	pad2 B32;
    CARD32	pad3 B32;
    CARD32	pad4 B32;
    CARD32	pad5 B32;
    CARD32	pad6 B32;
} xSiSCtrlQueryVersionReply;
#define sz_xSiSCtrlQueryVersionReply	32

typedef struct {
    CARD8	reqType;		/* always SiSCtrlReqCode */
    CARD8	SiSCtrlReqType;		/* always X_SiSCtrlCommand */
    CARD16	length B16;
    CARD32	pad1 B32;
    CARD32	screen;
    CARD32 	sdc_id;
    CARD32 	sdc_chksum;
    CARD32	sdc_command;
    CARD32	sdc_parm[SDC_NUM_PARM_RESULT];
    CARD32	sdc_result_header;
    CARD32	sdc_result[SDC_NUM_PARM_RESULT];
    char	sdc_buffer[32];
} xSiSCtrlCommandReq;
#define sz_xSiSCtrlCommandReq		(28 + (SDC_NUM_PARM_RESULT * 4 * 2) + 32)

typedef struct {
    BYTE	type;			/* X_Reply */
    BOOL	pad1;
    CARD16	sequenceNumber B16;
    CARD32	length B32;
    CARD32	screen;
    CARD32 	sdc_id;
    CARD32 	sdc_chksum;
    CARD32	sdc_command;
    CARD32	sdc_parm[SDC_NUM_PARM_RESULT];
    CARD32	sdc_result_header;
    CARD32	sdc_result[SDC_NUM_PARM_RESULT];
    char	sdc_buffer[32];
} xSiSCtrlCommandReply;
#define sz_xSiSCtrlCommandReply		(28 + (SDC_NUM_PARM_RESULT * 4 * 2) + 32)

#endif /* --------------------------- end of private stuff ---------------------- */

#define SDC_ID				0x53495321

#define SDC_VERSION			1

/* sdc_command */
#define SDC_CMD_GETVERSION 		0x98980001
#define SDC_CMD_GETHWINFO		0x98980002
#define SDC_CMD_GETALLFLAGS		0x98980003
#define SDC_CMD_GETVBFLAGSVERSION	0x98980004
#define SDC_CMD_GETVBFLAGS		0x98980005
#define SDC_CMD_CHECKMODEFORCRT2 	0x98980006
#define SDC_CMD_SETVBFLAGS		0x98980007
#define SDC_CMD_GETDETECTEDDEVICES	0x98980008
#define SDC_CMD_REDETECTCRT2DEVICES	0x98980009
#define SDC_CMD_GETCRT1STATUS		0x9898000a
#define SDC_CMD_SETCRT1STATUS		0x9898000b
#define SDC_CMD_GETSDFLAGS		0x9898000c
#define SDC_CMD_GETSD2FLAGS		0x9898000d
#define SDC_CMD_GETLOCKSTATUS		0x9898000e
#define SDC_CMD_SETLOCKSTATUS		0x9898000f
#define SDC_CMD_GETTVANTIFLICKER	0x98980010
#define SDC_CMD_SETTVANTIFLICKER	0x98980011
#define SDC_CMD_GETTVSATURATION		0x98980012
#define SDC_CMD_SETTVSATURATION		0x98980013
#define SDC_CMD_GETTVEDGEENHANCE	0x98980014
#define SDC_CMD_SETTVEDGEENHANCE	0x98980015
#define SDC_CMD_GETTVCFILTER		0x98980016
#define SDC_CMD_SETTVCFILTER		0x98980017
#define SDC_CMD_GETTVYFILTER		0x98980018
#define SDC_CMD_SETTVYFILTER		0x98980019
#define SDC_CMD_GETTVCOLORCALIB		0x9898001a
#define SDC_CMD_SETTVCOLORCALIB		0x9898001b
#define SDC_CMD_GETTVCHCONTRAST		0x9898001c
#define SDC_CMD_SETTVCHCONTRAST		0x9898001d
#define SDC_CMD_GETTVCHTEXTENHANCE	0x9898001e
#define SDC_CMD_SETTVCHTEXTENHANCE	0x9898001f
#define SDC_CMD_GETTVCHCHROMAFLICKERFILTER 0x98980020
#define SDC_CMD_SETTVCHCHROMAFLICKERFILTER 0x98980021
#define SDC_CMD_GETTVCHLUMAFLICKERFILTER 0x98980022
#define SDC_CMD_SETTVCHLUMAFLICKERFILTER 0x98980023
#define SDC_CMD_GETTVCHCVBSCOLOR	0x98980024
#define SDC_CMD_SETTVCHCVBSCOLOR	0x98980025
#define SDC_CMD_GETCHTVOVERSCAN		0x98980026
#define SDC_CMD_SETCHTVOVERSCAN		0x98980027
#define SDC_CMD_GETGAMMASTATUS		0x98980028
#define SDC_CMD_SETGAMMASTATUS		0x98980029
#define SDC_CMD_GETTVXSCALE		0x9898002a
#define SDC_CMD_SETTVXSCALE		0x9898002b
#define SDC_CMD_GETTVYSCALE		0x9898002c
#define SDC_CMD_SETTVYSCALE		0x9898002d
#define SDC_CMD_GETSCREENSIZE		0x9898002e
#define SDC_CMD_GETGAMMABRIGHTNESS	0x9898002f
#define SDC_CMD_SETGAMMABRIGHTNESS	0x98980030
#define SDC_CMD_GETGAMMABRIGHTNESS2	0x98980031
#define SDC_CMD_SETGAMMABRIGHTNESS2	0x98980032
#define SDC_CMD_GETGETGAMMACRT2		0x98980033
#define SDC_CMD_SETGETGAMMACRT2		0x98980034
#define SDC_CMD_GETHWCURSORSTATUS	0x98980035
#define SDC_CMD_SETHWCURSORSTATUS	0x98980036
#define SDC_CMD_GETPANELMODE		0x98980037
#define SDC_CMD_SETPANELMODE		0x98980038
#define SDC_CMD_GETMERGEDMODEDETAILS	0x98980039
#define SDC_CMD_GETDEVICENAME		0x9898003a
#define SDC_CMD_GETMONITORNAME		0x9898003b
#define SDC_CMD_GETDEVICENAME2		0x9898003c
#define SDC_CMD_GETMONITORNAME2		0x9898003d
#define SDC_CMD_SETXVBRIGHTNESS		0x9898003e
#define SDC_CMD_GETXVBRIGHTNESS		0x9898003f
#define SDC_CMD_SETXVCONTRAST		0x98980040
#define SDC_CMD_GETXVCONTRAST		0x98980041
#define SDC_CMD_SETXVHUE		0x98980042
#define SDC_CMD_GETXVHUE		0x98980043
#define SDC_CMD_SETXVSATURATION		0x98980044
#define SDC_CMD_GETXVSATURATION		0x98980045
#define SDC_CMD_SETXVGAMMA		0x98980046
#define SDC_CMD_GETXVGAMMA		0x98980047
#define SDC_CMD_SETXVCOLORKEY		0x98980048
#define SDC_CMD_GETXVCOLORKEY		0x98980049
#define SDC_CMD_SETXVAUTOPAINTCOLORKEY	0x9898004a
#define SDC_CMD_GETXVAUTOPAINTCOLORKEY	0x9898004b
#define SDC_CMD_SETXVDEFAULTS		0x9898004c
#define SDC_CMD_SETXVDISABLEGFX		0x9898004d
#define SDC_CMD_GETXVDISABLEGFX		0x9898004e
#define SDC_CMD_SETXVDISABLEGFXLR	0x9898004f
#define SDC_CMD_GETXVDISABLEGFXLR	0x98980050
#define SDC_CMD_SETXVSWITCHCRT		0x98980051
#define SDC_CMD_GETXVSWITCHCRT		0x98980052
#define SDC_CMD_GETTVXPOS		0x98980053
#define SDC_CMD_SETTVXPOS		0x98980054
#define SDC_CMD_GETTVYPOS		0x98980055
#define SDC_CMD_SETTVYPOS		0x98980056
#define SDC_CMD_SETXVDEINT		0x98980057
#define SDC_CMD_GETXVDEINT		0x98980058
#define SDC_CMD_GETMONGAMMACRT1		0x98980059
#define SDC_CMD_GETMONGAMMACRT2		0x9898005a
#define SDC_CMD_LOGQUIET		0x9898005b
#define SDC_CMD_GETNEWGAMMABRICON	0x9898005c
#define SDC_CMD_SETNEWGAMMABRICON	0x9898005d
#define SDC_CMD_GETNEWGAMMABRICON2	0x9898005e
#define SDC_CMD_SETNEWGAMMABRICON2	0x9898005f
#define SDC_CMD_GETGETNEWGAMMACRT2	0x98980060
#define SDC_CMD_SETGETNEWGAMMACRT2	0x98980061
#define SDC_CMD_NEWSETVBFLAGS		0x98980062
#define SDC_CMD_GETCRT1SATGAIN		0x98980063
#define SDC_CMD_SETCRT1SATGAIN		0x98980064
#define SDC_CMD_GETCRT2SATGAIN		0x98980065
#define SDC_CMD_SETCRT2SATGAIN		0x98980066
#define SDC_CMD_REDETECTCRT1DEVICES	0x98980067
#define SDC_CMD_RESETCRT1STATUS		0x98980068
/* more to come, adapt MAXCOMMAND! */
#define SDC_MAXCOMMAND			SDC_CMD_RESETCRT1STATUS

/* in result_header */
#define SDC_RESULT_OK  			0x66670000
#define SDC_RESULT_UNDEFCMD		0x66670001
#define SDC_RESULT_NOPERM		0x66670002
#define SDC_RESULT_INVAL		0x66670003
#define SDC_RESULT_MESSAGEERROR		0x66670004
#define SDC_RESULT_NOEXTENSION		0x66670005

/* For SDC_CMD_GETHWINFO */
#define SDC_BUS_TYPE_PCI		0
#define SDC_BUS_TYPE_AGP		1
#define SDC_BUS_TYPE_PCIE		2
#define SDC_BUS_TYPE_USB		3

/* For SDC_CMD_GETMERGEDMODEDETAILS */
#define SDC_MMODE_POS_ERROR		0
#define SDC_MMODE_POS_LEFTOF		1
#define SDC_MMODE_POS_RIGHTOF		2
#define SDC_MMODE_POS_ABOVE		3
#define SDC_MMODE_POS_BELOW		4
#define SDC_MMODE_POS_CLONE		5

/* Argument to SiSCtrlCommand() */
typedef struct {
    CARD32 	sdc_id;
    CARD32 	sdc_chksum;
    CARD32	sdc_command;
    CARD32	sdc_parm[SDC_NUM_PARM_RESULT];
    CARD32	sdc_result_header;
    CARD32	sdc_result[SDC_NUM_PARM_RESULT];
    char	sdc_buffer[32];
} sisctrlcommand;

_XFUNCPROTOBEGIN

Bool SiSCtrlQueryVersion(
    Display *		/* dpy */,
    int *		/* majorVersion */,
    int *		/* minorVersion */
);

Bool SiSCtrlQueryExtension(
    Display *		/* dpy */,
    int *		/* event_base */,
    int *		/* error_base */
);

int SiSCtrlGetMaxScreens();

Bool SiSCtrlCommand(
    Display *		/* dpy */,
    int			/* screen */,
    sisctrlcommand *	/* command */
);

_XFUNCPROTOEND

#endif

