#ifndef __UADDR_H__
#define __UADDR_H__

#include <sys/param.h>

#define UADDR_NICK_SIZE 64
#define UADDR_DL 96

#define MAX_UADDR_PING 6
#define DELAY_BETWEEN_PING 30

typedef struct
{
	unsigned char slot_status;			/* if ==0, the slot is empty */
												/* if ==1, the slot is busy */
	char nick[UADDR_NICK_SIZE];		/* user nickname */
	char dl_addr[UADDR_DL];				/* remote user addr */
	time_t register_time;				/* date when this entry has been created */
	unsigned int ping_counter;			/* number of time the ping command has been sent */
} UADDR_ENTRY;

/******************************************************************************/
/* to reduce duplicated code, the DCTC being the clock master is also the one */
/* performing UADDR action                                                    */
/******************************************************************************/
void create_uaddr_thread(void);

/********************************/
/* perform UADDR initialisation */
/********************************/
void init_uaddr(void);

/*************/
/* end UADDR */
/*************/
void exit_uaddr(void);

/**********************************************************/
/* the following function adds an entry to the UADDR file */
/**********************************************************/
/* nick is always uniq in the database */
/***************************************/
/* output: 0= ok    */
/*         1= error */
/********************/
int add_uaddr_entry(const char *nickname, const char *dl_addr);

/**********************************************************/
/* the following function adds an entry to the UADDR file */
/**********************************************************/
/* addr_dl is always uniq in the database */
/******************************************/
/* output: 0= ok    */
/*         1= error */
/********************/
int add_uaddr_entry_addr_dl_only(const char *addr_dl);

/*************************************************************/
/* the following functions remove an entry to the UADDR file */
/*************************************************************/
void delete_uaddr_entry_by_name(const char *nickname);
void delete_uaddr_entry_by_addr(const char *dl_addr);

/**********************************************************/
/* check if the given nickname has a known remote address */
/**********************************************************/
/* output: 1=yes, 0=no */
/***********************/
int check_uaddr_entry_by_name(const char *nickname);

/************************************************/
/* get the remote address of the given nickname */
/*********************************************************************************/
/* output: NULL (not found) or a GString (host:port) to free when no more useful */
/*********************************************************************************/
GString *get_uaddr_dl_addr_by_name(const char *nickname);


/*****************************************************************************/
/* this function scans the UADDR files and looks if there is something to do */
/*****************************************************************************/
/* this function must be called regularly */
/******************************************/
void uaddr_action();

/*******************************************/
/* output UADDR content into CMD_KB format */
/*******************************************/
void list_uaddr_content(void);

#endif
