/*
 *  Copyright (C) 2006  MakeHuman Project
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *  
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *  
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 *  File   : ImageSysListener.cpp
 *  Project: MakeHuman <info@makehuman.org>, http://www.makehuman.org/
 *  Library: MHGUI
 *
 *  For individual developers look into the AUTHORS file.
 *   
 */

#include "../include/mhgui/ImageSysListener.h"
#include "../include/mhgui/CGUtilities.h"
#include "../include/mhgui/Image.h"

#include <cstdio>
#include <cassert>

#ifdef __APPLE__
  #include <GLUT/glut.h>
#else
  #ifdef USE_FREEGLUT     
    #include <GL/freeglut.h>
  #else
    #include <GL/glut.h>
  #endif
#endif

#include <iostream>

using namespace Animorph;
using namespace std;

namespace mhgui {

ImageSysListener::ImageSysListener()
    : AbstractListener()
{
}

ImageSysListener::~ImageSysListener()
{
}

bool ImageSysListener::mouseOver (const Point& inMousePos, Component *source)
{
  cgutils::redisplay();

  return false;
}

bool ImageSysListener::mouseOut (const Point& inMousePos, Component *source)
{
  cgutils::redisplay();

  return false;
}

bool ImageSysListener::mouseDragged (const Point& inMousePos, Component *source)
{
  return false;
}

bool ImageSysListener::mousePressed(const Point& inMousePos, int button, Component *source)
{
  Image *imgSource = dynamic_cast<Image *>(source); // req. RTTI!
  assert(imgSource); // Check if this is really an Image object?

  imgSource->setActive(true);
  imgSource->setClickConsumed(false);

  return false;
}

bool ImageSysListener::mouseReleased (const Point& inMousePos, int button, Component *source)
{
  Image *imgSource = dynamic_cast<Image *>(source); // req. RTTI!
  assert(imgSource); // Check if this is really an Image object?

  imgSource->setActive(false);
  imgSource->setClickConsumed(false);

  return false;
}

bool ImageSysListener::keyType (unsigned char key, Component *source)
{
  return false;
}
} // namespace mhgui
