% COTH  COTH Hyperbolic Cotangent Function
% 
% 
% Usage
%  
%  Computes the hyperbolic cotangent of the argument.
%  The syntax for its use is
%  
%     y = coth(x)
%  
%  

function y = coth(x)
  if (nargin == 0 || ~isnumeric(x))
    error('coth expects a numeric input');
  end
  y = 1.0f./tanh(x);
  
