% ASECH  ASECH Inverse Hyperbolic Secant Function
% 
% 
% Usage
%  
%  Computes the inverse hyperbolic secant of its argument.  The general
%  syntax for its use is
%  
%    y = asech(x)
%  
%  where x is an n-dimensional array of numerical type.
%  


function y = asech(x)
  if (nargin == 0 || ~isnumeric(x))
    error('asech expects a single, numeric input');
  end
  y = acosh(1.f./x);
  
