<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 1730 $
 * $Id: calcExceptions.php 1730 2008-02-17 20:28:09Z ipso $
 * $Date: 2008-02-17 12:28:09 -0800 (Sun, 17 Feb 2008) $
 */
/*
 * Calculate Exceptions for the previous day. This helps especially for
 * the "Unscheuled Absence" exception.
 *
 * Run this once a day. AFTER AddUserDate
 */
require_once( dirname(__FILE__) . DIRECTORY_SEPARATOR .'..'. DIRECTORY_SEPARATOR .'includes'. DIRECTORY_SEPARATOR .'global.inc.php');
require_once( dirname(__FILE__) . DIRECTORY_SEPARATOR .'..'. DIRECTORY_SEPARATOR .'includes'. DIRECTORY_SEPARATOR .'CLI.inc.php');

//Two days ago.
$date = TTDate::getMiddleDayEpoch( time() ) - (86400*2);
//$date = TTDate::getBeginDayEpoch( time() );

$udlf = new UserDateListFactory();
$udlf->getByDate( $date );
if ( $udlf->getRecordCount() > 0 ) {
	$i=0;
	foreach ($udlf as $ud_obj) {
		Debug::text($i .'. User: '. $ud_obj->getUser() .' Date: '. TTDate::getDate('DATE+TIME', $ud_obj->getDateStamp() ) .' User Date ID: '. $ud_obj->getId() , __FILE__, __LINE__, __METHOD__,10);

		//ExceptionPolicyFactory::calcExceptions( $ud_obj->getId() );

		//Recalculate system time, and exceptions for the day.
		//Because if its a Monday, it will also recalculate the rest of the days in the week.
		//Shouldn't be a big deal though.
		//This isn't needed, since we now do it in AddRecurringScheduleShift, so dock time is
		//applied at the beginning of the day.
		//The problem is that AddRecurringScheduleShift does it, then for the entire day someone with
		//a dock policy shows up as dock time. Some users have complained about this a few times.

		//Reason for doing two days ago is that if someone starts a shift at 11pm, but doesn't end it in
		//time, it still needs to be re-calculated a day later.
		//Could maybe get around this by getting all punches of yesterday, and getting their date_ids
		//and just recalculating those.
		UserDateTotalFactory::reCalculateDay( $ud_obj->getId(), TRUE );

		$i++;
	}
}

//One day ago
$date = TTDate::getMiddleDayEpoch( time() ) - (86400);

$udlf = new UserDateListFactory();
$udlf->getByDate( $date );
if ( $udlf->getRecordCount() > 0 ) {
	$i=0;
	foreach ($udlf as $ud_obj) {
		Debug::text($i .'. User: '. $ud_obj->getUser() .' Date: '. TTDate::getDate('DATE+TIME', $ud_obj->getDateStamp() ) .' User Date ID: '. $ud_obj->getId(), __FILE__, __LINE__, __METHOD__,10);

		//ExceptionPolicyFactory::calcExceptions( $ud_obj->getId() );
		UserDateTotalFactory::reCalculateDay( $ud_obj->getId(), TRUE, TRUE );

		$i++;
	}
}
Debug::writeToLog();
Debug::Display();
?>