<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 1835 $
 * $Id: About.php 1835 2008-04-29 21:15:06Z ipso $
 * $Date: 2008-04-29 14:15:06 -0700 (Tue, 29 Apr 2008) $
 */
require_once('../../includes/global.inc.php');
require_once(Environment::getBasePath() .'includes/Interface.inc.php');

//Debug::setVerbosity( 11 );

$smarty->assign('title', TTi18n::gettext($title = 'About')); // See index.php
BreadCrumb::setCrumb($title);

/*
 * Get FORM variables
 */
extract	(FormVariables::GetVariables(
										array	(
												'action',
												'ytd',
												) ) );

$data = $system_settings;

$action = Misc::findSubmitButton();
switch ($action) {
	case 'university':
		//Debug::setVerbosity( 11 );
		Debug::Text('Redirect to Online University!', __FILE__, __LINE__, __METHOD__,10);

		//Generate encoded data as well.
		$encoded_data = NULL;
		if ( is_object( $current_company ) AND is_object( $current_user ) ) {
			//If for some reason the registration key isn't set, generate a random one now.
			if ( isset($system_settings) AND ( !isset($system_settings['registration_key']) OR $system_settings['registration_key'] == '') ) {
				$sslf->setName('registration_key');
				$sslf->setValue( md5( uniqid() ) );
				if ( $sslf->isValid() == TRUE ) {
					$sslf->Save();
				}
			}

			//Get permissions of current user so we can show them the proper courses.
			$pf = new PermissionFactory();
			$permission_sections = $pf->getOptions('section');
			foreach( $permission_sections as $section => $name ) {
				$permission_arr[$section] = $permission->Check( $section, 'enabled');
			}
			$encoded_data = array( 'company_name' => $current_company->getName(), 'product_edition' => $current_company->getProductEdition(), 'version' => $system_settings['system_version'], 'registration_key' => $system_settings['registration_key'], 'first_name' => $current_user->getFirstName(), 'last_name' => $current_user->getLastName(), 'work_email' => $current_user->getWorkEmail(), 'permissions' => $permission_arr );
			$encoded_data = urlencode( base64_encode( gzdeflate( serialize( $encoded_data ) ) ) );
			//Debug::Text(' Encoded Data ('.strlen($encoded_data).'): '. $encoded_data, __FILE__, __LINE__, __METHOD__,10);
		}
		Redirect::Page( URLBuilder::getURL( array('data' => $encoded_data ), 'https://www.timetrex.com/university.php') );
		exit;

		break;
	case 'check_for_updates':
		Debug::Text('Check For Update!', __FILE__, __LINE__, __METHOD__,10);

		$ttsc = new TimeTrexSoapClient();

		//We must ensure that the data is up to date
		//Otherwise version check will fail.
		$ttsc->sendCompanyData( $current_company->getId(), TRUE );
		$ttsc->sendCompanyUserLocationData( $current_company->getId() );
		$ttsc->sendCompanyUserCountData( $current_company->getId() );
		$ttsc->sendCompanyVersionData( $current_company->getId() );

		$latest_version = $ttsc->isLatestVersion( $current_company->getId() );
		$latest_tax_engine_version = $ttsc->isLatestTaxEngineVersion( $current_company->getId() );
		$latest_tax_data_version = $ttsc->isLatestTaxDataVersion( $current_company->getId() );

		$sslf = new SystemSettingListFactory();
		$sslf->getByName('new_version');
		if ( $sslf->getRecordCount() == 1 ) {
			$obj = $sslf->getCurrent();
		} else {
			$obj = new SystemSettingListFactory();
		}
		$obj->setName( 'new_version' );

		if( $latest_version == FALSE
				OR $latest_tax_engine_version == FALSE
				OR $latest_tax_data_version == FALSE ) {
			$obj->setValue( 1 );
			$data['new_version'] = 1;
		} else {
			$obj->setValue( 0 );
			$data['new_version'] = 0;
		}

		if ( $obj->isValid() ) {
			$obj->Save();
		}
	default:
		$data['product_edition'] = Option::getByKey( getTTProductEdition(), $current_company->getOptions('product_edition') );

		//Get Employee counts for this month, and last month
		$month_of_year_arr = TTDate::getMonthOfYearArray();

		//This month
		if ( isset($ytd) AND $ytd == 1 ) {
			$begin_month_epoch = strtotime( '-2 years' );
		} else {
			$begin_month_epoch = TTDate::getBeginMonthEpoch(TTDate::getBeginMonthEpoch(time())-86400);
		}

		$cuclf = new CompanyUserCountListFactory();
		$cuclf->getMonthlyMinAvgMaxByCompanyIdAndStartDateAndEndDate( $current_company->getId(), $begin_month_epoch, TTDate::getEndMonthEpoch( time() ), NULL, NULL, NULL, array('date_stamp' => 'desc') );
		if ( $cuclf->getRecordCount() > 0 ) {
			foreach( $cuclf as $cuc_obj ) {
				$data['user_counts'][] = array(
																//'label' => $month_of_year_arr[TTDate::getMonth( $begin_month_epoch )] .' '. TTDate::getYear($begin_month_epoch),
																'label' => $month_of_year_arr[TTDate::getMonth( TTDate::strtotime( $cuc_obj->getColumn('date_stamp') ) )] .' '. TTDate::getYear( TTDate::strtotime( $cuc_obj->getColumn('date_stamp') ) ),
																'max_active_users' => $cuc_obj->getColumn('max_active_users'),
																'max_inactive_users' => $cuc_obj->getColumn('max_inactive_users'),
																'max_deleted_users' => $cuc_obj->getColumn('max_deleted_users'),
																);
			}
		}

		$cjlf = new CronJobListFactory();
		$cjlf->getMostRecentlyRun();
		if ( $cjlf->getRecordCount() > 0 ) {
			$cj_obj = $cjlf->getCurrent();
			$data['cron'] = array(
								'last_run_date' => $cj_obj->getLastRunDate()
								);
		}

		if ( ( $current_company->getId() == 1 OR ( isset($config_vars['other']['primary_company_id']) AND $current_company->getId() == $config_vars['other']['primary_company_id'] ) ) AND getTTProductEdition() > 10 ) {
			if ( !isset($system_settings['license']) ) {
				$system_settings['license'] = NULL;
			}

			//Set this so the license upload area at least shows up regardles of edition.
			$data['license_data'] = array();

			$license = new TTLicense();
			$retval = $license->validateLicense( $system_settings['license'] );
			if ( $retval == TRUE ) {
				$data['license_data'] = array(
										'organization_name' => $license->getOrganizationName(),
										'major_version' => $license->getMajorVersion(),
										'minor_version' => $license->getMinorVersion(),
										'product_name' => $license->getProductName(),
										'active_employee_licenses' => $license->getActiveEmployeeLicenses(),
										'issue_date' => TTDate::getDate('DATE', $license->getIssueDate() ),
										'expire_date' => $license->getExpireDate(),
										'expire_date_display' => TTDate::getDate('DATE', $license->getExpireDate() ),
										'registration_key' => $license->getRegistrationKey(),
										'message' => $license->getFullErrorMessage( $retval ),
										'retval' => $retval,
										);
			}
		}
}

//var_dump($data);
$smarty->assign_by_ref('data', $data);

$smarty->display('help/About.tpl');
?>