<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 797 $
 * $Id: UserGenericStatusFactory.class.php 797 2007-04-25 17:51:14Z ipso $
 * $Date: 2007-04-25 10:51:14 -0700 (Wed, 25 Apr 2007) $
 */
class UserGenericStatusFactory extends Factory {
	protected $table = 'user_generic_status';
	protected $pk_sequence_name = 'user_generic_status_id_seq'; //PK Sequence name
	protected $batch_sequence_name = 'user_generic_status_batch_id_seq'; //PK Sequence name

	protected $batch_id = NULL;
	protected $queue = NULL;
	static protected $static_queue = NULL;


	function _getFactoryOptions( $name ) {

		$retval = NULL;
		switch( $name ) {
			case 'status':
				$retval = array(
										10 => TTi18n::gettext('Failed'),
										20 => TTi18n::gettext('Warning'),
										30 => TTi18n::gettext('Success'),
									);
				break;

		}

		return $retval;
	}


	function getUser() {
		if ( isset($this->data['user_id']) ) {
			return $this->data['user_id'];
		}

		return FALSE;
	}
	function setUser($id) {
		$id = trim($id);

		$ulf = new UserListFactory();

		if ( $this->Validator->isResultSetWithRows(	'user',
															$ulf->getByID($id),
															TTi18n::gettext('Invalid User')
															) ) {
			$this->data['user_id'] = $id;

			return TRUE;
		}

		return FALSE;
	}

	function getNextBatchID() {
		$this->batch_id = $this->db->GenID( $this->batch_sequence_name );

		return $this->batch_id;
	}
	function getBatchID() {
		if ( isset($this->data['batch_id']) ) {
			return $this->data['batch_id'];
		}

		return FALSE;
	}
	function setBatchID($val) {
		$val = trim($val);
		if (	$this->Validator->isNumeric(	'batch_id',
												$val,
												TTi18n::gettext('Invalid Batch ID') )
						) {

			$this->data['batch_id'] = $val;

			return TRUE;
		}

		return FALSE;
	}

	function getStatus() {
		if ( isset($this->data['status_id']) ) {
			return (int)$this->data['status_id'];
		}

		return FALSE;
	}
	function setStatus($status) {
		$status = trim($status);

		$key = Option::getByValue($status, $this->getOptions('status') );
		if ($key !== FALSE) {
			$status = $key;
		}

		if ( $this->Validator->inArrayKey(	'status',
											$status,
											TTi18n::gettext('Incorrect Status'),
											$this->getOptions('status')) ) {

			$this->data['status_id'] = $status;

			return FALSE;
		}

		return FALSE;
	}

	function getLabel() {
		if ( isset($this->data['label']) ) {
			return $this->data['label'];
		}

		return FALSE;
	}
	function setLabel($val) {
		$val = trim($val);
		if (	$this->Validator->isLength(	'label',
											$val,
											TTi18n::gettext('Invalid label'),
											1,1024)
						) {

			$this->data['label'] = $val;

			return TRUE;
		}

		return FALSE;
	}

	function getDescription() {
		if ( isset($this->data['description']) ) {
			return $this->data['description'];
		}

		return FALSE;
	}
	function setDescription($val) {
		$val = trim($val);
		if (	$val == ''
				OR
				$this->Validator->isLength(	'description',
											$val,
											TTi18n::gettext('Invalid description'),
											1,1024)
						) {

			$this->data['description'] = $val;

			return TRUE;
		}

		return FALSE;
	}

	function getLink() {
		if ( isset($this->data['link']) ) {
			return $this->data['link'];
		}

		return FALSE;
	}
	function setLink($val) {
		$val = trim($val);
		if (	$val == ''
				OR
				$this->Validator->isLength(	'link',
											$val,
											TTi18n::gettext('Invalid link'),
											1,1024)
						) {

			$this->data['link'] = $val;

			return TRUE;
		}

		return FALSE;
	}

	//Static Queue functions
	static function getStaticQueue() {
		return self::$static_queue;
	}
	static function clearStaticQueue() {
		self::$static_queue = NULL;

		return TRUE;
	}
	static function queueGenericStatus($label, $status, $description = NULL, $link = NULL ) {
		Debug::Text('Add Generic Status row to queue... Label: '. $label .' Status: '. $status, __FILE__, __LINE__, __METHOD__,10);
		$arr = array(
					'label' => $label,
					'status' => $status,
					'description' => $description,
					'link' => $link
					);

		self::$static_queue[] = $arr;

		return TRUE;
	}


	//Non-Static Queue functions
	function setQueue( $queue ) {
		$this->queue = $queue;

		UserGenericStatusFactory::clearStaticQueue();

		return TRUE;
	}

	function saveQueue() {
		if ( is_array($this->queue) ) {
			Debug::Arr($this->queue, 'Generic Status Queue', __FILE__, __LINE__, __METHOD__,10);
			foreach( $this->queue as $key => $queue_data ) {

				$ugsf = new UserGenericStatusFactory();
				$ugsf->setUser( $this->getUser() );
				if ( $this->getBatchId() !== FALSE ) {
					$ugsf->setBatchID( $this->getBatchID() );
				} else {
					$this->setBatchId( $this->getNextBatchId() );
				}

				$ugsf->setLabel( $queue_data['label'] );
				$ugsf->setStatus( $queue_data['status'] );
				$ugsf->setDescription( $queue_data['description'] );
				$ugsf->setLink( $queue_data['link'] );

				if ( $ugsf->isValid() ) {
					$ugsf->Save();

					unset($this->queue[$key]);
				}
			}

			return TRUE;
		}

		Debug::Text('Generic Status Queue Empty', __FILE__, __LINE__, __METHOD__,10);
		return FALSE;
	}

	/*
	function addGenericStatus($label, $status, $description = NULL, $link = NULL ) {
		$this->setLabel( $label );
		$this->setStatus( $status );
		$this->setDescription( $description );
		$this->setLink( $link );

		$batch_id = $this->getBatchId();
		$user_id = $this->getUser();

		if ( $this->isValid() ) {
			$this->Save();

			$this->setBatchId( $batch_id );
			$this->setUser( $user_id );

			return TRUE;
		}

		return FALSE;
	}
	*/

	function preSave() {
		return TRUE;
	}
}
?>
