[comment {-*- tcl -*- doctools manpage}]
[manpage_begin doctools_api n 1.0]
[copyright {2002-2004 Andreas Kupries <andreas_kupries@users.sourceforge.net>}]
[moddesc   {Documentation tools}]
[titledesc {Specification of the Interface to Doctools Formatting Engines}]
[description]
[para]

This document specifies version 1 of the interface a doctools
formatting engine has to comply with to be usable by the package
[package doctools].

The specification of the [term doctools] format all doctools
formatting engines have to process can be found in the companion
document [term doctools_fmt].

[section API]

[subsection {EXPORTED COMMANDS}]

Each doctools formatting engine has to provide a number of commands
through which objects created by the package [package doctools] will
upon the functionality of the engine. These commands are described
here.

[list_begin definitions]
[lst_item [emph {Management commands}]]

[list_begin definitions]

[call [cmd fmt_numpasses]]

This command is called by a doctools object immediately after it has
loaded the engine. No other command of the engine will be called
before it. It has to return the number of passes this engine requires
to fully process the input document. This value has to be an integer
number greater or equal to one.


[call [cmd fmt_initialize]]

This command is called at the beginning of every conversion run, as
the first command of that run. Note that a run is not a pass, but may
consist of multiple passes. See [cmd fmt_numpasses]. The command has
to initialize the general state of the doctools formatting engine,
beyond the initialization done during the load.


[call [cmd fmt_setup] [arg n]]

This command is called at the beginning of each pass over the input in
a run. Its argument is the number of the pass which has begun. Passes
are counted from [const 1] upward. The command has to set up the
internal state of the doctools formatting engine for this particular
pass.


[call [cmd fmt_postprocess] [arg text]]

This command is called immediately after the last pass in a run. Its
argument is the result of the conversion generated by that pass. It is
provided to allow the engine to perform any global last-ditch
modifications of the generated document. The text returned by this
command will be the final result of the conversion.

[nl]

An engine for a format which requires no postprocessing can simply
return the argument without change.


[call [cmd fmt_shutdown]]

This command is called at the end of every conversion run. It is the
last command called in a run. It has to clean up of all the
run-specific state in the doctools formatting engine. After the call
the engine has to be in a state which allows the initiation of another
run without fear that information from the last run is leaked into
this new run.


[call [cmd fmt_listvariables]]

This command is called by a doctools object after it has loaded the
engine (after [cmd fmt_numpasses]). It has to return a list containing
the names of the engine parameters provided by the engine. This list
can be empty.


[call [cmd fmt_varset] [arg varname] [arg text]]

This command is called whenever the doctools object wishes to set an
engine parameter to a particular value. The parameter to change is
specified by [arg varname], the value to set in [arg text].

[nl]

The command has to throw an error if an unknown [arg varname] is
used. Only the names returned by [cmd fmt_listvariables] are
considered known.

[nl]

The values of all engine parameters have to persist between passes and
runs.

[list_end]


[lst_item [emph {Formatting commands}]]

The commands listed in this section are responsible for the conversion
of the input into the wanted output.

Their names are the names of the associated markup command, with
prefix [const fmt_] added to them.

Not all markup commands have associated formatting commands. The two
exceptions are [cmd vset] and [cmd include]. These markup commands are
processed by the doctools object itself.

[nl]

A detailed documentation of the markup commands can be found in the
companion document [term doctools_fmt]. It is the formal specification
of the [term doctools] format.

[nl]

[emph Note]: The formatting commands can expect that they are only
called in an order allowed by the format specification.


[list_begin definitions]

[call [cmd fmt_plain_text] [arg text]]

This command has no associated markup command. It is called for any
plain text encountered by the processor in the input. It has to
perform any special processing required for plain text. The text
returned as its result is added to the output. If no special
processing is required it has to simply return its argument without
change.


[call [cmd fmt_comment] [arg text]]

This command has to format the [arg text] as a comment and return the
formatted string. It has to return the empty string if the output
format has no way of formatting comments.


[call [cmd fmt_manpage_begin] [arg command] [arg section] [arg version]]

This command has to format the [arg command] name, the [arg section]
the manpage resides in, and the [arg version] of the module as the
start of the generated manpage and return the formatted string.


[call [cmd fmt_manpage_end]]

This command has to generate the end of the generated manpage and
return the formatted string.


[call [cmd fmt_moddesc] [arg desc]]

This command remembers its argument [arg desc] as a short description
of the module the manpage resides in. It may or may not return a
formatted string.


[call [cmd fmt_titledesc] [arg desc]]

This command remembers its argument [arg desc] as the title of the
manpage. It may or may not return a formatted string. If this command
was omitted the argument of [cmd moddesc] has to be be used for the
title as well.


[call [cmd fmt_copyright] [arg text]]

This command remembers its argument [arg text] as declaration of a
copyright assignment for the manpage. When invoked more than once the
assignments have to be accumulated. It may or may not return a
formatted string.

[nl]

Assignments provided by this command have priority over information
supplied by an doctools processing application.


[call [cmd fmt_description]]

This command separates the header part of the manpage from the main
body. It may or may not return a formatted string.


[call [cmd fmt_require] [arg pkg] [opt [arg version]]]

This command remembers its arguments as name and version of a package
which is required by an application or other library to use the
described package. It may or may not return a formatted string.


[call [cmd fmt_section] [arg name]]

This command partitions the body of the manpage into named
sections. Note that the command [cmd description] at the beginning of
the manpage body implicitly started a section named "DESCRIPTION". A
section command has to close the last [cmd para]graph coming before it
and also open the first paragraph of the new section. It may or may
not return a formatted string.


[call [cmd fmt_subsection] [arg name]]

This command partitions the body of a [term section] into named
sub-sections.

A subsection command has to close the last [cmd para]graph coming
before it and also opens the first paragraph of the new section.  It
may or may not return a formatted string.


[call [cmd fmt_para]]

This command partitions the text in a section or sub-section into
paragraphs. Each invokation has to close the paragraph coming before
it and open a new paragraph for the text coming after.  It may or may
not return a formatted string.


[call [cmd fmt_see_also] [arg args]]

This command defines direct cross-references to other documents. Each
argument is a label identifying the referenced document. If this
command is used multiple times all the arguments have to accumulate.
It may or may not return a formatted string.


[call [cmd fmt_keywords] [arg args]]

This command defines the keywords applying to this document. Each
argument is a single keyword. If this command is used multiple times
all the arguments have to accumulate.  It may or may not return a
formatted string.


[call [cmd fmt_arg] [arg text]]

This command declares that the argument [arg text] is the name of a
command argument.  It has to return a formatted string.


[call [cmd fmt_cmd] [arg text]]

This command declares that the argument [arg text] is the name of a
command.  It has to return a formatted string.


[call [cmd fmt_opt] [arg text]]

This command declares that the argument [arg text] is something
optional. It has to return a formatted string.


[call [cmd fmt_emph] [arg text]]

This command emphasizes the [arg text].  It has to return a formatted
string.


[call [cmd fmt_strong] [arg text]]

This command emphasizes the [arg text]. Same as [cmd emph]. Usage of
this command is discouraged. The command is deprecated and present
only for backward compatibility.  It has to return a formatted string.


[call [cmd fmt_sectref] [arg text] [opt [arg label]]]

This command declares that the argument [arg text] is the name of a
section somewhere else in the document, and the current location
should refer to it.  It has to return a formatted string.

If a [arg label] is specified then it has to be used in the returned
text. Otherwise the section title [arg text] is used.


[call [cmd fmt_syscmd] [arg text]]

This command declares that the argument [arg text] is the name of a
system command.  It has to return a formatted string.


[call [cmd fmt_method] [arg text]]

This command declares that the argument [arg text] is the name of an
object method.  It has to return a formatted string.


[call [cmd fmt_namespace] [arg text]]

This command declares that the argument [arg text] is the name of a
namespace.  It has to return a formatted string.


[call [cmd fmt_option] [arg text]]

This command declares that the argument [arg text] is the name of an
option.  It has to return a formatted string.


[call [cmd fmt_widget] [arg text]]

This command declares that the argument [arg text] is the name of a
widget.  It has to return a formatted string.


[call [cmd fmt_fun] [arg text]]

This command declares that the argument [arg text] is the name of a
function.  It has to return a formatted string.


[call [cmd fmt_type] [arg text]]

This command declares that the argument [arg text] is the name of a
data type.  It has to return a formatted string.


[call [cmd fmt_package] [arg text]]

This command declares that the argument [arg text] is the name of a
package.  It has to return a formatted string.


[call [cmd fmt_class] [arg text]]

This command declares that the argument [arg text] is the name of a
class.  It has to return a formatted string.


[call [cmd fmt_var] [arg text]]

This command declares that the argument [arg text] is the name of a
variable.  It has to return a formatted string.


[call [cmd fmt_file] [arg text]]

This command declares that the argument [arg text] is a file.  It has
to return a formatted string.


[call [cmd fmt_uri] [arg text] [opt [arg text]]]

This command declares that the argument [arg text] is an uri. The
second argument, if it is present, is the human-readable description
of the uri. In other words, the label for the link. Without a labeling
text the uri is used as its own label.  It has to return a formatted
string.


[call [cmd fmt_term] [arg text]]

This command declares that the argument [arg text] contains some
unspecific terminology.  It has to return a formatted string.


[call [cmd fmt_const] [arg text]]

This command declares that the argument [arg text] is a constant
value.  It has to return a formatted string.


[call [cmd fmt_nl]]

This command signals vertical space to separate blocks of text.  It
may or may not return a formatted string.

[comment {
    FUTURE: This is the same as para, but restricted to use inside of
    list elements. Whereas para's are restricted to usage outside list
    elements. Given that both do the same this separation is stupid.
    Doctools V2 will have only one command, 'para', useable everywhere.
    The formatting engine has to switch outputs, if truly necessary.
}]


[call [cmd fmt_example_begin]] 

This command begins an example block. Subsequent text belongs to the
example. Line breaks, spaces, and tabs have to be preserved literally.
It may or may not return a formatted string.


[call [cmd fmt_example_end]] 

This command closes the example block.  It may or may not return a
formatted string.


[call [cmd fmt_list_begin] [arg what]]

This command starts new list. The value of the argument [arg what]
determines what type of list is opened. This also defines what command
has to be used to start an item in the new list. The allowed types
(and their associated item commands) are explained in the format
specification, i.e. [term doctools_fmt].  It may or may not return a
formatted string.


[call [cmd fmt_list_end]]

This command ends the list opened by the last [cmd list_begin].  It
may or may not return a formatted string.


[call [cmd fmt_bullet]]

This command starts a new list item in a bulletted list. The previous
item has to be closed automatically.  It may or may not return a
formatted string.


[call [cmd fmt_enum]]

This command starts a new list item in an enumerated list. The
previous item has to be closed automatically.  It may or may not
return a formatted string.


[call [cmd fmt_lst_item] [arg text]]

This command starts a new list item in a definition list. The argument
is the term to be defined. The previous item has to be closed
automatically.  It may or may not return a formatted string.


[call [cmd fmt_call] [arg args]]

This command starts a new list item in a definition list, but the term
defined by it is a command and its arguments. The previous item is
automatically closed. The first argument is the name of the described
command, and everything after that are descriptions of the command
arguments.  It may or may not return a formatted string.


[call [cmd fmt_arg_def] [arg type] [arg name] [opt [arg mode]]]

This command starts a new list item in an argument list. The previous
item has to be closed automatically. Specifies the data-[arg type] of
the described argument, its [arg name] and its i/o-[arg mode]. The
latter is optional.  It may or may not return a formatted string.


[call [cmd fmt_opt_def] [arg name] [opt [arg arg]]]

This command starts a new list item in an option list. The previous
item has to be closed automatically. Specifies the [arg name] of the
option and its arguments ([arg arg]). The latter is a list, and can be
left out.  It may or may not return a formatted string.


[call [cmd fmt_cmd_def] [arg command]]

This command starts a new list item in a command list.  The previous
item has to be closed automatically.

Specifies the name of the [arg command].  It may or may not return a
formatted string.


[call [cmd fmt_tkoption_def] [arg name] [arg dbname] [arg dbclass]]

This command starts a new list item in a widget option list. The
previous item has to be closed automatically.

Specifies the [arg name] of the option, i.e. the name used in scripts,
the name used by the option database ([arg dbname]), and the class
(type) of the option ([arg dbclass]).  It may or may not return a
formatted string.


[call [cmd fmt_usage] [arg args]]

This command is like [cmd call], except that a formatting engine must
not generate output at the location of the command. In other words,
this command is [emph silent]. The data it defines may appear in a
different section of the output, for example a table of contents, or
synopsis, depending on the formatting engine and its output format.
It may or may not return a formatted string.

[list_end]
[list_end]
[para]


[subsection {IMPORTED ENVIRONMENT}]

The implementation of a doctools formatting engine can make the
following assumptions about the environment it is executed in:

[list_begin enum]
[enum]

That it has full access to its own safe interpreter. In other words,
the engine cannot damage the other parts of the processor, nor can it
damage the filesystem.

[enum]

That the following commands are provided by the doctools object
controlling the engine:

[list_begin definitions]
[lst_item {Doctools commands}]

[list_begin definitions]

[call [cmd dt_copyright]]

This command returns a string containing the copyright information the
doctools object was configured with (option [option -copyright]).


[call [cmd dt_file]]

This command returns the full name of the file currently processed by
the engine.


[call [cmd dt_fileid]]

This command returns the name of the file currently processed by the
engine, without path, nor extension.


[call [cmd dt_fmap] [arg symfname]]

This command returns the actual name to use in the output in place of
the symbolic filename [arg symfname]. It will return the unchanged
input if no mapping was found for [arg symfname].


[call [cmd dt_format]]

This command returns the name of the format currently executing.


[call [cmd dt_lnesting]]

This command returns the number of lists currently open.


[call [cmd dt_module]]

This command returns the name of the module the file currently
processed belongs to.


[call [cmd dt_source] [arg file]]

This command allows the doctools formatting engine to load additional
tcl code.

Only files which are either in the same directory as the file
containing the engine, or below it, can be loaded. Trying to load a
file outside of this directory causes an error.


[call [cmd dt_user]]

This command returns the name of the current user as known to the tcl
interpreter the doctools object controlling the engine resides in.

[list_end]


[lst_item "Expander commands"]

All of the commands below are methods of the expander object (without
the prefix [const ex_]) handling the current input. This gives the
engine limited access to the state of the expander.

Their arguments and results are described in the documentation for the
package [package expander].

[list_begin definitions]
[call [cmd ex_cappend]]
[call [cmd ex_cget]]
[call [cmd ex_cis]]
[call [cmd ex_cname]]
[call [cmd ex_cpop]]
[call [cmd ex_cpush]]
[call [cmd ex_cset]]
[call [cmd ex_lb]]
[call [cmd ex_rb]]
[list_end]

[lst_item {Other commands}]

The file [file _common.tcl] contains default implementations
of [cmd fmt_plaint_text] and all the [const fmt_] commands
listed in section [sectref {EXPORTED COMMANDS}].

It resides in the subdirectory [file mpformats] containing all the
predefined formats. This means that all external formats (i.e. not
provided by the package [package doctools]) cannot use it immediately,
but have to have a copy at their location.

Additional commands provided by this file are:

[list_begin definitions]
[call [cmd c_inpass]]

This command returns the id of the pass currently executing.


[call [cmd c_begin]]

This command signals that processing of the text
after [cmd manpage_begin] has begun.


[call [cmd c_begun]]

This command checks the flag set by [cmd c_begin].


[call [cmd c_set_module] [arg text]]

This command remembers [arg text] as module information.


[call [cmd c_get_module]]

This command retrieves the module information
stored by [cmd c_set_module].


[call [cmd c_set_title] [arg text]]

This command remembers [arg text] as title.


[call [cmd c_get_title]]

This command retrieves the title stored by [cmd c_set_title].


[call [cmd c_provenance]]

This command returns a string describing how the input was processed.


[call [cmd c_pass] [arg {pass proc arguments body}]]

This command defines a procedure which is valid when pass [arg pass]
of the engine is executed.


[call [cmd c_holdBuffers] [arg args]]

This command defines one or more buffers for holding data between
passes.


[call [cmd c_hold] [arg {buffer entry}]]

This command adds an entry to the specified buffer.

The buffer has to be defined by an earlier invocation of the command
[cmd c_holdBuffers].


[call [cmd c_held] [arg buffer]]

This command retrieves the contents of the specified buffer. The
buffer is empty afterwards. All entries in the buffer are joined by
newlines.


[call [cmd c_cnext]]

This command increments the counter and return its current value.


[call [cmd c_cinit]]

This command pushes the current counter on the stack and reinitialize
the counter to zero.


[call [cmd c_creset]]

This command reinitializes the counter with the value on the counter
stack and removes that value from the stack.


[call [cmd NOP] [arg args]]

This command does nothing.

It can be used in conjunction with [cmd c_pass] to visibly declare in
which passes a formatting command has nothing to do.


[call [cmd NYI] [opt [arg message]]]

This command throws the error
"[arg message] [const {Not yet implemented}]".


[call [cmd c_sectionId] [arg name]]

This command remembers the name of the section for later
cross-referencing.


[call [cmd c_possibleReference] [arg {text gi}]]

This command checks if a section is available for [arg text]. This
command is currently tuned for use by engines like HTML and TMML.

[list_end]

[list_end]
[list_end]

[see_also doctools_fmt doctools]
[keywords markup {generic markup} manpage document TMML HTML nroff LaTeX]
[manpage_end]
