/* Copyright (C) 2006 P.L. Lucas
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, 
 * Boston, MA 02111-1307, USA. 
 */

#ifndef __EDITOR_H__
#define __EDITOR_H__
#include <QAction>
#include <QToolBar>
#include <QTextEdit>
#include "basewidget.h"
#include "syntax.h"
#include "octave_connection.h"
#include "search_dialog.h"

class Editor: public BaseWidget
{
  Q_OBJECT
 public:
  Editor(QWidget *parent);

  QTextEdit *textEdit;

  void setOctaveConnection(OctaveConnection *octave_connection);
 private:
  QToolBar *toolBar;
  Syntax *syntax;
  QString path;
  OctaveConnection *octave_connection;
  SearchDialog search_dialog;

  // Actions
  QAction *actionOpen, *actionSave, *actionSaveAs, *actionPrint;
  QAction *actionUndo, *actionCut, *actionCopy, *actionPaste;
  QAction *actionSearch, *actionRun;

 public slots:
  void toolbar_action(QAction*);
 void search();
 void replace();
};

#endif
