/* Copyright (C) 2006 P.L. Lucas
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, 
 * Boston, MA 02111-1307, USA. 
 */

#ifndef __VARIABLES_LIST_H__
#define __VARIABLES_LIST_H__

#include <QTextEdit>
#include <QHBoxLayout>
#include <QVBoxLayout>
#include <QPushButton>
#include <QTreeWidget>
#include "octave_connection.h"
#include "basewidget.h"


/** Shows variables list. It uses whos command.
*/

class VariableList:public BaseWidget
{
	Q_OBJECT
	public:
	VariableList( QWidget * parent = 0 );
	void setOctaveConnection(OctaveConnection *octave_connection);
	
	private:
	OctaveConnection *octave_connection;
	QPushButton *reload_button;
	//QTextEdit *text;
	QTreeWidget *tree;
	QTreeWidgetItem *last_root_item, *dynamically_item, *local_item, *currently_item;
	
	public slots:
	void windowActivated ( QWidget * w );
	void windowActivated();
	void send_whos_command_to_octave();
	/**Opens variable table widget*/
	void item_click(QTreeWidgetItem * item, int column);
	
	/** Callback to line_ready signal from OctaveConnection.
	 * @param line line from Octave.
	*/
	void line_ready(QString line);
	
	signals:
	void open_table(QString table_name);
};


#endif
