/* Copyright (C) 2006 P.L. Lucas
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, 
 * Boston, MA 02111-1307, USA. 
 */

#ifndef __SEARCH_DIALOG_H__
#define __SEARCH_DIALOG_H__
#include <QDialog>
#include <QLabel>
#include <QLineEdit>
#include <QCheckBox>
#include <QBoxLayout>
#include <QGroupBox>
#include <QPushButton>
#include "config.h"

class SearchDialog: public QDialog
{
  Q_OBJECT
 private:
  QLineEdit *search, *replace;
  QCheckBox *searchRegExp, *caseSensitiveCB, *wholeWordsCB,
    *fromCursorCB;
 public:
  // Constructor
  SearchDialog(QWidget *parent): QDialog(parent)
  {
    // Title
    setWindowTitle(tr("Search and replace"));
    setWindowIcon(QIcon(QString(ICON_PATH) + "/search.png"));

    // Layout
    QVBoxLayout *vlayout = new QVBoxLayout();
    setLayout(vlayout);

    // Search
    QGroupBox *searchGroup = new QGroupBox(this);
    searchGroup->setTitle(tr("Search"));
    vlayout->addWidget(searchGroup);

    QVBoxLayout *searchLayout = new QVBoxLayout();
    searchGroup->setLayout(searchLayout);

    QLabel *searchLabel = new QLabel(this);
    searchLabel->setText(tr("Search"));
    searchLayout->addWidget(searchLabel);

    search = new QLineEdit(this);
    searchLayout->addWidget(search);

    searchRegExp = new QCheckBox(this);
    searchRegExp->setText(tr("Regular expression"));
    searchLayout->addWidget(searchRegExp);
    searchRegExp->hide();

    // Replace
    QGroupBox *replaceGroup = new QGroupBox(this);
    replaceGroup->setTitle(tr("Replace"));
    vlayout->addWidget(replaceGroup);

    QVBoxLayout *replaceLayout = new QVBoxLayout();
    replaceGroup->setLayout(replaceLayout);

    QLabel *replaceLabel = new QLabel(this);
    replaceLabel->setText(tr("Replace"));
    replaceLayout->addWidget(replaceLabel);

    replace = new QLineEdit(this);
    replaceLayout->addWidget(replace);

    // Options
    QGroupBox *optionsGroup = new QGroupBox(this);
    optionsGroup->setTitle(tr("Options"));
    vlayout->addWidget(optionsGroup);

    QHBoxLayout *optionsLayout = new QHBoxLayout();
    optionsGroup->setLayout(optionsLayout);

    QVBoxLayout *optionsV1Layout = new QVBoxLayout();
    optionsLayout->addLayout(optionsV1Layout);

    QVBoxLayout *optionsV2Layout = new QVBoxLayout();
    optionsLayout->addLayout(optionsV2Layout);

    caseSensitiveCB = new QCheckBox(this);
    caseSensitiveCB->setText(tr("Case sensitive"));
    optionsV1Layout->addWidget(caseSensitiveCB);

    wholeWordsCB = new QCheckBox(this);
    wholeWordsCB->setText(tr("Only full words"));
    optionsV1Layout->addWidget(wholeWordsCB);

    fromCursorCB = new QCheckBox(this);
    fromCursorCB->setText(tr("From cursor"));
    optionsV2Layout->addWidget(fromCursorCB);

    // Buttons
    QHBoxLayout *buttonsLayout = new QHBoxLayout();
    vlayout->addLayout(buttonsLayout);

    QPushButton *acceptButton = new QPushButton(this);
    acceptButton->setText(tr("Search"));
    buttonsLayout->addWidget(acceptButton);
    connect(acceptButton, SIGNAL(clicked()), this, SIGNAL(search_signal()));

    QPushButton *replaceButton = new QPushButton(this);
    replaceButton->setText(tr("Replace"));
    buttonsLayout->addWidget(replaceButton);
    connect(replaceButton, SIGNAL(clicked()), this, SIGNAL(replace_signal()));

    QPushButton *cancelButton = new QPushButton(this);
    cancelButton->setText(tr("Cancel"));
    buttonsLayout->addWidget(cancelButton);
    connect(cancelButton, SIGNAL(clicked()), this, SLOT(accept()));
  }

  // Strings
  QString searchString()  { return search->text(); }
  QString replaceString() { return replace->text(); }

  // Options
  bool searchStringIsRegExp()  { return searchRegExp->checkState();    }
  bool caseSensitive()         { return caseSensitiveCB->checkState(); }
  bool wholeWords()            { return wholeWordsCB->checkState();    }
  bool fromCursor()            { return fromCursorCB->checkState();    }

  // Signals
  signals:
  void search_signal();
  void replace_signal();
};

#endif
