#ifndef DIRBOX_H
#define DIRBOX_H



class FXAPI DirBox : public FXTreeListBox
{
    FXDECLARE(DirBox)
protected:
    DirBox()
    {}
    FXString getItemPathname(FXTreeItem *item) const;
    FXTreeItem* getPathnameItem(const FXString& path);
private:
    DirBox(const DirBox&);
    DirBox &operator=(const DirBox&);
public:
    long onTreeChanged(FXObject*,FXSelector,void*);
    long onTreeClicked(FXObject*,FXSelector,void*);
    long onCmdSetValue(FXObject*,FXSelector,void*);
    long onCmdSetStringValue(FXObject*,FXSelector,void*);
    long onCmdGetStringValue(FXObject*,FXSelector,void*);
public:

    // Construct a Directory Box
    DirBox(FXComposite *p,FXObject* tgt=NULL,FXSelector sel=0,FXuint opts=FRAME_SUNKEN|FRAME_THICK|TREELISTBOX_NORMAL,FXint x=0,FXint y=0,FXint w=0,FXint h=0,FXint pl=DEFAULT_PAD,FXint pr=DEFAULT_PAD,FXint pt=DEFAULT_PAD,FXint pb=DEFAULT_PAD);

    // Create server-side resources
    virtual void create();

    // Set current directory
    void setDirectory(const FXString& pathname);

    // Return current directory
    FXString getDirectory() const;

    // Destructor
    virtual ~DirBox();
};


#endif
