/* keysyms.c: UI keysym to Fuse input layer keysym mappings
   Copyright (c) 2000-2004 Philip Kendall, Matan Ziv-Av, Russell Marks,
                           Fredrick Meunier, Catalin Mihaila

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 49 Temple Place, Suite 330, Boston, MA 02111-1307 USA

   Author contact information:

   E-mail: pak21-fuse@srcf.ucam.org
   Postal address: 15 Crescent Road, Wokingham, Berks, RG40 2DB, England

*/

/* This file is autogenerated from keysyms.dat by keysyms.pl.
   Do not edit unless you know what you're doing! */

#include <config.h>

#ifdef UI_SVGA

#include "input.h"
#include "keyboard.h"

#include <vgakeyboard.h>

keysyms_map_t keysyms_map[] = {

  { SCANCODE_ESCAPE,           INPUT_KEY_Escape      },
  { SCANCODE_F1,               INPUT_KEY_F1          },
  { SCANCODE_F2,               INPUT_KEY_F2          },
  { SCANCODE_F3,               INPUT_KEY_F3          },
  { SCANCODE_F4,               INPUT_KEY_F4          },
  { SCANCODE_F5,               INPUT_KEY_F5          },
  { SCANCODE_F6,               INPUT_KEY_F6          },
  { SCANCODE_F7,               INPUT_KEY_F7          },
  { SCANCODE_F8,               INPUT_KEY_F8          },
  { SCANCODE_F9,               INPUT_KEY_F9          },
  { SCANCODE_F10,              INPUT_KEY_F10         },
  { SCANCODE_F11,              INPUT_KEY_F11         },
  { SCANCODE_F12,              INPUT_KEY_F12         },
  { SCANCODE_1,                INPUT_KEY_1           },
  { SCANCODE_2,                INPUT_KEY_2           },
  { SCANCODE_3,                INPUT_KEY_3           },
  { SCANCODE_4,                INPUT_KEY_4           },
  { SCANCODE_5,                INPUT_KEY_5           },
  { SCANCODE_6,                INPUT_KEY_6           },
  { SCANCODE_7,                INPUT_KEY_7           },
  { SCANCODE_8,                INPUT_KEY_8           },
  { SCANCODE_9,                INPUT_KEY_9           },
  { SCANCODE_0,                INPUT_KEY_0           },
  { SCANCODE_MINUS,            INPUT_KEY_minus       },
  { SCANCODE_EQUAL,            INPUT_KEY_equal       },
  { SCANCODE_BACKSPACE,        INPUT_KEY_BackSpace   },
  { SCANCODE_TAB,              INPUT_KEY_Tab         },
  { SCANCODE_Q,                INPUT_KEY_q           },
  { SCANCODE_W,                INPUT_KEY_w           },
  { SCANCODE_E,                INPUT_KEY_e           },
  { SCANCODE_R,                INPUT_KEY_r           },
  { SCANCODE_T,                INPUT_KEY_t           },
  { SCANCODE_Y,                INPUT_KEY_y           },
  { SCANCODE_U,                INPUT_KEY_u           },
  { SCANCODE_I,                INPUT_KEY_i           },
  { SCANCODE_O,                INPUT_KEY_o           },
  { SCANCODE_P,                INPUT_KEY_p           },
  { SCANCODE_CAPSLOCK,         INPUT_KEY_Caps_Lock   },
  { SCANCODE_A,                INPUT_KEY_a           },
  { SCANCODE_S,                INPUT_KEY_s           },
  { SCANCODE_D,                INPUT_KEY_d           },
  { SCANCODE_F,                INPUT_KEY_f           },
  { SCANCODE_G,                INPUT_KEY_g           },
  { SCANCODE_H,                INPUT_KEY_h           },
  { SCANCODE_J,                INPUT_KEY_j           },
  { SCANCODE_K,                INPUT_KEY_k           },
  { SCANCODE_L,                INPUT_KEY_l           },
  { SCANCODE_SEMICOLON,        INPUT_KEY_semicolon   },
  { SCANCODE_APOSTROPHE,       INPUT_KEY_apostrophe  },
  { SCANCODE_BACKSLASH,        INPUT_KEY_numbersign  },
  { SCANCODE_ENTER,            INPUT_KEY_Return      },
  { SCANCODE_LEFTSHIFT,        INPUT_KEY_Shift_L     },
  { SCANCODE_Z,                INPUT_KEY_z           },
  { SCANCODE_X,                INPUT_KEY_x           },
  { SCANCODE_C,                INPUT_KEY_c           },
  { SCANCODE_V,                INPUT_KEY_v           },
  { SCANCODE_B,                INPUT_KEY_b           },
  { SCANCODE_N,                INPUT_KEY_n           },
  { SCANCODE_M,                INPUT_KEY_m           },
  { SCANCODE_COMMA,            INPUT_KEY_comma       },
  { SCANCODE_PERIOD,           INPUT_KEY_period      },
  { SCANCODE_SLASH,            INPUT_KEY_slash       },
  { SCANCODE_RIGHTSHIFT,       INPUT_KEY_Shift_R     },
  { SCANCODE_LEFTCONTROL,      INPUT_KEY_Control_L   },
  { SCANCODE_LEFTALT,          INPUT_KEY_Alt_L       },
#ifdef SCANCODE_LEFTWIN
  { SCANCODE_LEFTWIN,          INPUT_KEY_Meta_L      },
#endif                          /* #ifdef Meta_L */
  { SCANCODE_SPACE,            INPUT_KEY_space       },
#ifdef SCANCODE_RIGHTWIN
  { SCANCODE_RIGHTWIN,         INPUT_KEY_Meta_R      },
#endif                          /* #ifdef Meta_R */
  { SCANCODE_RIGHTALT,         INPUT_KEY_Alt_R       },
  { SCANCODE_RIGHTCONTROL,     INPUT_KEY_Control_R   },
  { 127,                       INPUT_KEY_Mode_switch },
  { SCANCODE_CURSORBLOCKLEFT,  INPUT_KEY_Left        },
  { SCANCODE_CURSORBLOCKDOWN,  INPUT_KEY_Down        },
  { SCANCODE_CURSORBLOCKUP,    INPUT_KEY_Up          },
  { SCANCODE_CURSORBLOCKRIGHT, INPUT_KEY_Right       },
  { SCANCODE_PAGEUP,           INPUT_KEY_Page_Up     },
  { SCANCODE_PAGEDOWN,         INPUT_KEY_Page_Down   },
  { SCANCODE_HOME,             INPUT_KEY_Home        },
  { SCANCODE_END,              INPUT_KEY_End         },

  { 0, 0 }			/* End marker: DO NOT MOVE! */

};

#endif
