/* options.c: options dialog boxes
   Copyright (c) 2001-2004 Philip Kendall

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 49 Temple Place, Suite 330, Boston, MA 02111-1307 USA

   Author contact information:

   E-mail: pak21-fuse@srcf.ucam.org
   Postal address: 15 Crescent Road, Wokingham, Berks, RG40 2DB, England

*/

/* This file is autogenerated from options.dat by options.pl.
   Do not edit unless you know what you're doing! */

#include <config.h>

#ifdef UI_GTK		/* Use this file iff we're using GTK+ */

#include <stdio.h>
#include <stdlib.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "compat.h"
#include "display.h"
#include "fuse.h"
#include "gtkinternals.h"
#include "options.h"
#include "periph.h"
#include "settings.h"

static void menu_options_general_done( GtkWidget *widget,
					  gpointer user_data );

void
menu_options_general( GtkWidget *widget GCC_UNUSED,
			 gpointer data GCC_UNUSED )
{
  menu_options_general_t dialog;
  GtkWidget *ok_button, *cancel_button, *frame, *hbox, *text;
  GtkAccelGroup *accel_group;
  gchar buffer[80];

  frame = hbox = text = NULL;
  buffer[0] = '\0';		/* Shut gcc up */
  
  /* Firstly, stop emulation */
  fuse_emulation_pause();

  /* Create the necessary widgets */
  dialog.dialog = gtk_dialog_new();
  gtk_window_set_title( GTK_WINDOW( dialog.dialog ), "Fuse - General Options" );

  /* Create the various widgets */
  frame = gtk_frame_new( "Emulation speed" );
  gtk_box_pack_start_defaults( GTK_BOX( GTK_DIALOG( dialog.dialog )->vbox ),
			       frame );
				    
  hbox = gtk_hbox_new( FALSE, 0 );
  gtk_container_set_border_width( GTK_CONTAINER( hbox ), 4 );
  gtk_container_add( GTK_CONTAINER( frame ), hbox );

  dialog.emulation_speed = gtk_entry_new();
  gtk_entry_set_max_length( GTK_ENTRY( dialog.emulation_speed ),
	   		    3 );
  snprintf( buffer, 80, "%d", settings_current.emulation_speed );
  gtk_entry_set_text( GTK_ENTRY( dialog.emulation_speed ), buffer );
  gtk_box_pack_start_defaults( GTK_BOX( hbox ), dialog.emulation_speed );

  text = gtk_label_new( "%" );
  gtk_box_pack_start( GTK_BOX( hbox ), text, FALSE, FALSE, 5 );

  frame = gtk_frame_new( "Frame rate 1:n" );
  gtk_box_pack_start_defaults( GTK_BOX( GTK_DIALOG( dialog.dialog )->vbox ),
			       frame );
				    
  hbox = gtk_hbox_new( FALSE, 0 );
  gtk_container_set_border_width( GTK_CONTAINER( hbox ), 4 );
  gtk_container_add( GTK_CONTAINER( frame ), hbox );

  dialog.frame_rate = gtk_entry_new();
  gtk_entry_set_max_length( GTK_ENTRY( dialog.frame_rate ),
	   		    1 );
  snprintf( buffer, 80, "%d", settings_current.frame_rate );
  gtk_entry_set_text( GTK_ENTRY( dialog.frame_rate ), buffer );
  gtk_box_pack_start_defaults( GTK_BOX( hbox ), dialog.frame_rate );

  text = gtk_label_new( "frames" );
  gtk_box_pack_start( GTK_BOX( hbox ), text, FALSE, FALSE, 5 );

  dialog.issue2 =
    gtk_check_button_new_with_label( "Issue 2 Keyboard" );
  gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON( dialog.issue2 ),
				settings_current.issue2 );
  gtk_container_add( GTK_CONTAINER( GTK_DIALOG( dialog.dialog )->vbox ),
		     dialog.issue2 );

  dialog.tape_traps =
    gtk_check_button_new_with_label( "Use tape traps" );
  gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON( dialog.tape_traps ),
				settings_current.tape_traps );
  gtk_container_add( GTK_CONTAINER( GTK_DIALOG( dialog.dialog )->vbox ),
		     dialog.tape_traps );

  dialog.auto_load =
    gtk_check_button_new_with_label( "Auto-load media" );
  gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON( dialog.auto_load ),
				settings_current.auto_load );
  gtk_container_add( GTK_CONTAINER( GTK_DIALOG( dialog.dialog )->vbox ),
		     dialog.auto_load );

  dialog.snaps_as_z80 =
    gtk_check_button_new_with_label( "Save snaps as .z80" );
  gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON( dialog.snaps_as_z80 ),
				settings_current.snaps_as_z80 );
  gtk_container_add( GTK_CONTAINER( GTK_DIALOG( dialog.dialog )->vbox ),
		     dialog.snaps_as_z80 );

  dialog.slt_traps =
    gtk_check_button_new_with_label( "Use .slt traps" );
  gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON( dialog.slt_traps ),
				settings_current.slt_traps );
  gtk_container_add( GTK_CONTAINER( GTK_DIALOG( dialog.dialog )->vbox ),
		     dialog.slt_traps );

  dialog.writable_roms =
    gtk_check_button_new_with_label( "Allow writes to ROM" );
  gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON( dialog.writable_roms ),
				settings_current.writable_roms );
  gtk_container_add( GTK_CONTAINER( GTK_DIALOG( dialog.dialog )->vbox ),
		     dialog.writable_roms );

  dialog.autosave_settings =
    gtk_check_button_new_with_label( "Auto-save settings" );
  gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON( dialog.autosave_settings ),
				settings_current.autosave_settings );
  gtk_container_add( GTK_CONTAINER( GTK_DIALOG( dialog.dialog )->vbox ),
		     dialog.autosave_settings );

  dialog.bw_tv =
    gtk_check_button_new_with_label( "Black and white TV" );
  gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON( dialog.bw_tv ),
				settings_current.bw_tv );
  gtk_container_add( GTK_CONTAINER( GTK_DIALOG( dialog.dialog )->vbox ),
		     dialog.bw_tv );

  dialog.confirm_actions =
    gtk_check_button_new_with_label( "Confirm actions" );
  gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON( dialog.confirm_actions ),
				settings_current.confirm_actions );
  gtk_container_add( GTK_CONTAINER( GTK_DIALOG( dialog.dialog )->vbox ),
		     dialog.confirm_actions );

  dialog.statusbar =
    gtk_check_button_new_with_label( "Show statusbar" );
  gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON( dialog.statusbar ),
				settings_current.statusbar );
  gtk_container_add( GTK_CONTAINER( GTK_DIALOG( dialog.dialog )->vbox ),
		     dialog.statusbar );

  /* Create the OK and Cancel buttons */
  ok_button = gtk_button_new_with_label( "OK" );
  cancel_button = gtk_button_new_with_label( "Cancel" );

  gtk_container_add( GTK_CONTAINER( GTK_DIALOG( dialog.dialog )->action_area ),
		     ok_button );
  gtk_container_add( GTK_CONTAINER( GTK_DIALOG( dialog.dialog )->action_area ),
		     cancel_button );

  /* Add the necessary callbacks */
  gtk_signal_connect( GTK_OBJECT( ok_button ), "clicked",
		      GTK_SIGNAL_FUNC( menu_options_general_done ),
		      (gpointer) &dialog );
  gtk_signal_connect_object( GTK_OBJECT( cancel_button ), "clicked",
			     GTK_SIGNAL_FUNC( gtkui_destroy_widget_and_quit ),
			     GTK_OBJECT( dialog.dialog ) );
  gtk_signal_connect( GTK_OBJECT( dialog.dialog ), "delete-event",
		      GTK_SIGNAL_FUNC( gtkui_destroy_widget_and_quit ),
		      (gpointer) NULL );

  /* Return = 'OK', Esc = 'Cancel' */
  accel_group = gtk_accel_group_new();
  gtk_window_add_accel_group( GTK_WINDOW( dialog.dialog ), accel_group );

  gtk_widget_add_accelerator( ok_button, "clicked", accel_group,
			      GDK_Return, 0, 0 );
  gtk_widget_add_accelerator( cancel_button, "clicked", accel_group,
			      GDK_Escape, 0, 0 );

  /* Set the window to be modal and display it */
  gtk_window_set_modal( GTK_WINDOW( dialog.dialog ), TRUE );
  gtk_widget_show_all( dialog.dialog );

  /* Process events until the window is done with */
  gtk_main();

  /* And then carry on with emulation again */
  fuse_emulation_unpause();
}

static void
menu_options_general_done( GtkWidget *widget GCC_UNUSED,
			      gpointer user_data )
{
  menu_options_general_t *ptr = user_data;

  settings_current.emulation_speed =
    atoi( gtk_entry_get_text( GTK_ENTRY( ptr->emulation_speed ) ) );

  settings_current.frame_rate =
    atoi( gtk_entry_get_text( GTK_ENTRY( ptr->frame_rate ) ) );

  settings_current.issue2 =
    gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( ptr->issue2 ) );

  settings_current.tape_traps =
    gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( ptr->tape_traps ) );

  settings_current.auto_load =
    gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( ptr->auto_load ) );

  settings_current.snaps_as_z80 =
    gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( ptr->snaps_as_z80 ) );

  settings_current.slt_traps =
    gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( ptr->slt_traps ) );

  settings_current.writable_roms =
    gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( ptr->writable_roms ) );

  settings_current.autosave_settings =
    gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( ptr->autosave_settings ) );

  settings_current.bw_tv =
    gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( ptr->bw_tv ) );

  settings_current.confirm_actions =
    gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( ptr->confirm_actions ) );

  settings_current.statusbar =
    gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( ptr->statusbar ) );

  gtk_widget_destroy( ptr->dialog );

  gtkstatusbar_set_visibility( settings_current.statusbar );
  display_refresh_all();

  gtk_main_quit();
}

static void menu_options_peripherals_done( GtkWidget *widget,
					  gpointer user_data );

void
menu_options_peripherals( GtkWidget *widget GCC_UNUSED,
			 gpointer data GCC_UNUSED )
{
  menu_options_peripherals_t dialog;
  GtkWidget *ok_button, *cancel_button, *frame, *hbox, *text;
  GtkAccelGroup *accel_group;
  gchar buffer[80];

  frame = hbox = text = NULL;
  buffer[0] = '\0';		/* Shut gcc up */
  
  /* Firstly, stop emulation */
  fuse_emulation_pause();

  /* Create the necessary widgets */
  dialog.dialog = gtk_dialog_new();
  gtk_window_set_title( GTK_WINDOW( dialog.dialog ), "Fuse - Peripheral Options" );

  /* Create the various widgets */
  dialog.joy_kempston =
    gtk_check_button_new_with_label( "Kempston joystick" );
  gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON( dialog.joy_kempston ),
				settings_current.joy_kempston );
  gtk_container_add( GTK_CONTAINER( GTK_DIALOG( dialog.dialog )->vbox ),
		     dialog.joy_kempston );

  dialog.interface2 =
    gtk_check_button_new_with_label( "Interface II" );
  gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON( dialog.interface2 ),
				settings_current.interface2 );
  gtk_container_add( GTK_CONTAINER( GTK_DIALOG( dialog.dialog )->vbox ),
		     dialog.interface2 );

  dialog.printer =
    gtk_check_button_new_with_label( "Emulate printers" );
  gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON( dialog.printer ),
				settings_current.printer );
  gtk_container_add( GTK_CONTAINER( GTK_DIALOG( dialog.dialog )->vbox ),
		     dialog.printer );

  dialog.simpleide_active =
    gtk_check_button_new_with_label( "Simple 8-bit IDE" );
  gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON( dialog.simpleide_active ),
				settings_current.simpleide_active );
  gtk_container_add( GTK_CONTAINER( GTK_DIALOG( dialog.dialog )->vbox ),
		     dialog.simpleide_active );

  dialog.zxatasp_active =
    gtk_check_button_new_with_label( "ZXATASP interface" );
  gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON( dialog.zxatasp_active ),
				settings_current.zxatasp_active );
  gtk_container_add( GTK_CONTAINER( GTK_DIALOG( dialog.dialog )->vbox ),
		     dialog.zxatasp_active );

  dialog.zxatasp_upload =
    gtk_check_button_new_with_label( "ZXATASP upload" );
  gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON( dialog.zxatasp_upload ),
				settings_current.zxatasp_upload );
  gtk_container_add( GTK_CONTAINER( GTK_DIALOG( dialog.dialog )->vbox ),
		     dialog.zxatasp_upload );

  dialog.zxatasp_wp =
    gtk_check_button_new_with_label( "ZXATASP write protect" );
  gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON( dialog.zxatasp_wp ),
				settings_current.zxatasp_wp );
  gtk_container_add( GTK_CONTAINER( GTK_DIALOG( dialog.dialog )->vbox ),
		     dialog.zxatasp_wp );

  dialog.zxcf_active =
    gtk_check_button_new_with_label( "ZXCF interface" );
  gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON( dialog.zxcf_active ),
				settings_current.zxcf_active );
  gtk_container_add( GTK_CONTAINER( GTK_DIALOG( dialog.dialog )->vbox ),
		     dialog.zxcf_active );

  dialog.zxcf_upload =
    gtk_check_button_new_with_label( "ZXCF upload" );
  gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON( dialog.zxcf_upload ),
				settings_current.zxcf_upload );
  gtk_container_add( GTK_CONTAINER( GTK_DIALOG( dialog.dialog )->vbox ),
		     dialog.zxcf_upload );

  /* Create the OK and Cancel buttons */
  ok_button = gtk_button_new_with_label( "OK" );
  cancel_button = gtk_button_new_with_label( "Cancel" );

  gtk_container_add( GTK_CONTAINER( GTK_DIALOG( dialog.dialog )->action_area ),
		     ok_button );
  gtk_container_add( GTK_CONTAINER( GTK_DIALOG( dialog.dialog )->action_area ),
		     cancel_button );

  /* Add the necessary callbacks */
  gtk_signal_connect( GTK_OBJECT( ok_button ), "clicked",
		      GTK_SIGNAL_FUNC( menu_options_peripherals_done ),
		      (gpointer) &dialog );
  gtk_signal_connect_object( GTK_OBJECT( cancel_button ), "clicked",
			     GTK_SIGNAL_FUNC( gtkui_destroy_widget_and_quit ),
			     GTK_OBJECT( dialog.dialog ) );
  gtk_signal_connect( GTK_OBJECT( dialog.dialog ), "delete-event",
		      GTK_SIGNAL_FUNC( gtkui_destroy_widget_and_quit ),
		      (gpointer) NULL );

  /* Return = 'OK', Esc = 'Cancel' */
  accel_group = gtk_accel_group_new();
  gtk_window_add_accel_group( GTK_WINDOW( dialog.dialog ), accel_group );

  gtk_widget_add_accelerator( ok_button, "clicked", accel_group,
			      GDK_Return, 0, 0 );
  gtk_widget_add_accelerator( cancel_button, "clicked", accel_group,
			      GDK_Escape, 0, 0 );

  /* Set the window to be modal and display it */
  gtk_window_set_modal( GTK_WINDOW( dialog.dialog ), TRUE );
  gtk_widget_show_all( dialog.dialog );

  /* Process events until the window is done with */
  gtk_main();

  /* And then carry on with emulation again */
  fuse_emulation_unpause();
}

static void
menu_options_peripherals_done( GtkWidget *widget GCC_UNUSED,
			      gpointer user_data )
{
  menu_options_peripherals_t *ptr = user_data;

  settings_current.joy_kempston =
    gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( ptr->joy_kempston ) );

  settings_current.interface2 =
    gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( ptr->interface2 ) );

  settings_current.printer =
    gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( ptr->printer ) );

  settings_current.simpleide_active =
    gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( ptr->simpleide_active ) );

  settings_current.zxatasp_active =
    gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( ptr->zxatasp_active ) );

  settings_current.zxatasp_upload =
    gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( ptr->zxatasp_upload ) );

  settings_current.zxatasp_wp =
    gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( ptr->zxatasp_wp ) );

  settings_current.zxcf_active =
    gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( ptr->zxcf_active ) );

  settings_current.zxcf_upload =
    gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( ptr->zxcf_upload ) );

  gtk_widget_destroy( ptr->dialog );

  periph_update();

  gtkstatusbar_set_visibility( settings_current.statusbar );
  display_refresh_all();

  gtk_main_quit();
}

static void menu_options_rzx_done( GtkWidget *widget,
					  gpointer user_data );

void
menu_options_rzx( GtkWidget *widget GCC_UNUSED,
			 gpointer data GCC_UNUSED )
{
  menu_options_rzx_t dialog;
  GtkWidget *ok_button, *cancel_button, *frame, *hbox, *text;
  GtkAccelGroup *accel_group;
  gchar buffer[80];

  frame = hbox = text = NULL;
  buffer[0] = '\0';		/* Shut gcc up */
  
  /* Firstly, stop emulation */
  fuse_emulation_pause();

  /* Create the necessary widgets */
  dialog.dialog = gtk_dialog_new();
  gtk_window_set_title( GTK_WINDOW( dialog.dialog ), "Fuse - RZX Options" );

  /* Create the various widgets */
  dialog.rzx_compression =
    gtk_check_button_new_with_label( "Compress RZX data" );
  gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON( dialog.rzx_compression ),
				settings_current.rzx_compression );
  gtk_container_add( GTK_CONTAINER( GTK_DIALOG( dialog.dialog )->vbox ),
		     dialog.rzx_compression );

  dialog.competition_mode =
    gtk_check_button_new_with_label( "Competition mode" );
  gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON( dialog.competition_mode ),
				settings_current.competition_mode );
  gtk_container_add( GTK_CONTAINER( GTK_DIALOG( dialog.dialog )->vbox ),
		     dialog.competition_mode );

  frame = gtk_frame_new( "Competition code" );
  gtk_box_pack_start_defaults( GTK_BOX( GTK_DIALOG( dialog.dialog )->vbox ),
			       frame );
				    
  hbox = gtk_hbox_new( FALSE, 0 );
  gtk_container_set_border_width( GTK_CONTAINER( hbox ), 4 );
  gtk_container_add( GTK_CONTAINER( frame ), hbox );

  dialog.competition_code = gtk_entry_new();
  gtk_entry_set_max_length( GTK_ENTRY( dialog.competition_code ),
	   		    8 );
  snprintf( buffer, 80, "%d", settings_current.competition_code );
  gtk_entry_set_text( GTK_ENTRY( dialog.competition_code ), buffer );
  gtk_box_pack_start_defaults( GTK_BOX( hbox ), dialog.competition_code );

  text = gtk_label_new( "" );
  gtk_box_pack_start( GTK_BOX( hbox ), text, FALSE, FALSE, 5 );

  dialog.embed_snapshot =
    gtk_check_button_new_with_label( "Always embed snapshot" );
  gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON( dialog.embed_snapshot ),
				settings_current.embed_snapshot );
  gtk_container_add( GTK_CONTAINER( GTK_DIALOG( dialog.dialog )->vbox ),
		     dialog.embed_snapshot );

  /* Create the OK and Cancel buttons */
  ok_button = gtk_button_new_with_label( "OK" );
  cancel_button = gtk_button_new_with_label( "Cancel" );

  gtk_container_add( GTK_CONTAINER( GTK_DIALOG( dialog.dialog )->action_area ),
		     ok_button );
  gtk_container_add( GTK_CONTAINER( GTK_DIALOG( dialog.dialog )->action_area ),
		     cancel_button );

  /* Add the necessary callbacks */
  gtk_signal_connect( GTK_OBJECT( ok_button ), "clicked",
		      GTK_SIGNAL_FUNC( menu_options_rzx_done ),
		      (gpointer) &dialog );
  gtk_signal_connect_object( GTK_OBJECT( cancel_button ), "clicked",
			     GTK_SIGNAL_FUNC( gtkui_destroy_widget_and_quit ),
			     GTK_OBJECT( dialog.dialog ) );
  gtk_signal_connect( GTK_OBJECT( dialog.dialog ), "delete-event",
		      GTK_SIGNAL_FUNC( gtkui_destroy_widget_and_quit ),
		      (gpointer) NULL );

  /* Return = 'OK', Esc = 'Cancel' */
  accel_group = gtk_accel_group_new();
  gtk_window_add_accel_group( GTK_WINDOW( dialog.dialog ), accel_group );

  gtk_widget_add_accelerator( ok_button, "clicked", accel_group,
			      GDK_Return, 0, 0 );
  gtk_widget_add_accelerator( cancel_button, "clicked", accel_group,
			      GDK_Escape, 0, 0 );

  /* Set the window to be modal and display it */
  gtk_window_set_modal( GTK_WINDOW( dialog.dialog ), TRUE );
  gtk_widget_show_all( dialog.dialog );

  /* Process events until the window is done with */
  gtk_main();

  /* And then carry on with emulation again */
  fuse_emulation_unpause();
}

static void
menu_options_rzx_done( GtkWidget *widget GCC_UNUSED,
			      gpointer user_data )
{
  menu_options_rzx_t *ptr = user_data;

  settings_current.rzx_compression =
    gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( ptr->rzx_compression ) );

  settings_current.competition_mode =
    gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( ptr->competition_mode ) );

  settings_current.competition_code =
    atoi( gtk_entry_get_text( GTK_ENTRY( ptr->competition_code ) ) );

  settings_current.embed_snapshot =
    gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( ptr->embed_snapshot ) );

  gtk_widget_destroy( ptr->dialog );

  gtkstatusbar_set_visibility( settings_current.statusbar );
  display_refresh_all();

  gtk_main_quit();
}

static void menu_options_sound_done( GtkWidget *widget,
					  gpointer user_data );

void
menu_options_sound( GtkWidget *widget GCC_UNUSED,
			 gpointer data GCC_UNUSED )
{
  menu_options_sound_t dialog;
  GtkWidget *ok_button, *cancel_button, *frame, *hbox, *text;
  GtkAccelGroup *accel_group;
  gchar buffer[80];

  frame = hbox = text = NULL;
  buffer[0] = '\0';		/* Shut gcc up */
  
  /* Firstly, stop emulation */
  fuse_emulation_pause();

  /* Create the necessary widgets */
  dialog.dialog = gtk_dialog_new();
  gtk_window_set_title( GTK_WINDOW( dialog.dialog ), "Fuse - Sound Options" );

  /* Create the various widgets */
  dialog.sound =
    gtk_check_button_new_with_label( "Sound enabled" );
  gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON( dialog.sound ),
				settings_current.sound );
  gtk_container_add( GTK_CONTAINER( GTK_DIALOG( dialog.dialog )->vbox ),
		     dialog.sound );

  dialog.sound_load =
    gtk_check_button_new_with_label( "Loading sound" );
  gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON( dialog.sound_load ),
				settings_current.sound_load );
  gtk_container_add( GTK_CONTAINER( GTK_DIALOG( dialog.dialog )->vbox ),
		     dialog.sound_load );

  dialog.stereo_ay =
    gtk_check_button_new_with_label( "AY stereo separation" );
  gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON( dialog.stereo_ay ),
				settings_current.stereo_ay );
  gtk_container_add( GTK_CONTAINER( GTK_DIALOG( dialog.dialog )->vbox ),
		     dialog.stereo_ay );

  dialog.stereo_beeper =
    gtk_check_button_new_with_label( "Beeper pseudo-stereo" );
  gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON( dialog.stereo_beeper ),
				settings_current.stereo_beeper );
  gtk_container_add( GTK_CONTAINER( GTK_DIALOG( dialog.dialog )->vbox ),
		     dialog.stereo_beeper );

  dialog.sound_force_8bit =
    gtk_check_button_new_with_label( "Force 8-bit" );
  gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON( dialog.sound_force_8bit ),
				settings_current.sound_force_8bit );
  gtk_container_add( GTK_CONTAINER( GTK_DIALOG( dialog.dialog )->vbox ),
		     dialog.sound_force_8bit );

  /* Create the OK and Cancel buttons */
  ok_button = gtk_button_new_with_label( "OK" );
  cancel_button = gtk_button_new_with_label( "Cancel" );

  gtk_container_add( GTK_CONTAINER( GTK_DIALOG( dialog.dialog )->action_area ),
		     ok_button );
  gtk_container_add( GTK_CONTAINER( GTK_DIALOG( dialog.dialog )->action_area ),
		     cancel_button );

  /* Add the necessary callbacks */
  gtk_signal_connect( GTK_OBJECT( ok_button ), "clicked",
		      GTK_SIGNAL_FUNC( menu_options_sound_done ),
		      (gpointer) &dialog );
  gtk_signal_connect_object( GTK_OBJECT( cancel_button ), "clicked",
			     GTK_SIGNAL_FUNC( gtkui_destroy_widget_and_quit ),
			     GTK_OBJECT( dialog.dialog ) );
  gtk_signal_connect( GTK_OBJECT( dialog.dialog ), "delete-event",
		      GTK_SIGNAL_FUNC( gtkui_destroy_widget_and_quit ),
		      (gpointer) NULL );

  /* Return = 'OK', Esc = 'Cancel' */
  accel_group = gtk_accel_group_new();
  gtk_window_add_accel_group( GTK_WINDOW( dialog.dialog ), accel_group );

  gtk_widget_add_accelerator( ok_button, "clicked", accel_group,
			      GDK_Return, 0, 0 );
  gtk_widget_add_accelerator( cancel_button, "clicked", accel_group,
			      GDK_Escape, 0, 0 );

  /* Set the window to be modal and display it */
  gtk_window_set_modal( GTK_WINDOW( dialog.dialog ), TRUE );
  gtk_widget_show_all( dialog.dialog );

  /* Process events until the window is done with */
  gtk_main();

  /* And then carry on with emulation again */
  fuse_emulation_unpause();
}

static void
menu_options_sound_done( GtkWidget *widget GCC_UNUSED,
			      gpointer user_data )
{
  menu_options_sound_t *ptr = user_data;

  settings_current.sound =
    gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( ptr->sound ) );

  settings_current.sound_load =
    gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( ptr->sound_load ) );

  settings_current.stereo_ay =
    gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( ptr->stereo_ay ) );

  settings_current.stereo_beeper =
    gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( ptr->stereo_beeper ) );

  settings_current.sound_force_8bit =
    gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( ptr->sound_force_8bit ) );

  gtk_widget_destroy( ptr->dialog );

  gtkstatusbar_set_visibility( settings_current.statusbar );
  display_refresh_all();

  gtk_main_quit();
}

#endif			/* #ifdef UI_GTK */
