/*      Copyright (C) 2000, 2001, 2002, 2003, 2004 Stijn van Dongen
 *
 * This file is part of MCL.  You can redistribute and/or modify MCL under the
 * terms of the GNU General Public License; either version 2 of the License or
 * (at your option) any later version.  You should have received a copy of the
 * GPL along with MCL, in the file COPYING.
*/

/*    FIXME: parsing code is hideous.
 *    The parsing of ranges even more so. taurus/parse.c/parseIntSet.
*/

#include <string.h>
#include <stdlib.h>
#include <stdio.h>

#include "impala/matrix.h"
#include "impala/vector.h"
#include "impala/ivp.h"
#include "impala/pval.h"
#include "impala/io.h"
#include "impala/app.h"
#include "mcl/interpret.h"

#include "util/types.h"
#include "util/err.h"
#include "util/ting.h"
#include "util/opt.h"
#include "util/array.h"
#include "util/duck.h"

#include "taurus/parse.h"
#include "taurus/la.h"


enum
{  MY_OPT_IMX
,  MY_OPT_DOMAIN
,  MY_OPT_SPEC_DOMS
,  MY_OPT_SPEC_COLS
,  MY_OPT_SPEC_ROWS
,  MY_OPT_STEM
,  MY_OPT_FROM_DISK
,  MY_OPT_EFAC
,  MY_OPT_DFAC
,  MY_OPT_RFAC
,  MY_OPT_CFAC
,  MY_OPT_RAND_DISCARD
,  MY_OPT_RAND_EXCLUSIVE
,  MY_OPT_RAND_INTERSECT
,  MY_OPT_RAND_MERGE
,  MY_OPT_TAGGED
,  MY_OPT_TAG_DIGITS
,  MY_OPT_VERSION
,  MY_OPT_HELP
,  MY_OPT_APROPOS
}  ;


mcxOptAnchor options[] =
{
   {  "--apropos"
   ,  MCX_OPT_DEFAULT | MCX_OPT_INFO
   ,  MY_OPT_APROPOS
   ,  NULL
   ,  "print this help"
   }
,  {  "-h"
   ,  MCX_OPT_DEFAULT | MCX_OPT_INFO
   ,  MY_OPT_HELP
   ,  NULL
   ,  "print this help"
   }
,  {  "--version"
   ,  MCX_OPT_DEFAULT | MCX_OPT_INFO
   ,  MY_OPT_VERSION
   ,  NULL
   ,  "print version information"
   }
,  {  "-dom"
   ,  MCX_OPT_HASARG
   ,  MY_OPT_DOMAIN
   ,  "<fname>"
   ,  "domain matrix (target for 'd' specs)"
   }
,  {  "-stem"
   ,  MCX_OPT_HASARG
   ,  MY_OPT_STEM
   ,  "<str>"
   ,  "stem for file name construction"
   }
,  {  "--tag"
   ,  MCX_OPT_DEFAULT
   ,  MY_OPT_TAGGED
   ,  NULL
   ,  "output tagged matrices"
   }
,  {  "--from-disk"
   ,  MCX_OPT_DEFAULT
   ,  MY_OPT_FROM_DISK
   ,  NULL
   ,  "construct submatrices from disk"
   }
,  {  "--rand-discard"
   ,  MCX_OPT_DEFAULT
   ,  MY_OPT_RAND_DISCARD
   ,  NULL
   ,  "discard random selection"
   }
,  {  "--rand-exclusive"
   ,  MCX_OPT_DEFAULT
   ,  MY_OPT_RAND_EXCLUSIVE
   ,  NULL
   ,  "discard regular selection"
   }
,  {  "--rand-intersect"
   ,  MCX_OPT_DEFAULT
   ,  MY_OPT_RAND_INTERSECT
   ,  NULL
   ,  "intersect random and regular selection"
   }
,  {  "--rand-merge"
   ,  MCX_OPT_DEFAULT
   ,  MY_OPT_RAND_MERGE
   ,  NULL
   ,  "join random and regular selection"
   }
,  {  "--spec-doms"
   ,  MCX_OPT_DEFAULT
   ,  MY_OPT_SPEC_DOMS
   ,  NULL
   ,  "use spec domains as matrix domains"
   }
,  {  "--spec-cols"
   ,  MCX_OPT_DEFAULT
   ,  MY_OPT_SPEC_COLS
   ,  NULL
   ,  "use column spec as matrix column domain"
   }
,  {  "--spec-rows"
   ,  MCX_OPT_DEFAULT
   ,  MY_OPT_SPEC_ROWS
   ,  NULL
   ,  "use row spec as matrix row domain"
   }
,  {  "-efac"
   ,  MCX_OPT_HASARG
   ,  MY_OPT_EFAC
   ,  "<num>"
   ,  "random selection row factor"
   }
,  {  "-dfac"
   ,  MCX_OPT_HASARG
   ,  MY_OPT_DFAC
   ,  "<num>"
   ,  "random selection domain factor"
   }
,  {  "-rfac"
   ,  MCX_OPT_HASARG | MCX_OPT_HIDDEN
   ,  MY_OPT_RFAC
   ,  "<num>"
   ,  "edge selection, not implemented"
   }
,  {  "-cfac"
   ,  MCX_OPT_HASARG
   ,  MY_OPT_CFAC
   ,  "<num>"
   ,  "random selection column factor"
   }
,  {  "-tag-digits"
   ,  MCX_OPT_HASARG
   ,  MY_OPT_TAG_DIGITS
   ,  "<int>"
   ,  "digits to print for tagged write"
   }
,  {  "-imx"
   ,  MCX_OPT_HASARG
   ,  MY_OPT_IMX
   ,  "<fname>"
   ,  "matrix/graph file name"
   }
,  {  NULL, 0, 0, NULL, NULL }  
}  ;



#define DO_CC     16
#define DO_TP     32

#define MAP_COLS 1
#define MAP_ROWS 2

typedef struct
{  mcxTing*    tagTxt
;  mcxTing*    specTxt          /*  text representation of spec   */
;  mclVector*  cvec             /*  contains col indices    */
;  mclVector*  rvec             /*  contains row indices    */
;  mcxbool     blockdiagonal
;  mcxbool     tagIsFname
;  double      lft
;  double      rgt
;  mcxbits     options
;  mcxbits     selOptions
;  mcxbits     mapOptions
;  
}  subSpec     ;


const char* syntax = "Usage: mcxsubs <options> <sub-spec>+";
const char* me = "mcxsubs";

/*  Conceivable options for randomly thinning out a graph.
 * -  thing out domains, either the same way or separately, or only one of them.
 * -  randomly pick edges.
*/

double dfac = 0.0;         /* both domains */
double cfac = 0.0;         /* column domain */
double rfac = 0.0;         /* row domain */
double efac = 0.0;         /* edges */


mclVector*  VectorFromString
(  const char* str
,  mclMatrix*  dom
,  mclVector*  universe
)  ;


void thin_out
(  mclv* universe
,  double fac
)
   {  int i
   ;  double zero = 0.0
   ;  for (i=0;i<universe->n_ivps;i++)
      {  long r = random()
      ;  if (((double) r) / RANDOM_MAX > fac)
         universe->ivps[i].val = 0.0
   ;  }

      mclvUnary(universe, fltGtBar, &zero)
;  }


int main
(  int                  argc
,  const char*          argv[]
)  
   {  mcxIO *xfcl = NULL, *xfmx = NULL

   ;  mclx *dom = NULL,*el2dom = NULL, *mx = NULL
   ;  mclv *universe_rows = NULL, *universe_cols = NULL
   ;  mclv *subspace_rows = NULL, *subspace_cols = NULL

   ;  mcxTing *fstem =  mcxTingNew("out.sub-")
   ;  char *sep      =  NULL

   ;  subSpec *specList   =  NULL
   ;  int    n_spec  =  0
   ;  mcxBuf specBuf

   ;  int digits        =  MCLXIO_VALUE_GETENV
   ;  int a             =  1
   ;  int i             =  0
   ;  mcxbool bCltag    =  FALSE
   ;  mcxbool reread    =  FALSE
   ;  mcxbool map_rows_on_universe = TRUE
   ;  mcxbool map_cols_on_universe = TRUE
   ;  int rand_mode     =  'm'
   ;  unsigned int seed =  mcxSeed()
   ;  int n_arg_read    =  0

   ;  mcxstatus parseStatus = STATUS_OK
   ;  mcxOption* opts, *opt

   ;  srandom(seed)
   ;  mcxBufInit(&specBuf,  &specList, sizeof(subSpec), 30)

   ;  if (argc==1)
      {  mcxOptApropos(stdout, me, syntax, 20, MCX_OPT_DISPLAY_SKIP, options)
      ;  exit(0)
   ;  }

      mclxIOsetQMode("MCLXIOVERBOSITY", MCL_APP_VB_YES)

   ;  mcxOptAnchorSortById(options, sizeof(options)/sizeof(mcxOptAnchor) -1)

   ;  if
      (!(opts = mcxOptExhaust(options, (char**) argv, argc, 1, &n_arg_read, &parseStatus)))
      exit(0)

   ;  for (opt=opts;opt->anch;opt++)
      {  mcxOptAnchor* anch = opt->anch

      ;  switch(anch->id)
         {  case MY_OPT_HELP
         :  case MY_OPT_APROPOS
         :  mcxOptApropos(stdout, me, syntax, 20, MCX_OPT_DISPLAY_SKIP, options)
         ;  return 0
         ;

            case MY_OPT_VERSION
         :  app_report_version(me)
         ;  return 0
         ;

            case MY_OPT_IMX
         :  xfmx = mcxIOnew(opt->val, "r")
         ;  mcxIOopen(xfmx, EXIT_ON_FAIL)
         ;  break
         ;

            case MY_OPT_DOMAIN
         :  xfcl = mcxIOnew(opt->val, "r")
         ;  mcxIOopen(xfcl, EXIT_ON_FAIL)
         ;  break
         ;

            case MY_OPT_SPEC_DOMS
         :  map_rows_on_universe = FALSE
         ;  map_cols_on_universe = FALSE
         ;  break
         ;

            case MY_OPT_SPEC_COLS
         :  map_cols_on_universe = FALSE
         ;  break
         ;

            case MY_OPT_SPEC_ROWS
         :  map_rows_on_universe = FALSE
         ;  break
         ;

            case MY_OPT_STEM
         :  mcxTingWrite(fstem, opt->val)
         ;  break
         ;

            case MY_OPT_FROM_DISK
         :  reread = TRUE
         ;  break
         ;

            case MY_OPT_EFAC
         :  efac = atof(opt->val)
         ;  break
         ;

            case MY_OPT_DFAC
         :  dfac = atof(opt->val)
         ;  break
         ;

            case MY_OPT_RFAC
         :  rfac = atof(opt->val)
         ;  break
         ;

            case MY_OPT_CFAC
         :  cfac = atof(opt->val)
         ;  break
         ;

            case MY_OPT_RAND_DISCARD
         :  rand_mode = 'd'
         ;  break
         ;

            case MY_OPT_RAND_EXCLUSIVE
         :  rand_mode = 'e'
         ;  break
         ;

            case MY_OPT_RAND_INTERSECT
         :  rand_mode = 'i'
         ;  break
         ;

            case MY_OPT_RAND_MERGE
         :  rand_mode = 'm'
         ;  break
         ;

            case MY_OPT_TAGGED
         :  bCltag = TRUE
         ;  break
         ;

            case MY_OPT_TAG_DIGITS
         :  digits = atoi(argv[a])
         ;  break
      ;  }
      }

      if (n_arg_read+1 == argc)
      mcxDie(0, me, "no specs found")

   ;  for (a=1+n_arg_read;a<argc;a++)
      {  subSpec* spec =  (subSpec*) mcxBufExtend(&specBuf, 1, EXIT_ON_FAIL)
      ;  spec->specTxt        =  mcxTingNew(argv[a])
      ;  spec->tagTxt         =  NULL
      ;  spec->blockdiagonal  =  FALSE
      ;  spec->tagIsFname     =  FALSE
      ;  spec->lft            =  0
      ;  spec->rgt            =  0
      ;  spec->options        =  0
      ;  spec->selOptions     =  0
      ;  spec->mapOptions     =  0
      ;  spec->cvec           =  mclvInit(NULL)
      ;  spec->rvec           =  mclvInit(NULL)
   ;  }

      n_spec =  mcxBufFinalize(&specBuf)

   ;  if (!xfmx)
      {  mcxTell(me, "-imx flag is obligatory, see help (-h)")
      ;  mcxExit(1)
   ;  }
      else if (reread)
      {  universe_rows = mclvNew(NULL, 0)
      ;  universe_cols = mclvNew(NULL, 0)
      ;  if (mclxReadDomains(xfmx, universe_cols, universe_rows))
         mcxDie(1, me, "failed when reading domains")
      ;  mcxIOclose(xfmx)
   ;  }
      else
      {  mx    =  mclxRead(xfmx, EXIT_ON_FAIL)
      ;  universe_rows =  mclvClone(mx->dom_rows)
      ;  universe_cols =  mclvClone(mx->dom_cols)
   ;  }


      if (dfac)
      {  subspace_cols = mclvClone(universe_cols)
      ;  thin_out(subspace_cols, dfac)
      ;  if (mcldEquate(universe_rows, universe_cols, MCLD_EQ_EQUAL))
         subspace_rows = mclvClone(subspace_cols)
      ;  else
            subspace_rows = mclvClone(universe_rows)
         ,  thin_out(subspace_cols, dfac)
   ;  }
      else
      {  if (cfac)
            subspace_cols = mclvClone(universe_cols)
         ,  thin_out(subspace_cols, cfac)
      ;  if (rfac)
            subspace_rows = mclvClone(universe_rows)
         ,  thin_out(subspace_cols, rfac)
   ;  }


      if (xfcl)
      dom = mclxRead(xfcl, EXIT_ON_FAIL)

   ;  mcxIOclose(xfmx)
   ;  mcxIOfree(&xfcl)

   ;  if (bCltag)
      {  if (!dom)
         {  mcxErr(me, "option <--tag> requires <-dom> input")
         ;  mcxExit(1)
      ;  }
         el2dom = mclxTranspose(dom)
   ;  }

                                 /* fixme stick this in a routine */
      for (i=0;i<n_spec;i++)
      {  subSpec *spec = specList+i

      ;  mclVector *colvec = NULL
      ;  mclVector *rowvec = NULL

      ;  char *specStr = mcxTingStr(spec->specTxt)

      ;  char *rtag =  NULL, *ctag = NULL
            , *vtag =  NULL, *mtag = NULL, *btag  = NULL

      ;  char *rSpec=  NULL, *cSpec= NULL, *vSpec = NULL
            , *mSpec=  NULL, *bSpec= NULL

      ;  char rtype = '\0'
      ;  char ctype = '\0'

      ;  char *tagptr =  strchr(specStr, '#')

      ;  if (tagptr)
         {  *tagptr = '\0'
         ;  tagptr++

         ;  if (*tagptr == '#')
            {  spec->tagIsFname = TRUE
            ;  tagptr++
         ;  }
            spec->tagTxt = mcxTingNew(tagptr)
      ;  }
         else
         {  spec->tagTxt = mcxTingNew(spec->specTxt->str)
      ;  }
         
         /* vtag and mtag are easy to identify; hence they go first.
         */

         vtag = strstr(specStr, "v:")
      ;  mtag = strstr(specStr, "f:")
      ;  btag = strstr(specStr, "b:")

      ;  if (mtag)
            mSpec = mtag+2
         ,  *mtag = '\0'
      ;  if (vtag)
            vSpec = vtag+2
         ,  *vtag = '\0'
      ;  if (btag)
            bSpec = btag+2
         ,  *btag = '\0'
         ,  spec->blockdiagonal = TRUE

      ;  if (vtag)
         {  char* sep
         ;  while(1)
            {  if ((sep = strchr(vSpec, ',')))
               *sep = '\0'
            ;  if (!strncmp(vSpec, "gq", 2))
               {  spec->lft = atof(vSpec+2)
               ;  spec->selOptions |= MCLX_GQ
               ;  fprintf
                  (stdout, "[mcxsubs] selecting entries gq <%f>\n", spec->lft)
            ;  }
               else if (!strncmp(vSpec, "gt", 2))
               {  spec->lft = atof(vSpec+2)
               ;  spec->selOptions |= MCLX_GT
               ;  fprintf
                  (stdout, "[mcxsubs] selecting entries gt <%f>\n", spec->lft)
            ;  }
               else if (!strncmp(vSpec, "lt", 2))
               {  spec->rgt = atof(vSpec+2)
               ;  spec->selOptions |= MCLX_LT
               ;  fprintf
                  (stdout, "[mcxsubs] selecting entries lt <%f>\n", spec->rgt)
            ;  }
               else if (!strncmp(vSpec, "lq", 2))
               {  spec->rgt = atof(vSpec+2)
               ;  spec->selOptions |= MCLX_LQ
               ;  fprintf
                  (stdout, "[mcxsubs] selecting entries lq <%f>\n", spec->rgt)
            ;  }
               if (sep)
               vSpec = sep+1
            ;  else
               break
         ;  }
         }

         if (mtag)
         {  char* sep
         ;  while(1)
            {  if ((sep = strchr(mSpec, ',')))
               *sep = '\0'
            ;  if (!strncmp(mSpec, "md", 2))
               spec->mapOptions |= (MAP_COLS | MAP_ROWS)
            ;  else if (!strncmp(mSpec, "mr", 2))
               spec->mapOptions |= MAP_ROWS
            ;  else if (!strncmp(mSpec, "mc", 2))
               spec->mapOptions |= MAP_COLS
            ;  else if (!strncmp(mSpec, "tp", 2))
               spec->options |= DO_TP
            ;  else if (!strncmp(mSpec, "cc", 2))
               spec->options |= DO_CC

            ;  if (sep)
               mSpec = sep+1
            ;  else
               break
         ;  }
         }

         /* next find ctag and rtag. just search for cCrR.
          * the r in 'f:mr' if present is now hidden
         */

      ;  ctag              =  strpbrk(specStr, "cC")
      ;  rtag              =  strpbrk(specStr, "rR")

         /* next remove syntactic sugar, if present
         */

      ;  sep = specStr
      ;  while ((sep = strchr(sep, '_')))
         {  *sep = '\0'
         ;  sep++
      ;  }

         if (ctag)
         {  ctype          =  *ctag
         ;  if (!(cSpec = strchr(ctag+1, ':')))
            {  mcxErr(me, "cannot find <:> tag after <%c> tag", (int) ctype)
            ;  mcxExit(1)
         ;  }
            cSpec++
      ;  }

         if (rtag)
         {  rtype          =  *rtag
         ;  if (!(rSpec = strchr(rtag+1, ':')))
            {  mcxErr(me, "cannot find <:> tag after <%c> tag", (int) rtype)
            ;  mcxExit(1)
         ;  }
            rSpec++
      ;  }

         /* set these at this stage, not earlier.
          * because we need to recognize cr: and rc: etc.
         */

         if (rtag)
         *rtag = '\0'
      ;  if (ctag)
         *ctag = '\0'

      ;  if (ctag)
         {  fprintf(stdout, "[%s] parsing column poly-spec <%s>\n", me, cSpec)
         ;  colvec = VectorFromString(cSpec, dom, universe_cols)
         ;  if (ctype == 'C')
            colvec = mcldMinus(universe_cols, colvec, colvec)
      ;  }
         else
         {  colvec = mclvRenew(colvec, universe_cols->ivps, universe_cols->n_ivps)
      ;  }

         if (rtag)
         {  fprintf(stdout, "[%s] parsing row poly-spec <%s>\n", me, rSpec)
         ;  rowvec = VectorFromString(rSpec, dom, universe_rows)
         ;  if (rtype == 'R')
            rowvec = mcldMinus(universe_rows, rowvec, rowvec)
      ;  }
         else
         {  rowvec = mclvRenew(rowvec, universe_rows->ivps, universe_rows->n_ivps)
      ;  }

         if (subspace_cols)
         {  if (rand_mode == 'd')      /* discard */
            mcldMinus(colvec, subspace_cols, colvec)
         ;  else if (rand_mode == 'e')
            mcldMinus(subspace_cols, colvec, colvec)
         ;  else if (rand_mode == 'i')
            mcldMeet(subspace_cols, colvec, colvec)
         ;  else
            mcldMerge(colvec, subspace_cols, colvec)
      ;  }

         if (subspace_rows)
         {  if (rand_mode == 'd')
            mcldMinus(rowvec, subspace_rows, rowvec)
         ;  else if (rand_mode == 'e')
            mcldMinus(subspace_rows, rowvec, rowvec)
         ;  else if (rand_mode == 'i')
            mcldMeet(subspace_rows, rowvec, rowvec)
         ;  else
            mcldMerge(rowvec, subspace_rows, rowvec)
      ;  }

         if (map_cols_on_universe)
         {  mcldMeet(colvec, universe_cols, colvec)
         ;  mcldMeet(colvec, universe_cols, colvec)
      ;  }
         if (map_rows_on_universe)
         {  mcldMeet(rowvec, universe_rows, rowvec)
         ;  mcldMeet(rowvec, universe_rows, rowvec)
      ;  }

         spec->cvec = colvec
      ;  spec->rvec = rowvec  /* need some kind of check here on colvec, rowvec ?? */
   ;  }

      for (i=0;i<n_spec;i++)
      {  mclMatrix* sub

      ;  subSpec* spec   =  specList+i
      ;  mcxTing* tagTxt =  (specList+i)->tagTxt

      ;  mcxTing *fname  =  spec->tagIsFname
                            ?  mcxTingInit(NULL)
                            :  mcxTingNew(fstem->str)
      ;  mcxIO *xf

      ;  mcxTingAppend(fname, tagTxt->str)
      ;  xf    =  mcxIOnew(fname->str, "w")

      ;  if (mcxIOopen(xf, RETURN_ON_FAIL) == STATUS_FAIL)
         {  mcxErr
            (me, "cannot open file <%s> for writing! Ignoring", xf->fn->str)
         ;  mcxTingFree(&fname)
         ;  mcxIOfree(&xf)
         ;  continue          /* fixme; make error continuation reusable */
      ;  }

         if (reread)          /* fixme; blocks not yet supported */
         sub = mclxSubRead
               (  xfmx
               ,  mclvClone(spec->cvec)
               ,  mclvClone(spec->rvec)
               ,  EXIT_ON_FAIL
               )
         ,  mcxIOclose(xfmx)
      ;  else if  (spec->blockdiagonal && dom)
         sub =  mclxBlocks(mx, dom)
      ;  else                 /* fixme: must check subness */
         sub =  mclxSub(mx, spec->cvec, spec->rvec)

      ;  if (spec->mapOptions & MAP_COLS)
         mclxMapCols(sub, NULL)

      ;  if (spec->mapOptions & MAP_ROWS)
         mclxMapRows(sub, NULL)

      ;  if (spec->selOptions)
         mclxSelectValues
         (  sub
         ,  spec->selOptions & (MCLX_GQ | MCLX_GT) ? &(spec->lft) : NULL
         ,  spec->selOptions & (MCLX_LQ | MCLX_LT) ? &(spec->rgt) : NULL
         ,  spec->selOptions
         )

      ;  if (spec->options & DO_TP)
         {  mclMatrix* subt = mclxTranspose(sub)
         ;  mclxFree(&sub)
         ;  sub = subt
      ;  }

      ;  if (spec->options & DO_CC)
         mclxMakeCharacteristic(sub)

      ;  if (bCltag)
         mclxTaggedWrite(sub, el2dom, xf, digits, RETURN_ON_FAIL)
      ;  else
         mclxWrite(sub, xf, MCLXIO_VALUE_GETENV, RETURN_ON_FAIL)

      ;  mclxFree(&sub)
      ;  mcxTingFree(&fname)
      ;  mcxIOfree(&xf)
   ;  }
      mclxFree(&el2dom)
   ;  return 0
;  }


mclVector*  VectorFromString
(  const char*    str
,  mclMatrix*     dom
,  mclVector*     universe
)
   {  mcxTing*     txt     =     mcxTingNew(str)
   ;  char*       mystr    =     mcxTingStr(txt)
   ;  char*       iptr     =     strpbrk(mystr, "iI")
   ;  char*       sptr     =     strpbrk(mystr, "dD")
   ;  mclVector   *ivec    =     NULL
   ;  mclVector   *svec    =     mclvInit(NULL)     /* domain Vector */
   ;  mclVector   *subvec  =     NULL

   ;  char        itype    =     '\0'
   ;  char        stype    =     '\0'

   ;  if (iptr)
      {  itype =  *iptr
      ;  *iptr =  '\0'
   ;  }
      if (sptr)
      {  stype =  *sptr
      ;  *sptr =  '\0'
   ;  }


   ;  if (txt->len && !iptr && !sptr)
      mcxErr
      (  me
      ,  "warning: no 'i', 'I', 'd', or 'D' tag in specification <%s>"
      ,  txt->str
      )

   ;  if (iptr)
      {  mcxIL *intList
      ;  fprintf
         (  stdout
         ,  "[mcxsubs] Parsing simple index set [%c%s]\n"
         ,  (int) itype
         ,  iptr+1
         )

      ;  intList  =  ilParseIntSet(iptr+1, MCLV_MAXID(universe), EXIT_ON_FAIL)
      ;  ivec     =  mclvFromIlist(NULL, intList, 1.0)
      ;  ilFree(&intList)
      ;  if (itype == 'I')
         ivec =  mcldMinus(universe, ivec, ivec)
   ;  }
      else
      ivec = mclvInit(NULL)


   ;  if (sptr)
      {  int   x
      ;  mcxIL *clsList

      ;  fprintf
         (  stdout
         ,  "[mcxsubs] Parsing domain index set [%c%s]\n"
         ,  (int) stype
         ,  sptr+1
         )

      ;  if (!dom)
         {  mcxErr(me, "{d|D}<idx-list> specification requires <-dom> input")
         ;  mcxExit(1)
      ;  }

         clsList = ilParseIntSet(sptr+1, MCLV_MAXID(dom->dom_cols),EXIT_ON_FAIL)

      ;  for (x=0;x<clsList->n;x++)
         {  long idx = *(clsList->L+x)
         ;  mclVector* vec
            =     idx == -1
               ?  dom->dom_rows
               :     idx == -2
                  ?  dom->dom_cols
                  :  mclxGetVector(dom, idx, RETURN_ON_FAIL, NULL)
         ;  if (!vec)
            {  mcxErr
               (  me
               ,  "<%ld> does not index any column (domain error)"
               ,  (long) idx
               )
            ;  mcxExit(1)
         ;  }
            svec  =  mcldMerge(svec, vec, svec)
      ;  }
         ilFree(&clsList)

      ;  if (stype == 'D')
         svec =  mcldMinus(universe, svec, svec)
   ;  }

      subvec =  mcldMerge(ivec, svec, subvec)
   ;  mclvFree(&ivec)
   ;  mclvFree(&svec)
   ;  return(subvec)
;  }

