/*  This file is part of the KDE project
    Copyright (C) 2000 Simon Hausmann <hausmann@kde.org>
    Copyright (C) 2001 Dirk Mueller <mueller@kde.org>
    Copyright (C) 2003 Luciano Montanaro <mikelima@cirulla.net>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include <signal.h>

#include "slave.h"

#include <kdebug.h>

#include <signal.h>

using namespace KIO;

Slave::Slave( Connection *conn, pid_t pid )
    : SlaveInterface( conn )
{
    m_pid = pid;
    conn->connect( this, SLOT( slotDispatch() ) );
}

Slave::~Slave()
{
    kdDebug() << "Slave::~Slave()" << endl;
#if !defined(Q_WS_WIN)
    if ( connection()->inited() ) {
        int infd = connection()->fd_from();
        int outfd = connection()->fd_to();
        connection()->close();
        ::close( infd );
        ::close( outfd );
    }   
#endif

    // ###
    delete connection();
}

void Slave::slotDispatch()
{
    //    kdDebug() << "Slave::slotDispatch()" << endl;
    if ( !dispatch() )
    {
	qDebug( "Slave::slotDispatch() : abort!" );
        connection()->close();

        // ### FIXME!
//        emit slaveDied( this ); // this will make the scheduler delete us
    }
}

void Slave::kill()
{
    kdDebug() << "Slave::kill()" << endl;
    qDebug( "Slave::kill()" );
#if defined(Q_WS_WIN)
    connection()->sendnow( CMD_DISCONNECT );
#else
    if ( m_pid )
        ::kill( m_pid, SIGTERM );
#endif
}

void Slave::setConfig( const MetaData &config )
{
    QByteArray data;
    QDataStream stream( data, IO_WriteOnly );
    stream << config;
    send( CMD_CONFIG, data );
}

void Slave::suspend()
{
	connection()->suspend();
}

void Slave::resume()
{
	connection()->resume();
}

#include "slave.moc"
