/*  This file is part of the KDE project
    Copyright (C) 2000 David Faure <faure@kde.org>
    Copyright (C) 2000 Simon Hausmann <hausmann@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "kglobalsettings.h"

#include "kglobal.h"
#include "klocale.h"
#include <kcharsets.h>

QFont *KGlobalSettings::s_generalFont = 0;
QFont *KGlobalSettings::s_fixedFont = 0;

QFont KGlobalSettings::generalFont()
{
    if ( s_generalFont )
        return *s_generalFont;

    s_generalFont = new QFont( "helvetica", 12 );
    s_generalFont->setPixelSize( 12 );
    s_generalFont->setStyleHint( QFont::SansSerif );

#if 0 // QT_VERSION < 300 && defined(Q_WS_X11)
    KGlobal::charsets()->setQFont( *s_generalFont, KGlobal::locale()->charset() );
#endif

    return *s_generalFont;
}

QFont KGlobalSettings::fixedFont()
{
    if ( s_fixedFont )
        return *s_fixedFont;

    s_fixedFont = new QFont( "courier", 12 );
    s_fixedFont->setPixelSize( 12 );
    s_fixedFont->setStyleHint( QFont::TypeWriter );

#if 0 && QT_VERSION < 300 && defined(Q_WS_X11)
    KGlobal::charsets()->setQFont( *s_fixedFont, KGlobal::locale()->charset() );
#endif

    return *s_fixedFont;
}
