/* This file is part of the KDE libraries
    Copyright (C) 2003 Luciano Montanaro <mikelima@cirulla.net>
    Copyright (C) 2002 Paul Chitescu <Paul.Chitescu@IMC-Group.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/
#include <config.h>

#if defined(ENABLE_JS_HOSTEXTEND)

#include "jsextension.h"
#include "jsextconnect.h"

#include <kjs/object.h>
#include <kjs/types.h>
#include <kjs/interpreter.h>

#include <qlist.h>

static QPtrList<void> js_extensions;

namespace KJS {

    void addJsExtension( const JsHostExtend ext )
    {
	js_extensions.append( (void *)ext );
    }

    void probeJsExtension(ExecState* exec, 
	    KParts::ReadOnlyPart *part, const KURL &url, 
	    const QString &mimetype, ObjectImp *imp )
    {
#if QT_VERSION < 300
	QListIterator<void> it( js_extensions );
#else
	QPtrListIterator<void> it( js_extensions );
#endif

	KJS::Object hostobj(imp);
	for ( ; it.current(); ++it )
	    ( (JsHostExtend)(it.current()) ) (exec, part, url, mimetype, hostobj );
    }

}

#endif // ENABLE_JS_HOSTEXTEND
