/*
 * Copyright (c) 2001-2006 International Computer Science Institute
 * See LICENSE file for licensing, conditions, and warranties on use.
 *
 * DO NOT EDIT THIS FILE - IT IS PROGRAMMATICALLY GENERATED
 *
 * Generated by 'tgt-gen'.
 *
 * $XORP: xorp/xrl/targets/mld6igmp_base.hh,v 1.30 2006/07/03 23:33:42 pavlin Exp $
 */


#ifndef __XRL_TARGETS_MLD6IGMP_BASE_HH__
#define __XRL_TARGETS_MLD6IGMP_BASE_HH__

#undef XORP_LIBRARY_NAME
#define XORP_LIBRARY_NAME "XrlMld6igmpTarget"

#include "libxorp/xlog.h"
#include "libxipc/xrl_cmd_map.hh"

class XrlMld6igmpTargetBase {
protected:
    XrlCmdMap* _cmds;

public:
    /**
     * Constructor.
     *
     * @param cmds an XrlCmdMap that the commands associated with the target
     *		   should be added to.  This is typically the XrlRouter
     *		   associated with the target.
     */
    XrlMld6igmpTargetBase(XrlCmdMap* cmds = 0);

    /**
     * Destructor.
     *
     * Dissociates instance commands from command map.
     */
    virtual ~XrlMld6igmpTargetBase();

    /**
     * Set command map.
     *
     * @param cmds pointer to command map to associate commands with.  This
     * argument is typically a pointer to the XrlRouter associated with the
     * target.
     *
     * @return true on success, false if cmds is null or a command map has
     * already been supplied.
     */
    bool set_command_map(XrlCmdMap* cmds);

    /**
     * Get Xrl instance name associated with command map.
     */
    inline const string& name() const { return _cmds->name(); }

    /**
     * Get version string of instance.
     */
    inline const char* version() const { return "mld6igmp/0.0"; }

protected:

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Get name of Xrl Target
     */
    virtual XrlCmdError common_0_1_get_target_name(
	// Output values,
	string&	name) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Get version string from Xrl Target
     */
    virtual XrlCmdError common_0_1_get_version(
	// Output values,
	string&	version) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Get status of Xrl Target
     */
    virtual XrlCmdError common_0_1_get_status(
	// Output values,
	uint32_t&	status,
	string&	reason) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Request clean shutdown of Xrl Target
     */
    virtual XrlCmdError common_0_1_shutdown() = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Process a CLI command.
     *
     *  @param processor_name the processor name for this command.
     *
     *  @param cli_term_name the terminal name the command was entered from.
     *
     *  @param cli_session_id the CLI session ID the command was entered from.
     *
     *  @param command_name the command name to process.
     *
     *  @param command_args the command arguments to process.
     *
     *  @param ret_processor_name the processor name to return back to the CLI.
     *
     *  @param ret_cli_term_name the terminal name to return back.
     *
     *  @param ret_cli_session_id the CLI session ID to return back.
     *
     *  @param ret_command_output the command output to return back.
     */
    virtual XrlCmdError cli_processor_0_1_process_command(
	// Input values,
	const string&	processor_name,
	const string&	cli_term_name,
	const uint32_t&	cli_session_id,
	const string&	command_name,
	const string&	command_args,
	// Output values,
	string&	ret_processor_name,
	string&	ret_cli_term_name,
	uint32_t&	ret_cli_session_id,
	string&	ret_command_output) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Announce target birth to observer.
     *
     *  @param target_class the target class name.
     *
     *  @param target_instance the target instance name.
     */
    virtual XrlCmdError finder_event_observer_0_1_xrl_target_birth(
	// Input values,
	const string&	target_class,
	const string&	target_instance) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Announce target death to observer.
     *
     *  @param target_class the target class name.
     *
     *  @param target_instance the target instance name.
     */
    virtual XrlCmdError finder_event_observer_0_1_xrl_target_death(
	// Input values,
	const string&	target_class,
	const string&	target_instance) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Add a new vif.
     *
     *  @param vif_name the name of the new vif.
     *
     *  @param vif_index the index of the new vif.
     */
    virtual XrlCmdError mfea_client_0_1_new_vif(
	// Input values,
	const string&	vif_name,
	const uint32_t&	vif_index) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Delete an existing vif.
     *
     *  @param vif_name the name of the vif to delete.
     */
    virtual XrlCmdError mfea_client_0_1_delete_vif(
	// Input values,
	const string&	vif_name) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Add an address to a vif.
     *
     *  @param vif_name the name of the vif.
     *
     *  @param addr the unicast address to add.
     *
     *  @param subnet the subnet address to add.
     *
     *  @param broadcast the broadcast address (when applicable).
     *
     *  @param peer the peer address (when applicable).
     */
    virtual XrlCmdError mfea_client_0_1_add_vif_addr4(
	// Input values,
	const string&	vif_name,
	const IPv4&	addr,
	const IPv4Net&	subnet,
	const IPv4&	broadcast,
	const IPv4&	peer) = 0;

    virtual XrlCmdError mfea_client_0_1_add_vif_addr6(
	// Input values,
	const string&	vif_name,
	const IPv6&	addr,
	const IPv6Net&	subnet,
	const IPv6&	broadcast,
	const IPv6&	peer) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Delete an address from a vif.
     *
     *  @param vif_name the name of the vif.
     *
     *  @param addr the unicast address to delete.
     */
    virtual XrlCmdError mfea_client_0_1_delete_vif_addr4(
	// Input values,
	const string&	vif_name,
	const IPv4&	addr) = 0;

    virtual XrlCmdError mfea_client_0_1_delete_vif_addr6(
	// Input values,
	const string&	vif_name,
	const IPv6&	addr) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Set flags to a vif.
     *
     *  @param vif_name the name of the vif.
     *
     *  @param is_pim_register true if this is a PIM Register vif.
     *
     *  @param is_p2p true if this is a point-to-point vif.
     *
     *  @param is_loopback true if this is a loopback interface.
     *
     *  @param is_multicast true if the vif is multicast-capable.
     *
     *  @param is_broadcast true if the vif is broadcast-capable.
     *
     *  @param is_up true if the vif is UP and running.
     *
     *  @param mtu the MTU of the vif.
     */
    virtual XrlCmdError mfea_client_0_1_set_vif_flags(
	// Input values,
	const string&	vif_name,
	const bool&	is_pim_register,
	const bool&	is_p2p,
	const bool&	is_loopback,
	const bool&	is_multicast,
	const bool&	is_broadcast,
	const bool&	is_up,
	const uint32_t&	mtu) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Complete all transactions with vif information.
     */
    virtual XrlCmdError mfea_client_0_1_set_all_vifs_done() = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Test if the vif setup is completed.
     *
     *  @param is_completed if true the vif setup is completed.
     */
    virtual XrlCmdError mfea_client_0_1_is_vif_setup_completed(
	// Output values,
	bool&	is_completed) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Receive a protocol message from the MFEA.
     *
     *  @param xrl_sender_name the XRL name of the originator of this XRL.
     *
     *  @param protocol_name the name of the protocol that sends a message.
     *
     *  @param protocol_id the ID of the protocol that sends a message (both
     *  sides must agree on the particular values).
     *
     *  @param vif_name the name of the vif the message was received on.
     *
     *  @param vif_index the index of the vif the message was received on.
     *
     *  @param source_address the address of the sender.
     *
     *  @param dest_address the destination address.
     *
     *  @param ip_ttl the TTL of the received IP packet. If it has a negative
     *  value, it should be ignored.
     *
     *  @param ip_tos the TOS of the received IP packet. If it has a negative
     *  value, it should be ignored.
     *
     *  @param is_router_alert if true, the IP Router Alert option in the IP
     *  packet was set (when applicable).
     *
     *  @param protocol_message the protocol message.
     */
    virtual XrlCmdError mfea_client_0_1_recv_protocol_message4(
	// Input values,
	const string&	xrl_sender_name,
	const string&	protocol_name,
	const uint32_t&	protocol_id,
	const string&	vif_name,
	const uint32_t&	vif_index,
	const IPv4&	source_address,
	const IPv4&	dest_address,
	const int32_t&	ip_ttl,
	const int32_t&	ip_tos,
	const bool&	is_router_alert,
	const vector<uint8_t>&	protocol_message) = 0;

    virtual XrlCmdError mfea_client_0_1_recv_protocol_message6(
	// Input values,
	const string&	xrl_sender_name,
	const string&	protocol_name,
	const uint32_t&	protocol_id,
	const string&	vif_name,
	const uint32_t&	vif_index,
	const IPv6&	source_address,
	const IPv6&	dest_address,
	const int32_t&	ip_ttl,
	const int32_t&	ip_tos,
	const bool&	is_router_alert,
	const vector<uint8_t>&	protocol_message) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Receive a kernel signal message from the MFEA.
     *
     *  @param xrl_sender_name the XRL name of the originator of this XRL.
     *
     *  @param protocol_name the name of the protocol that sends a message.
     *
     *  @param protocol_id the ID of the protocol that sends a message (both
     *  sides must agree on the particular values).
     *
     *  @param message_type the type of the kernel signal message (TODO:
     *  integer for now: the particular types are well-known by both sides).
     *
     *  @param vif_name the name of the vif the message was received on.
     *
     *  @param vif_index the index of the vif the message was received on.
     *
     *  @param source_address the address of the sender.
     *
     *  @param dest_address the destination address.
     *
     *  @param protocol_message the protocol message.
     */
    virtual XrlCmdError mfea_client_0_1_recv_kernel_signal_message4(
	// Input values,
	const string&	xrl_sender_name,
	const string&	protocol_name,
	const uint32_t&	protocol_id,
	const uint32_t&	message_type,
	const string&	vif_name,
	const uint32_t&	vif_index,
	const IPv4&	source_address,
	const IPv4&	dest_address,
	const vector<uint8_t>&	protocol_message) = 0;

    virtual XrlCmdError mfea_client_0_1_recv_kernel_signal_message6(
	// Input values,
	const string&	xrl_sender_name,
	const string&	protocol_name,
	const uint32_t&	protocol_id,
	const uint32_t&	message_type,
	const string&	vif_name,
	const uint32_t&	vif_index,
	const IPv6&	source_address,
	const IPv6&	dest_address,
	const vector<uint8_t>&	protocol_message) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  A signal that a dataflow-related pre-condition is true.
     *
     *  @param xrl_sender_name the XRL name of the originator of this XRL.
     *
     *  @param source_address the source address of the dataflow.
     *
     *  @param group_address the group address of the dataflow.
     *
     *  @param threshold_interval_sec the number of seconds in the interval
     *  requested for measurement.
     *
     *  @param threshold_interval_usec the number of microseconds in the
     *  interval requested for measurement.
     *
     *  @param measured_interval_sec the number of seconds in the last measured
     *  interval that has triggered the signal.
     *
     *  @param measured_interval_usec the number of microseconds in the last
     *  measured interval that has triggered the signal.
     *
     *  @param threshold_packets the threshold value to trigger a signal (in
     *  number of packets).
     *
     *  @param threshold_bytes the threshold value to trigger a signal (in
     *  bytes).
     *
     *  @param measured_packets the number of packets measured within the
     *  measured interval.
     *
     *  @param measured_bytes the number of bytes measured within the measured
     *  interval.
     *
     *  @param is_threshold_in_packets if true, threshold_packets is valid.
     *
     *  @param is_threshold_in_bytes if true, threshold_bytes is valid.
     *
     *  @param is_geq_upcall if true, the operation for comparison is ">=".
     *
     *  @param is_leq_upcall if true, the operation for comparison is "<=".
     */
    virtual XrlCmdError mfea_client_0_1_recv_dataflow_signal4(
	// Input values,
	const string&	xrl_sender_name,
	const IPv4&	source_address,
	const IPv4&	group_address,
	const uint32_t&	threshold_interval_sec,
	const uint32_t&	threshold_interval_usec,
	const uint32_t&	measured_interval_sec,
	const uint32_t&	measured_interval_usec,
	const uint32_t&	threshold_packets,
	const uint32_t&	threshold_bytes,
	const uint32_t&	measured_packets,
	const uint32_t&	measured_bytes,
	const bool&	is_threshold_in_packets,
	const bool&	is_threshold_in_bytes,
	const bool&	is_geq_upcall,
	const bool&	is_leq_upcall) = 0;

    virtual XrlCmdError mfea_client_0_1_recv_dataflow_signal6(
	// Input values,
	const string&	xrl_sender_name,
	const IPv6&	source_address,
	const IPv6&	group_address,
	const uint32_t&	threshold_interval_sec,
	const uint32_t&	threshold_interval_usec,
	const uint32_t&	measured_interval_sec,
	const uint32_t&	measured_interval_usec,
	const uint32_t&	threshold_packets,
	const uint32_t&	threshold_bytes,
	const uint32_t&	measured_packets,
	const uint32_t&	measured_bytes,
	const bool&	is_threshold_in_packets,
	const bool&	is_threshold_in_bytes,
	const bool&	is_geq_upcall,
	const bool&	is_leq_upcall) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Enable/disable/start/stop a MLD6IGMP vif interface.
     *
     *  @param vif_name the name of the vif to enable/disable/start/stop.
     *
     *  @param enable if true, then enable the vif, otherwise disable it.
     */
    virtual XrlCmdError mld6igmp_0_1_enable_vif(
	// Input values,
	const string&	vif_name,
	const bool&	enable) = 0;

    virtual XrlCmdError mld6igmp_0_1_start_vif(
	// Input values,
	const string&	vif_name) = 0;

    virtual XrlCmdError mld6igmp_0_1_stop_vif(
	// Input values,
	const string&	vif_name) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Enable/disable/start/stop all MLD6IGMP vif interfaces.
     *
     *  @param enable if true, then enable the vifs, otherwise disable them.
     */
    virtual XrlCmdError mld6igmp_0_1_enable_all_vifs(
	// Input values,
	const bool&	enable) = 0;

    virtual XrlCmdError mld6igmp_0_1_start_all_vifs() = 0;

    virtual XrlCmdError mld6igmp_0_1_stop_all_vifs() = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Enable/disable/start/stop the MLD6IGMP protocol.
     *
     *  @param enable if true, then enable the MLD6IGMP protocol, otherwise
     *  disable it.
     */
    virtual XrlCmdError mld6igmp_0_1_enable_mld6igmp(
	// Input values,
	const bool&	enable) = 0;

    virtual XrlCmdError mld6igmp_0_1_start_mld6igmp() = 0;

    virtual XrlCmdError mld6igmp_0_1_stop_mld6igmp() = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Enable/disable/start/stop the MLD6IGMP CLI access.
     *
     *  @param enable if true, then enable the MLD6IGMP CLI access, otherwise
     *  disable it.
     */
    virtual XrlCmdError mld6igmp_0_1_enable_cli(
	// Input values,
	const bool&	enable) = 0;

    virtual XrlCmdError mld6igmp_0_1_start_cli() = 0;

    virtual XrlCmdError mld6igmp_0_1_stop_cli() = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Get the configured protocol version per interface.
     *
     *  @param vif_name the name of the vif to apply to.
     *
     *  @param proto_version the protocol version.
     */
    virtual XrlCmdError mld6igmp_0_1_get_vif_proto_version(
	// Input values,
	const string&	vif_name,
	// Output values,
	uint32_t&	proto_version) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Set the protocol version per interface.
     *
     *  @param vif_name the name of the vif to apply to.
     *
     *  @param proto_version the protocol version.
     */
    virtual XrlCmdError mld6igmp_0_1_set_vif_proto_version(
	// Input values,
	const string&	vif_name,
	const uint32_t&	proto_version) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Reset the protocol version per interface to its default value.
     *
     *  @param vif_name the name of the vif to apply to.
     */
    virtual XrlCmdError mld6igmp_0_1_reset_vif_proto_version(
	// Input values,
	const string&	vif_name) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Get the IP Router Alert option check per interface for received
     *  packets.
     *
     *  @param vif_name the name of the vif to apply to.
     *
     *  @param enabled if true, then the IP Router Alert option check was
     *  enabled, otherwise it was disabled.
     */
    virtual XrlCmdError mld6igmp_0_1_get_vif_ip_router_alert_option_check(
	// Input values,
	const string&	vif_name,
	// Output values,
	bool&	enabled) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Set the IP Router Alert option check per interface for received
     *  packets.
     *
     *  @param vif_name the name of the vif to apply to.
     *
     *  @param enable if true, then enable the IP Router Alert option check,
     *  otherwise disable it.
     */
    virtual XrlCmdError mld6igmp_0_1_set_vif_ip_router_alert_option_check(
	// Input values,
	const string&	vif_name,
	const bool&	enable) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Reset the IP Router Alert option check for received packets per per
     *  interface to its default value.
     *
     *  @param vif_name the name of the vif to apply to.
     */
    virtual XrlCmdError mld6igmp_0_1_reset_vif_ip_router_alert_option_check(
	// Input values,
	const string&	vif_name) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Get the Query Interval per interface.
     *
     *  @param vif_name the name of the vif to apply to.
     *
     *  @param interval_sec the number of seconds in the interval.
     *
     *  @param interval_usec the number of microseconds (in addition to
     *  interval_sec) in the interval.
     */
    virtual XrlCmdError mld6igmp_0_1_get_vif_query_interval(
	// Input values,
	const string&	vif_name,
	// Output values,
	uint32_t&	interval_sec,
	uint32_t&	interval_usec) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Set the Query Interval per interface.
     *
     *  @param vif_name the name of the vif to apply to.
     *
     *  @param interval_sec the number of seconds in the interval.
     *
     *  @param interval_usec the number of microseconds (in addition to
     *  interval_sec) in the interval.
     */
    virtual XrlCmdError mld6igmp_0_1_set_vif_query_interval(
	// Input values,
	const string&	vif_name,
	const uint32_t&	interval_sec,
	const uint32_t&	interval_usec) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Reset the Query Interval per interface to its default value.
     *
     *  @param vif_name the name of the vif to apply to.
     */
    virtual XrlCmdError mld6igmp_0_1_reset_vif_query_interval(
	// Input values,
	const string&	vif_name) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Get the Last Member Query Interval per interface.
     *
     *  @param vif_name the name of the vif to apply to.
     *
     *  @param interval_sec the number of seconds in the interval.
     *
     *  @param interval_usec the number of microseconds (in addition to
     *  interval_sec) in the interval.
     */
    virtual XrlCmdError mld6igmp_0_1_get_vif_query_last_member_interval(
	// Input values,
	const string&	vif_name,
	// Output values,
	uint32_t&	interval_sec,
	uint32_t&	interval_usec) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Set the Last Member Query Interval per interface.
     *
     *  @param vif_name the name of the vif to apply to.
     *
     *  @param interval_sec the number of seconds in the interval.
     *
     *  @param interval_usec the number of microseconds (in addition to
     *  interval_sec) in the interval.
     */
    virtual XrlCmdError mld6igmp_0_1_set_vif_query_last_member_interval(
	// Input values,
	const string&	vif_name,
	const uint32_t&	interval_sec,
	const uint32_t&	interval_usec) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Reset the Last Member Query Interval per interface to its default
     *  value.
     *
     *  @param vif_name the name of the vif to apply to.
     */
    virtual XrlCmdError mld6igmp_0_1_reset_vif_query_last_member_interval(
	// Input values,
	const string&	vif_name) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Get the Query Response Interval per interface.
     *
     *  @param vif_name the name of the vif to apply to.
     *
     *  @param interval_sec the number of seconds in the interval.
     *
     *  @param interval_usec the number of microseconds (in addition to
     *  interval_sec) in the interval.
     */
    virtual XrlCmdError mld6igmp_0_1_get_vif_query_response_interval(
	// Input values,
	const string&	vif_name,
	// Output values,
	uint32_t&	interval_sec,
	uint32_t&	interval_usec) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Set the Query Response Interval per interface.
     *
     *  @param vif_name the name of the vif to apply to.
     *
     *  @param interval_sec the number of seconds in the interval.
     *
     *  @param interval_usec the number of microseconds (in addition to
     *  interval_sec) in the interval.
     */
    virtual XrlCmdError mld6igmp_0_1_set_vif_query_response_interval(
	// Input values,
	const string&	vif_name,
	const uint32_t&	interval_sec,
	const uint32_t&	interval_usec) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Reset the Query Response Interval per interface to its default value.
     *
     *  @param vif_name the name of the vif to apply to.
     */
    virtual XrlCmdError mld6igmp_0_1_reset_vif_query_response_interval(
	// Input values,
	const string&	vif_name) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Get the Robustness Variable count per interface.
     *
     *  @param vif_name the name of the vif to apply to.
     *
     *  @param robust_count the count value.
     */
    virtual XrlCmdError mld6igmp_0_1_get_vif_robust_count(
	// Input values,
	const string&	vif_name,
	// Output values,
	uint32_t&	robust_count) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Set the Robustness Variable count per interface.
     *
     *  @param vif_name the name of the vif to apply to.
     *
     *  @param robust_count the count value.
     */
    virtual XrlCmdError mld6igmp_0_1_set_vif_robust_count(
	// Input values,
	const string&	vif_name,
	const uint32_t&	robust_count) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Reset the Robustness Variable count per interface to its default value.
     *
     *  @param vif_name the name of the vif to apply to.
     */
    virtual XrlCmdError mld6igmp_0_1_reset_vif_robust_count(
	// Input values,
	const string&	vif_name) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Enable/disable the MLD6IGMP trace log for all operations.
     *
     *  @param enable if true, then enable the trace log, otherwise disable it.
     */
    virtual XrlCmdError mld6igmp_0_1_log_trace_all(
	// Input values,
	const bool&	enable) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Add/delete a client protocol in the MLD/IGMP protocol.
     *
     *  @param xrl_sender_name the XRL name of the originator of this XRL.
     *
     *  @param protocol_name the name of the protocol to add/delete.
     *
     *  @param protocol_id the ID of the protocol to add/delete (both sides
     *  must agree on the particular values).
     *
     *  @param vif_name the name of the vif the protocol add/delete to apply
     *  to.
     *
     *  @param vif_index the index of the vif the protocol add/delete to apply
     *  to. The added protocol will receive Join/Leave membership information
     *  about same-LAN members for the particular vif.
     */
    virtual XrlCmdError mld6igmp_0_1_add_protocol4(
	// Input values,
	const string&	xrl_sender_name,
	const string&	protocol_name,
	const uint32_t&	protocol_id,
	const string&	vif_name,
	const uint32_t&	vif_index) = 0;

    virtual XrlCmdError mld6igmp_0_1_add_protocol6(
	// Input values,
	const string&	xrl_sender_name,
	const string&	protocol_name,
	const uint32_t&	protocol_id,
	const string&	vif_name,
	const uint32_t&	vif_index) = 0;

    virtual XrlCmdError mld6igmp_0_1_delete_protocol4(
	// Input values,
	const string&	xrl_sender_name,
	const string&	protocol_name,
	const uint32_t&	protocol_id,
	const string&	vif_name,
	const uint32_t&	vif_index) = 0;

    virtual XrlCmdError mld6igmp_0_1_delete_protocol6(
	// Input values,
	const string&	xrl_sender_name,
	const string&	protocol_name,
	const uint32_t&	protocol_id,
	const string&	vif_name,
	const uint32_t&	vif_index) = 0;

private:
    const XrlCmdError handle_common_0_1_get_target_name(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_common_0_1_get_version(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_common_0_1_get_status(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_common_0_1_shutdown(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_cli_processor_0_1_process_command(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_finder_event_observer_0_1_xrl_target_birth(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_finder_event_observer_0_1_xrl_target_death(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_mfea_client_0_1_new_vif(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_mfea_client_0_1_delete_vif(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_mfea_client_0_1_add_vif_addr4(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_mfea_client_0_1_add_vif_addr6(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_mfea_client_0_1_delete_vif_addr4(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_mfea_client_0_1_delete_vif_addr6(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_mfea_client_0_1_set_vif_flags(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_mfea_client_0_1_set_all_vifs_done(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_mfea_client_0_1_is_vif_setup_completed(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_mfea_client_0_1_recv_protocol_message4(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_mfea_client_0_1_recv_protocol_message6(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_mfea_client_0_1_recv_kernel_signal_message4(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_mfea_client_0_1_recv_kernel_signal_message6(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_mfea_client_0_1_recv_dataflow_signal4(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_mfea_client_0_1_recv_dataflow_signal6(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_mld6igmp_0_1_enable_vif(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_mld6igmp_0_1_start_vif(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_mld6igmp_0_1_stop_vif(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_mld6igmp_0_1_enable_all_vifs(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_mld6igmp_0_1_start_all_vifs(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_mld6igmp_0_1_stop_all_vifs(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_mld6igmp_0_1_enable_mld6igmp(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_mld6igmp_0_1_start_mld6igmp(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_mld6igmp_0_1_stop_mld6igmp(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_mld6igmp_0_1_enable_cli(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_mld6igmp_0_1_start_cli(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_mld6igmp_0_1_stop_cli(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_mld6igmp_0_1_get_vif_proto_version(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_mld6igmp_0_1_set_vif_proto_version(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_mld6igmp_0_1_reset_vif_proto_version(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_mld6igmp_0_1_get_vif_ip_router_alert_option_check(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_mld6igmp_0_1_set_vif_ip_router_alert_option_check(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_mld6igmp_0_1_reset_vif_ip_router_alert_option_check(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_mld6igmp_0_1_get_vif_query_interval(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_mld6igmp_0_1_set_vif_query_interval(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_mld6igmp_0_1_reset_vif_query_interval(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_mld6igmp_0_1_get_vif_query_last_member_interval(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_mld6igmp_0_1_set_vif_query_last_member_interval(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_mld6igmp_0_1_reset_vif_query_last_member_interval(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_mld6igmp_0_1_get_vif_query_response_interval(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_mld6igmp_0_1_set_vif_query_response_interval(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_mld6igmp_0_1_reset_vif_query_response_interval(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_mld6igmp_0_1_get_vif_robust_count(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_mld6igmp_0_1_set_vif_robust_count(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_mld6igmp_0_1_reset_vif_robust_count(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_mld6igmp_0_1_log_trace_all(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_mld6igmp_0_1_add_protocol4(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_mld6igmp_0_1_add_protocol6(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_mld6igmp_0_1_delete_protocol4(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_mld6igmp_0_1_delete_protocol6(const XrlArgs& in, XrlArgs* out);

    void add_handlers();
    void remove_handlers();
};

#endif // __XRL_TARGETS_MLD6IGMP_BASE_HH__
