/* logjam - a GTK client for LiveJournal.
 * Copyright (C) 2000-2002 Evan Martin <evan@livejournal.com>
 *
 * vim: tabstop=4 shiftwidth=4 noexpandtab :
 * $Id: conf.h,v 1.15 2002/11/26 09:39:16 martine Exp $
 */

#ifndef CONF_H
#define CONF_H

#include <gtk/gtktooltips.h>
/* structures for representing logjam data. 
 * livejournal-specific structures are in ljtypes.h.
 */ 
#include "config.h"
#include "ljtypes.h"
#include "checkfriends.h"

typedef struct {
	int x, y, width, height;
} Geometry;

/* this should match the array in conf_xml.c */
typedef enum {
	GEOM_MAIN,
	GEOM_LOGIN,
	GEOM_FRIENDS,
	GEOM_FRIENDGROUPS,
	GEOM_CONSOLE,
	GEOM_MANAGER,
	GEOM_CFFLOAT,
	GEOM_COUNT
} GeometryType;

typedef struct {
	char *name;
	char *url;

	GList *users;
	User *usercur;

	GList *moods;
} Server;

typedef struct {
	gboolean revertusejournal;
	gboolean netdump;
	gboolean nofork;
	gboolean useproxy;
	gboolean useproxyauth;
#ifdef HAVE_GTKSPELL
	gboolean usespellcheck;
#endif
	gboolean keepmetadata;
	gboolean autosave;
	gboolean noautologin;
	gboolean cfautostart;
	gboolean cfusemask;
	gboolean cfautofloat;
	gboolean cfautofloatraise;
	gboolean cffloat_decorate;
	gboolean friends_statsvis, friends_filtervis;
} Options;

enum {
	POSTMODE_GUI,
	POSTMODE_CMD
} PostmodeType;

typedef struct {
	/* configuration file */
	GList *servers;
	Server *servercur;

	Geometry geometries[GEOM_COUNT];

	Options options;

	gchar *uifont;

	char *spawn_command;

	char *proxy;
	char *proxyuser, *proxypass;

	Security defaultsecurity;

	gchar *cfmask;
	gint cfuserinterval;
	gint cfthreshold;

	/* run-time settings. */
	gboolean loginok;
	char *usejournal;
	int postmode;
} Configuration;

typedef struct {
	gchar *programname;
	gchar *conf_dir;        /* may be null, which means <home>/.logjam/ */

	GtkTooltips *tooltips;
	GSList *secmgr_list;
	GSList *cfmgr_list;

	GList *quiet_dlgs;

	CFIndicator *cfi_float;

	gboolean cli;           /* true if there's no gui */
	gboolean quiet;

	gboolean autosave_ok;      /* TRUE by default, disabled in cli mode */
	gboolean autoloaddraft_ok; /* TRUE by default, unset by -f and -e */
	gint autosave;          /* timeout id */
} Application;

char*    conf_nid_by_id(GList *l, int id);
int      conf_nid_by_name(GList *l, const char* name);
int      conf_nid_compare_alpha(NameIDHash *a, NameIDHash *b);
void     conf_nid_free(NameIDHash *nid);

User*    conf_user_by_username(Server *server, const char *username);
void     conf_server_add_user(Server *server, User *user);
Server*  conf_server_by_name(Configuration *c, const char *servername);

int      conf_read(Configuration *c);
int      conf_write(Configuration *c);

int      conf_mood_get_last_cached(Server *server);

extern Configuration conf;
extern Application app;
#define conf_cur_server() conf.servercur
#define conf_cur_user() conf_cur_server()->usercur
#define conf_mood_id_from_name(name) conf_nid_by_name(conf_cur_server()->moods, name)
#define conf_mood_name_from_id(id) conf_nid_by_id(conf_cur_server()->moods, id)

int conf_verify_dir(void);
void conf_make_path(const char *file, char *buf, size_t maxlen);

void conf_verify_a_server_exists();

#endif /* CONF_H */
