/* logjam - a GTK client for LiveJournal.
 * Copyright (C) 2000-2002 Evan Martin <evan@livejournal.com>
 *
 * vim: tabstop=4 shiftwidth=4 noexpandtab :
 * $Id: checkfriends.h,v 1.6 2002/09/17 21:28:30 martine Exp $
 */

#ifndef checkfriends_h
#define checkfriends_h

#include <gtk/gtkwidget.h>

typedef enum {
	CF_DISABLED,
	CF_ON,
	CF_NEW
} CFState;

typedef struct {
	GtkWidget   *menu;
	GtkWidget   *check_onoff;
	GtkWidget   *check_float;
} CFContextMenu;

typedef struct {
	GtkWidget   *parent;          /* controlling LJWin */
	GSList      *indicators;      /* controlled CFIndicators */
	gint         server_interval; /* minimum poll interval dictated by server */
	gint         user_interval;   /* poll interval requested by user */
	gchar       *mask;            /* mask of friendd groups to check for */
#ifdef NOTYET
	gchar       *usejournal       /* journal to check friends for */
#endif
	CFState      state;           /* activity status of this cf manager */
	gint         newcount;        /* number of NEW hits; for thresholding */
	gchar       *lastupdate;      /* opaque server-owned lastupdate tag */
	gint         errors;          /* number of (network?) errors withstood */
	guint        timeout;         /* handle on glib timeout for next check */
} CFMgr;

typedef enum {
	CF_MAIN = 0x71,
	CF_FLOATING,

	/* reserved */
	CF_ICON,
	CF_SYSTRAY
} CFIndicatorStyle;

typedef struct {
	gint              id;       /* XXX: is this needed? */
	CFIndicatorStyle  style;
	CFMgr            *cfmgr;    /* manager (CF business logic) */
	GtkWidget        *parent;   /* parent (GUI) */
	
	GtkWidget        *box;      /* container for indicator */
	GtkWidget        *button;
	GtkWidget        *image;
	GtkWidget        *floatwin; /* for CF_FLOATING style only */
} CFIndicator;

static const gint CF_MAXERRORS = 3;
static const gint CF_AUTOSCHED = -1;
static const gint CF_MAX_THRESHOLD = 7;

CFMgr* cfmgr_new(void);
CFIndicator* cfindicator_new(CFMgr *cfm, CFIndicatorStyle style, GtkWidget *parent);
void cfmgr_set_state(CFMgr *cfm, CFState state);

void cf_threshold_normalize(gint *threshold);
GtkWidget* cfindicator_box_get(CFIndicator *ind);
void cfmgr_refresh_images(CFMgr *cfm);
void cf_context_menu(CFIndicator *cfi, GdkEventButton *event);
void cf_float_destroy(CFIndicator *cfi);
CFIndicator* make_cf_float(CFMgr *cfm, GtkWidget *parent);
gboolean checkfriends_cli(gchar *ljid);
void checkfriends_cli_purge(gchar *ljid);
void cf_float_decorate_refresh(void);
void cfmgr_parent_set(CFMgr *cfm, GtkWidget *parent);
void cfmgr_mask_set(CFMgr *cfm, gchar *maskstr);

#endif /* checkfriends_h */
