#include <string.h>

#include "fetchnews.h"
#include "system.h"
#include "leafnode.h"

/* send DATE command to upstream server and complain if the clocks are
 * more than 15 minutes apart.
 */
void
check_date(const struct server *current_server)
{
    int reply;
    struct tm tm;
    time_t t, to;
    const int tolerate = 10;
    const char *lastline = lastreply();

    strcpy(lineout, "DATE\r\n");
    putaline();
    reply = nntpreply(current_server);
    if (reply != 111) {
	/* upstream does not support the DATE command, so ignore */
	if (debugmode) {
	    syslog(LOG_DEBUG, "check_date: %s: does not support DATE, "
		    "reply %d, expected 111", current_server->name, reply);
	}
	return;
    }

    if (lastline == NULL) {
	if (debugmode) {
	    syslog(LOG_DEBUG, "check_date: %s: cannot parse lastline (NULL)",
		    current_server->name);
	}
	return;
    }


    /* upstream supports the DATE command */
    if (sscanf(lastline, "%*d %4d%2d%2d%2d%2d%2d",
		&tm.tm_year, &tm.tm_mon, &tm.tm_mday,
		&tm.tm_hour, &tm.tm_min, &tm.tm_sec) < 6) {
	/* too few fields */
	if (debugmode) {
	    syslog(LOG_DEBUG, "check_date: %s: too few fields in DATE reply "
		    "\"%s\"", current_server->name, lastline);
	}
	return;
    }

    /* we can match 6 fields, parse date */
    tm.tm_year -= 1900;
    tm.tm_mon -= 1;
    tm.tm_isdst = -1; /* let libc figure time zone offset */
    t = mktime(&tm);
    if (t == (time_t) - 1) {
	/* error, ignore */
	syslog(LOG_INFO, "check_date: %s: upstream sends unparsable reply "
		"to DATE, mktime failed. \"%s\"", current_server->name, lastline);
	return;
    }

    /* mktime assumes local time zone, compensate */
    t += gmtoff(t);

    if (labs((long)(t - time(&to))) > tolerate * 60 || t - to > LONG_MAX || to - t > LONG_MAX) {
	syslog(LOG_WARNING, "check_date: %s: clocks of upstream and this computer are more than %d minutes apart. Check your system clock.", current_server->name, tolerate);
	printf("check_date: %s: clocks of upstream and this computer are more than\n%d minutes apart. Check your system clock.\n", current_server->name, tolerate);
    } else {
	if (debugmode) {
	syslog(LOG_DEBUG, "check_date: %s: server time %ld, our time %ld",
		current_server->name, (long)t, (long)to);
	}
    }
}


