/*
 * critmem.c -- memory allocation that only returns on success
 *
 * (C) 2000 - 2002 by Matthias Andree <matthias.andree@gmx.de>
 * Backport of critstrdup courtesy of Ralf Wildenhues <ralf.wildenhues@gmx.de>
 *
 * ---------------------------------------------------------------------------
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2 or 2.1 of
 * the License. See the file COPYING.LGPL for details.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "critmem.h"
#include <stdio.h>
#include <stdlib.h>
#include <syslog.h>
#include <string.h>

/*
 * replacement for malloc, syslogs allocation failures
 * and exits with the error message
 */
char *
critmalloc(size_t size, const char *message)
{
    char *a;

    a = (char *)malloc(size);
    /* we don't want to return NULL, not even for size == 0 */
    if (!a && size == 0)
	a = (char *)malloc(1);
    if (!a) {
	syslog(LOG_ERR, "malloc(%d) failed: %s", (int)size, message);
	fprintf(stderr, "malloc(%d) failed: %s\n", (int)size, message);
	exit(1);
    }
    return a;
}

/*
 * replacement for realloc, syslogs allocation failures
 * and exits with the error message
 */
char *
critrealloc(char *a, size_t size, const char *message)
{
    char *b = (char *)realloc(a, size);
    if (!b && size != 0) {
	syslog(LOG_ERR, "realloc(%d) failed: %s", (int)size, message);
	fprintf(stderr, "realloc(%d) failed: %s\n", (int)size, message);
	exit(1);
    }
    return b;
}

/*
 * replacement for malloc, logs allocation failures
 * and exits with the error message
 */
char *
critstrdup(const char *source, const char *message)
{
    char *a;

    a = (char *)critmalloc(strlen(source) + 1, message);
    strcpy(a, source);		/* RATS: ignore */
    return a;
}
