/*
** msx.c : driver for MSX
**
** Todo:
** - Add support for other MSX models (de,fr,jp,ru etc.)
*/

#include "driver.h"
#include "vidhrdw/generic.h"
#include "machine/8255ppi.h"
#include "vidhrdw/tms9928a.h"
#include "vidhrdw/v9938.h"
#include "includes/msx_slot.h"
#include "includes/msx.h"
#include "devices/basicdsk.h"
#include "devices/printer.h"
#include "devices/cartslot.h"
#include "devices/cassette.h"
#include "formats/fmsx_cas.h"
#include "sound/ay8910.h"

static ADDRESS_MAP_START (readmem, ADDRESS_SPACE_PROGRAM, 8)
	AM_RANGE( 0x0000, 0x1fff) AM_READ( MRA8_BANK1 )
	AM_RANGE( 0x2000, 0x3fff) AM_READ( MRA8_BANK2 )
	AM_RANGE( 0x4000, 0x5fff) AM_READ( MRA8_BANK3 )
	AM_RANGE( 0x6000, 0x7ff7) AM_READ( MRA8_BANK4 )
	AM_RANGE( 0x7ff8, 0x7fff) AM_READ( MRA8_BANK5 )
	AM_RANGE( 0x8000, 0x97ff) AM_READ( MRA8_BANK6 )
	AM_RANGE( 0x9800, 0x9fff) AM_READ( MRA8_BANK7 )
	AM_RANGE( 0xa000, 0xb7ff) AM_READ( MRA8_BANK8 )
	AM_RANGE( 0xb800, 0xbfff) AM_READ( MRA8_BANK9 )
	AM_RANGE( 0xc000, 0xdfff) AM_READ( MRA8_BANK10 )
	AM_RANGE( 0xe000, 0xfffe) AM_READ( MRA8_BANK11 )
	AM_RANGE( 0xffff, 0xffff) AM_READ( msx_sec_slot_r )
ADDRESS_MAP_END

static ADDRESS_MAP_START( writemem , ADDRESS_SPACE_PROGRAM, 8)
	AM_RANGE( 0x0000, 0x0000) AM_WRITE( msx_superloadrunner_w )
	AM_RANGE( 0x0001, 0x3fff) AM_WRITE( msx_page0_w )
	AM_RANGE( 0x4000, 0x7fff) AM_WRITE( msx_page1_w )
	AM_RANGE( 0x8000, 0xbfff) AM_WRITE( msx_page2_w )
	AM_RANGE( 0xc000, 0xfffe) AM_WRITE( msx_page3_w )
	AM_RANGE( 0xffff, 0xffff) AM_WRITE( msx_sec_slot_w )
ADDRESS_MAP_END


static ADDRESS_MAP_START (readport, ADDRESS_SPACE_IO, 8)
	ADDRESS_MAP_FLAGS( AMEF_UNMAP(0xff) )
	ADDRESS_MAP_FLAGS( AMEF_ABITS(8) )
	AM_RANGE( 0x90, 0x91) AM_READ( msx_printer_r )
	AM_RANGE( 0xa0, 0xa7) AM_READ( msx_psg_r )
	AM_RANGE( 0xa8, 0xab) AM_READ( ppi8255_0_r )
	AM_RANGE( 0x98, 0x98) AM_READ( TMS9928A_vram_r )
	AM_RANGE( 0x99, 0x99) AM_READ( TMS9928A_register_r )
	AM_RANGE( 0xd9, 0xd9) AM_READ( msx_kanji_r )
ADDRESS_MAP_END

static ADDRESS_MAP_START (writeport, ADDRESS_SPACE_IO, 8)
	ADDRESS_MAP_FLAGS( AMEF_ABITS(8) )
	AM_RANGE( 0x77, 0x77) AM_WRITE( msx_90in1_w )
	AM_RANGE( 0x7c, 0x7d) AM_WRITE( msx_fmpac_w )
	AM_RANGE( 0x90, 0x91) AM_WRITE( msx_printer_w )
	AM_RANGE( 0xa0, 0xa7) AM_WRITE( msx_psg_w )
	AM_RANGE( 0xa8, 0xab) AM_WRITE( ppi8255_0_w )
	AM_RANGE( 0x98, 0x98) AM_WRITE( TMS9928A_vram_w )
	AM_RANGE( 0x99, 0x99) AM_WRITE( TMS9928A_register_w )
	AM_RANGE( 0xd8, 0xd9) AM_WRITE( msx_kanji_w )
ADDRESS_MAP_END

static ADDRESS_MAP_START (readport2, ADDRESS_SPACE_IO, 8)
	ADDRESS_MAP_FLAGS( AMEF_UNMAP(0xff) )
	ADDRESS_MAP_FLAGS( AMEF_ABITS(8) )
	AM_RANGE( 0x90, 0x91) AM_READ( msx_printer_r )
	AM_RANGE( 0xa0, 0xa7) AM_READ( msx_psg_r )
	AM_RANGE( 0xa8, 0xab) AM_READ( ppi8255_0_r )
	AM_RANGE( 0x98, 0x98) AM_READ( v9938_vram_r )
	AM_RANGE( 0x99, 0x99) AM_READ( v9938_status_r )
	AM_RANGE( 0xb5, 0xb5) AM_READ( msx_rtc_reg_r )
	AM_RANGE( 0xd9, 0xd9) AM_READ( msx_kanji_r )
	AM_RANGE( 0xfc, 0xff) AM_READ( msx_ram_mapper_r )
ADDRESS_MAP_END

static ADDRESS_MAP_START (writeport2, ADDRESS_SPACE_IO, 8)
	ADDRESS_MAP_FLAGS( AMEF_ABITS(8) )
	AM_RANGE( 0x77, 0x77) AM_WRITE( msx_90in1_w )
	AM_RANGE( 0x7c, 0x7d) AM_WRITE( msx_fmpac_w )
	AM_RANGE( 0x90, 0x91) AM_WRITE( msx_printer_w )
	AM_RANGE( 0xa0, 0xa7) AM_WRITE( msx_psg_w )
	AM_RANGE( 0xa8, 0xab) AM_WRITE( ppi8255_0_w )
	AM_RANGE( 0x98, 0x98) AM_WRITE( v9938_vram_w )
	AM_RANGE( 0x99, 0x99) AM_WRITE( v9938_command_w )
	AM_RANGE( 0x9a, 0x9a) AM_WRITE( v9938_palette_w )
	AM_RANGE( 0x9b, 0x9b) AM_WRITE( v9938_register_w )
	AM_RANGE( 0xb4, 0xb4) AM_WRITE( msx_rtc_latch_w )
	AM_RANGE( 0xb5, 0xb5) AM_WRITE( msx_rtc_reg_w )
	AM_RANGE( 0xd8, 0xd9) AM_WRITE( msx_kanji_w )
	AM_RANGE( 0xfc, 0xff) AM_WRITE( msx_ram_mapper_w )
ADDRESS_MAP_END

/* start define for the special ports (DIPS, joystick, mouse) */
static INPUT_PORTS_START( msx_dips )
	PORT_START /* 6 */
	PORT_BIT (0x01, IP_ACTIVE_LOW, IPT_JOYSTICK_UP)
	PORT_BIT (0x02, IP_ACTIVE_LOW, IPT_JOYSTICK_DOWN)
	PORT_BIT (0x04, IP_ACTIVE_LOW, IPT_JOYSTICK_LEFT)
	PORT_BIT (0x08, IP_ACTIVE_LOW, IPT_JOYSTICK_RIGHT)
	PORT_BIT (0x10, IP_ACTIVE_LOW, IPT_BUTTON1)
	PORT_BIT (0x20, IP_ACTIVE_LOW, IPT_BUTTON2)
	PORT_BIT (0x40, IP_ACTIVE_LOW, IPT_UNUSED)
	PORT_DIPNAME( 0x80, 0, "Game port 1")
	PORT_DIPSETTING(    0x00, DEF_STR( Joystick ))
	PORT_DIPSETTING(    0x80, "Mouse")

	PORT_START /* 7 */
	PORT_BIT (0x01, IP_ACTIVE_LOW, IPT_JOYSTICK_UP)     PORT_PLAYER(2)
	PORT_BIT (0x02, IP_ACTIVE_LOW, IPT_JOYSTICK_DOWN)	  PORT_PLAYER(2)
	PORT_BIT (0x04, IP_ACTIVE_LOW, IPT_JOYSTICK_LEFT)	  PORT_PLAYER(2)
	PORT_BIT (0x08, IP_ACTIVE_LOW, IPT_JOYSTICK_RIGHT)	   PORT_PLAYER(2)
	PORT_BIT (0x10, IP_ACTIVE_LOW, IPT_BUTTON1)     PORT_PLAYER(2)
	PORT_BIT (0x20, IP_ACTIVE_LOW, IPT_BUTTON2)     PORT_PLAYER(2)
	PORT_BIT (0x40, IP_ACTIVE_LOW, IPT_UNUSED)
	PORT_DIPNAME( 0x80, 0, "Game port 2")
	PORT_DIPSETTING( 0x00, DEF_STR( Joystick ))
	PORT_DIPSETTING( 0x80, "Mouse")

	PORT_START /* 8 */
	PORT_DIPNAME( 0x40, 0, "Swap game port 1 and 2")
	PORT_DIPSETTING( 0, DEF_STR( No ) )
	PORT_DIPSETTING( 0x40, DEF_STR( Yes ) )
	PORT_DIPNAME( 0x80, 0, "SIMPL")
	PORT_DIPSETTING( 0x00, DEF_STR ( Off ) )
	PORT_DIPSETTING( 0x80, DEF_STR ( On ) )
	PORT_DIPNAME( 0x20, 0x20, "Enforce 4/8 sprites/line")
	PORT_DIPSETTING( 0, DEF_STR( No ) )
	PORT_DIPSETTING( 0x20, DEF_STR( Yes ) )
	PORT_DIPNAME ( 0x03, 0, "Render resolution")
	PORT_DIPSETTING( 0, DEF_STR( High ))
	PORT_DIPSETTING( 1, DEF_STR( Low ))
	PORT_DIPSETTING( 2, "Auto" )

	PORT_START /* 9 */
	PORT_BIT( 0xff00, 0x00, IPT_TRACKBALL_X) PORT_SENSITIVITY(100) PORT_KEYDELTA(0) PORT_MINMAX(0,0) PORT_PLAYER(1)
	PORT_BIT( 0x00ff, 0x00, IPT_TRACKBALL_Y) PORT_SENSITIVITY(100) PORT_KEYDELTA(0) PORT_MINMAX(0,0) PORT_PLAYER(1)

	PORT_START /* 10 */
	PORT_BIT( 0xff00, 0x00, IPT_TRACKBALL_X) PORT_SENSITIVITY(100) PORT_KEYDELTA(0) PORT_MINMAX(0,0) PORT_PLAYER(2)
	PORT_BIT( 0x00ff, 0x00, IPT_TRACKBALL_Y) PORT_SENSITIVITY(100) PORT_KEYDELTA(0) PORT_MINMAX(0,0) PORT_PLAYER(2)
	/* end define for the special ports (DIPS, joystick, mouse) */
INPUT_PORTS_END


#define KEYB_ROW0	\
  PORT_BIT (0x0001, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("0 )") PORT_CODE(KEYCODE_0)	\
  PORT_BIT (0x0002, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("1 !") PORT_CODE(KEYCODE_1)	\
  PORT_BIT (0x0004, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("2 @") PORT_CODE(KEYCODE_2)	\
  PORT_BIT (0x0008, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("3 #") PORT_CODE(KEYCODE_3)	\
  PORT_BIT (0x0010, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("4 $") PORT_CODE(KEYCODE_4)	\
  PORT_BIT (0x0020, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("5 %") PORT_CODE(KEYCODE_5)	\
  PORT_BIT (0x0040, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("6 ^") PORT_CODE(KEYCODE_6)	\
  PORT_BIT (0x0080, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("7 &") PORT_CODE(KEYCODE_7)

#define KEYB_EXPERT11_ROW0	 \
  PORT_BIT (0x0001, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("0 )") PORT_CODE(KEYCODE_0)	\
  PORT_BIT (0x0002, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("1 !") PORT_CODE(KEYCODE_1)	\
  PORT_BIT (0x0004, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("2 \"") PORT_CODE(KEYCODE_2)	 \
  PORT_BIT (0x0008, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("3 #") PORT_CODE(KEYCODE_3)	\
  PORT_BIT (0x0010, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("4 $") PORT_CODE(KEYCODE_4)	\
  PORT_BIT (0x0020, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("5 %") PORT_CODE(KEYCODE_5)	\
  PORT_BIT (0x0040, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("6 ^") PORT_CODE(KEYCODE_6)	\
  PORT_BIT (0x0080, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("7 &") PORT_CODE(KEYCODE_7)

#define KEYB_HOTBIT_ROW0   \
  PORT_BIT (0x0001, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("0 )") PORT_CODE(KEYCODE_0)	\
  PORT_BIT (0x0002, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("1 !") PORT_CODE(KEYCODE_1)	\
  PORT_BIT (0x0004, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("2 @") PORT_CODE(KEYCODE_2)	\
  PORT_BIT (0x0008, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("3 #") PORT_CODE(KEYCODE_3)	\
  PORT_BIT (0x0010, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("4 $") PORT_CODE(KEYCODE_4)	\
  PORT_BIT (0x0020, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("5 %") PORT_CODE(KEYCODE_5)	\
  PORT_BIT (0x0040, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("6 \"") PORT_CODE(KEYCODE_6)	 \
  PORT_BIT (0x0080, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("7 &") PORT_CODE(KEYCODE_7)

#define KEYB_ROW1	\
  PORT_BIT (0x0100, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("8 *") PORT_CODE(KEYCODE_8)	\
  PORT_BIT (0x0200, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("9 (") PORT_CODE(KEYCODE_9)	\
  PORT_BIT (0x0400, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("- _") PORT_CODE(KEYCODE_MINUS)	\
  PORT_BIT (0x0800, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("= +") PORT_CODE(KEYCODE_EQUALS)	\
  PORT_BIT (0x1000, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("\\ |") PORT_CODE(KEYCODE_BACKSLASH)	\
  PORT_BIT (0x2000, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("[ {") PORT_CODE(KEYCODE_OPENBRACE)	\
  PORT_BIT (0x4000, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("] }") PORT_CODE(KEYCODE_CLOSEBRACE)	\
  PORT_BIT (0x8000, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("; :") PORT_CODE(KEYCODE_COLON)

#define KEYB_HOTBIT_ROW1   \
  PORT_BIT (0x0100, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("8 *") PORT_CODE(KEYCODE_8)	\
  PORT_BIT (0x0200, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("9 (") PORT_CODE(KEYCODE_9)	\
  PORT_BIT (0x0400, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("- _") PORT_CODE(KEYCODE_MINUS)	\
  PORT_BIT (0x0800, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("= +") PORT_CODE(KEYCODE_EQUALS)	\
  PORT_BIT (0x1000, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("\\ ^") PORT_CODE(KEYCODE_BACKSLASH)	\
  PORT_BIT (0x2000, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("' `") PORT_CODE(KEYCODE_QUOTE)	\
  PORT_BIT (0x4000, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("\" `") PORT_CODE(KEYCODE_BACKSLASH2)	 \
  PORT_BIT (0x8000, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("\xc7 \xe7") PORT_CODE(KEYCODE_ASTERISK)

#define KEYB_EXPERT11_ROW1	 \
  PORT_BIT (0x0100, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("8 '") PORT_CODE(KEYCODE_8)	\
  PORT_BIT (0x0200, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("9 (") PORT_CODE(KEYCODE_9)	\
  PORT_BIT (0x0400, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("- _") PORT_CODE(KEYCODE_MINUS)	\
  PORT_BIT (0x0800, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("= +") PORT_CODE(KEYCODE_EQUALS)	\
  PORT_BIT (0x1000, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("{ }") PORT_CODE(KEYCODE_OPENBRACE)   \
  PORT_BIT (0x2000, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("' `") PORT_CODE(KEYCODE_QUOTE)	\
  PORT_BIT (0x4000, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("[ ]") PORT_CODE(KEYCODE_CLOSEBRACE)	\
  PORT_BIT (0x8000, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("~ ^") PORT_CODE(KEYCODE_TILDE)

#define KEYB_ROW2	\
  PORT_BIT (0x0001, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("' \"") PORT_CODE(KEYCODE_QUOTE)	\
  PORT_BIT (0x0002, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("` ~") PORT_CODE(KEYCODE_TILDE)	\
  PORT_BIT (0x0004, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME(", <") PORT_CODE(KEYCODE_COMMA)	\
  PORT_BIT (0x0008, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME(". >") PORT_CODE(KEYCODE_STOP)		\
  PORT_BIT (0x0010, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("/ ?") PORT_CODE(KEYCODE_SLASH)	\
  PORT_BIT (0x0020, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("Dead Key")	\
  PORT_BIT (0x0040, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("a A") PORT_CODE(KEYCODE_A)	\
  PORT_BIT (0x0080, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("b B") PORT_CODE(KEYCODE_B)

#define KEYB_HOTBIT_ROW2   \
  PORT_BIT (0x0001, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("~ ^") PORT_CODE(KEYCODE_TILDE)   \
  PORT_BIT (0x0002, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("[ ]") PORT_CODE(KEYCODE_OPENBRACE)	\
  PORT_BIT (0x0004, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME(", ;") PORT_CODE(KEYCODE_COMMA)	\
  PORT_BIT (0x0008, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME(". :") PORT_CODE(KEYCODE_STOP)		\
  PORT_BIT (0x0010, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("/ ?") PORT_CODE(KEYCODE_SLASH)	\
  PORT_BIT (0x0020, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("< >") PORT_CODE(KEYCODE_CLOSEBRACE)	 \
  PORT_BIT (0x0040, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("a A") PORT_CODE(KEYCODE_A)	\
  PORT_BIT (0x0080, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("b B") PORT_CODE(KEYCODE_B)

#define KEYB_EXPERT10_ROW2	 \
  PORT_BIT (0x0001, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("' \"") PORT_CODE(KEYCODE_QUOTE)	\
  PORT_BIT (0x0002, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("\xc7 \xe7") PORT_CODE(KEYCODE_TILDE)	  \
  PORT_BIT (0x0004, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME(", <") PORT_CODE(KEYCODE_COMMA)	\
  PORT_BIT (0x0008, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME(". >") PORT_CODE(KEYCODE_STOP)		\
  PORT_BIT (0x0010, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("/ ?") PORT_CODE(KEYCODE_SLASH)	\
  PORT_BIT (0x0020, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("Dead Key")	\
  PORT_BIT (0x0040, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("a A") PORT_CODE(KEYCODE_A)	\
  PORT_BIT (0x0080, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("b B") PORT_CODE(KEYCODE_B)

#define KEYB_EXPERT11_ROW2	 \
  PORT_BIT (0x0001, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("* @") PORT_CODE(KEYCODE_ASTERISK)   \
  PORT_BIT (0x0002, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("\xc7 \xe7") PORT_CODE(KEYCODE_BACKSLASH)	  \
  PORT_BIT (0x0004, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME(", <") PORT_CODE(KEYCODE_COMMA)	\
  PORT_BIT (0x0008, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME(". >") PORT_CODE(KEYCODE_STOP)		\
  PORT_BIT (0x0010, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("/ ?") PORT_CODE(KEYCODE_SLASH)	\
  PORT_BIT (0x0020, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME(": ;") PORT_CODE(KEYCODE_COLON)	\
  PORT_BIT (0x0040, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("a A") PORT_CODE(KEYCODE_A)	\
  PORT_BIT (0x0080, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("b B") PORT_CODE(KEYCODE_B)

#define KEYB_ROW3	\
  PORT_BIT (0x0100, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("c C") PORT_CODE(KEYCODE_C)	\
  PORT_BIT (0x0200, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("d D") PORT_CODE(KEYCODE_D)	\
  PORT_BIT (0x0400, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("e E") PORT_CODE(KEYCODE_E)	\
  PORT_BIT (0x0800, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("f F") PORT_CODE(KEYCODE_F)	\
  PORT_BIT (0x1000, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("g G") PORT_CODE(KEYCODE_G)	\
  PORT_BIT (0x2000, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("h H") PORT_CODE(KEYCODE_H)	\
  PORT_BIT (0x4000, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("i I") PORT_CODE(KEYCODE_I)	\
  PORT_BIT (0x8000, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("j J") PORT_CODE(KEYCODE_J)

#define KEYB_ROW4	\
  PORT_BIT (0x0001, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("k K") PORT_CODE(KEYCODE_K)	\
  PORT_BIT (0x0002, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("l L") PORT_CODE(KEYCODE_L)	\
  PORT_BIT (0x0004, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("m M") PORT_CODE(KEYCODE_M)	\
  PORT_BIT (0x0008, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("n N") PORT_CODE(KEYCODE_N)	\
  PORT_BIT (0x0010, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("o O") PORT_CODE(KEYCODE_O)	\
  PORT_BIT (0x0020, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("p P") PORT_CODE(KEYCODE_P)	\
  PORT_BIT (0x0040, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("q Q") PORT_CODE(KEYCODE_Q)	\
  PORT_BIT (0x0080, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("r R") PORT_CODE(KEYCODE_R)

#define KEYB_ROW5	\
  PORT_BIT (0x0100, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("s S") PORT_CODE(KEYCODE_S)	\
  PORT_BIT (0x0200, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("t T") PORT_CODE(KEYCODE_T)	\
  PORT_BIT (0x0400, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("u U") PORT_CODE(KEYCODE_U)	\
  PORT_BIT (0x0800, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("v V") PORT_CODE(KEYCODE_V)	\
  PORT_BIT (0x1000, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("w W") PORT_CODE(KEYCODE_W)	\
  PORT_BIT (0x2000, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("x X") PORT_CODE(KEYCODE_X)	\
  PORT_BIT (0x4000, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("y Y") PORT_CODE(KEYCODE_Y)	\
  PORT_BIT (0x8000, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("z Z") PORT_CODE(KEYCODE_Z)

#define KEYB_ROW6	\
  PORT_BIT (0x0001, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("SHIFT") PORT_CODE(KEYCODE_LSHIFT)	\
  PORT_BIT (0x0002, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("CTRL") PORT_CODE(KEYCODE_LCONTROL)	\
  PORT_BIT (0x0004, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("GRAPH") PORT_CODE(KEYCODE_PGUP)	\
  PORT_BIT (0x0008, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("CAPS") PORT_CODE(KEYCODE_CAPSLOCK)	\
  PORT_BIT (0x0010, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("CODE") PORT_CODE(KEYCODE_PGDN)	\
  PORT_BIT (0x0020, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("F1") PORT_CODE(KEYCODE_F1)	\
  PORT_BIT (0x0040, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("F2") PORT_CODE(KEYCODE_F2)	\
  PORT_BIT (0x0080, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("F3") PORT_CODE(KEYCODE_F3)

#define KEYB_EXPERT11_ROW6	 \
  PORT_BIT (0x0001, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("SHIFT") PORT_CODE(KEYCODE_LSHIFT) \
  PORT_BIT (0x0002, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("CTRL") PORT_CODE(KEYCODE_LCONTROL)	\
  PORT_BIT (0x0004, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("LGRAPH") PORT_CODE(KEYCODE_PGUP)	 \
  PORT_BIT (0x0008, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("CAPS") PORT_CODE(KEYCODE_CAPSLOCK)	\
  PORT_BIT (0x0010, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("RGRAPH") PORT_CODE(KEYCODE_PGDN)	  \
  PORT_BIT (0x0020, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("F1") PORT_CODE(KEYCODE_F1)	\
  PORT_BIT (0x0040, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("F2") PORT_CODE(KEYCODE_F2)	\
  PORT_BIT (0x0080, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("F3") PORT_CODE(KEYCODE_F3)

#define KEYB_ROW7	\
  PORT_BIT (0x0100, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("F4") PORT_CODE(KEYCODE_F4)	\
  PORT_BIT (0x0200, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("F5") PORT_CODE(KEYCODE_F5)	\
  PORT_BIT (0x0400, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("ESC") PORT_CODE(KEYCODE_ESC)	\
  PORT_BIT (0x0800, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("TAB") PORT_CODE(KEYCODE_TAB)	\
  PORT_BIT (0x1000, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("STOP") PORT_CODE(KEYCODE_RCONTROL)	\
  PORT_BIT (0x2000, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("BACKSPACE") PORT_CODE(KEYCODE_BACKSPACE)	\
  PORT_BIT (0x4000, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("SELECT") PORT_CODE(KEYCODE_END)	\
  PORT_BIT (0x8000, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("ENTER") PORT_CODE(KEYCODE_ENTER)

#define KEYB_ROW8	\
  PORT_BIT (0x0001, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("SPACE") PORT_CODE(KEYCODE_SPACE)	\
  PORT_BIT (0x0002, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("HOME") PORT_CODE(KEYCODE_HOME)	\
  PORT_BIT (0x0004, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("INSERT") PORT_CODE(KEYCODE_INSERT)	\
  PORT_BIT (0x0008, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("DEL") PORT_CODE(KEYCODE_DEL)	\
  PORT_BIT (0x0010, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("LEFT") PORT_CODE(KEYCODE_LEFT)	\
  PORT_BIT (0x0020, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("UP") PORT_CODE(KEYCODE_UP)	\
  PORT_BIT (0x0040, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("DOWN") PORT_CODE(KEYCODE_DOWN)	\
  PORT_BIT (0x0080, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("RIGHT") PORT_CODE(KEYCODE_RIGHT)

#define KEYB_ROW9	\
  PORT_BIT (0x0100, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("NUM *") PORT_CODE(KEYCODE_ASTERISK)	\
  PORT_BIT (0x0200, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("NUM +") PORT_CODE(KEYCODE_PLUS_PAD)	\
  PORT_BIT (0x0400, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("NUM /") PORT_CODE(KEYCODE_SLASH_PAD)	\
  PORT_BIT (0x0800, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("NUM 0") PORT_CODE(KEYCODE_0_PAD)	\
  PORT_BIT (0x1000, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("NUM 1") PORT_CODE(KEYCODE_1_PAD)	\
  PORT_BIT (0x2000, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("NUM 2") PORT_CODE(KEYCODE_2_PAD)	\
  PORT_BIT (0x4000, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("NUM 3") PORT_CODE(KEYCODE_3_PAD)	\
  PORT_BIT (0x8000, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("NUM 4") PORT_CODE(KEYCODE_4_PAD)

#define KEYB_ROW10	\
  PORT_BIT (0x0001, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("NUM 5") PORT_CODE(KEYCODE_5_PAD)	\
  PORT_BIT (0x0002, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("NUM 6") PORT_CODE(KEYCODE_6_PAD)	\
  PORT_BIT (0x0004, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("NUM 7") PORT_CODE(KEYCODE_7_PAD)	\
  PORT_BIT (0x0008, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("NUM 8") PORT_CODE(KEYCODE_8_PAD)	\
  PORT_BIT (0x0010, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("NUM 9") PORT_CODE(KEYCODE_9_PAD)	\
  PORT_BIT (0x0020, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("NUM -") PORT_CODE(KEYCODE_MINUS_PAD)	\
  PORT_BIT (0x0040, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("NUM ,") PORT_CODE(KEYCODE_ENTER_PAD)	\
  PORT_BIT (0x0080, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("NUM .") PORT_CODE(KEYCODE_DEL_PAD)

INPUT_PORTS_START( msx )

 PORT_START /* 0 */
  KEYB_ROW0
  KEYB_ROW1

 PORT_START /* 1 */
  KEYB_ROW2
  KEYB_ROW3

 PORT_START /* 2 */
  KEYB_ROW4
  KEYB_ROW5

 PORT_START /* 3 */
  KEYB_ROW6
  KEYB_ROW7

 PORT_START /* 4 */
  KEYB_ROW8
  PORT_BIT (0xff00, IP_ACTIVE_LOW, IPT_UNUSED)	\

 PORT_START /* 5 */
  PORT_BIT (0xffff, IP_ACTIVE_LOW, IPT_UNUSED)	\

	PORT_INCLUDE( msx_dips )
INPUT_PORTS_END

INPUT_PORTS_START( msxuk )

 PORT_START /* 0 */
  KEYB_ROW0
  KEYB_ROW1

 PORT_START /* 1 */
  PORT_BIT (0x0001, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("' \"") PORT_CODE(KEYCODE_QUOTE)
  PORT_BIT (0x0002, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("\xa3 ~") PORT_CODE(KEYCODE_TILDE)
  PORT_BIT (0x0004, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME(", <") PORT_CODE(KEYCODE_COMMA)
  PORT_BIT (0x0008, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME(". >") PORT_CODE(KEYCODE_STOP)
  PORT_BIT (0x0010, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("/ ?") PORT_CODE(KEYCODE_SLASH)
  PORT_BIT (0x0020, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("Dead Key")
  PORT_BIT (0x0040, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("a A") PORT_CODE(KEYCODE_A)
  PORT_BIT (0x0080, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("b B") PORT_CODE(KEYCODE_B)
  KEYB_ROW3

 PORT_START /* 2 */
  KEYB_ROW4
  KEYB_ROW5

 PORT_START /* 3 */
  KEYB_ROW6
  KEYB_ROW7

 PORT_START /* 4 */
  KEYB_ROW8
  PORT_BIT (0xff00, IP_ACTIVE_LOW, IPT_UNUSED)	\

 PORT_START /* 5 */
  PORT_BIT (0xffff, IP_ACTIVE_LOW, IPT_UNUSED)	\

	PORT_INCLUDE( msx_dips )
INPUT_PORTS_END

#define KEYB_JAP_ROW0	\
  PORT_BIT (0x0001, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("0") PORT_CODE(KEYCODE_0)	\
  PORT_BIT (0x0002, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("1 !") PORT_CODE(KEYCODE_1)	\
  PORT_BIT (0x0004, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("2 \"") PORT_CODE(KEYCODE_2)	\
  PORT_BIT (0x0008, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("3 #") PORT_CODE(KEYCODE_3)	\
  PORT_BIT (0x0010, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("4 $") PORT_CODE(KEYCODE_4)	\
  PORT_BIT (0x0020, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("5 %") PORT_CODE(KEYCODE_5)	\
  PORT_BIT (0x0040, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("6 &") PORT_CODE(KEYCODE_6)	\
  PORT_BIT (0x0080, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("7 '") PORT_CODE(KEYCODE_7)

#define KEYB_JAP_ROW1	\
  PORT_BIT (0x0100, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("8 (") PORT_CODE(KEYCODE_8)	\
  PORT_BIT (0x0200, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("9 )") PORT_CODE(KEYCODE_9)	\
  PORT_BIT (0x0400, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("- =") PORT_CODE(KEYCODE_MINUS)	\
  PORT_BIT (0x0800, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("^ ~") PORT_CODE(KEYCODE_EQUALS)	\
  PORT_BIT (0x1000, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("\xa5 |") PORT_CODE(KEYCODE_BACKSLASH)	\
  PORT_BIT (0x2000, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("@ `") PORT_CODE(KEYCODE_OPENBRACE)	\
  PORT_BIT (0x4000, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("[ }") PORT_CODE(KEYCODE_CLOSEBRACE)	\
  PORT_BIT (0x8000, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("; +") PORT_CODE(KEYCODE_COLON)

#define KEYB_KOR_ROW1	\
  PORT_BIT (0x0100, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("8 (") PORT_CODE(KEYCODE_8)	\
  PORT_BIT (0x0200, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("9 )") PORT_CODE(KEYCODE_9)	\
  PORT_BIT (0x0400, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("- =") PORT_CODE(KEYCODE_MINUS)	\
  PORT_BIT (0x0800, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("^ ~") PORT_CODE(KEYCODE_EQUALS)	\
  PORT_BIT (0x1000, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("WON |") PORT_CODE(KEYCODE_BACKSLASH) \
  PORT_BIT (0x2000, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("@ `") PORT_CODE(KEYCODE_OPENBRACE)	\
  PORT_BIT (0x4000, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("[ }") PORT_CODE(KEYCODE_CLOSEBRACE)	\
  PORT_BIT (0x8000, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("; +") PORT_CODE(KEYCODE_COLON)

#define KEYB_JAP_ROW2	\
  PORT_BIT (0x0001, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME(": *") PORT_CODE(KEYCODE_QUOTE)	\
  PORT_BIT (0x0002, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("] }") PORT_CODE(KEYCODE_TILDE)	\
  PORT_BIT (0x0004, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME(", <") PORT_CODE(KEYCODE_COMMA)	\
  PORT_BIT (0x0008, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME(". >") PORT_CODE(KEYCODE_STOP)		\
  PORT_BIT (0x0010, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("/ ?") PORT_CODE(KEYCODE_SLASH)	\
  PORT_BIT (0x0020, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("  _") PORT_CODE(KEYCODE_F8)		\
  PORT_BIT (0x0040, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("a A") PORT_CODE(KEYCODE_A)		\
  PORT_BIT (0x0080, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("b B") PORT_CODE(KEYCODE_B)

INPUT_PORTS_START( msxjp )

 PORT_START /* 0 */
  KEYB_JAP_ROW0
  KEYB_JAP_ROW1

 PORT_START /* 1 */
  KEYB_JAP_ROW2
  KEYB_ROW3

 PORT_START /* 2 */
  KEYB_ROW4
  KEYB_ROW5

 PORT_START /* 3 */
  PORT_BIT (0x0001, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("SHIFT") PORT_CODE(KEYCODE_LSHIFT)
  PORT_BIT (0x0002, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("CTRL") PORT_CODE(KEYCODE_LCONTROL)
  PORT_BIT (0x0004, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("GRAPH") PORT_CODE(KEYCODE_PGUP)
  PORT_BIT (0x0008, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("CAPS") PORT_CODE(KEYCODE_CAPSLOCK)
  PORT_BIT (0x0010, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("KANA") PORT_CODE(KEYCODE_PGDN)
  PORT_BIT (0x0020, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("F1") PORT_CODE(KEYCODE_F1)
  PORT_BIT (0x0040, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("F2") PORT_CODE(KEYCODE_F2)
  PORT_BIT (0x0080, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("F3") PORT_CODE(KEYCODE_F3)
  KEYB_ROW7

 PORT_START /* 4 */
  KEYB_ROW8
  PORT_BIT (0xff00, IP_ACTIVE_LOW, IPT_UNUSED)	\

 PORT_START /* 5 */
  PORT_BIT (0xffff, IP_ACTIVE_LOW, IPT_UNUSED)	\

	PORT_INCLUDE( msx_dips )
INPUT_PORTS_END

INPUT_PORTS_START( msxkr )

 PORT_START /* 0 */
  KEYB_JAP_ROW0
  KEYB_KOR_ROW1

 PORT_START /* 1 */
  KEYB_JAP_ROW2
  KEYB_ROW3

 PORT_START /* 2 */
  KEYB_ROW4
  KEYB_ROW5

 PORT_START /* 3 */
  PORT_BIT (0x0001, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("SHIFT") PORT_CODE(KEYCODE_LSHIFT)
  PORT_BIT (0x0002, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("CTRL") PORT_CODE(KEYCODE_LCONTROL)
  PORT_BIT (0x0004, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("GRAPH") PORT_CODE(KEYCODE_PGUP)
  PORT_BIT (0x0008, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("CAPS") PORT_CODE(KEYCODE_CAPSLOCK)
  PORT_BIT (0x0010, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("Hangul") PORT_CODE(KEYCODE_PGDN)
  PORT_BIT (0x0020, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("F1") PORT_CODE(KEYCODE_F1)
  PORT_BIT (0x0040, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("F2") PORT_CODE(KEYCODE_F2)
  PORT_BIT (0x0080, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("F3") PORT_CODE(KEYCODE_F3)
  KEYB_ROW7

 PORT_START /* 4 */
  KEYB_ROW8
  PORT_BIT (0xff00, IP_ACTIVE_LOW, IPT_UNUSED)	\

 PORT_START /* 5 */
  PORT_BIT (0xffff, IP_ACTIVE_LOW, IPT_UNUSED)	\

	PORT_INCLUDE( msx_dips )
INPUT_PORTS_END

INPUT_PORTS_START( hotbit )

 PORT_START /* 0 */
  KEYB_HOTBIT_ROW0
  KEYB_HOTBIT_ROW1

 PORT_START /* 1 */
  KEYB_HOTBIT_ROW2
  KEYB_ROW3

 PORT_START /* 2 */
  KEYB_ROW4
  KEYB_ROW5

 PORT_START /* 3 */
  KEYB_ROW6
  KEYB_ROW7

 PORT_START /* 4 */
  KEYB_ROW8
  PORT_BIT (0xff00, IP_ACTIVE_LOW, IPT_UNUSED)	\

 PORT_START /* 5 */
  PORT_BIT (0xffff, IP_ACTIVE_LOW, IPT_UNUSED)	\

	PORT_INCLUDE( msx_dips )
INPUT_PORTS_END

#define KEYB_EXPERT11_ROW9	 \
  PORT_BIT (0x0100, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("+") PORT_CODE(KEYCODE_8)	  \
  PORT_BIT (0x0200, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("-") PORT_CODE(KEYCODE_9)	  \
  PORT_BIT (0x0400, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("*") PORT_CODE(KEYCODE_MINUS)	  \
  PORT_BIT (0x0800, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("/") PORT_CODE(KEYCODE_EQUALS)   \
  PORT_BIT (0xf000, IP_ACTIVE_LOW, IPT_UNUSED)	\

INPUT_PORTS_START( expert11 )

 PORT_START /* 0 */
  KEYB_EXPERT11_ROW0
  KEYB_EXPERT11_ROW1

 PORT_START /* 1 */
  KEYB_EXPERT11_ROW2
  KEYB_ROW3

 PORT_START /* 2 */
  KEYB_ROW4
  KEYB_ROW5

 PORT_START /* 3 */
  KEYB_EXPERT11_ROW6
  KEYB_ROW7

 PORT_START /* 4 */
  KEYB_ROW8
  KEYB_EXPERT11_ROW9

 PORT_START /* 5 */
  PORT_BIT (0xffff, IP_ACTIVE_LOW, IPT_UNUSED)	\

	PORT_INCLUDE( msx_dips )
INPUT_PORTS_END

INPUT_PORTS_START( expert10 )

 PORT_START /* 0 */
  KEYB_ROW0
  KEYB_ROW1

 PORT_START /* 1 */
  KEYB_EXPERT10_ROW2
  KEYB_ROW3

 PORT_START /* 2 */
  KEYB_ROW4
  KEYB_ROW5

 PORT_START /* 3 */
  KEYB_EXPERT11_ROW6
  KEYB_ROW7

 PORT_START /* 4 */
  KEYB_ROW8
  KEYB_EXPERT11_ROW9

 PORT_START /* 5 */
  PORT_BIT (0xffff, IP_ACTIVE_LOW, IPT_UNUSED)	\

	PORT_INCLUDE( msx_dips )
INPUT_PORTS_END

INPUT_PORTS_START( msx2 )

 PORT_START /* 0 */
  KEYB_ROW0
  KEYB_ROW1

 PORT_START /* 1 */
  KEYB_ROW2
  KEYB_ROW3

 PORT_START /* 2 */
  KEYB_ROW4
  KEYB_ROW5

 PORT_START /* 3 */
  KEYB_ROW6
  KEYB_ROW7

 PORT_START /* 4 */
  KEYB_ROW8
  KEYB_ROW9

 PORT_START /* 5 */
  KEYB_ROW10

	PORT_INCLUDE( msx_dips )
INPUT_PORTS_END

INPUT_PORTS_START( msx2jp )

 PORT_START /* 0 */
  KEYB_JAP_ROW0
  KEYB_JAP_ROW1

 PORT_START /* 1 */
  KEYB_JAP_ROW2
  KEYB_ROW3

 PORT_START /* 2 */
  KEYB_ROW4
  KEYB_ROW5

 PORT_START /* 3 */
  PORT_BIT (0x0001, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("SHIFT") PORT_CODE(KEYCODE_LSHIFT)
  PORT_BIT (0x0002, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("CTRL") PORT_CODE(KEYCODE_LCONTROL)
  PORT_BIT (0x0004, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("GRAPH") PORT_CODE(KEYCODE_PGUP)
  PORT_BIT (0x0008, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("CAPS") PORT_CODE(KEYCODE_CAPSLOCK)
  PORT_BIT (0x0010, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("KANA") PORT_CODE(KEYCODE_PGDN)
  PORT_BIT (0x0020, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("F1") PORT_CODE(KEYCODE_F1)
  PORT_BIT (0x0040, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("F2") PORT_CODE(KEYCODE_F2)
  PORT_BIT (0x0080, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("F3") PORT_CODE(KEYCODE_F3)
  KEYB_ROW7

 PORT_START /* 4 */
  KEYB_ROW8
  KEYB_ROW9

 PORT_START /* 5 */
  KEYB_ROW10

	PORT_INCLUDE( msx_dips )
INPUT_PORTS_END

INPUT_PORTS_START( msx2kr )

 PORT_START /* 0 */
  KEYB_JAP_ROW0
  KEYB_KOR_ROW1

 PORT_START /* 1 */
  KEYB_JAP_ROW2
  KEYB_ROW3

 PORT_START /* 2 */
  KEYB_ROW4
  KEYB_ROW5

 PORT_START /* 3 */
  PORT_BIT (0x0001, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("SHIFT") PORT_CODE(KEYCODE_LSHIFT)
  PORT_BIT (0x0002, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("CTRL") PORT_CODE(KEYCODE_LCONTROL)
  PORT_BIT (0x0004, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("GRAPH") PORT_CODE(KEYCODE_PGUP)
  PORT_BIT (0x0008, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("CAPS") PORT_CODE(KEYCODE_CAPSLOCK)
  PORT_BIT (0x0010, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("Hangul") PORT_CODE(KEYCODE_PGDN)
  PORT_BIT (0x0020, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("F1") PORT_CODE(KEYCODE_F1)
  PORT_BIT (0x0040, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("F2") PORT_CODE(KEYCODE_F2)
  PORT_BIT (0x0080, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("F3") PORT_CODE(KEYCODE_F3)
  KEYB_ROW7

 PORT_START /* 4 */
  KEYB_ROW8
  PORT_BIT (0xff00, IP_ACTIVE_LOW, IPT_UNUSED)	\

 PORT_START /* 5 */
  PORT_BIT (0xffff, IP_ACTIVE_LOW, IPT_UNUSED)	\

	PORT_INCLUDE( msx_dips )
INPUT_PORTS_END


static struct AY8910interface ay8910_interface =
{
	msx_psg_port_a_r,
	msx_psg_port_b_r,
	msx_psg_port_a_w,
	msx_psg_port_b_w
};

static VIDEO_START( msx2 )
{
	return v9938_init (MODEL_V9938, 0x20000, msx_vdp_interrupt);
}

static const TMS9928a_interface tms9928a_interface =
{
	TMS99x8A,
	0x4000,
	msx_vdp_interrupt
};

static MACHINE_DRIVER_START( msx )
	/* basic machine hardware */
	MDRV_CPU_ADD(Z80, 3579545)		  /* 3.579545 Mhz */
	MDRV_CPU_PROGRAM_MAP(readmem,writemem)
	MDRV_CPU_IO_MAP(readport,writeport)
	MDRV_CPU_VBLANK_INT(msx_interrupt,1)
	MDRV_FRAMES_PER_SECOND(60)
	MDRV_VBLANK_DURATION(DEFAULT_REAL_60HZ_VBLANK_DURATION)
	MDRV_INTERLEAVE(1)

	MDRV_MACHINE_INIT( msx )

	/* video hardware */
	MDRV_TMS9928A( &tms9928a_interface )
	MDRV_SCREEN_SIZE(15 + 256 + 15, 27 + 192 + 24)
	MDRV_VISIBLE_AREA(15 - 8, 15 + 256 + 8 - 1, 27 - 24, 27 + 192 + 24 - 1)

	/* sound hardware */
	MDRV_SPEAKER_STANDARD_MONO("mono")
	MDRV_SOUND_ADD(DAC, 0)
	MDRV_SOUND_ROUTE(ALL_OUTPUTS, "mono", 0.10)
	MDRV_SOUND_ADD(WAVE, 0)
	MDRV_SOUND_ROUTE(ALL_OUTPUTS, "mono", 0.25)
	MDRV_SOUND_ADD(AY8910, 1789773)
	MDRV_SOUND_CONFIG(ay8910_interface)
	MDRV_SOUND_ROUTE(ALL_OUTPUTS, "mono", 0.10)	
	MDRV_SOUND_ADD(K051649, 1789773)
	MDRV_SOUND_ROUTE(ALL_OUTPUTS, "mono", 0.25)	
	MDRV_SOUND_ADD(YM2413, 3579545)
	MDRV_SOUND_ROUTE(ALL_OUTPUTS, "mono", 0.40)	
MACHINE_DRIVER_END


static MACHINE_DRIVER_START( msx_pal )
	MDRV_IMPORT_FROM( msx )
	MDRV_FRAMES_PER_SECOND(50)
MACHINE_DRIVER_END


static MACHINE_DRIVER_START( msx2 )
	/* basic machine hardware */
	MDRV_CPU_ADD(Z80, 3579545)		  /* 3.579545 Mhz */
	MDRV_CPU_PROGRAM_MAP(readmem, writemem)
	MDRV_CPU_IO_MAP(readport2,writeport2)
	MDRV_CPU_VBLANK_INT(msx2_interrupt,262)
	MDRV_FRAMES_PER_SECOND(60)
	MDRV_VBLANK_DURATION(DEFAULT_REAL_60HZ_VBLANK_DURATION)
	MDRV_INTERLEAVE(1)

	MDRV_MACHINE_INIT( msx2 )

	/* video hardware */
	MDRV_VIDEO_ATTRIBUTES(VIDEO_UPDATE_BEFORE_VBLANK | VIDEO_TYPE_RASTER)
	MDRV_SCREEN_SIZE(512 + 32, (212 + 28) * 2)
	MDRV_VISIBLE_AREA(0, 512 + 32 - 1, 0, (212 + 28) * 2 - 1)
	MDRV_PALETTE_LENGTH(512)
	MDRV_COLORTABLE_LENGTH(512)
	MDRV_PALETTE_INIT( v9938 )

	MDRV_VIDEO_START( msx2 )
	MDRV_VIDEO_UPDATE( v9938 )

	/* sound hardware */
	MDRV_SPEAKER_STANDARD_MONO("mono")
	MDRV_SOUND_ADD(DAC, 0)
	MDRV_SOUND_ROUTE(ALL_OUTPUTS, "mono", 0.10)
	MDRV_SOUND_ADD(WAVE, 0)
	MDRV_SOUND_ROUTE(ALL_OUTPUTS, "mono", 0.25)
	MDRV_SOUND_ADD(AY8910, 1789773)
	MDRV_SOUND_CONFIG(ay8910_interface)
	MDRV_SOUND_ROUTE(ALL_OUTPUTS, "mono", 0.10)	
	MDRV_SOUND_ADD(K051649, 1789773)
	MDRV_SOUND_ROUTE(ALL_OUTPUTS, "mono", 0.25)	
	MDRV_SOUND_ADD(YM2413, 3579545)
	MDRV_SOUND_ROUTE(ALL_OUTPUTS, "mono", 0.40)	

	MDRV_NVRAM_HANDLER( msx2 )
MACHINE_DRIVER_END


/***************************************************************************

  Game driver(s)

***************************************************************************/

ROM_START (msx)
	ROM_REGION (0x8000, REGION_CPU1, 0)
	ROM_LOAD ("msx.rom", 0x0000, 0x8000, CRC(8205795e))
ROM_END

MSX_LAYOUT_INIT (msx)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000) 
	MSX_LAYOUT_SLOT (3, 0, 0, 4, RAM, 0x10000, 0x0000)	/* 64KB RAM */
MSX_LAYOUT_END

ROM_START (hb75d)
	ROM_REGION (0xc000, REGION_CPU1, 0)
	ROM_LOAD ("75dbios.rom", 0x0000, 0x8000, CRC(7e2b32dd))
	ROM_LOAD ("75dnote.rom", 0x8000, 0x4000, CRC(8aae0494))
ROM_END

MSX_LAYOUT_INIT (hb75d)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (0, 0, 2, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, RAM, 0x10000, 0x0000)	/* 64KB RAM */
	MSX_LAYOUT_SLOT (3, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000) 
MSX_LAYOUT_END

ROM_START (hb75p)
	ROM_REGION (0xc000, REGION_CPU1, 0)
	ROM_LOAD ("75pbios.rom", 0x0000, 0x8000, CRC(e9ccd789))
	ROM_LOAD ("75pnote.rom", 0x8000, 0x4000, CRC(492b12f8))
ROM_END

MSX_LAYOUT_INIT (hb75p)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (0, 0, 2, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, RAM, 0x10000, 0x0000)	/* 64KB RAM */
	MSX_LAYOUT_SLOT (3, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000) 
MSX_LAYOUT_END

ROM_START (hb501p)
	ROM_REGION (0x8000, REGION_CPU1, 0)
	ROM_LOAD ("501pbios.rom", 0x0000, 0x8000, CRC(0f488dd8))
ROM_END

MSX_LAYOUT_INIT (hb501p)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000) 
	MSX_LAYOUT_SLOT (3, 0, 0, 4, RAM, 0x10000, 0x0000)	/* 64KB RAM */
MSX_LAYOUT_END

ROM_START (hb201p)
	ROM_REGION (0xc000, REGION_CPU1, 0)
	ROM_LOAD ("201pbios.rom", 0x0000, 0x8000, CRC(0f488dd8))
	ROM_LOAD ("201pnote.rom", 0x8000, 0x4000, CRC(1ff9b6ec))
ROM_END

MSX_LAYOUT_INIT (hb201p)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (0, 0, 2, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000) 
	MSX_LAYOUT_SLOT (3, 0, 0, 4, RAM, 0x10000, 0x0000)	/* 64KB RAM */
MSX_LAYOUT_END

ROM_START (svi738)
	ROM_REGION (0x10000, REGION_CPU1, 0)
	ROM_LOAD ("738bios.rom", 0x0000, 0x8000, CRC(ad007d62))
	ROM_LOAD ("738disk.rom", 0x8000, 0x4000, CRC(acd27a36))
	ROM_LOAD ("738232c.rom", 0xc000, 0x4000, CRC(af568506))
ROM_END

MSX_LAYOUT_INIT (svi738)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, RAM, 0x10000, 0x0000)  /* 64KB RAM */
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000) 
	MSX_LAYOUT_SLOT (3, 0, 1, 1, ROM, 0x4000, 0xc000)
	MSX_LAYOUT_SLOT (3, 1, 1, 2, DISK_ROM2, 0x4000, 0x8000)
MSX_LAYOUT_END

ROM_START (cf2000)
	ROM_REGION (0x8000, REGION_CPU1, 0)
	ROM_LOAD ("2000bios.rom", 0x0000, 0x8000, CRC(ee229390))
ROM_END

MSX_LAYOUT_INIT (cf2000)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (0, 0, 3, 1, RAM, 0x4000, 0xC000)   /* 16KB RAM */
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000)
MSX_LAYOUT_END

ROM_START (cf1200)
	ROM_REGION (0x8000, REGION_CPU1, 0)
	ROM_LOAD ("1200bios.rom", 0x0000, 0x8000, CRC(5ad03407))
ROM_END

MSX_LAYOUT_INIT (cf1200)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (0, 0, 3, 1, RAM, 0x4000, 0xC000)   /* 16KB RAM */
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000)
MSX_LAYOUT_END

ROM_START (cf2700)
	ROM_REGION (0x8000, REGION_CPU1, 0)
	ROM_LOAD ("2700bios.rom", 0x0000, 0x8000, CRC(5ad03407))
ROM_END

MSX_LAYOUT_INIT (cf2700)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (0, 0, 2, 2, RAM, 0x8000, 0x8000)   /* 32KB RAM */
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000) 
MSX_LAYOUT_END

ROM_START (cf3000)
	ROM_REGION (0x8000, REGION_CPU1, 0)
	ROM_LOAD ("3000bios.rom", 0x0000, 0x8000, CRC(5ad03407))
ROM_END

MSX_LAYOUT_INIT (cf3000)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, RAM, 0x10000, 0x0000)  /* 64KB RAM */
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (3, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000) 
MSX_LAYOUT_END

ROM_START (cf3300)
	ROM_REGION (0xc000, REGION_CPU1, 0)
	ROM_LOAD ("3300bios.rom", 0x0000, 0x8000, CRC(5ad03407))
	ROM_LOAD ("3300disk.rom", 0x8000, 0x4000, CRC(549f1d90))
ROM_END

MSX_LAYOUT_INIT (cf3300)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000) 
	MSX_LAYOUT_SLOT (3, 0, 0, 4, RAM, 0x10000, 0x0000)  /* 64KB RAM */
  	MSX_LAYOUT_SLOT (3, 1, 1, 2, DISK_ROM2, 0x4000, 0x8000)
MSX_LAYOUT_END

ROM_START (fs4000)
	ROM_REGION (0x38000 ,REGION_CPU1, 0)
	ROM_LOAD ("4000bios.rom", 0x0000, 0x8000, CRC(071135e0))
	ROM_LOAD ("4000word.rom", 0x8000, 0x8000, CRC(950b6c87))
	ROM_LOAD ("4000kdr.rom", 0x10000, 0x8000, CRC(ebaa5a1e))
	ROM_LOAD ("4000kfn.rom", 0x18000, 0x20000, CRC(956dc96d))
ROM_END

MSX_LAYOUT_INIT (fs4000)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000) 
	MSX_LAYOUT_SLOT (3, 0, 0, 2, ROM, 0x8000, 0x8000) 
	MSX_LAYOUT_SLOT (3, 1, 1, 2, ROM, 0x8000, 0x10000) 
	MSX_LAYOUT_SLOT (3, 2, 0, 4, RAM, 0x10000, 0x0000)	/* 64KB RAM */
	MSX_LAYOUT_KANJI (0x18000)
MSX_LAYOUT_END

ROM_START (fs1300)
	ROM_REGION (0x8000, REGION_CPU1, 0)
	ROM_LOAD ("1300bios.rom", 0x0000, 0x8000, CRC(5ad03407))
ROM_END

MSX_LAYOUT_INIT (fs1300)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000) 
	MSX_LAYOUT_SLOT (3, 0, 0, 4, RAM, 0x10000, 0x0000)  /* 64KB RAM */
MSX_LAYOUT_END

ROM_START (hb201)
	ROM_REGION (0x10000, REGION_CPU1, 0)
	ROM_LOAD ("201bios.rom", 0x0000, 0x8000, CRC(ee229390))
	ROM_LOAD ("201note.rom", 0x8000, 0x8000, CRC(d280186e))
ROM_END

MSX_LAYOUT_INIT (hb201)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (0, 0, 2, 2, ROM, 0x8000, 0x8000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000) 
	MSX_LAYOUT_SLOT (3, 0, 0, 4, RAM, 0x10000, 0x0000)	/* 64KB RAM */
MSX_LAYOUT_END

ROM_START (dpc100)
	ROM_REGION (0xc000, REGION_CPU1, 0)
	ROM_LOAD ("100bios.rom", 0x0000, 0x8000, CRC(3ab0cd3b))
	ROM_LOAD ("100han.rom", 0x8000, 0x4000, CRC(97478efb))
ROM_END

MSX_LAYOUT_INIT (dpc100)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (0, 0, 2, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 3, 1, RAM, 0x4000, 0xC000)   /* 16KB RAM */
	MSX_LAYOUT_SLOT (3, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000) 
MSX_LAYOUT_END

ROM_START (dpc180)
	ROM_REGION (0xc000, REGION_CPU1, 0)
	ROM_LOAD ("180bios.rom", 0x0000, 0x8000, CRC(3ab0cd3b))
	ROM_LOAD ("180han.rom", 0x8000, 0x4000, CRC(97478efb))
ROM_END

MSX_LAYOUT_INIT (dpc180)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (0, 0, 2, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 2, 2, RAM, 0x8000, 0x8000)   /* 32KB RAM */
	MSX_LAYOUT_SLOT (3, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000) 
MSX_LAYOUT_END


ROM_START (dpc200)
	ROM_REGION (0xc000, REGION_CPU1, 0)
	ROM_LOAD ("200bios.rom", 0x0000, 0x8000, CRC(3ab0cd3b))
	ROM_LOAD ("200han.rom", 0x8000, 0x4000, CRC(97478efb))
ROM_END

MSX_LAYOUT_INIT (dpc200)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (0, 0, 2, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, RAM, 0x10000, 0x0000)	/* 64KB RAM */
	MSX_LAYOUT_SLOT (3, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000) 
MSX_LAYOUT_END

ROM_START (hotbit11)
	ROM_REGION (0x8000, REGION_CPU1,0)
	ROM_LOAD ("hotbit11.rom", 0x0000, 0x8000, CRC(b6942694))
ROM_END

MSX_LAYOUT_INIT (hotbit11)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000) 
	MSX_LAYOUT_SLOT (3, 0, 0, 4, RAM, 0x10000, 0x0000)	/* 64KB RAM */
MSX_LAYOUT_END

ROM_START (hotbit12)
	ROM_REGION (0x8000, REGION_CPU1,0)
	ROM_LOAD ("hotbit12.rom", 0x0000, 0x8000, CRC(f59a4a0c))
ROM_END

MSX_LAYOUT_INIT (hotbit12)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000) 
	MSX_LAYOUT_SLOT (3, 0, 0, 4, RAM, 0x10000, 0x0000)	/* 64KB RAM */
MSX_LAYOUT_END

ROM_START (expert10)
	ROM_REGION (0x8000, REGION_CPU1,0)
	ROM_LOAD ("expbios.rom", 0x0000, 0x8000, CRC(07610d77))
ROM_END

MSX_LAYOUT_INIT (expert10)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000) 
	MSX_LAYOUT_SLOT (3, 0, 0, 4, RAM, 0x10000, 0x0000)	/* 64KB RAM */
MSX_LAYOUT_END

ROM_START (expert11)
	ROM_REGION (0xc000, REGION_CPU1,0)
	ROM_LOAD ("exppbios.rom", 0x0000, 0x8000, CRC(efb4b972))
	ROM_LOAD ("exppdemo.rom", 0x8000, 0x4000, CRC(a9bbef64))
ROM_END

MSX_LAYOUT_INIT (expert11)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (0, 0, 2, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000) 
	MSX_LAYOUT_SLOT (3, 0, 0, 4, RAM, 0x10000, 0x0000)	/* 64KB RAM */
MSX_LAYOUT_END

ROM_START (expertdp)
	ROM_REGION (0xc000, REGION_CPU1,0)
	ROM_LOAD ("eddpbios.rom", 0x0000, 0x8000, CRC(efb4b972))
	ROM_LOAD ("eddpdisk.rom", 0x8000, 0x4000, CRC(549f1d90))
ROM_END

MSX_LAYOUT_INIT (expertdp)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000) 
	MSX_LAYOUT_SLOT (3, 0, 0, 4, RAM, 0x10000, 0x0000)  /* 64KB RAM */
  	MSX_LAYOUT_SLOT (3, 3, 1, 2, DISK_ROM2, 0x4000, 0x8000)
MSX_LAYOUT_END

ROM_START (msx2)
	ROM_REGION (0x20000, REGION_CPU1,0)
	ROM_LOAD ("msx2.rom", 0x0000, 0x8000, CRC(f05ed518))
	ROM_LOAD ("msx2ext.rom", 0x8000, 0x4000, CRC(95db2959))
	ROM_LOAD_OPTIONAL ("disk.rom", 0xc000, 0x4000, CRC(b7c58fad))
	ROM_LOAD_OPTIONAL ("fmpac.rom", 0x10000, 0x10000, CRC(0e84505d))
ROM_END

MSX_LAYOUT_INIT (msx2)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000) 
	MSX_LAYOUT_SLOT (3, 0, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (3, 0, 1, 2, DISK_ROM, 0x4000, 0xc000) 
	MSX_LAYOUT_SLOT (3, 3, 0, 4, RAM_MM, 0x20000, 0x0000)	/* 128KB Mapper RAM */
	MSX_LAYOUT_RAMIO_SET_BITS (0xf8)
MSX_LAYOUT_END

ROM_START (nms8220)
	ROM_REGION (0x20000, REGION_CPU1, 0)
	ROM_LOAD ("8220bios.rom", 0x0000, 0x8000, CRC(6cdaf3a5))
	ROM_LOAD ("8220ext.rom", 0x8000, 0x4000, CRC(06e4f5e6))
	ROM_LOAD ("8220pen.rom", 0xc000, 0x4000, CRC(3d38c53e))
	ROM_FILL (0x10000, 0x10000, 0)
ROM_END

MSX_LAYOUT_INIT (nms8220)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000) 
	MSX_LAYOUT_SLOT (3, 0, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (3, 2, 0, 4, RAM_MM, 0x10000, 0x0000)	/* 64KB Mapper RAM */
	MSX_LAYOUT_SLOT (3, 3, 1, 1, ROM, 0x4000, 0xc000) 
	MSX_LAYOUT_RAMIO_SET_BITS (0xf8)
MSX_LAYOUT_END

ROM_START (nms8220a)
	ROM_REGION (0x20000, REGION_CPU1, 0)
	ROM_LOAD ("8220bios.rom", 0x0000, 0x8000, CRC(6cdaf3a5))
	ROM_LOAD ("8220ext.rom", 0x8000, 0x4000, CRC(06e4f5e6))
	ROM_LOAD ("8220pena.rom", 0xc000, 0x4000, CRC(17817b5a))
	ROM_FILL (0x10000, 0x10000, 0)
ROM_END

MSX_LAYOUT_INIT (nms8220a)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000) 
	MSX_LAYOUT_SLOT (3, 0, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (3, 2, 0, 4, RAM_MM, 0x10000, 0x0000)	/* 64KB Mapper RAM */
	MSX_LAYOUT_SLOT (3, 3, 1, 1, ROM, 0x4000, 0xc000) 
	MSX_LAYOUT_RAMIO_SET_BITS (0xf8)
MSX_LAYOUT_END

ROM_START (vg8235)
	ROM_REGION (0x20000, REGION_CPU1, 0)
	ROM_LOAD ("8235bios.rom", 0x0000, 0x8000, CRC(6cdaf3a5))
	ROM_LOAD ("8235ext.rom", 0x8000, 0x4000, CRC(66237ecf))
	ROM_LOAD ("8235disk.rom", 0xc000, 0x4000, CRC(51daeb25))
	ROM_FILL (0x10000, 0x10000, 0)
ROM_END

MSX_LAYOUT_INIT (vg8235)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000) 
	MSX_LAYOUT_SLOT (3, 0, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (3, 2, 0, 4, RAM_MM, 0x20000, 0x0000)	/* 128KB Mapper RAM */
	MSX_LAYOUT_SLOT (3, 3, 1, 2, DISK_ROM, 0x4000, 0xc000) 
	MSX_LAYOUT_RAMIO_SET_BITS (0xf8)
MSX_LAYOUT_END

ROM_START (nms8245)
	ROM_REGION (0x20000, REGION_CPU1, 0)
	ROM_LOAD ("8245bios.rom", 0x0000, 0x8000, CRC(6cdaf3a5))
	ROM_LOAD ("8245ext.rom", 0x8000, 0x4000, CRC(95db2959))
	ROM_LOAD ("8245disk.rom", 0xc000, 0x4000, CRC(ca3307d3))
	ROM_FILL (0x10000, 0x10000, 0)
ROM_END

MSX_LAYOUT_INIT (nms8245)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000) 
	MSX_LAYOUT_SLOT (3, 0, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (3, 2, 0, 4, RAM_MM, 0x20000, 0x0000)	/* 128KB Mapper RAM */
	MSX_LAYOUT_SLOT (3, 3, 1, 2, DISK_ROM, 0x4000, 0xc000) 
	MSX_LAYOUT_RAMIO_SET_BITS (0xf8)
MSX_LAYOUT_END

ROM_START (nms8250)
	ROM_REGION (0x20000, REGION_CPU1, 0)
	ROM_LOAD ("8250bios.rom", 0x0000, 0x8000, CRC (6cdaf3a5))
	ROM_LOAD ("8250ext.rom", 0x8000, 0x4000, CRC (66237ecf))
	ROM_LOAD ("8250disk.rom", 0xc000, 0x04000, CRC (ca3307d3))
	ROM_FILL (0x10000, 0x10000, 0)
ROM_END

MSX_LAYOUT_INIT (nms8250)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000) 
	MSX_LAYOUT_SLOT (3, 0, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (3, 2, 0, 4, RAM_MM, 0x20000, 0x0000)	/* 128KB Mapper RAM */
	MSX_LAYOUT_SLOT (3, 3, 1, 2, DISK_ROM, 0x4000, 0xc000) 
	MSX_LAYOUT_RAMIO_SET_BITS (0xf8)
MSX_LAYOUT_END

ROM_START (nms8255)
	ROM_REGION (0x20000, REGION_CPU1, 0)
	ROM_LOAD ("8255bios.rom", 0x0000, 0x8000, CRC (6cdaf3a5))
	ROM_LOAD ("8255ext.rom", 0x8000, 0x4000, CRC (66237ecf))
	ROM_LOAD ("8255disk.rom", 0xc000, 0x04000, CRC (ca3307d3))
	ROM_FILL (0x10000, 0x10000, 0)
ROM_END

MSX_LAYOUT_INIT (nms8255)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000) 
	MSX_LAYOUT_SLOT (3, 0, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (3, 2, 0, 4, RAM_MM, 0x20000, 0x0000)	/* 128KB Mapper RAM */
	MSX_LAYOUT_SLOT (3, 3, 1, 2, DISK_ROM, 0x4000, 0xc000) 
	MSX_LAYOUT_RAMIO_SET_BITS (0xf8)
MSX_LAYOUT_END

ROM_START (nms8280)
	ROM_REGION (0x20000, REGION_CPU1, 0)
	ROM_LOAD ("8280bios.rom", 0x0000, 0x8000, CRC (6cdaf3a5))
	ROM_LOAD ("8280ext.rom", 0x8000, 0x4000, CRC (66237ecf))
	ROM_LOAD ("8280disk.rom", 0xc000, 0x04000, CRC (ca3307d3))
	ROM_FILL (0x10000, 0x10000, 0)
ROM_END

MSX_LAYOUT_INIT (nms8280)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000) 
	MSX_LAYOUT_SLOT (3, 0, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (3, 2, 0, 4, RAM_MM, 0x20000, 0x0000)	/* 128KB Mapper RAM */
	MSX_LAYOUT_SLOT (3, 3, 1, 2, DISK_ROM, 0x4000, 0xc000) 
	MSX_LAYOUT_RAMIO_SET_BITS (0xf8)
MSX_LAYOUT_END

ROM_START (fs5500)
	ROM_REGION (0x50000, REGION_CPU1,0)
	ROM_LOAD ("5500bios.rom", 0x0000, 0x8000, CRC(5bf38e13))
	ROM_LOAD ("5500ext.rom", 0x8000, 0x4000, CRC(3c42c367))
	ROM_LOAD ("5500disk.rom", 0xc000, 0x4000, CRC(1e7d6512))
	ROM_LOAD ("5500null.rom", 0x10000, 0x10000, CRC(deab7e4e))
	ROM_LOAD ("5500imp.rom", 0x20000, 0x8000, CRC(6173a88c))
	ROM_LOAD ("5500kdr.rom", 0x28000, 0x8000, CRC(b2db6bf5))
	ROM_LOAD ("5500kfn.rom", 0x30000, 0x20000, CRC(956dc96d))
ROM_END

MSX_LAYOUT_INIT (fs5500)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (0, 1, 0, 4, ROM, 0x10000, 0x10000)
	MSX_LAYOUT_SLOT (0, 2, 0, 4, ROM, 0x10000, 0x10000)
	MSX_LAYOUT_SLOT (0, 3, 0, 4, ROM, 0x10000, 0x10000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (3, 0, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (3, 0, 1, 2, ROM, 0x8000, 0x28000)
	MSX_LAYOUT_SLOT (3, 1, 1, 1, ROM, 0x8000, 0x20000)
	MSX_LAYOUT_SLOT (3, 2, 0, 4, RAM, 0x10000, 0x0000)	/* 64KB RAM */
	MSX_LAYOUT_SLOT (3, 3, 1, 2, DISK_ROM2, 0x4000, 0xc000)
	MSX_LAYOUT_KANJI (0x30000)
MSX_LAYOUT_END

ROM_START (fs4500)
	ROM_REGION (0x94000, REGION_CPU1,0)
	ROM_LOAD ("4500bios.rom", 0x0000, 0x8000, CRC(9b3e7b97))
	ROM_LOAD ("4500ext.rom", 0x8000, 0x4000, CRC(4a48779c))
	ROM_FILL (0xc000, 0x14000, 0)
	ROM_LOAD ("4500font.rom", 0x20000, 0x4000, CRC(4bd54f95))
	ROM_LOAD ("4500buns.rom", 0x24000, 0x8000, CRC(c9398e11))
	ROM_LOAD ("4500jush.rom", 0x2c000, 0x8000, CRC(4debfd2d))
	ROM_LOAD ("4500wor1.rom", 0x34000, 0xc000, CRC(0c8b5cfb))
	ROM_LOAD ("4500wor2.rom", 0x40000, 0xc000, CRC(d9909451))
	ROM_LOAD ("4500kdr1.rom", 0x4c000, 0x4000, CRC(f8c7f0db))
	ROM_LOAD ("4500kdr2.rom", 0x50000, 0x4000, CRC(69e87c31))
	ROM_LOAD ("4500kfn.rom", 0x54000, 0x20000, CRC(956dc96d))
	ROM_LOAD ("4500budi.rom", 0x74000, 0x20000, CRC(f94590f8))
ROM_END

MSX_LAYOUT_INIT (fs4500)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (0, 1, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (0, 2, 0, 1, ROM, 0x4000, 0x20000)
	MSX_LAYOUT_SLOT (0, 3, 1, 2, ROM, 0x8000, 0x2c000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (3, 0, 0, 3, ROM, 0xc000, 0x34000)
	MSX_LAYOUT_SLOT (3, 0, 3, 1, ROM, 0x4000, 0x4c000)
	MSX_LAYOUT_SLOT (3, 1, 0, 3, ROM, 0xc000, 0x40000)
	MSX_LAYOUT_SLOT (3, 1, 3, 1, ROM, 0x4000, 0x50000)
	MSX_LAYOUT_SLOT (3, 2, 0, 4, RAM, 0x10000, 0x0000)	/* 64KB RAM */
	MSX_LAYOUT_KANJI (0x54000)
/*	MSX_LAYOUT_BUNSETSU (0x74000) */ /* Matsushita Bunsetsu Henkan ROM must be emulated */
MSX_LAYOUT_END

ROM_START (fs4700)
	ROM_REGION (0x94000, REGION_CPU1,0)
	ROM_LOAD ("4700bios.rom", 0x0000, 0x8000, CRC(9b3e7b97))
	ROM_LOAD ("4700ext.rom", 0x8000, 0x4000, CRC(4a48779c))
	ROM_LOAD ("4700disk.rom", 0xc000, 0x4000, CRC(1e7d6512))
	ROM_FILL (0x10000, 0x10000, 0)
	ROM_LOAD ("4700font.rom", 0x20000, 0x4000, CRC(4bd54f95))
	ROM_LOAD ("4700buns.rom", 0x24000, 0x8000, CRC(c9398e11))
	ROM_LOAD ("4700jush.rom", 0x2c000, 0x8000, CRC(4debfd2d))
	ROM_LOAD ("4700wor1.rom", 0x34000, 0xc000, CRC(5f39a727))
	ROM_LOAD ("4700wor2.rom", 0x40000, 0xc000, CRC(d9909451))
	ROM_LOAD ("4700kdr1.rom", 0x4c000, 0x4000, CRC(f8c7f0db))
	ROM_LOAD ("4700kdr2.rom", 0x50000, 0x4000, CRC(69e87c31))
	ROM_LOAD ("4700kfn.rom", 0x54000, 0x20000, CRC(956dc96d))
	ROM_LOAD ("4700budi.rom", 0x74000, 0x20000, CRC(f94590f8))
ROM_END

MSX_LAYOUT_INIT (fs4700)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (0, 1, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (0, 2, 0, 1, ROM, 0x4000, 0x20000)
	MSX_LAYOUT_SLOT (0, 3, 1, 2, ROM, 0x8000, 0x2c000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (3, 0, 0, 3, ROM, 0xc000, 0x34000)
	MSX_LAYOUT_SLOT (3, 0, 3, 1, ROM, 0x4000, 0x4c000)
	MSX_LAYOUT_SLOT (3, 1, 0, 3, ROM, 0xc000, 0x40000)
	MSX_LAYOUT_SLOT (3, 1, 3, 1, ROM, 0x4000, 0x50000)
	MSX_LAYOUT_SLOT (3, 2, 0, 4, RAM, 0x10000, 0x0000)	/* 64KB RAM */
	MSX_LAYOUT_SLOT (3, 3, 1, 2, DISK_ROM2, 0x4000, 0xc000)
	MSX_LAYOUT_KANJI (0x54000)
/*	MSX_LAYOUT_BUNSETSU (0x74000) */ /* Matsushita Bunsetsu Henkan ROM must be emulated */
MSX_LAYOUT_END

ROM_START (fs5000)
	ROM_REGION (0x50000, REGION_CPU1,0)
	ROM_LOAD ("5000bios.rom", 0x0000, 0x8000, CRC(a44ea707))
	ROM_LOAD ("5000ext.rom", 0x8000, 0x4000, CRC(43e7a7fc))
	ROM_LOAD ("5000disk.rom", 0xc000, 0x4000, CRC(ae4e65b7))
	ROM_LOAD ("5000null.rom", 0x10000, 0x10000, CRC(deab7e4e))
	ROM_LOAD ("5000rtc.rom", 0x20000, 0x8000, CRC(03351598))
	ROM_LOAD ("5000kdr.rom", 0x28000, 0x8000, CRC(b2db6bf5))
	ROM_LOAD ("5000kfn.rom", 0x30000, 0x20000, CRC(c61ddc5d))
ROM_END

MSX_LAYOUT_INIT (fs5000)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (0, 1, 0, 4, ROM, 0x10000, 0x10000)
	MSX_LAYOUT_SLOT (0, 2, 0, 4, ROM, 0x10000, 0x10000)
	MSX_LAYOUT_SLOT (0, 3, 0, 4, ROM, 0x10000, 0x10000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (3, 0, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (3, 0, 1, 2, ROM, 0x8000, 0x28000)
	MSX_LAYOUT_SLOT (3, 1, 1, 1, ROM, 0x8000, 0x20000)
	MSX_LAYOUT_SLOT (3, 2, 0, 4, RAM_MM, 0x20000, 0x0000)   /* 128KB Mapper RAM */
	MSX_LAYOUT_SLOT (3, 3, 1, 2, DISK_ROM2, 0x4000, 0xc000)
	MSX_LAYOUT_KANJI (0x30000)
	MSX_LAYOUT_RAMIO_SET_BITS (0x80)
MSX_LAYOUT_END

ROM_START (fs4600)
	ROM_REGION (0x170000, REGION_CPU1,0)
	ROM_LOAD ("4600bios.rom", 0x0000, 0x8000, CRC(9b3e7b97))
	ROM_LOAD ("4600ext.rom", 0x8000, 0x4000, CRC(43e7a7fc))
	ROM_LOAD ("4600disk.rom", 0xc000, 0x4000, CRC(ae4e65b7))
	ROM_FILL (0x10000, 0x10000, 0)
	ROM_LOAD ("4600fon1.rom", 0x20000, 0x4000, CRC(7391389b))
	ROM_LOAD ("4600fon2.rom", 0x24000, 0x4000, CRC(c3a6b445))
	ROM_LOAD ("4600kdr.rom", 0x28000, 0x8000, CRC(b2db6bf5))
	ROM_LOAD ("4600kfn.rom", 0x30000, 0x20000, CRC(c61ddc5d))
	ROM_LOAD ("4600kf12.rom", 0x50000, 0x20000, CRC(340d1ef7))
	ROM_LOAD ("4600firm.rom", 0x70000, 0x100000, CRC(1df57472))
ROM_END

MSX_LAYOUT_INIT (fs4600)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (0, 1, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (0, 2, 0, 1, ROM, 0x4000, 0x20000)
	MSX_LAYOUT_SLOT (0, 2, 1, 2, ROM, 0x8000, 0x28000)
	MSX_LAYOUT_SLOT (0, 3, 0, 1, ROM, 0x4000, 0x24000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (3, 1, 0, 4, ASCII16, 0x100000, 0x70000) /* National FS-4600 Mapper must be emulated */
	MSX_LAYOUT_SLOT (3, 2, 0, 4, RAM_MM, 0x20000, 0x0000)   /* 128KB Mapper RAM */
	MSX_LAYOUT_SLOT (3, 3, 1, 2, DISK_ROM2, 0x4000, 0xc000)
	MSX_LAYOUT_KANJI (0x30000)
/*	MSX_LAYOUT_KANJI_12 (0x50000) */ /* Matsushita 12 dots Kanji ROM must be emulated */
	MSX_LAYOUT_RAMIO_SET_BITS (0x80)
MSX_LAYOUT_END

ROM_START (fsa1)
	ROM_REGION (0x30000, REGION_CPU1,0)
	ROM_LOAD ("a1bios.rom", 0x0000, 0x8000, CRC(9b3e7b97))
	ROM_LOAD ("a1ext.rom", 0x8000, 0x4000, CRC(43e7a7fc))
	ROM_FILL (0xc000, 0x14000, 0)
	ROM_LOAD ("deskpac1.rom", 0x20000, 0x8000, CRC(99c48147))
	ROM_LOAD ("deskpac2.rom", 0x28000, 0x8000, CRC(7f6f4aa1))
ROM_END

MSX_LAYOUT_INIT (fsa1)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (3, 0, 0, 4, RAM, 0x10000, 0x0000)  /* 64 KB RAM */
	MSX_LAYOUT_SLOT (3, 1, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (3, 2, 1, 2, ROM, 0x8000, 0x20000)
	MSX_LAYOUT_SLOT (3, 3, 1, 2, ROM, 0x8000, 0x28000)
MSX_LAYOUT_END

ROM_START (fsa1a)
	ROM_REGION (0x30000, REGION_CPU1,0)
	ROM_LOAD ("a1bios.rom", 0x0000, 0x8000, CRC(9b3e7b97))
	ROM_LOAD ("a1ext.rom", 0x8000, 0x4000, CRC(43e7a7fc))
	ROM_FILL (0xc000, 0x14000, 0)
	ROM_LOAD ("deskpa1a.rom", 0x20000, 0x8000, CRC(25b5b170))
	ROM_LOAD ("deskpac2.rom", 0x28000, 0x8000, CRC(7f6f4aa1))
ROM_END

MSX_LAYOUT_INIT (fsa1a)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (3, 0, 0, 4, RAM, 0x10000, 0x0000)  /* 64KB RAM */
	MSX_LAYOUT_SLOT (3, 1, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (3, 2, 1, 2, ROM, 0x8000, 0x20000)
	MSX_LAYOUT_SLOT (3, 3, 1, 2, ROM, 0x8000, 0x28000)
MSX_LAYOUT_END

ROM_START (fsa1mk2)
	ROM_REGION (0x34000, REGION_CPU1,0)
	ROM_LOAD ("a1mkbios.rom", 0x0000, 0x8000, CRC(9b3e7b97))
	ROM_LOAD ("a1mk2ext.rom", 0x8000, 0x4000, CRC(43e7a7fc))
	ROM_FILL (0xc000, 0x14000, 0)
	ROM_LOAD ("cockpit1.rom", 0x20000, 0x8000, CRC(0eda3f57))
	ROM_LOAD ("cockpit2.rom", 0x28000, 0x4000, CRC(756d7128))
	ROM_LOAD ("cockpit3.rom", 0x2c000, 0x8000, CRC(c1945676))
ROM_END

MSX_LAYOUT_INIT (fsa1mk2)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (3, 0, 0, 4, RAM_MM, 0x10000, 0x0000)   /* 64 KB Mapper RAM */
	MSX_LAYOUT_SLOT (3, 1, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (3, 1, 1, 2, ROM, 0x8000, 0x20000)
	MSX_LAYOUT_SLOT (3, 2, 1, 1, ROM, 0x4000, 0x28000)
	MSX_LAYOUT_SLOT (3, 3, 1, 2, ROM, 0x8000, 0x2c000)
	MSX_LAYOUT_RAMIO_SET_BITS (0x80)
MSX_LAYOUT_END

ROM_START (fsa1f)
	ROM_REGION (0x50000, REGION_CPU1,0)
	ROM_LOAD ("a1fbios.rom", 0x0000, 0x8000, CRC(9b3e7b97))
	ROM_LOAD ("a1fext.rom", 0x8000, 0x4000, CRC(43e7a7fc))
	ROM_LOAD ("a1fdisk.rom", 0xc000, 0x4000, CRC(d24cd452))
	ROM_FILL (0x10000, 0x10000, 0)
	ROM_LOAD ("a1fkdr.rom", 0x20000, 0x8000, CRC(2dbea5ec))
	ROM_LOAD ("a1fcock.rom", 0x28000, 0x8000, CRC(5c2948cd))
	ROM_LOAD ("a1fkfn.rom", 0x30000, 0x20000, CRC(c61ddc5d))
ROM_END

MSX_LAYOUT_INIT (fsa1f)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (3, 0, 0, 4, RAM_MM, 0x10000, 0x0000)   /* 64KB Mapper RAM */
	MSX_LAYOUT_SLOT (3, 1, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (3, 1, 1, 2, ROM, 0x8000, 0x20000)
/*	MSX_LAYOUT_SLOT (3, 2, 1, 2, DISK_ROM, 0x4000, 0xc000) */ /* FDC Emulation of TC8566AF must be emulated */
	MSX_LAYOUT_SLOT (3, 3, 1, 2, ROM, 0x8000, 0x28000)
	MSX_LAYOUT_KANJI (0x30000)
	MSX_LAYOUT_RAMIO_SET_BITS (0x80)
MSX_LAYOUT_END

ROM_START (fsa1fm)
	ROM_REGION (0x180000, REGION_CPU1,0)
	ROM_LOAD ("a1fmbios.rom", 0x0000, 0x8000, CRC(9b3e7b97))
	ROM_LOAD ("a1fmext.rom", 0x8000, 0x4000, CRC(ad295b5d))
	ROM_LOAD ("a1fmdisk.rom", 0xc000, 0x4000, CRC(d24cd452))
	ROM_FILL (0x10000, 0x10000, 0)
	ROM_LOAD ("a1fmmod.rom", 0x20000, 0x20000, CRC(925dbeeb))
	ROM_LOAD ("a1fmkfn.rom", 0x40000, 0x20000, CRC(c61ddc5d))
	ROM_LOAD ("a1fmkf12.rom", 0x60000, 0x20000, CRC(340d1ef7))
	ROM_LOAD ("a1fmfirm.rom", 0x80000, 0x100000, CRC(8ce0ece7))
ROM_END

MSX_LAYOUT_INIT (fsa1fm)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (3, 0, 0, 4, RAM_MM, 0x10000, 0x0000)   /* 64KB Mapper RAM */
	MSX_LAYOUT_SLOT (3, 1, 0, 1, ROM, 0x4000, 0x8000)
/*	MSX_LAYOUT_SLOT (3, 1, 1, 2, MODEM_ROM, 0x20000, 0x20000) */ /* Modem Mapper of FS-CM1/A1FM must be emulated */
/*	MSX_LAYOUT_SLOT (3, 2, 1, 2, DISK_ROM, 0x4000, 0xc000) */ /* FDC Emulation of TC8566AF must be emulated */
/*	MSX_LAYOUT_SLOT (3, 3, 0, 4, FSA1FM_ROM, 0x100000, 0x80000) */ /* Panasonic FS-A1FM Mapper must be emulated */
	MSX_LAYOUT_KANJI (0x40000)
/*	MSX_LAYOUT_KANJI_12 (0x60000) */ /* Matsushita 12 dots Kanji ROM must be emulated */
	MSX_LAYOUT_RAMIO_SET_BITS (0x80)
MSX_LAYOUT_END

ROM_START (hbf500)
	ROM_REGION (0x40000, REGION_CPU1, 0)
	ROM_LOAD ("f500bios.rom", 0x0000, 0x8000, CRC(9b3e7b97))
	ROM_LOAD ("f500ext.rom", 0x8000, 0x4000, CRC(4a48779c))
	ROM_LOAD ("f500disk.rom", 0xc000, 0x4000, CRC(f7f5b0ea))
	ROM_FILL (0x10000, 0x10000, 0)
	ROM_LOAD ("f500kfn.rom", 0x20000, 0x20000, CRC(5a59926e))
ROM_END

MSX_LAYOUT_INIT (hbf500)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (0, 0, 2, 2, RAM, 0x8000, 0x8000)   /* 32KB RAM */
	MSX_LAYOUT_SLOT (0, 1, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (0, 1, 1, 2, DISK_ROM, 0x4000, 0xc000) 
	MSX_LAYOUT_SLOT (0, 2, 0, 2, RAM, 0x8000, 0x0000)   /* 32KB RAM */
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000)
	MSX_LAYOUT_KANJI (0x20000)
MSX_LAYOUT_END

ROM_START (hbf900)
	ROM_REGION (0x44000, REGION_CPU1, 0)
	ROM_LOAD ("f900bios.rom", 0x0000, 0x8000, CRC(9b3e7b97))
	ROM_LOAD ("f900ext.rom", 0x8000, 0x4000, CRC(43e7a7fc))
	ROM_LOAD ("f900disk.rom", 0xc000, 0x4000, CRC(f83d0ea6))
	ROM_FILL (0x10000, 0x10000, 0)
	ROM_LOAD ("f900util.rom", 0x20000, 0x4000, CRC(bc6c7c66))
	ROM_LOAD ("f900kfn.rom", 0x24000, 0x20000, CRC(5a59926e))
ROM_END

MSX_LAYOUT_INIT (hbf900)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000) 
	MSX_LAYOUT_SLOT (3, 0, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (3, 0, 1, 2, DISK_ROM, 0x4000, 0xc000) 
	MSX_LAYOUT_SLOT (3, 1, 0, 4, RAM_MM, 0x40000, 0x0000)	/* 256KB Mapper RAM */
	MSX_LAYOUT_SLOT (3, 3, 1, 1, ROM, 0x4000, 0x10000) 
	MSX_LAYOUT_KANJI (0x24000)
	MSX_LAYOUT_RAMIO_SET_BITS (0x80)
MSX_LAYOUT_END

ROM_START (hbf900a)
	ROM_REGION (0x44000, REGION_CPU1, 0)
	ROM_LOAD ("f900bios.rom", 0x0000, 0x8000, CRC(9b3e7b97))
	ROM_LOAD ("f900ext.rom", 0x8000, 0x4000, CRC(43e7a7fc))
	ROM_LOAD ("f900disa.rom", 0xc000, 0x4000, CRC(54c73ad6))
	ROM_FILL (0x10000, 0x10000, 0)
	ROM_LOAD ("f900util.rom", 0x20000, 0x4000, CRC(bc6c7c66))
	ROM_LOAD ("f900kfn.rom", 0x24000, 0x20000, CRC(5a59926e))
ROM_END

MSX_LAYOUT_INIT (hbf900a)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000) 
	MSX_LAYOUT_SLOT (3, 0, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (3, 0, 1, 2, DISK_ROM, 0x4000, 0xc000) 
	MSX_LAYOUT_SLOT (3, 1, 0, 4, RAM_MM, 0x40000, 0x0000)	/* 256KB Mapper RAM */
	MSX_LAYOUT_SLOT (3, 3, 1, 1, ROM, 0x4000, 0x10000) 
	MSX_LAYOUT_KANJI (0x24000)
	MSX_LAYOUT_RAMIO_SET_BITS (0x80)
MSX_LAYOUT_END

ROM_START (hbf1)
	ROM_REGION (0x34000, REGION_CPU1,0)
	ROM_LOAD ("f1bios.rom", 0x0000, 0x8000, CRC(9b3e7b97))
	ROM_LOAD ("f1ext.rom", 0x8000, 0x4000, CRC(4a48779c))
	ROM_FILL (0xc000, 0x14000, 0)
	ROM_LOAD ("f1note1.rom", 0x20000, 0x4000, CRC(84810ea8))
	ROM_LOAD ("f1note2.rom", 0x24000, 0x8000, CRC(e32e5ee0))
	ROM_LOAD ("f1note3.rom", 0x2c000, 0x8000, CRC(73eb9329))
ROM_END

MSX_LAYOUT_INIT (hbf1)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (3, 0, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (3, 0, 1, 1, ROM, 0x4000, 0x20000)
	MSX_LAYOUT_SLOT (3, 1, 1, 2, ROM, 0x8000, 0x24000)
	MSX_LAYOUT_SLOT (3, 2, 1, 2, ROM, 0x8000, 0x2c000)
	MSX_LAYOUT_SLOT (3, 3, 0, 4, RAM, 0x10000, 0x0000)  /* 64KB RAM */
MSX_LAYOUT_END

ROM_START (hbf12)
	ROM_REGION (0x34000, REGION_CPU1,0)
	ROM_LOAD ("f12bios.rom", 0x0000, 0x8000, CRC(9b3e7b97))
	ROM_LOAD ("f12ext.rom", 0x8000, 0x4000, CRC(43e7a7fc))
	ROM_FILL (0xc000, 0x14000, 0)
	ROM_LOAD ("f12note1.rom", 0x20000, 0x4000, CRC(dcacf970))
	ROM_LOAD ("f12note2.rom", 0x24000, 0x8000, CRC(b0241a61))
	ROM_LOAD ("f12note3.rom", 0x2c000, 0x8000, CRC(44a10e6a))
ROM_END

MSX_LAYOUT_INIT (hbf12)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (3, 0, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (3, 0, 1, 1, ROM, 0x4000, 0x20000)
	MSX_LAYOUT_SLOT (3, 1, 1, 2, ROM, 0x8000, 0x24000)
	MSX_LAYOUT_SLOT (3, 2, 1, 2, ROM, 0x8000, 0x2c000)
	MSX_LAYOUT_SLOT (3, 3, 0, 4, RAM_MM, 0x10000, 0x0000)   /* 64KB Mapper RAM */
	MSX_LAYOUT_RAMIO_SET_BITS (0x80)
MSX_LAYOUT_END

ROM_START (hbf1xd)
	ROM_REGION (0x20000, REGION_CPU1,0)
	ROM_LOAD ("f1xdbios.rom", 0x0000, 0x8000, CRC(ba81b3dd))
	ROM_LOAD ("f1xdext.rom", 0x8000, 0x4000, CRC(43e7a7fc))
	ROM_LOAD ("f1xddisk.rom", 0xc000, 0x4000, CRC(54c73ad6))
	ROM_FILL (0x10000, 0x10000, 0)
ROM_END

MSX_LAYOUT_INIT (hbf1xd)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (3, 0, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (3, 0, 1, 2, DISK_ROM, 0x4000, 0xc000)
	MSX_LAYOUT_SLOT (3, 3, 0, 4, RAM_MM, 0x10000, 0x0000)   /* 64KB Mapper RAM */
	MSX_LAYOUT_RAMIO_SET_BITS (0x80)
MSX_LAYOUT_END

ROM_START (hbf1xdm2)
	ROM_REGION (0x20000, REGION_CPU1,0)
	ROM_LOAD ("f1m2bios.rom", 0x0000, 0x8000, CRC(ba81b3dd))
	ROM_LOAD ("f1m2ext.rom", 0x8000, 0x4000, CRC(43e7a7fc))
	ROM_LOAD ("f1m2disk.rom", 0xc000, 0x4000, CRC(54c73ad6))
	ROM_FILL (0x10000, 0x10000, 0)
ROM_END

MSX_LAYOUT_INIT (hbf1xdm2)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (3, 0, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (3, 0, 1, 2, DISK_ROM, 0x4000, 0xc000)
	MSX_LAYOUT_SLOT (3, 3, 0, 4, RAM_MM, 0x10000, 0x0000)   /* 64KB Mapper RAM */
	MSX_LAYOUT_RAMIO_SET_BITS (0x80)
MSX_LAYOUT_END

ROM_START (phc23)
	ROM_REGION (0x20000, REGION_CPU1,0)
	ROM_LOAD ("23bios.rom", 0x0000, 0x8000, CRC(ba81b3dd))
	ROM_LOAD ("23ext.rom", 0x8000, 0x4000, CRC(90ca25b5))
	ROM_FILL (0xc000, 0x14000, 0)
ROM_END

MSX_LAYOUT_INIT (phc23)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (3, 0, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (3, 2, 0, 4, RAM, 0x10000, 0x0000)  /* 64KB RAM */
MSX_LAYOUT_END

ROM_START (cpc300)
	ROM_REGION (0x28000, REGION_CPU1, 0)
	ROM_LOAD ("300bios.rom", 0x0000, 0x8000, CRC(53850907))
	ROM_LOAD ("300ext.rom", 0x8000, 0x8000, CRC(d64da39c))
	ROM_FILL (0x10000, 0x10000, 0)
	ROM_LOAD ("300han.rom", 0x20000, 0x8000, CRC(e78cd87f))
ROM_END

MSX_LAYOUT_INIT (cpc300)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (0, 1, 1, 2, ROM, 0x8000, 0x20000)
	MSX_LAYOUT_SLOT (0, 2, 0, 4, RAM_MM, 0x20000, 0x0000)	/* 128KB Mapper RAM */
	MSX_LAYOUT_SLOT (0, 3, 0, 2, ROM, 0x8000, 0x8000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (3, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000)
	MSX_LAYOUT_RAMIO_SET_BITS (0x80)
MSX_LAYOUT_END

ROM_START (cpc400)
	ROM_REGION (0x50000, REGION_CPU1, 0)
	ROM_LOAD ("400bios.rom", 0x0000, 0x8000, CRC(53850907))
	ROM_LOAD ("400disk.rom", 0x8000, 0x4000, CRC(5fa517df))
	ROM_FILL (0xc000, 0x14000, 0)
	ROM_LOAD ("400ext.rom", 0x20000, 0x8000, CRC(2ba104a3))
	ROM_LOAD ("400han.rom", 0x28000, 0x8000, CRC(a8ead5e3))
	ROM_LOAD ("400kfn.rom", 0x30000, 0x20000, CRC(b663c605))
ROM_END

MSX_LAYOUT_INIT (cpc400)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (0, 1, 1, 2, ROM, 0x8000, 0x28000)
	MSX_LAYOUT_SLOT (0, 2, 0, 4, RAM_MM, 0x20000, 0x0000)	/* 128KB Mapper RAM */
	MSX_LAYOUT_SLOT (0, 3, 0, 2, ROM, 0x8000, 0x20000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 1, 2, DISK_ROM2, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (3, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000)
	MSX_LAYOUT_KANJI (0x30000)
	MSX_LAYOUT_RAMIO_SET_BITS (0x80)
MSX_LAYOUT_END

ROM_START (cpc400s)
	ROM_REGION (0x50000, REGION_CPU1, 0)
	ROM_LOAD ("400sbios.rom", 0x0000, 0x8000, CRC(53850907))
	ROM_LOAD ("400sdisk.rom", 0x8000, 0x4000, CRC(5fa517df))
	ROM_FILL (0xc000, 0x14000, 0)
	ROM_LOAD ("400sext.rom", 0x20000, 0x8000, CRC(2ba104a3))
	ROM_LOAD ("400shan.rom", 0x28000, 0x8000, CRC(975e7a31))
	ROM_LOAD ("400skfn.rom", 0x30000, 0x20000, CRC(fa85368c))
ROM_END

MSX_LAYOUT_INIT (cpc400s)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (0, 1, 1, 2, ROM, 0x8000, 0x28000)
	MSX_LAYOUT_SLOT (0, 2, 0, 4, RAM_MM, 0x20000, 0x0000)	/* 128KB Mapper RAM */
	MSX_LAYOUT_SLOT (0, 3, 0, 2, ROM, 0x8000, 0x20000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 1, 2, DISK_ROM2, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (3, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000)
	MSX_LAYOUT_KANJI (0x30000)
	MSX_LAYOUT_RAMIO_SET_BITS (0x80)
MSX_LAYOUT_END

ROM_START (hbf9p)
	ROM_REGION (0x28000, REGION_CPU1, 0)
	ROM_LOAD ("f9pbios.rom", 0x0000, 0x8000, CRC(b31c851d))
	ROM_LOAD ("f9pext.rom", 0x8000, 0x4000, CRC(7c456c8b))
	ROM_LOAD ("f9pfirm1.rom", 0xc000, 0x4000, CRC(dea2cb50))
	ROM_FILL (0x10000, 0x10000, 0)
	ROM_LOAD ("f9pfirm2.rom", 0x20000, 0x8000, CRC(ea97069f))
ROM_END

MSX_LAYOUT_INIT (hbf9p)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000) 
	MSX_LAYOUT_SLOT (3, 0, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (3, 0, 1, 1, ROM, 0x4000, 0xc000)
	MSX_LAYOUT_SLOT (3, 1, 1, 2, ROM, 0x8000, 0x20000) 
	MSX_LAYOUT_SLOT (3, 2, 0, 4, RAM_MM, 0x20000, 0x0000)	/* 128KB Mapper RAM */
	MSX_LAYOUT_RAMIO_SET_BITS (0x80)
MSX_LAYOUT_END

ROM_START (hbf500p)
	ROM_REGION (0x20000, REGION_CPU1, 0)
	ROM_LOAD ("500pbios.rom", 0x0000, 0x8000, CRC(b31c851d))
	ROM_LOAD ("500pext.rom", 0x8000, 0x4000, CRC(8f84f783))
	ROM_LOAD ("500pdisk.rom", 0xc000, 0x4000, CRC(54c73ad6))
	ROM_FILL (0x10000, 0x10000, 0)
ROM_END

MSX_LAYOUT_INIT (hbf500p)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (0, 0, 2, 2, RAM, 0x8000, 0x8000)   /* 32KB RAM */
	MSX_LAYOUT_SLOT (0, 1, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (0, 1, 1, 2, DISK_ROM, 0x4000, 0xc000) 
	MSX_LAYOUT_SLOT (0, 2, 0, 2, RAM, 0x8000, 0x0000)   /* 32KB RAM */
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000) 
	MSX_LAYOUT_SLOT (3, 0, 0, 4, ROM, 0x10000, 0x10000)
MSX_LAYOUT_END

ROM_START (hbf700d)
	ROM_REGION (0x20000, REGION_CPU1, 0)
	ROM_LOAD ("700dbios.rom", 0x0000, 0x8000, CRC(e975aa79))
	ROM_LOAD ("700dext.rom", 0x8000, 0x4000, CRC(7c456c8b))
	ROM_LOAD ("700ddisk.rom", 0xc000, 0x4000, CRC(54c73ad6))
	ROM_FILL (0x10000, 0x10000, 0)
ROM_END

MSX_LAYOUT_INIT (hbf700d)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000) 
	MSX_LAYOUT_SLOT (3, 0, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (3, 0, 1, 2, DISK_ROM, 0x4000, 0xc000) 
	MSX_LAYOUT_SLOT (3, 3, 0, 4, RAM_MM, 0x40000, 0x0000)	/* 256KB Mapper RAM */
	MSX_LAYOUT_RAMIO_SET_BITS (0x80)
MSX_LAYOUT_END

ROM_START (hbf700p)
	ROM_REGION (0x20000, REGION_CPU1, 0)
	ROM_LOAD ("700pbios.rom", 0x0000, 0x8000, CRC(b31c851d))
	ROM_LOAD ("700pext.rom", 0x8000, 0x4000, CRC(8f84f783))
	ROM_LOAD ("700pdisk.rom", 0xc000, 0x4000, CRC(1d9cc7f6))
	ROM_FILL (0x10000, 0x10000, 0)
ROM_END

MSX_LAYOUT_INIT (hbf700p)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000) 
	MSX_LAYOUT_SLOT (3, 0, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (3, 0, 1, 2, DISK_ROM, 0x4000, 0xc000) 
	MSX_LAYOUT_SLOT (3, 3, 0, 4, RAM_MM, 0x40000, 0x0000)	/* 256KB Mapper RAM */
	MSX_LAYOUT_RAMIO_SET_BITS (0x80)
MSX_LAYOUT_END

ROM_START (hbf700s)
	ROM_REGION (0x20000, REGION_CPU1, 0)
	ROM_LOAD ("700sbios.rom", 0x0000, 0x8000, CRC(c2b889a5))
	ROM_LOAD ("700sext.rom", 0x8000, 0x4000, CRC(dc0951bd))
	ROM_LOAD ("700sdisk.rom", 0xc000, 0x4000, CRC(1d9cc7f6))
	ROM_FILL (0x10000, 0x10000, 0)
ROM_END

MSX_LAYOUT_INIT (hbf700s)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000) 
	MSX_LAYOUT_SLOT (3, 0, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (3, 0, 1, 2, DISK_ROM, 0x4000, 0xc000) 
	MSX_LAYOUT_SLOT (3, 3, 0, 4, RAM_MM, 0x40000, 0x0000)	/* 256KB Mapper RAM */
	MSX_LAYOUT_RAMIO_SET_BITS (0x80)
MSX_LAYOUT_END

ROM_START (hbg900p)
	ROM_REGION (0x28000, REGION_CPU1, 0)
	ROM_LOAD ("g900bios.rom", 0x0000, 0x8000, CRC(b31c851d))
	ROM_LOAD ("g900ext.rom", 0x8000, 0x4000, CRC(8f84f783))
	ROM_LOAD ("g900disk.rom", 0xc000, 0x4000, CRC(54c73ad6))
	ROM_FILL (0x10000, 0x10000, 0)
	ROM_LOAD ("g900232c.rom", 0x20000, 0x4000, CRC(06cf1da6))
	ROM_LOAD ("g900util.rom", 0x24000, 0x4000, CRC(d0417c20))
ROM_END

MSX_LAYOUT_INIT (hbg900p)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (0, 1, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (0, 1, 1, 2, DISK_ROM, 0x4000, 0xc000) 
/*	MSX_LAYOUT_SLOT (0, 2, 1, 1, ROM, 0x4000, 0x20000) */ /* RS232C must be emulated */
	MSX_LAYOUT_SLOT (0, 3, 1, 1, ROM, 0x4000, 0x24000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000) 
	MSX_LAYOUT_SLOT (3, 0, 0, 4, RAM_MM, 0x10000, 0x0000)	/* 64KB Mapper RAM */
	MSX_LAYOUT_RAMIO_SET_BITS (0x80)
MSX_LAYOUT_END

ROM_START (msx2p)
	ROM_REGION (0x48000, REGION_CPU1,0)
	ROM_LOAD ("msx2p.rom", 0x0000, 0x8000, CRC(00870134))
	ROM_LOAD ("msx2pext.rom", 0x8000, 0x4000, CRC(b8ba44d3))
	ROM_LOAD_OPTIONAL ("disk.rom", 0xc000, 0x4000, CRC(b7c58fad))
	ROM_LOAD_OPTIONAL ("fmpac.rom", 0x10000, 0x10000, CRC(0e84505d))
	ROM_LOAD ("msx2pkdr.rom", 0x20000, 0x8000, CRC(a068cba9))
	ROM_LOAD ("msx2pkfn.rom", 0x28000, 0x20000, CRC(b244f6cf))
ROM_END

MSX_LAYOUT_INIT (msx2p)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (3, 0, 0, 4, RAM_MM, 0x20000, 0x0000)   /* 128KB Mapper RAM */
	MSX_LAYOUT_SLOT (3, 1, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (3, 1, 1, 2, ROM, 0x8000, 0x20000)
	MSX_LAYOUT_SLOT (3, 2, 1, 2, DISK_ROM, 0x4000, 0xc000) 
	MSX_LAYOUT_KANJI (0x28000)
	MSX_LAYOUT_RAMIO_SET_BITS (0x80)
MSX_LAYOUT_END

ROM_START (fsa1fx)
	ROM_REGION (0x50000, REGION_CPU1,0)
	ROM_LOAD ("a1fxbios.rom", 0x0000, 0x8000, CRC(19771608))
	ROM_LOAD ("a1fxext.rom", 0x8000, 0x4000, CRC(b8ba44d3))
	ROM_LOAD ("a1fxdisk.rom", 0xc000, 0x4000, CRC(905daa1b))
	ROM_FILL (0x10000, 0x10000, 0)
	ROM_LOAD ("a1fxkdr.rom", 0x20000, 0x8000, CRC(a068cba9))
	ROM_LOAD ("a1fxcock.rom", 0x28000, 0x8000, CRC(f662e6eb))
	ROM_LOAD ("a1fxkfn.rom", 0x30000, 0x20000, CRC(b244f6cf))
ROM_END

MSX_LAYOUT_INIT (fsa1fx)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (3, 0, 0, 4, RAM_MM, 0x10000, 0x0000)   /* 64KB Mapper RAM */
	MSX_LAYOUT_SLOT (3, 1, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (3, 1, 1, 2, ROM, 0x8000, 0x20000)
/*	MSX_LAYOUT_SLOT (3, 2, 1, 2, DISK_ROM, 0x4000, 0xc000) */ /* FDC Emulation of TC8566AF must be emulated */
	MSX_LAYOUT_SLOT (3, 3, 1, 2, ROM, 0x8000, 0x28000)
	MSX_LAYOUT_KANJI (0x30000)
	MSX_LAYOUT_RAMIO_SET_BITS (0x80)
MSX_LAYOUT_END

ROM_START (fsa1wx)
	ROM_REGION (0x270000, REGION_CPU1,0)
	ROM_LOAD ("a1wxbios.rom", 0x0000, 0x8000, CRC(19771608))
	ROM_LOAD ("a1wxext.rom", 0x8000, 0x4000, CRC(b8ba44d3))
	ROM_LOAD ("a1wxdisk.rom", 0xc000, 0x4000, CRC(905daa1b))
	ROM_FILL (0x10000, 0x10000, 0)
	ROM_LOAD ("a1wxkdr.rom", 0x20000, 0x8000, CRC(a068cba9))
	ROM_LOAD ("a1wxmus.rom", 0x28000, 0x4000, CRC(5c32eb29))
	ROM_FILL (0x2c000, 0x4000, 0)
	ROM_LOAD ("a1wxkfn.rom", 0x30000, 0x40000, CRC(1f6406fb))
	ROM_LOAD ("a1wxfirm.rom", 0x70000, 0x200000, CRC(283f3250))
ROM_END

MSX_LAYOUT_INIT (fsa1wx)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (0, 2, 1, 1, ROM, 0x4000, 0x28000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (3, 0, 0, 4, RAM_MM, 0x10000, 0x0000)   /* 64KB Mapper RAM */
	MSX_LAYOUT_SLOT (3, 1, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (3, 1, 1, 2, ROM, 0x8000, 0x20000)
/*	MSX_LAYOUT_SLOT (3, 2, 1, 2, DISK_ROM, 0x4000, 0xc000) */ /* FDC Emulation of TC8566AF must be emulated */
/*	MSX_LAYOUT_SLOT (3, 3, 1, 4, PANASONIC08, 0x200000, 0x70000) */ /* Panasonic 08KB Mapper must be emulated */
	MSX_LAYOUT_KANJI (0x30000)
	MSX_LAYOUT_RAMIO_SET_BITS (0x80)
MSX_LAYOUT_END

ROM_START (fsa1wxa)
	ROM_REGION (0x270000, REGION_CPU1,0)
	ROM_LOAD ("a1wxbios.rom", 0x0000, 0x8000, CRC(19771608))
	ROM_LOAD ("a1wxext.rom", 0x8000, 0x4000, CRC(b8ba44d3))
	ROM_LOAD ("a1wxdisk.rom", 0xc000, 0x4000, CRC(905daa1b))
	ROM_FILL (0x10000, 0x10000, 0)
	ROM_LOAD ("a1wxkdr.rom", 0x20000, 0x8000, CRC(a068cba9))
	ROM_LOAD ("a1wxmus.rom", 0x28000, 0x4000, CRC(5c32eb29))
	ROM_FILL (0x2c000, 0x4000, 0)
	ROM_LOAD ("a1wxkfn.rom", 0x30000, 0x40000, CRC(1f6406fb))
	ROM_LOAD ("a1wxfira.rom", 0x70000, 0x200000, CRC(58440a8e))
ROM_END

MSX_LAYOUT_INIT (fsa1wxa)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (0, 2, 1, 1, ROM, 0x4000, 0x28000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (3, 0, 0, 4, RAM_MM, 0x10000, 0x0000)   /* 64KB Mapper RAM */
	MSX_LAYOUT_SLOT (3, 1, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (3, 1, 1, 2, ROM, 0x8000, 0x20000)
/*	MSX_LAYOUT_SLOT (3, 2, 1, 2, DISK_ROM, 0x4000, 0xc000) */ /* FDC Emulation of TC8566AF must be emulated */
/*	MSX_LAYOUT_SLOT (3, 3, 1, 4, PANASONIC08, 0x200000, 0x70000) */ /* Panasonic 08KB Mapper must be emulated */
	MSX_LAYOUT_KANJI (0x30000)
	MSX_LAYOUT_RAMIO_SET_BITS (0x80)
MSX_LAYOUT_END

ROM_START (fsa1wsx)
	ROM_REGION (0x270000, REGION_CPU1,0)
	ROM_LOAD ("a1wsbios.rom", 0x0000, 0x8000, CRC(358ec547))
	ROM_LOAD ("a1wsext.rom", 0x8000, 0x4000, CRC(b8ba44d3))
	ROM_LOAD ("a1wsdisk.rom", 0xc000, 0x4000, CRC(17fa392b))
	ROM_FILL (0x10000, 0x10000, 0)
	ROM_LOAD ("a1wskdr.rom", 0x20000, 0x8000, CRC(b4fc574d))
	ROM_LOAD ("a1wsmus.rom", 0x28000, 0x4000, CRC(5c32eb29))
	ROM_FILL (0x2c000, 0x4000, 0)
	ROM_LOAD ("a1wskfn.rom", 0x30000, 0x40000, CRC(1f6406fb))
	ROM_LOAD ("a1wsfirm.rom", 0x70000, 0x200000, CRC(e363595d))
ROM_END

MSX_LAYOUT_INIT (fsa1wsx)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (0, 2, 1, 1, ROM, 0x4000, 0x28000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (3, 0, 0, 4, RAM_MM, 0x10000, 0x0000)   /* 64KB Mapper RAM */
	MSX_LAYOUT_SLOT (3, 1, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (3, 1, 1, 2, ROM, 0x8000, 0x20000)
/*	MSX_LAYOUT_SLOT (3, 2, 1, 2, DISK_ROM, 0x4000, 0xc000) */ /* FDC Emulation of TC8566AF must be emulated */
/*	MSX_LAYOUT_SLOT (3, 3, 1, 4, PANASONIC08, 0x200000, 0x70000) */ /* Panasonic 08KB Mapper must be emulated */
	MSX_LAYOUT_KANJI (0x30000)
	MSX_LAYOUT_RAMIO_SET_BITS (0x80)
MSX_LAYOUT_END

ROM_START (hbf1xdj)
	ROM_REGION (0x170000, REGION_CPU1,0)
	ROM_LOAD ("f1xjbios.rom", 0x0000, 0x8000, CRC(00870134))
	ROM_LOAD ("f1xjext.rom", 0x8000, 0x4000, CRC(b8ba44d3))
	ROM_LOAD ("f1xjdisk.rom", 0xc000, 0x4000, CRC(a21f5266))
	ROM_FILL (0x10000, 0x10000, 0)
	ROM_LOAD ("f1xjkdr.rom", 0x20000, 0x8000, CRC(a068cba9))
	ROM_LOAD ("f1xjmus.rom", 0x28000, 0x4000, CRC(5c32eb29))
	ROM_FILL (0x2c000, 0x4000, 0)
	ROM_LOAD ("f1xjkfn.rom", 0x30000, 0x40000, CRC(7016dfd0))
	ROM_LOAD ("f1xjfirm.rom", 0x70000, 0x100000, CRC(77be583f))
ROM_END

MSX_LAYOUT_INIT (hbf1xdj)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
/*	MSX_LAYOUT_SLOT (0, 3, 1, 4, SONY08, 0x100000, 0x70000) */ /* Sony 08KB MSX-JE Mapper must be emulated */
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (3, 0, 0, 4, RAM_MM, 0x10000, 0x0000)   /* 64KB Mapper RAM */
	MSX_LAYOUT_SLOT (3, 1, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (3, 1, 1, 2, ROM, 0x8000, 0x20000)
	MSX_LAYOUT_SLOT (3, 2, 1, 2, DISK_ROM, 0x4000, 0xc000) 
	MSX_LAYOUT_SLOT (3, 3, 1, 1, ROM, 0x4000, 0x28000)
	MSX_LAYOUT_KANJI (0x30000)
	MSX_LAYOUT_RAMIO_SET_BITS (0x80)
MSX_LAYOUT_END

ROM_START (hbf1xv)
	ROM_REGION (0x170000, REGION_CPU1,0)
	ROM_LOAD ("f1xvbios.rom", 0x0000, 0x8000, CRC(2c7ed27b))
	ROM_LOAD ("f1xvext.rom", 0x8000, 0x4000, CRC(b8ba44d3))
	ROM_LOAD ("f1xvdisk.rom", 0xc000, 0x4000, CRC(04e4e533))
	ROM_FILL (0x10000, 0x10000, 0)
	ROM_LOAD ("f1xvkdr.rom", 0x20000, 0x8000, CRC(b4fc574d))
	ROM_LOAD ("f1xvmus.rom", 0x28000, 0x4000, CRC(5c32eb29))
	ROM_FILL (0x2c000, 0x4000, 0)
	ROM_LOAD ("f1xvkfn.rom", 0x30000, 0x40000, CRC(7016dfd0))
	ROM_LOAD ("f1xvfirm.rom", 0x70000, 0x100000, CRC(77be583f))
ROM_END

MSX_LAYOUT_INIT (hbf1xv)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
/*	MSX_LAYOUT_SLOT (0, 3, 1, 4, SONY08, 0x100000, 0x70000) */ /* Sony 08KB MSX-JE Mapper must be emulated */
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (3, 0, 0, 4, RAM_MM, 0x10000, 0x0000)   /* 64KB Mapper RAM */
	MSX_LAYOUT_SLOT (3, 1, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (3, 1, 1, 2, ROM, 0x8000, 0x20000)
	MSX_LAYOUT_SLOT (3, 2, 1, 2, DISK_ROM, 0x4000, 0xc000) 
	MSX_LAYOUT_SLOT (3, 3, 1, 1, ROM, 0x4000, 0x28000)
	MSX_LAYOUT_KANJI (0x30000)
	MSX_LAYOUT_RAMIO_SET_BITS (0x80)
MSX_LAYOUT_END

ROM_START (phc70fd)
	ROM_REGION (0x50000, REGION_CPU1,0)
	ROM_LOAD ("70fdbios.rom", 0x0000, 0x8000, CRC(19771608))
	ROM_LOAD ("70fdext.rom", 0x8000, 0x4000, CRC(b8ba44d3))
	ROM_LOAD ("70fddisk.rom", 0xc000, 0x4000, CRC(db7f1125))
	ROM_FILL (0x10000, 0x10000, 0)
	ROM_LOAD ("70fdkdr.rom", 0x20000, 0x8000, CRC(a068cba9))
	ROM_LOAD ("70fdmus.rom", 0x28000, 0x4000, CRC(5c32eb29))
	ROM_LOAD ("70fdbas.rom", 0x2c000, 0x4000, CRC(da7be246))
	ROM_LOAD ("70fdkfn.rom", 0x30000, 0x20000, CRC(c9651b32))
ROM_END

MSX_LAYOUT_INIT (phc70fd)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (3, 0, 0, 4, RAM_MM, 0x10000, 0x0000)   /* 64KB Mapper RAM */
	MSX_LAYOUT_SLOT (3, 1, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (3, 1, 1, 2, ROM, 0x8000, 0x20000)
/*	MSX_LAYOUT_SLOT (3, 2, 1, 2, DISK_ROM, 0x4000, 0xc000) */ /* FDC Emulation of TC8566AF must be emulated */
	MSX_LAYOUT_SLOT (3, 3, 1, 1, ROM, 0x4000, 0x28000)
	MSX_LAYOUT_SLOT (3, 3, 2, 1, ROM, 0x4000, 0x2c000)
	MSX_LAYOUT_KANJI (0x30000)
	MSX_LAYOUT_RAMIO_SET_BITS (0x80)
MSX_LAYOUT_END

ROM_START (phc70fd2)
	ROM_REGION (0x70000, REGION_CPU1,0)
	ROM_LOAD ("70f2bios.rom", 0x0000, 0x8000, CRC(19771608))
	ROM_LOAD ("70f2ext.rom", 0x8000, 0x4000, CRC(b8ba44d3))
	ROM_LOAD ("70f2disk.rom", 0xc000, 0x4000, CRC(db7f1125))
	ROM_FILL (0x10000, 0x10000, 0)
	ROM_LOAD ("70f2kdr.rom", 0x20000, 0x8000, CRC(a068cba9))
	ROM_LOAD ("70f2mus.rom", 0x28000, 0x4000, CRC(5c32eb29))
	ROM_LOAD ("70f2bas.rom", 0x2c000, 0x4000, CRC(da7be246))
	ROM_LOAD ("70f2kfn.rom", 0x30000, 0x40000, CRC(9a850db9))
ROM_END

MSX_LAYOUT_INIT (phc70fd2)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (3, 0, 0, 4, RAM_MM, 0x10000, 0x0000)   /* 64KB Mapper RAM */
	MSX_LAYOUT_SLOT (3, 1, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (3, 1, 1, 2, ROM, 0x8000, 0x20000)
/*	MSX_LAYOUT_SLOT (3, 2, 1, 2, DISK_ROM, 0x4000, 0xc000) */ /* FDC Emulation of TC8566AF must be emulated */
	MSX_LAYOUT_SLOT (3, 3, 1, 1, ROM, 0x4000, 0x28000)
	MSX_LAYOUT_SLOT (3, 3, 2, 1, ROM, 0x4000, 0x2c000)
	MSX_LAYOUT_KANJI (0x30000)
	MSX_LAYOUT_RAMIO_SET_BITS (0x80)
MSX_LAYOUT_END

ROM_START (phc35j)
	ROM_REGION (0x48000, REGION_CPU1,0)
	ROM_LOAD ("35jbios.rom", 0x0000, 0x8000, CRC(358ec547))
	ROM_LOAD ("35jext.rom", 0x8000, 0x4000, CRC(b8ba44d3))
	ROM_FILL (0xc000, 0x14000, 0)
	ROM_LOAD ("35jkdr.rom", 0x20000, 0x8000, CRC(b4fc574d))
	ROM_LOAD ("35jkfn.rom", 0x28000, 0x20000, CRC(c9651b32))
ROM_END

MSX_LAYOUT_INIT (phc35j)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (3, 0, 0, 4, RAM_MM, 0x10000, 0x0000)   /* 64KB Mapper RAM */
	MSX_LAYOUT_SLOT (3, 1, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (3, 1, 1, 2, ROM, 0x8000, 0x20000)
	MSX_LAYOUT_KANJI (0x28000)
	MSX_LAYOUT_RAMIO_SET_BITS (0x80)
MSX_LAYOUT_END

static void msx_floppy_getinfo(const device_class *devclass, UINT32 state, union devinfo *info)
{
	/* floppy */
	switch(state)
	{
		/* --- the following bits of info are returned as 64-bit signed integers --- */
		case DEVINFO_INT_COUNT:							info->i = 2; break;

		/* --- the following bits of info are returned as pointers to data or functions --- */
		case DEVINFO_PTR_LOAD:							info->load = device_load_msx_floppy; break;

		/* --- the following bits of info are returned as NULL-terminated strings --- */
		case DEVINFO_STR_FILE_EXTENSIONS:				strcpy(info->s = device_temp_str(), "dsk"); break;

		default:										legacybasicdsk_device_getinfo(devclass, state, info); break;
	}
}

static void msx_cartslot_getinfo(const device_class *devclass, UINT32 state, union devinfo *info)
{
	/* cartslot */
	switch(state)
	{
		/* --- the following bits of info are returned as 64-bit signed integers --- */
		case DEVINFO_INT_COUNT:							info->i = MSX_MAX_CARTS; break;

		/* --- the following bits of info are returned as pointers to data or functions --- */
		case DEVINFO_PTR_LOAD:							info->load = device_load_msx_cart; break;
		case DEVINFO_PTR_UNLOAD:						info->unload = device_unload_msx_cart; break;

		/* --- the following bits of info are returned as NULL-terminated strings --- */
		case DEVINFO_STR_FILE_EXTENSIONS:				strcpy(info->s = device_temp_str(), "mx1,rom"); break;

		default:										cartslot_device_getinfo(devclass, state, info); break;
	}
}

static void msx_cassette_getinfo(const device_class *devclass, UINT32 state, union devinfo *info)
{
	/* cassette */
	switch(state)
	{
		/* --- the following bits of info are returned as 64-bit signed integers --- */
		case DEVINFO_INT_COUNT:							info->i = 1; break;

		/* --- the following bits of info are returned as pointers to data or functions --- */
		case DEVINFO_PTR_CASSETTE_FORMATS:				info->p = (void *) fmsx_cassette_formats; break;

		default:										cassette_device_getinfo(devclass, state, info); break;
	}
}

static void msx_printer_getinfo(const device_class *devclass, UINT32 state, union devinfo *info)
{
	/* printer */
	switch(state)
	{
		/* --- the following bits of info are returned as 64-bit signed integers --- */
		case DEVINFO_INT_COUNT:							info->i = 1; break;

		default:										printer_device_getinfo(devclass, state, info); break;
	}
}

SYSTEM_CONFIG_START(msx)
	CONFIG_DEVICE(msx_floppy_getinfo)
	CONFIG_DEVICE(msx_cartslot_getinfo)
	CONFIG_DEVICE(msx_cassette_getinfo)
	CONFIG_DEVICE(msx_printer_getinfo)
SYSTEM_CONFIG_END

MSX_DRIVER_LIST
	MSX_DRIVER (msx) 
	MSX_DRIVER (hb75d)
	MSX_DRIVER (hb75p)
	MSX_DRIVER (hb501p)
	MSX_DRIVER (hb201p)
	MSX_DRIVER (svi738)
	MSX_DRIVER (cf2000)
	MSX_DRIVER (cf1200)
	MSX_DRIVER (cf2700)
	MSX_DRIVER (cf3000)
	MSX_DRIVER (cf3300)
	MSX_DRIVER (fs4000)
	MSX_DRIVER (fs1300)
	MSX_DRIVER (hb201)
	MSX_DRIVER (dpc100) 
	MSX_DRIVER (dpc180) 
	MSX_DRIVER (dpc200) 
	MSX_DRIVER (hotbit11) 
	MSX_DRIVER (hotbit12) 
	MSX_DRIVER (expert10) 
	MSX_DRIVER (expert11) 
	MSX_DRIVER (expertdp) 
	MSX_DRIVER (msx2) 
	MSX_DRIVER (nms8220)
	MSX_DRIVER (nms8220a)
	MSX_DRIVER (vg8235)
	MSX_DRIVER (nms8245)
	MSX_DRIVER (nms8250)
	MSX_DRIVER (nms8255)
	MSX_DRIVER (nms8280)
	MSX_DRIVER (hbf9p)
	MSX_DRIVER (hbf500p)
	MSX_DRIVER (hbf700d)
	MSX_DRIVER (hbf700p)
	MSX_DRIVER (hbf700s) 
	MSX_DRIVER (hbg900p)
	MSX_DRIVER (fs5500)
	MSX_DRIVER (fs4500)
	MSX_DRIVER (fs4700)
	MSX_DRIVER (fs5000)
	MSX_DRIVER (fs4600)
	MSX_DRIVER (fsa1)
	MSX_DRIVER (fsa1a)
	MSX_DRIVER (fsa1mk2)
	MSX_DRIVER (fsa1f)
	MSX_DRIVER (fsa1fm)
	MSX_DRIVER (hbf500)
	MSX_DRIVER (hbf900)
	MSX_DRIVER (hbf900a)
	MSX_DRIVER (hbf1)
	MSX_DRIVER (hbf12)
	MSX_DRIVER (hbf1xd)
	MSX_DRIVER (hbf1xdm2)
	MSX_DRIVER (phc23)
	MSX_DRIVER (cpc300)
	MSX_DRIVER (cpc400)
	MSX_DRIVER (cpc400s)
	MSX_DRIVER (msx2p)
	MSX_DRIVER (fsa1fx)
	MSX_DRIVER (fsa1wx)
	MSX_DRIVER (fsa1wxa)
	MSX_DRIVER (fsa1wsx)
 	MSX_DRIVER (hbf1xdj)
	MSX_DRIVER (hbf1xv)
	MSX_DRIVER (phc70fd2)
	MSX_DRIVER (phc35j)
MSX_DRIVER_END

/*	  YEAR	NAME	  PARENT	COMPAT	MACHINE  INPUT	   INIT   CONFIG  COMPANY			   FULLNAME */
COMP( 1983,	msx,	  0,		0,		msx_pal, msx,	   msx,		msx,	"ASCII & Microsoft", "MSX" , 0)
COMP( 1983, hb75d,	  msx,		0,		msx_pal, msx,      msx,		msx,	"Sony", "HB-75D (Germany)" , 0)
COMP( 1983, hb75p,	  msx,		0,		msx_pal, msx,      msx,		msx,	"Sony", "HB-75P" , 0)
COMP( 1984, hb501p,	  msx,		0,		msx_pal, msx,      msx,		msx,	"Sony", "HB-501P" , 0)
COMP( 1985, hb201p,	  msx,		0,		msx_pal, msx,      msx,		msx,	"Sony", "HB-201P" , 0)
COMP(1985, svi738,	  msx,		0,		msx_pal, msx,      msx,		msx,	"Spectravideo", "SVI-738", GAME_NOT_WORKING )
COMP( 1983, cf2000,   msx,      0,      msx,     msxjp,    msx,     msx,    "National / Matsushita", "CF-2000 (Japan)" , 0)
COMP( 1984, cf1200,   msx,      0,      msx,     msxjp,    msx,     msx,    "National / Matsushita", "CF-1200 (Japan)" , 0)
COMP( 1984, cf2700,   msx,		0,      msx,     msxjp,    msx,     msx,    "National / Matsushita", "CF-2700 (Japan)" , 0)
COMP( 1984, cf3000,   msx,		0,      msx,     msxjp,    msx,     msx,    "National / Matsushita", "CF-3000 (Japan)" , 0)
COMP(1985, cf3300,   msx,		0,      msx,     msxjp,    msx,     msx,    "National / Matsushita", "CF-3300 (Japan)", GAME_NOT_WORKING )
COMP( 1985, fs4000,   msx,      0,      msx,     msxjp,    msx,     msx,    "National / Matsushita", "FS-4000 (Japan)" , 0)
COMP( 1985, fs1300,   msx,		0,      msx,     msxjp,    msx,     msx,    "National / Matsushita", "FS-1300 (Japan)" , 0)
COMP( 1985, hb201,    msx,		0,      msx,     msxjp,    msx,     msx,    "Sony", "HB-201 (Japan)" , 0)
COMP( 1984, dpc100,	  msx,		0,		msx,	 msxkr,    msx,		msx,	"Daewoo", "IQ-1000 DPC-100 (Korea)" , 0)
COMP( 1984, dpc180,	  msx,		0,		msx,	 msxkr,    msx,		msx,	"Daewoo", "IQ-1000 DPC-180 (Korea)" , 0)
COMP( 1984, dpc200,	  msx,		0,		msx,	 msxkr,    msx,		msx,	"Daewoo", "IQ-1000 DPC-200 (Korea)" , 0)
COMP( 1985, hotbit11, msx,		0,		msx,	 hotbit,   msx,		msx,	"Sharp / Epcom",	 "HB-8000 Hotbit 1.1" , 0)
COMP( 1985, hotbit12, msx,		0,		msx,	 hotbit,   msx,		msx,	"Sharp / Epcom",	 "HB-8000 Hotbit 1.2" , 0)
COMP( 1983, expert10, msx,		0,		msx,	 expert10, msx,		msx,	"Gradiente", "Expert (Brazil)" , 0)
COMP( 1984, expert11, msx,		0,		msx,	 expert11, msx,		msx,	"Gradiente", "Expert Plus (Brazil)" , 0)
COMP(1985, expertdp, msx,		0,		msx,	 expert11, msx,		msx,	"Gradiente", "Expert DDPlus (Brazil)", GAME_NOT_WORKING )
COMP (1985, msx2,	  0,		msx,	msx2,	 msx2,	   msx2,	msx,	"ASCII & Microsoft", "MSX2", 0)
COMP (1986, nms8220,  msx2,		0,		msx2,	 msx2,	   msx2,	msx,	"Philips", "NMS-8220 / 1st released version", 0)
COMP (1986, nms8220a, msx2,		0,		msx2,	 msx2,	   msx2,	msx,	"Philips", "NMS-8220 / 2nd released version", 0)
COMP (1986, vg8235,   msx2,		0,		msx2,	 msx2,	   msx2,	msx,	"Philips", "VG-8235", 0)
COMP (1986, nms8245,  msx2,		0,		msx2,	 msx2,	   msx2,	msx,	"Philips", "NMS-8245", 0)
COMP (1986, nms8250,  msx2,		0,		msx2,	 msx2,	   msx2,	msx,	"Philips", "NMS-8250", 0)
COMP (1986, nms8255,  msx2,		0,		msx2,	 msx2,	   msx2,	msx,	"Philips", "NMS-8255", 0)
COMP (1986, nms8280,  msx2,		0,		msx2,	 msx2,	   msx2,	msx,	"Philips", "NMS-8280", 0)
COMP (1985, hbf9p,    msx2,		0,		msx2,	 msx2,	   msx2,	msx,	"Sony", "HB-F9P" , 0)
COMP (1985, hbf500p,  msx2,		0,		msx2,	 msx2,	   msx2,	msx,	"Sony", "HB-F500P", 0)
COMP (1985, hbf700d,  msx2,		0,		msx2,	 msx2,	   msx2,	msx,	"Sony", "HB-F700D (Germany)" , 0)
COMP (1985, hbf700p,  msx2,		0,		msx2,	 msx2,	   msx2,	msx,	"Sony", "HB-F700P" , 0)
COMP (1985, hbf700s,  msx2,		0,		msx2,	 msx2,	   msx2,	msx,	"Sony", "HB-F700S (Spain)", 0)
COMP(1986, hbg900p,  msx2,		0,		msx2,	 msx2,	   msx2,	msx,	"Sony", "HB-G900P", GAME_NOT_WORKING )
COMP(1985, fs5500,   msx2,		0,      msx2,    msx2jp,   msx2,    msx,    "National / Matsushita", "FS-5500F1/F2 (Japan)", GAME_NOT_WORKING )
COMP(1986, fs4500,   msx2,		0,      msx2,    msx2jp,   msx2,    msx,    "National / Matsushita", "FS-4500 (Japan)", GAME_NOT_WORKING )
COMP(1986, fs4700,   msx2,		0,      msx2,    msx2jp,   msx2,    msx,    "National / Matsushita", "FS-4700 (Japan)", GAME_NOT_WORKING )
COMP(1986, fs5000,   msx2,		0,      msx2,    msx2jp,   msx2,    msx,    "National / Matsushita", "FS-5000F2 (Japan)", GAME_NOT_WORKING )
COMP(1986, fs4600,   msx2,		0,      msx2,    msx2jp,   msx2,    msx,    "National / Matsushita", "FS-4600 (Japan)", GAME_NOT_WORKING )
COMP (1986, fsa1,     msx2,     0,      msx2,    msx2jp,   msx2,    msx,    "Panasonic / Matsushita", "FS-A1 / 1st released version (Japan)", 0)
COMP (1986, fsa1a,    msx2,     0,      msx2,    msx2jp,   msx2,    msx,    "Panasonic / Matsushita", "FS-A1 / 2nd released version (Japan)", 0)
COMP (1987, fsa1mk2,  msx2,     0,      msx2,    msx2jp,   msx2,    msx,    "Panasonic / Matsushita", "FS-A1MK2 (Japan)", 0)
COMP(1987, fsa1f,    msx2,     0,      msx2,    msx2jp,   msx2,    msx,    "Panasonic / Matsushita", "FS-A1F (Japan)", GAME_NOT_WORKING )
COMP(1987, fsa1fm,   msx2,     0,      msx2,    msx2jp,   msx2,    msx,    "Panasonic / Matsushita", "FS-A1FM (Japan)", GAME_NOT_WORKING )
COMP (1986, hbf500,   msx2,     0,      msx2,    msx2jp,   msx2,    msx,    "Sony", "HB-F500 (Japan)", 0)
COMP (1986, hbf900,   msx2,     0,      msx2,    msx2jp,   msx2,    msx,    "Sony", "HB-F900 / 1st released version (Japan)", 0)
COMP (1986, hbf900a,  msx2,     0,      msx2,    msx2jp,   msx2,    msx,    "Sony", "HB-F900 / 2nd released version (Japan)", 0)
COMP(1986, hbf1,     msx2,     0,      msx2,    msx2jp,   msx2,    msx,    "Sony", "HB-F1 (Japan)", GAME_NOT_WORKING )
COMP(1987, hbf12,    msx2,     0,      msx2,    msx2jp,   msx2,    msx,    "Sony", "HB-F1II (Japan)", GAME_NOT_WORKING )
COMP (1987, hbf1xd,   msx2,     0,      msx2,    msx2jp,   msx2,    msx,    "Sony", "HB-F1XD (Japan)", 0)
COMP (1988, hbf1xdm2, msx2,     0,      msx2,    msx2jp,   msx2,    msx,    "Sony", "HB-F1XDMK2 (Japan)", 0)
COMP (1988, phc23,    msx2,     0,      msx2,    msx2jp,   msx2,    msx,    "Sanyo", "WAVY PHC-23 (Japan)", 0)
COMP (1986, cpc300,	  msx2,		0,		msx2,	 msx2kr,   msx2,	msx,	"Daewoo", "IQ-2000 CPC-300 (Korea)", 0)
COMP(1986, cpc400,	  msx2,		0,		msx2,	 msx2kr,   msx2,	msx,	"Daewoo", "X-II CPC-400 (Korea)", GAME_NOT_WORKING )
COMP(1986, cpc400s,  msx2,		0,		msx2,	 msx2kr,   msx2,	msx,	"Daewoo", "X-II CPC-400S (Korea)", GAME_NOT_WORKING )
COMP (1988, msx2p,	  0,		msx,	msx2,	 msx2jp,   msx2,	msx,	"ASCII & Microsoft", "MSX2+", 0)
COMP(1988, fsa1fx,   msx2p,    0,      msx2,    msx2jp,   msx2,    msx,    "Panasonic / Matsushita", "FS-A1FX (Japan)", GAME_NOT_WORKING )
COMP(1988, fsa1wx,   msx2p,    0,      msx2,    msx2jp,   msx2,    msx,    "Panasonic / Matsushita", "FS-A1WX / 1st released version (Japan)", GAME_NOT_WORKING )
COMP(1988, fsa1wxa,  msx2p,    0,      msx2,    msx2jp,   msx2,    msx,    "Panasonic / Matsushita", "FS-A1WX / 2nd released version (Japan)", GAME_NOT_WORKING )
COMP(1989, fsa1wsx,  msx2p,    0,      msx2,    msx2jp,   msx2,    msx,    "Panasonic / Matsushita", "FS-A1WSX (Japan)", GAME_NOT_WORKING )
COMP(1988, hbf1xdj,  msx2p,    0,      msx2,    msx2jp,   msx2,    msx,    "Sony", "HB-F1XDJ (Japan)", GAME_NOT_WORKING )
COMP(1989, hbf1xv,   msx2p,    0,      msx2,    msx2jp,   msx2,    msx,    "Sony", "HB-F1XV (Japan)", GAME_NOT_WORKING )
COMP(1988, phc70fd,  msx2p,    0,      msx2,    msx2jp,   msx2,    msx,    "Sanyo", "WAVY PHC-70FD (Japan)", GAME_NOT_WORKING )
COMP(1988, phc70fd2, msx2p,    0,      msx2,    msx2jp,   msx2,    msx,    "Sanyo", "WAVY PHC-70FD2 (Japan)", GAME_NOT_WORKING )
COMP (1989, phc35j,   msx2p,    0,      msx2,    msx2jp,   msx2,    msx,    "Sanyo", "WAVY PHC-35J (Japan)", 0)

