/***************************************************************************
                          weatherlib.h  -  description
                             -------------------
    begin                : Wed Jul 5 2000
    copyright            : (C) 2000 by Ian Reinhart Geiser
    email                : geiseri@msoe.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef WEATHERLIB_H
#define WEATHERLIB_H
#include <qstring.h>
#include <qptrlist.h>
#include <qregexp.h>

/**
  *@author Ian Reinhart Geiser
  */

class weatherlib{
public:
    weatherlib(QString location);
    ~weatherlib();
    /** This is will tokenize the data and process it. */
    void processData(QString s, bool mode);
    /**  */
    QString temp();
    /** Will return the wind data  as a QString */
    QString wind();
    /** Will return the current airpressure */
    QString pressure();
    /** This will return the name of the icon suitable for current weather */
    QString currentIcon();
    /** Returns the date of the weather data */
    QString date(int GMT_Offset);
    /**  */
    QString weatherText();
    /** return the weather text */
    QStringList weather();
    /** return the visibility */
    QString visibility();
    /** Returns the current cover */
    QStringList cover();

private: // Private methods
    /** Parse out the current pressure. */
    void parsePressure( QString s);
    /** Parse the current visibility. */
    void parseVisibility( QString s);
    /** Parse out the current time. */
    void parseTime(QString s);
    /** Parse out the current temperature */
    void parseTemperature(QString s);
    /** Parse out the current date. */
    void parseDate(QString s);
    /** Parse the current weather conditions */
    void parseCurrent(QString s);
    /** Parse the current cover type */
    void parseCover( QString s);
    /** Parse the wind speed */
    void parseWindSpeed( QString s);
    void clearData();
    void calcCurrentIcon();

    QStringList qsCoverList;
    QStringList qsCurrentList;
    QString qsDate;
    QString qsPressure;
    QString qsTemperature;
    QString qsTime;
    QString qsVisibility;
    QString qsWindSpeed;
    QString qsWindDirection;

    QString reportLocation;

    QRegExp WindRegExp;
    QRegExp VisRegExp;
    QRegExp TempRegExp;
    QRegExp CoverRegExp;
    QRegExp CurrentRegExp;
    QRegExp TimeRegExp;
    QRegExp DateRegExp;
    QRegExp PressRegExp;

    bool MetricMode;
    /** The current weather state outside */
    QString theWeather;
    int clouds;
};

#endif
