#!/usr/bin/env python2.4
#
# Dynamic tentakel hostlist. Return all hosts from GROUP that have
# sshd running on port 22.
#
# Sebastian Stark <seb@biskalar.de>
#

import lekatnet.config, os, socket

TIMEOUT = 1.0         # seconds
PORT = 22             # scan for running sshd
GROUP = 'default'     # where to get the initial hostlist from.
                      # this is the name of some tentakel group

# load user defined configuration file
conf = lekatnet.config.ConfigBase()
conf.load(file(os.path.join(lekatnet.config._user_dir, 'tentakel.conf')))

def openPort(host):
	# simple strategy port scanner
	sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
	sock.settimeout(TIMEOUT)
	try:
		sock.connect((host, PORT))
		return True
	except socket.error:
		return False

# read group members for GROUP and return only those that have sshd running
hosts = [ x[0] for x in conf.getGroupMembers(GROUP) if openPort(x[0]) ]

print '\n'.join(hosts)
