/*
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
#include <stdlib.h>
#include <gtk/gtk.h>
#include <glib/gi18n.h>
#include "def.h"
#include "throw.h"
#include "select.h"
#include "set.h"
#include "position.h"

/* throw_card_list: get all needed cards in the 
 * list. Just make them AVAILABLE.
 */
void throw_card_list(GList *ptr)
{
	struct _card *data_ptr;
	
	for(; ptr; ptr = ptr->next)
	{
		data_ptr = ptr->data;
		
		/* This game only uses Ace, 7, 8, 9, 10, Jack, Queen and King */
		if(data_ptr->family >= 0 && data_ptr->family <= 3 
		&& (data_ptr->num == 0 || data_ptr->num > 5) )
		{
			data_ptr->dim.x = 0;
			data_ptr->dim.y = 0;
			
			data_ptr->moveable = FALSE;
			
			data_ptr->draw_face = FALSE;
			data_ptr->draw = TRUE;
			data_ptr->blink = FALSE;
			
			data_ptr->status = AVAILABLE;
		}
		else
			data_ptr->status = NOTAVAILABLE;
	}
}

/* throw_to: send a card in a list.
 */
void throw_to(GList **list, struct _card *data_ptr)
{
	/*if(data_ptr != NULL)*/
	{
		*list = g_list_prepend(*list, (gpointer)data_ptr);
	}
}

/* throw_cards: takes care of building the 
 * main shuffled pile, at the beginning of 
 * every round.
 */
void throw_cards(struct _prog *prog_data)
{
	int i, j;
	struct _card *data_ptr;
	
	srand(time(NULL));
	
	if(prog_data->distributer == -1)
		prog_data->distributer = (int) ((4.0)*rand()/(RAND_MAX+1.0));
	else
		select_player_next(&prog_data->distributer);
	
	if(prog_data->output)
		fprintf(prog_data->output, _("Player %d is distributing\n"), 
			prog_data->distributer);
	
	for(i=0;i<31;i++)
	{
		j = (int) ((32.0-i)*rand()/(RAND_MAX+1.0));
		
		
		
		data_ptr = throw_card_x(prog_data->all, j);
		
		if(data_ptr != NULL)
		{
			throw_to(&prog_data->pile, data_ptr);
			
			data_ptr->status = DISTRIBUTED;
		}

	}
	
	data_ptr = throw_card_x(prog_data->all, 0);
	
	if(data_ptr != NULL)
	{
		throw_to(&prog_data->pile, data_ptr);
		
		data_ptr->status = DISTRIBUTED;
	}
	
	
	set_status(prog_data->pile, AVAILABLE);
	
	prog_data->pile = g_list_reverse(prog_data->pile);


	position_list(prog_data->pile, 10, 5, 
		EP_DIAGONAL, 1, prog_data);
	
}

/* throw_card_x: get a pointer to the data 
 * of a GList, at position X.
 * X is the card you want on that list.
 * 
 * Example: if you send x=2, 
 * it will go to the list and scan it till 
 * it has found 3 available cards, and 
 * return a pointer to the third one. 
 * (You get it, the very first is x=0 )
 */
struct _card * throw_card_x(GList *ptr, int x)
{
	struct _card *data_ptr, *ret = NULL;
	
	int z;
	
	for( z = 0 ; ptr; ptr = ptr->next)
	{
		data_ptr = ptr->data;
		
		if(data_ptr->status == AVAILABLE)
		{
			if( x == z)
			{
				ret = data_ptr;
				return(ret);
			}
			z++;
		}
	}
	
	return(ret);
}
