/*
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
#include <gtk/gtk.h>
#include "def.h"

void clear_blink(struct _prog *prog_data)
{
	GList *lst;
	struct _card *card;
	
	if(prog_data->blinkid != -1 )
	{
		g_source_remove(prog_data->blinkid);
		prog_data->blinkid = -1;
	}
	
	for(lst = prog_data->waiting; lst; lst = lst->next)
	{
		card = lst->data;
		card->blink = FALSE;
		card->draw = TRUE;
	}

	if(prog_data->copy)
		g_object_unref(prog_data->copy);
	
	prog_data->copy = NULL;
}
