/** \file marc8.c
    \brief Character conversion, generated from ./codetables.xml

    Generated automatically by charconv.tcl
*/
#include <string.h>

        struct yaz_iconv_trie_flat {
            char from[6];
            unsigned combining : 1;
            unsigned  to : 24;
        };
        struct yaz_iconv_trie_dir {
            int ptr : 15;
            unsigned combining : 1;
            unsigned  to : 24;
        };
        
        struct yaz_iconv_trie {
            struct yaz_iconv_trie_flat *flat;
            struct yaz_iconv_trie_dir *dir;
        };
    

        static unsigned long lookup(struct yaz_iconv_trie **ptrs, int ptr, unsigned char *inp,
                                    size_t inbytesleft, size_t *no_read, int *combining, unsigned mask, int boffset)
        {
            struct yaz_iconv_trie *t = (ptr > 0) ? ptrs[ptr-1] : 0;
            if (!t || inbytesleft < 1)
                return 0;
            if (t->dir)
            {
                size_t ch = (inp[0] & mask) + boffset;
                unsigned long code =
                lookup(ptrs, t->dir[ch].ptr, inp+1, inbytesleft-1, no_read, combining, mask, boffset);
                if (code)
                {
                    (*no_read)++;
                    return code;
                }
                if (t->dir[ch].to)
                {
                    code = t->dir[ch].to;
		    *combining = t->dir[ch].combining;
                    *no_read = 1;
                    return code;
                }
            }
            else
            {
                struct yaz_iconv_trie_flat *flat = t->flat;
                while (flat->to)
                {
                    size_t len = strlen(flat->from);
                    if (len <= inbytesleft)
                    {
                        size_t i;
			for (i = 0; i < len; i++)
			{
			    if (((unsigned char *) flat->from)[i] != (inp[i] & mask) + boffset)
			        break;
		        }
                        if (i == len)
                        {
                            *no_read = len;
			    *combining = flat->combining;
                            return flat->to;
                        }
                    }
                    flat++;
                }
            }
            return 0;
        }
    
/* TRIE: size 99 */
/* PAGE 0 */
struct yaz_iconv_trie_dir marc8_42page0_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x001B} /* ESCAPE (Unlikely to occur in UCS/Unicode) */,
  {0, 0, 0},
  {0, 0, 0x001D} /* RECORD TERMINATOR / GROUP SEPARATOR */,
  {0, 0, 0x001E} /* FIELD TERMINATOR / RECORD SEPARATOR */,
  {0, 0, 0x001F} /* SUBFIELD DELIMITER / UNIT SEPARATOR */,
  {0, 0, 0x0020} /* SPACE, BLANK / SPACE */,
  {0, 0, 0x0021} /* EXCLAMATION MARK */,
  {0, 0, 0x0022} /* QUOTATION MARK */,
  {0, 0, 0x0023} /* NUMBER SIGN */,
  {0, 0, 0x0024} /* DOLLAR SIGN */,
  {0, 0, 0x0025} /* PERCENT SIGN */,
  {0, 0, 0x0026} /* AMPERSAND */,
  {0, 0, 0x0027} /* APOSTROPHE */,
  {0, 0, 0x0028} /* OPENING PARENTHESIS / LEFT PARENTHESIS */,
  {0, 0, 0x0029} /* CLOSING PARENTHESIS / CLOSING PARENTHESIS */,
  {0, 0, 0x002A} /* ASTERISK */,
  {0, 0, 0x002B} /* PLUS SIGN */,
  {0, 0, 0x002C} /* COMMA */,
  {0, 0, 0x002D} /* HYPHEN-MINUS */,
  {0, 0, 0x002E} /* PERIOD, DECIMAL POINT / FULL STOP */,
  {0, 0, 0x002F} /* SLASH / SOLIDUS */,
  {0, 0, 0x0030} /* DIGIT ZERO */,
  {0, 0, 0x0031} /* DIGIT ONE */,
  {0, 0, 0x0032} /* DIGIT TWO */,
  {0, 0, 0x0033} /* DIGIT THREE */,
  {0, 0, 0x0034} /* DIGIT FOUR */,
  {0, 0, 0x0035} /* DIGIT FIVE */,
  {0, 0, 0x0036} /* DIGIT SIX */,
  {0, 0, 0x0037} /* DIGIT SEVEN */,
  {0, 0, 0x0038} /* DIGIT EIGHT */,
  {0, 0, 0x0039} /* DIGIT NINE */,
  {0, 0, 0x003A} /* COLON */,
  {0, 0, 0x003B} /* SEMICOLON */,
  {0, 0, 0x003C} /* LESS-THAN SIGN */,
  {0, 0, 0x003D} /* EQUALS SIGN */,
  {0, 0, 0x003E} /* GREATER-THAN SIGN */,
  {0, 0, 0x003F} /* QUESTION MARK */,
  {0, 0, 0x0040} /* COMMERCIAL AT */,
  {0, 0, 0x0041} /* LATIN CAPITAL LETTER A */,
  {0, 0, 0x0042} /* LATIN CAPITAL LETTER B */,
  {0, 0, 0x0043} /* LATIN CAPITAL LETTER C */,
  {0, 0, 0x0044} /* LATIN CAPITAL LETTER D */,
  {0, 0, 0x0045} /* LATIN CAPITAL LETTER E */,
  {0, 0, 0x0046} /* LATIN CAPITAL LETTER F */,
  {0, 0, 0x0047} /* LATIN CAPITAL LETTER G */,
  {0, 0, 0x0048} /* LATIN CAPITAL LETTER H */,
  {0, 0, 0x0049} /* LATIN CAPITAL LETTER I */,
  {0, 0, 0x004A} /* LATIN CAPITAL LETTER J */,
  {0, 0, 0x004B} /* LATIN CAPITAL LETTER K */,
  {0, 0, 0x004C} /* LATIN CAPITAL LETTER L */,
  {0, 0, 0x004D} /* LATIN CAPITAL LETTER M */,
  {0, 0, 0x004E} /* LATIN CAPITAL LETTER N */,
  {0, 0, 0x004F} /* LATIN CAPITAL LETTER O */,
  {0, 0, 0x0050} /* LATIN CAPITAL LETTER P */,
  {0, 0, 0x0051} /* LATIN CAPITAL LETTER Q */,
  {0, 0, 0x0052} /* LATIN CAPITAL LETTER R */,
  {0, 0, 0x0053} /* LATIN CAPITAL LETTER S */,
  {0, 0, 0x0054} /* LATIN CAPITAL LETTER T */,
  {0, 0, 0x0055} /* LATIN CAPITAL LETTER U */,
  {0, 0, 0x0056} /* LATIN CAPITAL LETTER V */,
  {0, 0, 0x0057} /* LATIN CAPITAL LETTER W */,
  {0, 0, 0x0058} /* LATIN CAPITAL LETTER X */,
  {0, 0, 0x0059} /* LATIN CAPITAL LETTER Y */,
  {0, 0, 0x005A} /* LATIN CAPITAL LETTER Z */,
  {0, 0, 0x005B} /* OPENING SQUARE BRACKET / LEFT SQUARE BRACKET */,
  {0, 0, 0x005C} /* REVERSE SLASH / REVERSE SOLIDUS */,
  {0, 0, 0x005D} /* CLOSING SQUARE BRACKET / RIGHT SQUARE BRACKET */,
  {0, 0, 0x005E} /* SPACING CIRCUMFLEX / CIRCUMFLEX ACCENT */,
  {0, 0, 0x005F} /* SPACING UNDERSCORE / LOW LINE */,
  {0, 0, 0x0060} /* SPACING GRAVE / GRAVE ACCENT */,
  {0, 0, 0x0061} /* LATIN SMALL LETTER A */,
  {0, 0, 0x0062} /* LATIN SMALL LETTER B */,
  {0, 0, 0x0063} /* LATIN SMALL LETTER C */,
  {0, 0, 0x0064} /* LATIN SMALL LETTER D */,
  {0, 0, 0x0065} /* LATIN SMALL LETTER E */,
  {0, 0, 0x0066} /* LATIN SMALL LETTER F */,
  {0, 0, 0x0067} /* LATIN SMALL LETTER G */,
  {0, 0, 0x0068} /* LATIN SMALL LETTER H */,
  {0, 0, 0x0069} /* LATIN SMALL LETTER I */,
  {0, 0, 0x006A} /* LATIN SMALL LETTER J */,
  {0, 0, 0x006B} /* LATIN SMALL LETTER K */,
  {0, 0, 0x006C} /* LATIN SMALL LETTER L */,
  {0, 0, 0x006D} /* LATIN SMALL LETTER M */,
  {0, 0, 0x006E} /* LATIN SMALL LETTER N */,
  {0, 0, 0x006F} /* LATIN SMALL LETTER O */,
  {0, 0, 0x0070} /* LATIN SMALL LETTER P */,
  {0, 0, 0x0071} /* LATIN SMALL LETTER Q */,
  {0, 0, 0x0072} /* LATIN SMALL LETTER R */,
  {0, 0, 0x0073} /* LATIN SMALL LETTER S */,
  {0, 0, 0x0074} /* LATIN SMALL LETTER T */,
  {0, 0, 0x0075} /* LATIN SMALL LETTER U */,
  {0, 0, 0x0076} /* LATIN SMALL LETTER V */,
  {0, 0, 0x0077} /* LATIN SMALL LETTER W */,
  {0, 0, 0x0078} /* LATIN SMALL LETTER X */,
  {0, 0, 0x0079} /* LATIN SMALL LETTER Y */,
  {0, 0, 0x007A} /* LATIN SMALL LETTER Z */,
  {0, 0, 0x007B} /* OPENING CURLY BRACKET / LEFT CURLY BRACKET */,
  {0, 0, 0x007C} /* VERTICAL BAR (FILL) / VERTICAL LINE */,
  {0, 0, 0x007D} /* CLOSING CURLY BRACKET / RIGHT CURLY BRACKET */,
  {0, 0, 0x007E} /* SPACING TILDE / TILDE */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8_42page0 = {
  0, marc8_42page0_dir
};
struct yaz_iconv_trie *marc8_42ptrs [] = {
 &marc8_42page0,
0, };

unsigned long yaz_marc8_42_conv
            (unsigned char *inp, size_t inbytesleft, size_t *no_read, int *combining, unsigned mask, int boffset)
        {
            unsigned long code;
            
            code = lookup(marc8_42ptrs, 1, inp, inbytesleft, no_read, combining, mask, boffset);
            if (!code)
            {
                *no_read = 1;
            }
            return code;
        }
    
/* TRIE: size 67 */
/* PAGE 0 */
struct yaz_iconv_trie_dir marc8_45page0_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x0098} /* NON-SORT BEGIN / START OF STRING */,
  {0, 0, 0x009C} /* NON-SORT END / STRING TERMINATOR */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x200D} /* JOINER / ZERO WIDTH JOINER */,
  {0, 0, 0x200C} /* NON-JOINER / ZERO WIDTH NON-JOINER */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x0141} /* UPPERCASE POLISH L / LATIN CAPITAL LETTER L WITH STROKE */,
  {0, 0, 0x00D8} /* UPPERCASE SCANDINAVIAN O / LATIN CAPITAL LETTER O WITH STROKE */,
  {0, 0, 0x0110} /* UPPERCASE D WITH CROSSBAR / LATIN CAPITAL LETTER D WITH STROKE */,
  {0, 0, 0x00DE} /* UPPERCASE ICELANDIC THORN / LATIN CAPITAL LETTER THORN (Icelandic) */,
  {0, 0, 0x00C6} /* UPPERCASE DIGRAPH AE / LATIN CAPITAL LIGATURE AE */,
  {0, 0, 0x0152} /* UPPERCASE DIGRAPH OE / LATIN CAPITAL LIGATURE OE */,
  {0, 0, 0x02B9} /* SOFT SIGN, PRIME / MODIFIER LETTER PRIME */,
  {0, 0, 0x00B7} /* MIDDLE DOT */,
  {0, 0, 0x266D} /* MUSIC FLAT SIGN */,
  {0, 0, 0x00AE} /* PATENT MARK / REGISTERED SIGN */,
  {0, 0, 0x00B1} /* PLUS OR MINUS / PLUS-MINUS SIGN */,
  {0, 0, 0x01A0} /* UPPERCASE O-HOOK / LATIN CAPITAL LETTER O WITH HORN */,
  {0, 0, 0x01AF} /* UPPERCASE U-HOOK / LATIN CAPITAL LETTER U WITH HORN */,
  {0, 0, 0x02BC} /* ALIF / MODIFIER LETTER APOSTROPHE */,
  {0, 0, 0},
  {0, 0, 0x02BB} /* AYN / MODIFIER LETTER TURNED COMMA */,
  {0, 0, 0x0142} /* LOWERCASE POLISH L / LATIN SMALL LETTER L WITH STROKE */,
  {0, 0, 0x00F8} /* LOWERCASE SCANDINAVIAN O / LATIN SMALL LETTER O WITH STROKE */,
  {0, 0, 0x0111} /* LOWERCASE D WITH CROSSBAR / LATIN SMALL LETTER D WITH STROKE */,
  {0, 0, 0x00FE} /* LOWERCASE ICELANDIC THORN / LATIN SMALL LETTER THORN (Icelandic) */,
  {0, 0, 0x00E6} /* LOWERCASE DIGRAPH AE / LATIN SMALL LIGATURE AE */,
  {0, 0, 0x0153} /* LOWERCASE DIGRAPH OE / LATIN SMALL LIGATURE OE */,
  {0, 0, 0x02BA} /* HARD SIGN, DOUBLE PRIME / MODIFIER LETTER DOUBLE PRIME */,
  {0, 0, 0x0131} /* LOWERCASE TURKISH I / LATIN SMALL LETTER DOTLESS I */,
  {0, 0, 0x00A3} /* BRITISH POUND / POUND SIGN */,
  {0, 0, 0x00F0} /* LOWERCASE ETH / LATIN SMALL LETTER ETH (Icelandic) */,
  {0, 0, 0},
  {0, 0, 0x01A1} /* LOWERCASE O-HOOK / LATIN SMALL LETTER O WITH HORN */,
  {0, 0, 0x01B0} /* LOWERCASE U-HOOK / LATIN SMALL LETTER U WITH HORN */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x00B0} /* DEGREE SIGN */,
  {0, 0, 0x2113} /* SCRIPT SMALL L */,
  {0, 0, 0x2117} /* SOUND RECORDING COPYRIGHT */,
  {0, 0, 0x00A9} /* COPYRIGHT SIGN */,
  {0, 0, 0x266F} /* MUSIC SHARP SIGN */,
  {0, 0, 0x00BF} /* INVERTED QUESTION MARK */,
  {0, 0, 0x00A1} /* INVERTED EXCLAMATION MARK */,
  {0, 0, 0x00DF} /* ESZETT SYMBOL */,
  {0, 0, 0x20AC} /* EURO SIGN */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 1, 0x0309} /* PSEUDO QUESTION MARK / COMBINING HOOK ABOVE */,
  {0, 1, 0x0300} /* GRAVE / COMBINING GRAVE ACCENT (Varia) */,
  {0, 1, 0x0301} /* ACUTE / COMBINING ACUTE ACCENT (Oxia) */,
  {0, 1, 0x0302} /* CIRCUMFLEX / COMBINING CIRCUMFLEX ACCENT */,
  {0, 1, 0x0303} /* TILDE / COMBINING TILDE */,
  {0, 1, 0x0304} /* MACRON / COMBINING MACRON */,
  {0, 1, 0x0306} /* BREVE / COMBINING BREVE (Vrachy) */,
  {0, 1, 0x0307} /* SUPERIOR DOT / COMBINING DOT ABOVE */,
  {0, 1, 0x0308} /* UMLAUT, DIAERESIS / COMBINING DIAERESIS (Dialytika) */,
  {0, 1, 0x030C} /* HACEK / COMBINING CARON */,
  {0, 1, 0x030A} /* CIRCLE ABOVE, ANGSTROM / COMBINING RING ABOVE */,
  {0, 1, 0x0361} /* LIGATURE, FIRST HALF / COMBINING DOUBLE  				INVERTED BREVE */,
  {0, 0, 0},
  {0, 1, 0x0315} /* HIGH COMMA, OFF CENTER / COMBINING COMMA ABOVE RIGHT */,
  {0, 1, 0x030B} /* DOUBLE ACUTE / COMBINING DOUBLE ACUTE ACCENT */,
  {0, 1, 0x0310} /* CANDRABINDU / COMBINING CANDRABINDU */,
  {0, 1, 0x0327} /* CEDILLA / COMBINING CEDILLA */,
  {0, 1, 0x0328} /* RIGHT HOOK, OGONEK / COMBINING OGONEK */,
  {0, 1, 0x0323} /* DOT BELOW / COMBINING DOT BELOW */,
  {0, 1, 0x0324} /* DOUBLE DOT BELOW / COMBINING DIAERESIS BELOW */,
  {0, 1, 0x0325} /* CIRCLE BELOW / COMBINING RING BELOW */,
  {0, 1, 0x0333} /* DOUBLE UNDERSCORE / COMBINING DOUBLE LOW LINE */,
  {0, 1, 0x0332} /* UNDERSCORE / COMBINING LOW LINE */,
  {0, 1, 0x0326} /* LEFT HOOK (COMMA BELOW) / COMBINING COMMA BELOW */,
  {0, 1, 0x031C} /* RIGHT CEDILLA / COMBINING LEFT HALF RING BELOW */,
  {0, 1, 0x032E} /* UPADHMANIYA / COMBINING BREVE BELOW */,
  {0, 1, 0x0360} /* DOUBLE TILDE, FIRST HALF / COMBINING DOUBLE TILDE */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 1, 0x0313} /* HIGH COMMA, CENTERED / COMBINING COMMA ABOVE (Psili) */,
  {0, 0, 0}
};
struct yaz_iconv_trie marc8_45page0 = {
  0, marc8_45page0_dir
};
struct yaz_iconv_trie *marc8_45ptrs [] = {
 &marc8_45page0,
0, };

unsigned long yaz_marc8_45_conv
            (unsigned char *inp, size_t inbytesleft, size_t *no_read, int *combining, unsigned mask, int boffset)
        {
            unsigned long code;
            
            code = lookup(marc8_45ptrs, 1, inp, inbytesleft, no_read, combining, mask, boffset);
            if (!code)
            {
                *no_read = 1;
            }
            return code;
        }
    
/* TRIE: size 3 */
/* PAGE 0 */
struct yaz_iconv_trie_flat marc8_67page0_flat[] = {
  {"\x61", 0, 0x03B1}, /* GREEK SMALL LETTER ALPHA */
  {"\x62", 0, 0x03B2}, /* GREEK SMALL LETTER BETA */
  {"\x63", 0, 0x03B3}, /* GREEK SMALL LETTER GAMMA */
  {"", 0}
};
struct yaz_iconv_trie marc8_67page0 = {
  marc8_67page0_flat, 0
};
struct yaz_iconv_trie *marc8_67ptrs [] = {
 &marc8_67page0,
0, };

unsigned long yaz_marc8_67_conv
            (unsigned char *inp, size_t inbytesleft, size_t *no_read, int *combining, unsigned mask, int boffset)
        {
            unsigned long code;
            
            code = lookup(marc8_67ptrs, 1, inp, inbytesleft, no_read, combining, mask, boffset);
            if (!code)
            {
                *no_read = 1;
            }
            return code;
        }
    
/* TRIE: size 14 */
/* PAGE 0 */
struct yaz_iconv_trie_flat marc8_62page0_flat[] = {
  {"\x28", 0, 0x208D}, /* SUBSCRIPT OPENING PARENTHESIS / SUBSCRIPT LEFT PARENTHESIS */
  {"\x29", 0, 0x208E}, /* SUBSCRIPT CLOSING PARENTHESIS / SUBSCRIPT RIGHT PARENTHESIS */
  {"\x2B", 0, 0x208A}, /* SUBSCRIPT PLUS SIGN */
  {"\x2D", 0, 0x208B}, /* SUBSCRIPT HYPHEN-MINUS / SUBSCRIPT MINUS */
  {"\x30", 0, 0x2080}, /* SUBSCRIPT DIGIT ZERO */
  {"\x31", 0, 0x2081}, /* SUBSCRIPT DIGIT ONE */
  {"\x32", 0, 0x2082}, /* SUBSCRIPT DIGIT TWO */
  {"\x33", 0, 0x2083}, /* SUBSCRIPT DIGIT THREE */
  {"\x34", 0, 0x2084}, /* SUBSCRIPT DIGIT FOUR */
  {"\x35", 0, 0x2085}, /* SUBSCRIPT DIGIT FIVE */
  {"\x36", 0, 0x2086}, /* SUBSCRIPT DIGIT SIX */
  {"\x37", 0, 0x2087}, /* SUBSCRIPT DIGIT SEVEN */
  {"\x38", 0, 0x2088}, /* SUBSCRIPT DIGIT EIGHT */
  {"\x39", 0, 0x2089}, /* SUBSCRIPT DIGIT NINE */
  {"", 0}
};
struct yaz_iconv_trie marc8_62page0 = {
  marc8_62page0_flat, 0
};
struct yaz_iconv_trie *marc8_62ptrs [] = {
 &marc8_62page0,
0, };

unsigned long yaz_marc8_62_conv
            (unsigned char *inp, size_t inbytesleft, size_t *no_read, int *combining, unsigned mask, int boffset)
        {
            unsigned long code;
            
            code = lookup(marc8_62ptrs, 1, inp, inbytesleft, no_read, combining, mask, boffset);
            if (!code)
            {
                *no_read = 1;
            }
            return code;
        }
    
/* TRIE: size 14 */
/* PAGE 0 */
struct yaz_iconv_trie_flat marc8_70page0_flat[] = {
  {"\x28", 0, 0x207D}, /* SUPERSCRIPT OPENING PARENTHESIS / SUPERSCRIPT LEFT PARENTHESIS */
  {"\x29", 0, 0x207E}, /* SUPERSCRIPT CLOSING PARENTHESIS / SUPERSCRIPT RIGHT PARENTHESIS */
  {"\x2B", 0, 0x207A}, /* SUPERSCRIPT PLUS SIGN */
  {"\x2D", 0, 0x207B}, /* SUPERSCRIPT HYPHEN-MINUS / SUPERSCRIPT MINUS */
  {"\x30", 0, 0x2070}, /* SUPERSCRIPT DIGIT ZERO */
  {"\x31", 0, 0x00B9}, /* SUPERSCRIPT DIGIT ONE */
  {"\x32", 0, 0x00B2}, /* SUPERSCRIPT DIGIT TWO */
  {"\x33", 0, 0x00B3}, /* SUPERSCRIPT DIGIT THREE */
  {"\x34", 0, 0x2074}, /* SUPERSCRIPT DIGIT FOUR */
  {"\x35", 0, 0x2075}, /* SUPERSCRIPT DIGIT FIVE */
  {"\x36", 0, 0x2076}, /* SUPERSCRIPT DIGIT SIX */
  {"\x37", 0, 0x2077}, /* SUPERSCRIPT DIGIT SEVEN */
  {"\x38", 0, 0x2078}, /* SUPERSCRIPT DIGIT EIGHT */
  {"\x39", 0, 0x2079}, /* SUPERSCRIPT DIGIT NINE */
  {"", 0}
};
struct yaz_iconv_trie marc8_70page0 = {
  marc8_70page0_flat, 0
};
struct yaz_iconv_trie *marc8_70ptrs [] = {
 &marc8_70page0,
0, };

unsigned long yaz_marc8_70_conv
            (unsigned char *inp, size_t inbytesleft, size_t *no_read, int *combining, unsigned mask, int boffset)
        {
            unsigned long code;
            
            code = lookup(marc8_70ptrs, 1, inp, inbytesleft, no_read, combining, mask, boffset);
            if (!code)
            {
                *no_read = 1;
            }
            return code;
        }
    
/* TRIE: size 78 */
/* PAGE 0 */
struct yaz_iconv_trie_dir marc8_32page0_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x0021} /* EXCLAMATION MARK */,
  {0, 0, 0x05F4} /* QUOTATION MARK, GERSHAYIM / HEBREW PUNCTUATION GERSHAYIM */,
  {0, 0, 0x0023} /* NUMBER SIGN */,
  {0, 0, 0x0024} /* DOLLAR SIGN */,
  {0, 0, 0x0025} /* PERCENT SIGN */,
  {0, 0, 0x0026} /* AMPERSAND */,
  {0, 0, 0x05F3} /* APOSTROPHE, GERESH / HEBREW PUNCTUATION GERESH */,
  {0, 0, 0x0028} /* OPENING PARENTHESIS / LEFT PARENTHESIS */,
  {0, 0, 0x0029} /* CLOSING PARENTHESIS / RIGHT PARENTHESIS */,
  {0, 0, 0x002A} /* ASTERISK */,
  {0, 0, 0x002B} /* PLUS SIGN */,
  {0, 0, 0x002C} /* COMMA */,
  {0, 0, 0x05BE} /* HYPHEN-MINUS, MAKEF / HEBREW PUNCTUATION MAQAF */,
  {0, 0, 0x002E} /* PERIOD, DECIMAL POINT / FULL STOP */,
  {0, 0, 0x002F} /* SLASH / SOLIDUS */,
  {0, 0, 0x0030} /* DIGIT ZERO */,
  {0, 0, 0x0031} /* DIGIT ONE */,
  {0, 0, 0x0032} /* DIGIT TWO */,
  {0, 0, 0x0033} /* DIGIT THREE */,
  {0, 0, 0x0034} /* DIGIT FOUR */,
  {0, 0, 0x0035} /* DIGIT FIVE */,
  {0, 0, 0x0036} /* DIGIT SIX */,
  {0, 0, 0x0037} /* DIGIT SEVEN */,
  {0, 0, 0x0038} /* DIGIT EIGHT */,
  {0, 0, 0x0039} /* DIGIT NINE */,
  {0, 0, 0x003A} /* COLON */,
  {0, 0, 0x003B} /* SEMICOLON */,
  {0, 0, 0x003C} /* LESS-THAN SIGN */,
  {0, 0, 0x003D} /* EQUALS SIGN */,
  {0, 0, 0x003E} /* GREATER-THAN SIGN */,
  {0, 0, 0x003F} /* QUESTION MARK */,
  {0, 1, 0x05B7} /* HEBREW POINT PATAH */,
  {0, 1, 0x05B8} /* KAMATS / HEBREW POINT QAMATS */,
  {0, 1, 0x05B6} /* HEBREW POINT SEGOL */,
  {0, 1, 0x05B5} /* TSEREH / HEBREW POINT TSERE */,
  {0, 1, 0x05B4} /* HIRIK / HEBREW POINT HIRIQ */,
  {0, 1, 0x05B9} /* HOLAM, LEFT SIN DOT / HEBREW POINT HOLAM */,
  {0, 1, 0x05BB} /* KUBUTS / HEBREW POINT QUBUTS */,
  {0, 1, 0x05B0} /* HEBREW POINT SHEVA */,
  {0, 1, 0x05B2} /* HEBREW POINT HATAF PATAH */,
  {0, 1, 0x05B3} /* HATAF KAMATS / HEBREW POINT HATAF QAMATS */,
  {0, 1, 0x05B1} /* HEBREW POINT HATAF SEGOL */,
  {0, 1, 0x05BC} /* HEBREW POINT DAGESH OR MAPIQ */,
  {0, 1, 0x05BF} /* RAFEH / HEBREW POINT RAFE */,
  {0, 1, 0x05C1} /* RIGHT SHIN DOT / HEBREW POINT  SHIN DOT */,
  {0, 1, 0xFB1E} /* VARIKA / HEBREW POINT JUDEO-SPANISH VARIKA */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x005B} /* OPENING SQUARE BRACKET / LEFT SQUARE BRACKET */,
  {0, 0, 0},
  {0, 0, 0x005D} /* CLOSING SQUARE BRACKET / RIGHT SQUARE BRACKET */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x05D0} /* HEBREW LETTER ALEF */,
  {0, 0, 0x05D1} /* HEBREW LETTER BET */,
  {0, 0, 0x05D2} /* HEBREW LETTER GIMEL */,
  {0, 0, 0x05D3} /* HEBREW LETTER DALET */,
  {0, 0, 0x05D4} /* HEBREW LETTER HE */,
  {0, 0, 0x05D5} /* HEBREW LETTER VAV */,
  {0, 0, 0x05D6} /* HEBREW LETTER ZAYIN */,
  {0, 0, 0x05D7} /* HEBREW LETTER HET */,
  {0, 0, 0x05D8} /* HEBREW LETTER TET */,
  {0, 0, 0x05D9} /* HEBREW LETTER YOD */,
  {0, 0, 0x05DA} /* HEBREW LETTER FINAL KAF */,
  {0, 0, 0x05DB} /* HEBREW LETTER KAF */,
  {0, 0, 0x05DC} /* HEBREW LETTER LAMED */,
  {0, 0, 0x05DD} /* HEBREW LETTER FINAL MEM */,
  {0, 0, 0x05DE} /* HEBREW LETTER MEM */,
  {0, 0, 0x05DF} /* HEBREW LETTER FINAL NUN */,
  {0, 0, 0x05E0} /* HEBREW LETTER NUN */,
  {0, 0, 0x05E1} /* HEBREW LETTER SAMEKH */,
  {0, 0, 0x05E2} /* HEBREW LETTER AYIN */,
  {0, 0, 0x05E3} /* HEBREW LETTER FINAL PE */,
  {0, 0, 0x05E4} /* HEBREW LETTER PE */,
  {0, 0, 0x05E5} /* HEBREW LETTER FINAL TSADI */,
  {0, 0, 0x05E6} /* HEBREW LETTER TSADI */,
  {0, 0, 0x05E7} /* HEBREW LETTER QOF / KOF */,
  {0, 0, 0x05E8} /* HEBREW LETTER RESH */,
  {0, 0, 0x05E9} /* HEBREW LETTER SHIN */,
  {0, 0, 0x05EA} /* HEBREW LETTER TAV */,
  {0, 0, 0x05F0} /* HEBREW LIGATURE YIDDISH DOUBLE VAV / TSVEY VOVN */,
  {0, 0, 0x05F1} /* HEBREW LIGATURE YIDDISH VAV YOD / VOV YUD */,
  {0, 0, 0x05F2} /* HEBREW LIGATURE YIDDISH DOUBLE YOD / TSVEY YUDN */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8_32page0 = {
  0, marc8_32page0_dir
};
struct yaz_iconv_trie *marc8_32ptrs [] = {
 &marc8_32page0,
0, };

unsigned long yaz_marc8_32_conv
            (unsigned char *inp, size_t inbytesleft, size_t *no_read, int *combining, unsigned mask, int boffset)
        {
            unsigned long code;
            
            code = lookup(marc8_32ptrs, 1, inp, inbytesleft, no_read, combining, mask, boffset);
            if (!code)
            {
                *no_read = 1;
            }
            return code;
        }
    
/* TRIE: size 94 */
/* PAGE 0 */
struct yaz_iconv_trie_dir marc8_4Epage0_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x0021} /* EXCLAMATION MARK */,
  {0, 0, 0x0022} /* QUOTATION MARK */,
  {0, 0, 0x0023} /* NUMBER SIGN */,
  {0, 0, 0x0024} /* DOLLAR SIGN */,
  {0, 0, 0x0025} /* PERCENT SIGN */,
  {0, 0, 0x0026} /* AMPERSAND */,
  {0, 0, 0x0027} /* APOSTROPHE */,
  {0, 0, 0x0028} /* OPENING PARENTHESIS / LEFT PARENTHESIS */,
  {0, 0, 0x0029} /* CLOSING PARENTHESIS / RIGHT PARENTHESIS */,
  {0, 0, 0x002A} /* ASTERISK */,
  {0, 0, 0x002B} /* PLUS SIGN */,
  {0, 0, 0x002C} /* COMMA */,
  {0, 0, 0x002D} /* HYPHEN-MINUS */,
  {0, 0, 0x002E} /* PERIOD, DECIMAL POINT / FULL STOP */,
  {0, 0, 0x002F} /* SLASH / SOLIDUS */,
  {0, 0, 0x0030} /* DIGIT ZERO */,
  {0, 0, 0x0031} /* DIGIT ONE */,
  {0, 0, 0x0032} /* DIGIT TWO */,
  {0, 0, 0x0033} /* DIGIT THREE */,
  {0, 0, 0x0034} /* DIGIT FOUR */,
  {0, 0, 0x0035} /* DIGIT FIVE */,
  {0, 0, 0x0036} /* DIGIT SIX */,
  {0, 0, 0x0037} /* DIGIT SEVEN */,
  {0, 0, 0x0038} /* DIGIT EIGHT */,
  {0, 0, 0x0039} /* DIGIT NINE */,
  {0, 0, 0x003A} /* COLON */,
  {0, 0, 0x003B} /* SEMICOLON */,
  {0, 0, 0x003C} /* LESS-THAN SIGN */,
  {0, 0, 0x003D} /* EQUALS SIGN */,
  {0, 0, 0x003E} /* GREATER-THAN SIGN */,
  {0, 0, 0x003F} /* QUESTION MARK */,
  {0, 0, 0x044E} /* LOWERCASE IU / CYRILLIC SMALL LETTER YU */,
  {0, 0, 0x0430} /* CYRILLIC SMALL LETTER A */,
  {0, 0, 0x0431} /* CYRILLIC SMALL LETTER BE */,
  {0, 0, 0x0446} /* CYRILLIC SMALL LETTER TSE */,
  {0, 0, 0x0434} /* CYRILLIC SMALL LETTER DE */,
  {0, 0, 0x0435} /* CYRILLIC SMALL LETTER IE */,
  {0, 0, 0x0444} /* CYRILLIC SMALL LETTER EF */,
  {0, 0, 0x0433} /* LOWERCASE GE / CYRILLIC SMALL LETTER GHE */,
  {0, 0, 0x0445} /* LOWERCASE KHA / CYRILLIC SMALL LETTER HA */,
  {0, 0, 0x0438} /* LOWERCASE II / CYRILLIC SMALL LETTER I */,
  {0, 0, 0x0439} /* LOWERCASE SHORT II / CYRILLIC SMALL LETTER SHORT I */,
  {0, 0, 0x043A} /* CYRILLIC SMALL LETTER KA */,
  {0, 0, 0x043B} /* CYRILLIC SMALL LETTER EL */,
  {0, 0, 0x043C} /* CYRILLIC SMALL LETTER EM */,
  {0, 0, 0x043D} /* CYRILLIC SMALL LETTER EN */,
  {0, 0, 0x043E} /* CYRILLIC SMALL LETTER O */,
  {0, 0, 0x043F} /* CYRILLIC SMALL LETTER PE */,
  {0, 0, 0x044F} /* LOWERCASE IA / CYRILLIC SMALL LETTER YA */,
  {0, 0, 0x0440} /* CYRILLIC SMALL LETTER ER */,
  {0, 0, 0x0441} /* CYRILLIC SMALL LETTER ES */,
  {0, 0, 0x0442} /* CYRILLIC SMALL LETTER TE */,
  {0, 0, 0x0443} /* CYRILLIC SMALL LETTER U */,
  {0, 0, 0x0436} /* CYRILLIC SMALL LETTER ZHE */,
  {0, 0, 0x0432} /* CYRILLIC SMALL LETTER VE */,
  {0, 0, 0x044C} /* CYRILLIC SMALL LETTER SOFT SIGN */,
  {0, 0, 0x044B} /* LOWERCASE YERI / CYRILLIC SMALL LETTER YERI */,
  {0, 0, 0x0437} /* CYRILLIC SMALL LETTER ZE */,
  {0, 0, 0x0448} /* CYRILLIC SMALL LETTER SHA */,
  {0, 0, 0x044D} /* LOWERCASE REVERSED E / CYRILLIC SMALL LETTER E */,
  {0, 0, 0x0449} /* CYRILLIC SMALL LETTER SHCHA */,
  {0, 0, 0x0447} /* CYRILLIC SMALL LETTER CHE */,
  {0, 0, 0x044A} /* CYRILLIC SMALL LETTER HARD SIGN */,
  {0, 0, 0x042E} /* UPPERCASE IU / CYRILLIC CAPITAL LETTER YU */,
  {0, 0, 0x0410} /* CYRILLIC CAPITAL LETTER A */,
  {0, 0, 0x0411} /* CYRILLIC CAPITAL LETTER BE */,
  {0, 0, 0x0426} /* CYRILLIC CAPITAL LETTER TSE */,
  {0, 0, 0x0414} /* CYRILLIC CAPITAL LETTER DE */,
  {0, 0, 0x0415} /* CYRILLIC CAPITAL LETTER IE */,
  {0, 0, 0x0424} /* CYRILLIC CAPITAL LETTER EF */,
  {0, 0, 0x0413} /* UPPERCASE GE / CYRILLIC CAPITAL LETTER GHE */,
  {0, 0, 0x0425} /* UPPERCASE KHA / CYRILLIC CAPITAL LETTER HA */,
  {0, 0, 0x0418} /* UPPERCASE II / CYRILLIC CAPITAL LETTER I */,
  {0, 0, 0x0419} /* UPPERCASE SHORT II / CYRILLIC CAPITAL LETTER SHORT I */,
  {0, 0, 0x041A} /* CYRILLIC CAPITAL LETTER KA */,
  {0, 0, 0x041B} /* CYRILLIC CAPITAL LETTER EL */,
  {0, 0, 0x041C} /* CYRILLIC CAPITAL LETTER EM */,
  {0, 0, 0x041D} /* CYRILLIC CAPITAL LETTER EN */,
  {0, 0, 0x041E} /* CYRILLIC CAPITAL LETTER O */,
  {0, 0, 0x041F} /* CYRILLIC CAPITAL LETTER PE */,
  {0, 0, 0x042F} /* UPPERCASE IA / CYRILLIC CAPITAL LETTER YA */,
  {0, 0, 0x0420} /* CYRILLIC CAPITAL LETTER ER */,
  {0, 0, 0x0421} /* CYRILLIC CAPITAL LETTER ES */,
  {0, 0, 0x0422} /* CYRILLIC CAPITAL LETTER TE */,
  {0, 0, 0x0423} /* CYRILLIC CAPITAL LETTER U */,
  {0, 0, 0x0416} /* CYRILLIC CAPITAL LETTER ZHE */,
  {0, 0, 0x0412} /* CYRILLIC CAPITAL LETTER VE */,
  {0, 0, 0x042C} /* CYRILLIC CAPITAL LETTER SOFT SIGN */,
  {0, 0, 0x042B} /* UPPERCASE YERI / CYRILLIC CAPITAL LETTER YERI */,
  {0, 0, 0x0417} /* CYRILLIC CAPITAL LETTER ZE */,
  {0, 0, 0x0428} /* CYRILLIC CAPITAL LETTER SHA */,
  {0, 0, 0x042D} /* CYRILLIC CAPITAL LETTER E */,
  {0, 0, 0x0429} /* CYRILLIC CAPITAL LETTER SHCHA */,
  {0, 0, 0x0427} /* CYRILLIC CAPITAL LETTER CHE */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8_4Epage0 = {
  0, marc8_4Epage0_dir
};
struct yaz_iconv_trie *marc8_4Eptrs [] = {
 &marc8_4Epage0,
0, };

unsigned long yaz_marc8_4E_conv
            (unsigned char *inp, size_t inbytesleft, size_t *no_read, int *combining, unsigned mask, int boffset)
        {
            unsigned long code;
            
            code = lookup(marc8_4Eptrs, 1, inp, inbytesleft, no_read, combining, mask, boffset);
            if (!code)
            {
                *no_read = 1;
            }
            return code;
        }
    
/* TRIE: size 42 */
/* PAGE 0 */
struct yaz_iconv_trie_flat marc8_51page0_flat[] = {
  {"\x40", 0, 0x0491}, /* LOWERCASE GE WITH UPTURN / CYRILLIC SMALL LETTER GHE WITH UPTURN */
  {"\x41", 0, 0x0452}, /* LOWERCASE DJE / CYRILLIC SMALL LETTER DJE (Serbian) */
  {"\x42", 0, 0x0453}, /* CYRILLIC SMALL LETTER GJE */
  {"\x43", 0, 0x0454}, /* LOWERCASE E / CYRILLIC SMALL LETTER UKRAINIAN IE */
  {"\x44", 0, 0x0451}, /* CYRILLIC SMALL LETTER IO */
  {"\x45", 0, 0x0455}, /* CYRILLIC SMALL LETTER DZE */
  {"\x46", 0, 0x0456}, /* LOWERCASE I / CYRILLIC SMALL LETTER BYELORUSSIAN-UKRANIAN I */
  {"\x47", 0, 0x0457}, /* LOWERCASE YI / CYRILLIC SMALL LETTER YI (Ukrainian) */
  {"\x48", 0, 0x0458}, /* CYRILLIC SMALL LETTER JE */
  {"\x49", 0, 0x0459}, /* CYRILLIC SMALL LETTER LJE */
  {"\x4A", 0, 0x045A}, /* CYRILLIC SMALL LETTER NJE */
  {"\x4B", 0, 0x045B}, /* LOWERCASE TSHE / CYRILLIC SMALL LETTER TSHE (Serbian) */
  {"\x4C", 0, 0x045C}, /* CYRILLIC SMALL LETTER KJE */
  {"\x4D", 0, 0x045E}, /* LOWERCASE SHORT U / CYRILLIC SMALL LETTER SHORT U (Byelorussian) */
  {"\x4E", 0, 0x045F}, /* CYRILLIC SMALL LETTER DZHE */
  {"\x50", 0, 0x0463}, /* CYRILLIC SMALL LETTER YAT */
  {"\x51", 0, 0x0473}, /* CYRILLIC SMALL LETTER FITA */
  {"\x52", 0, 0x0475}, /* CYRILLIC SMALL LETTER IZHITSA */
  {"\x53", 0, 0x046B}, /* CYRILLIC SMALL LETTER BIG YUS */
  {"\x5B", 0, 0x005B}, /* OPENING SQUARE BRACKET / LEFT SQUARE BRACKET */
  {"\x5D", 0, 0x005D}, /* CLOSING SQUARE BRACKET / RIGHT SQUARE BRACKET */
  {"\x5F", 0, 0x005F}, /* SPACING UNDERSCORE / LOW LINE */
  {"\x60", 0, 0x0490}, /* UPPERCASE GE WITH UPTURN / CYRILLIC CAPITAL LETTER GHE WITH UPTURN */
  {"\x61", 0, 0x0402}, /* UPPERCASE DJE / CYRILLIC CAPITAL LETTER DJE (Serbian) */
  {"\x62", 0, 0x0403}, /* CYRILLIC CAPITAL LETTER GJE */
  {"\x63", 0, 0x0404}, /* UPPERCASE E / CYRILLIC CAPITAL LETTER UKRAINIAN IE */
  {"\x64", 0, 0x0401}, /* CYRILLIC CAPITAL LETTER IO */
  {"\x65", 0, 0x0405}, /* CYRILLIC CAPITAL LETTER DZE */
  {"\x66", 0, 0x0406}, /* UPPERCASE I / CYRILLIC CAPITAL LETTER BYELORUSSIAN-UKRANIAN I */
  {"\x67", 0, 0x0407}, /* UPPERCASE YI / CYRILLIC CAPITAL LETTER YI (Ukrainian) */
  {"\x68", 0, 0x0408}, /* CYRILLIC CAPITAL LETTER JE */
  {"\x69", 0, 0x0409}, /* CYRILLIC CAPITAL LETTER LJE */
  {"\x6A", 0, 0x040A}, /* CYRILLIC CAPITAL LETTER NJE */
  {"\x6B", 0, 0x040B}, /* UPPERCASE TSHE / CYRILLIC CAPITAL LETTER TSHE (Serbian) */
  {"\x6C", 0, 0x040C}, /* CYRILLIC CAPITAL LETTER KJE */
  {"\x6D", 0, 0x040E}, /* UPPERCASE SHORT U / CYRILLIC CAPITAL LETTER SHORT U (Byelorussian) */
  {"\x6E", 0, 0x040F}, /* CYRILLIC CAPITAL LETTER DZHE */
  {"\x6F", 0, 0x042A}, /* CYRILLIC CAPITAL LETTER HARD SIGN */
  {"\x70", 0, 0x0462}, /* CYRILLIC CAPITAL LETTER YAT */
  {"\x71", 0, 0x0472}, /* CYRILLIC CAPITAL LETTER FITA */
  {"\x72", 0, 0x0474}, /* CYRILLIC CAPITAL LETTER IZHITSA */
  {"\x73", 0, 0x046A}, /* CYRILLIC CAPITAL LETTER BIG YUS */
  {"", 0}
};
struct yaz_iconv_trie marc8_51page0 = {
  marc8_51page0_flat, 0
};
struct yaz_iconv_trie *marc8_51ptrs [] = {
 &marc8_51page0,
0, };

unsigned long yaz_marc8_51_conv
            (unsigned char *inp, size_t inbytesleft, size_t *no_read, int *combining, unsigned mask, int boffset)
        {
            unsigned long code;
            
            code = lookup(marc8_51ptrs, 1, inp, inbytesleft, no_read, combining, mask, boffset);
            if (!code)
            {
                *no_read = 1;
            }
            return code;
        }
    
/* TRIE: size 83 */
/* PAGE 0 */
struct yaz_iconv_trie_dir marc8_33page0_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x0021} /* EXCLAMATION MARK */,
  {0, 0, 0x0022} /* QUOTATION MARK */,
  {0, 0, 0x0023} /* NUMBER SIGN */,
  {0, 0, 0x0024} /* DOLLAR SIGN */,
  {0, 0, 0x066A} /* PERCENT SIGN / ARABIC PERCENT SIGN */,
  {0, 0, 0x0026} /* AMPERSAND */,
  {0, 0, 0x0027} /* APOSTROPHE */,
  {0, 0, 0x0028} /* OPENING PARENTHESIS / LEFT PARENTHESIS */,
  {0, 0, 0x0029} /* CLOSING PARENTHESIS / RIGHT PARENTHESIS */,
  {0, 0, 0x066D} /* ASTERISK / ARABIC FIVE POINTED STAR */,
  {0, 0, 0x002B} /* PLUS SIGN */,
  {0, 0, 0x060C} /* ARABIC COMMA */,
  {0, 0, 0x002D} /* HYPHEN-MINUS */,
  {0, 0, 0x002E} /* PERIOD, DECIMAL POINT / FULL STOP */,
  {0, 0, 0x002F} /* SLASH / SOLIDUS */,
  {0, 0, 0x0660} /* ARABIC-INDIC DIGIT ZERO */,
  {0, 0, 0x0661} /* ARABIC-INDIC DIGIT ONE */,
  {0, 0, 0x0662} /* ARABIC-INDIC DIGIT TWO */,
  {0, 0, 0x0663} /* ARABIC-INDIC DIGIT THREE */,
  {0, 0, 0x0664} /* ARABIC-INDIC DIGIT FOUR */,
  {0, 0, 0x0665} /* ARABIC-INDIC DIGIT FIVE */,
  {0, 0, 0x0666} /* ARABIC-INDIC DIGIT SIX */,
  {0, 0, 0x0667} /* ARABIC-INDIC DIGIT SEVEN */,
  {0, 0, 0x0668} /* ARABIC-INDIC DIGIT EIGHT */,
  {0, 0, 0x0669} /* ARABIC-INDIC DIGIT NINE */,
  {0, 0, 0x003A} /* COLON */,
  {0, 0, 0x061B} /* ARABIC SEMICOLON */,
  {0, 0, 0x003C} /* LESS-THAN SIGN */,
  {0, 0, 0x003D} /* EQUALS SIGN */,
  {0, 0, 0x003E} /* GREATER-THAN SIGN */,
  {0, 0, 0x061F} /* ARABIC QUESTION MARK */,
  {0, 0, 0},
  {0, 0, 0x0621} /* HAMZAH / ARABIC LETTER HAMZA */,
  {0, 0, 0x0622} /* ARABIC LETTER ALEF WITH MADDA ABOVE */,
  {0, 0, 0x0623} /* ARABIC LETTER ALEF WITH HAMZA ABOVE */,
  {0, 0, 0x0624} /* ARABIC LETTER WAW WITH HAMZA ABOVE */,
  {0, 0, 0x0625} /* ARABIC LETTER ALEF WITH HAMZA BELOW */,
  {0, 0, 0x0626} /* ARABIC LETTER YEH WITH HAMZA ABOVE */,
  {0, 0, 0x0627} /* ARABIC LETTER ALEF */,
  {0, 0, 0x0628} /* ARABIC LETTER BEH */,
  {0, 0, 0x0629} /* ARABIC LETTER TEH MARBUTA */,
  {0, 0, 0x062A} /* ARABIC LETTER TEH */,
  {0, 0, 0x062B} /* ARABIC LETTER THEH */,
  {0, 0, 0x062C} /* ARABIC LETTER JEEM */,
  {0, 0, 0x062D} /* ARABIC LETTER HAH */,
  {0, 0, 0x062E} /* ARABIC LETTER KHAH */,
  {0, 0, 0x062F} /* ARABIC LETTER DAL */,
  {0, 0, 0x0630} /* ARABIC LETTER THAL */,
  {0, 0, 0x0631} /* ARABIC LETTER REH */,
  {0, 0, 0x0632} /* ARABIC LETTER ZAIN */,
  {0, 0, 0x0633} /* ARABIC LETTER SEEN */,
  {0, 0, 0x0634} /* ARABIC LETTER SHEEN */,
  {0, 0, 0x0635} /* ARABIC LETTER SAD */,
  {0, 0, 0x0636} /* ARABIC LETTER DAD */,
  {0, 0, 0x0637} /* ARABIC LETTER TAH */,
  {0, 0, 0x0638} /* ARABIC LETTER ZAH */,
  {0, 0, 0x0639} /* ARABIC LETTER AIN */,
  {0, 0, 0x063A} /* ARABIC LETTER GHAIN */,
  {0, 0, 0x005B} /* OPENING SQUARE BRACKET / LEFT SQUARE BRACKET */,
  {0, 0, 0},
  {0, 0, 0x005D} /* CLOSING SQUARE BRACKET / RIGHT SQUARE BRACKET */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x0640} /* ARABIC TATWEEL */,
  {0, 0, 0x0641} /* ARABIC LETTER FEH */,
  {0, 0, 0x0642} /* ARABIC LETTER QAF */,
  {0, 0, 0x0643} /* ARABIC LETTER KAF */,
  {0, 0, 0x0644} /* ARABIC LETTER LAM */,
  {0, 0, 0x0645} /* ARABIC LETTER MEEM */,
  {0, 0, 0x0646} /* ARABIC LETTER NOON */,
  {0, 0, 0x0647} /* ARABIC LETTER HEH */,
  {0, 0, 0x0648} /* ARABIC LETTER WAW */,
  {0, 0, 0x0649} /* ARABIC LETTER ALEF MAKSURA */,
  {0, 0, 0x064A} /* ARABIC LETTER YEH */,
  {0, 1, 0x064B} /* ARABIC FATHATAN */,
  {0, 1, 0x064C} /* ARABIC DAMMATAN */,
  {0, 1, 0x064D} /* ARABIC KASRATAN */,
  {0, 1, 0x064E} /* ARABIC FATHA */,
  {0, 1, 0x064F} /* ARABIC DAMMA */,
  {0, 1, 0x0650} /* ARABIC KASRA */,
  {0, 1, 0x0651} /* ARABIC SHADDA */,
  {0, 1, 0x0652} /* ARABIC SUKUN */,
  {0, 0, 0x0671} /* ARABIC LETTER ALEF WASLA */,
  {0, 0, 0x0670} /* ARABIC LETTER SUPERSCRIPT ALEF */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x066C} /* ARABIC THOUSANDS SEPARATOR */,
  {0, 0, 0x201D} /* RIGHT DOUBLE QUOTATION MARK */,
  {0, 0, 0x201C} /* LEFT DOUBLE QUOTATION MARK */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8_33page0 = {
  0, marc8_33page0_dir
};
struct yaz_iconv_trie *marc8_33ptrs [] = {
 &marc8_33page0,
0, };

unsigned long yaz_marc8_33_conv
            (unsigned char *inp, size_t inbytesleft, size_t *no_read, int *combining, unsigned mask, int boffset)
        {
            unsigned long code;
            
            code = lookup(marc8_33ptrs, 1, inp, inbytesleft, no_read, combining, mask, boffset);
            if (!code)
            {
                *no_read = 1;
            }
            return code;
        }
    
/* TRIE: size 90 */
/* PAGE 0 */
struct yaz_iconv_trie_dir marc8_34page0_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x06FD} /* DOUBLE ALEF WITH HAMZA ABOVE / ARABIC SIGN SINDHI AMPERSAND */,
  {0, 0, 0x0672} /* ARABIC LETTER ALEF WITH WAVY HAMZA ABOVE */,
  {0, 0, 0x0673} /* ARABIC LETTER ALEF WITH WAVY HAMZA BELOW */,
  {0, 0, 0x0679} /* ARABIC LETTER TTEH */,
  {0, 0, 0x067A} /* ARABIC LETTER TTEHEH */,
  {0, 0, 0x067B} /* ARABIC LETTER BBEH */,
  {0, 0, 0x067C} /* ARABIC LETTER TEH WITH RING */,
  {0, 0, 0x067D} /* ARABIC LETTER TEH WITH THREE DOTS ABOVE DOWNWARDS */,
  {0, 0, 0x067E} /* ARABIC LETTER PEH */,
  {0, 0, 0x067F} /* ARABIC LETTER TEHEH */,
  {0, 0, 0x0680} /* ARABIC LETTER BEHEH */,
  {0, 0, 0x0681} /* ARABIC LETTER HAH WITH HAMZA ABOVE */,
  {0, 0, 0x0682} /* ARABIC LETTER HAH WITH TWO ABOVE DOTS VERTICAL ABOVE */,
  {0, 0, 0x0683} /* ARABIC LETTER NYEH */,
  {0, 0, 0x0684} /* ARABIC LETTER DYEH */,
  {0, 0, 0x0685} /* ARABIC LETTER HAH WITH THREE DOTS ABOVE */,
  {0, 0, 0x0686} /* ARABIC LETTER TCHEH */,
  {0, 0, 0x06BF} /* ARABIC LETTER TCHEH WITH DOT ABOVE */,
  {0, 0, 0x0687} /* ARABIC LETTER TCHEHEH */,
  {0, 0, 0x0688} /* ARABIC LETTER DDAL */,
  {0, 0, 0x0689} /* ARABIC LETTER DAL WITH RING */,
  {0, 0, 0x068A} /* ARABIC LETTER DAL WITH DOT BELOW */,
  {0, 0, 0x068B} /* ARABIC LETTER DAL WITH DOT BELOW AND SMALL TAH */,
  {0, 0, 0x068C} /* ARABIC LETTER DAHAL */,
  {0, 0, 0x068D} /* ARABIC LETTER DDAHAL */,
  {0, 0, 0x068E} /* ARABIC LETTER DUL */,
  {0, 0, 0x068F} /* ARABIC LETTER DAL WITH THREE DOTS ABOVE DOWNWARDS */,
  {0, 0, 0x0690} /* ARABIC LETTER DAL WITH FOUR DOTS ABOVE */,
  {0, 0, 0x0691} /* ARABIC LETTER RREH */,
  {0, 0, 0x0692} /* ARABIC LETTER REH WITH SMALL V */,
  {0, 0, 0x0693} /* ARABIC LETTER REH WITH RING */,
  {0, 0, 0x0694} /* ARABIC LETTER REH WITH DOT BELOW */,
  {0, 0, 0x0695} /* ARABIC LETTER REH WITH SMALL V BELOW */,
  {0, 0, 0x0696} /* ARABIC LETTER REH WITH DOT BELOW AND DOT ABOVE */,
  {0, 0, 0x0697} /* ARABIC LETTER REH WITH TWO DOTS ABOVE */,
  {0, 0, 0x0698} /* ARABIC LETTER JEH */,
  {0, 0, 0x0699} /* ARABIC LETTER REH WITH FOUR DOTS ABOVE */,
  {0, 0, 0x069A} /* ARABIC LETTER SEEN WITH DOT BELOW AND DOT ABOVE */,
  {0, 0, 0x069B} /* ARABIC LETTER SEEN WITH THREE DOTS BELOW */,
  {0, 0, 0x069C} /* ARABIC LETTER SEEN WITH THREE DOTS BELOW AND THREE DOTS ABOVE */,
  {0, 0, 0x06FA} /* ARABIC LETTER SHEEN WITH DOT BELOW */,
  {0, 0, 0x069D} /* ARABIC LETTER SAD WITH TWO DOTS BELOW */,
  {0, 0, 0x069E} /* ARABIC LETTER SAD WITH THREE DOTS ABOVE */,
  {0, 0, 0x06FB} /* ARABIC LETTER DAD WITH DOT BELOW */,
  {0, 0, 0x069F} /* ARABIC LETTER TAH WITH THREE DOTS ABOVE */,
  {0, 0, 0x06A0} /* ARABIC LETTER AIN WITH THREE DOTS ABOVE */,
  {0, 0, 0x06FC} /* ARABIC LETTER GHAIN WITH DOT BELOW */,
  {0, 0, 0x06A1} /* ARABIC LETTER DOTLESS FEH */,
  {0, 0, 0x06A2} /* ARABIC LETTER FEH WITH DOT MOVED BELOW */,
  {0, 0, 0x06A3} /* ARABIC LETTER FEH WITH DOT BELOW */,
  {0, 0, 0x06A4} /* ARABIC LETTER VEH */,
  {0, 0, 0x06A5} /* ARABIC LETTER FEH WITH THREE DOTS BELOW */,
  {0, 0, 0x06A6} /* ARABIC LETTER PEHEH */,
  {0, 0, 0x06A7} /* ARABIC LETTER QAF WITH DOT ABOVE */,
  {0, 0, 0x06A8} /* ARABIC LETTER QAF WITH THREE DOTS ABOVE */,
  {0, 0, 0x06A9} /* ARABIC LETTER KEHEH */,
  {0, 0, 0x06AA} /* ARABIC LETTER SWASH KAF */,
  {0, 0, 0x06AB} /* ARABIC LETTER KAF WITH RING */,
  {0, 0, 0x06AC} /* ARABIC LETTER KAF WITH DOT ABOVE */,
  {0, 0, 0x06AD} /* ARABIC LETTER NG */,
  {0, 0, 0x06AE} /* ARABIC LETTER KAF WITH THREE DOTS BELOW */,
  {0, 0, 0x06AF} /* ARABIC LETTER GAF */,
  {0, 0, 0x06B0} /* ARABIC LETTER GAF WITH RING */,
  {0, 0, 0x06B1} /* ARABIC LETTER NGOEH */,
  {0, 0, 0x06B2} /* ARABIC LETTER GAF WITH TWO DOTS BELOW */,
  {0, 0, 0x06B3} /* ARABIC LETTER GUEH */,
  {0, 0, 0x06B4} /* ARABIC LETTER GAF WITH THREE DOTS ABOVE */,
  {0, 0, 0x06B5} /* ARABIC LETTER LAM WITH SMALL V */,
  {0, 0, 0x06B6} /* ARABIC LETTER LAM WITH DOT ABOVE */,
  {0, 0, 0x06B7} /* ARABIC LETTER LAM WITH THREE DOTS ABOVE */,
  {0, 0, 0x06B8} /* ARABIC LETTER LAM WITH THREE DOTS BELOW */,
  {0, 0, 0x06BA} /* ARABIC LETTER NOON GHUNNA */,
  {0, 0, 0x06BB} /* ARABIC LETTER RNOON */,
  {0, 0, 0x06BC} /* ARABIC LETTER NOON WITH RING */,
  {0, 0, 0x06BD} /* ARABIC LETTER NOON WITH THREE DOTS ABOVE */,
  {0, 0, 0x06B9} /* ARABIC LETTER NOON WITH DOT BELOW */,
  {0, 0, 0x06BE} /* ARABIC LETTER HEH DOACHASHMEE */,
  {0, 0, 0x06C0} /* HEH WITH HAMZA ABOVE / ARABIC LETTER HEH WITH YEH ABOVE */,
  {0, 0, 0x06C4} /* ARABIC LETTER WAW WITH RING */,
  {0, 0, 0x06C5} /* KYRGHYZ OE / ARABIC LETTER KIRGHIZ OE */,
  {0, 0, 0x06C6} /* ARABIC LETTER OE */,
  {0, 0, 0x06CA} /* ARABIC LETTER WAW WITH TWO DOTS ABOVE */,
  {0, 0, 0x06CB} /* ARABIC LETTER VE */,
  {0, 0, 0x06CD} /* ARABIC LETTER YEH WITH TAIL */,
  {0, 0, 0x06CE} /* ARABIC LETTER YEH WITH SMALL V */,
  {0, 0, 0x06D0} /* ARABIC LETTER E */,
  {0, 0, 0x06D2} /* ARABIC LETTER YEH BARREE */,
  {0, 0, 0x06D3} /* ARABIC LETTER YEH BARREE WITH HAMZA ABOVE */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 1, 0x0306} /* SHORT E / COMBINING BREVE */,
  {0, 1, 0x030C} /* SHORT U / COMBINING CARON */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8_34page0 = {
  0, marc8_34page0_dir
};
struct yaz_iconv_trie *marc8_34ptrs [] = {
 &marc8_34page0,
0, };

unsigned long yaz_marc8_34_conv
            (unsigned char *inp, size_t inbytesleft, size_t *no_read, int *combining, unsigned mask, int boffset)
        {
            unsigned long code;
            
            code = lookup(marc8_34ptrs, 1, inp, inbytesleft, no_read, combining, mask, boffset);
            if (!code)
            {
                *no_read = 1;
            }
            return code;
        }
    
/* TRIE: size 73 */
/* PAGE 0 */
struct yaz_iconv_trie_dir marc8_53page0_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 1, 0x0300} /* COMBINING GRAVE ACCENT */,
  {0, 1, 0x0301} /* COMBINING ACUTE ACCENT */,
  {0, 1, 0x0308} /* COMBINING DIAERESIS */,
  {0, 1, 0x0342} /* COMBINING GREEK PERISPOMENI / CIRCUMFLEX */,
  {0, 1, 0x0313} /* COMBINING COMMA ABOVE / SMOOTH BREATHING */,
  {0, 1, 0x0314} /* COMBINING REVERSED COMMA ABOVE / ROUGH BREATHING */,
  {0, 1, 0x0345} /* COMBINING GREEK YPOGEGRAMMENI / IOTA SUBSCRIPT */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x00AB} /* LEFT-POINTING DOUBLE ANGLE QUOTATION MARK */,
  {0, 0, 0x00BB} /* RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK */,
  {0, 0, 0x201C} /* LEFT DOUBLE QUOTATION MARK */,
  {0, 0, 0x201D} /* RIGHT DOUBLE QUOTATION MARK */,
  {0, 0, 0x0374} /* GREEK NUMERAL SIGN / UPPER PRIME */,
  {0, 0, 0x0375} /* GREEK LOWER NUMERAL SIGN / LOWER PRIME */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x0387} /* GREEK ANO TELEIA / RAISED DOT, GREEK SEMICOLON */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x037E} /* GREEK QUESTION MARK */,
  {0, 0, 0},
  {0, 0, 0x0391} /* GREEK CAPITAL LETTER ALPHA */,
  {0, 0, 0x0392} /* GREEK CAPITAL LETTER BETA */,
  {0, 0, 0},
  {0, 0, 0x0393} /* GREEK CAPITAL LETTER GAMMA */,
  {0, 0, 0x0394} /* GREEK CAPITAL LETTER DELTA */,
  {0, 0, 0x0395} /* GREEK CAPITAL LETTER EPSILON */,
  {0, 0, 0x03DA} /* GREEK LETTER STIGMA */,
  {0, 0, 0x03DC} /* GREEK LETTER DIGAMMA */,
  {0, 0, 0x0396} /* GREEK CAPITAL LETTER ZETA */,
  {0, 0, 0x0397} /* GREEK CAPITAL LETTER ETA */,
  {0, 0, 0x0398} /* GREEK CAPITAL LETTER THETA */,
  {0, 0, 0x0399} /* GREEK CAPITAL LETTER IOTA */,
  {0, 0, 0x039A} /* GREEK CAPITAL LETTER KAPPA */,
  {0, 0, 0x039B} /* GREEK CAPITAL LETTER LAMDA */,
  {0, 0, 0x039C} /* GREEK CAPITAL LETTER MU */,
  {0, 0, 0x039D} /* GREEK CAPITAL LETTER NU */,
  {0, 0, 0x039E} /* GREEK CAPITAL LETTER XI */,
  {0, 0, 0x039F} /* GREEK CAPITAL LETTER OMICRON */,
  {0, 0, 0x03A0} /* GREEK CAPITAL LETTER PI */,
  {0, 0, 0x03DE} /* GREEK LETTER KOPPA */,
  {0, 0, 0x03A1} /* GREEK CAPITAL LETTER RHO */,
  {0, 0, 0x03A3} /* GREEK CAPITAL LETTER SIGMA */,
  {0, 0, 0},
  {0, 0, 0x03A4} /* GREEK CAPITAL LETTER TAU */,
  {0, 0, 0x03A5} /* GREEK CAPITAL LETTER UPSILON */,
  {0, 0, 0x03A6} /* GREEK CAPITAL LETTER PHI */,
  {0, 0, 0x03A7} /* GREEK CAPITAL LETTER CHI */,
  {0, 0, 0x03A8} /* GREEK CAPITAL LETTER PSI */,
  {0, 0, 0x03A9} /* GREEK CAPITAL LETTER OMEGA */,
  {0, 0, 0x03E0} /* GREEK LETTER SAMPI */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x03B1} /* GREEK SMALL LETTER ALPHA */,
  {0, 0, 0x03B2} /* GREEK SMALL LETTER BETA / SMALL LETTER BETA BEGINNING OF WORD */,
  {0, 0, 0x03D0} /* GREEK BETA SYMBOL / SMALL LETTER BETA MIDDLE OF WORD */,
  {0, 0, 0x03B3} /* GREEK SMALL LETTER GAMMA */,
  {0, 0, 0x03B4} /* GREEK SMALL LETTER DELTA */,
  {0, 0, 0x03B5} /* GREEK SMALL LETTER EPSILON */,
  {0, 0, 0x03DB} /* GREEK SMALL LETTER STIGMA */,
  {0, 0, 0x03DD} /* GREEK SMALL LETTER DIGAMMA */,
  {0, 0, 0x03B6} /* GREEK SMALL LETTER ZETA */,
  {0, 0, 0x03B7} /* GREEK SMALL LETTER ETA */,
  {0, 0, 0x03B8} /* GREEK SMALL LETTER THETA */,
  {0, 0, 0x03B9} /* GREEK SMALL LETTER IOTA */,
  {0, 0, 0x03BA} /* GREEK SMALL LETTER KAPPA */,
  {0, 0, 0x03BB} /* GREEK SMALL LETTER LAMDA */,
  {0, 0, 0x03BC} /* GREEK SMALL LETTER MU */,
  {0, 0, 0x03BD} /* GREEK SMALL LETTER NU */,
  {0, 0, 0x03BE} /* GREEK SMALL LETTER XI */,
  {0, 0, 0x03BF} /* GREEK SMALL LETTER OMICRON */,
  {0, 0, 0x03C0} /* GREEK SMALL LETTER PI */,
  {0, 0, 0x03DF} /* GREEK SMALL LETTER KOPPA */,
  {0, 0, 0x03C1} /* GREEK SMALL LETTER RHO */,
  {0, 0, 0x03C3} /* GREEK SMALL LETTER SIGMA */,
  {0, 0, 0x03C2} /* GREEK SMALL LETTER FINAL SIGMA / SMALL LETTER SIGMA END OF WORD */,
  {0, 0, 0x03C4} /* GREEK SMALL LETTER TAU */,
  {0, 0, 0x03C5} /* GREEK SMALL LETTER UPSILON */,
  {0, 0, 0x03C6} /* GREEK SMALL LETTER PHI */,
  {0, 0, 0x03C7} /* GREEK SMALL LETTER CHI */,
  {0, 0, 0x03C8} /* GREEK SMALL LETTER PSI */,
  {0, 0, 0x03C9} /* GREEK SMALL LETTER OMEGA */,
  {0, 0, 0x03E1} /* GREEK SMALL LETTER SAMPI */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8_53page0 = {
  0, marc8_53page0_dir
};
struct yaz_iconv_trie *marc8_53ptrs [] = {
 &marc8_53page0,
0, };

unsigned long yaz_marc8_53_conv
            (unsigned char *inp, size_t inbytesleft, size_t *no_read, int *combining, unsigned mask, int boffset)
        {
            unsigned long code;
            
            code = lookup(marc8_53ptrs, 1, inp, inbytesleft, no_read, combining, mask, boffset);
            if (!code)
            {
                *no_read = 1;
            }
            return code;
        }
    
/* TRIE: size 15739 */
/* PAGE 827 */
struct yaz_iconv_trie_flat marc8_31page827_flat[] = {
  {"\x25", 0, 0x300C}, /* Ideographic left corner bracket */
  {"\x26", 0, 0x300D}, /* Ideographic right corner bracket */
  {"\x31", 0, 0xFF3B}, /* Ideographic left square bracket */
  {"\x32", 0, 0xFF3D}, /* Ideographic right square bracket */
  {"\x33", 0, 0x3002}, /* Ideographic full stop */
  {"\x34", 0, 0xFF0E}, /* Ideographic variant full stop */
  {"\x35", 0, 0x3001}, /* Ideographic comma */
  {"\x38", 0, 0xFF0C}, /* Ideographic variant comma */
  {"\x39", 0, 0xFF1B}, /* Ideographic semicolon */
  {"\x3A", 0, 0xFF1A}, /* Ideographic colon */
  {"\x3B", 0, 0xFF1F}, /* Ideographic question mark */
  {"\x3D", 0, 0xFF01}, /* Ideographic exclamation point */
  {"\x59", 0, 0xFF0F}, /* Ideographic solidus */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page827 = {
  marc8_31page827_flat, 0
};
/* PAGE 826 */
struct yaz_iconv_trie_flat marc8_31page826_flat[] = {
  {"\x46", 0, 0x3013}, /* Ideographic geta symbol */
  {"\x21", 0, 0xE8D0}, /* EACC component character */
  {"\x22", 0, 0xE8D1}, /* EACC component character */
  {"\x23", 0, 0xE8D2}, /* EACC component character */
  {"\x24", 0, 0xE8D3}, /* EACC component character */
  {"\x25", 0, 0xE8D4}, /* EACC component character */
  {"\x26", 0, 0xE8D5}, /* EACC component character */
  {"\x28", 0, 0xE8D6}, /* EACC component character */
  {"\x29", 0, 0xE8D7}, /* EACC component character */
  {"\x2A", 0, 0xE8D8}, /* EACC component character */
  {"\x2B", 0, 0xE8D9}, /* EACC component character */
  {"\x2C", 0, 0xE8DA}, /* EACC component character */
  {"\x2D", 0, 0xE8DB}, /* EACC component character */
  {"\x2E", 0, 0xE8DC}, /* EACC component character */
  {"\x2F", 0, 0xE8DD}, /* EACC component character */
  {"\x30", 0, 0xE8DE}, /* EACC component character */
  {"\x32", 0, 0xE8DF}, /* EACC component character */
  {"\x33", 0, 0xE8E0}, /* EACC component character */
  {"\x34", 0, 0xE8E1}, /* EACC component character */
  {"\x35", 0, 0xE8E2}, /* EACC component character */
  {"\x36", 0, 0xE8E3}, /* EACC component character */
  {"\x37", 0, 0xE8E4}, /* EACC component character */
  {"\x38", 0, 0xE8E5}, /* EACC component character */
  {"\x39", 0, 0xE8E6}, /* EACC component character */
  {"\x3A", 0, 0xE8E7}, /* EACC component character */
  {"\x3B", 0, 0xE8E8}, /* EACC component character */
  {"\x3C", 0, 0xE8E9}, /* EACC component character */
  {"\x3D", 0, 0xE8EA}, /* EACC component character */
  {"\x3E", 0, 0xE8EB}, /* EACC component character */
  {"\x3F", 0, 0xE8EC}, /* EACC component character */
  {"\x40", 0, 0xE8ED}, /* EACC component character */
  {"\x41", 0, 0xE8EE}, /* EACC component character */
  {"\x42", 0, 0xE8EF}, /* EACC component character */
  {"\x43", 0, 0xE8F0}, /* EACC component character */
  {"\x44", 0, 0xE8F1}, /* EACC component character */
  {"\x45", 0, 0xE8F2}, /* EACC component character */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page826 = {
  marc8_31page826_flat, 0
};
/* PAGE 825 */
struct yaz_iconv_trie_flat marc8_31page825_flat[] = {
  {"\x21", 0, 0x3000}, /* Ideographic space per ANSI Z39.64 */
  {"\x20", 0, 0x3000}, /* Ideographic space in some implementations */
  {"\x28", 0, 0xFF08}, /* Ideographic left parenthesis */
  {"\x29", 0, 0xFF09}, /* Ideographic right parenthesis */
  {"\x2D", 0, 0xFF0D}, /* Ideographic hyphen minus */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page825 = {
  marc8_31page825_flat, 0
};
/* PAGE 824 */
struct yaz_iconv_trie_flat marc8_31page824_flat[] = {
  {"\x21", 0, 0xAD35}, /* Korean hangul */
  {"\x22", 0, 0xAD7B}, /* Korean hangul */
  {"\x23", 0, 0xE8CA}, /* Korean hangul */
  {"\x24", 0, 0xAD89}, /* Korean hangul */
  {"\x25", 0, 0xAD9D}, /* Korean hangul */
  {"\x26", 0, 0xADB9}, /* Korean hangul */
  {"\x27", 0, 0xADD5}, /* Korean hangul */
  {"\x28", 0, 0xAE07}, /* Korean hangul */
  {"\x29", 0, 0xAE0E}, /* Korean hangul */
  {"\x2A", 0, 0xAE0F}, /* Korean hangul */
  {"\x2B", 0, 0xAE11}, /* Korean hangul */
  {"\x2C", 0, 0xAE14}, /* Korean hangul */
  {"\x2D", 0, 0xAE5F}, /* Korean hangul */
  {"\x2E", 0, 0xAEED}, /* Korean hangul */
  {"\x2F", 0, 0xAF09}, /* Korean hangul */
  {"\x30", 0, 0xAF50}, /* Korean hangul */
  {"\x31", 0, 0xAFBF}, /* Korean hangul */
  {"\x32", 0, 0xB060}, /* Korean hangul */
  {"\x33", 0, 0xB9C4}, /* Korean hangul */
  {"\x34", 0, 0xC54D}, /* Korean hangul */
  {"\x35", 0, 0xC54F}, /* Korean hangul */
  {"\x36", 0, 0xC552}, /* Korean hangul */
  {"\x37", 0, 0xC5AB}, /* Korean hangul */
  {"\x38", 0, 0xC5B1}, /* Korean hangul */
  {"\x39", 0, 0xC61C}, /* Korean hangul */
  {"\x3A", 0, 0xC61D}, /* Korean hangul */
  {"\x3B", 0, 0xC6FD}, /* Korean hangul */
  {"\x3C", 0, 0xC717}, /* Korean hangul (unified with EACC 6F5658) */
  {"\x3D", 0, 0xC733}, /* Korean hangul */
  {"\x3E", 0, 0xCB4C}, /* Korean hangul */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page824 = {
  marc8_31page824_flat, 0
};
/* PAGE 823 */
struct yaz_iconv_trie_flat marc8_31page823_flat[] = {
  {"\x21", 0, 0x3181}, /* Korean hangul */
  {"\x22", 0, 0x3186}, /* Korean hangul */
  {"\x23", 0, 0x317F}, /* Korean hangul */
  {"\x24", 0, 0xE8B0}, /* Korean hangul (ancient) */
  {"\x25", 0, 0x318D}, /* Korean hangul (ancient) */
  {"\x40", 0, 0xE8B2}, /* Korean hangul (ancient) */
  {"\x41", 0, 0xE8B3}, /* Korean hangul (ancient) */
  {"\x42", 0, 0xE8B4}, /* Korean hangul (ancient) */
  {"\x43", 0, 0xE8B5}, /* Korean hangul (ancient) */
  {"\x44", 0, 0xE8B6}, /* Korean hangul (ancient) */
  {"\x45", 0, 0xE8B7}, /* Korean hangul (ancient) */
  {"\x46", 0, 0xE8B8}, /* Korean hangul (ancient) */
  {"\x47", 0, 0xE8B9}, /* Korean hangul (ancient) */
  {"\x48", 0, 0xE8BA}, /* Korean hangul (ancient) */
  {"\x49", 0, 0xE8BB}, /* Korean hangul (ancient) */
  {"\x4A", 0, 0xE8BC}, /* Korean hangul (ancient) */
  {"\x4B", 0, 0xE8BD}, /* Korean hangul (ancient) */
  {"\x4C", 0, 0xE8BE}, /* Korean hangul (ancient) */
  {"\x4D", 0, 0xE8BF}, /* Korean hangul (ancient) */
  {"\x4E", 0, 0xE8C0}, /* Korean hangul (ancient) */
  {"\x4F", 0, 0xE8C1}, /* Korean hangul (ancient) */
  {"\x50", 0, 0xE8C2}, /* Korean hangul (ancient) */
  {"\x51", 0, 0xE8C3}, /* Korean hangul (ancient) */
  {"\x52", 0, 0xE8C4}, /* Korean hangul (ancient) */
  {"\x53", 0, 0xE8C5}, /* Korean hangul (ancient) */
  {"\x54", 0, 0xE8C6}, /* Korean hangul (ancient) */
  {"\x55", 0, 0xE8C7}, /* Korean hangul (ancient) */
  {"\x56", 0, 0xE8C8}, /* Korean hangul (ancient) */
  {"\x57", 0, 0xE8C9}, /* Korean hangul (ancient) */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page823 = {
  marc8_31page823_flat, 0
};
/* PAGE 822 */
struct yaz_iconv_trie_flat marc8_31page822_flat[] = {
  {"\x21", 0, 0xD79D}, /* Korean hangul */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page822 = {
  marc8_31page822_flat, 0
};
/* PAGE 821 */
struct yaz_iconv_trie_dir marc8_31page821_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0xD5D9} /* Korean hangul */,
  {0, 0, 0xD5DB} /* Korean hangul */,
  {0, 0, 0xD5DD} /* Korean hangul */,
  {0, 0, 0xD5E4} /* Korean hangul */,
  {0, 0, 0xD5E5} /* Korean hangul */,
  {0, 0, 0xD5E8} /* Korean hangul */,
  {0, 0, 0xD5EC} /* Korean hangul */,
  {0, 0, 0xD5F4} /* Korean hangul */,
  {0, 0, 0xD5F5} /* Korean hangul */,
  {0, 0, 0xD5F7} /* Korean hangul */,
  {0, 0, 0xD5F9} /* Korean hangul */,
  {0, 0, 0xD600} /* Korean hangul */,
  {0, 0, 0xD601} /* Korean hangul */,
  {0, 0, 0xD604} /* Korean hangul */,
  {0, 0, 0xD608} /* Korean hangul */,
  {0, 0, 0xD610} /* Korean hangul */,
  {0, 0, 0xD611} /* Korean hangul */,
  {0, 0, 0xD613} /* Korean hangul */,
  {0, 0, 0xD614} /* Korean hangul */,
  {0, 0, 0xD615} /* Korean hangul */,
  {0, 0, 0xD61C} /* Korean hangul */,
  {0, 0, 0xD638} /* Korean hangul */,
  {0, 0, 0xD639} /* Korean hangul */,
  {0, 0, 0xD63C} /* Korean hangul */,
  {0, 0, 0xD640} /* Korean hangul */,
  {0, 0, 0xD648} /* Korean hangul */,
  {0, 0, 0xD649} /* Korean hangul */,
  {0, 0, 0xD64B} /* Korean hangul */,
  {0, 0, 0xD64D} /* Korean hangul */,
  {0, 0, 0},
  {0, 0, 0xD654} /* Korean hangul */,
  {0, 0, 0xD655} /* Korean hangul */,
  {0, 0, 0xD658} /* Korean hangul */,
  {0, 0, 0xD65C} /* Korean hangul */,
  {0, 0, 0},
  {0, 0, 0xD667} /* Korean hangul */,
  {0, 0, 0xD669} /* Korean hangul */,
  {0, 0, 0xD670} /* Korean hangul */,
  {0, 0, 0xD671} /* Korean hangul */,
  {0, 0, 0xD683} /* Korean hangul */,
  {0, 0, 0},
  {0, 0, 0xD68C} /* Korean hangul */,
  {0, 0, 0xD68D} /* Korean hangul */,
  {0, 0, 0xD69F} /* Korean hangul */,
  {0, 0, 0xD6A1} /* Korean hangul */,
  {0, 0, 0xD6A8} /* Korean hangul */,
  {0, 0, 0xD6C4} /* Korean hangul */,
  {0, 0, 0xD6C5} /* Korean hangul */,
  {0, 0, 0xD6C8} /* Korean hangul */,
  {0, 0, 0xD6CC} /* Korean hangul */,
  {0, 0, 0xD6D1} /* Korean hangul */,
  {0, 0, 0xD6D4} /* Korean hangul */,
  {0, 0, 0xD6D7} /* Korean hangul */,
  {0, 0, 0xD6E0} /* Korean hangul */,
  {0, 0, 0xD6E4} /* Korean hangul */,
  {0, 0, 0xD6E8} /* Korean hangul */,
  {0, 0, 0xD6F0} /* Korean hangul */,
  {0, 0, 0xD6FC} /* Korean hangul */,
  {0, 0, 0},
  {0, 0, 0xD700} /* Korean hangul */,
  {0, 0, 0xD711} /* Korean hangul */,
  {0, 0, 0xD718} /* Korean hangul */,
  {0, 0, 0xD719} /* Korean hangul */,
  {0, 0, 0xD71C} /* Korean hangul */,
  {0, 0, 0xD720} /* Korean hangul */,
  {0, 0, 0xD728} /* Korean hangul */,
  {0, 0, 0xD729} /* Korean hangul */,
  {0, 0, 0},
  {0, 0, 0xD72D} /* Korean hangul */,
  {0, 0, 0xD734} /* Korean hangul */,
  {0, 0, 0xD73C} /* Korean hangul */,
  {0, 0, 0xD744} /* Korean hangul */,
  {0, 0, 0xD749} /* Korean hangul */,
  {0, 0, 0xD750} /* Korean hangul */,
  {0, 0, 0xD751} /* Korean hangul */,
  {0, 0, 0xD754} /* Korean hangul */,
  {0, 0, 0xD757} /* Korean hangul */,
  {0, 0, 0xD758} /* Korean hangul */,
  {0, 0, 0xD759} /* Korean hangul */,
  {0, 0, 0xD760} /* Korean hangul */,
  {0, 0, 0xD761} /* Korean hangul */,
  {0, 0, 0xD763} /* Korean hangul */,
  {0, 0, 0xD765} /* Korean hangul */,
  {0, 0, 0xD769} /* Korean hangul */,
  {0, 0, 0xD76C} /* Korean hangul */,
  {0, 0, 0xD770} /* Korean hangul */,
  {0, 0, 0xD774} /* Korean hangul */,
  {0, 0, 0xD788} /* Korean hangul */,
  {0, 0, 0xD789} /* Korean hangul */,
  {0, 0, 0xD78C} /* Korean hangul */,
  {0, 0, 0xD790} /* Korean hangul */,
  {0, 0, 0xD798} /* Korean hangul */,
  {0, 0, 0xD799} /* Korean hangul */,
  {0, 0, 0xD79B} /* Korean hangul */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8_31page821 = {
  0, marc8_31page821_dir
};
/* PAGE 820 */
struct yaz_iconv_trie_dir marc8_31page820_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0xD33D} /* Korean hangul */,
  {0, 0, 0},
  {0, 0, 0xD37C} /* Korean hangul */,
  {0, 0, 0xD37D} /* Korean hangul */,
  {0, 0, 0xD380} /* Korean hangul */,
  {0, 0, 0xD384} /* Korean hangul */,
  {0, 0, 0xD38C} /* Korean hangul */,
  {0, 0, 0xD38D} /* Korean hangul */,
  {0, 0, 0xD38F} /* Korean hangul */,
  {0, 0, 0xD390} /* Korean hangul */,
  {0, 0, 0xD391} /* Korean hangul */,
  {0, 0, 0xD398} /* Korean hangul */,
  {0, 0, 0xD399} /* Korean hangul */,
  {0, 0, 0xD39C} /* Korean hangul */,
  {0, 0, 0xD3A0} /* Korean hangul */,
  {0, 0, 0xD3A8} /* Korean hangul */,
  {0, 0, 0xD3A9} /* Korean hangul */,
  {0, 0, 0xD3AB} /* Korean hangul */,
  {0, 0, 0xD3AD} /* Korean hangul */,
  {0, 0, 0xD3B4} /* Korean hangul */,
  {0, 0, 0xD3B5} /* Korean hangul */,
  {0, 0, 0xD3B8} /* Korean hangul */,
  {0, 0, 0xD3BC} /* Korean hangul */,
  {0, 0, 0xD3C4} /* Korean hangul */,
  {0, 0, 0xD3C5} /* Korean hangul */,
  {0, 0, 0xD3C8} /* Korean hangul */,
  {0, 0, 0xD3C9} /* Korean hangul */,
  {0, 0, 0xD3D0} /* Korean hangul */,
  {0, 0, 0xD3EC} /* Korean hangul */,
  {0, 0, 0xD3ED} /* Korean hangul */,
  {0, 0, 0xD3F0} /* Korean hangul */,
  {0, 0, 0xD3F4} /* Korean hangul */,
  {0, 0, 0xD3FC} /* Korean hangul */,
  {0, 0, 0xD3FD} /* Korean hangul */,
  {0, 0, 0xD3FF} /* Korean hangul */,
  {0, 0, 0xD401} /* Korean hangul */,
  {0, 0, 0xD440} /* Korean hangul */,
  {0, 0, 0xD444} /* Korean hangul */,
  {0, 0, 0xD45C} /* Korean hangul */,
  {0, 0, 0xD46F} /* Korean hangul */,
  {0, 0, 0xD478} /* Korean hangul */,
  {0, 0, 0xD479} /* Korean hangul */,
  {0, 0, 0xD47C} /* Korean hangul */,
  {0, 0, 0xD480} /* Korean hangul */,
  {0, 0, 0xD488} /* Korean hangul */,
  {0, 0, 0xD489} /* Korean hangul */,
  {0, 0, 0xD48B} /* Korean hangul */,
  {0, 0, 0xD48D} /* Korean hangul */,
  {0, 0, 0xD4CC} /* Korean hangul */,
  {0, 0, 0xD4E8} /* Korean hangul */,
  {0, 0, 0xD504} /* Korean hangul */,
  {0, 0, 0},
  {0, 0, 0xD508} /* Korean hangul */,
  {0, 0, 0xD50C} /* Korean hangul */,
  {0, 0, 0xD514} /* Korean hangul */,
  {0, 0, 0xD515} /* Korean hangul */,
  {0, 0, 0xD53C} /* Korean hangul */,
  {0, 0, 0xD53D} /* Korean hangul */,
  {0, 0, 0xD540} /* Korean hangul */,
  {0, 0, 0xD544} /* Korean hangul */,
  {0, 0, 0xD54C} /* Korean hangul */,
  {0, 0, 0xD54D} /* Korean hangul */,
  {0, 0, 0xD54F} /* Korean hangul */,
  {0, 0, 0xD551} /* Korean hangul */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0xD558} /* Korean hangul */,
  {0, 0, 0xD559} /* Korean hangul */,
  {0, 0, 0xD55C} /* Korean hangul */,
  {0, 0, 0xD560} /* Korean hangul */,
  {0, 0, 0xD565} /* Korean hangul */,
  {0, 0, 0xD568} /* Korean hangul */,
  {0, 0, 0xD569} /* Korean hangul */,
  {0, 0, 0xD56B} /* Korean hangul */,
  {0, 0, 0xD56C} /* Korean hangul */,
  {0, 0, 0xD56D} /* Korean hangul */,
  {0, 0, 0xD571} /* Korean hangul */,
  {0, 0, 0xD574} /* Korean hangul */,
  {0, 0, 0xD575} /* Korean hangul */,
  {0, 0, 0xD578} /* Korean hangul */,
  {0, 0, 0xD57C} /* Korean hangul */,
  {0, 0, 0xD584} /* Korean hangul */,
  {0, 0, 0xD585} /* Korean hangul */,
  {0, 0, 0xD587} /* Korean hangul */,
  {0, 0, 0xD588} /* Korean hangul */,
  {0, 0, 0xD589} /* Korean hangul */,
  {0, 0, 0xD590} /* Korean hangul */,
  {0, 0, 0xD5A5} /* Korean hangul */,
  {0, 0, 0xD5C8} /* Korean hangul */,
  {0, 0, 0xD5C9} /* Korean hangul */,
  {0, 0, 0xD5CC} /* Korean hangul */,
  {0, 0, 0xD5D0} /* Korean hangul */,
  {0, 0, 0xD5D2} /* Korean hangul */,
  {0, 0, 0xD5D8} /* Korean hangul */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8_31page820 = {
  0, marc8_31page820_dir
};
/* PAGE 819 */
struct yaz_iconv_trie_dir marc8_31page819_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0xD0ED} /* Korean hangul */,
  {0, 0, 0xD0EF} /* Korean hangul */,
  {0, 0, 0xD0F0} /* Korean hangul */,
  {0, 0, 0xD0F1} /* Korean hangul */,
  {0, 0, 0xD130} /* Korean hangul */,
  {0, 0, 0xD131} /* Korean hangul */,
  {0, 0, 0xD134} /* Korean hangul */,
  {0, 0, 0xD138} /* Korean hangul */,
  {0, 0, 0xD140} /* Korean hangul */,
  {0, 0, 0xD141} /* Korean hangul */,
  {0, 0, 0xD143} /* Korean hangul */,
  {0, 0, 0xD144} /* Korean hangul */,
  {0, 0, 0xD145} /* Korean hangul */,
  {0, 0, 0xD14C} /* Korean hangul */,
  {0, 0, 0xD14D} /* Korean hangul */,
  {0, 0, 0xD150} /* Korean hangul */,
  {0, 0, 0xD154} /* Korean hangul */,
  {0, 0, 0xD15C} /* Korean hangul */,
  {0, 0, 0xD15D} /* Korean hangul */,
  {0, 0, 0xD15F} /* Korean hangul */,
  {0, 0, 0xD160} /* Korean hangul */,
  {0, 0, 0xD161} /* Korean hangul */,
  {0, 0, 0xD168} /* Korean hangul */,
  {0, 0, 0xD1A0} /* Korean hangul */,
  {0, 0, 0xD1A1} /* Korean hangul */,
  {0, 0, 0xD1A4} /* Korean hangul */,
  {0, 0, 0xD1A8} /* Korean hangul */,
  {0, 0, 0xD1B0} /* Korean hangul */,
  {0, 0, 0xD1B1} /* Korean hangul */,
  {0, 0, 0xD1B3} /* Korean hangul */,
  {0, 0, 0xD1B5} /* Korean hangul */,
  {0, 0, 0xD1D8} /* Korean hangul */,
  {0, 0, 0xD1F4} /* Korean hangul */,
  {0, 0, 0},
  {0, 0, 0xD22C} /* Korean hangul */,
  {0, 0, 0xD22D} /* Korean hangul */,
  {0, 0, 0xD230} /* Korean hangul */,
  {0, 0, 0xD234} /* Korean hangul */,
  {0, 0, 0xD23C} /* Korean hangul */,
  {0, 0, 0xD23D} /* Korean hangul */,
  {0, 0, 0xD23F} /* Korean hangul */,
  {0, 0, 0xD241} /* Korean hangul */,
  {0, 0, 0xD264} /* Korean hangul */,
  {0, 0, 0xD277} /* Korean hangul */,
  {0, 0, 0xD280} /* Korean hangul */,
  {0, 0, 0xD284} /* Korean hangul */,
  {0, 0, 0xD288} /* Korean hangul */,
  {0, 0, 0xD290} /* Korean hangul */,
  {0, 0, 0xD291} /* Korean hangul */,
  {0, 0, 0xD293} /* Korean hangul */,
  {0, 0, 0xD295} /* Korean hangul */,
  {0, 0, 0xD29C} /* Korean hangul */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0xD2AC} /* Korean hangul */,
  {0, 0, 0},
  {0, 0, 0xD2B8} /* Korean hangul */,
  {0, 0, 0xD2B9} /* Korean hangul */,
  {0, 0, 0xD2BC} /* Korean hangul */,
  {0, 0, 0xD2BF} /* Korean hangul */,
  {0, 0, 0xD2C0} /* Korean hangul */,
  {0, 0, 0xD2C8} /* Korean hangul */,
  {0, 0, 0xD2C9} /* Korean hangul */,
  {0, 0, 0xD2CB} /* Korean hangul */,
  {0, 0, 0xD2D4} /* Korean hangul */,
  {0, 0, 0xD1F8} /* Korean hangul */,
  {0, 0, 0xD2F0} /* Korean hangul */,
  {0, 0, 0xD2F1} /* Korean hangul */,
  {0, 0, 0xD2F4} /* Korean hangul */,
  {0, 0, 0xD2F8} /* Korean hangul */,
  {0, 0, 0xD300} /* Korean hangul */,
  {0, 0, 0xD301} /* Korean hangul */,
  {0, 0, 0xD305} /* Korean hangul */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0xD30C} /* Korean hangul */,
  {0, 0, 0xD30D} /* Korean hangul */,
  {0, 0, 0xD30E} /* Korean hangul */,
  {0, 0, 0xD310} /* Korean hangul */,
  {0, 0, 0xD314} /* Korean hangul */,
  {0, 0, 0xD31C} /* Korean hangul */,
  {0, 0, 0xD31D} /* Korean hangul */,
  {0, 0, 0xD31F} /* Korean hangul */,
  {0, 0, 0xD320} /* Korean hangul */,
  {0, 0, 0xD321} /* Korean hangul */,
  {0, 0, 0xD325} /* Korean hangul */,
  {0, 0, 0xD328} /* Korean hangul */,
  {0, 0, 0xD329} /* Korean hangul */,
  {0, 0, 0xD32C} /* Korean hangul */,
  {0, 0, 0xD330} /* Korean hangul */,
  {0, 0, 0xD338} /* Korean hangul */,
  {0, 0, 0xD339} /* Korean hangul */,
  {0, 0, 0xD33B} /* Korean hangul */,
  {0, 0, 0xD33C} /* Korean hangul */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8_31page819 = {
  0, marc8_31page819_dir
};
/* PAGE 818 */
struct yaz_iconv_trie_dir marc8_31page818_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0xCEA5} /* Korean hangul */,
  {0, 0, 0xCEAC} /* Korean hangul */,
  {0, 0, 0xCEAD} /* Korean hangul */,
  {0, 0, 0xCEE4} /* Korean hangul */,
  {0, 0, 0},
  {0, 0, 0xCEE8} /* Korean hangul */,
  {0, 0, 0xCEEC} /* Korean hangul */,
  {0, 0, 0xCEF4} /* Korean hangul */,
  {0, 0, 0xCEF5} /* Korean hangul */,
  {0, 0, 0xCEF7} /* Korean hangul */,
  {0, 0, 0},
  {0, 0, 0xCEF9} /* Korean hangul */,
  {0, 0, 0},
  {0, 0, 0xCF00} /* Korean hangul */,
  {0, 0, 0xCF01} /* Korean hangul */,
  {0, 0, 0xCF04} /* Korean hangul */,
  {0, 0, 0xCF08} /* Korean hangul */,
  {0, 0, 0xCF10} /* Korean hangul */,
  {0, 0, 0xCF11} /* Korean hangul */,
  {0, 0, 0xCF13} /* Korean hangul */,
  {0, 0, 0xCF15} /* Korean hangul */,
  {0, 0, 0xCF1C} /* Korean hangul */,
  {0, 0, 0xCF20} /* Korean hangul */,
  {0, 0, 0xCF24} /* Korean hangul */,
  {0, 0, 0xCF2C} /* Korean hangul */,
  {0, 0, 0xCF2D} /* Korean hangul */,
  {0, 0, 0xCF2F} /* Korean hangul */,
  {0, 0, 0xCF30} /* Korean hangul */,
  {0, 0, 0xCF54} /* Korean hangul */,
  {0, 0, 0xCF55} /* Korean hangul */,
  {0, 0, 0xCF58} /* Korean hangul */,
  {0, 0, 0xCF5C} /* Korean hangul */,
  {0, 0, 0xCF64} /* Korean hangul */,
  {0, 0, 0xCF65} /* Korean hangul */,
  {0, 0, 0xCF67} /* Korean hangul */,
  {0, 0, 0xCF69} /* Korean hangul */,
  {0, 0, 0xCF70} /* Korean hangul */,
  {0, 0, 0xCF71} /* Korean hangul */,
  {0, 0, 0xCF74} /* Korean hangul */,
  {0, 0, 0xCF78} /* Korean hangul */,
  {0, 0, 0xCF80} /* Korean hangul */,
  {0, 0, 0xCF85} /* Korean hangul */,
  {0, 0, 0xCF8C} /* Korean hangul */,
  {0, 0, 0xCF8D} /* Korean hangul */,
  {0, 0, 0xCFA1} /* Korean hangul */,
  {0, 0, 0},
  {0, 0, 0xCFB0} /* Korean hangul */,
  {0, 0, 0xCFC4} /* Korean hangul */,
  {0, 0, 0xCFE0} /* Korean hangul */,
  {0, 0, 0xCFE1} /* Korean hangul */,
  {0, 0, 0xCFE4} /* Korean hangul */,
  {0, 0, 0xCFE8} /* Korean hangul */,
  {0, 0, 0xCFF0} /* Korean hangul */,
  {0, 0, 0xCFF3} /* Korean hangul */,
  {0, 0, 0xCFF5} /* Korean hangul */,
  {0, 0, 0xCFFC} /* Korean hangul */,
  {0, 0, 0},
  {0, 0, 0xD018} /* Korean hangul */,
  {0, 0, 0xD02D} /* Korean hangul */,
  {0, 0, 0xD034} /* Korean hangul */,
  {0, 0, 0xD035} /* Korean hangul */,
  {0, 0, 0xD038} /* Korean hangul */,
  {0, 0, 0xD050} /* Korean hangul */,
  {0, 0, 0xD06C} /* Korean hangul */,
  {0, 0, 0xD070} /* Korean hangul */,
  {0, 0, 0xD074} /* Korean hangul */,
  {0, 0, 0xD07C} /* Korean hangul */,
  {0, 0, 0xD07D} /* Korean hangul */,
  {0, 0, 0xD081} /* Korean hangul */,
  {0, 0, 0xD0A4} /* Korean hangul */,
  {0, 0, 0xD0A5} /* Korean hangul */,
  {0, 0, 0xD0A8} /* Korean hangul */,
  {0, 0, 0xD0AC} /* Korean hangul */,
  {0, 0, 0xD0B4} /* Korean hangul */,
  {0, 0, 0xD0B5} /* Korean hangul */,
  {0, 0, 0xD0B7} /* Korean hangul */,
  {0, 0, 0xD0B9} /* Korean hangul */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0xD0C0} /* Korean hangul */,
  {0, 0, 0xD0C1} /* Korean hangul */,
  {0, 0, 0xD0C4} /* Korean hangul */,
  {0, 0, 0xD0C8} /* Korean hangul */,
  {0, 0, 0xD0C9} /* Korean hangul */,
  {0, 0, 0xD0D0} /* Korean hangul */,
  {0, 0, 0xD0D1} /* Korean hangul */,
  {0, 0, 0xD0D3} /* Korean hangul */,
  {0, 0, 0xD0D4} /* Korean hangul */,
  {0, 0, 0xD0D5} /* Korean hangul */,
  {0, 0, 0xD0DC} /* Korean hangul */,
  {0, 0, 0xD0DD} /* Korean hangul */,
  {0, 0, 0xD0E0} /* Korean hangul */,
  {0, 0, 0xD0E4} /* Korean hangul */,
  {0, 0, 0xD0EC} /* Korean hangul */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8_31page818 = {
  0, marc8_31page818_dir
};
/* PAGE 817 */
struct yaz_iconv_trie_dir marc8_31page817_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0xCC29} /* Korean hangul */,
  {0, 0, 0xCC2C} /* Korean hangul */,
  {0, 0, 0xCC2E} /* Korean hangul */,
  {0, 0, 0xCC2F} /* Korean hangul */,
  {0, 0, 0xCC30} /* Korean hangul */,
  {0, 0, 0xCC38} /* Korean hangul */,
  {0, 0, 0xCC39} /* Korean hangul */,
  {0, 0, 0xCC3B} /* Korean hangul */,
  {0, 0, 0xCC3C} /* Korean hangul */,
  {0, 0, 0xCC3D} /* Korean hangul */,
  {0, 0, 0xCC3E} /* Korean hangul */,
  {0, 0, 0xCC3F} /* Korean hangul */,
  {0, 0, 0xCC44} /* Korean hangul */,
  {0, 0, 0xCC45} /* Korean hangul */,
  {0, 0, 0xCC48} /* Korean hangul */,
  {0, 0, 0xCC4C} /* Korean hangul */,
  {0, 0, 0xCC54} /* Korean hangul */,
  {0, 0, 0xCC55} /* Korean hangul */,
  {0, 0, 0xCC58} /* Korean hangul */,
  {0, 0, 0xCC59} /* Korean hangul */,
  {0, 0, 0xCC60} /* Korean hangul */,
  {0, 0, 0xCC64} /* Korean hangul */,
  {0, 0, 0xCC70} /* Korean hangul */,
  {0, 0, 0xCC71} /* Korean hangul */,
  {0, 0, 0xCC98} /* Korean hangul */,
  {0, 0, 0xCC99} /* Korean hangul */,
  {0, 0, 0xCC9C} /* Korean hangul */,
  {0, 0, 0xCCA0} /* Korean hangul */,
  {0, 0, 0xCCA8} /* Korean hangul */,
  {0, 0, 0xCCA9} /* Korean hangul */,
  {0, 0, 0xCCAB} /* Korean hangul */,
  {0, 0, 0xCCAD} /* Korean hangul */,
  {0, 0, 0xCCB4} /* Korean hangul */,
  {0, 0, 0xCCB5} /* Korean hangul */,
  {0, 0, 0xCCB8} /* Korean hangul */,
  {0, 0, 0xCCBC} /* Korean hangul */,
  {0, 0, 0xCCC7} /* Korean hangul */,
  {0, 0, 0xCCD0} /* Korean hangul */,
  {0, 0, 0xCCE4} /* Korean hangul */,
  {0, 0, 0xCD08} /* Korean hangul */,
  {0, 0, 0xCD09} /* Korean hangul */,
  {0, 0, 0xCD0C} /* Korean hangul */,
  {0, 0, 0xCD10} /* Korean hangul */,
  {0, 0, 0xCD18} /* Korean hangul */,
  {0, 0, 0xCD19} /* Korean hangul */,
  {0, 0, 0xCD1B} /* Korean hangul */,
  {0, 0, 0xCD1D} /* Korean hangul */,
  {0, 0, 0xCD2C} /* Korean hangul */,
  {0, 0, 0xCD5C} /* Korean hangul */,
  {0, 0, 0xCD78} /* Korean hangul */,
  {0, 0, 0xCD94} /* Korean hangul */,
  {0, 0, 0xCD95} /* Korean hangul */,
  {0, 0, 0xCD98} /* Korean hangul */,
  {0, 0, 0xCD9C} /* Korean hangul */,
  {0, 0, 0xCDA4} /* Korean hangul */,
  {0, 0, 0xCDA5} /* Korean hangul */,
  {0, 0, 0xCDA7} /* Korean hangul */,
  {0, 0, 0xCDA9} /* Korean hangul */,
  {0, 0, 0xCDB0} /* Korean hangul */,
  {0, 0, 0xCDC4} /* Korean hangul */,
  {0, 0, 0xCDCC} /* Korean hangul */,
  {0, 0, 0xCDE8} /* Korean hangul */,
  {0, 0, 0xCE04} /* Korean hangul */,
  {0, 0, 0xCE20} /* Korean hangul */,
  {0, 0, 0xCE21} /* Korean hangul */,
  {0, 0, 0xCE30} /* Korean hangul */,
  {0, 0, 0xCE35} /* Korean hangul */,
  {0, 0, 0xCE58} /* Korean hangul */,
  {0, 0, 0xCE59} /* Korean hangul */,
  {0, 0, 0xCE5C} /* Korean hangul */,
  {0, 0, 0xCE60} /* Korean hangul */,
  {0, 0, 0xCE61} /* Korean hangul */,
  {0, 0, 0xCE68} /* Korean hangul */,
  {0, 0, 0xCE69} /* Korean hangul */,
  {0, 0, 0xCE6B} /* Korean hangul */,
  {0, 0, 0xCE6D} /* Korean hangul */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0xCE74} /* Korean hangul */,
  {0, 0, 0xCE75} /* Korean hangul */,
  {0, 0, 0xCE78} /* Korean hangul */,
  {0, 0, 0xCE7C} /* Korean hangul */,
  {0, 0, 0xCE84} /* Korean hangul */,
  {0, 0, 0xCE85} /* Korean hangul */,
  {0, 0, 0xCE87} /* Korean hangul */,
  {0, 0, 0xCE89} /* Korean hangul */,
  {0, 0, 0xCE90} /* Korean hangul */,
  {0, 0, 0xCE91} /* Korean hangul */,
  {0, 0, 0xCE94} /* Korean hangul */,
  {0, 0, 0xCE98} /* Korean hangul */,
  {0, 0, 0xCEA0} /* Korean hangul */,
  {0, 0, 0xCEA1} /* Korean hangul */,
  {0, 0, 0xCEA3} /* Korean hangul */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8_31page817 = {
  0, marc8_31page817_dir
};
/* PAGE 816 */
struct yaz_iconv_trie_dir marc8_31page816_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0xC974} /* Korean hangul */,
  {0, 0, 0xC988} /* Korean hangul */,
  {0, 0, 0xC989} /* Korean hangul */,
  {0, 0, 0xC98C} /* Korean hangul */,
  {0, 0, 0xC990} /* Korean hangul */,
  {0, 0, 0xC998} /* Korean hangul */,
  {0, 0, 0xC999} /* Korean hangul */,
  {0, 0, 0xC99D} /* Korean hangul */,
  {0, 0, 0xC9C0} /* Korean hangul */,
  {0, 0, 0xC9C1} /* Korean hangul */,
  {0, 0, 0xC9C4} /* Korean hangul */,
  {0, 0, 0xC9C7} /* Korean hangul */,
  {0, 0, 0xC9C8} /* Korean hangul */,
  {0, 0, 0xC9CA} /* Korean hangul */,
  {0, 0, 0xC9D0} /* Korean hangul */,
  {0, 0, 0xC9D1} /* Korean hangul */,
  {0, 0, 0xC9D3} /* Korean hangul */,
  {0, 0, 0xC9D5} /* Korean hangul */,
  {0, 0, 0xC9D6} /* Korean hangul */,
  {0, 0, 0xC9D9} /* Korean hangul */,
  {0, 0, 0xC9DA} /* Korean hangul */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0xC9DC} /* Korean hangul */,
  {0, 0, 0xC9DD} /* Korean hangul */,
  {0, 0, 0xC9E0} /* Korean hangul */,
  {0, 0, 0xC9E2} /* Korean hangul */,
  {0, 0, 0xC9E4} /* Korean hangul */,
  {0, 0, 0},
  {0, 0, 0xC9E7} /* Korean hangul */,
  {0, 0, 0xC9EC} /* Korean hangul */,
  {0, 0, 0xC9ED} /* Korean hangul */,
  {0, 0, 0xC9EF} /* Korean hangul */,
  {0, 0, 0xC9F0} /* Korean hangul */,
  {0, 0, 0xC9F1} /* Korean hangul */,
  {0, 0, 0xC9F8} /* Korean hangul */,
  {0, 0, 0xC9F9} /* Korean hangul */,
  {0, 0, 0xC9FC} /* Korean hangul */,
  {0, 0, 0xCA00} /* Korean hangul */,
  {0, 0, 0xCA08} /* Korean hangul */,
  {0, 0, 0xCA09} /* Korean hangul */,
  {0, 0, 0xCA0B} /* Korean hangul */,
  {0, 0, 0xCA0C} /* Korean hangul */,
  {0, 0, 0xCA0D} /* Korean hangul */,
  {0, 0, 0xCA18} /* Korean hangul */,
  {0, 0, 0xCA4C} /* Korean hangul */,
  {0, 0, 0xCA4D} /* Korean hangul */,
  {0, 0, 0xCA50} /* Korean hangul */,
  {0, 0, 0xCA54} /* Korean hangul */,
  {0, 0, 0xCA5C} /* Korean hangul */,
  {0, 0, 0xCA5D} /* Korean hangul */,
  {0, 0, 0xCA61} /* Korean hangul */,
  {0, 0, 0xCA84} /* Korean hangul */,
  {0, 0, 0xCA98} /* Korean hangul */,
  {0, 0, 0xCABC} /* Korean hangul */,
  {0, 0, 0xCABD} /* Korean hangul */,
  {0, 0, 0xCAC0} /* Korean hangul */,
  {0, 0, 0xCAC4} /* Korean hangul */,
  {0, 0, 0xCACC} /* Korean hangul */,
  {0, 0, 0xCACD} /* Korean hangul */,
  {0, 0, 0xCAD1} /* Korean hangul */,
  {0, 0, 0xCAD2} /* Korean hangul */,
  {0, 0, 0xCAD3} /* Korean hangul */,
  {0, 0, 0xCAD8} /* Korean hangul */,
  {0, 0, 0xCAD9} /* Korean hangul */,
  {0, 0, 0xCB10} /* Korean hangul */,
  {0, 0, 0xCB14} /* Korean hangul */,
  {0, 0, 0xCB18} /* Korean hangul */,
  {0, 0, 0xCB20} /* Korean hangul */,
  {0, 0, 0xCB21} /* Korean hangul */,
  {0, 0, 0xCB41} /* Korean hangul */,
  {0, 0, 0xCB48} /* Korean hangul */,
  {0, 0, 0xCB49} /* Korean hangul */,
  {0, 0, 0xCB50} /* Korean hangul */,
  {0, 0, 0xCB58} /* Korean hangul */,
  {0, 0, 0xCB59} /* Korean hangul */,
  {0, 0, 0xCB5D} /* Korean hangul */,
  {0, 0, 0xCB64} /* Korean hangul */,
  {0, 0, 0xCBB8} /* Korean hangul */,
  {0, 0, 0xCBD4} /* Korean hangul */,
  {0, 0, 0xCBE4} /* Korean hangul */,
  {0, 0, 0xCBE7} /* Korean hangul */,
  {0, 0, 0xCC0C} /* Korean hangul */,
  {0, 0, 0xCC0D} /* Korean hangul */,
  {0, 0, 0xCC10} /* Korean hangul */,
  {0, 0, 0xCC14} /* Korean hangul */,
  {0, 0, 0xCC1C} /* Korean hangul */,
  {0, 0, 0xCC1D} /* Korean hangul */,
  {0, 0, 0xCC21} /* Korean hangul */,
  {0, 0, 0xCC22} /* Korean hangul */,
  {0, 0, 0xCC27} /* Korean hangul */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0xCC28} /* Korean hangul */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8_31page816 = {
  0, marc8_31page816_dir
};
/* PAGE 815 */
struct yaz_iconv_trie_dir marc8_31page815_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0xC7A1} /* Korean hangul */,
  {0, 0, 0xC7A3} /* Korean hangul */,
  {0, 0, 0xC7A4} /* Korean hangul */,
  {0, 0, 0xC7A5} /* Korean hangul */,
  {0, 0, 0xC7A6} /* Korean hangul */,
  {0, 0, 0xC7A7} /* Korean hangul */,
  {0, 0, 0xC7AC} /* Korean hangul */,
  {0, 0, 0xC7AD} /* Korean hangul */,
  {0, 0, 0xC7B0} /* Korean hangul */,
  {0, 0, 0xC7B4} /* Korean hangul */,
  {0, 0, 0xC7BC} /* Korean hangul */,
  {0, 0, 0xC7BD} /* Korean hangul */,
  {0, 0, 0xC7BF} /* Korean hangul */,
  {0, 0, 0xC7C0} /* Korean hangul */,
  {0, 0, 0xC7C1} /* Korean hangul */,
  {0, 0, 0xC7C8} /* Korean hangul */,
  {0, 0, 0xC7C9} /* Korean hangul */,
  {0, 0, 0xC7CC} /* Korean hangul */,
  {0, 0, 0xC7D8} /* Korean hangul */,
  {0, 0, 0xC800} /* Korean hangul */,
  {0, 0, 0xC801} /* Korean hangul */,
  {0, 0, 0xC804} /* Korean hangul */,
  {0, 0, 0xC808} /* Korean hangul */,
  {0, 0, 0xC80A} /* Korean hangul */,
  {0, 0, 0xC810} /* Korean hangul */,
  {0, 0, 0xC811} /* Korean hangul */,
  {0, 0, 0xC813} /* Korean hangul */,
  {0, 0, 0xC814} /* Korean hangul */,
  {0, 0, 0xC815} /* Korean hangul */,
  {0, 0, 0xC816} /* Korean hangul */,
  {0, 0, 0xC81C} /* Korean hangul */,
  {0, 0, 0xC81D} /* Korean hangul */,
  {0, 0, 0xC820} /* Korean hangul */,
  {0, 0, 0xC824} /* Korean hangul */,
  {0, 0, 0xC82C} /* Korean hangul */,
  {0, 0, 0xC82D} /* Korean hangul */,
  {0, 0, 0xC82F} /* Korean hangul */,
  {0, 0, 0xC838} /* Korean hangul */,
  {0, 0, 0xC83C} /* Korean hangul */,
  {0, 0, 0xC84C} /* Korean hangul */,
  {0, 0, 0xC870} /* Korean hangul */,
  {0, 0, 0xC871} /* Korean hangul */,
  {0, 0, 0xC874} /* Korean hangul */,
  {0, 0, 0xC878} /* Korean hangul */,
  {0, 0, 0xC87A} /* Korean hangul */,
  {0, 0, 0xC880} /* Korean hangul */,
  {0, 0, 0xC881} /* Korean hangul */,
  {0, 0, 0xC885} /* Korean hangul */,
  {0, 0, 0xC886} /* Korean hangul */,
  {0, 0, 0xC887} /* Korean hangul */,
  {0, 0, 0xC88B} /* Korean hangul */,
  {0, 0, 0xC88C} /* Korean hangul */,
  {0, 0, 0xC88D} /* Korean hangul */,
  {0, 0, 0xC890} /* Korean hangul */,
  {0, 0, 0xC894} /* Korean hangul */,
  {0, 0, 0xC89C} /* Korean hangul */,
  {0, 0, 0xC89D} /* Korean hangul */,
  {0, 0, 0xC89F} /* Korean hangul */,
  {0, 0, 0xC8A0} /* Korean hangul */,
  {0, 0, 0},
  {0, 0, 0xC8A8} /* Korean hangul */,
  {0, 0, 0xC8AC} /* Korean hangul */,
  {0, 0, 0xC8B0} /* Korean hangul */,
  {0, 0, 0xC8B8} /* Korean hangul */,
  {0, 0, 0xC8C4} /* Korean hangul */,
  {0, 0, 0xC8C8} /* Korean hangul */,
  {0, 0, 0xC8CC} /* Korean hangul */,
  {0, 0, 0xC8D4} /* Korean hangul */,
  {0, 0, 0xC8D5} /* Korean hangul */,
  {0, 0, 0xC8D7} /* Korean hangul */,
  {0, 0, 0xC8E0} /* Korean hangul */,
  {0, 0, 0xC8E4} /* Korean hangul */,
  {0, 0, 0xC8F0} /* Korean hangul */,
  {0, 0, 0xC8F1} /* Korean hangul */,
  {0, 0, 0xC8F5} /* Korean hangul */,
  {0, 0, 0xC8FC} /* Korean hangul */,
  {0, 0, 0xC8FD} /* Korean hangul */,
  {0, 0, 0xC900} /* Korean hangul */,
  {0, 0, 0xC904} /* Korean hangul */,
  {0, 0, 0xC906} /* Korean hangul */,
  {0, 0, 0xC90C} /* Korean hangul */,
  {0, 0, 0xC90D} /* Korean hangul */,
  {0, 0, 0xC90F} /* Korean hangul */,
  {0, 0, 0xC911} /* Korean hangul */,
  {0, 0, 0xC918} /* Korean hangul */,
  {0, 0, 0xC92C} /* Korean hangul */,
  {0, 0, 0xC950} /* Korean hangul */,
  {0, 0, 0},
  {0, 0, 0xC954} /* Korean hangul */,
  {0, 0, 0xC958} /* Korean hangul */,
  {0, 0, 0xC960} /* Korean hangul */,
  {0, 0, 0xC961} /* Korean hangul */,
  {0, 0, 0xC96C} /* Korean hangul */,
  {0, 0, 0xC970} /* Korean hangul */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8_31page815 = {
  0, marc8_31page815_dir
};
/* PAGE 814 */
struct yaz_iconv_trie_dir marc8_31page814_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0xC641} /* Korean hangul */,
  {0, 0, 0xC644} /* Korean hangul */,
  {0, 0, 0xC648} /* Korean hangul */,
  {0, 0, 0xC650} /* Korean hangul */,
  {0, 0, 0xC651} /* Korean hangul */,
  {0, 0, 0xC653} /* Korean hangul */,
  {0, 0, 0xC654} /* Korean hangul */,
  {0, 0, 0},
  {0, 0, 0xC65C} /* Korean hangul */,
  {0, 0, 0xC65D} /* Korean hangul */,
  {0, 0, 0xC660} /* Korean hangul */,
  {0, 0, 0xC671} /* Korean hangul */,
  {0, 0, 0xC678} /* Korean hangul */,
  {0, 0, 0xC679} /* Korean hangul */,
  {0, 0, 0xC67C} /* Korean hangul */,
  {0, 0, 0xC680} /* Korean hangul */,
  {0, 0, 0xC688} /* Korean hangul */,
  {0, 0, 0xC68B} /* Korean hangul */,
  {0, 0, 0xC68D} /* Korean hangul */,
  {0, 0, 0xC694} /* Korean hangul */,
  {0, 0, 0xC695} /* Korean hangul */,
  {0, 0, 0xC698} /* Korean hangul */,
  {0, 0, 0xC6A5} /* Korean hangul */,
  {0, 0, 0xC6A7} /* Korean hangul */,
  {0, 0, 0xC6A9} /* Korean hangul */,
  {0, 0, 0xC6B0} /* Korean hangul */,
  {0, 0, 0xC6B1} /* Korean hangul */,
  {0, 0, 0xC6B4} /* Korean hangul */,
  {0, 0, 0xC6B7} /* Korean hangul */,
  {0, 0, 0xC6B8} /* Korean hangul */,
  {0, 0, 0xC6B9} /* Korean hangul */,
  {0, 0, 0xC6BA} /* Korean hangul */,
  {0, 0, 0xC6C0} /* Korean hangul */,
  {0, 0, 0xC6C1} /* Korean hangul */,
  {0, 0, 0xC6C3} /* Korean hangul */,
  {0, 0, 0xC6C5} /* Korean hangul */,
  {0, 0, 0xC6CC} /* Korean hangul */,
  {0, 0, 0xC6CD} /* Korean hangul */,
  {0, 0, 0xC6D0} /* Korean hangul */,
  {0, 0, 0xC6D4} /* Korean hangul */,
  {0, 0, 0xC6DC} /* Korean hangul */,
  {0, 0, 0xC6DD} /* Korean hangul */,
  {0, 0, 0xC6DF} /* Korean hangul */,
  {0, 0, 0xC6E0} /* Korean hangul */,
  {0, 0, 0xC6E1} /* Korean hangul */,
  {0, 0, 0xC6E8} /* Korean hangul */,
  {0, 0, 0xC6E9} /* Korean hangul */,
  {0, 0, 0xC6EC} /* Korean hangul */,
  {0, 0, 0xC6F0} /* Korean hangul */,
  {0, 0, 0xC6F8} /* Korean hangul */,
  {0, 0, 0xC704} /* Korean hangul */,
  {0, 0, 0xC705} /* Korean hangul */,
  {0, 0, 0xC708} /* Korean hangul */,
  {0, 0, 0xC70C} /* Korean hangul */,
  {0, 0, 0xC714} /* Korean hangul */,
  {0, 0, 0xC717} /* Korean hangul */,
  {0, 0, 0xC719} /* Korean hangul */,
  {0, 0, 0xC720} /* Korean hangul */,
  {0, 0, 0xC721} /* Korean hangul */,
  {0, 0, 0xC724} /* Korean hangul */,
  {0, 0, 0xC728} /* Korean hangul */,
  {0, 0, 0xC730} /* Korean hangul */,
  {0, 0, 0xC735} /* Korean hangul */,
  {0, 0, 0xC737} /* Korean hangul */,
  {0, 0, 0xC73C} /* Korean hangul */,
  {0, 0, 0xC73D} /* Korean hangul */,
  {0, 0, 0xC740} /* Korean hangul */,
  {0, 0, 0xC744} /* Korean hangul */,
  {0, 0, 0xC74A} /* Korean hangul */,
  {0, 0, 0xC74C} /* Korean hangul */,
  {0, 0, 0xC74D} /* Korean hangul */,
  {0, 0, 0xC751} /* Korean hangul */,
  {0, 0, 0xC758} /* Korean hangul */,
  {0, 0, 0xC774} /* Korean hangul */,
  {0, 0, 0xC775} /* Korean hangul */,
  {0, 0, 0xC778} /* Korean hangul */,
  {0, 0, 0xC77C} /* Korean hangul */,
  {0, 0, 0xC77D} /* Korean hangul */,
  {0, 0, 0xC783} /* Korean hangul */,
  {0, 0, 0xC784} /* Korean hangul */,
  {0, 0, 0xC785} /* Korean hangul */,
  {0, 0, 0xC787} /* Korean hangul */,
  {0, 0, 0xC788} /* Korean hangul */,
  {0, 0, 0xC789} /* Korean hangul */,
  {0, 0, 0xC78A} /* Korean hangul */,
  {0, 0, 0xC78E} /* Korean hangul */,
  {0, 0, 0xC655} /* Korean hangul */,
  {0, 0, 0},
  {0, 0, 0xC790} /* Korean hangul */,
  {0, 0, 0xC791} /* Korean hangul */,
  {0, 0, 0xC794} /* Korean hangul */,
  {0, 0, 0xC796} /* Korean hangul */,
  {0, 0, 0xC798} /* Korean hangul */,
  {0, 0, 0xC7A0} /* Korean hangul */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8_31page814 = {
  0, marc8_31page814_dir
};
/* PAGE 813 */
struct yaz_iconv_trie_dir marc8_31page813_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0xC549} /* Korean hangul */,
  {0, 0, 0xC54A} /* Korean hangul */,
  {0, 0, 0xC54C} /* Korean hangul */,
  {0, 0, 0xC54E} /* Korean hangul */,
  {0, 0, 0xC553} /* Korean hangul */,
  {0, 0, 0xC554} /* Korean hangul */,
  {0, 0, 0xC555} /* Korean hangul */,
  {0, 0, 0xC557} /* Korean hangul */,
  {0, 0, 0xC558} /* Korean hangul */,
  {0, 0, 0xC559} /* Korean hangul */,
  {0, 0, 0xC55E} /* Korean hangul */,
  {0, 0, 0xC55F} /* Korean hangul */,
  {0, 0, 0xC560} /* Korean hangul */,
  {0, 0, 0xC561} /* Korean hangul */,
  {0, 0, 0xC564} /* Korean hangul */,
  {0, 0, 0xC568} /* Korean hangul */,
  {0, 0, 0xC570} /* Korean hangul */,
  {0, 0, 0xC571} /* Korean hangul */,
  {0, 0, 0xC573} /* Korean hangul */,
  {0, 0, 0xC574} /* Korean hangul */,
  {0, 0, 0xC575} /* Korean hangul */,
  {0, 0, 0xC57C} /* Korean hangul */,
  {0, 0, 0xC57D} /* Korean hangul */,
  {0, 0, 0xC580} /* Korean hangul */,
  {0, 0, 0xC584} /* Korean hangul */,
  {0, 0, 0xC587} /* Korean hangul */,
  {0, 0, 0xC58C} /* Korean hangul */,
  {0, 0, 0xC58D} /* Korean hangul */,
  {0, 0, 0xC58F} /* Korean hangul */,
  {0, 0, 0xC590} /* Korean hangul */,
  {0, 0, 0xC591} /* Korean hangul */,
  {0, 0, 0xC595} /* Korean hangul */,
  {0, 0, 0xC597} /* Korean hangul */,
  {0, 0, 0xC598} /* Korean hangul */,
  {0, 0, 0xC59C} /* Korean hangul */,
  {0, 0, 0xC5B4} /* Korean hangul */,
  {0, 0, 0xC5B5} /* Korean hangul */,
  {0, 0, 0xC5B6} /* Korean hangul */,
  {0, 0, 0xC5B8} /* Korean hangul */,
  {0, 0, 0xC5B9} /* Korean hangul */,
  {0, 0, 0xC5BA} /* Korean hangul */,
  {0, 0, 0xC5BB} /* Korean hangul */,
  {0, 0, 0xC5BC} /* Korean hangul */,
  {0, 0, 0xC5BD} /* Korean hangul */,
  {0, 0, 0xC5C4} /* Korean hangul */,
  {0, 0, 0xC5C5} /* Korean hangul */,
  {0, 0, 0xC5C6} /* Korean hangul */,
  {0, 0, 0xC5C7} /* Korean hangul */,
  {0, 0, 0xC5C8} /* Korean hangul */,
  {0, 0, 0xC5C9} /* Korean hangul */,
  {0, 0, 0xC5CA} /* Korean hangul */,
  {0, 0, 0xC5CC} /* Korean hangul */,
  {0, 0, 0xC5CE} /* Korean hangul */,
  {0, 0, 0xC5D0} /* Korean hangul */,
  {0, 0, 0xC5D1} /* Korean hangul */,
  {0, 0, 0xC5D4} /* Korean hangul */,
  {0, 0, 0xC5D8} /* Korean hangul */,
  {0, 0, 0xC5E0} /* Korean hangul */,
  {0, 0, 0xC5E1} /* Korean hangul */,
  {0, 0, 0xC5E3} /* Korean hangul */,
  {0, 0, 0xC5E5} /* Korean hangul */,
  {0, 0, 0xC5EC} /* Korean hangul */,
  {0, 0, 0xC5ED} /* Korean hangul */,
  {0, 0, 0xC5EE} /* Korean hangul */,
  {0, 0, 0xC5F0} /* Korean hangul */,
  {0, 0, 0xC5F4} /* Korean hangul */,
  {0, 0, 0xC5F6} /* Korean hangul */,
  {0, 0, 0xC5F7} /* Korean hangul */,
  {0, 0, 0xC5FC} /* Korean hangul */,
  {0, 0, 0xC5FD} /* Korean hangul */,
  {0, 0, 0xC5FE} /* Korean hangul */,
  {0, 0, 0xC5FF} /* Korean hangul */,
  {0, 0, 0xC600} /* Korean hangul */,
  {0, 0, 0xC601} /* Korean hangul */,
  {0, 0, 0xC606} /* Korean hangul */,
  {0, 0, 0xC607} /* Korean hangul */,
  {0, 0, 0xC608} /* Korean hangul */,
  {0, 0, 0xC60C} /* Korean hangul */,
  {0, 0, 0xC610} /* Korean hangul */,
  {0, 0, 0xC61B} /* Korean hangul */,
  {0, 0, 0xC624} /* Korean hangul */,
  {0, 0, 0xC625} /* Korean hangul */,
  {0, 0, 0xC628} /* Korean hangul */,
  {0, 0, 0xC62C} /* Korean hangul */,
  {0, 0, 0xC62D} /* Korean hangul */,
  {0, 0, 0xC62E} /* Korean hangul */,
  {0, 0, 0xC633} /* Korean hangul */,
  {0, 0, 0xC634} /* Korean hangul */,
  {0, 0, 0xC635} /* Korean hangul */,
  {0, 0, 0xC637} /* Korean hangul */,
  {0, 0, 0xC639} /* Korean hangul */,
  {0, 0, 0xC63A} /* Korean hangul */,
  {0, 0, 0xC63B} /* Korean hangul */,
  {0, 0, 0xC640} /* Korean hangul */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8_31page813 = {
  0, marc8_31page813_dir
};
/* PAGE 812 */
struct yaz_iconv_trie_dir marc8_31page812_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0xC2B7} /* Korean hangul */,
  {0, 0, 0xC2B9} /* Korean hangul */,
  {0, 0, 0xC2DC} /* Korean hangul */,
  {0, 0, 0xC2DD} /* Korean hangul */,
  {0, 0, 0xC2E0} /* Korean hangul */,
  {0, 0, 0xC2E3} /* Korean hangul */,
  {0, 0, 0xC2E4} /* Korean hangul */,
  {0, 0, 0xC2EB} /* Korean hangul */,
  {0, 0, 0xC2EC} /* Korean hangul */,
  {0, 0, 0xC2ED} /* Korean hangul */,
  {0, 0, 0xC2EF} /* Korean hangul */,
  {0, 0, 0xC2F1} /* Korean hangul */,
  {0, 0, 0xC2F6} /* Korean hangul */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0xC2F8} /* Korean hangul */,
  {0, 0, 0xC2F9} /* Korean hangul */,
  {0, 0, 0xC2FC} /* Korean hangul */,
  {0, 0, 0xC300} /* Korean hangul */,
  {0, 0, 0xC308} /* Korean hangul */,
  {0, 0, 0xC309} /* Korean hangul */,
  {0, 0, 0xC30B} /* Korean hangul */,
  {0, 0, 0xC30C} /* Korean hangul */,
  {0, 0, 0xC30D} /* Korean hangul */,
  {0, 0, 0xC313} /* Korean hangul */,
  {0, 0, 0xC314} /* Korean hangul */,
  {0, 0, 0xC315} /* Korean hangul */,
  {0, 0, 0xC318} /* Korean hangul */,
  {0, 0, 0xC31C} /* Korean hangul */,
  {0, 0, 0xC324} /* Korean hangul */,
  {0, 0, 0xC327} /* Korean hangul */,
  {0, 0, 0xC328} /* Korean hangul */,
  {0, 0, 0xC329} /* Korean hangul */,
  {0, 0, 0xC330} /* Korean hangul */,
  {0, 0, 0xC343} /* Korean hangul */,
  {0, 0, 0xC345} /* Korean hangul */,
  {0, 0, 0xC368} /* Korean hangul */,
  {0, 0, 0xC369} /* Korean hangul */,
  {0, 0, 0xC36C} /* Korean hangul */,
  {0, 0, 0xC370} /* Korean hangul */,
  {0, 0, 0xC372} /* Korean hangul */,
  {0, 0, 0xC378} /* Korean hangul */,
  {0, 0, 0xC379} /* Korean hangul */,
  {0, 0, 0xC37C} /* Korean hangul */,
  {0, 0, 0xC37D} /* Korean hangul */,
  {0, 0, 0xC384} /* Korean hangul */,
  {0, 0, 0xC388} /* Korean hangul */,
  {0, 0, 0xC399} /* Korean hangul */,
  {0, 0, 0xC3D8} /* Korean hangul */,
  {0, 0, 0xC3D9} /* Korean hangul */,
  {0, 0, 0xC3DC} /* Korean hangul */,
  {0, 0, 0xC3DF} /* Korean hangul */,
  {0, 0, 0xC3E0} /* Korean hangul */,
  {0, 0, 0xC3E8} /* Korean hangul */,
  {0, 0, 0xC3ED} /* Korean hangul */,
  {0, 0, 0xC3F4} /* Korean hangul */,
  {0, 0, 0xC3F5} /* Korean hangul */,
  {0, 0, 0xC410} /* Korean hangul */,
  {0, 0, 0xC42C} /* Korean hangul */,
  {0, 0, 0xC430} /* Korean hangul */,
  {0, 0, 0xC434} /* Korean hangul */,
  {0, 0, 0xC43C} /* Korean hangul */,
  {0, 0, 0xC43F} /* Korean hangul */,
  {0, 0, 0xC464} /* Korean hangul */,
  {0, 0, 0xC465} /* Korean hangul */,
  {0, 0, 0xC468} /* Korean hangul */,
  {0, 0, 0xC46C} /* Korean hangul */,
  {0, 0, 0xC474} /* Korean hangul */,
  {0, 0, 0xC479} /* Korean hangul */,
  {0, 0, 0xC480} /* Korean hangul */,
  {0, 0, 0xC494} /* Korean hangul */,
  {0, 0, 0xC4D4} /* Korean hangul */,
  {0, 0, 0xC4D5} /* Korean hangul */,
  {0, 0, 0xC4F0} /* Korean hangul */,
  {0, 0, 0xC4F1} /* Korean hangul */,
  {0, 0, 0xC4F4} /* Korean hangul */,
  {0, 0, 0xC4F8} /* Korean hangul */,
  {0, 0, 0xC500} /* Korean hangul */,
  {0, 0, 0xC501} /* Korean hangul */,
  {0, 0, 0xC50C} /* Korean hangul */,
  {0, 0, 0xC510} /* Korean hangul */,
  {0, 0, 0xC528} /* Korean hangul */,
  {0, 0, 0xC529} /* Korean hangul */,
  {0, 0, 0xC52C} /* Korean hangul */,
  {0, 0, 0xC530} /* Korean hangul */,
  {0, 0, 0xC538} /* Korean hangul */,
  {0, 0, 0xC539} /* Korean hangul */,
  {0, 0, 0xC53B} /* Korean hangul */,
  {0, 0, 0xC53D} /* Korean hangul */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0xC544} /* Korean hangul */,
  {0, 0, 0xC545} /* Korean hangul */,
  {0, 0, 0xC548} /* Korean hangul */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8_31page812 = {
  0, marc8_31page812_dir
};
/* PAGE 811 */
struct yaz_iconv_trie_dir marc8_31page811_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0xC11C} /* Korean hangul */,
  {0, 0, 0xC11D} /* Korean hangul */,
  {0, 0, 0xC11E} /* Korean hangul */,
  {0, 0, 0xC120} /* Korean hangul */,
  {0, 0, 0xC123} /* Korean hangul */,
  {0, 0, 0xC124} /* Korean hangul */,
  {0, 0, 0xC125} /* Korean hangul */,
  {0, 0, 0xC126} /* Korean hangul */,
  {0, 0, 0xC127} /* Korean hangul */,
  {0, 0, 0xC12A} /* Korean hangul */,
  {0, 0, 0xC12C} /* Korean hangul */,
  {0, 0, 0xC12D} /* Korean hangul */,
  {0, 0, 0xC12F} /* Korean hangul */,
  {0, 0, 0xC130} /* Korean hangul */,
  {0, 0, 0xC131} /* Korean hangul */,
  {0, 0, 0xC136} /* Korean hangul */,
  {0, 0, 0xC138} /* Korean hangul */,
  {0, 0, 0xC139} /* Korean hangul */,
  {0, 0, 0xC13C} /* Korean hangul */,
  {0, 0, 0xC140} /* Korean hangul */,
  {0, 0, 0xC148} /* Korean hangul */,
  {0, 0, 0xC149} /* Korean hangul */,
  {0, 0, 0xC14B} /* Korean hangul */,
  {0, 0, 0xC14D} /* Korean hangul */,
  {0, 0, 0xC151} /* Korean hangul */,
  {0, 0, 0xC154} /* Korean hangul */,
  {0, 0, 0xC158} /* Korean hangul */,
  {0, 0, 0xC167} /* Korean hangul */,
  {0, 0, 0xC168} /* Korean hangul */,
  {0, 0, 0xC170} /* Korean hangul */,
  {0, 0, 0xC18C} /* Korean hangul */,
  {0, 0, 0xC18D} /* Korean hangul */,
  {0, 0, 0xC18E} /* Korean hangul */,
  {0, 0, 0xC190} /* Korean hangul */,
  {0, 0, 0xC194} /* Korean hangul */,
  {0, 0, 0xC19C} /* Korean hangul */,
  {0, 0, 0xC19D} /* Korean hangul */,
  {0, 0, 0xC19F} /* Korean hangul */,
  {0, 0, 0xC1A1} /* Korean hangul */,
  {0, 0, 0xC1A5} /* Korean hangul */,
  {0, 0, 0xC1A8} /* Korean hangul */,
  {0, 0, 0xC1A9} /* Korean hangul */,
  {0, 0, 0xC1B0} /* Korean hangul */,
  {0, 0, 0xC1C4} /* Korean hangul */,
  {0, 0, 0xC1C8} /* Korean hangul */,
  {0, 0, 0xC1D7} /* Korean hangul */,
  {0, 0, 0xC1E0} /* Korean hangul */,
  {0, 0, 0xC1E4} /* Korean hangul */,
  {0, 0, 0xC1E8} /* Korean hangul */,
  {0, 0, 0xC1F0} /* Korean hangul */,
  {0, 0, 0xC1F1} /* Korean hangul */,
  {0, 0, 0xC1F3} /* Korean hangul */,
  {0, 0, 0xC1FC} /* Korean hangul */,
  {0, 0, 0xC1FD} /* Korean hangul */,
  {0, 0, 0xC200} /* Korean hangul */,
  {0, 0, 0xC204} /* Korean hangul */,
  {0, 0, 0xC20D} /* Korean hangul */,
  {0, 0, 0},
  {0, 0, 0xC218} /* Korean hangul */,
  {0, 0, 0xC219} /* Korean hangul */,
  {0, 0, 0xC21C} /* Korean hangul */,
  {0, 0, 0xC21F} /* Korean hangul */,
  {0, 0, 0xC220} /* Korean hangul */,
  {0, 0, 0xC228} /* Korean hangul */,
  {0, 0, 0xC229} /* Korean hangul */,
  {0, 0, 0xC22B} /* Korean hangul */,
  {0, 0, 0xC22D} /* Korean hangul */,
  {0, 0, 0xC22F} /* Korean hangul */,
  {0, 0, 0xC231} /* Korean hangul */,
  {0, 0, 0xC232} /* Korean hangul */,
  {0, 0, 0xC234} /* Korean hangul */,
  {0, 0, 0xC250} /* Korean hangul */,
  {0, 0, 0xC258} /* Korean hangul */,
  {0, 0, 0xC26C} /* Korean hangul */,
  {0, 0, 0xC270} /* Korean hangul */,
  {0, 0, 0xC274} /* Korean hangul */,
  {0, 0, 0xC27C} /* Korean hangul */,
  {0, 0, 0xC27D} /* Korean hangul */,
  {0, 0, 0xC27F} /* Korean hangul */,
  {0, 0, 0xC281} /* Korean hangul */,
  {0, 0, 0xC288} /* Korean hangul */,
  {0, 0, 0xC289} /* Korean hangul */,
  {0, 0, 0xC290} /* Korean hangul */,
  {0, 0, 0xC298} /* Korean hangul */,
  {0, 0, 0xC29B} /* Korean hangul */,
  {0, 0, 0xC29D} /* Korean hangul */,
  {0, 0, 0xC2A4} /* Korean hangul */,
  {0, 0, 0xC2A5} /* Korean hangul */,
  {0, 0, 0xC2A8} /* Korean hangul */,
  {0, 0, 0xC2AC} /* Korean hangul */,
  {0, 0, 0xC2AD} /* Korean hangul */,
  {0, 0, 0},
  {0, 0, 0xC2B4} /* Korean hangul */,
  {0, 0, 0xC2B5} /* Korean hangul */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8_31page811 = {
  0, marc8_31page811_dir
};
/* PAGE 810 */
struct yaz_iconv_trie_dir marc8_31page810_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0xBE70} /* Korean hangul */,
  {0, 0, 0xBE71} /* Korean hangul */,
  {0, 0, 0xBE73} /* Korean hangul */,
  {0, 0, 0xBE74} /* Korean hangul */,
  {0, 0, 0xBE75} /* Korean hangul */,
  {0, 0, 0xBE7B} /* Korean hangul */,
  {0, 0, 0xBE7C} /* Korean hangul */,
  {0, 0, 0xBE7D} /* Korean hangul */,
  {0, 0, 0xBE80} /* Korean hangul */,
  {0, 0, 0xBE84} /* Korean hangul */,
  {0, 0, 0xBE8C} /* Korean hangul */,
  {0, 0, 0xBE8F} /* Korean hangul */,
  {0, 0, 0xBE90} /* Korean hangul */,
  {0, 0, 0xBE91} /* Korean hangul */,
  {0, 0, 0xBE98} /* Korean hangul */,
  {0, 0, 0xBEA8} /* Korean hangul */,
  {0, 0, 0xBED0} /* Korean hangul */,
  {0, 0, 0xBED1} /* Korean hangul */,
  {0, 0, 0xBED4} /* Korean hangul */,
  {0, 0, 0xBED7} /* Korean hangul */,
  {0, 0, 0xBED8} /* Korean hangul */,
  {0, 0, 0xBEE0} /* Korean hangul */,
  {0, 0, 0xBEE3} /* Korean hangul */,
  {0, 0, 0xBEE4} /* Korean hangul */,
  {0, 0, 0xBEE5} /* Korean hangul */,
  {0, 0, 0xBEEC} /* Korean hangul */,
  {0, 0, 0xBF08} /* Korean hangul */,
  {0, 0, 0xBF09} /* Korean hangul */,
  {0, 0, 0xBF18} /* Korean hangul */,
  {0, 0, 0xBF1D} /* Korean hangul */,
  {0, 0, 0xBF40} /* Korean hangul */,
  {0, 0, 0xBF41} /* Korean hangul */,
  {0, 0, 0xBF44} /* Korean hangul */,
  {0, 0, 0xBF48} /* Korean hangul */,
  {0, 0, 0xBF50} /* Korean hangul */,
  {0, 0, 0xBF51} /* Korean hangul */,
  {0, 0, 0xBF55} /* Korean hangul */,
  {0, 0, 0xBFB0} /* Korean hangul */,
  {0, 0, 0xBFC0} /* Korean hangul */,
  {0, 0, 0xBFC5} /* Korean hangul */,
  {0, 0, 0xBFCC} /* Korean hangul */,
  {0, 0, 0xBFCD} /* Korean hangul */,
  {0, 0, 0xBFD0} /* Korean hangul */,
  {0, 0, 0xBFD4} /* Korean hangul */,
  {0, 0, 0xBFDC} /* Korean hangul */,
  {0, 0, 0xBFDD} /* Korean hangul */,
  {0, 0, 0xBFE1} /* Korean hangul */,
  {0, 0, 0xC058} /* Korean hangul */,
  {0, 0, 0xC059} /* Korean hangul */,
  {0, 0, 0xC05C} /* Korean hangul */,
  {0, 0, 0xC060} /* Korean hangul */,
  {0, 0, 0xC068} /* Korean hangul */,
  {0, 0, 0xC069} /* Korean hangul */,
  {0, 0, 0xC090} /* Korean hangul */,
  {0, 0, 0xC091} /* Korean hangul */,
  {0, 0, 0xC094} /* Korean hangul */,
  {0, 0, 0xC098} /* Korean hangul */,
  {0, 0, 0xC0A0} /* Korean hangul */,
  {0, 0, 0xC0A3} /* Korean hangul */,
  {0, 0, 0xC0A5} /* Korean hangul */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0xC0AC} /* Korean hangul */,
  {0, 0, 0xC0AD} /* Korean hangul */,
  {0, 0, 0xC0AE} /* Korean hangul */,
  {0, 0, 0xC0AF} /* Korean hangul */,
  {0, 0, 0xC0B0} /* Korean hangul */,
  {0, 0, 0xC0B3} /* Korean hangul */,
  {0, 0, 0xC0B4} /* Korean hangul */,
  {0, 0, 0xC0B5} /* Korean hangul */,
  {0, 0, 0xC0B6} /* Korean hangul */,
  {0, 0, 0xC0BC} /* Korean hangul */,
  {0, 0, 0xC0BD} /* Korean hangul */,
  {0, 0, 0xC0BF} /* Korean hangul */,
  {0, 0, 0xC0C0} /* Korean hangul */,
  {0, 0, 0xC0C1} /* Korean hangul */,
  {0, 0, 0xC0C5} /* Korean hangul */,
  {0, 0, 0xC0C8} /* Korean hangul */,
  {0, 0, 0xC0C9} /* Korean hangul */,
  {0, 0, 0xC0CC} /* Korean hangul */,
  {0, 0, 0xC0CF} /* Korean hangul */,
  {0, 0, 0xC0D0} /* Korean hangul */,
  {0, 0, 0xC0D8} /* Korean hangul */,
  {0, 0, 0xC0D9} /* Korean hangul */,
  {0, 0, 0xC0DB} /* Korean hangul */,
  {0, 0, 0xC0DC} /* Korean hangul */,
  {0, 0, 0xC0DD} /* Korean hangul */,
  {0, 0, 0xC0E4} /* Korean hangul */,
  {0, 0, 0xC0E5} /* Korean hangul */,
  {0, 0, 0xC0E8} /* Korean hangul */,
  {0, 0, 0xC0EC} /* Korean hangul */,
  {0, 0, 0xC0F4} /* Korean hangul */,
  {0, 0, 0xC0F7} /* Korean hangul */,
  {0, 0, 0xC0F9} /* Korean hangul */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8_31page810 = {
  0, marc8_31page810_dir
};
/* PAGE 809 */
struct yaz_iconv_trie_dir marc8_31page809_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0xBC40} /* Korean hangul */,
  {0, 0, 0xBC41} /* Korean hangul */,
  {0, 0, 0xBC43} /* Korean hangul */,
  {0, 0, 0xBC44} /* Korean hangul */,
  {0, 0, 0xBC45} /* Korean hangul */,
  {0, 0, 0xBC84} /* Korean hangul */,
  {0, 0, 0xBC85} /* Korean hangul */,
  {0, 0, 0xBC88} /* Korean hangul */,
  {0, 0, 0xBC8B} /* Korean hangul */,
  {0, 0, 0xBC8C} /* Korean hangul */,
  {0, 0, 0xBC94} /* Korean hangul */,
  {0, 0, 0xBC95} /* Korean hangul */,
  {0, 0, 0xBC97} /* Korean hangul */,
  {0, 0, 0xBC98} /* Korean hangul */,
  {0, 0, 0xBC99} /* Korean hangul */,
  {0, 0, 0xBC9A} /* Korean hangul */,
  {0, 0, 0xBCA0} /* Korean hangul */,
  {0, 0, 0xBCA1} /* Korean hangul */,
  {0, 0, 0xBCA4} /* Korean hangul */,
  {0, 0, 0xBCA7} /* Korean hangul */,
  {0, 0, 0xBCA8} /* Korean hangul */,
  {0, 0, 0xBCB0} /* Korean hangul */,
  {0, 0, 0xBCB1} /* Korean hangul */,
  {0, 0, 0xBCB3} /* Korean hangul */,
  {0, 0, 0xBCB5} /* Korean hangul */,
  {0, 0, 0xBCBC} /* Korean hangul */,
  {0, 0, 0xBCBD} /* Korean hangul */,
  {0, 0, 0xBCC0} /* Korean hangul */,
  {0, 0, 0xBCC4} /* Korean hangul */,
  {0, 0, 0xBCCC} /* Korean hangul */,
  {0, 0, 0xBCCD} /* Korean hangul */,
  {0, 0, 0xBCCF} /* Korean hangul */,
  {0, 0, 0xBCD0} /* Korean hangul */,
  {0, 0, 0xBCD1} /* Korean hangul */,
  {0, 0, 0xBCD2} /* Korean hangul */,
  {0, 0, 0xBCD5} /* Korean hangul */,
  {0, 0, 0xBCF4} /* Korean hangul */,
  {0, 0, 0xBCF5} /* Korean hangul */,
  {0, 0, 0xBCF6} /* Korean hangul */,
  {0, 0, 0xBCF8} /* Korean hangul */,
  {0, 0, 0xBCFC} /* Korean hangul */,
  {0, 0, 0xBD04} /* Korean hangul */,
  {0, 0, 0xBD05} /* Korean hangul */,
  {0, 0, 0xBD07} /* Korean hangul */,
  {0, 0, 0xBD09} /* Korean hangul */,
  {0, 0, 0xBD10} /* Korean hangul */,
  {0, 0, 0xBD14} /* Korean hangul */,
  {0, 0, 0xBD24} /* Korean hangul */,
  {0, 0, 0xBD48} /* Korean hangul */,
  {0, 0, 0xBD49} /* Korean hangul */,
  {0, 0, 0xBD4C} /* Korean hangul */,
  {0, 0, 0xBD50} /* Korean hangul */,
  {0, 0, 0xBD58} /* Korean hangul */,
  {0, 0, 0xBD59} /* Korean hangul */,
  {0, 0, 0xBD64} /* Korean hangul */,
  {0, 0, 0xBD80} /* Korean hangul */,
  {0, 0, 0xBD81} /* Korean hangul */,
  {0, 0, 0xBD84} /* Korean hangul */,
  {0, 0, 0xBD87} /* Korean hangul */,
  {0, 0, 0xBD88} /* Korean hangul */,
  {0, 0, 0xBD89} /* Korean hangul */,
  {0, 0, 0xBD90} /* Korean hangul */,
  {0, 0, 0xBD91} /* Korean hangul */,
  {0, 0, 0xBD93} /* Korean hangul */,
  {0, 0, 0xBD95} /* Korean hangul */,
  {0, 0, 0xBD99} /* Korean hangul */,
  {0, 0, 0xBD9C} /* Korean hangul */,
  {0, 0, 0xBDD4} /* Korean hangul */,
  {0, 0, 0xBDF0} /* Korean hangul */,
  {0, 0, 0xBE0C} /* Korean hangul */,
  {0, 0, 0xBE0D} /* Korean hangul */,
  {0, 0, 0xBE10} /* Korean hangul */,
  {0, 0, 0xBE14} /* Korean hangul */,
  {0, 0, 0xBE1C} /* Korean hangul */,
  {0, 0, 0xBE1D} /* Korean hangul */,
  {0, 0, 0xBE1F} /* Korean hangul */,
  {0, 0, 0xBE44} /* Korean hangul */,
  {0, 0, 0xBE45} /* Korean hangul */,
  {0, 0, 0xBE48} /* Korean hangul */,
  {0, 0, 0xBE4B} /* Korean hangul */,
  {0, 0, 0xBE4C} /* Korean hangul */,
  {0, 0, 0xBE4E} /* Korean hangul */,
  {0, 0, 0xBE54} /* Korean hangul */,
  {0, 0, 0xBE55} /* Korean hangul */,
  {0, 0, 0xBE57} /* Korean hangul */,
  {0, 0, 0xBE59} /* Korean hangul */,
  {0, 0, 0xBE5A} /* Korean hangul */,
  {0, 0, 0xBE5B} /* Korean hangul */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0xBE60} /* Korean hangul */,
  {0, 0, 0xBE61} /* Korean hangul */,
  {0, 0, 0xBE64} /* Korean hangul */,
  {0, 0, 0xBE68} /* Korean hangul */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8_31page809 = {
  0, marc8_31page809_dir
};
/* PAGE 808 */
struct yaz_iconv_trie_dir marc8_31page808_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0xBA38} /* Korean hangul */,
  {0, 0, 0xBA39} /* Korean hangul */,
  {0, 0, 0xBA3C} /* Korean hangul */,
  {0, 0, 0xBA40} /* Korean hangul */,
  {0, 0, 0xBA48} /* Korean hangul */,
  {0, 0, 0xBA49} /* Korean hangul */,
  {0, 0, 0xBA4B} /* Korean hangul */,
  {0, 0, 0xBA4D} /* Korean hangul */,
  {0, 0, 0xBA4E} /* Korean hangul */,
  {0, 0, 0xBA53} /* Korean hangul */,
  {0, 0, 0xBA54} /* Korean hangul */,
  {0, 0, 0xBA55} /* Korean hangul */,
  {0, 0, 0xBA58} /* Korean hangul */,
  {0, 0, 0xBA5C} /* Korean hangul */,
  {0, 0, 0xBA64} /* Korean hangul */,
  {0, 0, 0xBA65} /* Korean hangul */,
  {0, 0, 0xBA67} /* Korean hangul */,
  {0, 0, 0xBA70} /* Korean hangul */,
  {0, 0, 0xBA71} /* Korean hangul */,
  {0, 0, 0xBA74} /* Korean hangul */,
  {0, 0, 0xBA78} /* Korean hangul */,
  {0, 0, 0xBA83} /* Korean hangul */,
  {0, 0, 0xBA84} /* Korean hangul */,
  {0, 0, 0xBA85} /* Korean hangul */,
  {0, 0, 0xBA87} /* Korean hangul */,
  {0, 0, 0xBAA8} /* Korean hangul */,
  {0, 0, 0xBAA9} /* Korean hangul */,
  {0, 0, 0xBAAB} /* Korean hangul */,
  {0, 0, 0xBAAC} /* Korean hangul */,
  {0, 0, 0xBAB0} /* Korean hangul */,
  {0, 0, 0xBAB8} /* Korean hangul */,
  {0, 0, 0xBAB9} /* Korean hangul */,
  {0, 0, 0xBABB} /* Korean hangul */,
  {0, 0, 0xBABD} /* Korean hangul */,
  {0, 0, 0xBAC3} /* Korean hangul */,
  {0, 0, 0xBAFC} /* Korean hangul */,
  {0, 0, 0xBB0F} /* Korean hangul */,
  {0, 0, 0xBB18} /* Korean hangul */,
  {0, 0, 0xBB34} /* Korean hangul */,
  {0, 0, 0xBB35} /* Korean hangul */,
  {0, 0, 0xBB36} /* Korean hangul */,
  {0, 0, 0xBB38} /* Korean hangul */,
  {0, 0, 0xBB3B} /* Korean hangul */,
  {0, 0, 0xBB3C} /* Korean hangul */,
  {0, 0, 0xBB3D} /* Korean hangul */,
  {0, 0, 0xBB44} /* Korean hangul */,
  {0, 0, 0xBB47} /* Korean hangul */,
  {0, 0, 0xBB49} /* Korean hangul */,
  {0, 0, 0xBB4D} /* Korean hangul */,
  {0, 0, 0xBB4F} /* Korean hangul */,
  {0, 0, 0xBB50} /* Korean hangul */,
  {0, 0, 0xBB54} /* Korean hangul */,
  {0, 0, 0xBB58} /* Korean hangul */,
  {0, 0, 0xBB61} /* Korean hangul */,
  {0, 0, 0xBB63} /* Korean hangul */,
  {0, 0, 0xBB88} /* Korean hangul */,
  {0, 0, 0xBB8C} /* Korean hangul */,
  {0, 0, 0xBBA4} /* Korean hangul */,
  {0, 0, 0xBBC0} /* Korean hangul */,
  {0, 0, 0xBBC4} /* Korean hangul */,
  {0, 0, 0xBBC8} /* Korean hangul */,
  {0, 0, 0xBBD0} /* Korean hangul */,
  {0, 0, 0xBBF8} /* Korean hangul */,
  {0, 0, 0xBBF9} /* Korean hangul */,
  {0, 0, 0xBBFC} /* Korean hangul */,
  {0, 0, 0xBBFF} /* Korean hangul */,
  {0, 0, 0xBC00} /* Korean hangul */,
  {0, 0, 0xBC08} /* Korean hangul */,
  {0, 0, 0xBC09} /* Korean hangul */,
  {0, 0, 0xBC0B} /* Korean hangul */,
  {0, 0, 0},
  {0, 0, 0xBC0D} /* Korean hangul */,
  {0, 0, 0xBC0F} /* Korean hangul */,
  {0, 0, 0xBC11} /* Korean hangul */,
  {0, 0, 0xBBB4} /* Korean hangul */,
  {0, 0, 0},
  {0, 0, 0xBC14} /* Korean hangul */,
  {0, 0, 0xBC15} /* Korean hangul */,
  {0, 0, 0xBC16} /* Korean hangul */,
  {0, 0, 0xBC18} /* Korean hangul */,
  {0, 0, 0xBC1B} /* Korean hangul */,
  {0, 0, 0xBC1C} /* Korean hangul */,
  {0, 0, 0xBC1D} /* Korean hangul */,
  {0, 0, 0xBC1F} /* Korean hangul */,
  {0, 0, 0xBC24} /* Korean hangul */,
  {0, 0, 0xBC25} /* Korean hangul */,
  {0, 0, 0xBC27} /* Korean hangul */,
  {0, 0, 0xBC29} /* Korean hangul */,
  {0, 0, 0xBC2D} /* Korean hangul */,
  {0, 0, 0xBC30} /* Korean hangul */,
  {0, 0, 0xBC31} /* Korean hangul */,
  {0, 0, 0xBC34} /* Korean hangul */,
  {0, 0, 0xBC37} /* Korean hangul */,
  {0, 0, 0xBC38} /* Korean hangul */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8_31page808 = {
  0, marc8_31page808_dir
};
/* PAGE 807 */
struct yaz_iconv_trie_dir marc8_31page807_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0xB7FD} /* Korean hangul */,
  {0, 0, 0xB7FF} /* Korean hangul */,
  {0, 0, 0xB800} /* Korean hangul */,
  {0, 0, 0xB801} /* Korean hangul */,
  {0, 0, 0xB807} /* Korean hangul */,
  {0, 0, 0xB808} /* Korean hangul */,
  {0, 0, 0xB809} /* Korean hangul */,
  {0, 0, 0xB80C} /* Korean hangul */,
  {0, 0, 0xB810} /* Korean hangul */,
  {0, 0, 0xB818} /* Korean hangul */,
  {0, 0, 0xB819} /* Korean hangul */,
  {0, 0, 0xB81B} /* Korean hangul */,
  {0, 0, 0xB81D} /* Korean hangul */,
  {0, 0, 0xB824} /* Korean hangul */,
  {0, 0, 0xB825} /* Korean hangul */,
  {0, 0, 0xB828} /* Korean hangul */,
  {0, 0, 0xB82C} /* Korean hangul */,
  {0, 0, 0xB834} /* Korean hangul */,
  {0, 0, 0xB835} /* Korean hangul */,
  {0, 0, 0xB837} /* Korean hangul */,
  {0, 0, 0xB838} /* Korean hangul */,
  {0, 0, 0xB839} /* Korean hangul */,
  {0, 0, 0xB840} /* Korean hangul */,
  {0, 0, 0xB85C} /* Korean hangul */,
  {0, 0, 0xB85D} /* Korean hangul */,
  {0, 0, 0xB860} /* Korean hangul */,
  {0, 0, 0xB864} /* Korean hangul */,
  {0, 0, 0xB86C} /* Korean hangul */,
  {0, 0, 0xB86D} /* Korean hangul */,
  {0, 0, 0xB86F} /* Korean hangul */,
  {0, 0, 0xB871} /* Korean hangul */,
  {0, 0, 0xB8B0} /* Korean hangul */,
  {0, 0, 0xB8CC} /* Korean hangul */,
  {0, 0, 0xB8E1} /* Korean hangul */,
  {0, 0, 0xB8E8} /* Korean hangul */,
  {0, 0, 0xB8E9} /* Korean hangul */,
  {0, 0, 0xB8EC} /* Korean hangul */,
  {0, 0, 0xB8F0} /* Korean hangul */,
  {0, 0, 0xB8F8} /* Korean hangul */,
  {0, 0, 0xB8F9} /* Korean hangul */,
  {0, 0, 0xB8FB} /* Korean hangul */,
  {0, 0, 0xB8FD} /* Korean hangul */,
  {0, 0, 0xB904} /* Korean hangul */,
  {0, 0, 0xB93C} /* Korean hangul */,
  {0, 0, 0xB958} /* Korean hangul */,
  {0, 0, 0xB959} /* Korean hangul */,
  {0, 0, 0xB95C} /* Korean hangul */,
  {0, 0, 0xB960} /* Korean hangul */,
  {0, 0, 0xB968} /* Korean hangul */,
  {0, 0, 0xB96D} /* Korean hangul */,
  {0, 0, 0xB974} /* Korean hangul */,
  {0, 0, 0xB975} /* Korean hangul */,
  {0, 0, 0xB978} /* Korean hangul */,
  {0, 0, 0xB97C} /* Korean hangul */,
  {0, 0, 0xB984} /* Korean hangul */,
  {0, 0, 0xB985} /* Korean hangul */,
  {0, 0, 0xB987} /* Korean hangul */,
  {0, 0, 0xB989} /* Korean hangul */,
  {0, 0, 0xB98E} /* Korean hangul */,
  {0, 0, 0xB9AC} /* Korean hangul */,
  {0, 0, 0xB9AD} /* Korean hangul */,
  {0, 0, 0xB9B0} /* Korean hangul */,
  {0, 0, 0xB9B4} /* Korean hangul */,
  {0, 0, 0xB9BC} /* Korean hangul */,
  {0, 0, 0xB9BD} /* Korean hangul */,
  {0, 0, 0xB9BF} /* Korean hangul */,
  {0, 0, 0xB9C1} /* Korean hangul */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0xB9C8} /* Korean hangul */,
  {0, 0, 0xB9C9} /* Korean hangul */,
  {0, 0, 0xB9CC} /* Korean hangul */,
  {0, 0, 0xB9CE} /* Korean hangul */,
  {0, 0, 0xB9CF} /* Korean hangul */,
  {0, 0, 0xB9D0} /* Korean hangul */,
  {0, 0, 0xB9D1} /* Korean hangul */,
  {0, 0, 0xB9D8} /* Korean hangul */,
  {0, 0, 0xB9D9} /* Korean hangul */,
  {0, 0, 0xB9DB} /* Korean hangul */,
  {0, 0, 0xB9DD} /* Korean hangul */,
  {0, 0, 0xB9DE} /* Korean hangul */,
  {0, 0, 0xB9E1} /* Korean hangul */,
  {0, 0, 0xB9E3} /* Korean hangul */,
  {0, 0, 0xB9E4} /* Korean hangul */,
  {0, 0, 0xB9E5} /* Korean hangul */,
  {0, 0, 0xB9E8} /* Korean hangul */,
  {0, 0, 0xB9EC} /* Korean hangul */,
  {0, 0, 0xB9F4} /* Korean hangul */,
  {0, 0, 0xB9F5} /* Korean hangul */,
  {0, 0, 0xB9F7} /* Korean hangul */,
  {0, 0, 0xB9F8} /* Korean hangul */,
  {0, 0, 0xB9F9} /* Korean hangul */,
  {0, 0, 0xB9FA} /* Korean hangul */,
  {0, 0, 0xBA00} /* Korean hangul */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8_31page807 = {
  0, marc8_31page807_dir
};
/* PAGE 806 */
struct yaz_iconv_trie_dir marc8_31page806_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0xB540} /* Korean hangul */,
  {0, 0, 0xB541} /* Korean hangul */,
  {0, 0, 0xB543} /* Korean hangul */,
  {0, 0, 0xB544} /* Korean hangul */,
  {0, 0, 0xB545} /* Korean hangul */,
  {0, 0, 0xB54B} /* Korean hangul */,
  {0, 0, 0xB54C} /* Korean hangul */,
  {0, 0, 0xB54D} /* Korean hangul */,
  {0, 0, 0xB550} /* Korean hangul */,
  {0, 0, 0xB554} /* Korean hangul */,
  {0, 0, 0xB55C} /* Korean hangul */,
  {0, 0, 0xB55D} /* Korean hangul */,
  {0, 0, 0xB55F} /* Korean hangul */,
  {0, 0, 0xB560} /* Korean hangul */,
  {0, 0, 0xB561} /* Korean hangul */,
  {0, 0, 0xB5A0} /* Korean hangul */,
  {0, 0, 0xB5A1} /* Korean hangul */,
  {0, 0, 0xB5A4} /* Korean hangul */,
  {0, 0, 0xB5A8} /* Korean hangul */,
  {0, 0, 0xB5AB} /* Korean hangul */,
  {0, 0, 0xB5B0} /* Korean hangul */,
  {0, 0, 0xB5B1} /* Korean hangul */,
  {0, 0, 0xB5B3} /* Korean hangul */,
  {0, 0, 0xB5B4} /* Korean hangul */,
  {0, 0, 0xB5B5} /* Korean hangul */,
  {0, 0, 0xB5BB} /* Korean hangul */,
  {0, 0, 0xB5BC} /* Korean hangul */,
  {0, 0, 0xB5C0} /* Korean hangul */,
  {0, 0, 0xB5C4} /* Korean hangul */,
  {0, 0, 0xB5CC} /* Korean hangul */,
  {0, 0, 0xB5CF} /* Korean hangul */,
  {0, 0, 0xB5D1} /* Korean hangul */,
  {0, 0, 0xB610} /* Korean hangul */,
  {0, 0, 0xB611} /* Korean hangul */,
  {0, 0, 0xB614} /* Korean hangul */,
  {0, 0, 0xB618} /* Korean hangul */,
  {0, 0, 0xB625} /* Korean hangul */,
  {0, 0, 0xB664} /* Korean hangul */,
  {0, 0, 0xB69C} /* Korean hangul */,
  {0, 0, 0xB69D} /* Korean hangul */,
  {0, 0, 0xB6A4} /* Korean hangul */,
  {0, 0, 0xB6AB} /* Korean hangul */,
  {0, 0, 0xB6AC} /* Korean hangul */,
  {0, 0, 0xB6B1} /* Korean hangul */,
  {0, 0, 0xB6F0} /* Korean hangul */,
  {0, 0, 0xB6F4} /* Korean hangul */,
  {0, 0, 0xB6F8} /* Korean hangul */,
  {0, 0, 0xB700} /* Korean hangul */,
  {0, 0, 0xB701} /* Korean hangul */,
  {0, 0, 0xB728} /* Korean hangul */,
  {0, 0, 0xB729} /* Korean hangul */,
  {0, 0, 0xB72C} /* Korean hangul */,
  {0, 0, 0xB72F} /* Korean hangul */,
  {0, 0, 0xB730} /* Korean hangul */,
  {0, 0, 0xB738} /* Korean hangul */,
  {0, 0, 0xB739} /* Korean hangul */,
  {0, 0, 0xB73B} /* Korean hangul */,
  {0, 0, 0xB744} /* Korean hangul */,
  {0, 0, 0xB748} /* Korean hangul */,
  {0, 0, 0xB760} /* Korean hangul */,
  {0, 0, 0xB764} /* Korean hangul */,
  {0, 0, 0xB768} /* Korean hangul */,
  {0, 0, 0xB770} /* Korean hangul */,
  {0, 0, 0xB771} /* Korean hangul */,
  {0, 0, 0xB775} /* Korean hangul */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0xB77C} /* Korean hangul */,
  {0, 0, 0xB77D} /* Korean hangul */,
  {0, 0, 0xB780} /* Korean hangul */,
  {0, 0, 0xB784} /* Korean hangul */,
  {0, 0, 0xB78C} /* Korean hangul */,
  {0, 0, 0xB78D} /* Korean hangul */,
  {0, 0, 0xB78F} /* Korean hangul */,
  {0, 0, 0xB790} /* Korean hangul */,
  {0, 0, 0xB791} /* Korean hangul */,
  {0, 0, 0xB797} /* Korean hangul */,
  {0, 0, 0xB798} /* Korean hangul */,
  {0, 0, 0xB799} /* Korean hangul */,
  {0, 0, 0xB79C} /* Korean hangul */,
  {0, 0, 0xB7A0} /* Korean hangul */,
  {0, 0, 0xB7A8} /* Korean hangul */,
  {0, 0, 0xB7A9} /* Korean hangul */,
  {0, 0, 0xB7AB} /* Korean hangul */,
  {0, 0, 0xB7AC} /* Korean hangul */,
  {0, 0, 0xB7AD} /* Korean hangul */,
  {0, 0, 0xB7B4} /* Korean hangul */,
  {0, 0, 0xB7B5} /* Korean hangul */,
  {0, 0, 0xB7C9} /* Korean hangul */,
  {0, 0, 0xB7EC} /* Korean hangul */,
  {0, 0, 0xB7ED} /* Korean hangul */,
  {0, 0, 0xB7F0} /* Korean hangul */,
  {0, 0, 0xB7F4} /* Korean hangul */,
  {0, 0, 0xB7FC} /* Korean hangul */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8_31page806 = {
  0, marc8_31page806_dir
};
/* PAGE 805 */
struct yaz_iconv_trie_dir marc8_31page805_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0xB304} /* Korean hangul */,
  {0, 0, 0xB308} /* Korean hangul */,
  {0, 0, 0xB310} /* Korean hangul */,
  {0, 0, 0xB311} /* Korean hangul */,
  {0, 0, 0xB313} /* Korean hangul */,
  {0, 0, 0xB314} /* Korean hangul */,
  {0, 0, 0xB315} /* Korean hangul */,
  {0, 0, 0xB354} /* Korean hangul */,
  {0, 0, 0xB355} /* Korean hangul */,
  {0, 0, 0xB358} /* Korean hangul */,
  {0, 0, 0xB35B} /* Korean hangul */,
  {0, 0, 0xB35C} /* Korean hangul */,
  {0, 0, 0xB35F} /* Korean hangul */,
  {0, 0, 0xB364} /* Korean hangul */,
  {0, 0, 0xB365} /* Korean hangul */,
  {0, 0, 0xB367} /* Korean hangul */,
  {0, 0, 0xB368} /* Korean hangul */,
  {0, 0, 0xB369} /* Korean hangul */,
  {0, 0, 0xB36A} /* Korean hangul */,
  {0, 0, 0xB36B} /* Korean hangul */,
  {0, 0, 0xB36E} /* Korean hangul */,
  {0, 0, 0xB370} /* Korean hangul */,
  {0, 0, 0xB371} /* Korean hangul */,
  {0, 0, 0xB374} /* Korean hangul */,
  {0, 0, 0xB378} /* Korean hangul */,
  {0, 0, 0xB380} /* Korean hangul */,
  {0, 0, 0xB383} /* Korean hangul */,
  {0, 0, 0xB385} /* Korean hangul */,
  {0, 0, 0xB38C} /* Korean hangul */,
  {0, 0, 0xB3C4} /* Korean hangul */,
  {0, 0, 0xB3C5} /* Korean hangul */,
  {0, 0, 0xB3C8} /* Korean hangul */,
  {0, 0, 0xB3CB} /* Korean hangul */,
  {0, 0, 0xB3CC} /* Korean hangul */,
  {0, 0, 0xB3D0} /* Korean hangul */,
  {0, 0, 0xB3D4} /* Korean hangul */,
  {0, 0, 0xB3D5} /* Korean hangul */,
  {0, 0, 0xB3D7} /* Korean hangul */,
  {0, 0, 0xB3D9} /* Korean hangul */,
  {0, 0, 0xB3DB} /* Korean hangul */,
  {0, 0, 0xB3FC} /* Korean hangul */,
  {0, 0, 0xB400} /* Korean hangul */,
  {0, 0, 0xB410} /* Korean hangul */,
  {0, 0, 0xB418} /* Korean hangul */,
  {0, 0, 0xB41C} /* Korean hangul */,
  {0, 0, 0xB420} /* Korean hangul */,
  {0, 0, 0xB428} /* Korean hangul */,
  {0, 0, 0xB429} /* Korean hangul */,
  {0, 0, 0xB42B} /* Korean hangul */,
  {0, 0, 0xB42C} /* Korean hangul */,
  {0, 0, 0xB450} /* Korean hangul */,
  {0, 0, 0xB451} /* Korean hangul */,
  {0, 0, 0xB454} /* Korean hangul */,
  {0, 0, 0xB458} /* Korean hangul */,
  {0, 0, 0xB460} /* Korean hangul */,
  {0, 0, 0xB461} /* Korean hangul */,
  {0, 0, 0xB463} /* Korean hangul */,
  {0, 0, 0xB465} /* Korean hangul */,
  {0, 0, 0xB46C} /* Korean hangul */,
  {0, 0, 0xB480} /* Korean hangul */,
  {0, 0, 0xB488} /* Korean hangul */,
  {0, 0, 0xB4A4} /* Korean hangul */,
  {0, 0, 0xB4B7} /* Korean hangul */,
  {0, 0, 0xB4C0} /* Korean hangul */,
  {0, 0, 0xB4D0} /* Korean hangul */,
  {0, 0, 0xB4DC} /* Korean hangul */,
  {0, 0, 0xB4DD} /* Korean hangul */,
  {0, 0, 0xB4E0} /* Korean hangul */,
  {0, 0, 0xB4E3} /* Korean hangul */,
  {0, 0, 0xB4E4} /* Korean hangul */,
  {0, 0, 0xB4EC} /* Korean hangul */,
  {0, 0, 0xB4ED} /* Korean hangul */,
  {0, 0, 0xB4EF} /* Korean hangul */,
  {0, 0, 0xB4F1} /* Korean hangul */,
  {0, 0, 0xB514} /* Korean hangul */,
  {0, 0, 0xB515} /* Korean hangul */,
  {0, 0, 0xB518} /* Korean hangul */,
  {0, 0, 0xB51B} /* Korean hangul */,
  {0, 0, 0xB51C} /* Korean hangul */,
  {0, 0, 0xB524} /* Korean hangul */,
  {0, 0, 0xB525} /* Korean hangul */,
  {0, 0, 0xB527} /* Korean hangul */,
  {0, 0, 0xB528} /* Korean hangul */,
  {0, 0, 0xB529} /* Korean hangul */,
  {0, 0, 0xB52A} /* Korean hangul */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0xB530} /* Korean hangul */,
  {0, 0, 0xB531} /* Korean hangul */,
  {0, 0, 0xB532} /* Korean hangul */,
  {0, 0, 0xB534} /* Korean hangul */,
  {0, 0, 0xB537} /* Korean hangul */,
  {0, 0, 0xB538} /* Korean hangul */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8_31page805 = {
  0, marc8_31page805_dir
};
/* PAGE 804 */
struct yaz_iconv_trie_dir marc8_31page804_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0xB128} /* Korean hangul */,
  {0, 0, 0xB12C} /* Korean hangul */,
  {0, 0, 0xB134} /* Korean hangul */,
  {0, 0, 0xB135} /* Korean hangul */,
  {0, 0, 0xB137} /* Korean hangul */,
  {0, 0, 0xB140} /* Korean hangul */,
  {0, 0, 0xB141} /* Korean hangul */,
  {0, 0, 0xB144} /* Korean hangul */,
  {0, 0, 0xB150} /* Korean hangul */,
  {0, 0, 0xB151} /* Korean hangul */,
  {0, 0, 0xB153} /* Korean hangul */,
  {0, 0, 0xB154} /* Korean hangul */,
  {0, 0, 0xB155} /* Korean hangul */,
  {0, 0, 0xB158} /* Korean hangul */,
  {0, 0, 0xB15C} /* Korean hangul */,
  {0, 0, 0xB178} /* Korean hangul */,
  {0, 0, 0xB179} /* Korean hangul */,
  {0, 0, 0xB17A} /* Korean hangul */,
  {0, 0, 0xB17C} /* Korean hangul */,
  {0, 0, 0xB180} /* Korean hangul */,
  {0, 0, 0xB188} /* Korean hangul */,
  {0, 0, 0xB189} /* Korean hangul */,
  {0, 0, 0xB18B} /* Korean hangul */,
  {0, 0, 0xB18D} /* Korean hangul */,
  {0, 0, 0xB192} /* Korean hangul */,
  {0, 0, 0xB193} /* Korean hangul */,
  {0, 0, 0xB194} /* Korean hangul */,
  {0, 0, 0xB1A8} /* Korean hangul */,
  {0, 0, 0xB1CC} /* Korean hangul */,
  {0, 0, 0xB1D0} /* Korean hangul */,
  {0, 0, 0xB1D4} /* Korean hangul */,
  {0, 0, 0xB1DC} /* Korean hangul */,
  {0, 0, 0xB1E8} /* Korean hangul */,
  {0, 0, 0xB1FD} /* Korean hangul */,
  {0, 0, 0xB204} /* Korean hangul */,
  {0, 0, 0xB205} /* Korean hangul */,
  {0, 0, 0xB208} /* Korean hangul */,
  {0, 0, 0xB20B} /* Korean hangul */,
  {0, 0, 0xB20C} /* Korean hangul */,
  {0, 0, 0xB213} /* Korean hangul */,
  {0, 0, 0xB214} /* Korean hangul */,
  {0, 0, 0xB215} /* Korean hangul */,
  {0, 0, 0xB217} /* Korean hangul */,
  {0, 0, 0xB220} /* Korean hangul */,
  {0, 0, 0xB233} /* Korean hangul */,
  {0, 0, 0xB234} /* Korean hangul */,
  {0, 0, 0xB258} /* Korean hangul */,
  {0, 0, 0xB25C} /* Korean hangul */,
  {0, 0, 0xB260} /* Korean hangul */,
  {0, 0, 0xB268} /* Korean hangul */,
  {0, 0, 0xB269} /* Korean hangul */,
  {0, 0, 0xB274} /* Korean hangul */,
  {0, 0, 0xB284} /* Korean hangul */,
  {0, 0, 0xB289} /* Korean hangul */,
  {0, 0, 0xB290} /* Korean hangul */,
  {0, 0, 0xB291} /* Korean hangul */,
  {0, 0, 0xB294} /* Korean hangul */,
  {0, 0, 0xB298} /* Korean hangul */,
  {0, 0, 0xB299} /* Korean hangul */,
  {0, 0, 0xB2A0} /* Korean hangul */,
  {0, 0, 0xB2A1} /* Korean hangul */,
  {0, 0, 0xB2A5} /* Korean hangul */,
  {0, 0, 0xB2A6} /* Korean hangul */,
  {0, 0, 0xB2AA} /* Korean hangul */,
  {0, 0, 0xB2AC} /* Korean hangul */,
  {0, 0, 0xB2C8} /* Korean hangul */,
  {0, 0, 0xB2C9} /* Korean hangul */,
  {0, 0, 0xB2CC} /* Korean hangul */,
  {0, 0, 0xB2D0} /* Korean hangul */,
  {0, 0, 0xB2D8} /* Korean hangul */,
  {0, 0, 0xB2D9} /* Korean hangul */,
  {0, 0, 0xB2DB} /* Korean hangul */,
  {0, 0, 0xB2DD} /* Korean hangul */,
  {0, 0, 0xB2E2} /* Korean hangul */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0xB2E4} /* Korean hangul */,
  {0, 0, 0xB2E5} /* Korean hangul */,
  {0, 0, 0xB2E6} /* Korean hangul */,
  {0, 0, 0xB2E8} /* Korean hangul */,
  {0, 0, 0xB2EB} /* Korean hangul */,
  {0, 0, 0xB2EC} /* Korean hangul */,
  {0, 0, 0xB2ED} /* Korean hangul */,
  {0, 0, 0xB2EE} /* Korean hangul */,
  {0, 0, 0xB2F3} /* Korean hangul */,
  {0, 0, 0xB2F4} /* Korean hangul */,
  {0, 0, 0xB2F5} /* Korean hangul */,
  {0, 0, 0xB2F7} /* Korean hangul */,
  {0, 0, 0xB2F9} /* Korean hangul */,
  {0, 0, 0xB2FA} /* Korean hangul */,
  {0, 0, 0xB2FB} /* Korean hangul */,
  {0, 0, 0xB2FF} /* Korean hangul */,
  {0, 0, 0xB300} /* Korean hangul */,
  {0, 0, 0xB301} /* Korean hangul */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8_31page804 = {
  0, marc8_31page804_dir
};
/* PAGE 803 */
struct yaz_iconv_trie_dir marc8_31page803_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0xAF9C} /* Korean hangul */,
  {0, 0, 0xAFB8} /* Korean hangul */,
  {0, 0, 0xAFB9} /* Korean hangul */,
  {0, 0, 0xAFBC} /* Korean hangul */,
  {0, 0, 0xAFC0} /* Korean hangul */,
  {0, 0, 0xAFC7} /* Korean hangul */,
  {0, 0, 0xAFC8} /* Korean hangul */,
  {0, 0, 0xAFC9} /* Korean hangul */,
  {0, 0, 0xAFCB} /* Korean hangul */,
  {0, 0, 0xAFCD} /* Korean hangul */,
  {0, 0, 0xAFCE} /* Korean hangul */,
  {0, 0, 0xAFD4} /* Korean hangul */,
  {0, 0, 0xAFD8} /* Korean hangul */,
  {0, 0, 0xAFE9} /* Korean hangul */,
  {0, 0, 0xAFF0} /* Korean hangul */,
  {0, 0, 0xB000} /* Korean hangul */,
  {0, 0, 0},
  {0, 0, 0xB00C} /* Korean hangul */,
  {0, 0, 0xB00D} /* Korean hangul */,
  {0, 0, 0xB010} /* Korean hangul */,
  {0, 0, 0xB014} /* Korean hangul */,
  {0, 0, 0xB01C} /* Korean hangul */,
  {0, 0, 0xB01D} /* Korean hangul */,
  {0, 0, 0xB028} /* Korean hangul */,
  {0, 0, 0xB044} /* Korean hangul */,
  {0, 0, 0xB045} /* Korean hangul */,
  {0, 0, 0xB048} /* Korean hangul */,
  {0, 0, 0xB04A} /* Korean hangul */,
  {0, 0, 0xB04C} /* Korean hangul */,
  {0, 0, 0xB053} /* Korean hangul */,
  {0, 0, 0xB054} /* Korean hangul */,
  {0, 0, 0xB055} /* Korean hangul */,
  {0, 0, 0xB057} /* Korean hangul */,
  {0, 0, 0xB059} /* Korean hangul */,
  {0, 0, 0xB05D} /* Korean hangul */,
  {0, 0, 0xB07C} /* Korean hangul */,
  {0, 0, 0xB07D} /* Korean hangul */,
  {0, 0, 0xB080} /* Korean hangul */,
  {0, 0, 0xB084} /* Korean hangul */,
  {0, 0, 0xB08C} /* Korean hangul */,
  {0, 0, 0xB08D} /* Korean hangul */,
  {0, 0, 0xB08F} /* Korean hangul */,
  {0, 0, 0xB090} /* Korean hangul */,
  {0, 0, 0xB091} /* Korean hangul */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0xB098} /* Korean hangul */,
  {0, 0, 0xB099} /* Korean hangul */,
  {0, 0, 0xB09A} /* Korean hangul */,
  {0, 0, 0xB09C} /* Korean hangul */,
  {0, 0, 0xB09F} /* Korean hangul */,
  {0, 0, 0xB0A0} /* Korean hangul */,
  {0, 0, 0xB0A1} /* Korean hangul */,
  {0, 0, 0xB0A8} /* Korean hangul */,
  {0, 0, 0xB0A9} /* Korean hangul */,
  {0, 0, 0xB0AB} /* Korean hangul */,
  {0, 0, 0xB0AC} /* Korean hangul */,
  {0, 0, 0xB0AD} /* Korean hangul */,
  {0, 0, 0xB0AE} /* Korean hangul */,
  {0, 0, 0xB0AF} /* Korean hangul */,
  {0, 0, 0xB0B1} /* Korean hangul */,
  {0, 0, 0xB0B3} /* Korean hangul */,
  {0, 0, 0xB0B4} /* Korean hangul */,
  {0, 0, 0xB0B5} /* Korean hangul */,
  {0, 0, 0xB0B8} /* Korean hangul */,
  {0, 0, 0xB0BB} /* Korean hangul */,
  {0, 0, 0xB0BC} /* Korean hangul */,
  {0, 0, 0xB0C4} /* Korean hangul */,
  {0, 0, 0xB0C5} /* Korean hangul */,
  {0, 0, 0xB0C7} /* Korean hangul */,
  {0, 0, 0xB0C8} /* Korean hangul */,
  {0, 0, 0xB0C9} /* Korean hangul */,
  {0, 0, 0xB0D0} /* Korean hangul */,
  {0, 0, 0xB0D1} /* Korean hangul */,
  {0, 0, 0xB0E0} /* Korean hangul */,
  {0, 0, 0xB0E5} /* Korean hangul */,
  {0, 0, 0xB0EC} /* Korean hangul */,
  {0, 0, 0xB108} /* Korean hangul */,
  {0, 0, 0xB109} /* Korean hangul */,
  {0, 0, 0},
  {0, 0, 0xB10B} /* Korean hangul */,
  {0, 0, 0xB10C} /* Korean hangul */,
  {0, 0, 0xB10F} /* Korean hangul */,
  {0, 0, 0xB110} /* Korean hangul */,
  {0, 0, 0xB113} /* Korean hangul */,
  {0, 0, 0xB118} /* Korean hangul */,
  {0, 0, 0xB119} /* Korean hangul */,
  {0, 0, 0xB11B} /* Korean hangul */,
  {0, 0, 0xB11C} /* Korean hangul */,
  {0, 0, 0xB11D} /* Korean hangul */,
  {0, 0, 0xB11E} /* Korean hangul */,
  {0, 0, 0xB123} /* Korean hangul */,
  {0, 0, 0xB124} /* Korean hangul */,
  {0, 0, 0xB125} /* Korean hangul */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8_31page803 = {
  0, marc8_31page803_dir
};
/* PAGE 802 */
struct yaz_iconv_trie_dir marc8_31page802_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0xADC0} /* Korean hangul */,
  {0, 0, 0xADC4} /* Korean hangul */,
  {0, 0, 0xADC8} /* Korean hangul */,
  {0, 0, 0xADD0} /* Korean hangul */,
  {0, 0, 0xADD1} /* Korean hangul */,
  {0, 0, 0xADD3} /* Korean hangul */,
  {0, 0, 0xADDC} /* Korean hangul */,
  {0, 0, 0xADE0} /* Korean hangul */,
  {0, 0, 0xADE4} /* Korean hangul */,
  {0, 0, 0xADEC} /* Korean hangul */,
  {0, 0, 0xADF8} /* Korean hangul */,
  {0, 0, 0xADF9} /* Korean hangul */,
  {0, 0, 0xADFC} /* Korean hangul */,
  {0, 0, 0xADFF} /* Korean hangul */,
  {0, 0, 0xAE00} /* Korean hangul */,
  {0, 0, 0xAE01} /* Korean hangul */,
  {0, 0, 0xAE08} /* Korean hangul */,
  {0, 0, 0xAE09} /* Korean hangul */,
  {0, 0, 0xAE0B} /* Korean hangul */,
  {0, 0, 0xAE0D} /* Korean hangul */,
  {0, 0, 0xAE30} /* Korean hangul */,
  {0, 0, 0xAE31} /* Korean hangul */,
  {0, 0, 0xAE34} /* Korean hangul */,
  {0, 0, 0xAE37} /* Korean hangul */,
  {0, 0, 0xAE38} /* Korean hangul */,
  {0, 0, 0xAE40} /* Korean hangul */,
  {0, 0, 0xAE41} /* Korean hangul */,
  {0, 0, 0xAE43} /* Korean hangul */,
  {0, 0, 0xAE44} /* Korean hangul */,
  {0, 0, 0xAE45} /* Korean hangul */,
  {0, 0, 0xAE4A} /* Korean hangul */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0xAE4C} /* Korean hangul */,
  {0, 0, 0xAE4D} /* Korean hangul */,
  {0, 0, 0xAE4E} /* Korean hangul */,
  {0, 0, 0xAE50} /* Korean hangul */,
  {0, 0, 0xAE54} /* Korean hangul */,
  {0, 0, 0xAE5C} /* Korean hangul */,
  {0, 0, 0xAE5D} /* Korean hangul */,
  {0, 0, 0xAE60} /* Korean hangul */,
  {0, 0, 0xAE61} /* Korean hangul */,
  {0, 0, 0xAE62} /* Korean hangul */,
  {0, 0, 0xAE65} /* Korean hangul */,
  {0, 0, 0xAE68} /* Korean hangul */,
  {0, 0, 0xAE69} /* Korean hangul */,
  {0, 0, 0xAE6C} /* Korean hangul */,
  {0, 0, 0xAE70} /* Korean hangul */,
  {0, 0, 0xAE78} /* Korean hangul */,
  {0, 0, 0xAE79} /* Korean hangul */,
  {0, 0, 0xAE7B} /* Korean hangul */,
  {0, 0, 0xAE7C} /* Korean hangul */,
  {0, 0, 0xAE7D} /* Korean hangul */,
  {0, 0, 0xAE84} /* Korean hangul */,
  {0, 0, 0xAE85} /* Korean hangul */,
  {0, 0, 0xAEBC} /* Korean hangul */,
  {0, 0, 0xAEBD} /* Korean hangul */,
  {0, 0, 0xAEBE} /* Korean hangul */,
  {0, 0, 0xAEC0} /* Korean hangul */,
  {0, 0, 0xAEC4} /* Korean hangul */,
  {0, 0, 0xAECC} /* Korean hangul */,
  {0, 0, 0xAECD} /* Korean hangul */,
  {0, 0, 0xAECF} /* Korean hangul */,
  {0, 0, 0xAED0} /* Korean hangul */,
  {0, 0, 0xAED1} /* Korean hangul */,
  {0, 0, 0xAED8} /* Korean hangul */,
  {0, 0, 0xAEDC} /* Korean hangul */,
  {0, 0, 0xAEF4} /* Korean hangul */,
  {0, 0, 0xAF0D} /* Korean hangul */,
  {0, 0, 0xAF2C} /* Korean hangul */,
  {0, 0, 0xAF2D} /* Korean hangul */,
  {0, 0, 0xAF30} /* Korean hangul */,
  {0, 0, 0xAF34} /* Korean hangul */,
  {0, 0, 0xAF3C} /* Korean hangul */,
  {0, 0, 0xAF3D} /* Korean hangul */,
  {0, 0, 0xAF3F} /* Korean hangul */,
  {0, 0, 0xAF41} /* Korean hangul */,
  {0, 0, 0xAF42} /* Korean hangul */,
  {0, 0, 0xAF43} /* Korean hangul */,
  {0, 0, 0xAF48} /* Korean hangul */,
  {0, 0, 0xAF49} /* Korean hangul */,
  {0, 0, 0xAF4C} /* Korean hangul */,
  {0, 0, 0xAF58} /* Korean hangul */,
  {0, 0, 0xAF5C} /* Korean hangul */,
  {0, 0, 0xAF5D} /* Korean hangul */,
  {0, 0, 0xAF64} /* Korean hangul */,
  {0, 0, 0xAF65} /* Korean hangul */,
  {0, 0, 0xAF79} /* Korean hangul */,
  {0, 0, 0xAF80} /* Korean hangul */,
  {0, 0, 0xAF84} /* Korean hangul */,
  {0, 0, 0xAF88} /* Korean hangul */,
  {0, 0, 0xAF90} /* Korean hangul */,
  {0, 0, 0xAF95} /* Korean hangul */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8_31page802 = {
  0, marc8_31page802_dir
};
/* PAGE 801 */
struct yaz_iconv_trie_dir marc8_31page801_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0xAC70} /* Korean hangul */,
  {0, 0, 0xAC71} /* Korean hangul */,
  {0, 0, 0},
  {0, 0, 0xAC74} /* Korean hangul */,
  {0, 0, 0xAC77} /* Korean hangul */,
  {0, 0, 0xAC78} /* Korean hangul */,
  {0, 0, 0xAC79} /* Korean hangul */,
  {0, 0, 0},
  {0, 0, 0xAC80} /* Korean hangul */,
  {0, 0, 0xAC81} /* Korean hangul */,
  {0, 0, 0xAC83} /* Korean hangul */,
  {0, 0, 0xAC84} /* Korean hangul */,
  {0, 0, 0xAC85} /* Korean hangul */,
  {0, 0, 0xAC86} /* Korean hangul */,
  {0, 0, 0},
  {0, 0, 0xAC89} /* Korean hangul */,
  {0, 0, 0xAC8A} /* Korean hangul */,
  {0, 0, 0xAC8B} /* Korean hangul */,
  {0, 0, 0xAC8C} /* Korean hangul */,
  {0, 0, 0xAC90} /* Korean hangul */,
  {0, 0, 0xAC94} /* Korean hangul */,
  {0, 0, 0xAC9C} /* Korean hangul */,
  {0, 0, 0xAC9F} /* Korean hangul */,
  {0, 0, 0xACA0} /* Korean hangul */,
  {0, 0, 0xACA1} /* Korean hangul */,
  {0, 0, 0xACA8} /* Korean hangul */,
  {0, 0, 0xACA9} /* Korean hangul */,
  {0, 0, 0xACAA} /* Korean hangul */,
  {0, 0, 0xACAC} /* Korean hangul */,
  {0, 0, 0xACAF} /* Korean hangul */,
  {0, 0, 0xACB0} /* Korean hangul */,
  {0, 0, 0xACB8} /* Korean hangul */,
  {0, 0, 0xACB9} /* Korean hangul */,
  {0, 0, 0},
  {0, 0, 0xACBC} /* Korean hangul */,
  {0, 0, 0xACBD} /* Korean hangul */,
  {0, 0, 0xACC1} /* Korean hangul */,
  {0, 0, 0},
  {0, 0, 0xACC4} /* Korean hangul */,
  {0, 0, 0},
  {0, 0, 0xACD7} /* Korean hangul */,
  {0, 0, 0xACE0} /* Korean hangul */,
  {0, 0, 0xACE1} /* Korean hangul */,
  {0, 0, 0xACE4} /* Korean hangul */,
  {0, 0, 0xACE7} /* Korean hangul */,
  {0, 0, 0xACE8} /* Korean hangul */,
  {0, 0, 0xACEA} /* Korean hangul */,
  {0, 0, 0xACEC} /* Korean hangul */,
  {0, 0, 0xACEF} /* Korean hangul */,
  {0, 0, 0xACF0} /* Korean hangul */,
  {0, 0, 0xACF1} /* Korean hangul */,
  {0, 0, 0xACF3} /* Korean hangul */,
  {0, 0, 0xACF5} /* Korean hangul */,
  {0, 0, 0xACF6} /* Korean hangul */,
  {0, 0, 0xACFA} /* Korean hangul */,
  {0, 0, 0xACFC} /* Korean hangul */,
  {0, 0, 0xACFD} /* Korean hangul */,
  {0, 0, 0xAD00} /* Korean hangul */,
  {0, 0, 0xAD04} /* Korean hangul */,
  {0, 0, 0xAD0C} /* Korean hangul */,
  {0, 0, 0xAD0D} /* Korean hangul */,
  {0, 0, 0xAD0F} /* Korean hangul */,
  {0, 0, 0xAD11} /* Korean hangul */,
  {0, 0, 0xAD18} /* Korean hangul */,
  {0, 0, 0xAD19} /* Korean hangul */,
  {0, 0, 0xAD1C} /* Korean hangul */,
  {0, 0, 0xAD20} /* Korean hangul */,
  {0, 0, 0xAD28} /* Korean hangul */,
  {0, 0, 0xAD29} /* Korean hangul */,
  {0, 0, 0xAD2D} /* Korean hangul */,
  {0, 0, 0xAD34} /* Korean hangul */,
  {0, 0, 0xAD38} /* Korean hangul */,
  {0, 0, 0xAD3C} /* Korean hangul */,
  {0, 0, 0xAD44} /* Korean hangul */,
  {0, 0, 0},
  {0, 0, 0xAD49} /* Korean hangul */,
  {0, 0, 0xAD50} /* Korean hangul */,
  {0, 0, 0xAD6C} /* Korean hangul */,
  {0, 0, 0xAD6D} /* Korean hangul */,
  {0, 0, 0xAD70} /* Korean hangul */,
  {0, 0, 0xAD73} /* Korean hangul */,
  {0, 0, 0xAD74} /* Korean hangul */,
  {0, 0, 0xAD75} /* Korean hangul */,
  {0, 0, 0xAD76} /* Korean hangul */,
  {0, 0, 0xAD7C} /* Korean hangul */,
  {0, 0, 0xAD7D} /* Korean hangul */,
  {0, 0, 0xAD7F} /* Korean hangul */,
  {0, 0, 0xAD81} /* Korean hangul */,
  {0, 0, 0xAD82} /* Korean hangul */,
  {0, 0, 0xAD88} /* Korean hangul */,
  {0, 0, 0xAD8C} /* Korean hangul */,
  {0, 0, 0xAD90} /* Korean hangul */,
  {0, 0, 0},
  {0, 0, 0xADA4} /* Korean hangul */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8_31page801 = {
  0, marc8_31page801_dir
};
/* PAGE 800 */
struct yaz_iconv_trie_flat marc8_31page800_flat[] = {
  {"\x5F", 0, 0xAC00}, /* Korean hangul */
  {"\x60", 0, 0xAC01}, /* Korean hangul */
  {"\x61", 0, 0xAC02}, /* Korean hangul */
  {"\x62", 0, 0xAC04}, /* Korean hangul */
  {"\x63", 0, 0xAC07}, /* Korean hangul */
  {"\x64", 0, 0xAC08}, /* Korean hangul */
  {"\x65", 0, 0xAC09}, /* Korean hangul */
  {"\x66", 0, 0xAC10}, /* Korean hangul */
  {"\x67", 0, 0xAC11}, /* Korean hangul */
  {"\x68", 0, 0xAC12}, /* Korean hangul */
  {"\x69", 0, 0xAC13}, /* Korean hangul */
  {"\x6A", 0, 0xAC14}, /* Korean hangul */
  {"\x6B", 0, 0xAC15}, /* Korean hangul */
  {"\x6C", 0, 0xAC16}, /* Korean hangul */
  {"\x6D", 0, 0xAC17}, /* Korean hangul */
  {"\x6E", 0, 0xAC19}, /* Korean hangul */
  {"\x6F", 0, 0xAC1A}, /* Korean hangul */
  {"\x70", 0, 0xAC1B}, /* Korean hangul */
  {"\x71", 0, 0xAC1C}, /* Korean hangul */
  {"\x72", 0, 0xAC1D}, /* Korean hangul */
  {"\x73", 0, 0xAC20}, /* Korean hangul */
  {"\x75", 0, 0xAC24}, /* Korean hangul */
  {"\x76", 0, 0xAC2C}, /* Korean hangul */
  {"\x77", 0, 0xAC2D}, /* Korean hangul */
  {"\x78", 0, 0xAC2F}, /* Korean hangul */
  {"\x79", 0, 0xAC30}, /* Korean hangul */
  {"\x7A", 0, 0xAC31}, /* Korean hangul */
  {"\x7B", 0, 0xAC38}, /* Korean hangul */
  {"\x7C", 0, 0xAC39}, /* Korean hangul */
  {"\x7D", 0, 0xAC40}, /* Korean hangul */
  {"\x7E", 0, 0xAC54}, /* Korean hangul */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page800 = {
  marc8_31page800_flat, 0
};
/* PAGE 799 */
struct yaz_iconv_trie_flat marc8_31page799_flat[] = {
  {"\x21", 0, 0x315C}, /* Korean hangul */
  {"\x25", 0, 0x3160}, /* Korean hangul */
  {"\x26", 0, 0x3161}, /* Korean hangul */
  {"\x27", 0, 0x3162}, /* Korean hangul */
  {"\x28", 0, 0x3163}, /* Korean hangul */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page799 = {
  marc8_31page799_flat, 0
};
/* PAGE 798 */
struct yaz_iconv_trie_flat marc8_31page798_flat[] = {
  {"\x57", 0, 0x3131}, /* Korean hangul */
  {"\x58", 0, 0x3134}, /* Korean hangul */
  {"\x59", 0, 0x3137}, /* Korean hangul */
  {"\x5A", 0, 0x3139}, /* Korean hangul */
  {"\x5B", 0, 0x3141}, /* Korean hangul */
  {"\x5C", 0, 0x3142}, /* Korean hangul */
  {"\x5D", 0, 0x3145}, /* Korean hangul */
  {"\x5E", 0, 0x3147}, /* Korean hangul */
  {"\x5F", 0, 0x3148}, /* Korean hangul */
  {"\x60", 0, 0x314A}, /* Korean hangul */
  {"\x61", 0, 0x314B}, /* Korean hangul */
  {"\x62", 0, 0x314C}, /* Korean hangul */
  {"\x63", 0, 0x314D}, /* Korean hangul */
  {"\x64", 0, 0x314E}, /* Korean hangul */
  {"\x65", 0, 0x3132}, /* Korean hangul */
  {"\x69", 0, 0x3138}, /* Korean hangul */
  {"\x6E", 0, 0x3143}, /* Korean hangul */
  {"\x70", 0, 0x3146}, /* Korean hangul */
  {"\x71", 0, 0x3149}, /* Korean hangul */
  {"\x72", 0, 0x314F}, /* Korean hangul */
  {"\x73", 0, 0x3150}, /* Korean hangul */
  {"\x74", 0, 0x3151}, /* Korean hangul */
  {"\x76", 0, 0x3153}, /* Korean hangul */
  {"\x77", 0, 0x3154}, /* Korean hangul */
  {"\x78", 0, 0x3155}, /* Korean hangul */
  {"\x7A", 0, 0x3157}, /* Korean hangul */
  {"\x7B", 0, 0x3158}, /* Korean hangul */
  {"\x7E", 0, 0x315B}, /* Korean hangul */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page798 = {
  marc8_31page798_flat, 0
};
/* PAGE 797 */
struct yaz_iconv_trie_dir marc8_31page797_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {799, 0, 0},
  {800, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {801, 0, 0},
  {802, 0, 0},
  {803, 0, 0},
  {804, 0, 0},
  {805, 0, 0},
  {806, 0, 0},
  {807, 0, 0},
  {808, 0, 0},
  {809, 0, 0},
  {810, 0, 0},
  {811, 0, 0},
  {812, 0, 0},
  {813, 0, 0},
  {814, 0, 0},
  {815, 0, 0},
  {816, 0, 0},
  {817, 0, 0},
  {818, 0, 0},
  {819, 0, 0},
  {820, 0, 0},
  {821, 0, 0},
  {822, 0, 0},
  {823, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {824, 0, 0},
  {825, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8_31page797 = {
  0, marc8_31page797_dir
};
/* PAGE 796 */
struct yaz_iconv_trie_dir marc8_31page796_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x30A1} /* Katakana letter small A */,
  {0, 0, 0x30A2} /* Katakana letter A */,
  {0, 0, 0x30A3} /* Katakana letter small I */,
  {0, 0, 0x30A4} /* Katakana letter I */,
  {0, 0, 0x30A5} /* Katakana letter small U */,
  {0, 0, 0x30A6} /* Katakana letter U */,
  {0, 0, 0x30A7} /* Katakana letter small E */,
  {0, 0, 0x30A8} /* Katakana letter E */,
  {0, 0, 0x30A9} /* Katakana letter small O */,
  {0, 0, 0x30AA} /* Katakana letter O */,
  {0, 0, 0x30AB} /* Katakana letter KA */,
  {0, 0, 0x30AC} /* Katakana letter GA */,
  {0, 0, 0x30AD} /* Katakana letter KI */,
  {0, 0, 0x30AE} /* Katakana letter GI */,
  {0, 0, 0x30AF} /* Katakana letter KU */,
  {0, 0, 0x30B0} /* Katakana letter GU */,
  {0, 0, 0x30B1} /* Katakana letter KE */,
  {0, 0, 0x30B2} /* Katakana letter GE */,
  {0, 0, 0x30B3} /* Katakana letter KO */,
  {0, 0, 0x30B4} /* Katakana letter GO */,
  {0, 0, 0x30B5} /* Katakana letter SA */,
  {0, 0, 0x30B6} /* Katakana letter ZA */,
  {0, 0, 0x30B7} /* Katakana letter SI */,
  {0, 0, 0x30B8} /* Katakana letter ZI */,
  {0, 0, 0x30B9} /* Katakana letter SU */,
  {0, 0, 0x30BA} /* Katakana letter ZU */,
  {0, 0, 0x30BB} /* Katakana letter SE */,
  {0, 0, 0x30BC} /* Katakana letter ZE */,
  {0, 0, 0x30BD} /* Katakana letter SO */,
  {0, 0, 0x30BE} /* Katakana letter ZO */,
  {0, 0, 0x30BF} /* Katakana letter TA */,
  {0, 0, 0x30C0} /* Katakana letter DA */,
  {0, 0, 0x30C1} /* Katakana letter TI */,
  {0, 0, 0x30C2} /* Katakana letter DI */,
  {0, 0, 0x30C3} /* Katakana letter small TU */,
  {0, 0, 0x30C4} /* Katakana letter TU */,
  {0, 0, 0x30C5} /* Katakana letter DU */,
  {0, 0, 0x30C6} /* Katakana letter TE */,
  {0, 0, 0x30C7} /* Katakana letter DE */,
  {0, 0, 0x30C8} /* Katakana letter TO */,
  {0, 0, 0x30C9} /* Katakana letter DO */,
  {0, 0, 0x30CA} /* Katakana letter NA */,
  {0, 0, 0x30CB} /* Katakana letter NI */,
  {0, 0, 0x30CC} /* Katakana letter NU */,
  {0, 0, 0x30CD} /* Katakana letter NE */,
  {0, 0, 0x30CE} /* Katakana letter NO */,
  {0, 0, 0x30CF} /* Katakana letter HA */,
  {0, 0, 0x30D0} /* Katakana letter BA */,
  {0, 0, 0x30D1} /* Katakana letter PA */,
  {0, 0, 0x30D2} /* Katakana letter HI */,
  {0, 0, 0x30D3} /* Katakana letter BI */,
  {0, 0, 0x30D4} /* Katakana letter PI */,
  {0, 0, 0x30D5} /* Katakana letter HU */,
  {0, 0, 0x30D6} /* Katakana letter BU */,
  {0, 0, 0x30D7} /* Katakana letter PU */,
  {0, 0, 0x30D8} /* Katakana letter HE */,
  {0, 0, 0x30D9} /* Katakana letter BE */,
  {0, 0, 0x30DA} /* Katakana letter PE */,
  {0, 0, 0x30DB} /* Katakana letter HO */,
  {0, 0, 0x30DC} /* Katakana letter BO */,
  {0, 0, 0x30DD} /* Katakana letter PO */,
  {0, 0, 0x30DE} /* Katakana letter MA */,
  {0, 0, 0x30DF} /* Katakana letter MI */,
  {0, 0, 0x30E0} /* Katakana letter MU */,
  {0, 0, 0x30E1} /* Katakana letter ME */,
  {0, 0, 0x30E2} /* Katakana letter MO */,
  {0, 0, 0x30E3} /* Katakana letter small YA */,
  {0, 0, 0x30E4} /* Katakana letter YA */,
  {0, 0, 0x30E5} /* Katakana letter small YU */,
  {0, 0, 0x30E6} /* Katakana letter YU */,
  {0, 0, 0x30E7} /* Katakana letter small YO */,
  {0, 0, 0x30E8} /* Katakana letter YO */,
  {0, 0, 0x30E9} /* Katakana letter RA */,
  {0, 0, 0x30EA} /* Katakana letter RI */,
  {0, 0, 0x30EB} /* Katakana letter RU */,
  {0, 0, 0x30EC} /* Katakana letter RE */,
  {0, 0, 0x30ED} /* Katakana letter RO */,
  {0, 0, 0x30EE} /* Katakana letter small WA */,
  {0, 0, 0x30EF} /* Katakana letter WA */,
  {0, 0, 0x30F0} /* Katakana letter WI */,
  {0, 0, 0x30F1} /* Katakana letter WE */,
  {0, 0, 0x30F2} /* Katakana letter WO */,
  {0, 0, 0x30F3} /* Katakana letter N */,
  {0, 0, 0x30F4} /* Katakana letter VU */,
  {0, 0, 0x30F5} /* Katakana letter small KA */,
  {0, 0, 0x30F6} /* Katakana letter small KE */,
  {0, 0, 0x309B} /* Katakana-hiragana voiced sound mark */,
  {0, 0, 0x309C} /* Katakana-hiragana semi-voiced sound mark */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8_31page796 = {
  0, marc8_31page796_dir
};
/* PAGE 795 */
struct yaz_iconv_trie_dir marc8_31page795_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x3041} /* Hiragana letter small A */,
  {0, 0, 0x3042} /* Hiragana letter A */,
  {0, 0, 0x3043} /* Hiragana letter small I */,
  {0, 0, 0x3044} /* Hiragana letter I */,
  {0, 0, 0x3045} /* Hiragana letter small U */,
  {0, 0, 0x3046} /* Hiragana letter U */,
  {0, 0, 0x3047} /* Hiragana letter small E */,
  {0, 0, 0x3048} /* Hiragana letter E */,
  {0, 0, 0x3049} /* Hiragana letter small O */,
  {0, 0, 0x304A} /* Hiragana letter O */,
  {0, 0, 0x304B} /* Hiragana letter KA */,
  {0, 0, 0x304C} /* Hiragana letter GA */,
  {0, 0, 0x304D} /* Hiragana letter KI */,
  {0, 0, 0x304E} /* Hiragana letter GI */,
  {0, 0, 0x304F} /* Hiragana letter KU */,
  {0, 0, 0x3050} /* Hiragana letter GU */,
  {0, 0, 0x3051} /* Hiragana letter KE */,
  {0, 0, 0x3052} /* Hiragana letter GE */,
  {0, 0, 0x3053} /* Hiragana letter KO */,
  {0, 0, 0x3054} /* Hiragana letter GO */,
  {0, 0, 0x3055} /* Hiragana letter SA */,
  {0, 0, 0x3056} /* Hiragana letter ZA */,
  {0, 0, 0x3057} /* Hiragana letter SI */,
  {0, 0, 0x3058} /* Hiragana letter ZI */,
  {0, 0, 0x3059} /* Hiragana letter SU */,
  {0, 0, 0x305A} /* Hiragana letter ZU */,
  {0, 0, 0x305B} /* Hiragana letter SE */,
  {0, 0, 0x305C} /* Hiragana letter ZE */,
  {0, 0, 0x305D} /* Hiragana letter SO */,
  {0, 0, 0x305E} /* Hiragana letter ZO */,
  {0, 0, 0x305F} /* Hiragana letter TA */,
  {0, 0, 0x3060} /* Hiragana letter DA */,
  {0, 0, 0x3061} /* Hiragana letter TI */,
  {0, 0, 0x3062} /* Hiragana letter DI */,
  {0, 0, 0x3063} /* Hiragana letter small TU */,
  {0, 0, 0x3064} /* Hiragana letter TU */,
  {0, 0, 0x3065} /* Hiragana letter DU */,
  {0, 0, 0x3066} /* Hiragana letter TE */,
  {0, 0, 0x3067} /* Hiragana letter DE */,
  {0, 0, 0x3068} /* Hiragana letter TO */,
  {0, 0, 0x3069} /* Hiragana letter DO */,
  {0, 0, 0x306A} /* Hiragana letter NA */,
  {0, 0, 0x306B} /* Hiragana letter NI */,
  {0, 0, 0x306C} /* Hiragana letter NU */,
  {0, 0, 0x306D} /* Hiragana letter NE */,
  {0, 0, 0x306E} /* Hiragana letter NO */,
  {0, 0, 0x306F} /* Hiragana letter HA */,
  {0, 0, 0x3070} /* Hiragana letter BA */,
  {0, 0, 0x3071} /* Hiragana letter PA */,
  {0, 0, 0x3072} /* Hiragana letter HI */,
  {0, 0, 0x3073} /* Hiragana letter BI */,
  {0, 0, 0x3074} /* Hiragana letter PI */,
  {0, 0, 0x3075} /* Hiragana letter HU */,
  {0, 0, 0x3076} /* Hiragana letter BU */,
  {0, 0, 0x3077} /* Hiragana letter PU */,
  {0, 0, 0x3078} /* Hiragana letter HE */,
  {0, 0, 0x3079} /* Hiragana letter BE */,
  {0, 0, 0x307A} /* Hiragana letter PE */,
  {0, 0, 0x307B} /* Hiragana letter HO */,
  {0, 0, 0x307C} /* Hiragana letter BO */,
  {0, 0, 0x307D} /* Hiragana letter PO */,
  {0, 0, 0x307E} /* Hiragana letter MA */,
  {0, 0, 0x307F} /* Hiragana letter MI */,
  {0, 0, 0x3080} /* Hiragana letter MU */,
  {0, 0, 0x3081} /* Hiragana letter ME */,
  {0, 0, 0x3082} /* Hiragana letter MO */,
  {0, 0, 0x3083} /* Hiragana letter small YA */,
  {0, 0, 0x3084} /* Hiragana letter YA */,
  {0, 0, 0x3085} /* Hiragana letter small YU */,
  {0, 0, 0x3086} /* Hiragana letter YU */,
  {0, 0, 0x3087} /* Hiragana letter small YO */,
  {0, 0, 0x3088} /* Hiragana letter YO */,
  {0, 0, 0x3089} /* Hiragana letter RA */,
  {0, 0, 0x308A} /* Hiragana letter RI */,
  {0, 0, 0x308B} /* Hiragana letter RU */,
  {0, 0, 0x308C} /* Hiragana letter RE */,
  {0, 0, 0x308D} /* Hiragana letter RO */,
  {0, 0, 0x308E} /* Hiragana letter small WA */,
  {0, 0, 0x308F} /* Hiragana letter WA */,
  {0, 0, 0x3090} /* Hiragana letter WI */,
  {0, 0, 0x3091} /* Hiragana letter WE */,
  {0, 0, 0x3092} /* Hiragana letter WO */,
  {0, 0, 0x3093} /* Hiragana letter N */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8_31page795 = {
  0, marc8_31page795_dir
};
/* PAGE 794 */
struct yaz_iconv_trie_flat marc8_31page794_flat[] = {
  {"\x3C", 0, 0x30FC}, /* Vowel elongation mark for kana */
  {"\x26", 0, 0x30FB}, /* Ideographic centered point */
  {"\x39", 0, 0x3005}, /* Ideographic iteration mark */
  {"\x52", 0, 0x3008}, /* Ideographic less than sign */
  {"\x53", 0, 0x3009}, /* Ideographic greater than sign */
  {"\x54", 0, 0x300A}, /* Ideographic left double angle bracket */
  {"\x55", 0, 0x300B}, /* Ideographic right double angle bracket */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page794 = {
  marc8_31page794_flat, 0
};
/* PAGE 793 */
struct yaz_iconv_trie_flat marc8_31page793_flat[] = {
  {"\x4C\x2A", 0, 0x915E}, /* East Asian ideograph */
  {"\x58\x6F", 0, 0x4EEB}, /* East Asian ideograph */
  {"\x5B\x71", 0, 0x57B4}, /* East Asian ideograph */
  {"\x5C\x43", 0, 0x82CA}, /* East Asian ideograph */
  {"\x5C\x50", 0, 0x82C4}, /* East Asian ideograph */
  {"\x5D\x46", 0, 0x841C}, /* East Asian ideograph */
  {"\x5D\x5C", 0, 0x8488}, /* East Asian ideograph */
  {"\x5F\x30", 0, 0x7519}, /* East Asian ideograph */
  {"\x5F\x39", 0, 0x5416}, /* East Asian ideograph */
  {"\x5F\x50", 0, 0x549D}, /* East Asian ideograph */
  {"\x5F\x51", 0, 0x54D0}, /* East Asian ideograph */
  {"\x5F\x54", 0, 0x54B4}, /* East Asian ideograph */
  {"\x5F\x5B", 0, 0x54A3}, /* East Asian ideograph */
  {"\x5F\x61", 0, 0x54DA}, /* East Asian ideograph */
  {"\x60\x2D", 0, 0x55B9}, /* East Asian ideograph */
  {"\x60\x3A", 0, 0x55EA}, /* East Asian ideograph */
  {"\x60\x4C", 0, 0x55F5}, /* East Asian ideograph */
  {"\x60\x54", 0, 0x5623}, /* East Asian ideograph */
  {"\x60\x58", 0, 0x562D}, /* East Asian ideograph */
  {"\x60\x67", 0, 0x567B}, /* East Asian ideograph */
  {"\x61\x31", 0, 0x5C9C}, /* East Asian ideograph */
  {"\x62\x2A", 0, 0x7339}, /* East Asian ideograph */
  {"\x62\x47", 0, 0x9987}, /* East Asian ideograph */
  {"\x62\x4E", 0, 0x9995}, /* East Asian ideograph */
  {"\x63\x40", 0, 0x61B7}, /* East Asian ideograph */
  {"\x66\x40", 0, 0x80EC}, /* East Asian ideograph */
  {"\x6B\x42", 0, 0x80BC}, /* East Asian ideograph */
  {"\x6B\x44", 0, 0x80BD}, /* East Asian ideograph */
  {"\x6B\x4C", 0, 0x80E9}, /* East Asian ideograph */
  {"\x6B\x5B", 0, 0x810E}, /* East Asian ideograph */
  {"\x6B\x5F", 0, 0x8112}, /* East Asian ideograph */
  {"\x6B\x6A", 0, 0x8159}, /* East Asian ideograph */
  {"\x6C\x42", 0, 0x70BB}, /* East Asian ideograph */
  {"\x6C\x43", 0, 0x70C0}, /* East Asian ideograph */
  {"\x6D\x3B", 0, 0x7818}, /* East Asian ideograph */
  {"\x6D\x3F", 0, 0x781C}, /* East Asian ideograph */
  {"\x6D\x45", 0, 0x783C}, /* East Asian ideograph */
  {"\x72\x7D", 0, 0x87A8}, /* East Asian ideograph */
  {"\x73\x60", 0, 0x7B7B}, /* East Asian ideograph */
  {"\x73\x6E", 0, 0x7BA2}, /* East Asian ideograph */
  {"\x74\x38", 0, 0x823E}, /* East Asian ideograph */
  {"\x75\x23", 0, 0x9170}, /* East Asian ideograph */
  {"\x75\x5D", 0, 0x8E3A}, /* East Asian ideograph */
  {"\x77\x5D", 0, 0x9B0F}, /* East Asian ideograph */
  {"\x77\x71", 0, 0x9EE2}, /* East Asian ideograph (Version J extension) */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page793 = {
  marc8_31page793_flat, 0
};
/* PAGE 792 */
struct yaz_iconv_trie_flat marc8_31page792_flat[] = {
  {"\x23", 0, 0x9D64}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page792 = {
  marc8_31page792_flat, 0
};
/* PAGE 791 */
struct yaz_iconv_trie_flat marc8_31page791_flat[] = {
  {"\x3B", 0, 0x9B96}, /* East Asian ideograph */
  {"\x40", 0, 0x9BB4}, /* East Asian ideograph */
  {"\x45", 0, 0x9BCF}, /* East Asian ideograph */
  {"\x46", 0, 0x9BD1}, /* East Asian ideograph */
  {"\x4E", 0, 0x9BF2}, /* East Asian ideograph */
  {"\x60", 0, 0x9C30}, /* East Asian ideograph */
  {"\x65", 0, 0x9C5A}, /* East Asian ideograph */
  {"\x7E", 0, 0x9D48}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page791 = {
  marc8_31page791_flat, 0
};
/* PAGE 790 */
struct yaz_iconv_trie_flat marc8_31page790_flat[] = {
  {"\x24", 0, 0x98AA}, /* East Asian ideograph */
  {"\x52", 0, 0x99F2}, /* East Asian ideograph */
  {"\x74", 0, 0x9ADE}, /* East Asian ideograph */
  {"\x7D", 0, 0x9AF1}, /* East Asian ideograph */
  {"\x7E", 0, 0x9AF7}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page790 = {
  marc8_31page790_flat, 0
};
/* PAGE 789 */
struct yaz_iconv_trie_flat marc8_31page789_flat[] = {
  {"\x23", 0, 0x9666}, /* East Asian ideograph */
  {"\x58", 0, 0x9779}, /* East Asian ideograph */
  {"\x5D", 0, 0x9786}, /* East Asian ideograph */
  {"\x60", 0, 0x9790}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page789 = {
  marc8_31page789_flat, 0
};
/* PAGE 788 */
struct yaz_iconv_trie_flat marc8_31page788_flat[] = {
  {"\x27", 0, 0x933B}, /* East Asian ideograph */
  {"\x5B", 0, 0x958A}, /* East Asian ideograph */
  {"\x5D", 0, 0x9596}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page788 = {
  marc8_31page788_flat, 0
};
/* PAGE 787 */
struct yaz_iconv_trie_flat marc8_31page787_flat[] = {
  {"\x28", 0, 0x9056}, /* East Asian ideograph */
  {"\x5C", 0, 0x91DF}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page787 = {
  marc8_31page787_flat, 0
};
/* PAGE 786 */
struct yaz_iconv_trie_flat marc8_31page786_flat[] = {
  {"\x3F", 0, 0x8EBE}, /* East Asian ideograph */
  {"\x40", 0, 0x8EC5}, /* East Asian ideograph */
  {"\x41", 0, 0x8EC8}, /* East Asian ideograph */
  {"\x5A", 0, 0x8F4C}, /* East Asian ideograph */
  {"\x7A", 0, 0x9027}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page786 = {
  marc8_31page786_flat, 0
};
/* PAGE 785 */
struct yaz_iconv_trie_flat marc8_31page785_flat[] = {
  {"\x27", 0, 0x8977}, /* East Asian ideograph */
  {"\x5C", 0, 0x8ADA}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page785 = {
  marc8_31page785_flat, 0
};
/* PAGE 784 */
struct yaz_iconv_trie_flat marc8_31page784_flat[] = {
  {"\x2C", 0, 0x87D0}, /* East Asian ideograph */
  {"\x5E", 0, 0x88B0}, /* East Asian ideograph */
  {"\x61", 0, 0x88C3}, /* East Asian ideograph */
  {"\x6D", 0, 0x8904}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page784 = {
  marc8_31page784_flat, 0
};
/* PAGE 783 */
struct yaz_iconv_trie_flat marc8_31page783_flat[] = {
  {"\x46", 0, 0x8630}, /* East Asian ideograph */
  {"\x5B", 0, 0x86AB}, /* East Asian ideograph */
  {"\x62", 0, 0x86EF}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page783 = {
  marc8_31page783_flat, 0
};
/* PAGE 782 */
struct yaz_iconv_trie_flat marc8_31page782_flat[] = {
  {"\x4D", 0, 0x8422}, /* East Asian ideograph */
  {"\x68", 0, 0x84D9}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page782 = {
  marc8_31page782_flat, 0
};
/* PAGE 781 */
struct yaz_iconv_trie_flat marc8_31page781_flat[] = {
  {"\x33", 0, 0x81A4}, /* East Asian ideograph */
  {"\x5C", 0, 0x825D}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page781 = {
  marc8_31page781_flat, 0
};
/* PAGE 780 */
struct yaz_iconv_trie_flat marc8_31page780_flat[] = {
  {"\x4F", 0, 0x7E05}, /* East Asian ideograph */
  {"\x6D", 0, 0x7E83}, /* East Asian ideograph */
  {"\x6E", 0, 0x7DD5}, /* East Asian ideograph */
  {"\x76", 0, 0x7E90}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page780 = {
  marc8_31page780_flat, 0
};
/* PAGE 779 */
struct yaz_iconv_trie_flat marc8_31page779_flat[] = {
  {"\x49", 0, 0x7C13}, /* East Asian ideograph */
  {"\x4C", 0, 0x7C17}, /* East Asian ideograph */
  {"\x4E", 0, 0x7BF6}, /* East Asian ideograph */
  {"\x64", 0, 0x7C90}, /* East Asian ideograph */
  {"\x66", 0, 0x7CAD}, /* East Asian ideograph */
  {"\x71", 0, 0x7CC0}, /* East Asian ideograph */
  {"\x74", 0, 0x7CD8}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page779 = {
  marc8_31page779_flat, 0
};
/* PAGE 778 */
struct yaz_iconv_trie_flat marc8_31page778_flat[] = {
  {"\x25", 0, 0x7907}, /* East Asian ideograph */
  {"\x4E", 0, 0x7A43}, /* East Asian ideograph */
  {"\x73", 0, 0x7B02}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page778 = {
  marc8_31page778_flat, 0
};
/* PAGE 777 */
struct yaz_iconv_trie_flat marc8_31page777_flat[] = {
  {"\x6D", 0, 0x7874}, /* East Asian ideograph */
  {"\x73", 0, 0x78B5}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page777 = {
  marc8_31page777_flat, 0
};
/* PAGE 776 */
struct yaz_iconv_trie_flat marc8_31page776_flat[] = {
  {"\x26", 0, 0x74F2}, /* East Asian ideograph */
  {"\x36", 0, 0x753C}, /* East Asian ideograph */
  {"\x3A", 0, 0x7549}, /* East Asian ideograph */
  {"\x3E", 0, 0x7569}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page776 = {
  marc8_31page776_flat, 0
};
/* PAGE 775 */
struct yaz_iconv_trie_flat marc8_31page775_flat[] = {
  {"\x70", 0, 0x7195}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page775 = {
  marc8_31page775_flat, 0
};
/* PAGE 774 */
struct yaz_iconv_trie_flat marc8_31page774_flat[] = {
  {"\x63", 0, 0x6E82}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page774 = {
  marc8_31page774_flat, 0
};
/* PAGE 773 */
struct yaz_iconv_trie_flat marc8_31page773_flat[] = {
  {"\x36", 0, 0x6B1F}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page773 = {
  marc8_31page773_flat, 0
};
/* PAGE 772 */
struct yaz_iconv_trie_flat marc8_31page772_flat[] = {
  {"\x29", 0, 0x6925}, /* East Asian ideograph */
  {"\x2D", 0, 0x6928}, /* East Asian ideograph */
  {"\x30", 0, 0x6923}, /* East Asian ideograph */
  {"\x31", 0, 0x6921}, /* East Asian ideograph */
  {"\x39", 0, 0x697E}, /* East Asian ideograph */
  {"\x43", 0, 0x6981}, /* East Asian ideograph */
  {"\x4F", 0, 0x69DD}, /* East Asian ideograph */
  {"\x53", 0, 0x6A2E}, /* East Asian ideograph */
  {"\x71", 0, 0x6A78}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page772 = {
  marc8_31page772_flat, 0
};
/* PAGE 771 */
struct yaz_iconv_trie_flat marc8_31page771_flat[] = {
  {"\x37", 0, 0x6737}, /* East Asian ideograph */
  {"\x7B", 0, 0x6926}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page771 = {
  marc8_31page771_flat, 0
};
/* PAGE 770 */
struct yaz_iconv_trie_flat marc8_31page770_flat[] = {
  {"\x31", 0, 0x64F6}, /* East Asian ideograph */
  {"\x73", 0, 0x6683}, /* East Asian ideograph */
  {"\x7E", 0, 0x66BC}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page770 = {
  marc8_31page770_flat, 0
};
/* PAGE 769 */
struct yaz_iconv_trie_flat marc8_31page769_flat[] = {
  {"\x4B", 0, 0x6327}, /* East Asian ideograph */
  {"\x5E", 0, 0x63B5}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page769 = {
  marc8_31page769_flat, 0
};
/* PAGE 768 */
struct yaz_iconv_trie_flat marc8_31page768_flat[] = {
  {"\x37", 0, 0x5F16}, /* East Asian ideograph */
  {"\x3B", 0, 0x5F41}, /* East Asian ideograph */
  {"\x6A", 0, 0x603A}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page768 = {
  marc8_31page768_flat, 0
};
/* PAGE 767 */
struct yaz_iconv_trie_flat marc8_31page767_flat[] = {
  {"\x26", 0, 0x4E62}, /* East Asian ideograph */
  {"\x2C", 0, 0x599B}, /* East Asian ideograph */
  {"\x2E", 0, 0x5CBB}, /* East Asian ideograph */
  {"\x30", 0, 0x5CBC}, /* East Asian ideograph */
  {"\x32", 0, 0x5CC5}, /* East Asian ideograph */
  {"\x33", 0, 0x5CBE}, /* East Asian ideograph */
  {"\x4E", 0, 0x5D76}, /* East Asian ideograph */
  {"\x57", 0, 0x5D90}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page767 = {
  marc8_31page767_flat, 0
};
/* PAGE 766 */
struct yaz_iconv_trie_flat marc8_31page766_flat[] = {
  {"\x4E", 0, 0x5B36}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page766 = {
  marc8_31page766_flat, 0
};
/* PAGE 765 */
struct yaz_iconv_trie_flat marc8_31page765_flat[] = {
  {"\x29", 0, 0x5726}, /* East Asian ideograph */
  {"\x2A", 0, 0x5737}, /* East Asian ideograph */
  {"\x38", 0, 0x57B3}, /* East Asian ideograph */
  {"\x3A", 0, 0x57AA}, /* East Asian ideograph */
  {"\x3B", 0, 0x57B0}, /* East Asian ideograph */
  {"\x42", 0, 0x57D6}, /* East Asian ideograph */
  {"\x4B", 0, 0x5870}, /* East Asian ideograph */
  {"\x51", 0, 0x58B9}, /* East Asian ideograph */
  {"\x57", 0, 0x58B8}, /* East Asian ideograph */
  {"\x5C", 0, 0x58D7}, /* East Asian ideograph */
  {"\x5F", 0, 0x58E5}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page765 = {
  marc8_31page765_flat, 0
};
/* PAGE 764 */
struct yaz_iconv_trie_flat marc8_31page764_flat[] = {
  {"\x26", 0, 0x54D8}, /* East Asian ideograph */
  {"\x3B", 0, 0x555D}, /* East Asian ideograph */
  {"\x75", 0, 0x56CE}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page764 = {
  marc8_31page764_flat, 0
};
/* PAGE 763 */
struct yaz_iconv_trie_flat marc8_31page763_flat[] = {
  {"\x5D", 0, 0x53FA}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page763 = {
  marc8_31page763_flat, 0
};
/* PAGE 762 */
struct yaz_iconv_trie_flat marc8_31page762_flat[] = {
  {"\x30", 0, 0x5116}, /* East Asian ideograph */
  {"\x5E", 0, 0x51E9}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page762 = {
  marc8_31page762_flat, 0
};
/* PAGE 761 */
struct yaz_iconv_trie_flat marc8_31page761_flat[] = {
  {"\x5D", 0, 0x6762}, /* East Asian ideograph */
  {"\x68", 0, 0x5301}, /* East Asian ideograph */
  {"\x7A", 0, 0x9453}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page761 = {
  marc8_31page761_flat, 0
};
/* PAGE 760 */
struct yaz_iconv_trie_flat marc8_31page760_flat[] = {
  {"\x7B", 0, 0x9EBF}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page760 = {
  marc8_31page760_flat, 0
};
/* PAGE 759 */
struct yaz_iconv_trie_flat marc8_31page759_flat[] = {
  {"\x23", 0, 0x7872}, /* East Asian ideograph */
  {"\x2B", 0, 0x7560}, /* East Asian ideograph */
  {"\x38", 0, 0x567A}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page759 = {
  marc8_31page759_flat, 0
};
/* PAGE 758 */
struct yaz_iconv_trie_flat marc8_31page758_flat[] = {
  {"\x64", 0, 0x51EA}, /* East Asian ideograph */
  {"\x77", 0, 0x5302}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page758 = {
  marc8_31page758_flat, 0
};
/* PAGE 757 */
struct yaz_iconv_trie_flat marc8_31page757_flat[] = {
  {"\x32", 0, 0x9D2B}, /* East Asian ideograph */
  {"\x36", 0, 0x96EB}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page757 = {
  marc8_31page757_flat, 0
};
/* PAGE 756 */
struct yaz_iconv_trie_flat marc8_31page756_flat[] = {
  {"\x29", 0, 0x7C82}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page756 = {
  marc8_31page756_flat, 0
};
/* PAGE 755 */
struct yaz_iconv_trie_dir marc8_31page755_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {795, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {796, 0, 0},
  {797, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {757, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {758, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {759, 0, 0},
  {0, 0, 0},
  {760, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {761, 0, 0},
  {762, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {763, 0, 0},
  {764, 0, 0},
  {765, 0, 0},
  {766, 0, 0},
  {767, 0, 0},
  {768, 0, 0},
  {769, 0, 0},
  {0, 0, 0},
  {770, 0, 0},
  {771, 0, 0},
  {772, 0, 0},
  {773, 0, 0},
  {774, 0, 0},
  {775, 0, 0},
  {776, 0, 0},
  {0, 0, 0},
  {777, 0, 0},
  {778, 0, 0},
  {779, 0, 0},
  {780, 0, 0},
  {781, 0, 0},
  {0, 0, 0},
  {782, 0, 0},
  {783, 0, 0},
  {784, 0, 0},
  {785, 0, 0},
  {786, 0, 0},
  {0, 0, 0},
  {787, 0, 0},
  {788, 0, 0},
  {789, 0, 0},
  {790, 0, 0},
  {791, 0, 0},
  {792, 0, 0},
  {793, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8_31page755 = {
  0, marc8_31page755_dir
};
/* PAGE 754 */
struct yaz_iconv_trie_flat marc8_31page754_flat[] = {
  {"\x73\x5D", 0, 0x7E8A}, /* East Asian ideograph (variant of EACC 22735D) */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page754 = {
  marc8_31page754_flat, 0
};
/* PAGE 753 */
struct yaz_iconv_trie_flat marc8_31page753_flat[] = {
  {"\x30\x51", 0, 0x8CAE}, /* East Asian ideograph */
  {"\x30\x57", 0, 0x4E98}, /* East Asian ideograph */
  {"\x34\x21", 0, 0x91D6}, /* East Asian ideograph */
  {"\x35\x6A", 0, 0x8BC3}, /* East Asian ideograph */
  {"\x38\x4D", 0, 0x51C3}, /* East Asian ideograph */
  {"\x3A\x47", 0, 0x8885}, /* East Asian ideograph */
  {"\x3B\x52", 0, 0x6C3D}, /* East Asian ideograph */
  {"\x3D\x67", 0, 0x8FF3}, /* East Asian ideograph */
  {"\x45\x6D", 0, 0x822E}, /* East Asian ideograph */
  {"\x49\x6B", 0, 0x852B}, /* East Asian ideograph */
  {"\x4E\x5B", 0, 0x9271}, /* East Asian ideograph */
  {"\x51\x3B", 0, 0x7E9F}, /* East Asian ideograph */
  {"\x56\x3F", 0, 0x8616}, /* East Asian ideograph */
  {"\x5E\x5D", 0, 0x9616}, /* East Asian ideograph */
  {"\x61\x22", 0, 0x9988}, /* East Asian ideograph */
  {"\x6A\x26", 0, 0x51B4}, /* East Asian ideograph */
  {"\x79\x54", 0, 0x734E}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page753 = {
  marc8_31page753_flat, 0
};
/* PAGE 752 */
struct yaz_iconv_trie_flat marc8_31page752_flat[] = {
  {"\x22\x2A", 0, 0x83B5}, /* East Asian ideograph */
  {"\x29\x25", 0, 0x8770}, /* East Asian ideograph */
  {"\x29\x62", 0, 0x86C9}, /* East Asian ideograph (variant of EACC 232962) */
  {"\x2C\x3C", 0, 0x87E5}, /* East Asian ideograph */
  {"\x2D\x75", 0, 0x8872}, /* East Asian ideograph (variant of EACC 232D75) */
  {"\x2F\x5D", 0, 0x8941}, /* East Asian ideograph (variant of EACC 232F5D) */
  {"\x2F\x73", 0, 0x7E5D}, /* East Asian ideograph */
  {"\x2F\x7A", 0, 0x891D}, /* East Asian ideograph */
  {"\x30\x32", 0, 0x88AE}, /* East Asian ideograph */
  {"\x33\x59", 0, 0x56AF}, /* East Asian ideograph */
  {"\x33\x63", 0, 0x8C25}, /* East Asian ideograph */
  {"\x38\x6F", 0, 0x544B}, /* East Asian ideograph */
  {"\x3C\x6C", 0, 0x8FB6}, /* East Asian ideograph */
  {"\x41\x34", 0, 0x919B}, /* East Asian ideograph */
  {"\x41\x76", 0, 0x91DB}, /* East Asian ideograph */
  {"\x44\x5B", 0, 0x9306}, /* East Asian ideograph (variant of EACC 23445B) */
  {"\x44\x6B", 0, 0x954E}, /* East Asian ideograph */
  {"\x47\x2C", 0, 0x952A}, /* East Asian ideograph */
  {"\x47\x54", 0, 0x9544}, /* East Asian ideograph */
  {"\x47\x7B", 0, 0x943E}, /* East Asian ideograph */
  {"\x48\x32", 0, 0x953F}, /* East Asian ideograph */
  {"\x48\x35", 0, 0x954C}, /* East Asian ideograph */
  {"\x48\x62", 0, 0x9229}, /* East Asian ideograph */
  {"\x4A\x6C", 0, 0x9667}, /* East Asian ideograph */
  {"\x4D\x61", 0, 0x7EF1}, /* East Asian ideograph */
  {"\x4F\x39", 0, 0x988C}, /* East Asian ideograph */
  {"\x50\x3A", 0, 0x98D1}, /* East Asian ideograph */
  {"\x50\x53", 0, 0x98DA}, /* East Asian ideograph */
  {"\x51\x54", 0, 0x9942}, /* East Asian ideograph */
  {"\x55\x74", 0, 0x9B2E}, /* East Asian ideograph */
  {"\x58\x58", 0, 0x9BE3}, /* East Asian ideograph */
  {"\x58\x75", 0, 0x9CD0}, /* East Asian ideograph */
  {"\x59\x34", 0, 0x9CA6}, /* East Asian ideograph */
  {"\x59\x4E", 0, 0x9BF5}, /* East Asian ideograph */
  {"\x59\x73", 0, 0x51EB}, /* East Asian ideograph */
  {"\x5A\x6C", 0, 0x9D46}, /* East Asian ideograph */
  {"\x5B\x35", 0, 0x9DAB}, /* East Asian ideograph */
  {"\x5B\x7E", 0, 0x9DC6}, /* East Asian ideograph */
  {"\x5C\x6B", 0, 0x9D50}, /* East Asian ideograph */
  {"\x5D\x49", 0, 0x9E81}, /* East Asian ideograph */
  {"\x5F\x70", 0, 0x9F44}, /* East Asian ideograph */
  {"\x5F\x7B", 0, 0x97F2}, /* East Asian ideograph */
  {"\x60\x47", 0, 0x816D}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page752 = {
  marc8_31page752_flat, 0
};
/* PAGE 751 */
struct yaz_iconv_trie_flat marc8_31page751_flat[] = {
  {"\x4D", 0, 0x8343}, /* East Asian ideograph */
  {"\x6A", 0, 0x8323}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page751 = {
  marc8_31page751_flat, 0
};
/* PAGE 750 */
struct yaz_iconv_trie_flat marc8_31page750_flat[] = {
  {"\x45", 0, 0x82AE}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page750 = {
  marc8_31page750_flat, 0
};
/* PAGE 749 */
struct yaz_iconv_trie_flat marc8_31page749_flat[] = {
  {"\x4E", 0, 0x80B7}, /* East Asian ideograph */
  {"\x59", 0, 0x817D}, /* East Asian ideograph */
  {"\x6B", 0, 0x815F}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page749 = {
  marc8_31page749_flat, 0
};
/* PAGE 748 */
struct yaz_iconv_trie_flat marc8_31page748_flat[] = {
  {"\x28", 0, 0x5FAD}, /* East Asian ideograph (variant of EACC 2E7328) */
  {"\x5D", 0, 0x7D4B}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page748 = {
  marc8_31page748_flat, 0
};
/* PAGE 747 */
struct yaz_iconv_trie_flat marc8_31page747_flat[] = {
  {"\x5D", 0, 0x7A39}, /* East Asian ideograph */
  {"\x65", 0, 0x7DFC}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page747 = {
  marc8_31page747_flat, 0
};
/* PAGE 746 */
struct yaz_iconv_trie_flat marc8_31page746_flat[] = {
  {"\x5A", 0, 0x7EE6}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page746 = {
  marc8_31page746_flat, 0
};
/* PAGE 745 */
struct yaz_iconv_trie_flat marc8_31page745_flat[] = {
  {"\x43", 0, 0x7CCD}, /* East Asian ideograph */
  {"\x7B", 0, 0x7CE8}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page745 = {
  marc8_31page745_flat, 0
};
/* PAGE 744 */
struct yaz_iconv_trie_flat marc8_31page744_flat[] = {
  {"\x42", 0, 0x7C31}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page744 = {
  marc8_31page744_flat, 0
};
/* PAGE 743 */
struct yaz_iconv_trie_flat marc8_31page743_flat[] = {
  {"\x46", 0, 0x7B9F}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page743 = {
  marc8_31page743_flat, 0
};
/* PAGE 742 */
struct yaz_iconv_trie_flat marc8_31page742_flat[] = {
  {"\x62", 0, 0x7B4C}, /* East Asian ideograph (variant of EACC 226B62) */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page742 = {
  marc8_31page742_flat, 0
};
/* PAGE 741 */
struct yaz_iconv_trie_flat marc8_31page741_flat[] = {
  {"\x5C", 0, 0x7A06}, /* East Asian ideograph */
  {"\x5F", 0, 0x7A63}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page741 = {
  marc8_31page741_flat, 0
};
/* PAGE 740 */
struct yaz_iconv_trie_flat marc8_31page740_flat[] = {
  {"\x3E", 0, 0x79EB}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page740 = {
  marc8_31page740_flat, 0
};
/* PAGE 739 */
struct yaz_iconv_trie_flat marc8_31page739_flat[] = {
  {"\x75", 0, 0x7962}, /* East Asian ideograph (unrelated variant of EACC 293032) */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page739 = {
  marc8_31page739_flat, 0
};
/* PAGE 738 */
struct yaz_iconv_trie_flat marc8_31page738_flat[] = {
  {"\x64", 0, 0x78D9}, /* East Asian ideograph */
  {"\x65", 0, 0x78B9}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page738 = {
  marc8_31page738_flat, 0
};
/* PAGE 737 */
struct yaz_iconv_trie_flat marc8_31page737_flat[] = {
  {"\x76", 0, 0x7839}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page737 = {
  marc8_31page737_flat, 0
};
/* PAGE 736 */
struct yaz_iconv_trie_flat marc8_31page736_flat[] = {
  {"\x66", 0, 0x778B}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page736 = {
  marc8_31page736_flat, 0
};
/* PAGE 735 */
struct yaz_iconv_trie_flat marc8_31page735_flat[] = {
  {"\x22", 0, 0x7596}, /* East Asian ideograph */
  {"\x74", 0, 0x76B9}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page735 = {
  marc8_31page735_flat, 0
};
/* PAGE 734 */
struct yaz_iconv_trie_flat marc8_31page734_flat[] = {
  {"\x58", 0, 0x7640}, /* East Asian ideograph */
  {"\x69", 0, 0x75EB}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page734 = {
  marc8_31page734_flat, 0
};
/* PAGE 733 */
struct yaz_iconv_trie_flat marc8_31page733_flat[] = {
  {"\x3A", 0, 0x73F1}, /* East Asian ideograph */
  {"\x61", 0, 0x74F4}, /* East Asian ideograph (variant of EACC 225C61) */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page733 = {
  marc8_31page733_flat, 0
};
/* PAGE 732 */
struct yaz_iconv_trie_flat marc8_31page732_flat[] = {
  {"\x38", 0, 0x729F}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page732 = {
  marc8_31page732_flat, 0
};
/* PAGE 731 */
struct yaz_iconv_trie_flat marc8_31page731_flat[] = {
  {"\x41", 0, 0x4E2C}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page731 = {
  marc8_31page731_flat, 0
};
/* PAGE 730 */
struct yaz_iconv_trie_flat marc8_31page730_flat[] = {
  {"\x47", 0, 0x71E0}, /* East Asian ideograph (variant of EACC 225447) */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page730 = {
  marc8_31page730_flat, 0
};
/* PAGE 729 */
struct yaz_iconv_trie_flat marc8_31page729_flat[] = {
  {"\x3A", 0, 0x717A}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page729 = {
  marc8_31page729_flat, 0
};
/* PAGE 728 */
struct yaz_iconv_trie_flat marc8_31page728_flat[] = {
  {"\x75", 0, 0x8315}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page728 = {
  marc8_31page728_flat, 0
};
/* PAGE 727 */
struct yaz_iconv_trie_flat marc8_31page727_flat[] = {
  {"\x24", 0, 0x6F46}, /* East Asian ideograph */
  {"\x26", 0, 0x6EDD}, /* East Asian ideograph */
  {"\x2B", 0, 0x701E}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page727 = {
  marc8_31page727_flat, 0
};
/* PAGE 726 */
struct yaz_iconv_trie_flat marc8_31page726_flat[] = {
  {"\x3D", 0, 0x6F62}, /* East Asian ideograph */
  {"\x63", 0, 0x6F99}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page726 = {
  marc8_31page726_flat, 0
};
/* PAGE 725 */
struct yaz_iconv_trie_flat marc8_31page725_flat[] = {
  {"\x35", 0, 0x6E0C}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page725 = {
  marc8_31page725_flat, 0
};
/* PAGE 724 */
struct yaz_iconv_trie_flat marc8_31page724_flat[] = {
  {"\x6E", 0, 0x6CAD}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page724 = {
  marc8_31page724_flat, 0
};
/* PAGE 723 */
struct yaz_iconv_trie_flat marc8_31page723_flat[] = {
  {"\x46", 0, 0x6B4E}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page723 = {
  marc8_31page723_flat, 0
};
/* PAGE 722 */
struct yaz_iconv_trie_flat marc8_31page722_flat[] = {
  {"\x33", 0, 0x6AAA}, /* East Asian ideograph */
  {"\x39", 0, 0x69DE}, /* East Asian ideograph */
  {"\x3F", 0, 0x6A65}, /* East Asian ideograph */
  {"\x45", 0, 0x67A6}, /* East Asian ideograph */
  {"\x59", 0, 0x6B05}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page722 = {
  marc8_31page722_flat, 0
};
/* PAGE 721 */
struct yaz_iconv_trie_flat marc8_31page721_flat[] = {
  {"\x46", 0, 0x8538}, /* East Asian ideograph */
  {"\x77", 0, 0x8223}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page721 = {
  marc8_31page721_flat, 0
};
/* PAGE 720 */
struct yaz_iconv_trie_flat marc8_31page720_flat[] = {
  {"\x68", 0, 0x69C7}, /* East Asian ideograph */
  {"\x7A", 0, 0x6922}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page720 = {
  marc8_31page720_flat, 0
};
/* PAGE 719 */
struct yaz_iconv_trie_flat marc8_31page719_flat[] = {
  {"\x22", 0, 0x6860}, /* East Asian ideograph */
  {"\x31", 0, 0x6798}, /* East Asian ideograph */
  {"\x60", 0, 0x6764}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page719 = {
  marc8_31page719_flat, 0
};
/* PAGE 718 */
struct yaz_iconv_trie_flat marc8_31page718_flat[] = {
  {"\x33", 0, 0x80AD}, /* East Asian ideograph (variant of EACC 2E3A33) */
  {"\x55", 0, 0x6741}, /* East Asian ideograph */
  {"\x5B", 0, 0x6859}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page718 = {
  marc8_31page718_flat, 0
};
/* PAGE 717 */
struct yaz_iconv_trie_flat marc8_31page717_flat[] = {
  {"\x44", 0, 0x65D9}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page717 = {
  marc8_31page717_flat, 0
};
/* PAGE 716 */
struct yaz_iconv_trie_flat marc8_31page716_flat[] = {
  {"\x4A", 0, 0x64B8}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page716 = {
  marc8_31page716_flat, 0
};
/* PAGE 715 */
struct yaz_iconv_trie_flat marc8_31page715_flat[] = {
  {"\x74", 0, 0x631D}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page715 = {
  marc8_31page715_flat, 0
};
/* PAGE 714 */
struct yaz_iconv_trie_flat marc8_31page714_flat[] = {
  {"\x61", 0, 0x622C}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page714 = {
  marc8_31page714_flat, 0
};
/* PAGE 713 */
struct yaz_iconv_trie_flat marc8_31page713_flat[] = {
  {"\x62", 0, 0x5F4D}, /* East Asian ideograph (variant of EACC 222962) */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page713 = {
  marc8_31page713_flat, 0
};
/* PAGE 712 */
struct yaz_iconv_trie_flat marc8_31page712_flat[] = {
  {"\x4C", 0, 0x53A9}, /* East Asian ideograph */
  {"\x67", 0, 0x5EDB}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page712 = {
  marc8_31page712_flat, 0
};
/* PAGE 711 */
struct yaz_iconv_trie_flat marc8_31page711_flat[] = {
  {"\x32", 0, 0x5D5B}, /* East Asian ideograph */
  {"\x39", 0, 0x5D73}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page711 = {
  marc8_31page711_flat, 0
};
/* PAGE 710 */
struct yaz_iconv_trie_flat marc8_31page710_flat[] = {
  {"\x30", 0, 0x5C53}, /* East Asian ideograph */
  {"\x3F", 0, 0x5C76}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page710 = {
  marc8_31page710_flat, 0
};
/* PAGE 709 */
struct yaz_iconv_trie_dir marc8_31page709_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {711, 0, 0},
  {0, 0, 0},
  {712, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {713, 0, 0},
  {714, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {715, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {716, 0, 0},
  {717, 0, 0},
  {0, 0, 0},
  {718, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {719, 0, 0},
  {720, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {721, 0, 0},
  {0, 0, 0},
  {722, 0, 0},
  {0, 0, 0},
  {723, 0, 0},
  {724, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {725, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {726, 0, 0},
  {727, 0, 0},
  {0, 0, 0},
  {728, 0, 0},
  {0, 0, 0},
  {729, 0, 0},
  {730, 0, 0},
  {0, 0, 0},
  {731, 0, 0},
  {732, 0, 0},
  {733, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {734, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {735, 0, 0},
  {736, 0, 0},
  {0, 0, 0},
  {737, 0, 0},
  {738, 0, 0},
  {0, 0, 0},
  {739, 0, 0},
  {0, 0, 0},
  {740, 0, 0},
  {741, 0, 0},
  {742, 0, 0},
  {0, 0, 0},
  {743, 0, 0},
  {744, 0, 0},
  {0, 0, 0},
  {745, 0, 0},
  {746, 0, 0},
  {0, 0, 0},
  {747, 0, 0},
  {748, 0, 0},
  {749, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {750, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {751, 0, 0},
  {752, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8_31page709 = {
  0, marc8_31page709_dir
};
/* PAGE 708 */
struct yaz_iconv_trie_flat marc8_31page708_flat[] = {
  {"\x6A", 0, 0x5BC3}, /* East Asian ideograph (variant of EACC 217E6A) */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page708 = {
  marc8_31page708_flat, 0
};
/* PAGE 707 */
struct yaz_iconv_trie_flat marc8_31page707_flat[] = {
  {"\x54", 0, 0x5968}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page707 = {
  marc8_31page707_flat, 0
};
/* PAGE 706 */
struct yaz_iconv_trie_flat marc8_31page706_flat[] = {
  {"\x74", 0, 0x590A}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page706 = {
  marc8_31page706_flat, 0
};
/* PAGE 705 */
struct yaz_iconv_trie_flat marc8_31page705_flat[] = {
  {"\x3D", 0, 0x57F4}, /* East Asian ideograph (variant of EACC 21763D) */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page705 = {
  marc8_31page705_flat, 0
};
/* PAGE 704 */
struct yaz_iconv_trie_flat marc8_31page704_flat[] = {
  {"\x77", 0, 0x57D3}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page704 = {
  marc8_31page704_flat, 0
};
/* PAGE 703 */
struct yaz_iconv_trie_flat marc8_31page703_flat[] = {
  {"\x21", 0, 0x56F9}, /* East Asian ideograph (variant of EACC 217421) */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page703 = {
  marc8_31page703_flat, 0
};
/* PAGE 702 */
struct yaz_iconv_trie_flat marc8_31page702_flat[] = {
  {"\x22", 0, 0x7F83}, /* East Asian ideograph */
  {"\x26", 0, 0x6C8D}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page702 = {
  marc8_31page702_flat, 0
};
/* PAGE 701 */
struct yaz_iconv_trie_flat marc8_31page701_flat[] = {
  {"\x2E", 0, 0x4EC2}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page701 = {
  marc8_31page701_flat, 0
};
/* PAGE 700 */
struct yaz_iconv_trie_flat marc8_31page700_flat[] = {
  {"\x37", 0, 0x4FE3}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page700 = {
  marc8_31page700_flat, 0
};
/* PAGE 699 */
struct yaz_iconv_trie_flat marc8_31page699_flat[] = {
  {"\x55", 0, 0x4EB6}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page699 = {
  marc8_31page699_flat, 0
};
/* PAGE 698 */
struct yaz_iconv_trie_flat marc8_31page698_flat[] = {
  {"\x24", 0, 0x9F62}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page698 = {
  marc8_31page698_flat, 0
};
/* PAGE 697 */
struct yaz_iconv_trie_flat marc8_31page697_flat[] = {
  {"\x3B", 0, 0x9D12}, /* East Asian ideograph */
  {"\x47", 0, 0x9D2C}, /* East Asian ideograph */
  {"\x4F", 0, 0x9D49}, /* East Asian ideograph */
  {"\x58", 0, 0x68BA}, /* East Asian ideograph */
  {"\x5C", 0, 0x9EB8}, /* East Asian ideograph (variant of EACC 27625C) */
  {"\x60", 0, 0x9EBD}, /* East Asian ideograph */
  {"\x66", 0, 0x9ED2}, /* East Asian ideograph */
  {"\x68", 0, 0x9ED9}, /* East Asian ideograph */
  {"\x78", 0, 0x9F21}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page697 = {
  marc8_31page697_flat, 0
};
/* PAGE 696 */
struct yaz_iconv_trie_flat marc8_31page696_flat[] = {
  {"\x22", 0, 0x994B}, /* East Asian ideograph */
  {"\x30", 0, 0x99C4}, /* East Asian ideograph */
  {"\x3F", 0, 0x9A08}, /* East Asian ideograph */
  {"\x45", 0, 0x9A12}, /* East Asian ideograph */
  {"\x47", 0, 0x99C6}, /* East Asian ideograph */
  {"\x4D", 0, 0x9A13}, /* East Asian ideograph */
  {"\x59", 0, 0x81B8}, /* East Asian ideograph */
  {"\x5F", 0, 0x9AEA}, /* East Asian ideograph */
  {"\x67", 0, 0x95D8}, /* East Asian ideograph */
  {"\x68", 0, 0x9599}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page696 = {
  marc8_31page696_flat, 0
};
/* PAGE 695 */
struct yaz_iconv_trie_flat marc8_31page695_flat[] = {
  {"\x2D", 0, 0x9771}, /* East Asian ideograph */
  {"\x44", 0, 0x9818}, /* East Asian ideograph */
  {"\x48", 0, 0x981A}, /* East Asian ideograph */
  {"\x53", 0, 0x985E}, /* East Asian ideograph */
  {"\x6F", 0, 0x991D}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page695 = {
  marc8_31page695_flat, 0
};
/* PAGE 694 */
struct yaz_iconv_trie_flat marc8_31page694_flat[] = {
  {"\x30", 0, 0x9686}, /* East Asian ideograph (variant of EACC 215F30) */
  {"\x35", 0, 0x6B92}, /* East Asian ideograph */
  {"\x3A", 0, 0x967A}, /* East Asian ideograph */
  {"\x49", 0, 0x51CB}, /* East Asian ideograph */
  {"\x4C", 0, 0x9D8F}, /* East Asian ideograph */
  {"\x50", 0, 0x96E3}, /* East Asian ideograph */
  {"\x58", 0, 0x96F6}, /* East Asian ideograph (variant of EACC 215F58 */
  {"\x62", 0, 0x7668}, /* East Asian ideograph */
  {"\x6F", 0, 0x970A}, /* East Asian ideograph */
  {"\x70", 0, 0x9752}, /* East Asian ideograph */
  {"\x71", 0, 0x9756}, /* East Asian ideograph */
  {"\x72", 0, 0x975B}, /* East Asian ideograph */
  {"\x73", 0, 0x975C}, /* East Asian ideograph (variant of EACC 215F73) */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page694 = {
  marc8_31page694_flat, 0
};
/* PAGE 693 */
struct yaz_iconv_trie_flat marc8_31page693_flat[] = {
  {"\x27", 0, 0x93AD}, /* East Asian ideograph */
  {"\x3D", 0, 0x9421}, /* East Asian ideograph */
  {"\x3F", 0, 0x922C}, /* East Asian ideograph */
  {"\x5D", 0, 0x95D4}, /* East Asian ideograph */
  {"\x69", 0, 0x95A2}, /* East Asian ideograph */
  {"\x6C", 0, 0x961D}, /* East Asian ideograph (duplicate simplified) */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page693 = {
  marc8_31page693_flat, 0
};
/* PAGE 692 */
struct yaz_iconv_trie_flat marc8_31page692_flat[] = {
  {"\x2B", 0, 0x9162}, /* East Asian ideograph */
  {"\x34", 0, 0x91B8}, /* East Asian ideograph */
  {"\x36", 0, 0x91C6}, /* East Asian ideograph */
  {"\x38", 0, 0x91C8}, /* East Asian ideograph */
  {"\x42", 0, 0x91E1}, /* East Asian ideograph */
  {"\x58", 0, 0x9234}, /* East Asian ideograph */
  {"\x65", 0, 0x8217}, /* East Asian ideograph */
  {"\x70", 0, 0x92AD}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page692 = {
  marc8_31page692_flat, 0
};
/* PAGE 691 */
struct yaz_iconv_trie_flat marc8_31page691_flat[] = {
  {"\x32", 0, 0x9038}, /* East Asian ideograph */
  {"\x39", 0, 0x9039}, /* East Asian ideograph */
  {"\x47", 0, 0x9059}, /* East Asian ideograph */
  {"\x50", 0, 0x9045}, /* East Asian ideograph */
  {"\x54", 0, 0x8F9F}, /* East Asian ideograph (duplicate simplified) */
  {"\x5B", 0, 0x8FBA}, /* East Asian ideograph */
  {"\x5E", 0, 0x961D}, /* East Asian ideograph */
  {"\x72", 0, 0x9119}, /* East Asian ideograph (variant of EACC 215C72) */
  {"\x77", 0, 0x9139}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page691 = {
  marc8_31page691_flat, 0
};
/* PAGE 690 */
struct yaz_iconv_trie_flat marc8_31page690_flat[] = {
  {"\x29", 0, 0x8E8D}, /* East Asian ideograph */
  {"\x46", 0, 0x8F0C}, /* East Asian ideograph */
  {"\x52", 0, 0x8F42}, /* East Asian ideograph */
  {"\x55", 0, 0x8EE2}, /* East Asian ideograph */
  {"\x58", 0, 0x8EE3}, /* East Asian ideograph */
  {"\x5E", 0, 0x5F01}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page690 = {
  marc8_31page690_flat, 0
};
/* PAGE 689 */
struct yaz_iconv_trie_flat marc8_31page689_flat[] = {
  {"\x23", 0, 0x621D}, /* East Asian ideograph */
  {"\x31", 0, 0x8CCE}, /* East Asian ideograph */
  {"\x3B", 0, 0x8D08}, /* East Asian ideograph */
  {"\x68", 0, 0x8DF5}, /* East Asian ideograph (variant of EACC 275A68) */
  {"\x7E", 0, 0x5C69}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page689 = {
  marc8_31page689_flat, 0
};
/* PAGE 688 */
struct yaz_iconv_trie_flat marc8_31page688_flat[] = {
  {"\x36", 0, 0x8B20}, /* East Asian ideograph */
  {"\x46", 0, 0x8A33}, /* East Asian ideograph */
  {"\x4A", 0, 0x8AAD}, /* East Asian ideograph */
  {"\x4B", 0, 0x5909}, /* East Asian ideograph */
  {"\x59", 0, 0x8273}, /* East Asian ideograph */
  {"\x63", 0, 0x734F}, /* East Asian ideograph */
  {"\x64", 0, 0x72E2}, /* East Asian ideograph */
  {"\x73", 0, 0x8D2E}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page688 = {
  marc8_31page688_flat, 0
};
/* PAGE 687 */
struct yaz_iconv_trie_flat marc8_31page687_flat[] = {
  {"\x24", 0, 0x897E}, /* East Asian ideograph */
  {"\x26", 0, 0x8983}, /* East Asian ideograph (variant of EACC 215826) */
  {"\x30", 0, 0x899A}, /* East Asian ideograph */
  {"\x32", 0, 0x89B3}, /* East Asian ideograph */
  {"\x61", 0, 0x4F89}, /* East Asian ideograph */
  {"\x71", 0, 0x8AA4}, /* East Asian ideograph */
  {"\x7A", 0, 0x8ACB}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page687 = {
  marc8_31page687_flat, 0
};
/* PAGE 686 */
struct yaz_iconv_trie_flat marc8_31page686_flat[] = {
  {"\x24", 0, 0x86CD}, /* East Asian ideograph */
  {"\x36", 0, 0x877F}, /* East Asian ideograph */
  {"\x40", 0, 0x8827}, /* East Asian ideograph */
  {"\x46", 0, 0x8853}, /* East Asian ideograph */
  {"\x6C", 0, 0x523E}, /* East Asian ideograph */
  {"\x6F", 0, 0x8910}, /* East Asian ideograph (variant of EACC 21576F) */
  {"\x73", 0, 0x7ED4}, /* East Asian ideograph */
  {"\x7E", 0, 0x7E7F}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page686 = {
  marc8_31page686_flat, 0
};
/* PAGE 685 */
struct yaz_iconv_trie_flat marc8_31page685_flat[] = {
  {"\x29", 0, 0x85CD}, /* East Asian ideograph */
  {"\x2B", 0, 0x8535}, /* East Asian ideograph */
  {"\x31", 0, 0x82B8}, /* East Asian ideograph */
  {"\x32", 0, 0x7C54}, /* East Asian ideograph */
  {"\x3A", 0, 0x82A6}, /* East Asian ideograph (variant of EACC 27563A) */
  {"\x3F", 0, 0x6A98}, /* East Asian ideograph */
  {"\x47", 0, 0x51E6}, /* East Asian ideograph */
  {"\x6A", 0, 0x8708}, /* East Asian ideograph (variant of EACC 21566A) */
  {"\x71", 0, 0x873B}, /* East Asian ideograph (variant of EACC 215671) */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page685 = {
  marc8_31page685_flat, 0
};
/* PAGE 684 */
struct yaz_iconv_trie_flat marc8_31page684_flat[] = {
  {"\x21", 0, 0x8332}, /* East Asian ideograph */
  {"\x2C", 0, 0x8392}, /* East Asian ideograph */
  {"\x3A", 0, 0x83C1}, /* East Asian ideograph (variant of EACC 21553A) */
  {"\x3F", 0, 0x83BD}, /* East Asian ideograph (variant of EACC 21553F) */
  {"\x42", 0, 0x8420}, /* East Asian ideograph */
  {"\x64", 0, 0x77C7}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page684 = {
  marc8_31page684_flat, 0
};
/* PAGE 683 */
struct yaz_iconv_trie_flat marc8_31page683_flat[] = {
  {"\x22", 0, 0x81D3}, /* East Asian ideograph */
  {"\x28", 0, 0x81ED}, /* East Asian ideograph (variant of EACC 215428) */
  {"\x34", 0, 0x6319}, /* East Asian ideograph */
  {"\x37", 0, 0x820E}, /* East Asian ideograph */
  {"\x6D", 0, 0x82D3}, /* East Asian ideograph (variant of EACC 21546D) */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page683 = {
  marc8_31page683_flat, 0
};
/* PAGE 682 */
struct yaz_iconv_trie_flat marc8_31page682_flat[] = {
  {"\x3B", 0, 0x695C}, /* East Asian ideograph */
  {"\x61", 0, 0x89D2}, /* East Asian ideograph (duplicate simplified) */
  {"\x65", 0, 0x8133}, /* East Asian ideograph */
  {"\x7D", 0, 0x9ACC}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page682 = {
  marc8_31page682_flat, 0
};
/* PAGE 681 */
struct yaz_iconv_trie_flat marc8_31page681_flat[] = {
  {"\x21", 0, 0x7D9A}, /* East Asian ideograph */
  {"\x23", 0, 0x7E4A}, /* East Asian ideograph */
  {"\x27", 0, 0x6B20}, /* East Asian ideograph */
  {"\x2B", 0, 0x7F36}, /* East Asian ideograph */
  {"\x38", 0, 0x7F87}, /* East Asian ideograph */
  {"\x3E", 0, 0x7F9A}, /* East Asian ideograph (variant of EACC 21523E) */
  {"\x47", 0, 0x7FAE}, /* East Asian ideograph */
  {"\x4E", 0, 0x7FCE}, /* East Asian ideograph */
  {"\x5A", 0, 0x7FFA}, /* East Asian ideograph */
  {"\x5B", 0, 0x66DC}, /* East Asian ideograph (variant of EACC 39525B) */
  {"\x5C", 0, 0x8002}, /* East Asian ideograph */
  {"\x6E", 0, 0x8046}, /* East Asian ideograph (variant of EACC 21526E) */
  {"\x77", 0, 0x8068}, /* East Asian ideograph */
  {"\x7C", 0, 0x8080}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page681 = {
  marc8_31page681_flat, 0
};
/* PAGE 680 */
struct yaz_iconv_trie_flat marc8_31page680_flat[] = {
  {"\x3B", 0, 0x7CF8}, /* East Asian ideograph */
  {"\x54", 0, 0x7DF4}, /* East Asian ideograph */
  {"\x5A", 0, 0x7E01}, /* East Asian ideograph */
  {"\x64", 0, 0x770C}, /* East Asian ideograph */
  {"\x6A", 0, 0x7EF7}, /* East Asian ideograph */
  {"\x6D", 0, 0x7DCF}, /* East Asian ideograph */
  {"\x6E", 0, 0x7E26}, /* East Asian ideograph */
  {"\x76", 0, 0x7E04}, /* East Asian ideograph */
  {"\x79", 0, 0x7F0B}, /* East Asian ideograph */
  {"\x7E", 0, 0x7E92}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page680 = {
  marc8_31page680_flat, 0
};
/* PAGE 679 */
struct yaz_iconv_trie_flat marc8_31page679_flat[] = {
  {"\x36", 0, 0x7C14}, /* East Asian ideograph */
  {"\x3B", 0, 0x7C12}, /* East Asian ideograph */
  {"\x44", 0, 0x7C27}, /* East Asian ideograph (variant of EACC 215044) */
  {"\x52", 0, 0x7C56}, /* East Asian ideograph */
  {"\x61", 0, 0x7CBE}, /* East Asian ideograph */
  {"\x6C", 0, 0x7CAB}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page679 = {
  marc8_31page679_flat, 0
};
/* PAGE 678 */
struct yaz_iconv_trie_flat marc8_31page678_flat[] = {
  {"\x29", 0, 0x7A50}, /* East Asian ideograph */
  {"\x3C", 0, 0x79F0}, /* East Asian ideograph (variant of EACC 274F3C) */
  {"\x43", 0, 0x7A32}, /* East Asian ideograph */
  {"\x4C", 0, 0x7A4F}, /* East Asian ideograph */
  {"\x7B", 0, 0x7B7A}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page678 = {
  marc8_31page678_flat, 0
};
/* PAGE 677 */
struct yaz_iconv_trie_flat marc8_31page677_flat[] = {
  {"\x21", 0, 0x7B36}, /* East Asian ideograph */
  {"\x37", 0, 0x7814}, /* East Asian ideograph */
  {"\x39", 0, 0x5CFA}, /* East Asian ideograph */
  {"\x56", 0, 0x78FA}, /* East Asian ideograph */
  {"\x5B", 0, 0x783F}, /* East Asian ideograph */
  {"\x67", 0, 0x79D8}, /* East Asian ideograph */
  {"\x7B", 0, 0x7985}, /* East Asian ideograph (variant of EACC 274E7B) */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page677 = {
  marc8_31page677_flat, 0
};
/* PAGE 676 */
struct yaz_iconv_trie_flat marc8_31page676_flat[] = {
  {"\x41", 0, 0x862F}, /* East Asian ideograph */
  {"\x45", 0, 0x76F4}, /* East Asian ideograph (variant of EACC 214D45) */
  {"\x56", 0, 0x8846}, /* East Asian ideograph */
  {"\x59", 0, 0x775B}, /* East Asian ideograph (variant of EACC 214D59) */
  {"\x73", 0, 0x66B8}, /* East Asian ideograph */
  {"\x7B", 0, 0x77D7}, /* East Asian ideograph (variant of EACC 214D7B) */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page676 = {
  marc8_31page676_flat, 0
};
/* PAGE 675 */
struct yaz_iconv_trie_flat marc8_31page675_flat[] = {
  {"\x36", 0, 0x7575}, /* East Asian ideograph */
  {"\x3C", 0, 0x7573}, /* East Asian ideograph */
  {"\x51", 0, 0x75CA}, /* East Asian ideograph */
  {"\x5B", 0, 0x75F3}, /* East Asian ideograph */
  {"\x67", 0, 0x761F}, /* East Asian ideograph (variant of EACC 214C67) */
  {"\x79", 0, 0x7672}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page675 = {
  marc8_31page675_flat, 0
};
/* PAGE 674 */
struct yaz_iconv_trie_flat marc8_31page674_flat[] = {
  {"\x2B", 0, 0x7363}, /* East Asian ideograph */
  {"\x2C", 0, 0x731F}, /* East Asian ideograph */
  {"\x3E", 0, 0x73B2}, /* East Asian ideograph (variant of EACC 214B3E) */
  {"\x63", 0, 0x749C}, /* East Asian ideograph */
  {"\x71", 0, 0x7F3E}, /* East Asian ideograph (variant of EACC 2D4B71) */
  {"\x77", 0, 0x4EC0}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page674 = {
  marc8_31page674_flat, 0
};
/* PAGE 673 */
struct yaz_iconv_trie_flat marc8_31page673_flat[] = {
  {"\x2E", 0, 0x55B6}, /* East Asian ideograph */
  {"\x38", 0, 0x71D7}, /* East Asian ideograph */
  {"\x3E", 0, 0x7235}, /* East Asian ideograph */
  {"\x45", 0, 0x5C13}, /* East Asian ideograph */
  {"\x62", 0, 0x72A0}, /* East Asian ideograph */
  {"\x74", 0, 0x731C}, /* East Asian ideograph (variant of EACC 214A74) */
  {"\x78", 0, 0x72F0}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page673 = {
  marc8_31page673_flat, 0
};
/* PAGE 672 */
struct yaz_iconv_trie_flat marc8_31page672_flat[] = {
  {"\x21", 0, 0x6CA2}, /* East Asian ideograph */
  {"\x25", 0, 0x6FB3}, /* East Asian ideograph (variant of EACC 214925) */
  {"\x2B", 0, 0x6FEB}, /* East Asian ideograph */
  {"\x2E", 0, 0x6E0B}, /* East Asian ideograph */
  {"\x31", 0, 0x6E16}, /* East Asian ideograph */
  {"\x37", 0, 0x56A0}, /* East Asian ideograph */
  {"\x40", 0, 0x6F45}, /* East Asian ideograph */
  {"\x47", 0, 0x7AC3}, /* East Asian ideograph */
  {"\x6A", 0, 0x932C}, /* East Asian ideograph */
  {"\x6B", 0, 0x83F8}, /* East Asian ideograph */
  {"\x73", 0, 0x7115}, /* East Asian ideograph */
  {"\x75", 0, 0x6427}, /* East Asian ideograph */
  {"\x77", 0, 0x7188}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page672 = {
  marc8_31page672_flat, 0
};
/* PAGE 671 */
struct yaz_iconv_trie_flat marc8_31page671_flat[] = {
  {"\x35", 0, 0x6DA3}, /* East Asian ideograph */
  {"\x46", 0, 0x78C6}, /* East Asian ideograph */
  {"\x4A", 0, 0x6E13}, /* East Asian ideograph */
  {"\x4B", 0, 0x51D6}, /* East Asian ideograph */
  {"\x4C", 0, 0x6F91}, /* East Asian ideograph */
  {"\x57", 0, 0x6F22}, /* East Asian ideograph */
  {"\x58", 0, 0x6E80}, /* East Asian ideograph */
  {"\x5F", 0, 0x6EDE}, /* East Asian ideograph (variant of EACC 27485F) */
  {"\x66", 0, 0x6E89}, /* East Asian ideograph */
  {"\x74", 0, 0x6FF3}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page671 = {
  marc8_31page671_flat, 0
};
/* PAGE 670 */
struct yaz_iconv_trie_flat marc8_31page670_flat[] = {
  {"\x41", 0, 0x51BD}, /* East Asian ideograph */
  {"\x59", 0, 0x6D99}, /* East Asian ideograph */
  {"\x61", 0, 0x6E05}, /* East Asian ideograph */
  {"\x67", 0, 0x6DB5}, /* East Asian ideograph (variant of EACC 214767) */
  {"\x6C", 0, 0x51C5}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page670 = {
  marc8_31page670_flat, 0
};
/* PAGE 669 */
struct yaz_iconv_trie_flat marc8_31page669_flat[] = {
  {"\x21", 0, 0x6B53}, /* East Asian ideograph */
  {"\x2A", 0, 0x6B74}, /* East Asian ideograph */
  {"\x2E", 0, 0x6B81}, /* East Asian ideograph */
  {"\x38", 0, 0x6BB1}, /* East Asian ideograph */
  {"\x55", 0, 0x6C17}, /* East Asian ideograph */
  {"\x5A", 0, 0x6C32}, /* East Asian ideograph */
  {"\x76", 0, 0x6C89}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page669 = {
  marc8_31page669_flat, 0
};
/* PAGE 668 */
struct yaz_iconv_trie_flat marc8_31page668_flat[] = {
  {"\x34", 0, 0x6994}, /* East Asian ideograph (variant of EACC 214534) */
  {"\x37", 0, 0x6804}, /* East Asian ideograph */
  {"\x44", 0, 0x69D8}, /* East Asian ideograph */
  {"\x45", 0, 0x6982}, /* East Asian ideograph */
  {"\x53", 0, 0x6955}, /* East Asian ideograph */
  {"\x56", 0, 0x6A2A}, /* East Asian ideograph */
  {"\x59", 0, 0x9792}, /* East Asian ideograph */
  {"\x61", 0, 0x691C}, /* East Asian ideograph */
  {"\x69", 0, 0x6A71}, /* East Asian ideograph */
  {"\x6C", 0, 0x6ADB}, /* East Asian ideograph (variant of EACC 21456C) */
  {"\x6D", 0, 0x823B}, /* East Asian ideograph */
  {"\x6F", 0, 0x685C}, /* East Asian ideograph */
  {"\x70", 0, 0x6A29}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page668 = {
  marc8_31page668_flat, 0
};
/* PAGE 667 */
struct yaz_iconv_trie_flat marc8_31page667_flat[] = {
  {"\x2D", 0, 0x67A9}, /* East Asian ideograph */
  {"\x44", 0, 0x8988}, /* East Asian ideograph (Version J extension) */
  {"\x56", 0, 0x6813}, /* East Asian ideograph */
  {"\x76", 0, 0x685F}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page667 = {
  marc8_31page667_flat, 0
};
/* PAGE 666 */
struct yaz_iconv_trie_flat marc8_31page666_flat[] = {
  {"\x39", 0, 0x6674}, /* East Asian ideograph */
  {"\x47", 0, 0x66A8}, /* East Asian ideograph */
  {"\x4D", 0, 0x663F}, /* East Asian ideograph */
  {"\x52", 0, 0x66F5}, /* East Asian ideograph */
  {"\x58", 0, 0x66FD}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page666 = {
  marc8_31page666_flat, 0
};
/* PAGE 665 */
struct yaz_iconv_trie_flat marc8_31page665_flat[] = {
  {"\x35", 0, 0x6442}, /* East Asian ideograph */
  {"\x36", 0, 0x643A}, /* East Asian ideograph */
  {"\x3A", 0, 0x64B9}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page665 = {
  marc8_31page665_flat, 0
};
/* PAGE 664 */
struct yaz_iconv_trie_flat marc8_31page664_flat[] = {
  {"\x2A", 0, 0x6323}, /* East Asian ideograph */
  {"\x35", 0, 0x6368}, /* East Asian ideograph */
  {"\x46", 0, 0x6362}, /* East Asian ideograph */
  {"\x47", 0, 0x633F}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page664 = {
  marc8_31page664_flat, 0
};
/* PAGE 663 */
struct yaz_iconv_trie_flat marc8_31page663_flat[] = {
  {"\x3D", 0, 0x62DD}, /* East Asian ideograph */
  {"\x46", 0, 0x629C}, /* East Asian ideograph */
  {"\x49", 0, 0x62D0}, /* East Asian ideograph */
  {"\x53", 0, 0x627A}, /* East Asian ideograph */
  {"\x66", 0, 0x62F4}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page663 = {
  marc8_31page663_flat, 0
};
/* PAGE 662 */
struct yaz_iconv_trie_flat marc8_31page662_flat[] = {
  {"\x40", 0, 0x618E}, /* East Asian ideograph (variant of EACC 213F40) */
  {"\x4A", 0, 0x5FDC}, /* East Asian ideograph */
  {"\x4B", 0, 0x601C}, /* East Asian ideograph (variant of EACC 273F4B) */
  {"\x50", 0, 0x61CA}, /* East Asian ideograph (variant of EACC 213F50) */
  {"\x51", 0, 0x61D1}, /* East Asian ideograph */
  {"\x53", 0, 0x61F2}, /* East Asian ideograph */
  {"\x74", 0, 0x623B}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page662 = {
  marc8_31page662_flat, 0
};
/* PAGE 661 */
struct yaz_iconv_trie_flat marc8_31page661_flat[] = {
  {"\x2A", 0, 0x6035}, /* East Asian ideograph */
  {"\x40", 0, 0x6046}, /* East Asian ideograph */
  {"\x5B", 0, 0x60C5}, /* East Asian ideograph */
  {"\x7E", 0, 0x60A9}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page661 = {
  marc8_31page661_flat, 0
};
/* PAGE 660 */
struct yaz_iconv_trie_flat marc8_31page660_flat[] = {
  {"\x24", 0, 0x53A6}, /* East Asian ideograph */
  {"\x27", 0, 0x5EC3}, /* East Asian ideograph */
  {"\x2A", 0, 0x5EE3}, /* East Asian ideograph */
  {"\x2C", 0, 0x53B0}, /* East Asian ideograph */
  {"\x2F", 0, 0x5EF0}, /* East Asian ideograph */
  {"\x4B", 0, 0x5F3E}, /* East Asian ideograph */
  {"\x4C", 0, 0x5F25}, /* East Asian ideograph (variant of EACC 273D4C) */
  {"\x5C", 0, 0x5F83}, /* East Asian ideograph */
  {"\x67", 0, 0x5F84}, /* East Asian ideograph (variant of EACC 273D67) */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page660 = {
  marc8_31page660_flat, 0
};
/* PAGE 659 */
struct yaz_iconv_trie_flat marc8_31page659_flat[] = {
  {"\x21", 0, 0x5D5C}, /* East Asian ideograph */
  {"\x23", 0, 0x5CE5}, /* East Asian ideograph */
  {"\x2B", 0, 0x67C3}, /* East Asian ideograph (Version J extension) */
  {"\x2F", 0, 0x5DBA}, /* East Asian ideograph */
  {"\x32", 0, 0x5DD3}, /* East Asian ideograph */
  {"\x33", 0, 0x5DCC}, /* East Asian ideograph */
  {"\x38", 0, 0x949C}, /* East Asian ideograph */
  {"\x53", 0, 0x5E2F}, /* East Asian ideograph */
  {"\x5E", 0, 0x5E64}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page659 = {
  marc8_31page659_flat, 0
};
/* PAGE 658 */
struct yaz_iconv_trie_flat marc8_31page658_flat[] = {
  {"\x22", 0, 0x51A6}, /* East Asian ideograph */
  {"\x31", 0, 0x5B9F}, /* East Asian ideograph */
  {"\x37", 0, 0x51A9}, /* East Asian ideograph */
  {"\x43", 0, 0x5BFE}, /* East Asian ideograph */
  {"\x52", 0, 0x8132}, /* East Asian ideograph */
  {"\x61", 0, 0x5C64}, /* East Asian ideograph */
  {"\x67", 0, 0x6B67}, /* East Asian ideograph */
  {"\x79", 0, 0x5D8C}, /* East Asian ideograph */
  {"\x7E", 0, 0x5D15}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page658 = {
  marc8_31page658_flat, 0
};
/* PAGE 657 */
struct yaz_iconv_trie_flat marc8_31page657_flat[] = {
  {"\x2F", 0, 0x805F}, /* East Asian ideograph */
  {"\x47", 0, 0x88CA}, /* East Asian ideograph */
  {"\x49", 0, 0x5B37}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page657 = {
  marc8_31page657_flat, 0
};
/* PAGE 656 */
struct yaz_iconv_trie_flat marc8_31page656_flat[] = {
  {"\x38", 0, 0x5942}, /* East Asian ideograph */
  {"\x3A", 0, 0x5F09}, /* East Asian ideograph */
  {"\x3E", 0, 0x5965}, /* East Asian ideograph */
  {"\x3F", 0, 0x5333}, /* East Asian ideograph */
  {"\x74", 0, 0x5B22}, /* East Asian ideograph */
  {"\x7B", 0, 0x5A2F}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page656 = {
  marc8_31page656_flat, 0
};
/* PAGE 655 */
struct yaz_iconv_trie_flat marc8_31page655_flat[] = {
  {"\x2E", 0, 0x57C0}, /* East Asian ideograph */
  {"\x50", 0, 0x5861}, /* East Asian ideograph (variant of EACC 213850) */
  {"\x53", 0, 0x586D}, /* East Asian ideograph */
  {"\x5E", 0, 0x5897}, /* East Asian ideograph */
  {"\x64", 0, 0x58C7}, /* East Asian ideograph */
  {"\x69", 0, 0x5727}, /* East Asian ideograph */
  {"\x6C", 0, 0x5841}, /* East Asian ideograph */
  {"\x70", 0, 0x58CC}, /* East Asian ideograph */
  {"\x71", 0, 0x57BB}, /* East Asian ideograph */
  {"\x7D", 0, 0x591B}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page655 = {
  marc8_31page655_flat, 0
};
/* PAGE 654 */
struct yaz_iconv_trie_flat marc8_31page654_flat[] = {
  {"\x2C", 0, 0x5606}, /* East Asian ideograph */
  {"\x2F", 0, 0x5C1C}, /* East Asian ideograph */
  {"\x49", 0, 0x5668}, /* East Asian ideograph (variant of EACC 213749) */
  {"\x4C", 0, 0x5662}, /* East Asian ideograph */
  {"\x58", 0, 0x56A5}, /* East Asian ideograph (variant of EACC 213758) */
  {"\x5A", 0, 0x53B3}, /* East Asian ideograph */
  {"\x68", 0, 0x56D8}, /* East Asian ideograph */
  {"\x6F", 0, 0x56FD}, /* East Asian ideograph */
  {"\x72", 0, 0x5186}, /* East Asian ideograph */
  {"\x73", 0, 0x56E3}, /* East Asian ideograph */
  {"\x74", 0, 0x56F3}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page654 = {
  marc8_31page654_flat, 0
};
/* PAGE 653 */
struct yaz_iconv_trie_flat marc8_31page653_flat[] = {
  {"\x22", 0, 0x8C18}, /* East Asian ideograph */
  {"\x42", 0, 0x8BF6}, /* East Asian ideograph */
  {"\x66", 0, 0x5A1A}, /* East Asian ideograph */
  {"\x68", 0, 0x5358}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page653 = {
  marc8_31page653_flat, 0
};
/* PAGE 652 */
struct yaz_iconv_trie_flat marc8_31page652_flat[] = {
  {"\x6A", 0, 0x55EC}, /* East Asian ideograph */
  {"\x7B", 0, 0x54CC}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page652 = {
  marc8_31page652_flat, 0
};
/* PAGE 651 */
struct yaz_iconv_trie_flat marc8_31page651_flat[] = {
  {"\x21", 0, 0x5263}, /* East Asian ideograph */
  {"\x35", 0, 0x52B4}, /* East Asian ideograph */
  {"\x36", 0, 0x52F2}, /* East Asian ideograph */
  {"\x6B", 0, 0x5DF5}, /* East Asian ideograph */
  {"\x74", 0, 0x537F}, /* East Asian ideograph (variant of EACC 213474) */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page651 = {
  marc8_31page651_flat, 0
};
/* PAGE 650 */
struct yaz_iconv_trie_flat marc8_31page650_flat[] = {
  {"\x21", 0, 0x5185}, /* East Asian ideograph */
  {"\x22", 0, 0x5168}, /* East Asian ideograph (variant of EACC 213322) */
  {"\x24", 0, 0x634C}, /* East Asian ideograph (variant of EACC 2D3324) */
  {"\x3E", 0, 0x51B7}, /* East Asian ideograph (variant of EACC 21333E) */
  {"\x51", 0, 0x5204}, /* East Asian ideograph */
  {"\x54", 0, 0x82C5}, /* East Asian ideograph */
  {"\x55", 0, 0x520B}, /* East Asian ideograph */
  {"\x5B", 0, 0x522B}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page650 = {
  marc8_31page650_flat, 0
};
/* PAGE 649 */
struct yaz_iconv_trie_flat marc8_31page649_flat[] = {
  {"\x31", 0, 0x4EEE}, /* East Asian ideograph */
  {"\x48", 0, 0x50B2}, /* East Asian ideograph */
  {"\x4E", 0, 0x50E7}, /* East Asian ideograph (variant of EACC 21324E) */
  {"\x5F", 0, 0x50BB}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page649 = {
  marc8_31page649_flat, 0
};
/* PAGE 648 */
struct yaz_iconv_trie_flat marc8_31page648_flat[] = {
  {"\x2D", 0, 0x4F2B}, /* East Asian ideograph */
  {"\x30", 0, 0x4FAB}, /* East Asian ideograph */
  {"\x44", 0, 0x4F36}, /* East Asian ideograph (variant of EACC 213144) */
  {"\x4C", 0, 0x5F95}, /* East Asian ideograph */
  {"\x6A", 0, 0x723C}, /* East Asian ideograph */
  {"\x78", 0, 0x5029}, /* East Asian ideograph (variant of EACC 213178) */
  {"\x7C", 0, 0x5024}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page648 = {
  marc8_31page648_flat, 0
};
/* PAGE 647 */
struct yaz_iconv_trie_flat marc8_31page647_flat[] = {
  {"\x21", 0, 0x58F1}, /* East Asian ideograph */
  {"\x50", 0, 0x4E8A}, /* East Asian ideograph */
  {"\x51", 0, 0x5F10}, /* East Asian ideograph */
  {"\x52", 0, 0x6275}, /* East Asian ideograph */
  {"\x57", 0, 0x4E99}, /* East Asian ideograph */
  {"\x6C", 0, 0x96E0}, /* East Asian ideograph */
  {"\x6E", 0, 0x4EE4}, /* East Asian ideograph (variant of EACC 21306E) */
  {"\x72", 0, 0x4EED}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page647 = {
  marc8_31page647_flat, 0
};
/* PAGE 646 */
struct yaz_iconv_trie_dir marc8_31page646_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {648, 0, 0},
  {649, 0, 0},
  {650, 0, 0},
  {651, 0, 0},
  {652, 0, 0},
  {653, 0, 0},
  {654, 0, 0},
  {655, 0, 0},
  {656, 0, 0},
  {657, 0, 0},
  {658, 0, 0},
  {659, 0, 0},
  {660, 0, 0},
  {661, 0, 0},
  {662, 0, 0},
  {663, 0, 0},
  {664, 0, 0},
  {665, 0, 0},
  {666, 0, 0},
  {667, 0, 0},
  {668, 0, 0},
  {669, 0, 0},
  {670, 0, 0},
  {671, 0, 0},
  {672, 0, 0},
  {673, 0, 0},
  {674, 0, 0},
  {675, 0, 0},
  {676, 0, 0},
  {677, 0, 0},
  {678, 0, 0},
  {679, 0, 0},
  {680, 0, 0},
  {681, 0, 0},
  {682, 0, 0},
  {683, 0, 0},
  {684, 0, 0},
  {685, 0, 0},
  {686, 0, 0},
  {687, 0, 0},
  {688, 0, 0},
  {689, 0, 0},
  {690, 0, 0},
  {691, 0, 0},
  {692, 0, 0},
  {693, 0, 0},
  {694, 0, 0},
  {695, 0, 0},
  {696, 0, 0},
  {697, 0, 0},
  {698, 0, 0},
  {699, 0, 0},
  {700, 0, 0},
  {0, 0, 0},
  {701, 0, 0},
  {0, 0, 0},
  {702, 0, 0},
  {0, 0, 0},
  {703, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {704, 0, 0},
  {705, 0, 0},
  {706, 0, 0},
  {0, 0, 0},
  {707, 0, 0},
  {708, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {709, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8_31page646 = {
  0, marc8_31page646_dir
};
/* PAGE 645 */
struct yaz_iconv_trie_flat marc8_31page645_flat[] = {
  {"\x2C\x4D", 0, 0x8801}, /* East Asian ideograph (variant of EACC 232C4D) */
  {"\x34\x22", 0, 0x8C2A}, /* East Asian ideograph */
  {"\x34\x7B", 0, 0x8C2B}, /* East Asian ideograph */
  {"\x35\x39", 0, 0x8B9E}, /* East Asian ideograph */
  {"\x36\x6F", 0, 0x8D4D}, /* East Asian ideograph */
  {"\x42\x36", 0, 0x949A}, /* East Asian ideograph */
  {"\x42\x70", 0, 0x94BC}, /* East Asian ideograph */
  {"\x49\x31", 0, 0x95F6}, /* East Asian ideograph */
  {"\x4E\x5C", 0, 0x97DE}, /* East Asian ideograph (variant of EACC 234E5C) */
  {"\x52\x22", 0, 0x9957}, /* East Asian ideograph */
  {"\x57\x7A", 0, 0x9BD6}, /* East Asian ideograph (variant of EACC 23577A) */
  {"\x59\x4E", 0, 0x9C3A}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page645 = {
  marc8_31page645_flat, 0
};
/* PAGE 644 */
struct yaz_iconv_trie_flat marc8_31page644_flat[] = {
  {"\x28\x4C", 0, 0x5ED0}, /* East Asian ideograph */
  {"\x60\x74", 0, 0x76B2}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page644 = {
  marc8_31page644_flat, 0
};
/* PAGE 643 */
struct yaz_iconv_trie_flat marc8_31page643_flat[] = {
  {"\x30\x4C", 0, 0x69A6}, /* East Asian ideograph */
  {"\x30\x51", 0, 0x8D30}, /* East Asian ideograph */
  {"\x33\x36", 0, 0x5B82}, /* East Asian ideograph */
  {"\x34\x21", 0, 0x5271}, /* East Asian ideograph */
  {"\x36\x66", 0, 0x5AD0}, /* East Asian ideograph */
  {"\x37\x55", 0, 0x56AE}, /* East Asian ideograph */
  {"\x37\x68", 0, 0x5EFB}, /* East Asian ideograph */
  {"\x3D\x53", 0, 0x5F66}, /* East Asian ideograph */
  {"\x3F\x6D", 0, 0x52E0}, /* East Asian ideograph */
  {"\x41\x46", 0, 0x63DB}, /* East Asian ideograph */
  {"\x45\x6D", 0, 0x6A10}, /* East Asian ideograph */
  {"\x46\x2B", 0, 0x7688}, /* East Asian ideograph */
  {"\x46\x5B", 0, 0x6C2F}, /* East Asian ideograph */
  {"\x47\x38", 0, 0x6CFA}, /* East Asian ideograph */
  {"\x47\x74", 0, 0x6E15}, /* East Asian ideograph */
  {"\x4B\x7A", 0, 0x7523}, /* East Asian ideograph */
  {"\x4C\x3C", 0, 0x7589}, /* East Asian ideograph */
  {"\x4E\x43", 0, 0x788C}, /* East Asian ideograph (variant of EACC 214E43) */
  {"\x4E\x75", 0, 0x7984}, /* East Asian ideograph */
  {"\x4F\x45", 0, 0x9896}, /* East Asian ideograph */
  {"\x51\x22", 0, 0x7D0D}, /* East Asian ideograph */
  {"\x51\x64", 0, 0x53BF}, /* East Asian ideograph */
  {"\x55\x64", 0, 0x6FDB}, /* East Asian ideograph (Version J extension) */
  {"\x56\x4B", 0, 0x865E}, /* East Asian ideograph (variant of EACC 21564B) */
  {"\x57\x46", 0, 0x672F}, /* East Asian ideograph */
  {"\x58\x37", 0, 0x8BA0}, /* East Asian ideograph */
  {"\x58\x47", 0, 0x8A25}, /* East Asian ideograph (variant of EACC 215847) */
  {"\x5D\x3E", 0, 0x9485}, /* East Asian ideograph */
  {"\x5E\x21", 0, 0x953A}, /* East Asian ideograph */
  {"\x5E\x60", 0, 0x95EB}, /* East Asian ideograph (Version J extension) */
  {"\x5F\x35", 0, 0x9668}, /* East Asian ideograph (Version J extension) */
  {"\x60\x36", 0, 0x97FF}, /* East Asian ideograph */
  {"\x60\x4E", 0, 0x984F}, /* East Asian ideograph */
  {"\x60\x64", 0, 0x9963}, /* East Asian ideograph */
  {"\x60\x6B", 0, 0x98F0}, /* East Asian ideograph */
  {"\x60\x76", 0, 0x9980}, /* East Asian ideograph */
  {"\x62\x60", 0, 0x5E7A}, /* East Asian ideograph */
  {"\x63\x24", 0, 0x9F61}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page643 = {
  marc8_31page643_flat, 0
};
/* PAGE 642 */
struct yaz_iconv_trie_flat marc8_31page642_flat[] = {
  {"\x30\x4C", 0, 0x5E79}, /* East Asian ideograph */
  {"\x30\x78", 0, 0x5023}, /* East Asian ideograph */
  {"\x34\x7D", 0, 0x84E1}, /* East Asian ideograph */
  {"\x35\x73", 0, 0x8B3C}, /* East Asian ideograph */
  {"\x37\x7B", 0, 0x784E}, /* East Asian ideograph (Version J extension) */
  {"\x3D\x6F", 0, 0x8986}, /* East Asian ideograph */
  {"\x3E\x47", 0, 0x5379}, /* East Asian ideograph */
  {"\x3F\x24", 0, 0x614E}, /* East Asian ideograph */
  {"\x40\x4F", 0, 0x638A}, /* East Asian ideograph */
  {"\x42\x4F", 0, 0x542F}, /* East Asian ideograph (variant of EACC 27424F) */
  {"\x44\x72", 0, 0x7881}, /* East Asian ideograph */
  {"\x45\x6D", 0, 0x8263}, /* East Asian ideograph */
  {"\x46\x21", 0, 0x9A69}, /* East Asian ideograph */
  {"\x46\x29", 0, 0x4E97}, /* East Asian ideograph */
  {"\x46\x2B", 0, 0x5E30}, /* East Asian ideograph */
  {"\x47\x6F", 0, 0x51C8}, /* East Asian ideograph */
  {"\x49\x26", 0, 0x6E08}, /* East Asian ideograph */
  {"\x49\x56", 0, 0x7832}, /* East Asian ideograph */
  {"\x4A\x28", 0, 0x9DF0}, /* East Asian ideograph */
  {"\x4A\x60", 0, 0x7266}, /* East Asian ideograph */
  {"\x4C\x3C", 0, 0x7582}, /* East Asian ideograph */
  {"\x51\x6D", 0, 0x6403}, /* East Asian ideograph */
  {"\x55\x64", 0, 0x61DE}, /* East Asian ideograph */
  {"\x56\x31", 0, 0x517F}, /* East Asian ideograph */
  {"\x59\x59", 0, 0x8276}, /* East Asian ideograph */
  {"\x5E\x60", 0, 0x9586}, /* East Asian ideograph */
  {"\x5F\x34", 0, 0x9699}, /* East Asian ideograph */
  {"\x5F\x35", 0, 0x6B9E}, /* East Asian ideograph */
  {"\x5F\x49", 0, 0x7431}, /* East Asian ideograph */
  {"\x61\x4C", 0, 0x99C5}, /* East Asian ideograph */
  {"\x61\x79", 0, 0x5C1F}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page642 = {
  marc8_31page642_flat, 0
};
/* PAGE 641 */
struct yaz_iconv_trie_flat marc8_31page641_flat[] = {
  {"\x2D\x44", 0, 0x8842}, /* East Asian ideograph */
  {"\x39\x22", 0, 0x8DB5}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page641 = {
  marc8_31page641_flat, 0
};
/* PAGE 640 */
struct yaz_iconv_trie_flat marc8_31page640_flat[] = {
  {"\x28\x4C", 0, 0x53A9}, /* East Asian ideograph (variant of EACC 4C284C) */
  {"\x2F\x7C", 0, 0x64C0}, /* East Asian ideograph */
  {"\x3B\x7D", 0, 0x67B1}, /* East Asian ideograph */
  {"\x40\x34", 0, 0x6855}, /* East Asian ideograph */
  {"\x6A\x7C", 0, 0x7BEA}, /* East Asian ideograph */
  {"\x78\x7D", 0, 0x80FC}, /* East Asian ideograph */
  {"\x79\x70", 0, 0x81D5}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page640 = {
  marc8_31page640_flat, 0
};
/* PAGE 639 */
struct yaz_iconv_trie_flat marc8_31page639_flat[] = {
  {"\x6B", 0, 0x60A4}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page639 = {
  marc8_31page639_flat, 0
};
/* PAGE 638 */
struct yaz_iconv_trie_flat marc8_31page638_flat[] = {
  {"\x2F", 0, 0x521F}, /* East Asian ideograph */
  {"\x33", 0, 0x5259}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page638 = {
  marc8_31page638_flat, 0
};
/* PAGE 637 */
struct yaz_iconv_trie_flat marc8_31page637_flat[] = {
  {"\x23", 0, 0x9BFD}, /* East Asian ideograph (variant of EACC 216223) */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page637 = {
  marc8_31page637_flat, 0
};
/* PAGE 636 */
struct yaz_iconv_trie_flat marc8_31page636_flat[] = {
  {"\x67", 0, 0x9B2A}, /* East Asian ideograph */
  {"\x79", 0, 0x5C20}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page636 = {
  marc8_31page636_flat, 0
};
/* PAGE 635 */
struct yaz_iconv_trie_flat marc8_31page635_flat[] = {
  {"\x74", 0, 0x55B0}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page635 = {
  marc8_31page635_flat, 0
};
/* PAGE 634 */
struct yaz_iconv_trie_flat marc8_31page634_flat[] = {
  {"\x49", 0, 0x5F6B}, /* East Asian ideograph */
  {"\x68", 0, 0x8987}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page634 = {
  marc8_31page634_flat, 0
};
/* PAGE 633 */
struct yaz_iconv_trie_flat marc8_31page633_flat[] = {
  {"\x2F", 0, 0x5277}, /* East Asian ideograph */
  {"\x3D", 0, 0x9295}, /* East Asian ideograph */
  {"\x42", 0, 0x9274}, /* East Asian ideograph */
  {"\x6F", 0, 0x7A7D}, /* East Asian ideograph */
  {"\x71", 0, 0x5742}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page633 = {
  marc8_31page633_flat, 0
};
/* PAGE 632 */
struct yaz_iconv_trie_flat marc8_31page632_flat[] = {
  {"\x23", 0, 0x91BB}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page632 = {
  marc8_31page632_flat, 0
};
/* PAGE 631 */
struct yaz_iconv_trie_flat marc8_31page631_flat[] = {
  {"\x2F", 0, 0x58F2}, /* East Asian ideograph */
  {"\x36", 0, 0x983C}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page631 = {
  marc8_31page631_flat, 0
};
/* PAGE 630 */
struct yaz_iconv_trie_flat marc8_31page630_flat[] = {
  {"\x3F", 0, 0x8A3C}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page630 = {
  marc8_31page630_flat, 0
};
/* PAGE 629 */
struct yaz_iconv_trie_flat marc8_31page629_flat[] = {
  {"\x21", 0, 0x97E4}, /* East Asian ideograph */
  {"\x29", 0, 0x69FB}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page629 = {
  marc8_31page629_flat, 0
};
/* PAGE 628 */
struct yaz_iconv_trie_flat marc8_31page628_flat[] = {
  {"\x73", 0, 0x7DAF}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page628 = {
  marc8_31page628_flat, 0
};
/* PAGE 627 */
struct yaz_iconv_trie_flat marc8_31page627_flat[] = {
  {"\x3C", 0, 0x56CC}, /* East Asian ideograph */
  {"\x43", 0, 0x4E55}, /* East Asian ideograph */
  {"\x52", 0, 0x87A1}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page627 = {
  marc8_31page627_flat, 0
};
/* PAGE 626 */
struct yaz_iconv_trie_flat marc8_31page626_flat[] = {
  {"\x3C", 0, 0x5D0B}, /* East Asian ideograph */
  {"\x64", 0, 0x6726}, /* East Asian ideograph */
  {"\x68", 0, 0x83DD}, /* East Asian ideograph */
  {"\x77", 0, 0x854B}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page626 = {
  marc8_31page626_flat, 0
};
/* PAGE 625 */
struct yaz_iconv_trie_flat marc8_31page625_flat[] = {
  {"\x77", 0, 0x85A6}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page625 = {
  marc8_31page625_flat, 0
};
/* PAGE 624 */
struct yaz_iconv_trie_flat marc8_31page624_flat[] = {
  {"\x30", 0, 0x5BD8}, /* East Asian ideograph */
  {"\x5B", 0, 0x66DC}, /* East Asian ideograph */
  {"\x6B", 0, 0x7094}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page624 = {
  marc8_31page624_flat, 0
};
/* PAGE 623 */
struct yaz_iconv_trie_flat marc8_31page623_flat[] = {
  {"\x79", 0, 0x7D75}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page623 = {
  marc8_31page623_flat, 0
};
/* PAGE 622 */
struct yaz_iconv_trie_flat marc8_31page622_flat[] = {
  {"\x50", 0, 0x7BED}, /* East Asian ideograph */
  {"\x5B", 0, 0x9B3B}, /* East Asian ideograph */
  {"\x63", 0, 0x9939}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page622 = {
  marc8_31page622_flat, 0
};
/* PAGE 621 */
struct yaz_iconv_trie_flat marc8_31page621_flat[] = {
  {"\x2D", 0, 0x7546}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page621 = {
  marc8_31page621_flat, 0
};
/* PAGE 620 */
struct yaz_iconv_trie_flat marc8_31page620_flat[] = {
  {"\x60", 0, 0x9AE6}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page620 = {
  marc8_31page620_flat, 0
};
/* PAGE 619 */
struct yaz_iconv_trie_flat marc8_31page619_flat[] = {
  {"\x28", 0, 0x6D5C}, /* East Asian ideograph */
  {"\x44", 0, 0x6B12}, /* East Asian ideograph */
  {"\x56", 0, 0x792E}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page619 = {
  marc8_31page619_flat, 0
};
/* PAGE 618 */
struct yaz_iconv_trie_flat marc8_31page618_flat[] = {
  {"\x3B", 0, 0x9061}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page618 = {
  marc8_31page618_flat, 0
};
/* PAGE 617 */
struct yaz_iconv_trie_flat marc8_31page617_flat[] = {
  {"\x35", 0, 0x6C3E}, /* East Asian ideograph */
  {"\x6F", 0, 0x51C0}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page617 = {
  marc8_31page617_flat, 0
};
/* PAGE 616 */
struct yaz_iconv_trie_flat marc8_31page616_flat[] = {
  {"\x34", 0, 0x6B96}, /* East Asian ideograph (variant of EACC 214634) */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page616 = {
  marc8_31page616_flat, 0
};
/* PAGE 615 */
struct yaz_iconv_trie_flat marc8_31page615_flat[] = {
  {"\x6D", 0, 0x826B}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page615 = {
  marc8_31page615_flat, 0
};
/* PAGE 614 */
struct yaz_iconv_trie_flat marc8_31page614_flat[] = {
  {"\x44", 0, 0x8988}, /* East Asian ideograph */
  {"\x7D", 0, 0x6AC2}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page614 = {
  marc8_31page614_flat, 0
};
/* PAGE 613 */
struct yaz_iconv_trie_flat marc8_31page613_flat[] = {
  {"\x30", 0, 0x6644}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page613 = {
  marc8_31page613_flat, 0
};
/* PAGE 612 */
struct yaz_iconv_trie_flat marc8_31page612_flat[] = {
  {"\x43", 0, 0x4FF2}, /* East Asian ideograph */
  {"\x4F", 0, 0x5554}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page612 = {
  marc8_31page612_flat, 0
};
/* PAGE 611 */
struct yaz_iconv_trie_flat marc8_31page611_flat[] = {
  {"\x7C", 0, 0x62E0}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page611 = {
  marc8_31page611_flat, 0
};
/* PAGE 610 */
struct yaz_iconv_trie_flat marc8_31page610_flat[] = {
  {"\x22", 0, 0x6443}, /* East Asian ideograph */
  {"\x42", 0, 0x646D}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page610 = {
  marc8_31page610_flat, 0
};
/* PAGE 609 */
struct yaz_iconv_trie_flat marc8_31page609_flat[] = {
  {"\x47", 0, 0x8CC9}, /* East Asian ideograph */
  {"\x4C", 0, 0x6142}, /* East Asian ideograph */
  {"\x61", 0, 0x60AA}, /* East Asian ideograph */
  {"\x7D", 0, 0x7609}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page609 = {
  marc8_31page609_flat, 0
};
/* PAGE 608 */
struct yaz_iconv_trie_flat marc8_31page608_flat[] = {
  {"\x6F", 0, 0x8907}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page608 = {
  marc8_31page608_flat, 0
};
/* PAGE 607 */
struct yaz_iconv_trie_flat marc8_31page607_flat[] = {
  {"\x52", 0, 0x8D26}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page607 = {
  marc8_31page607_flat, 0
};
/* PAGE 606 */
struct yaz_iconv_trie_flat marc8_31page606_flat[] = {
  {"\x39", 0, 0x5BF3}, /* East Asian ideograph */
  {"\x6E", 0, 0x5C97}, /* East Asian ideograph */
  {"\x78", 0, 0x5CC4}, /* East Asian ideograph (duplicate simplified) */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page606 = {
  marc8_31page606_flat, 0
};
/* PAGE 605 */
struct yaz_iconv_trie_flat marc8_31page605_flat[] = {
  {"\x44", 0, 0x59B3}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page605 = {
  marc8_31page605_flat, 0
};
/* PAGE 604 */
struct yaz_iconv_trie_flat marc8_31page604_flat[] = {
  {"\x70", 0, 0x56F2}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page604 = {
  marc8_31page604_flat, 0
};
/* PAGE 603 */
struct yaz_iconv_trie_flat marc8_31page603_flat[] = {
  {"\x5A", 0, 0x8AE0}, /* East Asian ideograph */
  {"\x5E", 0, 0x559E}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page603 = {
  marc8_31page603_flat, 0
};
/* PAGE 602 */
struct yaz_iconv_trie_flat marc8_31page602_flat[] = {
  {"\x73", 0, 0x5611}, /* East Asian ideograph */
  {"\x77", 0, 0x9FA2}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page602 = {
  marc8_31page602_flat, 0
};
/* PAGE 601 */
struct yaz_iconv_trie_flat marc8_31page601_flat[] = {
  {"\x28", 0, 0x5227}, /* East Asian ideograph */
  {"\x39", 0, 0x61C3}, /* East Asian ideograph */
  {"\x5B", 0, 0x965E}, /* East Asian ideograph */
  {"\x60", 0, 0x604A}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page601 = {
  marc8_31page601_flat, 0
};
/* PAGE 600 */
struct yaz_iconv_trie_flat marc8_31page600_flat[] = {
  {"\x46", 0, 0x4F1D}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page600 = {
  marc8_31page600_flat, 0
};
/* PAGE 599 */
struct yaz_iconv_trie_flat marc8_31page599_flat[] = {
  {"\x2D", 0, 0x534B}, /* East Asian ideograph */
  {"\x3A", 0, 0x5EFC}, /* East Asian ideograph */
  {"\x4C", 0, 0x4E81}, /* East Asian ideograph */
  {"\x52", 0, 0x65BC}, /* East Asian ideograph */
  {"\x54", 0, 0x4F0D}, /* East Asian ideograph */
  {"\x78", 0, 0x9AE3}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page599 = {
  marc8_31page599_flat, 0
};
/* PAGE 598 */
struct yaz_iconv_trie_dir marc8_31page598_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {600, 0, 0},
  {0, 0, 0},
  {601, 0, 0},
  {0, 0, 0},
  {602, 0, 0},
  {603, 0, 0},
  {604, 0, 0},
  {605, 0, 0},
  {0, 0, 0},
  {606, 0, 0},
  {0, 0, 0},
  {607, 0, 0},
  {608, 0, 0},
  {609, 0, 0},
  {610, 0, 0},
  {0, 0, 0},
  {611, 0, 0},
  {612, 0, 0},
  {613, 0, 0},
  {614, 0, 0},
  {615, 0, 0},
  {616, 0, 0},
  {617, 0, 0},
  {618, 0, 0},
  {619, 0, 0},
  {620, 0, 0},
  {621, 0, 0},
  {0, 0, 0},
  {622, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {623, 0, 0},
  {624, 0, 0},
  {625, 0, 0},
  {0, 0, 0},
  {626, 0, 0},
  {627, 0, 0},
  {628, 0, 0},
  {629, 0, 0},
  {630, 0, 0},
  {631, 0, 0},
  {632, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {633, 0, 0},
  {634, 0, 0},
  {635, 0, 0},
  {636, 0, 0},
  {637, 0, 0},
  {638, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {639, 0, 0},
  {640, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8_31page598 = {
  0, marc8_31page598_dir
};
/* PAGE 597 */
struct yaz_iconv_trie_flat marc8_31page597_flat[] = {
  {"\x34\x4D", 0, 0x8B5B}, /* East Asian ideograph */
  {"\x34\x7B", 0, 0x8B2D}, /* East Asian ideograph */
  {"\x41\x56", 0, 0x91BE}, /* East Asian ideograph */
  {"\x50\x53", 0, 0x98C8}, /* East Asian ideograph */
  {"\x57\x39", 0, 0x9C76}, /* East Asian ideograph */
  {"\x5D\x5C", 0, 0x8C8E}, /* East Asian ideograph */
  {"\x5E\x76", 0, 0x82BE}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page597 = {
  marc8_31page597_flat, 0
};
/* PAGE 596 */
struct yaz_iconv_trie_flat marc8_31page596_flat[] = {
  {"\x24\x53", 0, 0x5CBD}, /* East Asian ideograph */
  {"\x38\x75", 0, 0x5FDE}, /* East Asian ideograph */
  {"\x3A\x5B", 0, 0x572C}, /* East Asian ideograph */
  {"\x3E\x38", 0, 0x7BDA}, /* East Asian ideograph */
  {"\x41\x38", 0, 0x8022}, /* East Asian ideograph */
  {"\x41\x77", 0, 0x8264}, /* East Asian ideograph */
  {"\x49\x2F", 0, 0x6D34}, /* East Asian ideograph */
  {"\x51\x75", 0, 0x7162}, /* East Asian ideograph */
  {"\x54\x52", 0, 0x7118}, /* East Asian ideograph */
  {"\x5D\x6B", 0, 0x756D}, /* East Asian ideograph */
  {"\x5E\x3B", 0, 0x80AC}, /* East Asian ideograph */
  {"\x5E\x47", 0, 0x75FE}, /* East Asian ideograph */
  {"\x61\x26", 0, 0x6900}, /* East Asian ideograph */
  {"\x66\x22", 0, 0x589D}, /* East Asian ideograph */
  {"\x68\x2A", 0, 0x7C7C}, /* East Asian ideograph */
  {"\x71\x5A", 0, 0x7E1A}, /* East Asian ideograph */
  {"\x74\x31", 0, 0x58DC}, /* East Asian ideograph */
  {"\x78\x2A", 0, 0x90C5}, /* East Asian ideograph */
  {"\x7D\x24", 0, 0x83C7}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page596 = {
  marc8_31page596_flat, 0
};
/* PAGE 595 */
struct yaz_iconv_trie_flat marc8_31page595_flat[] = {
  {"\x45", 0, 0x9F67}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page595 = {
  marc8_31page595_flat, 0
};
/* PAGE 594 */
struct yaz_iconv_trie_flat marc8_31page594_flat[] = {
  {"\x6B", 0, 0x6031}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page594 = {
  marc8_31page594_flat, 0
};
/* PAGE 593 */
struct yaz_iconv_trie_flat marc8_31page593_flat[] = {
  {"\x33", 0, 0x524F}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page593 = {
  marc8_31page593_flat, 0
};
/* PAGE 592 */
struct yaz_iconv_trie_flat marc8_31page592_flat[] = {
  {"\x21", 0, 0x6B6F}, /* East Asian ideograph */
  {"\x2B", 0, 0x7ADC}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page592 = {
  marc8_31page592_flat, 0
};
/* PAGE 591 */
struct yaz_iconv_trie_flat marc8_31page591_flat[] = {
  {"\x5E", 0, 0x9EAA}, /* East Asian ideograph */
  {"\x5F", 0, 0x8534}, /* East Asian ideograph */
  {"\x75", 0, 0x76BC}, /* East Asian ideograph */
  {"\x7D", 0, 0x6589}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page591 = {
  marc8_31page591_flat, 0
};
/* PAGE 590 */
struct yaz_iconv_trie_flat marc8_31page590_flat[] = {
  {"\x5A", 0, 0x8EB0}, /* East Asian ideograph */
  {"\x62", 0, 0x9A23}, /* East Asian ideograph */
  {"\x79", 0, 0x9C7B}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page590 = {
  marc8_31page590_flat, 0
};
/* PAGE 589 */
struct yaz_iconv_trie_flat marc8_31page589_flat[] = {
  {"\x54", 0, 0x985B}, /* East Asian ideograph */
  {"\x58", 0, 0x9855}, /* East Asian ideograph */
  {"\x62", 0, 0x98C3}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page589 = {
  marc8_31page589_flat, 0
};
/* PAGE 588 */
struct yaz_iconv_trie_flat marc8_31page588_flat[] = {
  {"\x34", 0, 0x90C4}, /* East Asian ideograph */
  {"\x3D", 0, 0x96B7}, /* East Asian ideograph */
  {"\x43", 0, 0x9D08}, /* East Asian ideograph */
  {"\x49", 0, 0x9D70}, /* East Asian ideograph */
  {"\x73", 0, 0x9759}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page588 = {
  marc8_31page588_flat, 0
};
/* PAGE 587 */
struct yaz_iconv_trie_flat marc8_31page587_flat[] = {
  {"\x21", 0, 0x9221}, /* East Asian ideograph */
  {"\x2F", 0, 0x5257}, /* East Asian ideograph */
  {"\x3D", 0, 0x9244}, /* East Asian ideograph */
  {"\x42", 0, 0x9452}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page587 = {
  marc8_31page587_flat, 0
};
/* PAGE 586 */
struct yaz_iconv_trie_flat marc8_31page586_flat[] = {
  {"\x23", 0, 0x8A76}, /* East Asian ideograph */
  {"\x3B", 0, 0x57DC}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page586 = {
  marc8_31page586_flat, 0
};
/* PAGE 585 */
struct yaz_iconv_trie_flat marc8_31page585_flat[] = {
  {"\x70", 0, 0x5EF8}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page585 = {
  marc8_31page585_flat, 0
};
/* PAGE 584 */
struct yaz_iconv_trie_flat marc8_31page584_flat[] = {
  {"\x7B", 0, 0x8E28}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page584 = {
  marc8_31page584_flat, 0
};
/* PAGE 583 */
struct yaz_iconv_trie_flat marc8_31page583_flat[] = {
  {"\x41", 0, 0x54D7}, /* East Asian ideograph */
  {"\x58", 0, 0x8C4A}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page583 = {
  marc8_31page583_flat, 0
};
/* PAGE 582 */
struct yaz_iconv_trie_flat marc8_31page582_flat[] = {
  {"\x21", 0, 0x97C8}, /* East Asian ideograph */
  {"\x30", 0, 0x658D}, /* East Asian ideograph */
  {"\x34", 0, 0x89E7}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page582 = {
  marc8_31page582_flat, 0
};
/* PAGE 581 */
struct yaz_iconv_trie_flat marc8_31page581_flat[] = {
  {"\x2E", 0, 0x880E}, /* East Asian ideograph */
  {"\x38", 0, 0x880F}, /* East Asian ideograph */
  {"\x60", 0, 0x88E0}, /* East Asian ideograph */
  {"\x72", 0, 0x8943}, /* East Asian ideograph */
  {"\x73", 0, 0x88B4}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page581 = {
  marc8_31page581_flat, 0
};
/* PAGE 580 */
struct yaz_iconv_trie_flat marc8_31page580_flat[] = {
  {"\x35", 0, 0x85AC}, /* East Asian ideograph */
  {"\x52", 0, 0x87C1}, /* East Asian ideograph */
  {"\x7C", 0, 0x8671}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page580 = {
  marc8_31page580_flat, 0
};
/* PAGE 579 */
struct yaz_iconv_trie_flat marc8_31page579_flat[] = {
  {"\x61", 0, 0x8462}, /* East Asian ideograph */
  {"\x68", 0, 0x8406}, /* East Asian ideograph */
  {"\x77", 0, 0x8602}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page579 = {
  marc8_31page579_flat, 0
};
/* PAGE 578 */
struct yaz_iconv_trie_flat marc8_31page578_flat[] = {
  {"\x45", 0, 0x67C1}, /* East Asian ideograph */
  {"\x46", 0, 0x8221}, /* East Asian ideograph */
  {"\x61", 0, 0x6CD6}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page578 = {
  marc8_31page578_flat, 0
};
/* PAGE 577 */
struct yaz_iconv_trie_flat marc8_31page577_flat[] = {
  {"\x33", 0, 0x80BB}, /* East Asian ideograph */
  {"\x47", 0, 0x81D9}, /* East Asian ideograph */
  {"\x7D", 0, 0x9AD5}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page577 = {
  marc8_31page577_flat, 0
};
/* PAGE 576 */
struct yaz_iconv_trie_flat marc8_31page576_flat[] = {
  {"\x23", 0, 0x7E8E}, /* East Asian ideograph */
  {"\x28", 0, 0x94B5}, /* East Asian ideograph */
  {"\x30", 0, 0x7F6E}, /* East Asian ideograph (variant of EACC 215230) */
  {"\x34", 0, 0x99E1}, /* East Asian ideograph */
  {"\x38", 0, 0x8989}, /* East Asian ideograph */
  {"\x3F", 0, 0x8B71}, /* East Asian ideograph */
  {"\x59", 0, 0x7E59}, /* East Asian ideograph */
  {"\x5B", 0, 0x71FF}, /* East Asian ideograph */
  {"\x76", 0, 0x8061}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page576 = {
  marc8_31page576_flat, 0
};
/* PAGE 575 */
struct yaz_iconv_trie_flat marc8_31page575_flat[] = {
  {"\x2E", 0, 0x7E8D}, /* East Asian ideograph */
  {"\x3C", 0, 0x7D4C}, /* East Asian ideograph */
  {"\x47", 0, 0x7EEE}, /* East Asian ideograph */
  {"\x4C", 0, 0x7DD1}, /* East Asian ideograph */
  {"\x5C", 0, 0x7DAB}, /* East Asian ideograph */
  {"\x6B", 0, 0x7DD0}, /* East Asian ideograph */
  {"\x6D", 0, 0x6374}, /* East Asian ideograph */
  {"\x72", 0, 0x7D89}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page575 = {
  marc8_31page575_flat, 0
};
/* PAGE 574 */
struct yaz_iconv_trie_flat marc8_31page574_flat[] = {
  {"\x2A", 0, 0x9257}, /* East Asian ideograph */
  {"\x2B", 0, 0x724B}, /* East Asian ideograph */
  {"\x65", 0, 0x7A45}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page574 = {
  marc8_31page574_flat, 0
};
/* PAGE 573 */
struct yaz_iconv_trie_flat marc8_31page573_flat[] = {
  {"\x37", 0, 0x5EE9}, /* East Asian ideograph */
  {"\x3A", 0, 0x7A49}, /* East Asian ideograph */
  {"\x59", 0, 0x7A93}, /* East Asian ideograph */
  {"\x5E", 0, 0x7A91}, /* East Asian ideograph */
  {"\x71", 0, 0x54B2}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page573 = {
  marc8_31page573_flat, 0
};
/* PAGE 572 */
struct yaz_iconv_trie_flat marc8_31page572_flat[] = {
  {"\x37", 0, 0x784E}, /* East Asian ideograph */
  {"\x73", 0, 0x79A5}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page572 = {
  marc8_31page572_flat, 0
};
/* PAGE 571 */
struct yaz_iconv_trie_flat marc8_31page571_flat[] = {
  {"\x2C", 0, 0x754D}, /* East Asian ideograph */
  {"\x36", 0, 0x753B}, /* East Asian ideograph (variant of EACC 274C36) */
  {"\x37", 0, 0x8E6F}, /* East Asian ideograph */
  {"\x3E", 0, 0x8E08}, /* East Asian ideograph */
  {"\x7B", 0, 0x767A}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page571 = {
  marc8_31page571_flat, 0
};
/* PAGE 570 */
struct yaz_iconv_trie_flat marc8_31page570_flat[] = {
  {"\x28", 0, 0x91BC}, /* East Asian ideograph */
  {"\x58", 0, 0x89DD}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page570 = {
  marc8_31page570_flat, 0
};
/* PAGE 569 */
struct yaz_iconv_trie_flat marc8_31page569_flat[] = {
  {"\x2E", 0, 0x6F81}, /* East Asian ideograph */
  {"\x4A", 0, 0x70D6}, /* East Asian ideograph */
  {"\x68", 0, 0x7133}, /* East Asian ideograph */
  {"\x6A", 0, 0x934A}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page569 = {
  marc8_31page569_flat, 0
};
/* PAGE 568 */
struct yaz_iconv_trie_flat marc8_31page568_flat[] = {
  {"\x3B", 0, 0x6CDD}, /* East Asian ideograph */
  {"\x5E", 0, 0x67D2}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page568 = {
  marc8_31page568_flat, 0
};
/* PAGE 567 */
struct yaz_iconv_trie_flat marc8_31page567_flat[] = {
  {"\x29", 0, 0x6E2B}, /* East Asian ideograph */
  {"\x30", 0, 0x6E5F}, /* East Asian ideograph */
  {"\x40", 0, 0x6D1A}, /* East Asian ideograph */
  {"\x4A", 0, 0x6D1F}, /* East Asian ideograph */
  {"\x55", 0, 0x6FEC}, /* East Asian ideograph */
  {"\x5E", 0, 0x6FB9}, /* East Asian ideograph */
  {"\x5F", 0, 0x60BD}, /* East Asian ideograph */
  {"\x6F", 0, 0x6D44}, /* East Asian ideograph */
  {"\x70", 0, 0x5A6C}, /* East Asian ideograph */
  {"\x7B", 0, 0x904A}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page567 = {
  marc8_31page567_flat, 0
};
/* PAGE 566 */
struct yaz_iconv_trie_flat marc8_31page566_flat[] = {
  {"\x21", 0, 0x8B99}, /* East Asian ideograph */
  {"\x33", 0, 0x6B8B}, /* East Asian ideograph (variant of EACC 274633) */
  {"\x3C", 0, 0x6BBB}, /* East Asian ideograph */
  {"\x65", 0, 0x6C61}, /* East Asian ideograph */
  {"\x74", 0, 0x76C5}, /* East Asian ideograph */
  {"\x7A", 0, 0x6CA1}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page566 = {
  marc8_31page566_flat, 0
};
/* PAGE 565 */
struct yaz_iconv_trie_flat marc8_31page565_flat[] = {
  {"\x27", 0, 0x6918}, /* East Asian ideograph */
  {"\x50", 0, 0x7F47}, /* East Asian ideograph */
  {"\x6D", 0, 0x826A}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page565 = {
  marc8_31page565_flat, 0
};
/* PAGE 564 */
struct yaz_iconv_trie_flat marc8_31page564_flat[] = {
  {"\x25", 0, 0x76C3}, /* East Asian ideograph */
  {"\x49", 0, 0x6144}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page564 = {
  marc8_31page564_flat, 0
};
/* PAGE 563 */
struct yaz_iconv_trie_flat marc8_31page563_flat[] = {
  {"\x2F", 0, 0x664B}, /* East Asian ideograph */
  {"\x3E", 0, 0x95C7}, /* East Asian ideograph */
  {"\x42", 0, 0x7156}, /* East Asian ideograph */
  {"\x57", 0, 0x6702}, /* East Asian ideograph */
  {"\x69", 0, 0x5932}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page563 = {
  marc8_31page563_flat, 0
};
/* PAGE 562 */
struct yaz_iconv_trie_flat marc8_31page562_flat[] = {
  {"\x2A", 0, 0x62E1}, /* East Asian ideograph */
  {"\x3D", 0, 0x53CE}, /* East Asian ideograph */
  {"\x43", 0, 0x52B9}, /* East Asian ideograph */
  {"\x44", 0, 0x6559}, /* East Asian ideograph */
  {"\x56", 0, 0x6B5B}, /* East Asian ideograph */
  {"\x60", 0, 0x89D4}, /* East Asian ideograph */
  {"\x77", 0, 0x65EF}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page562 = {
  marc8_31page562_flat, 0
};
/* PAGE 561 */
struct yaz_iconv_trie_flat marc8_31page561_flat[] = {
  {"\x31", 0, 0x6425}, /* East Asian ideograph */
  {"\x7E", 0, 0x629E}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page561 = {
  marc8_31page561_flat, 0
};
/* PAGE 560 */
struct yaz_iconv_trie_flat marc8_31page560_flat[] = {
  {"\x45", 0, 0x629B}, /* East Asian ideograph */
  {"\x50", 0, 0x62D5}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page560 = {
  marc8_31page560_flat, 0
};
/* PAGE 559 */
struct yaz_iconv_trie_flat marc8_31page559_flat[] = {
  {"\x22", 0, 0x6168}, /* East Asian ideograph (variant of EACC 213F22) */
  {"\x24", 0, 0x7718}, /* East Asian ideograph */
  {"\x3F", 0, 0x51F4}, /* East Asian ideograph */
  {"\x55", 0, 0x5B3E}, /* East Asian ideograph */
  {"\x58", 0, 0x61F4}, /* East Asian ideograph */
  {"\x5B", 0, 0x6133}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page559 = {
  marc8_31page559_flat, 0
};
/* PAGE 558 */
struct yaz_iconv_trie_flat marc8_31page558_flat[] = {
  {"\x7D", 0, 0x7652}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page558 = {
  marc8_31page558_flat, 0
};
/* PAGE 557 */
struct yaz_iconv_trie_flat marc8_31page557_flat[] = {
  {"\x28", 0, 0x53A8}, /* East Asian ideograph */
  {"\x2A", 0, 0x5E83}, /* East Asian ideograph */
  {"\x2F", 0, 0x5E81}, /* East Asian ideograph */
  {"\x42", 0, 0x7D43}, /* East Asian ideograph */
  {"\x48", 0, 0x5F3A}, /* East Asian ideograph */
  {"\x4C", 0, 0x7030}, /* East Asian ideograph */
  {"\x54", 0, 0x4EFD}, /* East Asian ideograph */
  {"\x75", 0, 0x5FB3}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page557 = {
  marc8_31page557_flat, 0
};
/* PAGE 556 */
struct yaz_iconv_trie_flat marc8_31page556_flat[] = {
  {"\x21", 0, 0x7895}, /* East Asian ideograph */
  {"\x52", 0, 0x8CEC}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page556 = {
  marc8_31page556_flat, 0
};
/* PAGE 555 */
struct yaz_iconv_trie_flat marc8_31page555_flat[] = {
  {"\x2F", 0, 0x9029}, /* East Asian ideograph */
  {"\x44", 0, 0x5B2D}, /* East Asian ideograph */
  {"\x63", 0, 0x59C9}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page555 = {
  marc8_31page555_flat, 0
};
/* PAGE 554 */
struct yaz_iconv_trie_flat marc8_31page554_flat[] = {
  {"\x6E", 0, 0x576F}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page554 = {
  marc8_31page554_flat, 0
};
/* PAGE 553 */
struct yaz_iconv_trie_flat marc8_31page553_flat[] = {
  {"\x68", 0, 0x8FF4}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page553 = {
  marc8_31page553_flat, 0
};
/* PAGE 552 */
struct yaz_iconv_trie_flat marc8_31page552_flat[] = {
  {"\x23", 0, 0x9F69}, /* East Asian ideograph */
  {"\x2A", 0, 0x9B28}, /* East Asian ideograph */
  {"\x42", 0, 0x8A92}, /* East Asian ideograph */
  {"\x5A", 0, 0x5405}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page552 = {
  marc8_31page552_flat, 0
};
/* PAGE 551 */
struct yaz_iconv_trie_flat marc8_31page551_flat[] = {
  {"\x29", 0, 0x53DC}, /* East Asian ideograph */
  {"\x4E", 0, 0x608B}, /* East Asian ideograph */
  {"\x56", 0, 0x9A03}, /* East Asian ideograph */
  {"\x5C", 0, 0x5449}, /* East Asian ideograph */
  {"\x64", 0, 0x5415}, /* East Asian ideograph */
  {"\x73", 0, 0x8656}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page551 = {
  marc8_31page551_flat, 0
};
/* PAGE 550 */
struct yaz_iconv_trie_flat marc8_31page550_flat[] = {
  {"\x21", 0, 0x91FC}, /* East Asian ideograph */
  {"\x23", 0, 0x5264}, /* East Asian ideograph */
  {"\x28", 0, 0x523C}, /* East Asian ideograph */
  {"\x75", 0, 0x9628}, /* East Asian ideograph */
  {"\x7D", 0, 0x53C1}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page550 = {
  marc8_31page550_flat, 0
};
/* PAGE 549 */
struct yaz_iconv_trie_flat marc8_31page549_flat[] = {
  {"\x23", 0, 0x4E21}, /* East Asian ideograph */
  {"\x2A", 0, 0x4E93}, /* East Asian ideograph */
  {"\x30", 0, 0x518A}, /* East Asian ideograph */
  {"\x3C", 0, 0x6C37}, /* East Asian ideograph */
  {"\x44", 0, 0x51DB}, /* East Asian ideograph */
  {"\x4E", 0, 0x51FE}, /* East Asian ideograph */
  {"\x77", 0, 0x5270}, /* East Asian ideograph */
  {"\x7B", 0, 0x52E6}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page549 = {
  marc8_31page549_flat, 0
};
/* PAGE 548 */
struct yaz_iconv_trie_flat marc8_31page548_flat[] = {
  {"\x40", 0, 0x4FFB}, /* East Asian ideograph */
  {"\x51", 0, 0x5FBA}, /* East Asian ideograph */
  {"\x5D", 0, 0x4FA1}, /* East Asian ideograph */
  {"\x7A", 0, 0x5150}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page548 = {
  marc8_31page548_flat, 0
};
/* PAGE 547 */
struct yaz_iconv_trie_flat marc8_31page547_flat[] = {
  {"\x4C", 0, 0x5FA0}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page547 = {
  marc8_31page547_flat, 0
};
/* PAGE 546 */
struct yaz_iconv_trie_flat marc8_31page546_flat[] = {
  {"\x21", 0, 0x58F9}, /* East Asian ideograph */
  {"\x3A", 0, 0x8FFA}, /* East Asian ideograph */
  {"\x4C", 0, 0x4E79}, /* East Asian ideograph */
  {"\x51", 0, 0x8CB3}, /* East Asian ideograph */
  {"\x60", 0, 0x4EAF}, /* East Asian ideograph */
  {"\x66", 0, 0x5FC8}, /* East Asian ideograph */
  {"\x6C", 0, 0x8B90}, /* East Asian ideograph */
  {"\x78", 0, 0x5F77}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page546 = {
  marc8_31page546_flat, 0
};
/* PAGE 545 */
struct yaz_iconv_trie_dir marc8_31page545_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {547, 0, 0},
  {548, 0, 0},
  {549, 0, 0},
  {550, 0, 0},
  {551, 0, 0},
  {552, 0, 0},
  {553, 0, 0},
  {554, 0, 0},
  {555, 0, 0},
  {556, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {557, 0, 0},
  {558, 0, 0},
  {559, 0, 0},
  {560, 0, 0},
  {561, 0, 0},
  {562, 0, 0},
  {563, 0, 0},
  {564, 0, 0},
  {565, 0, 0},
  {566, 0, 0},
  {567, 0, 0},
  {568, 0, 0},
  {569, 0, 0},
  {570, 0, 0},
  {571, 0, 0},
  {0, 0, 0},
  {572, 0, 0},
  {0, 0, 0},
  {573, 0, 0},
  {574, 0, 0},
  {575, 0, 0},
  {576, 0, 0},
  {577, 0, 0},
  {578, 0, 0},
  {579, 0, 0},
  {580, 0, 0},
  {581, 0, 0},
  {582, 0, 0},
  {583, 0, 0},
  {584, 0, 0},
  {585, 0, 0},
  {586, 0, 0},
  {0, 0, 0},
  {587, 0, 0},
  {588, 0, 0},
  {589, 0, 0},
  {590, 0, 0},
  {591, 0, 0},
  {592, 0, 0},
  {593, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {594, 0, 0},
  {595, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {596, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8_31page545 = {
  0, marc8_31page545_dir
};
/* PAGE 544 */
struct yaz_iconv_trie_flat marc8_31page544_flat[] = {
  {"\x25\x2D", 0, 0x6A22}, /* East Asian ideograph */
  {"\x25\x2E", 0, 0x8507}, /* East Asian ideograph */
  {"\x2A\x5A", 0, 0x868B}, /* East Asian ideograph (unrelated variant of EACC 23293D) */
  {"\x2A\x64", 0, 0x87B5}, /* East Asian ideograph */
  {"\x2A\x73", 0, 0x87CA}, /* East Asian ideograph */
  {"\x2D\x79", 0, 0x88B5}, /* East Asian ideograph */
  {"\x2F\x5D", 0, 0x7E48}, /* East Asian ideograph */
  {"\x31\x2B", 0, 0x89BB}, /* East Asian ideograph */
  {"\x31\x43", 0, 0x89F5}, /* East Asian ideograph (unrelated variant of EACC 23315E) */
  {"\x31\x7D", 0, 0x8A7E}, /* East Asian ideograph */
  {"\x33\x63", 0, 0x8B1A}, /* East Asian ideograph */
  {"\x36\x39", 0, 0x8C7C}, /* East Asian ideograph */
  {"\x38\x33", 0, 0x8D91}, /* East Asian ideograph */
  {"\x38\x6F", 0, 0x8DD7}, /* East Asian ideograph */
  {"\x3A\x5E", 0, 0x8E6E}, /* East Asian ideograph */
  {"\x3B\x63", 0, 0x5E32}, /* East Asian ideograph */
  {"\x3C\x2D", 0, 0x8F3C}, /* East Asian ideograph */
  {"\x3D\x5D", 0, 0x900E}, /* East Asian ideograph */
  {"\x40\x53", 0, 0x914F}, /* East Asian ideograph */
  {"\x42\x31", 0, 0x8019}, /* East Asian ideograph (unrelated variant of EACC 215266) */
  {"\x44\x5F", 0, 0x941A}, /* East Asian ideograph */
  {"\x4A\x2E", 0, 0x90B4}, /* East Asian ideograph */
  {"\x4A\x4A", 0, 0x5F8F}, /* East Asian ideograph */
  {"\x51\x58", 0, 0x7CC7}, /* East Asian ideograph */
  {"\x54\x76", 0, 0x9AE1}, /* East Asian ideograph */
  {"\x57\x5F", 0, 0x9ABE}, /* East Asian ideograph */
  {"\x58\x5C", 0, 0x9C51}, /* East Asian ideograph (unrelated variant of EACC 235945) */
  {"\x58\x70", 0, 0x9C1B}, /* East Asian ideograph */
  {"\x59\x73", 0, 0x9CEC}, /* East Asian ideograph */
  {"\x5A\x48", 0, 0x9D44}, /* East Asian ideograph */
  {"\x5D\x3C", 0, 0x6EF7}, /* East Asian ideograph */
  {"\x5D\x49", 0, 0x9EA4}, /* East Asian ideograph */
  {"\x5D\x5C", 0, 0x730A}, /* East Asian ideograph */
  {"\x5E\x42", 0, 0x9EC9}, /* East Asian ideograph */
  {"\x5E\x66", 0, 0x9B12}, /* East Asian ideograph */
  {"\x5E\x7D", 0, 0x6641}, /* East Asian ideograph */
  {"\x5F\x45", 0, 0x86A1}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page544 = {
  marc8_31page544_flat, 0
};
/* PAGE 543 */
struct yaz_iconv_trie_flat marc8_31page543_flat[] = {
  {"\x24", 0, 0x83F0}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page543 = {
  marc8_31page543_flat, 0
};
/* PAGE 542 */
struct yaz_iconv_trie_flat marc8_31page542_flat[] = {
  {"\x2E", 0, 0x831C}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page542 = {
  marc8_31page542_flat, 0
};
/* PAGE 541 */
struct yaz_iconv_trie_flat marc8_31page541_flat[] = {
  {"\x5F", 0, 0x8037}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page541 = {
  marc8_31page541_flat, 0
};
/* PAGE 540 */
struct yaz_iconv_trie_flat marc8_31page540_flat[] = {
  {"\x2E", 0, 0x7516}, /* East Asian ideograph */
  {"\x31", 0, 0x7F48}, /* East Asian ideograph */
  {"\x50", 0, 0x7F82}, /* East Asian ideograph */
  {"\x51", 0, 0x7F58}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page540 = {
  marc8_31page540_flat, 0
};
/* PAGE 539 */
struct yaz_iconv_trie_flat marc8_31page539_flat[] = {
  {"\x28", 0, 0x5FAD}, /* East Asian ideograph */
  {"\x5D", 0, 0x7D56}, /* East Asian ideograph */
  {"\x74", 0, 0x7E89}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page539 = {
  marc8_31page539_flat, 0
};
/* PAGE 538 */
struct yaz_iconv_trie_flat marc8_31page538_flat[] = {
  {"\x5A", 0, 0x7E27}, /* East Asian ideograph */
  {"\x7C", 0, 0x7D63}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page538 = {
  marc8_31page538_flat, 0
};
/* PAGE 537 */
struct yaz_iconv_trie_flat marc8_31page537_flat[] = {
  {"\x62", 0, 0x7D4F}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page537 = {
  marc8_31page537_flat, 0
};
/* PAGE 536 */
struct yaz_iconv_trie_flat marc8_31page536_flat[] = {
  {"\x35", 0, 0x6CD4}, /* East Asian ideograph */
  {"\x43", 0, 0x9908}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page536 = {
  marc8_31page536_flat, 0
};
/* PAGE 535 */
struct yaz_iconv_trie_flat marc8_31page535_flat[] = {
  {"\x26", 0, 0x7BE0}, /* East Asian ideograph */
  {"\x27", 0, 0x7B2E}, /* East Asian ideograph */
  {"\x3E", 0, 0x7B59}, /* East Asian ideograph */
  {"\x46", 0, 0x7BE6}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page535 = {
  marc8_31page535_flat, 0
};
/* PAGE 534 */
struct yaz_iconv_trie_flat marc8_31page534_flat[] = {
  {"\x54", 0, 0x7B04}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page534 = {
  marc8_31page534_flat, 0
};
/* PAGE 533 */
struct yaz_iconv_trie_flat marc8_31page533_flat[] = {
  {"\x4E", 0, 0x8020}, /* East Asian ideograph */
  {"\x6F", 0, 0x7A19}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page533 = {
  marc8_31page533_flat, 0
};
/* PAGE 532 */
struct yaz_iconv_trie_flat marc8_31page532_flat[] = {
  {"\x4F", 0, 0x772D}, /* East Asian ideograph */
  {"\x5F", 0, 0x77C1}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page532 = {
  marc8_31page532_flat, 0
};
/* PAGE 531 */
struct yaz_iconv_trie_flat marc8_31page531_flat[] = {
  {"\x4A", 0, 0x7690}, /* East Asian ideograph */
  {"\x60", 0, 0x76A1}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page531 = {
  marc8_31page531_flat, 0
};
/* PAGE 530 */
struct yaz_iconv_trie_flat marc8_31page530_flat[] = {
  {"\x6F", 0, 0x75B8}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page530 = {
  marc8_31page530_flat, 0
};
/* PAGE 529 */
struct yaz_iconv_trie_flat marc8_31page529_flat[] = {
  {"\x40", 0, 0x73B3}, /* East Asian ideograph */
  {"\x78", 0, 0x74A2}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page529 = {
  marc8_31page529_flat, 0
};
/* PAGE 528 */
struct yaz_iconv_trie_flat marc8_31page528_flat[] = {
  {"\x52", 0, 0x71FE}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page528 = {
  marc8_31page528_flat, 0
};
/* PAGE 527 */
struct yaz_iconv_trie_flat marc8_31page527_flat[] = {
  {"\x5D", 0, 0x715B}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page527 = {
  marc8_31page527_flat, 0
};
/* PAGE 526 */
struct yaz_iconv_trie_flat marc8_31page526_flat[] = {
  {"\x6D", 0, 0x70B1}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page526 = {
  marc8_31page526_flat, 0
};
/* PAGE 525 */
struct yaz_iconv_trie_flat marc8_31page525_flat[] = {
  {"\x41", 0, 0x7032}, /* East Asian ideograph */
  {"\x56", 0, 0x9800}, /* East Asian ideograph */
  {"\x5D", 0, 0x6DE0}, /* East Asian ideograph */
  {"\x72", 0, 0x6F74}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page525 = {
  marc8_31page525_flat, 0
};
/* PAGE 524 */
struct yaz_iconv_trie_flat marc8_31page524_flat[] = {
  {"\x3D", 0, 0x6D38}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page524 = {
  marc8_31page524_flat, 0
};
/* PAGE 523 */
struct yaz_iconv_trie_flat marc8_31page523_flat[] = {
  {"\x35", 0, 0x6DE5}, /* East Asian ideograph */
  {"\x7B", 0, 0x6E86}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page523 = {
  marc8_31page523_flat, 0
};
/* PAGE 522 */
struct yaz_iconv_trie_flat marc8_31page522_flat[] = {
  {"\x6B", 0, 0x6EA6}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page522 = {
  marc8_31page522_flat, 0
};
/* PAGE 521 */
struct yaz_iconv_trie_flat marc8_31page521_flat[] = {
  {"\x2F", 0, 0x6CD9}, /* East Asian ideograph */
  {"\x3B", 0, 0x6E7C}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page521 = {
  marc8_31page521_flat, 0
};
/* PAGE 520 */
struct yaz_iconv_trie_flat marc8_31page520_flat[] = {
  {"\x73", 0, 0x6FA3}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page520 = {
  marc8_31page520_flat, 0
};
/* PAGE 519 */
struct yaz_iconv_trie_flat marc8_31page519_flat[] = {
  {"\x31", 0, 0x6C73}, /* East Asian ideograph */
  {"\x39", 0, 0x6C67}, /* East Asian ideograph (variant of EACC 224739) */
  {"\x47", 0, 0x6D64}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page519 = {
  marc8_31page519_flat, 0
};
/* PAGE 518 */
struct yaz_iconv_trie_flat marc8_31page518_flat[] = {
  {"\x70", 0, 0x6CD0}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page518 = {
  marc8_31page518_flat, 0
};
/* PAGE 517 */
struct yaz_iconv_trie_flat marc8_31page517_flat[] = {
  {"\x74", 0, 0x6AA9}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page517 = {
  marc8_31page517_flat, 0
};
/* PAGE 516 */
struct yaz_iconv_trie_flat marc8_31page516_flat[] = {
  {"\x3D", 0, 0x6AC1}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page516 = {
  marc8_31page516_flat, 0
};
/* PAGE 515 */
struct yaz_iconv_trie_flat marc8_31page515_flat[] = {
  {"\x2D", 0, 0x69B2}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page515 = {
  marc8_31page515_flat, 0
};
/* PAGE 514 */
struct yaz_iconv_trie_flat marc8_31page514_flat[] = {
  {"\x3F", 0, 0x7BA0}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page514 = {
  marc8_31page514_flat, 0
};
/* PAGE 513 */
struct yaz_iconv_trie_flat marc8_31page513_flat[] = {
  {"\x62", 0, 0x684A}, /* East Asian ideograph */
  {"\x73", 0, 0x7A1C}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page513 = {
  marc8_31page513_flat, 0
};
/* PAGE 512 */
struct yaz_iconv_trie_flat marc8_31page512_flat[] = {
  {"\x22", 0, 0x690F}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page512 = {
  marc8_31page512_flat, 0
};
/* PAGE 511 */
struct yaz_iconv_trie_flat marc8_31page511_flat[] = {
  {"\x26", 0, 0x661D}, /* East Asian ideograph */
  {"\x33", 0, 0x80AD}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page511 = {
  marc8_31page511_flat, 0
};
/* PAGE 510 */
struct yaz_iconv_trie_flat marc8_31page510_flat[] = {
  {"\x36", 0, 0x66CD}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page510 = {
  marc8_31page510_flat, 0
};
/* PAGE 509 */
struct yaz_iconv_trie_flat marc8_31page509_flat[] = {
  {"\x70", 0, 0x714A}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page509 = {
  marc8_31page509_flat, 0
};
/* PAGE 508 */
struct yaz_iconv_trie_flat marc8_31page508_flat[] = {
  {"\x29", 0, 0x65B5}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page508 = {
  marc8_31page508_flat, 0
};
/* PAGE 507 */
struct yaz_iconv_trie_flat marc8_31page507_flat[] = {
  {"\x3F", 0, 0x52C5}, /* East Asian ideograph */
  {"\x45", 0, 0x69E3}, /* East Asian ideograph */
  {"\x54", 0, 0x657F}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page507 = {
  marc8_31page507_flat, 0
};
/* PAGE 506 */
struct yaz_iconv_trie_flat marc8_31page506_flat[] = {
  {"\x28", 0, 0x6528}, /* East Asian ideograph */
  {"\x7B", 0, 0x630E}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page506 = {
  marc8_31page506_flat, 0
};
/* PAGE 505 */
struct yaz_iconv_trie_flat marc8_31page505_flat[] = {
  {"\x3A", 0, 0x6332}, /* East Asian ideograph */
  {"\x44", 0, 0x651F}, /* East Asian ideograph */
  {"\x72", 0, 0x5261}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page505 = {
  marc8_31page505_flat, 0
};
/* PAGE 504 */
struct yaz_iconv_trie_flat marc8_31page504_flat[] = {
  {"\x28", 0, 0x640B}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page504 = {
  marc8_31page504_flat, 0
};
/* PAGE 503 */
struct yaz_iconv_trie_flat marc8_31page503_flat[] = {
  {"\x7A", 0, 0x6738}, /* East Asian ideograph */
  {"\x7C", 0, 0x634D}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page503 = {
  marc8_31page503_flat, 0
};
/* PAGE 502 */
struct yaz_iconv_trie_flat marc8_31page502_flat[] = {
  {"\x79", 0, 0x6128}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page502 = {
  marc8_31page502_flat, 0
};
/* PAGE 501 */
struct yaz_iconv_trie_flat marc8_31page501_flat[] = {
  {"\x5B", 0, 0x605A}, /* East Asian ideograph */
  {"\x74", 0, 0x609B}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page501 = {
  marc8_31page501_flat, 0
};
/* PAGE 500 */
struct yaz_iconv_trie_flat marc8_31page500_flat[] = {
  {"\x68", 0, 0x5F51}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page500 = {
  marc8_31page500_flat, 0
};
/* PAGE 499 */
struct yaz_iconv_trie_flat marc8_31page499_flat[] = {
  {"\x4C", 0, 0x5ECF}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page499 = {
  marc8_31page499_flat, 0
};
/* PAGE 498 */
struct yaz_iconv_trie_flat marc8_31page498_flat[] = {
  {"\x7B", 0, 0x5D1F}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page498 = {
  marc8_31page498_flat, 0
};
/* PAGE 497 */
struct yaz_iconv_trie_dir marc8_31page497_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {499, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {500, 0, 0},
  {501, 0, 0},
  {0, 0, 0},
  {502, 0, 0},
  {0, 0, 0},
  {503, 0, 0},
  {0, 0, 0},
  {504, 0, 0},
  {505, 0, 0},
  {506, 0, 0},
  {0, 0, 0},
  {507, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {508, 0, 0},
  {509, 0, 0},
  {510, 0, 0},
  {511, 0, 0},
  {512, 0, 0},
  {513, 0, 0},
  {0, 0, 0},
  {514, 0, 0},
  {515, 0, 0},
  {516, 0, 0},
  {517, 0, 0},
  {518, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {519, 0, 0},
  {520, 0, 0},
  {521, 0, 0},
  {522, 0, 0},
  {523, 0, 0},
  {0, 0, 0},
  {524, 0, 0},
  {525, 0, 0},
  {526, 0, 0},
  {0, 0, 0},
  {527, 0, 0},
  {0, 0, 0},
  {528, 0, 0},
  {0, 0, 0},
  {529, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {530, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {531, 0, 0},
  {532, 0, 0},
  {0, 0, 0},
  {533, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {534, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {535, 0, 0},
  {536, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {537, 0, 0},
  {538, 0, 0},
  {539, 0, 0},
  {0, 0, 0},
  {540, 0, 0},
  {541, 0, 0},
  {0, 0, 0},
  {542, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {543, 0, 0},
  {544, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8_31page497 = {
  0, marc8_31page497_dir
};
/* PAGE 496 */
struct yaz_iconv_trie_flat marc8_31page496_flat[] = {
  {"\x6A", 0, 0x51A4}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page496 = {
  marc8_31page496_flat, 0
};
/* PAGE 495 */
struct yaz_iconv_trie_flat marc8_31page495_flat[] = {
  {"\x44", 0, 0x598D}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page495 = {
  marc8_31page495_flat, 0
};
/* PAGE 494 */
struct yaz_iconv_trie_flat marc8_31page494_flat[] = {
  {"\x3A", 0, 0x9654}, /* East Asian ideograph */
  {"\x52", 0, 0x579B}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page494 = {
  marc8_31page494_flat, 0
};
/* PAGE 493 */
struct yaz_iconv_trie_flat marc8_31page493_flat[] = {
  {"\x45", 0, 0x56D3}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page493 = {
  marc8_31page493_flat, 0
};
/* PAGE 492 */
struct yaz_iconv_trie_flat marc8_31page492_flat[] = {
  {"\x43", 0, 0x55E2}, /* East Asian ideograph */
  {"\x64", 0, 0x55D4}, /* East Asian ideograph (variant of EACC 217164) */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page492 = {
  marc8_31page492_flat, 0
};
/* PAGE 491 */
struct yaz_iconv_trie_flat marc8_31page491_flat[] = {
  {"\x7D", 0, 0x8123}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page491 = {
  marc8_31page491_flat, 0
};
/* PAGE 490 */
struct yaz_iconv_trie_flat marc8_31page490_flat[] = {
  {"\x33", 0, 0x5231}, /* East Asian ideograph */
  {"\x5F", 0, 0x5273}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page490 = {
  marc8_31page490_flat, 0
};
/* PAGE 489 */
struct yaz_iconv_trie_flat marc8_31page489_flat[] = {
  {"\x2B", 0, 0x5C28}, /* East Asian ideograph */
  {"\x2D", 0, 0x4E80}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page489 = {
  marc8_31page489_flat, 0
};
/* PAGE 488 */
struct yaz_iconv_trie_flat marc8_31page488_flat[] = {
  {"\x22", 0, 0x9C0C}, /* East Asian ideograph */
  {"\x29", 0, 0x9C53}, /* East Asian ideograph */
  {"\x2C", 0, 0x9F08}, /* East Asian ideograph */
  {"\x35", 0, 0x9D76}, /* East Asian ideograph */
  {"\x41", 0, 0x9D5E}, /* East Asian ideograph */
  {"\x51", 0, 0x5869}, /* East Asian ideograph */
  {"\x52", 0, 0x78B1}, /* East Asian ideograph */
  {"\x5F", 0, 0x83FB}, /* East Asian ideograph */
  {"\x60", 0, 0x5E85}, /* East Asian ideograph */
  {"\x62", 0, 0x9EC4}, /* East Asian ideograph */
  {"\x75", 0, 0x76B7}, /* East Asian ideograph */
  {"\x7E", 0, 0x658B}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page488 = {
  marc8_31page488_flat, 0
};
/* PAGE 487 */
struct yaz_iconv_trie_flat marc8_31page487_flat[] = {
  {"\x32", 0, 0x99EE}, /* East Asian ideograph */
  {"\x34", 0, 0x99DE}, /* East Asian ideograph */
  {"\x47", 0, 0x99C8}, /* East Asian ideograph */
  {"\x59", 0, 0x9AC4}, /* East Asian ideograph */
  {"\x5A", 0, 0x8EC6}, /* East Asian ideograph */
  {"\x62", 0, 0x9A0C}, /* East Asian ideograph */
  {"\x6A", 0, 0x6B1D}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page487 = {
  marc8_31page487_flat, 0
};
/* PAGE 486 */
struct yaz_iconv_trie_flat marc8_31page486_flat[] = {
  {"\x21", 0, 0x978C}, /* East Asian ideograph */
  {"\x2D", 0, 0x976D}, /* East Asian ideograph */
  {"\x30", 0, 0x97EE}, /* East Asian ideograph */
  {"\x56", 0, 0x980B}, /* East Asian ideograph */
  {"\x78", 0, 0x9920}, /* East Asian ideograph */
  {"\x79", 0, 0x8218}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page486 = {
  marc8_31page486_flat, 0
};
/* PAGE 485 */
struct yaz_iconv_trie_flat marc8_31page485_flat[] = {
  {"\x28", 0, 0x9665}, /* East Asian ideograph */
  {"\x2C", 0, 0x5826}, /* East Asian ideograph */
  {"\x2D", 0, 0x964F}, /* East Asian ideograph */
  {"\x2E", 0, 0x661C}, /* East Asian ideograph */
  {"\x35", 0, 0x78D2}, /* East Asian ideograph */
  {"\x3B", 0, 0x96A0}, /* East Asian ideograph */
  {"\x43", 0, 0x9CEB}, /* East Asian ideograph */
  {"\x46", 0, 0x96BD}, /* East Asian ideograph */
  {"\x4B", 0, 0x96D1}, /* East Asian ideograph */
  {"\x4C", 0, 0x9DC4}, /* East Asian ideograph */
  {"\x63", 0, 0x873A}, /* East Asian ideograph */
  {"\x73", 0, 0x975A}, /* East Asian ideograph (unrelated variant of EACC 234C76) */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page485 = {
  marc8_31page485_flat, 0
};
/* PAGE 484 */
struct yaz_iconv_trie_flat marc8_31page484_flat[] = {
  {"\x21", 0, 0x9418}, /* East Asian ideograph */
  {"\x24", 0, 0x7145}, /* East Asian ideograph */
  {"\x26", 0, 0x7194}, /* East Asian ideograph */
  {"\x28", 0, 0x93C1}, /* East Asian ideograph */
  {"\x3B", 0, 0x92B9}, /* East Asian ideograph */
  {"\x43", 0, 0x92F3}, /* East Asian ideograph */
  {"\x4A", 0, 0x945A}, /* East Asian ideograph */
  {"\x50", 0, 0x9587}, /* East Asian ideograph */
  {"\x61", 0, 0x6FF6}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page484 = {
  marc8_31page484_flat, 0
};
/* PAGE 483 */
struct yaz_iconv_trie_flat marc8_31page483_flat[] = {
  {"\x23", 0, 0x9167}, /* East Asian ideograph */
  {"\x2F", 0, 0x9196}, /* East Asian ideograph */
  {"\x56", 0, 0x920E}, /* East Asian ideograph */
  {"\x65", 0, 0x8216}, /* East Asian ideograph */
  {"\x68", 0, 0x8021}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page483 = {
  marc8_31page483_flat, 0
};
/* PAGE 482 */
struct yaz_iconv_trie_flat marc8_31page482_flat[] = {
  {"\x2F", 0, 0x8FE8}, /* East Asian ideograph */
  {"\x3F", 0, 0x5FA7}, /* East Asian ideograph */
  {"\x40", 0, 0x5FA8}, /* East Asian ideograph */
  {"\x48", 0, 0x9013}, /* East Asian ideograph */
  {"\x5A", 0, 0x8FE9}, /* East Asian ideograph */
  {"\x5B", 0, 0x9089}, /* East Asian ideograph */
  {"\x74", 0, 0x96A3}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page482 = {
  marc8_31page482_flat, 0
};
/* PAGE 481 */
struct yaz_iconv_trie_flat marc8_31page481_flat[] = {
  {"\x2F", 0, 0x8EB1}, /* East Asian ideograph */
  {"\x42", 0, 0x8F19}, /* East Asian ideograph */
  {"\x43", 0, 0x8EFD}, /* East Asian ideograph */
  {"\x5D", 0, 0x8FA2}, /* East Asian ideograph */
  {"\x5E", 0, 0x8FA7}, /* East Asian ideograph */
  {"\x69", 0, 0x5EF5}, /* East Asian ideograph */
  {"\x7A", 0, 0x8FEF}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page481 = {
  marc8_31page481_flat, 0
};
/* PAGE 480 */
struct yaz_iconv_trie_flat marc8_31page480_flat[] = {
  {"\x34", 0, 0x8CAD}, /* East Asian ideograph */
  {"\x3D", 0, 0x8CDB}, /* East Asian ideograph */
  {"\x48", 0, 0x8D71}, /* East Asian ideograph */
  {"\x4E", 0, 0x8D82}, /* East Asian ideograph */
  {"\x5F", 0, 0x8E5F}, /* East Asian ideograph */
  {"\x63", 0, 0x8DE5}, /* East Asian ideograph */
  {"\x7E", 0, 0x8E7B}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page480 = {
  marc8_31page480_flat, 0
};
/* PAGE 479 */
struct yaz_iconv_trie_flat marc8_31page479_flat[] = {
  {"\x27", 0, 0x8ACC}, /* East Asian ideograph */
  {"\x2C", 0, 0x8B01}, /* East Asian ideograph */
  {"\x3D", 0, 0x8AE9}, /* East Asian ideograph */
  {"\x41", 0, 0x5629}, /* East Asian ideograph */
  {"\x4C", 0, 0x8B72}, /* East Asian ideograph */
  {"\x4F", 0, 0x8B83}, /* East Asian ideograph */
  {"\x57", 0, 0x7AEA}, /* East Asian ideograph */
  {"\x59", 0, 0x8277}, /* East Asian ideograph */
  {"\x5F", 0, 0x732A}, /* East Asian ideograph */
  {"\x60", 0, 0x72B2}, /* East Asian ideograph */
  {"\x63", 0, 0x8C98}, /* East Asian ideograph */
  {"\x65", 0, 0x72F8}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page479 = {
  marc8_31page479_flat, 0
};
/* PAGE 478 */
struct yaz_iconv_trie_flat marc8_31page478_flat[] = {
  {"\x31", 0, 0x89A7}, /* East Asian ideograph */
  {"\x33", 0, 0x752A}, /* East Asian ideograph */
  {"\x36", 0, 0x89E6}, /* East Asian ideograph */
  {"\x4D", 0, 0x548F}, /* East Asian ideograph */
  {"\x56", 0, 0x612C}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page478 = {
  marc8_31page478_flat, 0
};
/* PAGE 477 */
struct yaz_iconv_trie_flat marc8_31page477_flat[] = {
  {"\x2B", 0, 0x8797}, /* East Asian ideograph */
  {"\x2D", 0, 0x8748}, /* East Asian ideograph */
  {"\x30", 0, 0x87C7}, /* East Asian ideograph */
  {"\x3B", 0, 0x60F7}, /* East Asian ideograph */
  {"\x49", 0, 0x885E}, /* East Asian ideograph */
  {"\x58", 0, 0x890E}, /* East Asian ideograph */
  {"\x5B", 0, 0x886E}, /* East Asian ideograph */
  {"\x60", 0, 0x5E2C}, /* East Asian ideograph */
  {"\x63", 0, 0x88E1}, /* East Asian ideograph */
  {"\x73", 0, 0x7D5D}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page477 = {
  marc8_31page477_flat, 0
};
/* PAGE 476 */
struct yaz_iconv_trie_flat marc8_31page476_flat[] = {
  {"\x2E", 0, 0x8024}, /* East Asian ideograph */
  {"\x35", 0, 0x846F}, /* East Asian ideograph */
  {"\x3C", 0, 0x8613}, /* East Asian ideograph */
  {"\x3F", 0, 0x6A97}, /* East Asian ideograph */
  {"\x64", 0, 0x9F04}, /* East Asian ideograph */
  {"\x75", 0, 0x9F05}, /* East Asian ideograph */
  {"\x7B", 0, 0x8717}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page476 = {
  marc8_31page476_flat, 0
};
/* PAGE 475 */
struct yaz_iconv_trie_flat marc8_31page475_flat[] = {
  {"\x29", 0, 0x830E}, /* East Asian ideograph (variant of EACC 275529) */
  {"\x2D", 0, 0x8358}, /* East Asian ideograph */
  {"\x2E", 0, 0x82FA}, /* East Asian ideograph (variant of EACC 227C68) */
  {"\x47", 0, 0x837D}, /* East Asian ideograph */
  {"\x50", 0, 0x585F}, /* East Asian ideograph */
  {"\x54", 0, 0x855A}, /* East Asian ideograph */
  {"\x5A", 0, 0x8386}, /* East Asian ideograph */
  {"\x5B", 0, 0x8385}, /* East Asian ideograph */
  {"\x61", 0, 0x76D6}, /* East Asian ideograph */
  {"\x73", 0, 0x83D4}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page475 = {
  marc8_31page475_flat, 0
};
/* PAGE 474 */
struct yaz_iconv_trie_flat marc8_31page474_flat[] = {
  {"\x21", 0, 0x9AD7}, /* East Asian ideograph */
  {"\x24", 0, 0x5367}, /* East Asian ideograph */
  {"\x34", 0, 0x64E7}, /* East Asian ideograph */
  {"\x40", 0, 0x6841}, /* East Asian ideograph */
  {"\x46", 0, 0x8229}, /* East Asian ideograph */
  {"\x47", 0, 0x824A}, /* East Asian ideograph */
  {"\x61", 0, 0x8306}, /* East Asian ideograph */
  {"\x68", 0, 0x6959}, /* East Asian ideograph */
  {"\x6F", 0, 0x83C0}, /* East Asian ideograph */
  {"\x76", 0, 0x8318}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page474 = {
  marc8_31page474_flat, 0
};
/* PAGE 473 */
struct yaz_iconv_trie_flat marc8_31page473_flat[] = {
  {"\x21", 0, 0x7C9B}, /* East Asian ideograph */
  {"\x23", 0, 0x5B8D}, /* East Asian ideograph */
  {"\x2C", 0, 0x6BD3}, /* East Asian ideograph */
  {"\x40", 0, 0x812C}, /* East Asian ideograph */
  {"\x44", 0, 0x8107}, /* East Asian ideograph */
  {"\x4B", 0, 0x80F7}, /* East Asian ideograph */
  {"\x5E", 0, 0x8193}, /* East Asian ideograph */
  {"\x61", 0, 0x811A}, /* East Asian ideograph */
  {"\x7E", 0, 0x81C8}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page473 = {
  marc8_31page473_flat, 0
};
/* PAGE 472 */
struct yaz_iconv_trie_flat marc8_31page472_flat[] = {
  {"\x28", 0, 0x9262}, /* East Asian ideograph */
  {"\x2B", 0, 0x9475}, /* East Asian ideograph */
  {"\x32", 0, 0x8FA0}, /* East Asian ideograph */
  {"\x33", 0, 0x7F78}, /* East Asian ideograph */
  {"\x38", 0, 0x898A}, /* East Asian ideograph */
  {"\x40", 0, 0x7FA1}, /* East Asian ideograph */
  {"\x41", 0, 0x7FA3}, /* East Asian ideograph */
  {"\x4A", 0, 0x7FC4}, /* East Asian ideograph */
  {"\x59", 0, 0x98DC}, /* East Asian ideograph */
  {"\x5D", 0, 0x6537}, /* East Asian ideograph */
  {"\x65", 0, 0x79D0}, /* East Asian ideograph */
  {"\x67", 0, 0x79CF}, /* East Asian ideograph */
  {"\x6B", 0, 0x7085}, /* East Asian ideograph */
  {"\x6C", 0, 0x8EAD}, /* East Asian ideograph */
  {"\x7B", 0, 0x8074}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page472 = {
  marc8_31page472_flat, 0
};
/* PAGE 471 */
struct yaz_iconv_trie_flat marc8_31page471_flat[] = {
  {"\x24", 0, 0x5E0B}, /* East Asian ideograph */
  {"\x29", 0, 0x7D25}, /* East Asian ideograph */
  {"\x4A", 0, 0x6DD6}, /* East Asian ideograph */
  {"\x4D", 0, 0x7D2C}, /* East Asian ideograph */
  {"\x6A", 0, 0x7DB3}, /* East Asian ideograph */
  {"\x79", 0, 0x7E62}, /* East Asian ideograph */
  {"\x7D", 0, 0x7D99}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page471 = {
  marc8_31page471_flat, 0
};
/* PAGE 470 */
struct yaz_iconv_trie_flat marc8_31page470_flat[] = {
  {"\x2B", 0, 0x693E}, /* East Asian ideograph */
  {"\x2D", 0, 0x7B5D}, /* East Asian ideograph */
  {"\x36", 0, 0x84D1}, /* East Asian ideograph */
  {"\x4F", 0, 0x7C58}, /* East Asian ideograph */
  {"\x6F", 0, 0x7CFA}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page470 = {
  marc8_31page470_flat, 0
};
/* PAGE 469 */
struct yaz_iconv_trie_flat marc8_31page469_flat[] = {
  {"\x29", 0, 0x9F9D}, /* East Asian ideograph */
  {"\x37", 0, 0x7980}, /* East Asian ideograph */
  {"\x3E", 0, 0x7A3E}, /* East Asian ideograph */
  {"\x41", 0, 0x4E69}, /* East Asian ideograph */
  {"\x45", 0, 0x9834}, /* East Asian ideograph */
  {"\x48", 0, 0x7A42}, /* East Asian ideograph */
  {"\x5E", 0, 0x7AB0}, /* East Asian ideograph */
  {"\x6B", 0, 0x7AF8}, /* East Asian ideograph */
  {"\x7C", 0, 0x7B5E}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page469 = {
  marc8_31page469_flat, 0
};
/* PAGE 468 */
struct yaz_iconv_trie_flat marc8_31page468_flat[] = {
  {"\x24", 0, 0x6998}, /* East Asian ideograph */
  {"\x33", 0, 0x78AA}, /* East Asian ideograph */
  {"\x5B", 0, 0x945B}, /* East Asian ideograph */
  {"\x79", 0, 0x5FA1}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page468 = {
  marc8_31page468_flat, 0
};
/* PAGE 467 */
struct yaz_iconv_trie_flat marc8_31page467_flat[] = {
  {"\x21", 0, 0x7681}, /* East Asian ideograph */
  {"\x34", 0, 0x76C7}, /* East Asian ideograph */
  {"\x38", 0, 0x76D7}, /* East Asian ideograph */
  {"\x4F", 0, 0x771F}, /* East Asian ideograph */
  {"\x5F", 0, 0x7741}, /* East Asian ideograph */
  {"\x65", 0, 0x53E1}, /* East Asian ideograph */
  {"\x6D", 0, 0x7792}, /* East Asian ideograph */
  {"\x71", 0, 0x7719}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page467 = {
  marc8_31page467_flat, 0
};
/* PAGE 466 */
struct yaz_iconv_trie_flat marc8_31page466_flat[] = {
  {"\x2C", 0, 0x583A}, /* East Asian ideograph */
  {"\x2D", 0, 0x756E}, /* East Asian ideograph */
  {"\x35", 0, 0x7567}, /* East Asian ideograph */
  {"\x3C", 0, 0x53E0}, /* East Asian ideograph */
  {"\x3E", 0, 0x758E}, /* East Asian ideograph */
  {"\x5D", 0, 0x7661}, /* East Asian ideograph */
  {"\x7E", 0, 0x4F70}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page466 = {
  marc8_31page466_flat, 0
};
/* PAGE 465 */
struct yaz_iconv_trie_flat marc8_31page465_flat[] = {
  {"\x22", 0, 0x736A}, /* East Asian ideograph */
  {"\x35", 0, 0x73C9}, /* East Asian ideograph */
  {"\x3F", 0, 0x73CE}, /* East Asian ideograph */
  {"\x43", 0, 0x746F}, /* East Asian ideograph */
  {"\x45", 0, 0x6BEC}, /* East Asian ideograph */
  {"\x5B", 0, 0x78AF}, /* East Asian ideograph */
  {"\x71", 0, 0x7F3E}, /* East Asian ideograph */
  {"\x72", 0, 0x7506}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page465 = {
  marc8_31page465_flat, 0
};
/* PAGE 464 */
struct yaz_iconv_trie_flat marc8_31page464_flat[] = {
  {"\x26", 0, 0x713C}, /* East Asian ideograph */
  {"\x28", 0, 0x8B8C}, /* East Asian ideograph */
  {"\x34", 0, 0x718F}, /* East Asian ideograph */
  {"\x3B", 0, 0x4E89}, /* East Asian ideograph */
  {"\x45", 0, 0x5C12}, /* East Asian ideograph */
  {"\x46", 0, 0x58BB}, /* East Asian ideograph */
  {"\x58", 0, 0x7F9D}, /* East Asian ideograph */
  {"\x5B", 0, 0x7282}, /* East Asian ideograph */
  {"\x60", 0, 0x6C02}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page464 = {
  marc8_31page464_flat, 0
};
/* PAGE 463 */
struct yaz_iconv_trie_flat marc8_31page463_flat[] = {
  {"\x3A", 0, 0x702C}, /* East Asian ideograph */
  {"\x47", 0, 0x7AC8}, /* East Asian ideograph */
  {"\x54", 0, 0x70F1}, /* East Asian ideograph */
  {"\x56", 0, 0x70B0}, /* East Asian ideograph */
  {"\x6B", 0, 0x70DF}, /* East Asian ideograph */
  {"\x71", 0, 0x70A4}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page463 = {
  marc8_31page463_flat, 0
};
/* PAGE 462 */
struct yaz_iconv_trie_flat marc8_31page462_flat[] = {
  {"\x29", 0, 0x51CF}, /* East Asian ideograph */
  {"\x2F", 0, 0x6E07}, /* East Asian ideograph */
  {"\x44", 0, 0x6FD5}, /* East Asian ideograph */
  {"\x45", 0, 0x6E29}, /* East Asian ideograph */
  {"\x50", 0, 0x6EDA}, /* East Asian ideograph */
  {"\x53", 0, 0x7001}, /* East Asian ideograph */
  {"\x5C", 0, 0x6F44}, /* East Asian ideograph */
  {"\x6B", 0, 0x6F82}, /* East Asian ideograph */
  {"\x6E", 0, 0x6F97}, /* East Asian ideograph */
  {"\x74", 0, 0x6F5C}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page462 = {
  marc8_31page462_flat, 0
};
/* PAGE 461 */
struct yaz_iconv_trie_flat marc8_31page461_flat[] = {
  {"\x29", 0, 0x6D29}, /* East Asian ideograph */
  {"\x30", 0, 0x51B5}, /* East Asian ideograph */
  {"\x35", 0, 0x6C4E}, /* East Asian ideograph */
  {"\x38", 0, 0x6FFC}, /* East Asian ideograph */
  {"\x46", 0, 0x6C79}, /* East Asian ideograph */
  {"\x56", 0, 0x6F94}, /* East Asian ideograph */
  {"\x5B", 0, 0x51C9}, /* East Asian ideograph */
  {"\x5F", 0, 0x51C4}, /* East Asian ideograph */
  {"\x68", 0, 0x6D45}, /* East Asian ideograph (variant of EACC 274768) */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page461 = {
  marc8_31page461_flat, 0
};
/* PAGE 460 */
struct yaz_iconv_trie_flat marc8_31page460_flat[] = {
  {"\x21", 0, 0x61FD}, /* East Asian ideograph */
  {"\x2C", 0, 0x6B7A}, /* East Asian ideograph */
  {"\x47", 0, 0x6BD8}, /* East Asian ideograph */
  {"\x6D", 0, 0x51B3}, /* East Asian ideograph */
  {"\x74", 0, 0x51B2}, /* East Asian ideograph */
  {"\x7C", 0, 0x6CB2}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page460 = {
  marc8_31page460_flat, 0
};
/* PAGE 459 */
struct yaz_iconv_trie_flat marc8_31page459_flat[] = {
  {"\x39", 0, 0x6406}, /* East Asian ideograph */
  {"\x3A", 0, 0x6760}, /* East Asian ideograph */
  {"\x43", 0, 0x6901}, /* East Asian ideograph */
  {"\x4E", 0, 0x697D}, /* East Asian ideograph */
  {"\x50", 0, 0x58AB}, /* East Asian ideograph */
  {"\x62", 0, 0x681D}, /* East Asian ideograph */
  {"\x64", 0, 0x68B9}, /* East Asian ideograph */
  {"\x69", 0, 0x6AC9}, /* East Asian ideograph */
  {"\x74", 0, 0x5FFB}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page459 = {
  marc8_31page459_flat, 0
};
/* PAGE 458 */
struct yaz_iconv_trie_flat marc8_31page458_flat[] = {
  {"\x25", 0, 0x686E}, /* East Asian ideograph */
  {"\x2D", 0, 0x6780}, /* East Asian ideograph */
  {"\x37", 0, 0x67FE}, /* East Asian ideograph */
  {"\x3A", 0, 0x6942}, /* East Asian ideograph */
  {"\x40", 0, 0x6822}, /* East Asian ideograph */
  {"\x44", 0, 0x69C5}, /* East Asian ideograph */
  {"\x4B", 0, 0x6852}, /* East Asian ideograph */
  {"\x50", 0, 0x8308}, /* East Asian ideograph */
  {"\x61", 0, 0x6746}, /* East Asian ideograph */
  {"\x66", 0, 0x6973}, /* East Asian ideograph */
  {"\x6B", 0, 0x6936}, /* East Asian ideograph */
  {"\x72", 0, 0x68CA}, /* East Asian ideograph */
  {"\x74", 0, 0x690D}, /* East Asian ideograph (variant of EACC 214474) */
  {"\x7D", 0, 0x684C}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page458 = {
  marc8_31page458_flat, 0
};
/* PAGE 457 */
struct yaz_iconv_trie_flat marc8_31page457_flat[] = {
  {"\x27", 0, 0x6630}, /* East Asian ideograph */
  {"\x29", 0, 0x668E}, /* East Asian ideograph */
  {"\x2E", 0, 0x66EC}, /* East Asian ideograph */
  {"\x3B", 0, 0x6662}, /* East Asian ideograph */
  {"\x3E", 0, 0x667B}, /* East Asian ideograph */
  {"\x43", 0, 0x6636}, /* East Asian ideograph */
  {"\x48", 0, 0x6681}, /* East Asian ideograph */
  {"\x49", 0, 0x66A6}, /* East Asian ideograph */
  {"\x5F", 0, 0x6716}, /* East Asian ideograph */
  {"\x62", 0, 0x6722}, /* East Asian ideograph */
  {"\x64", 0, 0x671E}, /* East Asian ideograph */
  {"\x70", 0, 0x6736}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page457 = {
  marc8_31page457_flat, 0
};
/* PAGE 456 */
struct yaz_iconv_trie_flat marc8_31page456_flat[] = {
  {"\x28", 0, 0x5117}, /* East Asian ideograph */
  {"\x49", 0, 0x53D9}, /* East Asian ideograph */
  {"\x4F", 0, 0x555F}, /* East Asian ideograph */
  {"\x72", 0, 0x65E3}, /* East Asian ideograph */
  {"\x77", 0, 0x65EE}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page456 = {
  marc8_31page456_flat, 0
};
/* PAGE 455 */
struct yaz_iconv_trie_flat marc8_31page455_flat[] = {
  {"\x22", 0, 0x6485}, /* East Asian ideograph */
  {"\x32", 0, 0x642F}, /* East Asian ideograph */
  {"\x41", 0, 0x63B2}, /* East Asian ideograph */
  {"\x47", 0, 0x6271}, /* East Asian ideograph */
  {"\x50", 0, 0x6428}, /* East Asian ideograph */
  {"\x52", 0, 0x6447}, /* East Asian ideograph */
  {"\x53", 0, 0x64E3}, /* East Asian ideograph */
  {"\x54", 0, 0x635C}, /* East Asian ideograph */
  {"\x6E", 0, 0x6534}, /* East Asian ideograph */
  {"\x71", 0, 0x62CA}, /* East Asian ideograph */
  {"\x76", 0, 0x6483}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page455 = {
  marc8_31page455_flat, 0
};
/* PAGE 454 */
struct yaz_iconv_trie_flat marc8_31page454_flat[] = {
  {"\x29", 0, 0x5214}, /* East Asian ideograph */
  {"\x31", 0, 0x64A6}, /* East Asian ideograph */
  {"\x39", 0, 0x67C6}, /* East Asian ideograph */
  {"\x3F", 0, 0x6255}, /* East Asian ideograph */
  {"\x49", 0, 0x67B4}, /* East Asian ideograph */
  {"\x4C", 0, 0x6283}, /* East Asian ideograph */
  {"\x4F", 0, 0x6294}, /* East Asian ideograph */
  {"\x66", 0, 0x63CE}, /* East Asian ideograph */
  {"\x67", 0, 0x62CF}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page454 = {
  marc8_31page454_flat, 0
};
/* PAGE 453 */
struct yaz_iconv_trie_flat marc8_31page453_flat[] = {
  {"\x24", 0, 0x661A}, /* East Asian ideograph */
  {"\x27", 0, 0x6120}, /* East Asian ideograph */
  {"\x2A", 0, 0x5ABF}, /* East Asian ideograph */
  {"\x31", 0, 0x6159}, /* East Asian ideograph */
  {"\x3A", 0, 0x6185}, /* East Asian ideograph */
  {"\x54", 0, 0x61D0}, /* East Asian ideograph */
  {"\x67", 0, 0x621E}, /* East Asian ideograph */
  {"\x6E", 0, 0x6226}, /* East Asian ideograph */
  {"\x6F", 0, 0x622F}, /* East Asian ideograph */
  {"\x76", 0, 0x78A5}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page453 = {
  marc8_31page453_flat, 0
};
/* PAGE 452 */
struct yaz_iconv_trie_flat marc8_31page452_flat[] = {
  {"\x2B", 0, 0x6060}, /* East Asian ideograph */
  {"\x3C", 0, 0x803B}, /* East Asian ideograph */
  {"\x40", 0, 0x6052}, /* East Asian ideograph */
  {"\x60", 0, 0x6075}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page452 = {
  marc8_31page452_flat, 0
};
/* PAGE 451 */
struct yaz_iconv_trie_flat marc8_31page451_flat[] = {
  {"\x29", 0, 0x53AE}, /* East Asian ideograph */
  {"\x2B", 0, 0x5EBF}, /* East Asian ideograph */
  {"\x2D", 0, 0x5396}, /* East Asian ideograph */
  {"\x2F", 0, 0x539B}, /* East Asian ideograph */
  {"\x34", 0, 0x5EFE}, /* East Asian ideograph */
  {"\x48", 0, 0x5F4A}, /* East Asian ideograph */
  {"\x4E", 0, 0x7BF2}, /* East Asian ideograph */
  {"\x50", 0, 0x5F5C}, /* East Asian ideograph */
  {"\x5E", 0, 0x9AF4}, /* East Asian ideograph */
  {"\x67", 0, 0x9015}, /* East Asian ideograph */
  {"\x6C", 0, 0x5F93}, /* East Asian ideograph */
  {"\x75", 0, 0x60EA}, /* East Asian ideograph */
  {"\x76", 0, 0x5FB4}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page451 = {
  marc8_31page451_flat, 0
};
/* PAGE 450 */
struct yaz_iconv_trie_flat marc8_31page450_flat[] = {
  {"\x21", 0, 0x57FC}, /* East Asian ideograph */
  {"\x22", 0, 0x5D10}, /* East Asian ideograph */
  {"\x26", 0, 0x5D18}, /* East Asian ideograph */
  {"\x36", 0, 0x5DE3}, /* East Asian ideograph */
  {"\x38", 0, 0x9245}, /* East Asian ideograph */
  {"\x49", 0, 0x83F7}, /* East Asian ideograph */
  {"\x5F", 0, 0x6A66}, /* East Asian ideograph */
  {"\x61", 0, 0x5E47}, /* East Asian ideograph */
  {"\x65", 0, 0x79CA}, /* East Asian ideograph */
  {"\x6A", 0, 0x51FC}, /* East Asian ideograph */
  {"\x6D", 0, 0x8298}, /* East Asian ideograph (duplicate simplified) */
  {"\x6E", 0, 0x7240}, /* East Asian ideograph */
  {"\x70", 0, 0x576B}, /* East Asian ideograph */
  {"\x7C", 0, 0x83F4}, /* East Asian ideograph */
  {"\x7D", 0, 0x53A2}, /* East Asian ideograph */
  {"\x7E", 0, 0x53A0}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page450 = {
  marc8_31page450_flat, 0
};
/* PAGE 449 */
struct yaz_iconv_trie_flat marc8_31page449_flat[] = {
  {"\x27", 0, 0x51A8}, /* East Asian ideograph */
  {"\x2A", 0, 0x5EBD}, /* East Asian ideograph */
  {"\x33", 0, 0x8A67}, /* East Asian ideograph */
  {"\x3F", 0, 0x5C02}, /* East Asian ideograph */
  {"\x40", 0, 0x5C06}, /* East Asian ideograph (variant of EACC 273B40) */
  {"\x52", 0, 0x6EBA}, /* East Asian ideograph */
  {"\x54", 0, 0x5C4A}, /* East Asian ideograph */
  {"\x6E", 0, 0x5D17}, /* East Asian ideograph */
  {"\x77", 0, 0x5CE9}, /* East Asian ideograph */
  {"\x78", 0, 0x5CEF}, /* East Asian ideograph */
  {"\x79", 0, 0x5D8B}, /* East Asian ideograph */
  {"\x7B", 0, 0x5D08}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page449 = {
  marc8_31page449_flat, 0
};
/* PAGE 448 */
struct yaz_iconv_trie_flat marc8_31page448_flat[] = {
  {"\x26", 0, 0x5A3F}, /* East Asian ideograph */
  {"\x2F", 0, 0x58FB}, /* East Asian ideograph */
  {"\x41", 0, 0x5AFA}, /* East Asian ideograph */
  {"\x47", 0, 0x5ACB}, /* East Asian ideograph */
  {"\x60", 0, 0x6588}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page448 = {
  marc8_31page448_flat, 0
};
/* PAGE 447 */
struct yaz_iconv_trie_flat marc8_31page447_flat[] = {
  {"\x21", 0, 0x591F}, /* East Asian ideograph */
  {"\x29", 0, 0x6B80}, /* East Asian ideograph */
  {"\x2F", 0, 0x7287}, /* East Asian ideograph */
  {"\x31", 0, 0x67F0}, /* East Asian ideograph */
  {"\x32", 0, 0x7AD2}, /* East Asian ideograph */
  {"\x44", 0, 0x511E}, /* East Asian ideograph */
  {"\x4D", 0, 0x59AC}, /* East Asian ideograph */
  {"\x54", 0, 0x7385}, /* East Asian ideograph */
  {"\x56", 0, 0x59D9}, /* East Asian ideograph */
  {"\x6E", 0, 0x4F84}, /* East Asian ideograph */
  {"\x70", 0, 0x5A63}, /* East Asian ideograph */
  {"\x74", 0, 0x5B43}, /* East Asian ideograph */
  {"\x7B", 0, 0x5A31}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page447 = {
  marc8_31page447_flat, 0
};
/* PAGE 446 */
struct yaz_iconv_trie_flat marc8_31page446_flat[] = {
  {"\x21", 0, 0x962F}, /* East Asian ideograph */
  {"\x30", 0, 0x573B}, /* East Asian ideograph */
  {"\x3F", 0, 0x575A}, /* East Asian ideograph */
  {"\x4A", 0, 0x5872}, /* East Asian ideograph */
  {"\x52", 0, 0x51A2}, /* East Asian ideograph */
  {"\x54", 0, 0x5896}, /* East Asian ideograph */
  {"\x6E", 0, 0x58CA}, /* East Asian ideograph */
  {"\x76", 0, 0x58F7}, /* East Asian ideograph */
  {"\x77", 0, 0x5900}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page446 = {
  marc8_31page446_flat, 0
};
/* PAGE 445 */
struct yaz_iconv_trie_flat marc8_31page445_flat[] = {
  {"\x30", 0, 0x751E}, /* East Asian ideograph */
  {"\x48", 0, 0x8B5F}, /* East Asian ideograph */
  {"\x49", 0, 0x5650}, /* East Asian ideograph */
  {"\x58", 0, 0x54BD}, /* East Asian ideograph */
  {"\x65", 0, 0x8086}, /* East Asian ideograph */
  {"\x68", 0, 0x56EC}, /* East Asian ideograph */
  {"\x6F", 0, 0x5700}, /* East Asian ideograph */
  {"\x7C", 0, 0x962C}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page445 = {
  marc8_31page445_flat, 0
};
/* PAGE 444 */
struct yaz_iconv_trie_flat marc8_31page444_flat[] = {
  {"\x22", 0, 0x8AEE}, /* East Asian ideograph */
  {"\x2A", 0, 0x95A7}, /* East Asian ideograph */
  {"\x32", 0, 0x8A7B}, /* East Asian ideograph */
  {"\x42", 0, 0x6B38}, /* East Asian ideograph */
  {"\x44", 0, 0x5557}, /* East Asian ideograph */
  {"\x61", 0, 0x6199}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page444 = {
  marc8_31page444_flat, 0
};
/* PAGE 443 */
struct yaz_iconv_trie_flat marc8_31page443_flat[] = {
  {"\x39", 0, 0x52FE}, /* East Asian ideograph */
  {"\x3C", 0, 0x6B62}, /* East Asian ideograph */
  {"\x43", 0, 0x4EDD}, /* East Asian ideograph */
  {"\x47", 0, 0x55AB}, /* East Asian ideograph */
  {"\x56", 0, 0x7343}, /* East Asian ideograph */
  {"\x5C", 0, 0x5434}, /* East Asian ideograph */
  {"\x6A", 0, 0x8A36}, /* East Asian ideograph */
  {"\x71", 0, 0x546A}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page443 = {
  marc8_31page443_flat, 0
};
/* PAGE 442 */
struct yaz_iconv_trie_flat marc8_31page442_flat[] = {
  {"\x21", 0, 0x5294}, /* East Asian ideograph */
  {"\x28", 0, 0x5226}, /* East Asian ideograph */
  {"\x2E", 0, 0x8274}, /* East Asian ideograph */
  {"\x36", 0, 0x52F3}, /* East Asian ideograph */
  {"\x3C", 0, 0x52A2}, /* East Asian ideograph */
  {"\x3D", 0, 0x52E7}, /* East Asian ideograph */
  {"\x53", 0, 0x758B}, /* East Asian ideograph */
  {"\x57", 0, 0x62FE}, /* East Asian ideograph */
  {"\x58", 0, 0x4EDF}, /* East Asian ideograph */
  {"\x5B", 0, 0x6607}, /* East Asian ideograph */
  {"\x5D", 0, 0x5349}, /* East Asian ideograph */
  {"\x64", 0, 0x613D}, /* East Asian ideograph */
  {"\x6A", 0, 0x5918}, /* East Asian ideograph */
  {"\x6E", 0, 0x5373}, /* East Asian ideograph */
  {"\x73", 0, 0x5374}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page442 = {
  marc8_31page442_flat, 0
};
/* PAGE 441 */
struct yaz_iconv_trie_flat marc8_31page441_flat[] = {
  {"\x24", 0, 0x634C}, /* East Asian ideograph */
  {"\x2A", 0, 0x4E0C}, /* East Asian ideograph */
  {"\x32", 0, 0x5190}, /* East Asian ideograph */
  {"\x4F", 0, 0x5202}, /* East Asian ideograph */
  {"\x56", 0, 0x5211}, /* East Asian ideograph */
  {"\x5F", 0, 0x52B5}, /* East Asian ideograph */
  {"\x66", 0, 0x5234}, /* East Asian ideograph */
  {"\x6B", 0, 0x5C05}, /* East Asian ideograph */
  {"\x72", 0, 0x5265}, /* East Asian ideograph */
  {"\x77", 0, 0x8CF8}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page441 = {
  marc8_31page441_flat, 0
};
/* PAGE 440 */
struct yaz_iconv_trie_flat marc8_31page440_flat[] = {
  {"\x24", 0, 0x7B87}, /* East Asian ideograph */
  {"\x51", 0, 0x510C}, /* East Asian ideograph */
  {"\x53", 0, 0x50E3}, /* East Asian ideograph */
  {"\x5F", 0, 0x50BB}, /* East Asian ideograph (variant of EACC 4B325F) */
  {"\x61", 0, 0x5039}, /* East Asian ideograph */
  {"\x63", 0, 0x4FAD}, /* East Asian ideograph */
  {"\x72", 0, 0x706E}, /* East Asian ideograph */
  {"\x79", 0, 0x514E}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page440 = {
  marc8_31page440_flat, 0
};
/* PAGE 439 */
struct yaz_iconv_trie_flat marc8_31page439_flat[] = {
  {"\x32", 0, 0x4ECF}, /* East Asian ideograph */
  {"\x3A", 0, 0x62BB}, /* East Asian ideograph */
  {"\x40", 0, 0x4F32}, /* East Asian ideograph */
  {"\x47", 0, 0x5002}, /* East Asian ideograph */
  {"\x4C", 0, 0x5008}, /* East Asian ideograph */
  {"\x5F", 0, 0x4FA3}, /* East Asian ideograph */
  {"\x64", 0, 0x7AE2}, /* East Asian ideograph */
  {"\x65", 0, 0x349E}, /* East Asian ideograph (Unicode CJK Extension A) */
  {"\x77", 0, 0x5E78}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page439 = {
  marc8_31page439_flat, 0
};
/* PAGE 438 */
struct yaz_iconv_trie_flat marc8_31page438_flat[] = {
  {"\x21", 0, 0x5F0C}, /* East Asian ideograph */
  {"\x2D", 0, 0x4E17}, /* East Asian ideograph */
  {"\x32", 0, 0x7ADD}, /* East Asian ideograph */
  {"\x45", 0, 0x4E57}, /* East Asian ideograph */
  {"\x51", 0, 0x5F0D}, /* East Asian ideograph */
  {"\x53", 0, 0x4E3C}, /* East Asian ideograph */
  {"\x58", 0, 0x4E9C}, /* East Asian ideograph */
  {"\x5B", 0, 0x4EBE}, /* East Asian ideograph */
  {"\x61", 0, 0x4EB0}, /* East Asian ideograph */
  {"\x6C", 0, 0x8B8E}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page438 = {
  marc8_31page438_flat, 0
};
/* PAGE 437 */
struct yaz_iconv_trie_dir marc8_31page437_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {439, 0, 0},
  {440, 0, 0},
  {441, 0, 0},
  {442, 0, 0},
  {443, 0, 0},
  {444, 0, 0},
  {445, 0, 0},
  {446, 0, 0},
  {447, 0, 0},
  {448, 0, 0},
  {449, 0, 0},
  {450, 0, 0},
  {451, 0, 0},
  {452, 0, 0},
  {453, 0, 0},
  {454, 0, 0},
  {455, 0, 0},
  {456, 0, 0},
  {457, 0, 0},
  {458, 0, 0},
  {459, 0, 0},
  {460, 0, 0},
  {461, 0, 0},
  {462, 0, 0},
  {463, 0, 0},
  {464, 0, 0},
  {465, 0, 0},
  {466, 0, 0},
  {467, 0, 0},
  {468, 0, 0},
  {469, 0, 0},
  {470, 0, 0},
  {471, 0, 0},
  {472, 0, 0},
  {473, 0, 0},
  {474, 0, 0},
  {475, 0, 0},
  {476, 0, 0},
  {477, 0, 0},
  {478, 0, 0},
  {479, 0, 0},
  {480, 0, 0},
  {481, 0, 0},
  {482, 0, 0},
  {483, 0, 0},
  {484, 0, 0},
  {485, 0, 0},
  {486, 0, 0},
  {487, 0, 0},
  {488, 0, 0},
  {489, 0, 0},
  {490, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {491, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {492, 0, 0},
  {0, 0, 0},
  {493, 0, 0},
  {0, 0, 0},
  {494, 0, 0},
  {0, 0, 0},
  {495, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {496, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {497, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8_31page437 = {
  0, marc8_31page437_dir
};
/* PAGE 436 */
struct yaz_iconv_trie_flat marc8_31page436_flat[] = {
  {"\x28", 0, 0x9F86}, /* East Asian ideograph */
  {"\x2B", 0, 0x9F85}, /* East Asian ideograph */
  {"\x62", 0, 0x9F9B}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page436 = {
  marc8_31page436_flat, 0
};
/* PAGE 435 */
struct yaz_iconv_trie_flat marc8_31page435_flat[] = {
  {"\x2B", 0, 0x9F0D}, /* East Asian ideograph */
  {"\x7B", 0, 0x9F51}, /* East Asian ideograph */
  {"\x7C", 0, 0x9F80}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page435 = {
  marc8_31page435_flat, 0
};
/* PAGE 434 */
struct yaz_iconv_trie_flat marc8_31page434_flat[] = {
  {"\x6A", 0, 0x9EEA}, /* East Asian ideograph */
  {"\x7A", 0, 0x9EFE}, /* East Asian ideograph */
  {"\x7C", 0, 0x9F0B}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page434 = {
  marc8_31page434_flat, 0
};
/* PAGE 433 */
struct yaz_iconv_trie_flat marc8_31page433_flat[] = {
  {"\x29", 0, 0x9E71}, /* East Asian ideograph */
  {"\x36", 0, 0x9E2C}, /* East Asian ideograph */
  {"\x3A", 0, 0x9E73}, /* East Asian ideograph */
  {"\x3B", 0, 0x9E42}, /* East Asian ideograph */
  {"\x3C", 0, 0x5364}, /* East Asian ideograph */
  {"\x42", 0, 0x9E7E}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page433 = {
  marc8_31page433_flat, 0
};
/* PAGE 432 */
struct yaz_iconv_trie_flat marc8_31page432_flat[] = {
  {"\x28", 0, 0x9E58}, /* East Asian ideograph */
  {"\x3E", 0, 0x9E37}, /* East Asian ideograph */
  {"\x47", 0, 0x9E68}, /* East Asian ideograph */
  {"\x49", 0, 0x9E47}, /* East Asian ideograph */
  {"\x57", 0, 0x9E6B}, /* East Asian ideograph */
  {"\x5B", 0, 0x9E6C}, /* East Asian ideograph */
  {"\x65", 0, 0x9E69}, /* East Asian ideograph */
  {"\x6C", 0, 0x9E6A}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page432 = {
  marc8_31page432_flat, 0
};
/* PAGE 431 */
struct yaz_iconv_trie_flat marc8_31page431_flat[] = {
  {"\x2A", 0, 0x9E46}, /* East Asian ideograph */
  {"\x35", 0, 0x9E2B}, /* East Asian ideograph */
  {"\x52", 0, 0x9E4E}, /* East Asian ideograph */
  {"\x59", 0, 0x9E5C}, /* East Asian ideograph */
  {"\x5C", 0, 0x9E5B}, /* East Asian ideograph */
  {"\x60", 0, 0x9E55}, /* East Asian ideograph */
  {"\x6B", 0, 0x9E57}, /* East Asian ideograph */
  {"\x6C", 0, 0x9E4B}, /* East Asian ideograph */
  {"\x77", 0, 0x9E63}, /* East Asian ideograph */
  {"\x79", 0, 0x9E5A}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page431 = {
  marc8_31page431_flat, 0
};
/* PAGE 430 */
struct yaz_iconv_trie_flat marc8_31page430_flat[] = {
  {"\x28", 0, 0x9E28}, /* East Asian ideograph */
  {"\x44", 0, 0x9E32}, /* East Asian ideograph */
  {"\x48", 0, 0x9E31}, /* East Asian ideograph */
  {"\x59", 0, 0x9E38}, /* East Asian ideograph */
  {"\x65", 0, 0x9E39}, /* East Asian ideograph */
  {"\x68", 0, 0x9E3A}, /* East Asian ideograph */
  {"\x70", 0, 0x9E48}, /* East Asian ideograph */
  {"\x75", 0, 0x9E41}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page430 = {
  marc8_31page430_flat, 0
};
/* PAGE 429 */
struct yaz_iconv_trie_flat marc8_31page429_flat[] = {
  {"\x21", 0, 0x9CD9}, /* East Asian ideograph */
  {"\x25", 0, 0x9CCC}, /* East Asian ideograph */
  {"\x28", 0, 0x9CD5}, /* East Asian ideograph */
  {"\x29", 0, 0x9CA3}, /* East Asian ideograph */
  {"\x2A", 0, 0x9CD3}, /* East Asian ideograph */
  {"\x32", 0, 0x9CD8}, /* East Asian ideograph */
  {"\x38", 0, 0x9CDF}, /* East Asian ideograph */
  {"\x3A", 0, 0x9C85}, /* East Asian ideograph */
  {"\x3B", 0, 0x9C9F}, /* East Asian ideograph */
  {"\x40", 0, 0x9CBC}, /* East Asian ideograph */
  {"\x4F", 0, 0x9CE2}, /* East Asian ideograph */
  {"\x55", 0, 0x9C8E}, /* East Asian ideograph */
  {"\x58", 0, 0x9C9A}, /* East Asian ideograph */
  {"\x6B", 0, 0x9CA1}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page429 = {
  marc8_31page429_flat, 0
};
/* PAGE 428 */
struct yaz_iconv_trie_flat marc8_31page428_flat[] = {
  {"\x22", 0, 0x9CAE}, /* East Asian ideograph */
  {"\x25", 0, 0x9CBA}, /* East Asian ideograph */
  {"\x27", 0, 0x9CB2}, /* East Asian ideograph */
  {"\x28", 0, 0x9CB4}, /* East Asian ideograph */
  {"\x2C", 0, 0x9CB1}, /* East Asian ideograph */
  {"\x2D", 0, 0x9CB7}, /* East Asian ideograph */
  {"\x2F", 0, 0x9CB5}, /* East Asian ideograph */
  {"\x31", 0, 0x9CB6}, /* East Asian ideograph */
  {"\x34", 0, 0x9CBB}, /* East Asian ideograph */
  {"\x3E", 0, 0x9CCA}, /* East Asian ideograph */
  {"\x4B", 0, 0x9CBD}, /* East Asian ideograph */
  {"\x54", 0, 0x9CC4}, /* East Asian ideograph */
  {"\x59", 0, 0x9CC6}, /* East Asian ideograph */
  {"\x5C", 0, 0x9CC7}, /* East Asian ideograph */
  {"\x6A", 0, 0x9CCB}, /* East Asian ideograph */
  {"\x6E", 0, 0x9CA5}, /* East Asian ideograph */
  {"\x71", 0, 0x9CCE}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page428 = {
  marc8_31page428_flat, 0
};
/* PAGE 427 */
struct yaz_iconv_trie_flat marc8_31page427_flat[] = {
  {"\x21", 0, 0x9C86}, /* East Asian ideograph */
  {"\x29", 0, 0x9C87}, /* East Asian ideograph */
  {"\x2B", 0, 0x9C90}, /* East Asian ideograph */
  {"\x31", 0, 0x9C8B}, /* East Asian ideograph */
  {"\x39", 0, 0x9C9E}, /* East Asian ideograph */
  {"\x3C", 0, 0x9C91}, /* East Asian ideograph */
  {"\x3D", 0, 0x9C92}, /* East Asian ideograph */
  {"\x42", 0, 0x9C95}, /* East Asian ideograph */
  {"\x56", 0, 0x9CA9}, /* East Asian ideograph */
  {"\x5F", 0, 0x9CA0}, /* East Asian ideograph */
  {"\x6E", 0, 0x9CA7}, /* East Asian ideograph */
  {"\x7A", 0, 0x9CAD}, /* East Asian ideograph */
  {"\x7C", 0, 0x9CB0}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page427 = {
  marc8_31page427_flat, 0
};
/* PAGE 426 */
struct yaz_iconv_trie_flat marc8_31page426_flat[] = {
  {"\x3C", 0, 0x9B49}, /* East Asian ideograph */
  {"\x5D", 0, 0x9C82}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page426 = {
  marc8_31page426_flat, 0
};
/* PAGE 425 */
struct yaz_iconv_trie_flat marc8_31page425_flat[] = {
  {"\x6C", 0, 0x960B}, /* East Asian ideograph */
  {"\x74", 0, 0x9604}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page425 = {
  marc8_31page425_flat, 0
};
/* PAGE 424 */
struct yaz_iconv_trie_flat marc8_31page424_flat[] = {
  {"\x21", 0, 0x9AA3}, /* East Asian ideograph */
  {"\x22", 0, 0x9A81}, /* East Asian ideograph */
  {"\x27", 0, 0x9A85}, /* East Asian ideograph */
  {"\x33", 0, 0x9AA7}, /* East Asian ideograph */
  {"\x6D", 0, 0x9ACB}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page424 = {
  marc8_31page424_flat, 0
};
/* PAGE 423 */
struct yaz_iconv_trie_flat marc8_31page423_flat[] = {
  {"\x3D", 0, 0x9A90}, /* East Asian ideograph */
  {"\x40", 0, 0x9A92}, /* East Asian ideograph */
  {"\x47", 0, 0x9A93}, /* East Asian ideograph */
  {"\x5A", 0, 0x9A9F}, /* East Asian ideograph */
  {"\x60", 0, 0x9A98}, /* East Asian ideograph */
  {"\x69", 0, 0x9A7A}, /* East Asian ideograph */
  {"\x6A", 0, 0x9A9D}, /* East Asian ideograph */
  {"\x70", 0, 0x9A9C}, /* East Asian ideograph */
  {"\x79", 0, 0x9A96}, /* East Asian ideograph */
  {"\x7A", 0, 0x9AA2}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page423 = {
  marc8_31page423_flat, 0
};
/* PAGE 422 */
struct yaz_iconv_trie_flat marc8_31page422_flat[] = {
  {"\x22", 0, 0x98E8}, /* East Asian ideograph */
  {"\x63", 0, 0x9A75}, /* East Asian ideograph */
  {"\x69", 0, 0x9A80}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page422 = {
  marc8_31page422_flat, 0
};
/* PAGE 421 */
struct yaz_iconv_trie_flat marc8_31page421_flat[] = {
  {"\x32", 0, 0x997D}, /* East Asian ideograph */
  {"\x53", 0, 0x9967}, /* East Asian ideograph */
  {"\x66", 0, 0x9969}, /* East Asian ideograph */
  {"\x6A", 0, 0x9990}, /* East Asian ideograph */
  {"\x6D", 0, 0x9991}, /* East Asian ideograph */
  {"\x70", 0, 0x998D}, /* East Asian ideograph */
  {"\x72", 0, 0x9994}, /* East Asian ideograph */
  {"\x75", 0, 0x9993}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page421 = {
  marc8_31page421_flat, 0
};
/* PAGE 420 */
struct yaz_iconv_trie_flat marc8_31page420_flat[] = {
  {"\x21", 0, 0x98A2}, /* East Asian ideograph */
  {"\x29", 0, 0x98A5}, /* East Asian ideograph */
  {"\x30", 0, 0x989E}, /* East Asian ideograph */
  {"\x31", 0, 0x98A7}, /* East Asian ideograph */
  {"\x53", 0, 0x98D9}, /* East Asian ideograph */
  {"\x6C", 0, 0x996B}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page420 = {
  marc8_31page420_flat, 0
};
/* PAGE 419 */
struct yaz_iconv_trie_flat marc8_31page419_flat[] = {
  {"\x23", 0, 0x9880}, /* East Asian ideograph */
  {"\x2C", 0, 0x988F}, /* East Asian ideograph */
  {"\x6B", 0, 0x98A1}, /* East Asian ideograph */
  {"\x77", 0, 0x989F}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page419 = {
  marc8_31page419_flat, 0
};
/* PAGE 418 */
struct yaz_iconv_trie_flat marc8_31page418_flat[] = {
  {"\x43", 0, 0x97AF}, /* East Asian ideograph */
  {"\x54", 0, 0x97EA}, /* East Asian ideograph */
  {"\x5C", 0, 0x97EB}, /* East Asian ideograph */
  {"\x79", 0, 0x9878}, /* East Asian ideograph */
  {"\x7B", 0, 0x9883}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page418 = {
  marc8_31page418_flat, 0
};
/* PAGE 417 */
struct yaz_iconv_trie_flat marc8_31page417_flat[] = {
  {"\x76", 0, 0x9753}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page417 = {
  marc8_31page417_flat, 0
};
/* PAGE 416 */
struct yaz_iconv_trie_flat marc8_31page416_flat[] = {
  {"\x44", 0, 0x9655}, /* East Asian ideograph */
  {"\x46", 0, 0x9649}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page416 = {
  marc8_31page416_flat, 0
};
/* PAGE 415 */
struct yaz_iconv_trie_flat marc8_31page415_flat[] = {
  {"\x36", 0, 0x95F3}, /* East Asian ideograph */
  {"\x42", 0, 0x9606}, /* East Asian ideograph */
  {"\x44", 0, 0x9603}, /* East Asian ideograph */
  {"\x48", 0, 0x960F}, /* East Asian ideograph */
  {"\x49", 0, 0x9608}, /* East Asian ideograph */
  {"\x4D", 0, 0x9609}, /* East Asian ideograph */
  {"\x4F", 0, 0x960A}, /* East Asian ideograph */
  {"\x50", 0, 0x960C}, /* East Asian ideograph */
  {"\x52", 0, 0x960D}, /* East Asian ideograph */
  {"\x5A", 0, 0x9612}, /* East Asian ideograph */
  {"\x60", 0, 0x9619}, /* East Asian ideograph */
  {"\x69", 0, 0x961A}, /* East Asian ideograph */
  {"\x6F", 0, 0x95FC}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page415 = {
  marc8_31page415_flat, 0
};
/* PAGE 414 */
struct yaz_iconv_trie_flat marc8_31page414_flat[] = {
  {"\x3E", 0, 0x9554}, /* East Asian ideograph */
  {"\x3F", 0, 0x9572}, /* East Asian ideograph */
  {"\x4A", 0, 0x956C}, /* East Asian ideograph */
  {"\x5C", 0, 0x9565}, /* East Asian ideograph */
  {"\x69", 0, 0x9567}, /* East Asian ideograph */
  {"\x6F", 0, 0x9569}, /* East Asian ideograph */
  {"\x71", 0, 0x954A}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page414 = {
  marc8_31page414_flat, 0
};
/* PAGE 413 */
struct yaz_iconv_trie_flat marc8_31page413_flat[] = {
  {"\x2F", 0, 0x94E9}, /* East Asian ideograph */
  {"\x32", 0, 0x94F4}, /* East Asian ideograph */
  {"\x34", 0, 0x9566}, /* East Asian ideograph */
  {"\x3C", 0, 0x9568}, /* East Asian ideograph */
  {"\x3E", 0, 0x94F9}, /* East Asian ideograph */
  {"\x4D", 0, 0x956B}, /* East Asian ideograph */
  {"\x50", 0, 0x950E}, /* East Asian ideograph */
  {"\x51", 0, 0x950F}, /* East Asian ideograph */
  {"\x58", 0, 0x9561}, /* East Asian ideograph */
  {"\x5E", 0, 0x9562}, /* East Asian ideograph */
  {"\x60", 0, 0x9563}, /* East Asian ideograph */
  {"\x67", 0, 0x94E7}, /* East Asian ideograph */
  {"\x69", 0, 0x9564}, /* East Asian ideograph */
  {"\x74", 0, 0x9571}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page413 = {
  marc8_31page413_flat, 0
};
/* PAGE 412 */
struct yaz_iconv_trie_flat marc8_31page412_flat[] = {
  {"\x21", 0, 0x9553}, /* East Asian ideograph */
  {"\x28", 0, 0x9552}, /* East Asian ideograph */
  {"\x29", 0, 0x84E5}, /* East Asian ideograph */
  {"\x2D", 0, 0x9549}, /* East Asian ideograph */
  {"\x42", 0, 0x94E0}, /* East Asian ideograph */
  {"\x47", 0, 0x954F}, /* East Asian ideograph */
  {"\x4A", 0, 0x953C}, /* East Asian ideograph */
  {"\x56", 0, 0x955B}, /* East Asian ideograph */
  {"\x5A", 0, 0x955F}, /* East Asian ideograph */
  {"\x62", 0, 0x956A}, /* East Asian ideograph */
  {"\x66", 0, 0x933E}, /* East Asian ideograph */
  {"\x7C", 0, 0x9546}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page412 = {
  marc8_31page412_flat, 0
};
/* PAGE 411 */
struct yaz_iconv_trie_flat marc8_31page411_flat[] = {
  {"\x31", 0, 0x9528}, /* East Asian ideograph */
  {"\x32", 0, 0x9531}, /* East Asian ideograph */
  {"\x4D", 0, 0x9534}, /* East Asian ideograph */
  {"\x4E", 0, 0x9545}, /* East Asian ideograph */
  {"\x51", 0, 0x9517}, /* East Asian ideograph */
  {"\x5E", 0, 0x94E1}, /* East Asian ideograph */
  {"\x64", 0, 0x9536}, /* East Asian ideograph */
  {"\x67", 0, 0x9537}, /* East Asian ideograph */
  {"\x68", 0, 0x9518}, /* East Asian ideograph */
  {"\x6F", 0, 0x9538}, /* East Asian ideograph */
  {"\x7A", 0, 0x9550}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page411 = {
  marc8_31page411_flat, 0
};
/* PAGE 410 */
struct yaz_iconv_trie_flat marc8_31page410_flat[] = {
  {"\x27", 0, 0x94D7}, /* East Asian ideograph */
  {"\x2B", 0, 0x9503}, /* East Asian ideograph */
  {"\x2D", 0, 0x94A1}, /* East Asian ideograph */
  {"\x2E", 0, 0x9502}, /* East Asian ideograph */
  {"\x35", 0, 0x950A}, /* East Asian ideograph */
  {"\x3E", 0, 0x94E4}, /* East Asian ideograph */
  {"\x40", 0, 0x9506}, /* East Asian ideograph */
  {"\x41", 0, 0x9507}, /* East Asian ideograph */
  {"\x4D", 0, 0x952B}, /* East Asian ideograph */
  {"\x57", 0, 0x9529}, /* East Asian ideograph */
  {"\x58", 0, 0x952C}, /* East Asian ideograph */
  {"\x5B", 0, 0x9516}, /* East Asian ideograph */
  {"\x66", 0, 0x9515}, /* East Asian ideograph */
  {"\x69", 0, 0x94FC}, /* East Asian ideograph */
  {"\x6D", 0, 0x951B}, /* East Asian ideograph */
  {"\x71", 0, 0x951D}, /* East Asian ideograph */
  {"\x72", 0, 0x951E}, /* East Asian ideograph */
  {"\x74", 0, 0x951F}, /* East Asian ideograph */
  {"\x75", 0, 0x9494}, /* East Asian ideograph */
  {"\x78", 0, 0x9522}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page410 = {
  marc8_31page410_flat, 0
};
/* PAGE 409 */
struct yaz_iconv_trie_flat marc8_31page409_flat[] = {
  {"\x2B", 0, 0x94C6}, /* East Asian ideograph */
  {"\x2F", 0, 0x94F3}, /* East Asian ideograph */
  {"\x31", 0, 0x94F1}, /* East Asian ideograph */
  {"\x35", 0, 0x94F5}, /* East Asian ideograph */
  {"\x40", 0, 0x94D6}, /* East Asian ideograph */
  {"\x43", 0, 0x94D2}, /* East Asian ideograph */
  {"\x46", 0, 0x94D1}, /* East Asian ideograph */
  {"\x49", 0, 0x94D5}, /* East Asian ideograph */
  {"\x4F", 0, 0x94DE}, /* East Asian ideograph */
  {"\x50", 0, 0x94DF}, /* East Asian ideograph */
  {"\x55", 0, 0x94EB}, /* East Asian ideograph */
  {"\x58", 0, 0x94EF}, /* East Asian ideograph */
  {"\x59", 0, 0x94E5}, /* East Asian ideograph */
  {"\x5B", 0, 0x94E3}, /* East Asian ideograph */
  {"\x62", 0, 0x94EA}, /* East Asian ideograph */
  {"\x64", 0, 0x94F7}, /* East Asian ideograph */
  {"\x6A", 0, 0x9512}, /* East Asian ideograph */
  {"\x6C", 0, 0x950D}, /* East Asian ideograph */
  {"\x71", 0, 0x94FD}, /* East Asian ideograph */
  {"\x72", 0, 0x9513}, /* East Asian ideograph */
  {"\x75", 0, 0x9514}, /* East Asian ideograph */
  {"\x7D", 0, 0x94D8}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page409 = {
  marc8_31page409_flat, 0
};
/* PAGE 408 */
struct yaz_iconv_trie_flat marc8_31page408_flat[] = {
  {"\x21", 0, 0x9495}, /* East Asian ideograph */
  {"\x22", 0, 0x9490}, /* East Asian ideograph */
  {"\x23", 0, 0x94AD}, /* East Asian ideograph */
  {"\x24", 0, 0x94AA}, /* East Asian ideograph */
  {"\x25", 0, 0x94AB}, /* East Asian ideograph */
  {"\x28", 0, 0x94AC}, /* East Asian ideograph */
  {"\x31", 0, 0x94AF}, /* East Asian ideograph */
  {"\x37", 0, 0x949B}, /* East Asian ideograph */
  {"\x4B", 0, 0x94A3}, /* East Asian ideograph */
  {"\x51", 0, 0x94C8}, /* East Asian ideograph */
  {"\x52", 0, 0x94C9}, /* East Asian ideograph */
  {"\x54", 0, 0x94CB}, /* East Asian ideograph */
  {"\x55", 0, 0x94CA}, /* East Asian ideograph */
  {"\x58", 0, 0x94B0}, /* East Asian ideograph */
  {"\x5C", 0, 0x94CC}, /* East Asian ideograph */
  {"\x5F", 0, 0x94B6}, /* East Asian ideograph */
  {"\x60", 0, 0x94B7}, /* East Asian ideograph */
  {"\x61", 0, 0x94B2}, /* East Asian ideograph */
  {"\x64", 0, 0x94BA}, /* East Asian ideograph */
  {"\x6D", 0, 0x94CD}, /* East Asian ideograph */
  {"\x6F", 0, 0x94BD}, /* East Asian ideograph */
  {"\x74", 0, 0x94BF}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page408 = {
  marc8_31page408_flat, 0
};
/* PAGE 407 */
struct yaz_iconv_trie_flat marc8_31page407_flat[] = {
  {"\x5C", 0, 0x917E}, /* East Asian ideograph */
  {"\x5D", 0, 0x917D}, /* East Asian ideograph */
  {"\x61", 0, 0x9487}, /* East Asian ideograph */
  {"\x62", 0, 0x9486}, /* East Asian ideograph */
  {"\x63", 0, 0x948C}, /* East Asian ideograph */
  {"\x64", 0, 0x948B}, /* East Asian ideograph */
  {"\x6A", 0, 0x948D}, /* East Asian ideograph */
  {"\x6B", 0, 0x948E}, /* East Asian ideograph */
  {"\x79", 0, 0x9492}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page407 = {
  marc8_31page407_flat, 0
};
/* PAGE 406 */
struct yaz_iconv_trie_flat marc8_31page406_flat[] = {
  {"\x21", 0, 0x90F8}, /* East Asian ideograph */
  {"\x2B", 0, 0x90BA}, /* East Asian ideograph */
  {"\x2C", 0, 0x90D0}, /* East Asian ideograph */
  {"\x31", 0, 0x909D}, /* East Asian ideograph */
  {"\x40", 0, 0x90E6}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page406 = {
  marc8_31page406_flat, 0
};
/* PAGE 405 */
struct yaz_iconv_trie_flat marc8_31page405_flat[] = {
  {"\x23", 0, 0x90CF}, /* East Asian ideograph */
  {"\x4C", 0, 0x90D3}, /* East Asian ideograph */
  {"\x5A", 0, 0x90E7}, /* East Asian ideograph */
  {"\x5C", 0, 0x90AC}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page405 = {
  marc8_31page405_flat, 0
};
/* PAGE 404 */
struct yaz_iconv_trie_flat marc8_31page404_flat[] = {
  {"\x4E", 0, 0x8FF8}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page404 = {
  marc8_31page404_flat, 0
};
/* PAGE 403 */
struct yaz_iconv_trie_flat marc8_31page403_flat[] = {
  {"\x30", 0, 0x8F98}, /* East Asian ideograph */
  {"\x57", 0, 0x8F79}, /* East Asian ideograph */
  {"\x5A", 0, 0x8F73}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page403 = {
  marc8_31page403_flat, 0
};
/* PAGE 402 */
struct yaz_iconv_trie_flat marc8_31page402_flat[] = {
  {"\x3E", 0, 0x8F71}, /* East Asian ideograph */
  {"\x3F", 0, 0x8F7A}, /* East Asian ideograph */
  {"\x42", 0, 0x8F75}, /* East Asian ideograph */
  {"\x47", 0, 0x8F77}, /* East Asian ideograph */
  {"\x4F", 0, 0x8F78}, /* East Asian ideograph */
  {"\x59", 0, 0x8F82}, /* East Asian ideograph */
  {"\x5B", 0, 0x8F81}, /* East Asian ideograph */
  {"\x6B", 0, 0x8F8B}, /* East Asian ideograph */
  {"\x6D", 0, 0x8F8A}, /* East Asian ideograph */
  {"\x7A", 0, 0x8F8F}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page402 = {
  marc8_31page402_flat, 0
};
/* PAGE 401 */
struct yaz_iconv_trie_flat marc8_31page401_flat[] = {
  {"\x2E", 0, 0x8DC4}, /* East Asian ideograph */
  {"\x40", 0, 0x8DF8}, /* East Asian ideograph */
  {"\x46", 0, 0x8E70}, /* East Asian ideograph */
  {"\x57", 0, 0x8DFB}, /* East Asian ideograph */
  {"\x5E", 0, 0x8DF9}, /* East Asian ideograph */
  {"\x5F", 0, 0x8DDE}, /* East Asian ideograph */
  {"\x60", 0, 0x8E2C}, /* East Asian ideograph */
  {"\x6B", 0, 0x8E7F}, /* East Asian ideograph */
  {"\x70", 0, 0x8E9C}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page401 = {
  marc8_31page401_flat, 0
};
/* PAGE 400 */
struct yaz_iconv_trie_flat marc8_31page400_flat[] = {
  {"\x66", 0, 0x8DB1}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page400 = {
  marc8_31page400_flat, 0
};
/* PAGE 399 */
struct yaz_iconv_trie_flat marc8_31page399_flat[] = {
  {"\x25", 0, 0x8D3D}, /* East Asian ideograph */
  {"\x26", 0, 0x8D5C}, /* East Asian ideograph */
  {"\x3A", 0, 0x8D46}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page399 = {
  marc8_31page399_flat, 0
};
/* PAGE 398 */
struct yaz_iconv_trie_flat marc8_31page398_flat[] = {
  {"\x4E", 0, 0x8D33}, /* East Asian ideograph */
  {"\x51", 0, 0x8D36}, /* East Asian ideograph */
  {"\x5F", 0, 0x8D47}, /* East Asian ideograph */
  {"\x6A", 0, 0x8D53}, /* East Asian ideograph */
  {"\x6B", 0, 0x8D55}, /* East Asian ideograph */
  {"\x70", 0, 0x8D49}, /* East Asian ideograph */
  {"\x7E", 0, 0x8D59}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page398 = {
  marc8_31page398_flat, 0
};
/* PAGE 397 */
struct yaz_iconv_trie_flat marc8_31page397_flat[] = {
  {"\x2D", 0, 0x8C30}, /* East Asian ideograph */
  {"\x37", 0, 0x8C20}, /* East Asian ideograph */
  {"\x39", 0, 0x8C33}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page397 = {
  marc8_31page397_flat, 0
};
/* PAGE 396 */
struct yaz_iconv_trie_flat marc8_31page396_flat[] = {
  {"\x30", 0, 0x8BB4}, /* East Asian ideograph */
  {"\x38", 0, 0x8C29}, /* East Asian ideograph */
  {"\x4D", 0, 0x8C2E}, /* East Asian ideograph */
  {"\x59", 0, 0x8C2F}, /* East Asian ideograph */
  {"\x68", 0, 0x8C35}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page396 = {
  marc8_31page396_flat, 0
};
/* PAGE 395 */
struct yaz_iconv_trie_flat marc8_31page395_flat[] = {
  {"\x25", 0, 0x8BF9}, /* East Asian ideograph */
  {"\x2C", 0, 0x8BFC}, /* East Asian ideograph */
  {"\x36", 0, 0x8BE4}, /* East Asian ideograph */
  {"\x38", 0, 0x8BFD}, /* East Asian ideograph */
  {"\x3B", 0, 0x8C00}, /* East Asian ideograph */
  {"\x40", 0, 0x8C02}, /* East Asian ideograph */
  {"\x44", 0, 0x8C19}, /* East Asian ideograph */
  {"\x45", 0, 0x8BE8}, /* East Asian ideograph */
  {"\x4E", 0, 0x8C0C}, /* East Asian ideograph */
  {"\x57", 0, 0x8C14}, /* East Asian ideograph */
  {"\x59", 0, 0x8C11}, /* East Asian ideograph */
  {"\x5D", 0, 0x8C16}, /* East Asian ideograph */
  {"\x62", 0, 0x8C1D}, /* East Asian ideograph */
  {"\x73", 0, 0x8C21}, /* East Asian ideograph */
  {"\x7A", 0, 0x8BCC}, /* East Asian ideograph */
  {"\x7D", 0, 0x8C27}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page395 = {
  marc8_31page395_flat, 0
};
/* PAGE 394 */
struct yaz_iconv_trie_flat marc8_31page394_flat[] = {
  {"\x2A", 0, 0x8BB5}, /* East Asian ideograph */
  {"\x3B", 0, 0x8BCE}, /* East Asian ideograph */
  {"\x3C", 0, 0x8BD2}, /* East Asian ideograph */
  {"\x4F", 0, 0x8BD6}, /* East Asian ideograph */
  {"\x50", 0, 0x8BD3}, /* East Asian ideograph */
  {"\x56", 0, 0x8BE9}, /* East Asian ideograph */
  {"\x5D", 0, 0x8BD4}, /* East Asian ideograph */
  {"\x5E", 0, 0x8BDC}, /* East Asian ideograph */
  {"\x71", 0, 0x8BEE}, /* East Asian ideograph */
  {"\x7E", 0, 0x8C07}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page394 = {
  marc8_31page394_flat, 0
};
/* PAGE 393 */
struct yaz_iconv_trie_flat marc8_31page393_flat[] = {
  {"\x2B", 0, 0x89D1}, /* East Asian ideograph */
  {"\x32", 0, 0x89CC}, /* East Asian ideograph */
  {"\x60", 0, 0x89EF}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page393 = {
  marc8_31page393_flat, 0
};
/* PAGE 392 */
struct yaz_iconv_trie_flat marc8_31page392_flat[] = {
  {"\x2D", 0, 0x88E3}, /* East Asian ideograph */
  {"\x32", 0, 0x7962}, /* East Asian ideograph */
  {"\x66", 0, 0x89C7}, /* East Asian ideograph */
  {"\x6F", 0, 0x89CB}, /* East Asian ideograph */
  {"\x7D", 0, 0x89CF}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page392 = {
  marc8_31page392_flat, 0
};
/* PAGE 391 */
struct yaz_iconv_trie_flat marc8_31page391_flat[] = {
  {"\x60", 0, 0x88E2}, /* East Asian ideograph */
  {"\x72", 0, 0x88E5}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page391 = {
  marc8_31page391_flat, 0
};
/* PAGE 390 */
struct yaz_iconv_trie_flat marc8_31page390_flat[] = {
  {"\x51", 0, 0x8511}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page390 = {
  marc8_31page390_flat, 0
};
/* PAGE 389 */
struct yaz_iconv_trie_flat marc8_31page389_flat[] = {
  {"\x4C", 0, 0x866E}, /* East Asian ideograph */
  {"\x55", 0, 0x86CF}, /* East Asian ideograph */
  {"\x5D", 0, 0x867F}, /* East Asian ideograph */
  {"\x61", 0, 0x86F4}, /* East Asian ideograph */
  {"\x64", 0, 0x877E}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page389 = {
  marc8_31page389_flat, 0
};
/* PAGE 388 */
struct yaz_iconv_trie_flat marc8_31page388_flat[] = {
  {"\x55", 0, 0x86F3}, /* East Asian ideograph */
  {"\x6E", 0, 0x86F0}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page388 = {
  marc8_31page388_flat, 0
};
/* PAGE 387 */
struct yaz_iconv_trie_flat marc8_31page387_flat[] = {
  {"\x2F", 0, 0x86F1}, /* East Asian ideograph */
  {"\x34", 0, 0x86AC}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page387 = {
  marc8_31page387_flat, 0
};
/* PAGE 386 */
struct yaz_iconv_trie_flat marc8_31page386_flat[] = {
  {"\x2A", 0, 0x8539}, /* East Asian ideograph */
  {"\x40", 0, 0x84E0}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page386 = {
  marc8_31page386_flat, 0
};
/* PAGE 385 */
struct yaz_iconv_trie_flat marc8_31page385_flat[] = {
  {"\x52", 0, 0x830F}, /* East Asian ideograph */
  {"\x65", 0, 0x82C8}, /* East Asian ideograph */
  {"\x68", 0, 0x8572}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page385 = {
  marc8_31page385_flat, 0
};
/* PAGE 384 */
struct yaz_iconv_trie_flat marc8_31page384_flat[] = {
  {"\x33", 0, 0x84E3}, /* East Asian ideograph */
  {"\x51", 0, 0x84DF}, /* East Asian ideograph */
  {"\x57", 0, 0x835F}, /* East Asian ideograph */
  {"\x58", 0, 0x83B6}, /* East Asian ideograph */
  {"\x61", 0, 0x8360}, /* East Asian ideograph */
  {"\x68", 0, 0x8369}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page384 = {
  marc8_31page384_flat, 0
};
/* PAGE 383 */
struct yaz_iconv_trie_flat marc8_31page383_flat[] = {
  {"\x24", 0, 0x848C}, /* East Asian ideograph */
  {"\x2D", 0, 0x8311}, /* East Asian ideograph */
  {"\x35", 0, 0x82C1}, /* East Asian ideograph */
  {"\x46", 0, 0x8368}, /* East Asian ideograph */
  {"\x4B", 0, 0x835B}, /* East Asian ideograph */
  {"\x5A", 0, 0x8487}, /* East Asian ideograph */
  {"\x64", 0, 0x8489}, /* East Asian ideograph */
  {"\x67", 0, 0x836C}, /* East Asian ideograph */
  {"\x71", 0, 0x835E}, /* East Asian ideograph */
  {"\x74", 0, 0x83B8}, /* East Asian ideograph */
  {"\x77", 0, 0x8297}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page383 = {
  marc8_31page383_flat, 0
};
/* PAGE 382 */
struct yaz_iconv_trie_flat marc8_31page382_flat[] = {
  {"\x33", 0, 0x8298}, /* East Asian ideograph (duplicate simplified) */
  {"\x3A", 0, 0x83BC}, /* East Asian ideograph */
  {"\x7D", 0, 0x835C}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page382 = {
  marc8_31page382_flat, 0
};
/* PAGE 381 */
struct yaz_iconv_trie_flat marc8_31page381_flat[] = {
  {"\x3C", 0, 0x836D}, /* East Asian ideograph */
  {"\x3D", 0, 0x836E}, /* East Asian ideograph */
  {"\x75", 0, 0x83B3}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page381 = {
  marc8_31page381_flat, 0
};
/* PAGE 380 */
struct yaz_iconv_trie_dir marc8_31page380_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {382, 0, 0},
  {383, 0, 0},
  {384, 0, 0},
  {385, 0, 0},
  {386, 0, 0},
  {387, 0, 0},
  {0, 0, 0},
  {388, 0, 0},
  {389, 0, 0},
  {390, 0, 0},
  {391, 0, 0},
  {0, 0, 0},
  {392, 0, 0},
  {393, 0, 0},
  {394, 0, 0},
  {395, 0, 0},
  {396, 0, 0},
  {397, 0, 0},
  {398, 0, 0},
  {399, 0, 0},
  {400, 0, 0},
  {401, 0, 0},
  {0, 0, 0},
  {402, 0, 0},
  {403, 0, 0},
  {404, 0, 0},
  {405, 0, 0},
  {0, 0, 0},
  {406, 0, 0},
  {407, 0, 0},
  {408, 0, 0},
  {409, 0, 0},
  {410, 0, 0},
  {411, 0, 0},
  {412, 0, 0},
  {413, 0, 0},
  {414, 0, 0},
  {415, 0, 0},
  {416, 0, 0},
  {417, 0, 0},
  {0, 0, 0},
  {418, 0, 0},
  {0, 0, 0},
  {419, 0, 0},
  {420, 0, 0},
  {421, 0, 0},
  {422, 0, 0},
  {423, 0, 0},
  {424, 0, 0},
  {425, 0, 0},
  {426, 0, 0},
  {427, 0, 0},
  {428, 0, 0},
  {429, 0, 0},
  {430, 0, 0},
  {431, 0, 0},
  {432, 0, 0},
  {433, 0, 0},
  {434, 0, 0},
  {435, 0, 0},
  {436, 0, 0},
  {437, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8_31page380 = {
  0, marc8_31page380_dir
};
/* PAGE 379 */
struct yaz_iconv_trie_flat marc8_31page379_flat[] = {
  {"\x61", 0, 0x82CC}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page379 = {
  marc8_31page379_flat, 0
};
/* PAGE 378 */
struct yaz_iconv_trie_flat marc8_31page378_flat[] = {
  {"\x56", 0, 0x8114}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page378 = {
  marc8_31page378_flat, 0
};
/* PAGE 377 */
struct yaz_iconv_trie_flat marc8_31page377_flat[] = {
  {"\x41", 0, 0x8136}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page377 = {
  marc8_31page377_flat, 0
};
/* PAGE 376 */
struct yaz_iconv_trie_flat marc8_31page376_flat[] = {
  {"\x55", 0, 0x80EB}, /* East Asian ideograph */
  {"\x6E", 0, 0x80E8}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page376 = {
  marc8_31page376_flat, 0
};
/* PAGE 375 */
struct yaz_iconv_trie_flat marc8_31page375_flat[] = {
  {"\x39", 0, 0x8069}, /* East Asian ideograph */
  {"\x3F", 0, 0x804D}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page375 = {
  marc8_31page375_flat, 0
};
/* PAGE 374 */
struct yaz_iconv_trie_flat marc8_31page374_flat[] = {
  {"\x55", 0, 0x8027}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page374 = {
  marc8_31page374_flat, 0
};
/* PAGE 373 */
struct yaz_iconv_trie_flat marc8_31page373_flat[] = {
  {"\x31", 0, 0x7F9F}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page373 = {
  marc8_31page373_flat, 0
};
/* PAGE 372 */
struct yaz_iconv_trie_flat marc8_31page372_flat[] = {
  {"\x2E", 0, 0x7F42}, /* East Asian ideograph */
  {"\x31", 0, 0x575B}, /* East Asian ideograph (duplicate simplified) */
  {"\x72", 0, 0x7F74}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page372 = {
  marc8_31page372_flat, 0
};
/* PAGE 371 */
struct yaz_iconv_trie_flat marc8_31page371_flat[] = {
  {"\x21", 0, 0x7F26}, /* East Asian ideograph */
  {"\x2D", 0, 0x7F2F}, /* East Asian ideograph */
  {"\x49", 0, 0x7F30}, /* East Asian ideograph */
  {"\x4E", 0, 0x7F32}, /* East Asian ideograph */
  {"\x51", 0, 0x7F33}, /* East Asian ideograph */
  {"\x52", 0, 0x7F34}, /* East Asian ideograph */
  {"\x59", 0, 0x7F31}, /* East Asian ideograph */
  {"\x5D", 0, 0x7EA9}, /* East Asian ideograph */
  {"\x60", 0, 0x7F2C}, /* East Asian ideograph */
  {"\x6D", 0, 0x624D}, /* East Asian ideograph */
  {"\x74", 0, 0x7F35}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page371 = {
  marc8_31page371_flat, 0
};
/* PAGE 370 */
struct yaz_iconv_trie_flat marc8_31page370_flat[] = {
  {"\x29", 0, 0x7F17}, /* East Asian ideograph */
  {"\x2A", 0, 0x7F02}, /* East Asian ideograph */
  {"\x31", 0, 0x7F03}, /* East Asian ideograph */
  {"\x36", 0, 0x7F07}, /* East Asian ideograph */
  {"\x3C", 0, 0x7F08}, /* East Asian ideograph */
  {"\x3E", 0, 0x7F0C}, /* East Asian ideograph */
  {"\x47", 0, 0x7F11}, /* East Asian ideograph */
  {"\x48", 0, 0x7F0F}, /* East Asian ideograph */
  {"\x51", 0, 0x7F1F}, /* East Asian ideograph */
  {"\x53", 0, 0x7F12}, /* East Asian ideograph */
  {"\x5D", 0, 0x7F1C}, /* East Asian ideograph */
  {"\x5E", 0, 0x7F19}, /* East Asian ideograph */
  {"\x5F", 0, 0x7F1B}, /* East Asian ideograph */
  {"\x69", 0, 0x7EC9}, /* East Asian ideograph */
  {"\x71", 0, 0x7EA4}, /* East Asian ideograph (duplicate simplified) */
  {"\x72", 0, 0x7F21}, /* East Asian ideograph */
  {"\x75", 0, 0x7D77}, /* East Asian ideograph */
  {"\x79", 0, 0x7F25}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page370 = {
  marc8_31page370_flat, 0
};
/* PAGE 369 */
struct yaz_iconv_trie_flat marc8_31page369_flat[] = {
  {"\x30", 0, 0x7EDB}, /* East Asian ideograph */
  {"\x34", 0, 0x7ED7}, /* East Asian ideograph */
  {"\x39", 0, 0x7EE8}, /* East Asian ideograph */
  {"\x44", 0, 0x7EE0}, /* East Asian ideograph */
  {"\x4D", 0, 0x7EE1}, /* East Asian ideograph */
  {"\x61", 0, 0x7EFB}, /* East Asian ideograph */
  {"\x67", 0, 0x7EEF}, /* East Asian ideograph */
  {"\x74", 0, 0x7EF2}, /* East Asian ideograph */
  {"\x78", 0, 0x7EF6}, /* East Asian ideograph */
  {"\x7D", 0, 0x7EFA}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page369 = {
  marc8_31page369_flat, 0
};
/* PAGE 368 */
struct yaz_iconv_trie_flat marc8_31page368_flat[] = {
  {"\x22", 0, 0x7CC1}, /* East Asian ideograph */
  {"\x2E", 0, 0x56E2}, /* East Asian ideograph (duplicate simplified) */
  {"\x30", 0, 0x7C9D}, /* East Asian ideograph */
  {"\x35", 0, 0x7C74}, /* East Asian ideograph */
  {"\x42", 0, 0x7EA1}, /* East Asian ideograph */
  {"\x45", 0, 0x7EA8}, /* East Asian ideograph */
  {"\x4A", 0, 0x7EBE}, /* East Asian ideograph */
  {"\x61", 0, 0x7EC0}, /* East Asian ideograph */
  {"\x62", 0, 0x7EC1}, /* East Asian ideograph */
  {"\x65", 0, 0x7EC2}, /* East Asian ideograph */
  {"\x6A", 0, 0x7ED0}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page368 = {
  marc8_31page368_flat, 0
};
/* PAGE 367 */
struct yaz_iconv_trie_flat marc8_31page367_flat[] = {
  {"\x56", 0, 0x7BA8}, /* East Asian ideograph */
  {"\x68", 0, 0x7B3E}, /* East Asian ideograph */
  {"\x69", 0, 0x7C16}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page367 = {
  marc8_31page367_flat, 0
};
/* PAGE 366 */
struct yaz_iconv_trie_flat marc8_31page366_flat[] = {
  {"\x47", 0, 0x7BA6}, /* East Asian ideograph */
  {"\x54", 0, 0x7B5A}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page366 = {
  marc8_31page366_flat, 0
};
/* PAGE 365 */
struct yaz_iconv_trie_flat marc8_31page365_flat[] = {
  {"\x58", 0, 0x7BA7}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page365 = {
  marc8_31page365_flat, 0
};
/* PAGE 364 */
struct yaz_iconv_trie_flat marc8_31page364_flat[] = {
  {"\x7C", 0, 0x7B15}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page364 = {
  marc8_31page364_flat, 0
};
/* PAGE 363 */
struct yaz_iconv_trie_flat marc8_31page363_flat[] = {
  {"\x3C", 0, 0x7AAD}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page363 = {
  marc8_31page363_flat, 0
};
/* PAGE 362 */
struct yaz_iconv_trie_flat marc8_31page362_flat[] = {
  {"\x22", 0, 0x7857}, /* East Asian ideograph */
  {"\x55", 0, 0x783B}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page362 = {
  marc8_31page362_flat, 0
};
/* PAGE 361 */
struct yaz_iconv_trie_flat marc8_31page361_flat[] = {
  {"\x40", 0, 0x7800}, /* East Asian ideograph */
  {"\x6A", 0, 0x789B}, /* East Asian ideograph */
  {"\x77", 0, 0x789C}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page361 = {
  marc8_31page361_flat, 0
};
/* PAGE 360 */
struct yaz_iconv_trie_flat marc8_31page360_flat[] = {
  {"\x5A", 0, 0x7817}, /* East Asian ideograph */
  {"\x60", 0, 0x7856}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page360 = {
  marc8_31page360_flat, 0
};
/* PAGE 359 */
struct yaz_iconv_trie_flat marc8_31page359_flat[] = {
  {"\x2C", 0, 0x7751}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page359 = {
  marc8_31page359_flat, 0
};
/* PAGE 358 */
struct yaz_iconv_trie_flat marc8_31page358_flat[] = {
  {"\x22", 0, 0x7726}, /* East Asian ideograph */
  {"\x72", 0, 0x770D}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page358 = {
  marc8_31page358_flat, 0
};
/* PAGE 357 */
struct yaz_iconv_trie_flat marc8_31page357_flat[] = {
  {"\x2B", 0, 0x762A}, /* East Asian ideograph */
  {"\x32", 0, 0x75AC}, /* East Asian ideograph */
  {"\x37", 0, 0x763F}, /* East Asian ideograph */
  {"\x3A", 0, 0x75C8}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page357 = {
  marc8_31page357_flat, 0
};
/* PAGE 356 */
struct yaz_iconv_trie_flat marc8_31page356_flat[] = {
  {"\x48", 0, 0x7617}, /* East Asian ideograph */
  {"\x5E", 0, 0x7618}, /* East Asian ideograph */
  {"\x6F", 0, 0x7605}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page356 = {
  marc8_31page356_flat, 0
};
/* PAGE 355 */
struct yaz_iconv_trie_flat marc8_31page355_flat[] = {
  {"\x7A", 0, 0x75D6}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page355 = {
  marc8_31page355_flat, 0
};
/* PAGE 354 */
struct yaz_iconv_trie_flat marc8_31page354_flat[] = {
  {"\x6B", 0, 0x7572}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page354 = {
  marc8_31page354_flat, 0
};
/* PAGE 353 */
struct yaz_iconv_trie_flat marc8_31page353_flat[] = {
  {"\x3A", 0, 0x748E}, /* East Asian ideograph */
  {"\x40", 0, 0x74D2}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page353 = {
  marc8_31page353_flat, 0
};
/* PAGE 352 */
struct yaz_iconv_trie_flat marc8_31page352_flat[] = {
  {"\x21", 0, 0x740F}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page352 = {
  marc8_31page352_flat, 0
};
/* PAGE 351 */
struct yaz_iconv_trie_flat marc8_31page351_flat[] = {
  {"\x47", 0, 0x73AE}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page351 = {
  marc8_31page351_flat, 0
};
/* PAGE 350 */
struct yaz_iconv_trie_flat marc8_31page350_flat[] = {
  {"\x2B", 0, 0x7303}, /* East Asian ideograph */
  {"\x36", 0, 0x7315}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page350 = {
  marc8_31page350_flat, 0
};
/* PAGE 349 */
struct yaz_iconv_trie_flat marc8_31page349_flat[] = {
  {"\x5E", 0, 0x72B8}, /* East Asian ideograph */
  {"\x5F", 0, 0x72F2}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page349 = {
  marc8_31page349_flat, 0
};
/* PAGE 348 */
struct yaz_iconv_trie_flat marc8_31page348_flat[] = {
  {"\x24", 0, 0x70E8}, /* East Asian ideograph */
  {"\x4F", 0, 0x70EC}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page348 = {
  marc8_31page348_flat, 0
};
/* PAGE 347 */
struct yaz_iconv_trie_flat marc8_31page347_flat[] = {
  {"\x23", 0, 0x8367}, /* East Asian ideograph */
  {"\x3C", 0, 0x709D}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page347 = {
  marc8_31page347_flat, 0
};
/* PAGE 346 */
struct yaz_iconv_trie_flat marc8_31page346_flat[] = {
  {"\x52", 0, 0x709C}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page346 = {
  marc8_31page346_flat, 0
};
/* PAGE 345 */
struct yaz_iconv_trie_flat marc8_31page345_flat[] = {
  {"\x50", 0, 0x70C3}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page345 = {
  marc8_31page345_flat, 0
};
/* PAGE 344 */
struct yaz_iconv_trie_flat marc8_31page344_flat[] = {
  {"\x29", 0, 0x6EDF}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page344 = {
  marc8_31page344_flat, 0
};
/* PAGE 343 */
struct yaz_iconv_trie_flat marc8_31page343_flat[] = {
  {"\x26", 0, 0x6CF7}, /* East Asian ideograph */
  {"\x39", 0, 0x6CF8}, /* East Asian ideograph */
  {"\x5D", 0, 0x6CA3}, /* East Asian ideograph */
  {"\x61", 0, 0x6EE0}, /* East Asian ideograph */
  {"\x6B", 0, 0x6F13}, /* East Asian ideograph */
  {"\x7D", 0, 0x704F}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page343 = {
  marc8_31page343_flat, 0
};
/* PAGE 342 */
struct yaz_iconv_trie_flat marc8_31page342_flat[] = {
  {"\x30", 0, 0x6E11}, /* East Asian ideograph */
  {"\x3E", 0, 0x6CF6}, /* East Asian ideograph */
  {"\x41", 0, 0x6F4B}, /* East Asian ideograph */
  {"\x42", 0, 0x6D4D}, /* East Asian ideograph */
  {"\x62", 0, 0x6F4D}, /* East Asian ideograph */
  {"\x66", 0, 0x6EE2}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page342 = {
  marc8_31page342_flat, 0
};
/* PAGE 341 */
struct yaz_iconv_trie_flat marc8_31page341_flat[] = {
  {"\x27", 0, 0x6D9D}, /* East Asian ideograph */
  {"\x2B", 0, 0x6D54}, /* East Asian ideograph */
  {"\x49", 0, 0x6DA0}, /* East Asian ideograph */
  {"\x58", 0, 0x6CA9}, /* East Asian ideograph */
  {"\x59", 0, 0x6ED7}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page341 = {
  marc8_31page341_flat, 0
};
/* PAGE 340 */
struct yaz_iconv_trie_flat marc8_31page340_flat[] = {
  {"\x2E", 0, 0x6D52}, /* East Asian ideograph */
  {"\x41", 0, 0x6CA4}, /* East Asian ideograph */
  {"\x62", 0, 0x988D}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page340 = {
  marc8_31page340_flat, 0
};
/* PAGE 339 */
struct yaz_iconv_trie_flat marc8_31page339_flat[] = {
  {"\x28", 0, 0x6D48}, /* East Asian ideograph */
  {"\x43", 0, 0x8365}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page339 = {
  marc8_31page339_flat, 0
};
/* PAGE 338 */
struct yaz_iconv_trie_flat marc8_31page338_flat[] = {
  {"\x34", 0, 0x6D43}, /* East Asian ideograph */
  {"\x71", 0, 0x6D9E}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page338 = {
  marc8_31page338_flat, 0
};
/* PAGE 337 */
struct yaz_iconv_trie_flat marc8_31page337_flat[] = {
  {"\x42", 0, 0x6BF5}, /* East Asian ideograph */
  {"\x4C", 0, 0x6BE1}, /* East Asian ideograph */
  {"\x51", 0, 0x6C07}, /* East Asian ideograph */
  {"\x68", 0, 0x6C29}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page337 = {
  marc8_31page337_flat, 0
};
/* PAGE 336 */
struct yaz_iconv_trie_flat marc8_31page336_flat[] = {
  {"\x39", 0, 0x6B9A}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page336 = {
  marc8_31page336_flat, 0
};
/* PAGE 335 */
struct yaz_iconv_trie_flat marc8_31page335_flat[] = {
  {"\x33", 0, 0x680E}, /* East Asian ideograph */
  {"\x35", 0, 0x6A7C}, /* East Asian ideograph */
  {"\x37", 0, 0x6987}, /* East Asian ideograph */
  {"\x39", 0, 0x680A}, /* East Asian ideograph */
  {"\x3A", 0, 0x69E0}, /* East Asian ideograph */
  {"\x40", 0, 0x67A5}, /* East Asian ideograph */
  {"\x45", 0, 0x680C}, /* East Asian ideograph */
  {"\x50", 0, 0x68C2}, /* East Asian ideograph */
  {"\x59", 0, 0x6989}, /* East Asian ideograph */
  {"\x66", 0, 0x6924}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page335 = {
  marc8_31page335_flat, 0
};
/* PAGE 334 */
struct yaz_iconv_trie_flat marc8_31page334_flat[] = {
  {"\x2B", 0, 0x6A2F}, /* East Asian ideograph */
  {"\x57", 0, 0x68BC}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page334 = {
  marc8_31page334_flat, 0
};
/* PAGE 333 */
struct yaz_iconv_trie_flat marc8_31page333_flat[] = {
  {"\x40", 0, 0x6861}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page333 = {
  marc8_31page333_flat, 0
};
/* PAGE 332 */
struct yaz_iconv_trie_flat marc8_31page332_flat[] = {
  {"\x27", 0, 0x6864}, /* East Asian ideograph */
  {"\x56", 0, 0x6920}, /* East Asian ideograph */
  {"\x5E", 0, 0x67FD}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page332 = {
  marc8_31page332_flat, 0
};
/* PAGE 331 */
struct yaz_iconv_trie_flat marc8_31page331_flat[] = {
  {"\x30", 0, 0x6966}, /* East Asian ideograph */
  {"\x5C", 0, 0x6769}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page331 = {
  marc8_31page331_flat, 0
};
/* PAGE 330 */
struct yaz_iconv_trie_flat marc8_31page330_flat[] = {
  {"\x30", 0, 0x67A7}, /* East Asian ideograph */
  {"\x6E", 0, 0x67A8}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page330 = {
  marc8_31page330_flat, 0
};
/* PAGE 329 */
struct yaz_iconv_trie_flat marc8_31page329_flat[] = {
  {"\x22", 0, 0x4E2B}, /* East Asian ideograph */
  {"\x7D", 0, 0x53F0}, /* East Asian ideograph (duplicate simplified) */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page329 = {
  marc8_31page329_flat, 0
};
/* PAGE 328 */
struct yaz_iconv_trie_flat marc8_31page328_flat[] = {
  {"\x55", 0, 0x6619}, /* East Asian ideograph */
  {"\x5C", 0, 0x6654}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page328 = {
  marc8_31page328_flat, 0
};
/* PAGE 327 */
struct yaz_iconv_trie_flat marc8_31page327_flat[] = {
  {"\x71", 0, 0x6593}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page327 = {
  marc8_31page327_flat, 0
};
/* PAGE 326 */
struct yaz_iconv_trie_flat marc8_31page326_flat[] = {
  {"\x2A", 0, 0x6448}, /* East Asian ideograph */
  {"\x42", 0, 0x64B7}, /* East Asian ideograph */
  {"\x46", 0, 0x6445}, /* East Asian ideograph */
  {"\x5B", 0, 0x6484}, /* East Asian ideograph */
  {"\x61", 0, 0x64BA}, /* East Asian ideograph */
  {"\x6D", 0, 0x6512}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page326 = {
  marc8_31page326_flat, 0
};
/* PAGE 325 */
struct yaz_iconv_trie_flat marc8_31page325_flat[] = {
  {"\x2C", 0, 0x63BA}, /* East Asian ideograph */
  {"\x2E", 0, 0x63BC}, /* East Asian ideograph */
  {"\x57", 0, 0x63B8}, /* East Asian ideograph */
  {"\x62", 0, 0x6322}, /* East Asian ideograph */
  {"\x66", 0, 0x63FF}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page325 = {
  marc8_31page325_flat, 0
};
/* PAGE 324 */
struct yaz_iconv_trie_flat marc8_31page324_flat[] = {
  {"\x6F", 0, 0x629F}, /* East Asian ideograph */
  {"\x7B", 0, 0x62A0}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page324 = {
  marc8_31page324_flat, 0
};
/* PAGE 323 */
struct yaz_iconv_trie_flat marc8_31page323_flat[] = {
  {"\x43", 0, 0x6206}, /* East Asian ideograph */
  {"\x47", 0, 0x620B}, /* East Asian ideograph */
  {"\x66", 0, 0x6217}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page323 = {
  marc8_31page323_flat, 0
};
/* PAGE 322 */
struct yaz_iconv_trie_flat marc8_31page322_flat[] = {
  {"\x4C", 0, 0x6126}, /* East Asian ideograph */
  {"\x52", 0, 0x6003}, /* East Asian ideograph */
  {"\x5C", 0, 0x603F}, /* East Asian ideograph */
  {"\x79", 0, 0x6079}, /* East Asian ideograph */
  {"\x7E", 0, 0x603C}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page322 = {
  marc8_31page322_flat, 0
};
/* PAGE 321 */
struct yaz_iconv_trie_flat marc8_31page321_flat[] = {
  {"\x34", 0, 0x607D}, /* East Asian ideograph */
  {"\x5E", 0, 0x607A}, /* East Asian ideograph */
  {"\x74", 0, 0x6004}, /* East Asian ideograph */
  {"\x77", 0, 0x60AD}, /* East Asian ideograph */
  {"\x79", 0, 0x60AB}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page321 = {
  marc8_31page321_flat, 0
};
/* PAGE 320 */
struct yaz_iconv_trie_flat marc8_31page320_flat[] = {
  {"\x51", 0, 0x5F2A}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page320 = {
  marc8_31page320_flat, 0
};
/* PAGE 319 */
struct yaz_iconv_trie_flat marc8_31page319_flat[] = {
  {"\x68", 0, 0x5E91}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page319 = {
  marc8_31page319_flat, 0
};
/* PAGE 318 */
struct yaz_iconv_trie_flat marc8_31page318_flat[] = {
  {"\x36", 0, 0x5E0F}, /* East Asian ideograph */
  {"\x47", 0, 0x5E3B}, /* East Asian ideograph */
  {"\x5F", 0, 0x5E31}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page318 = {
  marc8_31page318_flat, 0
};
/* PAGE 317 */
struct yaz_iconv_trie_flat marc8_31page317_flat[] = {
  {"\x26", 0, 0x5CC4}, /* East Asian ideograph */
  {"\x32", 0, 0x5D58}, /* East Asian ideograph */
  {"\x47", 0, 0x5CBF}, /* East Asian ideograph */
  {"\x59", 0, 0x5DEF}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page317 = {
  marc8_31page317_flat, 0
};
/* PAGE 316 */
struct yaz_iconv_trie_flat marc8_31page316_flat[] = {
  {"\x5A", 0, 0x5D5D}, /* East Asian ideograph */
  {"\x69", 0, 0x5D02}, /* East Asian ideograph */
  {"\x77", 0, 0x5CE4}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page316 = {
  marc8_31page316_flat, 0
};
/* PAGE 315 */
struct yaz_iconv_trie_flat marc8_31page315_flat[] = {
  {"\x41", 0, 0x5C98}, /* East Asian ideograph */
  {"\x58", 0, 0x5D03}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page315 = {
  marc8_31page315_flat, 0
};
/* PAGE 314 */
struct yaz_iconv_trie_flat marc8_31page314_flat[] = {
  {"\x2B", 0, 0x5C66}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page314 = {
  marc8_31page314_flat, 0
};
/* PAGE 313 */
struct yaz_iconv_trie_dir marc8_31page313_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {315, 0, 0},
  {316, 0, 0},
  {317, 0, 0},
  {318, 0, 0},
  {319, 0, 0},
  {320, 0, 0},
  {321, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {322, 0, 0},
  {323, 0, 0},
  {324, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {325, 0, 0},
  {326, 0, 0},
  {327, 0, 0},
  {328, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {329, 0, 0},
  {0, 0, 0},
  {330, 0, 0},
  {0, 0, 0},
  {331, 0, 0},
  {0, 0, 0},
  {332, 0, 0},
  {333, 0, 0},
  {334, 0, 0},
  {335, 0, 0},
  {336, 0, 0},
  {0, 0, 0},
  {337, 0, 0},
  {338, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {339, 0, 0},
  {0, 0, 0},
  {340, 0, 0},
  {341, 0, 0},
  {342, 0, 0},
  {343, 0, 0},
  {344, 0, 0},
  {345, 0, 0},
  {346, 0, 0},
  {347, 0, 0},
  {348, 0, 0},
  {349, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {350, 0, 0},
  {351, 0, 0},
  {0, 0, 0},
  {352, 0, 0},
  {353, 0, 0},
  {354, 0, 0},
  {355, 0, 0},
  {356, 0, 0},
  {357, 0, 0},
  {358, 0, 0},
  {0, 0, 0},
  {359, 0, 0},
  {360, 0, 0},
  {361, 0, 0},
  {362, 0, 0},
  {363, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {364, 0, 0},
  {365, 0, 0},
  {366, 0, 0},
  {367, 0, 0},
  {368, 0, 0},
  {0, 0, 0},
  {369, 0, 0},
  {370, 0, 0},
  {371, 0, 0},
  {372, 0, 0},
  {373, 0, 0},
  {374, 0, 0},
  {375, 0, 0},
  {376, 0, 0},
  {377, 0, 0},
  {378, 0, 0},
  {379, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {380, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8_31page313 = {
  0, marc8_31page313_dir
};
/* PAGE 312 */
struct yaz_iconv_trie_flat marc8_31page312_flat[] = {
  {"\x2B", 0, 0x5A06}, /* East Asian ideograph */
  {"\x40", 0, 0x5AF1}, /* East Asian ideograph */
  {"\x48", 0, 0x5AD2}, /* East Asian ideograph */
  {"\x74", 0, 0x5A08}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page312 = {
  marc8_31page312_flat, 0
};
/* PAGE 311 */
struct yaz_iconv_trie_flat marc8_31page311_flat[] = {
  {"\x24", 0, 0x5A32}, /* East Asian ideograph */
  {"\x36", 0, 0x59AB}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page311 = {
  marc8_31page311_flat, 0
};
/* PAGE 310 */
struct yaz_iconv_trie_flat marc8_31page310_flat[] = {
  {"\x3C", 0, 0x5A05}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page310 = {
  marc8_31page310_flat, 0
};
/* PAGE 309 */
struct yaz_iconv_trie_flat marc8_31page309_flat[] = {
  {"\x54", 0, 0x5956}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page309 = {
  marc8_31page309_flat, 0
};
/* PAGE 308 */
struct yaz_iconv_trie_flat marc8_31page308_flat[] = {
  {"\x5A", 0, 0x5785}, /* East Asian ideograph */
  {"\x5E", 0, 0x5786}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page308 = {
  marc8_31page308_flat, 0
};
/* PAGE 307 */
struct yaz_iconv_trie_flat marc8_31page307_flat[] = {
  {"\x42", 0, 0x57D8}, /* East Asian ideograph */
  {"\x45", 0, 0x57D9}, /* East Asian ideograph */
  {"\x48", 0, 0x57B2}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page307 = {
  marc8_31page307_flat, 0
};
/* PAGE 306 */
struct yaz_iconv_trie_flat marc8_31page306_flat[] = {
  {"\x38", 0, 0x57AD}, /* East Asian ideograph */
  {"\x7A", 0, 0x57DA}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page306 = {
  marc8_31page306_flat, 0
};
/* PAGE 305 */
struct yaz_iconv_trie_flat marc8_31page305_flat[] = {
  {"\x2E", 0, 0x56F5}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page305 = {
  marc8_31page305_flat, 0
};
/* PAGE 304 */
struct yaz_iconv_trie_flat marc8_31page304_flat[] = {
  {"\x28", 0, 0x54DC}, /* East Asian ideograph */
  {"\x45", 0, 0x556E}, /* East Asian ideograph */
  {"\x4C", 0, 0x5456}, /* East Asian ideograph */
  {"\x5A", 0, 0x55BE}, /* East Asian ideograph */
  {"\x60", 0, 0x5181}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page304 = {
  marc8_31page304_flat, 0
};
/* PAGE 303 */
struct yaz_iconv_trie_flat marc8_31page303_flat[] = {
  {"\x34", 0, 0x551B}, /* East Asian ideograph */
  {"\x39", 0, 0x54D4}, /* East Asian ideograph */
  {"\x55", 0, 0x54D3}, /* East Asian ideograph */
  {"\x58", 0, 0x6076}, /* East Asian ideograph (duplicate simplified) */
  {"\x67", 0, 0x5452}, /* East Asian ideograph */
  {"\x72", 0, 0x54D2}, /* East Asian ideograph */
  {"\x7A", 0, 0x54D5}, /* East Asian ideograph */
  {"\x7E", 0, 0x54D9}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page303 = {
  marc8_31page303_flat, 0
};
/* PAGE 302 */
struct yaz_iconv_trie_flat marc8_31page302_flat[] = {
  {"\x69", 0, 0x5522}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page302 = {
  marc8_31page302_flat, 0
};
/* PAGE 301 */
struct yaz_iconv_trie_flat marc8_31page301_flat[] = {
  {"\x30", 0, 0x5457}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page301 = {
  marc8_31page301_flat, 0
};
/* PAGE 300 */
struct yaz_iconv_trie_flat marc8_31page300_flat[] = {
  {"\x69", 0, 0x5459}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page300 = {
  marc8_31page300_flat, 0
};
/* PAGE 299 */
struct yaz_iconv_trie_flat marc8_31page299_flat[] = {
  {"\x2A", 0, 0x53A3}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page299 = {
  marc8_31page299_flat, 0
};
/* PAGE 298 */
struct yaz_iconv_trie_flat marc8_31page298_flat[] = {
  {"\x2E", 0, 0x5326}, /* East Asian ideograph */
  {"\x6D", 0, 0x538D}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page298 = {
  marc8_31page298_flat, 0
};
/* PAGE 297 */
struct yaz_iconv_trie_flat marc8_31page297_flat[] = {
  {"\x3E", 0, 0x522D}, /* East Asian ideograph */
  {"\x5B", 0, 0x5250}, /* East Asian ideograph */
  {"\x5F", 0, 0x672D}, /* East Asian ideograph */
  {"\x79", 0, 0x523F}, /* East Asian ideograph */
  {"\x7A", 0, 0x523D}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page297 = {
  marc8_31page297_flat, 0
};
/* PAGE 296 */
struct yaz_iconv_trie_flat marc8_31page296_flat[] = {
  {"\x44", 0, 0x50A9}, /* East Asian ideograph */
  {"\x48", 0, 0x50A5}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page296 = {
  marc8_31page296_flat, 0
};
/* PAGE 295 */
struct yaz_iconv_trie_flat marc8_31page295_flat[] = {
  {"\x22", 0, 0x507B}, /* East Asian ideograph */
  {"\x42", 0, 0x507E}, /* East Asian ideograph */
  {"\x71", 0, 0x4FAA}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page295 = {
  marc8_31page295_flat, 0
};
/* PAGE 294 */
struct yaz_iconv_trie_flat marc8_31page294_flat[] = {
  {"\x75", 0, 0x4F65}, /* East Asian ideograph */
  {"\x7C", 0, 0x4F1B}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page294 = {
  marc8_31page294_flat, 0
};
/* PAGE 293 */
struct yaz_iconv_trie_flat marc8_31page293_flat[] = {
  {"\x49", 0, 0x4F1C}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page293 = {
  marc8_31page293_flat, 0
};
/* PAGE 292 */
struct yaz_iconv_trie_flat marc8_31page292_flat[] = {
  {"\x21", 0, 0x9F7F}, /* East Asian ideograph */
  {"\x22", 0, 0x9F83}, /* East Asian ideograph */
  {"\x24", 0, 0x9F84}, /* East Asian ideograph */
  {"\x25", 0, 0x9F88}, /* East Asian ideograph */
  {"\x26", 0, 0x9F87}, /* East Asian ideograph */
  {"\x27", 0, 0x9F89}, /* East Asian ideograph */
  {"\x28", 0, 0x9F8A}, /* East Asian ideograph */
  {"\x29", 0, 0x9F8C}, /* East Asian ideograph */
  {"\x2A", 0, 0x9F8B}, /* East Asian ideograph */
  {"\x2B", 0, 0x9F99}, /* East Asian ideograph */
  {"\x2C", 0, 0x9F9A}, /* East Asian ideograph */
  {"\x2D", 0, 0x9F9F}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page292 = {
  marc8_31page292_flat, 0
};
/* PAGE 291 */
struct yaz_iconv_trie_dir marc8_31page291_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x9CC3} /* East Asian ideograph */,
  {0, 0, 0x9CC5} /* East Asian ideograph */,
  {0, 0, 0x9CAB} /* East Asian ideograph */,
  {0, 0, 0x9CCD} /* East Asian ideograph */,
  {0, 0, 0x9CCF} /* East Asian ideograph */,
  {0, 0, 0x9CA2} /* East Asian ideograph */,
  {0, 0, 0x9CD4} /* East Asian ideograph */,
  {0, 0, 0x9CD7} /* East Asian ideograph */,
  {0, 0, 0x9CDD} /* East Asian ideograph */,
  {0, 0, 0x9CDE} /* East Asian ideograph */,
  {0, 0, 0x9CDC} /* East Asian ideograph */,
  {0, 0, 0x9CD6} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x9C88} /* East Asian ideograph */,
  {0, 0, 0x9E1F} /* East Asian ideograph */,
  {0, 0, 0x9E20} /* East Asian ideograph */,
  {0, 0, 0x9E22} /* East Asian ideograph */,
  {0, 0, 0x9E23} /* East Asian ideograph */,
  {0, 0, 0x51E4} /* East Asian ideograph */,
  {0, 0, 0x9E29} /* East Asian ideograph */,
  {0, 0, 0x9E26} /* East Asian ideograph */,
  {0, 0, 0x9E35} /* East Asian ideograph */,
  {0, 0, 0x9E2A} /* East Asian ideograph */,
  {0, 0, 0x9E2D} /* East Asian ideograph */,
  {0, 0, 0x9E2F} /* East Asian ideograph */,
  {0, 0, 0x9E33} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x9E3F} /* East Asian ideograph */,
  {0, 0, 0x9E3D} /* East Asian ideograph */,
  {0, 0, 0x9E49} /* East Asian ideograph */,
  {0, 0, 0x9E43} /* East Asian ideograph */,
  {0, 0, 0x9E44} /* East Asian ideograph */,
  {0, 0, 0x9E45} /* East Asian ideograph */,
  {0, 0, 0x9E51} /* East Asian ideograph */,
  {0, 0, 0x9E4A} /* East Asian ideograph */,
  {0, 0, 0x9E4C} /* East Asian ideograph */,
  {0, 0, 0x9E4F} /* East Asian ideograph */,
  {0, 0, 0x9E64} /* East Asian ideograph */,
  {0, 0, 0x83BA} /* East Asian ideograph */,
  {0, 0, 0x9E5E} /* East Asian ideograph */,
  {0, 0, 0x9E67} /* East Asian ideograph */,
  {0, 0, 0x9E25} /* East Asian ideograph */,
  {0, 0, 0x9E36} /* East Asian ideograph */,
  {0, 0, 0x9E70} /* East Asian ideograph */,
  {0, 0, 0x9E6D} /* East Asian ideograph */,
  {0, 0, 0x9E66} /* East Asian ideograph */,
  {0, 0, 0x9E3E} /* East Asian ideograph */,
  {0, 0, 0x54B8} /* East Asian ideograph */,
  {0, 0, 0x76D0} /* East Asian ideograph */,
  {0, 0, 0x7877} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x4E3D} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x9EA6} /* East Asian ideograph */,
  {0, 0, 0x9EB8} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x9762} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x4E48} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x70B9} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x515A} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x9EE9} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x51AC} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x9F50} /* East Asian ideograph */,
  {0, 0, 0x658E} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8_31page291 = {
  0, marc8_31page291_dir
};
/* PAGE 290 */
struct yaz_iconv_trie_dir marc8_31page290_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x998A} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x9992} /* East Asian ideograph */,
  {0, 0, 0x9976} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x990D} /* East Asian ideograph */,
  {0, 0, 0x998B} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x9A6C} /* East Asian ideograph */,
  {0, 0, 0x51AF} /* East Asian ideograph */,
  {0, 0, 0x9A6D} /* East Asian ideograph */,
  {0, 0, 0x9A70} /* East Asian ideograph */,
  {0, 0, 0x9A6E} /* East Asian ideograph */,
  {0, 0, 0x9A6F} /* East Asian ideograph */,
  {0, 0, 0x9A73} /* East Asian ideograph */,
  {0, 0, 0x9A7B} /* East Asian ideograph */,
  {0, 0, 0x9A7C} /* East Asian ideograph */,
  {0, 0, 0x9A7E} /* East Asian ideograph */,
  {0, 0, 0x9A77} /* East Asian ideograph */,
  {0, 0, 0x9A76} /* East Asian ideograph */,
  {0, 0, 0x9A79} /* East Asian ideograph */,
  {0, 0, 0x9A78} /* East Asian ideograph */,
  {0, 0, 0x9A7D} /* East Asian ideograph */,
  {0, 0, 0x9A87} /* East Asian ideograph */,
  {0, 0, 0x9A86} /* East Asian ideograph */,
  {0, 0, 0x9A8B} /* East Asian ideograph */,
  {0, 0, 0x9A8F} /* East Asian ideograph */,
  {0, 0, 0x9A88} /* East Asian ideograph */,
  {0, 0, 0x9A91} /* East Asian ideograph */,
  {0, 0, 0x9A97} /* East Asian ideograph */,
  {0, 0, 0x9A9B} /* East Asian ideograph */,
  {0, 0, 0x9A9E} /* East Asian ideograph */,
  {0, 0, 0x817E} /* East Asian ideograph */,
  {0, 0, 0x9A9A} /* East Asian ideograph */,
  {0, 0, 0x9AA0} /* East Asian ideograph */,
  {0, 0, 0x9A71} /* East Asian ideograph */,
  {0, 0, 0x84E6} /* East Asian ideograph */,
  {0, 0, 0x9AA1} /* East Asian ideograph */,
  {0, 0, 0x9A84} /* East Asian ideograph */,
  {0, 0, 0x60CA} /* East Asian ideograph */,
  {0, 0, 0x9A7F} /* East Asian ideograph */,
  {0, 0, 0x9A8C} /* East Asian ideograph */,
  {0, 0, 0x9AA4} /* East Asian ideograph */,
  {0, 0, 0x9A74} /* East Asian ideograph */,
  {0, 0, 0x9AA5} /* East Asian ideograph */,
  {0, 0, 0x9A8A} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x80AE} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x9AC5} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x4F53} /* East Asian ideograph */,
  {0, 0, 0x810F} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x53D1} /* East Asian ideograph (duplicate simplified) */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x677E} /* East Asian ideograph (duplicate simplified) */,
  {0, 0, 0x80E1} /* East Asian ideograph (duplicate simplified) */,
  {0, 0, 0x987B} /* East Asian ideograph (duplicate simplified) */,
  {0, 0, 0x9B13} /* East Asian ideograph */,
  {0, 0, 0x6597} /* East Asian ideograph */,
  {0, 0, 0x95F9} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x90C1} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x9B47} /* East Asian ideograph */,
  {0, 0, 0x9C7C} /* East Asian ideograph */,
  {0, 0, 0x9C7F} /* East Asian ideograph */,
  {0, 0, 0x9C81} /* East Asian ideograph */,
  {0, 0, 0x9C8D} /* East Asian ideograph */,
  {0, 0, 0x9C9B} /* East Asian ideograph */,
  {0, 0, 0x9C9C} /* East Asian ideograph */,
  {0, 0, 0x9C94} /* East Asian ideograph */,
  {0, 0, 0x9CA8} /* East Asian ideograph */,
  {0, 0, 0x9CA4} /* East Asian ideograph */,
  {0, 0, 0x9CB8} /* East Asian ideograph */,
  {0, 0, 0x9CB3} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8_31page290 = {
  0, marc8_31page290_dir
};
/* PAGE 289 */
struct yaz_iconv_trie_dir marc8_31page289_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x5DE9} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x9791} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x97E6} /* East Asian ideograph */,
  {0, 0, 0x97E7} /* East Asian ideograph */,
  {0, 0, 0x97E9} /* East Asian ideograph */,
  {0, 0, 0x97EC} /* East Asian ideograph */,
  {0, 0, 0x827D} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x54CD} /* East Asian ideograph */,
  {0, 0, 0x9875} /* East Asian ideograph */,
  {0, 0, 0x9876} /* East Asian ideograph */,
  {0, 0, 0x9877} /* East Asian ideograph */,
  {0, 0, 0x9879} /* East Asian ideograph */,
  {0, 0, 0x987A} /* East Asian ideograph */,
  {0, 0, 0x987B} /* East Asian ideograph */,
  {0, 0, 0x9884} /* East Asian ideograph */,
  {0, 0, 0x987C} /* East Asian ideograph */,
  {0, 0, 0x987D} /* East Asian ideograph */,
  {0, 0, 0x987F} /* East Asian ideograph */,
  {0, 0, 0x9881} /* East Asian ideograph */,
  {0, 0, 0x9882} /* East Asian ideograph */,
  {0, 0, 0x9887} /* East Asian ideograph */,
  {0, 0, 0x9886} /* East Asian ideograph */,
  {0, 0, 0x9889} /* East Asian ideograph */,
  {0, 0, 0x5934} /* East Asian ideograph */,
  {0, 0, 0x988A} /* East Asian ideograph */,
  {0, 0, 0x9888} /* East Asian ideograph */,
  {0, 0, 0x9891} /* East Asian ideograph */,
  {0, 0, 0x9893} /* East Asian ideograph */,
  {0, 0, 0x9894} /* East Asian ideograph */,
  {0, 0, 0x9890} /* East Asian ideograph */,
  {0, 0, 0x9897} /* East Asian ideograph */,
  {0, 0, 0x989C} /* East Asian ideograph */,
  {0, 0, 0x989D} /* East Asian ideograph */,
  {0, 0, 0x9898} /* East Asian ideograph */,
  {0, 0, 0x989A} /* East Asian ideograph */,
  {0, 0, 0x989B} /* East Asian ideograph */,
  {0, 0, 0x7C7B} /* East Asian ideograph */,
  {0, 0, 0x98A0} /* East Asian ideograph */,
  {0, 0, 0x613F} /* East Asian ideograph */,
  {0, 0, 0x987E} /* East Asian ideograph */,
  {0, 0, 0x98A4} /* East Asian ideograph */,
  {0, 0, 0x663E} /* East Asian ideograph */,
  {0, 0, 0x9885} /* East Asian ideograph */,
  {0, 0, 0x98A6} /* East Asian ideograph */,
  {0, 0, 0x98CE} /* East Asian ideograph */,
  {0, 0, 0x98D2} /* East Asian ideograph */,
  {0, 0, 0x53F0} /* East Asian ideograph (duplicate simplified) */,
  {0, 0, 0x522E} /* East Asian ideograph */,
  {0, 0, 0x98D3} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x98D5} /* East Asian ideograph */,
  {0, 0, 0x98D8} /* East Asian ideograph */,
  {0, 0, 0x98DE} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x9965} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x9968} /* East Asian ideograph */,
  {0, 0, 0x996C} /* East Asian ideograph */,
  {0, 0, 0x996A} /* East Asian ideograph */,
  {0, 0, 0x996E} /* East Asian ideograph */,
  {0, 0, 0x996D} /* East Asian ideograph */,
  {0, 0, 0x9972} /* East Asian ideograph */,
  {0, 0, 0x9974} /* East Asian ideograph */,
  {0, 0, 0x9971} /* East Asian ideograph */,
  {0, 0, 0x9970} /* East Asian ideograph */,
  {0, 0, 0x997A} /* East Asian ideograph */,
  {0, 0, 0x517B} /* East Asian ideograph */,
  {0, 0, 0x9975} /* East Asian ideograph */,
  {0, 0, 0x9977} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x9981} /* East Asian ideograph */,
  {0, 0, 0x4F59} /* East Asian ideograph */,
  {0, 0, 0x997F} /* East Asian ideograph */,
  {0, 0, 0x997C} /* East Asian ideograph */,
  {0, 0, 0x9986} /* East Asian ideograph */,
  {0, 0, 0x996F} /* East Asian ideograph */,
  {0, 0, 0x9984} /* East Asian ideograph */,
  {0, 0, 0x9985} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x998F} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8_31page289 = {
  0, marc8_31page289_dir
};
/* PAGE 288 */
struct yaz_iconv_trie_flat marc8_31page288_flat[] = {
  {"\x23", 0, 0x9648}, /* East Asian ideograph */
  {"\x24", 0, 0x9646}, /* East Asian ideograph */
  {"\x2A", 0, 0x9634}, /* East Asian ideograph */
  {"\x2B", 0, 0x961F}, /* East Asian ideograph */
  {"\x2C", 0, 0x9636}, /* East Asian ideograph */
  {"\x2E", 0, 0x9633}, /* East Asian ideograph */
  {"\x37", 0, 0x9645}, /* East Asian ideograph */
  {"\x39", 0, 0x968F}, /* East Asian ideograph */
  {"\x3A", 0, 0x9669}, /* East Asian ideograph */
  {"\x3B", 0, 0x9690}, /* East Asian ideograph */
  {"\x3C", 0, 0x9647}, /* East Asian ideograph */
  {"\x3D", 0, 0x96B6}, /* East Asian ideograph */
  {"\x3E", 0, 0x53EA}, /* East Asian ideograph (duplicate simplified) */
  {"\x4A", 0, 0x867D}, /* East Asian ideograph */
  {"\x4B", 0, 0x6742}, /* East Asian ideograph */
  {"\x4C", 0, 0x9E21}, /* East Asian ideograph */
  {"\x4D", 0, 0x96CF}, /* East Asian ideograph */
  {"\x4E", 0, 0x53CC}, /* East Asian ideograph */
  {"\x4F", 0, 0x79BB}, /* East Asian ideograph */
  {"\x50", 0, 0x96BE}, /* East Asian ideograph */
  {"\x54", 0, 0x4E91}, /* East Asian ideograph */
  {"\x55", 0, 0x7535}, /* East Asian ideograph */
  {"\x67", 0, 0x96FE}, /* East Asian ideograph */
  {"\x6B", 0, 0x9701}, /* East Asian ideograph */
  {"\x6D", 0, 0x972D}, /* East Asian ideograph */
  {"\x6E", 0, 0x96F3}, /* East Asian ideograph */
  {"\x6F", 0, 0x7075}, /* East Asian ideograph */
  {"\x79", 0, 0x9765}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page288 = {
  marc8_31page288_flat, 0
};
/* PAGE 287 */
struct yaz_iconv_trie_dir marc8_31page287_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x949F} /* East Asian ideograph */,
  {0, 0, 0x9524} /* East Asian ideograph */,
  {0, 0, 0x9539} /* East Asian ideograph */,
  {0, 0, 0x953B} /* East Asian ideograph */,
  {0, 0, 0x9551} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x9547} /* East Asian ideograph */,
  {0, 0, 0x9501} /* East Asian ideograph */,
  {0, 0, 0x94A8} /* East Asian ideograph */,
  {0, 0, 0x954D} /* East Asian ideograph */,
  {0, 0, 0x955C} /* East Asian ideograph */,
  {0, 0, 0x955D} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x955E} /* East Asian ideograph */,
  {0, 0, 0x94F2} /* East Asian ideograph */,
  {0, 0, 0x94FF} /* East Asian ideograph */,
  {0, 0, 0x94FE} /* East Asian ideograph */,
  {0, 0, 0x9556} /* East Asian ideograph */,
  {0, 0, 0x9557} /* East Asian ideograph */,
  {0, 0, 0x9542} /* East Asian ideograph */,
  {0, 0, 0x9558} /* East Asian ideograph */,
  {0, 0, 0x9559} /* East Asian ideograph */,
  {0, 0, 0x9535} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x94D9} /* East Asian ideograph */,
  {0, 0, 0x9570} /* East Asian ideograph */,
  {0, 0, 0x9508} /* East Asian ideograph */,
  {0, 0, 0x956D} /* East Asian ideograph */,
  {0, 0, 0x94C1} /* East Asian ideograph */,
  {0, 0, 0x94DB} /* East Asian ideograph */,
  {0, 0, 0x94CE} /* East Asian ideograph */,
  {0, 0, 0x956F} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x94F8} /* East Asian ideograph */,
  {0, 0, 0x9573} /* East Asian ideograph */,
  {0, 0, 0x94C4} /* East Asian ideograph */,
  {0, 0, 0x9576} /* East Asian ideograph */,
  {0, 0, 0x94A5} /* East Asian ideograph */,
  {0, 0, 0x92AE} /* East Asian ideograph */,
  {0, 0, 0x9523} /* East Asian ideograph */,
  {0, 0, 0x94BB} /* East Asian ideograph */,
  {0, 0, 0x51FF} /* East Asian ideograph */,
  {0, 0, 0x957F} /* East Asian ideograph */,
  {0, 0, 0x95E8} /* East Asian ideograph */,
  {0, 0, 0x95E9} /* East Asian ideograph */,
  {0, 0, 0x95EA} /* East Asian ideograph */,
  {0, 0, 0x95ED} /* East Asian ideograph */,
  {0, 0, 0x95F5} /* East Asian ideograph */,
  {0, 0, 0x95F0} /* East Asian ideograph */,
  {0, 0, 0x5F00} /* East Asian ideograph */,
  {0, 0, 0x95F2} /* East Asian ideograph */,
  {0, 0, 0x95F4} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x95F8} /* East Asian ideograph */,
  {0, 0, 0x9602} /* East Asian ideograph */,
  {0, 0, 0x95FA} /* East Asian ideograph */,
  {0, 0, 0x95FD} /* East Asian ideograph */,
  {0, 0, 0x9601} /* East Asian ideograph */,
  {0, 0, 0x9600} /* East Asian ideograph */,
  {0, 0, 0x5408} /* East Asian ideograph */,
  {0, 0, 0x9605} /* East Asian ideograph */,
  {0, 0, 0x95FE} /* East Asian ideograph */,
  {0, 0, 0x960E} /* East Asian ideograph */,
  {0, 0, 0x9614} /* East Asian ideograph */,
  {0, 0, 0x9615} /* East Asian ideograph */,
  {0, 0, 0x9611} /* East Asian ideograph */,
  {0, 0, 0x95F1} /* East Asian ideograph */,
  {0, 0, 0x677F} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x95EF} /* East Asian ideograph */,
  {0, 0, 0x9617} /* East Asian ideograph */,
  {0, 0, 0x5173} /* East Asian ideograph */,
  {0, 0, 0x9610} /* East Asian ideograph */,
  {0, 0, 0x8F9F} /* East Asian ideograph (duplicate simplified) */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x9635} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8_31page287 = {
  0, marc8_31page287_dir
};
/* PAGE 286 */
struct yaz_iconv_trie_dir marc8_31page286_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x9154} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x915D} /* East Asian ideograph */,
  {0, 0, 0x4E11} /* East Asian ideograph */,
  {0, 0, 0x533B} /* East Asian ideograph */,
  {0, 0, 0x9171} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x917F} /* East Asian ideograph */,
  {0, 0, 0x8845} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x91CA} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x5398} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x9488} /* East Asian ideograph */,
  {0, 0, 0x9489} /* East Asian ideograph */,
  {0, 0, 0x948A} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x9497} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x9493} /* East Asian ideograph */,
  {0, 0, 0x948F} /* East Asian ideograph */,
  {0, 0, 0x9499} /* East Asian ideograph */,
  {0, 0, 0x949D} /* East Asian ideograph */,
  {0, 0, 0x94AE} /* East Asian ideograph */,
  {0, 0, 0x94A0} /* East Asian ideograph */,
  {0, 0, 0x949E} /* East Asian ideograph */,
  {0, 0, 0x94A7} /* East Asian ideograph */,
  {0, 0, 0x94A4} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x94B4} /* East Asian ideograph */,
  {0, 0, 0x94B9} /* East Asian ideograph */,
  {0, 0, 0x94B8} /* East Asian ideograph */,
  {0, 0, 0x94C0} /* East Asian ideograph */,
  {0, 0, 0x94BE} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x94C5} /* East Asian ideograph */,
  {0, 0, 0x94A9} /* East Asian ideograph */,
  {0, 0, 0x94C2} /* East Asian ideograph */,
  {0, 0, 0x94C3} /* East Asian ideograph */,
  {0, 0, 0x94F0} /* East Asian ideograph */,
  {0, 0, 0x94F6} /* East Asian ideograph */,
  {0, 0, 0x94D0} /* East Asian ideograph */,
  {0, 0, 0x94DC} /* East Asian ideograph */,
  {0, 0, 0x94ED} /* East Asian ideograph */,
  {0, 0, 0x94E2} /* East Asian ideograph */,
  {0, 0, 0x94EC} /* East Asian ideograph */,
  {0, 0, 0x94E8} /* East Asian ideograph */,
  {0, 0, 0x8854} /* East Asian ideograph */,
  {0, 0, 0x950C} /* East Asian ideograph */,
  {0, 0, 0x9511} /* East Asian ideograph */,
  {0, 0, 0x9510} /* East Asian ideograph */,
  {0, 0, 0x94FA} /* East Asian ideograph */,
  {0, 0, 0x9500} /* East Asian ideograph */,
  {0, 0, 0x94DD} /* East Asian ideograph */,
  {0, 0, 0x9504} /* East Asian ideograph */,
  {0, 0, 0x9509} /* East Asian ideograph */,
  {0, 0, 0x950B} /* East Asian ideograph */,
  {0, 0, 0x952D} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x952F} /* East Asian ideograph */,
  {0, 0, 0x9530} /* East Asian ideograph */,
  {0, 0, 0x9519} /* East Asian ideograph */,
  {0, 0, 0x94B1} /* East Asian ideograph */,
  {0, 0, 0x94A2} /* East Asian ideograph */,
  {0, 0, 0x9521} /* East Asian ideograph */,
  {0, 0, 0x94EE} /* East Asian ideograph */,
  {0, 0, 0x5F55} /* East Asian ideograph */,
  {0, 0, 0x9525} /* East Asian ideograph */,
  {0, 0, 0x9526} /* East Asian ideograph */,
  {0, 0, 0x9540} /* East Asian ideograph */,
  {0, 0, 0x9541} /* East Asian ideograph */,
  {0, 0, 0x952E} /* East Asian ideograph */,
  {0, 0, 0x9532} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x9505} /* East Asian ideograph */,
  {0, 0, 0x951A} /* East Asian ideograph */,
  {0, 0, 0x953E} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8_31page286 = {
  0, marc8_31page286_dir
};
/* PAGE 285 */
struct yaz_iconv_trie_flat marc8_31page285_flat[] = {
  {"\x33", 0, 0x8FDB}, /* East Asian ideograph */
  {"\x34", 0, 0x8FD0}, /* East Asian ideograph */
  {"\x39", 0, 0x8FBE}, /* East Asian ideograph */
  {"\x3A", 0, 0x8FDD}, /* East Asian ideograph */
  {"\x3C", 0, 0x8FC2}, /* East Asian ideograph */
  {"\x3E", 0, 0x8FC7}, /* East Asian ideograph */
  {"\x44", 0, 0x8FDC}, /* East Asian ideograph */
  {"\x45", 0, 0x900A}, /* East Asian ideograph */
  {"\x48", 0, 0x9012}, /* East Asian ideograph */
  {"\x49", 0, 0x9002}, /* East Asian ideograph */
  {"\x4F", 0, 0x9009}, /* East Asian ideograph */
  {"\x50", 0, 0x8FDF}, /* East Asian ideograph */
  {"\x51", 0, 0x8FC1}, /* East Asian ideograph */
  {"\x52", 0, 0x8FBD}, /* East Asian ideograph */
  {"\x53", 0, 0x9057}, /* East Asian ideograph */
  {"\x56", 0, 0x8FC8}, /* East Asian ideograph */
  {"\x57", 0, 0x8FD8}, /* East Asian ideograph */
  {"\x5A", 0, 0x8FE9}, /* East Asian ideograph (variant of EACC 2D5C5A) */
  {"\x5B", 0, 0x8FB9}, /* East Asian ideograph */
  {"\x5C", 0, 0x9026}, /* East Asian ideograph */
  {"\x5D", 0, 0x903B}, /* East Asian ideograph */
  {"\x6B", 0, 0x5369}, /* East Asian ideograph */
  {"\x6D", 0, 0x90AE}, /* East Asian ideograph */
  {"\x70", 0, 0x4E61}, /* East Asian ideograph */
  {"\x71", 0, 0x90B9}, /* East Asian ideograph */
  {"\x73", 0, 0x90D1}, /* East Asian ideograph */
  {"\x74", 0, 0x90BB}, /* East Asian ideograph */
  {"\x75", 0, 0x9093}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page285 = {
  marc8_31page285_flat, 0
};
/* PAGE 284 */
struct yaz_iconv_trie_dir marc8_31page284_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x8DB8} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x8E0C} /* East Asian ideograph */,
  {0, 0, 0x8DC3} /* East Asian ideograph */,
  {0, 0, 0x8E2F} /* East Asian ideograph */,
  {0, 0, 0x8E51} /* East Asian ideograph */,
  {0, 0, 0x8E8F} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x8EAF} /* East Asian ideograph */,
  {0, 0, 0x8F66} /* East Asian ideograph */,
  {0, 0, 0x8F67} /* East Asian ideograph */,
  {0, 0, 0x519B} /* East Asian ideograph */,
  {0, 0, 0x8F68} /* East Asian ideograph */,
  {0, 0, 0x8F69} /* East Asian ideograph */,
  {0, 0, 0x8F6B} /* East Asian ideograph */,
  {0, 0, 0x8F6F} /* East Asian ideograph */,
  {0, 0, 0x8F6D} /* East Asian ideograph */,
  {0, 0, 0x8F72} /* East Asian ideograph */,
  {0, 0, 0x8F74} /* East Asian ideograph */,
  {0, 0, 0x8F76} /* East Asian ideograph */,
  {0, 0, 0x8F83} /* East Asian ideograph */,
  {0, 0, 0x8F7C} /* East Asian ideograph */,
  {0, 0, 0x8F7D} /* East Asian ideograph */,
  {0, 0, 0x8F7E} /* East Asian ideograph */,
  {0, 0, 0x8F85} /* East Asian ideograph */,
  {0, 0, 0x8F84} /* East Asian ideograph */,
  {0, 0, 0x8F7B} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x8F87} /* East Asian ideograph */,
  {0, 0, 0x8F86} /* East Asian ideograph */,
  {0, 0, 0x8F8D} /* East Asian ideograph */,
  {0, 0, 0x8F89} /* East Asian ideograph */,
  {0, 0, 0x8F88} /* East Asian ideograph */,
  {0, 0, 0x8F6E} /* East Asian ideograph */,
  {0, 0, 0x8F8E} /* East Asian ideograph */,
  {0, 0, 0x8F90} /* East Asian ideograph */,
  {0, 0, 0x8F91} /* East Asian ideograph */,
  {0, 0, 0x8F93} /* East Asian ideograph */,
  {0, 0, 0x8F96} /* East Asian ideograph */,
  {0, 0, 0x8F97} /* East Asian ideograph */,
  {0, 0, 0x8F95} /* East Asian ideograph */,
  {0, 0, 0x6BC2} /* East Asian ideograph */,
  {0, 0, 0x8206} /* East Asian ideograph */,
  {0, 0, 0x8F99} /* East Asian ideograph */,
  {0, 0, 0x8F6C} /* East Asian ideograph */,
  {0, 0, 0x8F9A} /* East Asian ideograph */,
  {0, 0, 0x8F7F} /* East Asian ideograph */,
  {0, 0, 0x8F70} /* East Asian ideograph */,
  {0, 0, 0x8F94} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x529E} /* East Asian ideograph */,
  {0, 0, 0x8F9E} /* East Asian ideograph */,
  {0, 0, 0x8FA9} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x519C} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x8FF0} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x8FD9} /* East Asian ideograph */,
  {0, 0, 0x8FDE} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8_31page284 = {
  0, marc8_31page284_dir
};
/* PAGE 283 */
struct yaz_iconv_trie_flat marc8_31page283_flat[] = {
  {"\x21", 0, 0x8D45}, /* East Asian ideograph */
  {"\x22", 0, 0x8D44}, /* East Asian ideograph */
  {"\x23", 0, 0x8D3C}, /* East Asian ideograph */
  {"\x24", 0, 0x8D3E}, /* East Asian ideograph */
  {"\x25", 0, 0x8D3F}, /* East Asian ideograph */
  {"\x26", 0, 0x8D40}, /* East Asian ideograph */
  {"\x27", 0, 0x8D41}, /* East Asian ideograph */
  {"\x28", 0, 0x8D42}, /* East Asian ideograph */
  {"\x29", 0, 0x5BBE}, /* East Asian ideograph */
  {"\x2A", 0, 0x8D48}, /* East Asian ideograph */
  {"\x2B", 0, 0x8D4A}, /* East Asian ideograph */
  {"\x2C", 0, 0x8D54}, /* East Asian ideograph */
  {"\x2D", 0, 0x8D4B}, /* East Asian ideograph */
  {"\x2F", 0, 0x5356}, /* East Asian ideograph */
  {"\x30", 0, 0x8D24}, /* East Asian ideograph */
  {"\x31", 0, 0x8D31}, /* East Asian ideograph */
  {"\x32", 0, 0x8D4F}, /* East Asian ideograph */
  {"\x33", 0, 0x8D50}, /* East Asian ideograph */
  {"\x34", 0, 0x8D28}, /* East Asian ideograph */
  {"\x35", 0, 0x8D4C}, /* East Asian ideograph */
  {"\x36", 0, 0x8D56}, /* East Asian ideograph */
  {"\x37", 0, 0x8D5B}, /* East Asian ideograph */
  {"\x38", 0, 0x8D5A}, /* East Asian ideograph */
  {"\x39", 0, 0x8D58}, /* East Asian ideograph */
  {"\x3A", 0, 0x8D2D}, /* East Asian ideograph */
  {"\x3B", 0, 0x8D60}, /* East Asian ideograph */
  {"\x3C", 0, 0x8D5D}, /* East Asian ideograph */
  {"\x3D", 0, 0x8D5E}, /* East Asian ideograph */
  {"\x3E", 0, 0x8D62}, /* East Asian ideograph */
  {"\x3F", 0, 0x8D61}, /* East Asian ideograph */
  {"\x40", 0, 0x8D43}, /* East Asian ideograph */
  {"\x41", 0, 0x8D4E}, /* East Asian ideograph */
  {"\x42", 0, 0x8D63}, /* East Asian ideograph */
  {"\x4F", 0, 0x8D75}, /* East Asian ideograph */
  {"\x50", 0, 0x8D76}, /* East Asian ideograph */
  {"\x53", 0, 0x8D8B}, /* East Asian ideograph */
  {"\x68", 0, 0x8DF5}, /* East Asian ideograph */
  {"\x71", 0, 0x8E0A}, /* East Asian ideograph */
  {"\x78", 0, 0x8E52}, /* East Asian ideograph */
  {"\x7E", 0, 0x8DF7}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page283 = {
  marc8_31page283_flat, 0
};
/* PAGE 282 */
struct yaz_iconv_trie_dir marc8_31page282_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x8C04} /* East Asian ideograph */,
  {0, 0, 0x8C01} /* East Asian ideograph */,
  {0, 0, 0x8BDE} /* East Asian ideograph */,
  {0, 0, 0x8BBA} /* East Asian ideograph */,
  {0, 0, 0x8C1B} /* East Asian ideograph */,
  {0, 0, 0x8C1A} /* East Asian ideograph */,
  {0, 0, 0x8C0F} /* East Asian ideograph */,
  {0, 0, 0x8BB3} /* East Asian ideograph */,
  {0, 0, 0x8C10} /* East Asian ideograph */,
  {0, 0, 0x8C0D} /* East Asian ideograph */,
  {0, 0, 0x8C0B} /* East Asian ideograph */,
  {0, 0, 0x8C12} /* East Asian ideograph */,
  {0, 0, 0x8C13} /* East Asian ideograph */,
  {0, 0, 0x8BFA} /* East Asian ideograph */,
  {0, 0, 0x8BBD} /* East Asian ideograph */,
  {0, 0, 0x8C15} /* East Asian ideograph */,
  {0, 0, 0x8C24} /* East Asian ideograph */,
  {0, 0, 0x8C26} /* East Asian ideograph */,
  {0, 0, 0x8C1C} /* East Asian ideograph */,
  {0, 0, 0x8BB2} /* East Asian ideograph */,
  {0, 0, 0x8C0E} /* East Asian ideograph */,
  {0, 0, 0x8C23} /* East Asian ideograph */,
  {0, 0, 0x8A8A} /* East Asian ideograph */,
  {0, 0, 0x8C22} /* East Asian ideograph */,
  {0, 0, 0x8C28} /* East Asian ideograph */,
  {0, 0, 0x8C2C} /* East Asian ideograph */,
  {0, 0, 0x8C1F} /* East Asian ideograph */,
  {0, 0, 0x8BC6} /* East Asian ideograph */,
  {0, 0, 0x8C31} /* East Asian ideograph */,
  {0, 0, 0x8C32} /* East Asian ideograph */,
  {0, 0, 0x8BC1} /* East Asian ideograph */,
  {0, 0, 0x8C2D} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x8BA5} /* East Asian ideograph */,
  {0, 0, 0x8BAE} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x8BD1} /* East Asian ideograph */,
  {0, 0, 0x8C34} /* East Asian ideograph */,
  {0, 0, 0x62A4} /* East Asian ideograph */,
  {0, 0, 0x8A89} /* East Asian ideograph */,
  {0, 0, 0x8BFB} /* East Asian ideograph */,
  {0, 0, 0x53D8} /* East Asian ideograph */,
  {0, 0, 0x8BA9} /* East Asian ideograph */,
  {0, 0, 0x8C36} /* East Asian ideograph */,
  {0, 0, 0x8C17} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x5C82} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x7AD6} /* East Asian ideograph */,
  {0, 0, 0x4E30} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x4E88} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x7683} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x8D1D} /* East Asian ideograph */,
  {0, 0, 0x8D1E} /* East Asian ideograph */,
  {0, 0, 0x8D1F} /* East Asian ideograph */,
  {0, 0, 0x8D21} /* East Asian ideograph */,
  {0, 0, 0x8D22} /* East Asian ideograph */,
  {0, 0, 0x8D23} /* East Asian ideograph */,
  {0, 0, 0x8D2F} /* East Asian ideograph */,
  {0, 0, 0x8D27} /* East Asian ideograph */,
  {0, 0, 0x8D2A} /* East Asian ideograph */,
  {0, 0, 0x8D2B} /* East Asian ideograph */,
  {0, 0, 0x8D29} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x8D39} /* East Asian ideograph */,
  {0, 0, 0x8D32} /* East Asian ideograph */,
  {0, 0, 0x8D3A} /* East Asian ideograph */,
  {0, 0, 0x8D35} /* East Asian ideograph */,
  {0, 0, 0x8D34} /* East Asian ideograph */,
  {0, 0, 0x4E70} /* East Asian ideograph */,
  {0, 0, 0x8D2C} /* East Asian ideograph */,
  {0, 0, 0x8D3B} /* East Asian ideograph */,
  {0, 0, 0x8D37} /* East Asian ideograph */,
  {0, 0, 0x8D38} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8_31page282 = {
  0, marc8_31page282_dir
};
/* PAGE 281 */
struct yaz_iconv_trie_dir marc8_31page281_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x889C} /* East Asian ideograph */,
  {0, 0, 0x886C} /* East Asian ideograph */,
  {0, 0, 0x88AD} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x89C1} /* East Asian ideograph */,
  {0, 0, 0x89C4} /* East Asian ideograph */,
  {0, 0, 0x89C5} /* East Asian ideograph */,
  {0, 0, 0x89C6} /* East Asian ideograph */,
  {0, 0, 0x4EB2} /* East Asian ideograph */,
  {0, 0, 0x89CE} /* East Asian ideograph */,
  {0, 0, 0x89CA} /* East Asian ideograph */,
  {0, 0, 0x89D0} /* East Asian ideograph */,
  {0, 0, 0x89C9} /* East Asian ideograph */,
  {0, 0, 0x89C8} /* East Asian ideograph */,
  {0, 0, 0x89C2} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x89DE} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x8BA1} /* East Asian ideograph */,
  {0, 0, 0x8BA2} /* East Asian ideograph */,
  {0, 0, 0x8BA3} /* East Asian ideograph */,
  {0, 0, 0x8BA6} /* East Asian ideograph */,
  {0, 0, 0x8BB0} /* East Asian ideograph */,
  {0, 0, 0x8BA8} /* East Asian ideograph */,
  {0, 0, 0x8BA7} /* East Asian ideograph */,
  {0, 0, 0x8BAA} /* East Asian ideograph */,
  {0, 0, 0x8BAF} /* East Asian ideograph */,
  {0, 0, 0x8BAB} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x8BAD} /* East Asian ideograph */,
  {0, 0, 0x8BBF} /* East Asian ideograph */,
  {0, 0, 0x8BC0} /* East Asian ideograph */,
  {0, 0, 0x8BB6} /* East Asian ideograph */,
  {0, 0, 0x8BB7} /* East Asian ideograph */,
  {0, 0, 0x8BB8} /* East Asian ideograph */,
  {0, 0, 0x8BBE} /* East Asian ideograph */,
  {0, 0, 0x8BB9} /* East Asian ideograph */,
  {0, 0, 0x8BBC} /* East Asian ideograph */,
  {0, 0, 0x6CE8} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x8BC4} /* East Asian ideograph */,
  {0, 0, 0x8BCD} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x8BC2} /* East Asian ideograph */,
  {0, 0, 0x8BCF} /* East Asian ideograph */,
  {0, 0, 0x8BC5} /* East Asian ideograph */,
  {0, 0, 0x8BC8} /* East Asian ideograph */,
  {0, 0, 0x8BCB} /* East Asian ideograph */,
  {0, 0, 0x8BC9} /* East Asian ideograph */,
  {0, 0, 0x8BCA} /* East Asian ideograph */,
  {0, 0, 0x8BE7} /* East Asian ideograph */,
  {0, 0, 0x8BE5} /* East Asian ideograph */,
  {0, 0, 0x8BE6} /* East Asian ideograph */,
  {0, 0, 0x8BD5} /* East Asian ideograph */,
  {0, 0, 0x8BD7} /* East Asian ideograph */,
  {0, 0, 0x8BD8} /* East Asian ideograph */,
  {0, 0, 0x8BE3} /* East Asian ideograph */,
  {0, 0, 0x8BD9} /* East Asian ideograph */,
  {0, 0, 0x8BDA} /* East Asian ideograph */,
  {0, 0, 0x5938} /* East Asian ideograph */,
  {0, 0, 0x8BDB} /* East Asian ideograph */,
  {0, 0, 0x8BE1} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x8BE2} /* East Asian ideograph */,
  {0, 0, 0x8BDD} /* East Asian ideograph */,
  {0, 0, 0x8BE0} /* East Asian ideograph */,
  {0, 0, 0x8BDF} /* East Asian ideograph */,
  {0, 0, 0x8BF4} /* East Asian ideograph */,
  {0, 0, 0x8BF5} /* East Asian ideograph */,
  {0, 0, 0x8BEB} /* East Asian ideograph */,
  {0, 0, 0x8BED} /* East Asian ideograph */,
  {0, 0, 0x5FD7} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x8BEC} /* East Asian ideograph */,
  {0, 0, 0x8BA4} /* East Asian ideograph */,
  {0, 0, 0x8BEF} /* East Asian ideograph */,
  {0, 0, 0x8BF2} /* East Asian ideograph */,
  {0, 0, 0x8BF0} /* East Asian ideograph */,
  {0, 0, 0x8BF1} /* East Asian ideograph */,
  {0, 0, 0x8BF3} /* East Asian ideograph */,
  {0, 0, 0x8C0A} /* East Asian ideograph */,
  {0, 0, 0x8C06} /* East Asian ideograph */,
  {0, 0, 0x8C05} /* East Asian ideograph */,
  {0, 0, 0x8C08} /* East Asian ideograph */,
  {0, 0, 0x8BF7} /* East Asian ideograph */,
  {0, 0, 0x8BF8} /* East Asian ideograph */,
  {0, 0, 0x8BFE} /* East Asian ideograph */,
  {0, 0, 0x8C03} /* East Asian ideograph */,
  {0, 0, 0x8BFF} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8_31page281 = {
  0, marc8_31page281_dir
};
/* PAGE 280 */
struct yaz_iconv_trie_flat marc8_31page280_flat[] = {
  {"\x24", 0, 0x8424}, /* East Asian ideograph */
  {"\x25", 0, 0x8682}, /* East Asian ideograph */
  {"\x2C", 0, 0x877C}, /* East Asian ideograph */
  {"\x32", 0, 0x86F2}, /* East Asian ideograph */
  {"\x33", 0, 0x866B}, /* East Asian ideograph */
  {"\x34", 0, 0x8749}, /* East Asian ideograph */
  {"\x35", 0, 0x8681}, /* East Asian ideograph */
  {"\x36", 0, 0x8747}, /* East Asian ideograph */
  {"\x3C", 0, 0x86CE}, /* East Asian ideograph */
  {"\x3E", 0, 0x8721}, /* East Asian ideograph */
  {"\x3F", 0, 0x86CA}, /* East Asian ideograph */
  {"\x41", 0, 0x8695}, /* East Asian ideograph */
  {"\x42", 0, 0x86EE}, /* East Asian ideograph */
  {"\x46", 0, 0x672E}, /* East Asian ideograph */
  {"\x47", 0, 0x4E8D}, /* East Asian ideograph */
  {"\x49", 0, 0x536B}, /* East Asian ideograph */
  {"\x4A", 0, 0x51B2}, /* East Asian ideograph (duplicate simplified) */
  {"\x62", 0, 0x8865}, /* East Asian ideograph */
  {"\x63", 0, 0x91CC}, /* East Asian ideograph */
  {"\x65", 0, 0x88C5}, /* East Asian ideograph */
  {"\x6C", 0, 0x5236}, /* East Asian ideograph */
  {"\x71", 0, 0x8934}, /* East Asian ideograph */
  {"\x73", 0, 0x88E4}, /* East Asian ideograph */
  {"\x77", 0, 0x4EB5}, /* East Asian ideograph */
  {"\x79", 0, 0x891B}, /* East Asian ideograph */
  {"\x7C", 0, 0x88C6}, /* East Asian ideograph */
  {"\x7D", 0, 0x8884}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page280 = {
  marc8_31page280_flat, 0
};
/* PAGE 279 */
struct yaz_iconv_trie_flat marc8_31page279_flat[] = {
  {"\x22", 0, 0x8427}, /* East Asian ideograph */
  {"\x24", 0, 0x59DC}, /* East Asian ideograph */
  {"\x26", 0, 0x8537}, /* East Asian ideograph */
  {"\x29", 0, 0x84DD}, /* East Asian ideograph */
  {"\x2A", 0, 0x8428}, /* East Asian ideograph */
  {"\x2E", 0, 0x501F}, /* East Asian ideograph */
  {"\x31", 0, 0x827A}, /* East Asian ideograph */
  {"\x32", 0, 0x85AE}, /* East Asian ideograph */
  {"\x35", 0, 0x836F}, /* East Asian ideograph */
  {"\x37", 0, 0x853C}, /* East Asian ideograph */
  {"\x39", 0, 0x853A}, /* East Asian ideograph */
  {"\x3A", 0, 0x82A6}, /* East Asian ideograph */
  {"\x3B", 0, 0x82F9}, /* East Asian ideograph */
  {"\x3C", 0, 0x82CF}, /* East Asian ideograph */
  {"\x3D", 0, 0x8574}, /* East Asian ideograph */
  {"\x3E", 0, 0x5170}, /* East Asian ideograph */
  {"\x40", 0, 0x85D3}, /* East Asian ideograph */
  {"\x42", 0, 0x841D}, /* East Asian ideograph */
  {"\x44", 0, 0x4E47}, /* East Asian ideograph */
  {"\x47", 0, 0x5904}, /* East Asian ideograph */
  {"\x48", 0, 0x864F}, /* East Asian ideograph */
  {"\x4A", 0, 0x53F7}, /* East Asian ideograph */
  {"\x4C", 0, 0x4E8F}, /* East Asian ideograph */
  {"\x5A", 0, 0x65E6}, /* East Asian ideograph */
  {"\x76", 0, 0x8680}, /* East Asian ideograph */
  {"\x79", 0, 0x80E1}, /* East Asian ideograph (duplicate simplified) */
  {"\x7A", 0, 0x867E}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page279 = {
  marc8_31page279_flat, 0
};
/* PAGE 278 */
struct yaz_iconv_trie_flat marc8_31page278_flat[] = {
  {"\x28", 0, 0x835A}, /* East Asian ideograph */
  {"\x29", 0, 0x830E}, /* East Asian ideograph */
  {"\x2A", 0, 0x82CB}, /* East Asian ideograph */
  {"\x2D", 0, 0x5E84}, /* East Asian ideograph */
  {"\x3C", 0, 0x534E}, /* East Asian ideograph */
  {"\x41", 0, 0x83B1}, /* East Asian ideograph */
  {"\x4D", 0, 0x82C7}, /* East Asian ideograph */
  {"\x4F", 0, 0x53F6}, /* East Asian ideograph */
  {"\x51", 0, 0x80E1}, /* East Asian ideograph (duplicate simplified) */
  {"\x53", 0, 0x8364}, /* East Asian ideograph */
  {"\x55", 0, 0x83B4}, /* East Asian ideograph */
  {"\x5D", 0, 0x5E2D}, /* East Asian ideograph */
  {"\x63", 0, 0x836A}, /* East Asian ideograph */
  {"\x64", 0, 0x82CE}, /* East Asian ideograph */
  {"\x67", 0, 0x82CD}, /* East Asian ideograph */
  {"\x68", 0, 0x8298}, /* East Asian ideograph */
  {"\x6C", 0, 0x83B2}, /* East Asian ideograph */
  {"\x6E", 0, 0x836B}, /* East Asian ideograph */
  {"\x71", 0, 0x848B}, /* East Asian ideograph */
  {"\x73", 0, 0x535C}, /* East Asian ideograph */
  {"\x76", 0, 0x8361}, /* East Asian ideograph */
  {"\x7C", 0, 0x829C}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page278 = {
  marc8_31page278_flat, 0
};
/* PAGE 277 */
struct yaz_iconv_trie_flat marc8_31page277_flat[] = {
  {"\x21", 0, 0x80EA}, /* East Asian ideograph */
  {"\x22", 0, 0x810F}, /* East Asian ideograph (duplicate simplified) */
  {"\x25", 0, 0x4E34}, /* East Asian ideograph */
  {"\x2B", 0, 0x53F0}, /* East Asian ideograph */
  {"\x32", 0, 0x4E0E}, /* East Asian ideograph */
  {"\x33", 0, 0x5174}, /* East Asian ideograph */
  {"\x34", 0, 0x4E3E}, /* East Asian ideograph */
  {"\x35", 0, 0x65E7}, /* East Asian ideograph */
  {"\x4A", 0, 0x8231}, /* East Asian ideograph */
  {"\x4B", 0, 0x8230}, /* East Asian ideograph */
  {"\x4E", 0, 0x8270}, /* East Asian ideograph */
  {"\x58", 0, 0x5DF4}, /* East Asian ideograph (duplicate simplified) */
  {"\x5C", 0, 0x520D}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page277 = {
  marc8_31page277_flat, 0
};
/* PAGE 276 */
struct yaz_iconv_trie_flat marc8_31page276_flat[] = {
  {"\x21", 0, 0x8083}, /* East Asian ideograph */
  {"\x44", 0, 0x80C1}, /* East Asian ideograph */
  {"\x4A", 0, 0x8090}, /* East Asian ideograph */
  {"\x4D", 0, 0x8109}, /* East Asian ideograph */
  {"\x58", 0, 0x80BE}, /* East Asian ideograph */
  {"\x59", 0, 0x80C0}, /* East Asian ideograph */
  {"\x5E", 0, 0x80A0}, /* East Asian ideograph */
  {"\x62", 0, 0x80BF}, /* East Asian ideograph */
  {"\x65", 0, 0x8111}, /* East Asian ideograph */
  {"\x6C", 0, 0x80F6}, /* East Asian ideograph */
  {"\x6E", 0, 0x80A4}, /* East Asian ideograph */
  {"\x71", 0, 0x817B}, /* East Asian ideograph */
  {"\x78", 0, 0x8113}, /* East Asian ideograph */
  {"\x79", 0, 0x80C6}, /* East Asian ideograph */
  {"\x7A", 0, 0x8138}, /* East Asian ideograph */
  {"\x7B", 0, 0x810D}, /* East Asian ideograph */
  {"\x7C", 0, 0x8110}, /* East Asian ideograph */
  {"\x7D", 0, 0x8191}, /* East Asian ideograph */
  {"\x7E", 0, 0x814A}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page276 = {
  marc8_31page276_flat, 0
};
/* PAGE 275 */
struct yaz_iconv_trie_flat marc8_31page275_flat[] = {
  {"\x21", 0, 0x7EED}, /* East Asian ideograph */
  {"\x22", 0, 0x7F28}, /* East Asian ideograph */
  {"\x23", 0, 0x7EA4}, /* East Asian ideograph */
  {"\x24", 0, 0x7F06}, /* East Asian ideograph */
  {"\x33", 0, 0x7F5A}, /* East Asian ideograph */
  {"\x34", 0, 0x9A82}, /* East Asian ideograph */
  {"\x35", 0, 0x7F62}, /* East Asian ideograph */
  {"\x37", 0, 0x7F57}, /* East Asian ideograph */
  {"\x38", 0, 0x7F81}, /* East Asian ideograph */
  {"\x42", 0, 0x4E49}, /* East Asian ideograph */
  {"\x4D", 0, 0x4E60}, /* East Asian ideograph */
  {"\x51", 0, 0x7FC6}, /* East Asian ideograph */
  {"\x58", 0, 0x7FD8}, /* East Asian ideograph */
  {"\x6F", 0, 0x5723}, /* East Asian ideograph */
  {"\x71", 0, 0x95FB}, /* East Asian ideograph */
  {"\x74", 0, 0x58F0}, /* East Asian ideograph */
  {"\x75", 0, 0x8038}, /* East Asian ideograph */
  {"\x76", 0, 0x806A}, /* East Asian ideograph */
  {"\x77", 0, 0x8054}, /* East Asian ideograph */
  {"\x78", 0, 0x804C}, /* East Asian ideograph */
  {"\x79", 0, 0x8042}, /* East Asian ideograph */
  {"\x7A", 0, 0x804B}, /* East Asian ideograph */
  {"\x7B", 0, 0x542C}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page275 = {
  marc8_31page275_flat, 0
};
/* PAGE 274 */
struct yaz_iconv_trie_dir marc8_31page274_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x7EB1} /* East Asian ideograph */,
  {0, 0, 0x7EB3} /* East Asian ideograph */,
  {0, 0, 0x7EA7} /* East Asian ideograph */,
  {0, 0, 0x7EB8} /* East Asian ideograph */,
  {0, 0, 0x7EB7} /* East Asian ideograph */,
  {0, 0, 0x7ECA} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x7ECB} /* East Asian ideograph */,
  {0, 0, 0x624E} /* East Asian ideograph */,
  {0, 0, 0x7ECD} /* East Asian ideograph */,
  {0, 0, 0x7EC4} /* East Asian ideograph */,
  {0, 0, 0x7EC6} /* East Asian ideograph */,
  {0, 0, 0x7EC5} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x7ECC} /* East Asian ideograph */,
  {0, 0, 0x7EC8} /* East Asian ideograph */,
  {0, 0, 0x7EDF} /* East Asian ideograph */,
  {0, 0, 0x7EDE} /* East Asian ideograph */,
  {0, 0, 0x7ED2} /* East Asian ideograph */,
  {0, 0, 0x7ED3} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x7EDA} /* East Asian ideograph */,
  {0, 0, 0x7EDD} /* East Asian ideograph */,
  {0, 0, 0x7EDC} /* East Asian ideograph */,
  {0, 0, 0x7ED9} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x4E1D} /* East Asian ideograph */,
  {0, 0, 0x7ECF} /* East Asian ideograph */,
  {0, 0, 0x6346} /* East Asian ideograph */,
  {0, 0, 0x7EE2} /* East Asian ideograph */,
  {0, 0, 0x7EE5} /* East Asian ideograph */,
  {0, 0, 0x7ED1} /* East Asian ideograph */,
  {0, 0, 0x7EFC} /* East Asian ideograph */,
  {0, 0, 0x7EFD} /* East Asian ideograph */,
  {0, 0, 0x7EFE} /* East Asian ideograph */,
  {0, 0, 0x7D27} /* East Asian ideograph */,
  {0, 0, 0x7EEB} /* East Asian ideograph */,
  {0, 0, 0x7F00} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x7F51} /* East Asian ideograph */,
  {0, 0, 0x7EB2} /* East Asian ideograph */,
  {0, 0, 0x7EF0} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x7EFF} /* East Asian ideograph */,
  {0, 0, 0x7EF8} /* East Asian ideograph */,
  {0, 0, 0x7EF4} /* East Asian ideograph */,
  {0, 0, 0x7EF5} /* East Asian ideograph */,
  {0, 0, 0x7EB6} /* East Asian ideograph */,
  {0, 0, 0x7F01} /* East Asian ideograph */,
  {0, 0, 0x7F14} /* East Asian ideograph */,
  {0, 0, 0x7EAC} /* East Asian ideograph */,
  {0, 0, 0x7EC3} /* East Asian ideograph */,
  {0, 0, 0x7EEA} /* East Asian ideograph */,
  {0, 0, 0x7F04} /* East Asian ideograph */,
  {0, 0, 0x7F05} /* East Asian ideograph */,
  {0, 0, 0x7F09} /* East Asian ideograph */,
  {0, 0, 0x7F13} /* East Asian ideograph */,
  {0, 0, 0x7F18} /* East Asian ideograph */,
  {0, 0, 0x7F16} /* East Asian ideograph */,
  {0, 0, 0x7EBF} /* East Asian ideograph */,
  {0, 0, 0x7F0D} /* East Asian ideograph */,
  {0, 0, 0x7F0E} /* East Asian ideograph */,
  {0, 0, 0x7F23} /* East Asian ideograph */,
  {0, 0, 0x7F22} /* East Asian ideograph */,
  {0, 0, 0x8426} /* East Asian ideograph */,
  {0, 0, 0x7F1A} /* East Asian ideograph */,
  {0, 0, 0x81F4} /* East Asian ideograph */,
  {0, 0, 0x53BF} /* East Asian ideograph (variant of EACC 455164) */,
  {0, 0, 0x7F29} /* East Asian ideograph */,
  {0, 0, 0x7EE9} /* East Asian ideograph */,
  {0, 0, 0x7F2A} /* East Asian ideograph */,
  {0, 0, 0x7F15} /* East Asian ideograph */,
  {0, 0, 0x7F27} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x7F1D} /* East Asian ideograph */,
  {0, 0, 0x603B} /* East Asian ideograph */,
  {0, 0, 0x7EB5} /* East Asian ideograph */,
  {0, 0, 0x7F2B} /* East Asian ideograph */,
  {0, 0, 0x7F2E} /* East Asian ideograph */,
  {0, 0, 0x7EC7} /* East Asian ideograph */,
  {0, 0, 0x7EE3} /* East Asian ideograph */,
  {0, 0, 0x7ED5} /* East Asian ideograph */,
  {0, 0, 0x7F2D} /* East Asian ideograph */,
  {0, 0, 0x7CFB} /* East Asian ideograph (duplicate simplified) */,
  {0, 0, 0x7EF3} /* East Asian ideograph */,
  {0, 0, 0x8327} /* East Asian ideograph */,
  {0, 0, 0x7ECE} /* East Asian ideograph */,
  {0, 0, 0x7ED8} /* East Asian ideograph */,
  {0, 0, 0x8FAB} /* East Asian ideograph */,
  {0, 0, 0x7F24} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x7EE7} /* East Asian ideograph */,
  {0, 0, 0x7F20} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8_31page274 = {
  0, marc8_31page274_dir
};
/* PAGE 273 */
struct yaz_iconv_trie_flat marc8_31page273_flat[] = {
  {"\x21", 0, 0x7B0B}, /* East Asian ideograph */
  {"\x23", 0, 0x8345}, /* East Asian ideograph */
  {"\x2A", 0, 0x94B3}, /* East Asian ideograph */
  {"\x2B", 0, 0x7B3A}, /* East Asian ideograph */
  {"\x30", 0, 0x8303}, /* East Asian ideograph */
  {"\x33", 0, 0x8282}, /* East Asian ideograph */
  {"\x38", 0, 0x7BAC}, /* East Asian ideograph */
  {"\x39", 0, 0x7B03}, /* East Asian ideograph */
  {"\x3A", 0, 0x7B51}, /* East Asian ideograph */
  {"\x3C", 0, 0x7B5B}, /* East Asian ideograph */
  {"\x3E", 0, 0x7BD3}, /* East Asian ideograph */
  {"\x41", 0, 0x7B80}, /* East Asian ideograph */
  {"\x42", 0, 0x7BAB}, /* East Asian ideograph */
  {"\x45", 0, 0x7BAA}, /* East Asian ideograph */
  {"\x46", 0, 0x7BD1}, /* East Asian ideograph */
  {"\x48", 0, 0x5E18}, /* East Asian ideograph */
  {"\x4B", 0, 0x7B7E}, /* East Asian ideograph */
  {"\x4C", 0, 0x7BEE}, /* East Asian ideograph */
  {"\x4D", 0, 0x7B79}, /* East Asian ideograph */
  {"\x50", 0, 0x7B3C}, /* East Asian ideograph */
  {"\x51", 0, 0x7C41}, /* East Asian ideograph */
  {"\x52", 0, 0x7B7E}, /* East Asian ideograph (duplicate simplified) */
  {"\x53", 0, 0x7BF1}, /* East Asian ideograph */
  {"\x54", 0, 0x7BA9}, /* East Asian ideograph */
  {"\x55", 0, 0x5401}, /* East Asian ideograph */
  {"\x60", 0, 0x7C8B}, /* East Asian ideograph */
  {"\x62", 0, 0x80E1}, /* East Asian ideograph (duplicate simplified) */
  {"\x68", 0, 0x7CAA}, /* East Asian ideograph */
  {"\x6B", 0, 0x7CAE}, /* East Asian ideograph */
  {"\x6F", 0, 0x7EA0}, /* East Asian ideograph */
  {"\x70", 0, 0x7EAA}, /* East Asian ideograph */
  {"\x71", 0, 0x7EA3}, /* East Asian ideograph */
  {"\x72", 0, 0x7EA2}, /* East Asian ideograph */
  {"\x73", 0, 0x7EAB}, /* East Asian ideograph */
  {"\x74", 0, 0x7EA6}, /* East Asian ideograph */
  {"\x75", 0, 0x7EA5}, /* East Asian ideograph */
  {"\x76", 0, 0x7EBA}, /* East Asian ideograph */
  {"\x77", 0, 0x7EB9}, /* East Asian ideograph */
  {"\x7A", 0, 0x7EAD}, /* East Asian ideograph */
  {"\x7C", 0, 0x7EB0}, /* East Asian ideograph */
  {"\x7D", 0, 0x7EAF}, /* East Asian ideograph */
  {"\x7E", 0, 0x7EBD}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page273 = {
  marc8_31page273_flat, 0
};
/* PAGE 272 */
struct yaz_iconv_trie_flat marc8_31page272_flat[] = {
  {"\x22", 0, 0x4E07}, /* East Asian ideograph */
  {"\x25", 0, 0x53B6}, /* East Asian ideograph */
  {"\x36", 0, 0x5E0C}, /* East Asian ideograph */
  {"\x3C", 0, 0x79F0}, /* East Asian ideograph */
  {"\x3D", 0, 0x79CD}, /* East Asian ideograph */
  {"\x40", 0, 0x8C37}, /* East Asian ideograph */
  {"\x44", 0, 0x79EF}, /* East Asian ideograph */
  {"\x46", 0, 0x7A23}, /* East Asian ideograph */
  {"\x49", 0, 0x7A51}, /* East Asian ideograph */
  {"\x4A", 0, 0x79FD}, /* East Asian ideograph */
  {"\x4B", 0, 0x83B7}, /* East Asian ideograph (duplicate simplified) */
  {"\x4C", 0, 0x7A33}, /* East Asian ideograph */
  {"\x5C", 0, 0x6D3C}, /* East Asian ideograph */
  {"\x5D", 0, 0x7A9D}, /* East Asian ideograph */
  {"\x5F", 0, 0x7A77}, /* East Asian ideograph */
  {"\x60", 0, 0x7AA5}, /* East Asian ideograph */
  {"\x61", 0, 0x7A8D}, /* East Asian ideograph */
  {"\x62", 0, 0x7A9C}, /* East Asian ideograph */
  {"\x63", 0, 0x7AA6}, /* East Asian ideograph */
  {"\x64", 0, 0x7A83}, /* East Asian ideograph */
  {"\x6B", 0, 0x7ADE}, /* East Asian ideograph */
  {"\x70", 0, 0x5DF4}, /* East Asian ideograph (duplicate simplified) */
  {"\x79", 0, 0x7B14}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page272 = {
  marc8_31page272_flat, 0
};
/* PAGE 271 */
struct yaz_iconv_trie_flat marc8_31page271_flat[] = {
  {"\x27", 0, 0x77EB}, /* East Asian ideograph */
  {"\x3B", 0, 0x781A}, /* East Asian ideograph */
  {"\x3E", 0, 0x7815}, /* East Asian ideograph */
  {"\x45", 0, 0x7855}, /* East Asian ideograph */
  {"\x49", 0, 0x786E}, /* East Asian ideograph */
  {"\x4C", 0, 0x7801}, /* East Asian ideograph */
  {"\x53", 0, 0x7816}, /* East Asian ideograph */
  {"\x58", 0, 0x77F6}, /* East Asian ideograph */
  {"\x59", 0, 0x7840}, /* East Asian ideograph */
  {"\x5A", 0, 0x788D}, /* East Asian ideograph */
  {"\x5B", 0, 0x77FF}, /* East Asian ideograph */
  {"\x5C", 0, 0x77FE}, /* East Asian ideograph */
  {"\x5D", 0, 0x783A}, /* East Asian ideograph */
  {"\x5E", 0, 0x783E}, /* East Asian ideograph */
  {"\x6F", 0, 0x53EA}, /* East Asian ideograph (duplicate simplified) */
  {"\x77", 0, 0x7978}, /* East Asian ideograph */
  {"\x78", 0, 0x796F}, /* East Asian ideograph */
  {"\x7B", 0, 0x7985}, /* East Asian ideograph */
  {"\x7C", 0, 0x793C}, /* East Asian ideograph */
  {"\x7D", 0, 0x7977}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page271 = {
  marc8_31page271_flat, 0
};
/* PAGE 270 */
struct yaz_iconv_trie_flat marc8_31page270_flat[] = {
  {"\x29", 0, 0x7691}, /* East Asian ideograph */
  {"\x2D", 0, 0x76B1}, /* East Asian ideograph */
  {"\x3A", 0, 0x76CF}, /* East Asian ideograph */
  {"\x3C", 0, 0x5C3D}, /* East Asian ideograph */
  {"\x3D", 0, 0x76D1}, /* East Asian ideograph */
  {"\x3E", 0, 0x76D8}, /* East Asian ideograph */
  {"\x3F", 0, 0x5362}, /* East Asian ideograph */
  {"\x56", 0, 0x4F17}, /* East Asian ideograph */
  {"\x57", 0, 0x56F0}, /* East Asian ideograph */
  {"\x5D", 0, 0x7750}, /* East Asian ideograph */
  {"\x73", 0, 0x4E86}, /* East Asian ideograph */
  {"\x7C", 0, 0x77A9}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page270 = {
  marc8_31page270_flat, 0
};
/* PAGE 269 */
struct yaz_iconv_trie_flat marc8_31page269_flat[] = {
  {"\x2D", 0, 0x4EA9}, /* East Asian ideograph */
  {"\x31", 0, 0x7544}, /* East Asian ideograph */
  {"\x33", 0, 0x6BD5}, /* East Asian ideograph */
  {"\x34", 0, 0x5F02}, /* East Asian ideograph */
  {"\x36", 0, 0x753B}, /* East Asian ideograph */
  {"\x39", 0, 0x5F53}, /* East Asian ideograph */
  {"\x3B", 0, 0x7574}, /* East Asian ideograph */
  {"\x3C", 0, 0x8FED}, /* East Asian ideograph */
  {"\x56", 0, 0x75C9}, /* East Asian ideograph */
  {"\x60", 0, 0x75A1}, /* East Asian ideograph */
  {"\x61", 0, 0x759F}, /* East Asian ideograph */
  {"\x62", 0, 0x75EA}, /* East Asian ideograph */
  {"\x63", 0, 0x75AF}, /* East Asian ideograph */
  {"\x6A", 0, 0x75AE}, /* East Asian ideograph */
  {"\x6D", 0, 0x75E8}, /* East Asian ideograph */
  {"\x6E", 0, 0x7597}, /* East Asian ideograph */
  {"\x71", 0, 0x75A0}, /* East Asian ideograph */
  {"\x73", 0, 0x75D2}, /* East Asian ideograph */
  {"\x75", 0, 0x765E}, /* East Asian ideograph */
  {"\x76", 0, 0x763E}, /* East Asian ideograph */
  {"\x77", 0, 0x7663}, /* East Asian ideograph */
  {"\x78", 0, 0x762B}, /* East Asian ideograph */
  {"\x79", 0, 0x766B}, /* East Asian ideograph */
  {"\x7B", 0, 0x53D1}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page269 = {
  marc8_31page269_flat, 0
};
/* PAGE 268 */
struct yaz_iconv_trie_flat marc8_31page268_flat[] = {
  {"\x22", 0, 0x72EF}, /* East Asian ideograph */
  {"\x23", 0, 0x72EE}, /* East Asian ideograph */
  {"\x27", 0, 0x72EC}, /* East Asian ideograph */
  {"\x28", 0, 0x72DE}, /* East Asian ideograph */
  {"\x29", 0, 0x83B7}, /* East Asian ideograph */
  {"\x2A", 0, 0x72B7}, /* East Asian ideograph */
  {"\x2B", 0, 0x517D}, /* East Asian ideograph */
  {"\x2C", 0, 0x730E}, /* East Asian ideograph */
  {"\x2D", 0, 0x736D}, /* East Asian ideograph */
  {"\x2E", 0, 0x732E}, /* East Asian ideograph */
  {"\x2F", 0, 0x7321}, /* East Asian ideograph */
  {"\x47", 0, 0x73B0}, /* East Asian ideograph */
  {"\x57", 0, 0x73F2}, /* East Asian ideograph */
  {"\x5E", 0, 0x739B}, /* East Asian ideograph */
  {"\x5F", 0, 0x7410}, /* East Asian ideograph */
  {"\x64", 0, 0x7391}, /* East Asian ideograph */
  {"\x67", 0, 0x73AF}, /* East Asian ideograph */
  {"\x68", 0, 0x7477}, /* East Asian ideograph */
  {"\x69", 0, 0x73BA}, /* East Asian ideograph */
  {"\x6B", 0, 0x73D1}, /* East Asian ideograph */
  {"\x74", 0, 0x74EF}, /* East Asian ideograph */
  {"\x7A", 0, 0x4EA7}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page268 = {
  marc8_31page268_flat, 0
};
/* PAGE 267 */
struct yaz_iconv_trie_flat marc8_31page267_flat[] = {
  {"\x21", 0, 0x70BD}, /* East Asian ideograph */
  {"\x22", 0, 0x7096}, /* East Asian ideograph */
  {"\x24", 0, 0x706F}, /* East Asian ideograph */
  {"\x25", 0, 0x7116}, /* East Asian ideograph */
  {"\x26", 0, 0x70E7}, /* East Asian ideograph */
  {"\x2E", 0, 0x8425}, /* East Asian ideograph */
  {"\x30", 0, 0x70DB}, /* East Asian ideograph */
  {"\x31", 0, 0x707F}, /* East Asian ideograph */
  {"\x33", 0, 0x70E9}, /* East Asian ideograph */
  {"\x36", 0, 0x70C1}, /* East Asian ideograph */
  {"\x37", 0, 0x7089}, /* East Asian ideograph */
  {"\x38", 0, 0x70C2}, /* East Asian ideograph */
  {"\x42", 0, 0x7237}, /* East Asian ideograph */
  {"\x45", 0, 0x5C14}, /* East Asian ideograph */
  {"\x46", 0, 0x5899}, /* East Asian ideograph */
  {"\x4C", 0, 0x724D}, /* East Asian ideograph */
  {"\x53", 0, 0x5B83}, /* East Asian ideograph */
  {"\x5A", 0, 0x7275}, /* East Asian ideograph */
  {"\x5E", 0, 0x8366}, /* East Asian ideograph */
  {"\x61", 0, 0x728A}, /* East Asian ideograph */
  {"\x62", 0, 0x727A}, /* East Asian ideograph */
  {"\x68", 0, 0x72B6}, /* East Asian ideograph */
  {"\x70", 0, 0x72ED}, /* East Asian ideograph */
  {"\x72", 0, 0x72C8}, /* East Asian ideograph */
  {"\x79", 0, 0x72B9}, /* East Asian ideograph */
  {"\x7E", 0, 0x72F1}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page267 = {
  marc8_31page267_flat, 0
};
/* PAGE 266 */
struct yaz_iconv_trie_flat marc8_31page266_flat[] = {
  {"\x21", 0, 0x6CFD}, /* East Asian ideograph */
  {"\x22", 0, 0x6D4A}, /* East Asian ideograph */
  {"\x26", 0, 0x6D4E}, /* East Asian ideograph */
  {"\x27", 0, 0x6CDE}, /* East Asian ideograph */
  {"\x28", 0, 0x6EE8}, /* East Asian ideograph */
  {"\x2B", 0, 0x6EE5}, /* East Asian ideograph */
  {"\x2D", 0, 0x6D9B}, /* East Asian ideograph */
  {"\x2E", 0, 0x6DA9}, /* East Asian ideograph */
  {"\x31", 0, 0x6C88}, /* East Asian ideograph */
  {"\x32", 0, 0x6CFB}, /* East Asian ideograph */
  {"\x33", 0, 0x6E0E}, /* East Asian ideograph */
  {"\x34", 0, 0x6E85}, /* East Asian ideograph */
  {"\x36", 0, 0x6EE4}, /* East Asian ideograph */
  {"\x37", 0, 0x6D4F}, /* East Asian ideograph */
  {"\x3A", 0, 0x6FD1}, /* East Asian ideograph */
  {"\x3B", 0, 0x6CA5}, /* East Asian ideograph */
  {"\x3C", 0, 0x6FD2}, /* East Asian ideograph */
  {"\x3D", 0, 0x6F47}, /* East Asian ideograph */
  {"\x3F", 0, 0x6F9C}, /* East Asian ideograph */
  {"\x41", 0, 0x6D12}, /* East Asian ideograph */
  {"\x42", 0, 0x6EE9}, /* East Asian ideograph */
  {"\x43", 0, 0x6E7E}, /* East Asian ideograph */
  {"\x44", 0, 0x6EE6}, /* East Asian ideograph */
  {"\x4A", 0, 0x707E}, /* East Asian ideograph */
  {"\x51", 0, 0x4E3A}, /* East Asian ideograph */
  {"\x5D", 0, 0x4E4C}, /* East Asian ideograph */
  {"\x66", 0, 0x65E0}, /* East Asian ideograph */
  {"\x6A", 0, 0x70BC}, /* East Asian ideograph */
  {"\x6D", 0, 0x70E6}, /* East Asian ideograph */
  {"\x6F", 0, 0x7080}, /* East Asian ideograph */
  {"\x75", 0, 0x6247}, /* East Asian ideograph */
  {"\x7D", 0, 0x70ED}, /* East Asian ideograph */
  {"\x7E", 0, 0x70EB}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page266 = {
  marc8_31page266_flat, 0
};
/* PAGE 265 */
struct yaz_iconv_trie_flat marc8_31page265_flat[] = {
  {"\x2D", 0, 0x6C64}, /* East Asian ideograph */
  {"\x30", 0, 0x6D4B}, /* East Asian ideograph */
  {"\x31", 0, 0x6DA1}, /* East Asian ideograph */
  {"\x33", 0, 0x6D51}, /* East Asian ideograph */
  {"\x3D", 0, 0x6C9F}, /* East Asian ideograph */
  {"\x41", 0, 0x6C85}, /* East Asian ideograph */
  {"\x42", 0, 0x706D}, /* East Asian ideograph */
  {"\x44", 0, 0x6E7F}, /* East Asian ideograph */
  {"\x48", 0, 0x6CA7}, /* East Asian ideograph */
  {"\x4B", 0, 0x51C6}, /* East Asian ideograph */
  {"\x4F", 0, 0x6CAA}, /* East Asian ideograph */
  {"\x54", 0, 0x6E0D}, /* East Asian ideograph */
  {"\x55", 0, 0x6DA8}, /* East Asian ideograph */
  {"\x57", 0, 0x6C49}, /* East Asian ideograph */
  {"\x58", 0, 0x6EE1}, /* East Asian ideograph */
  {"\x59", 0, 0x6D9F}, /* East Asian ideograph */
  {"\x5A", 0, 0x6E10}, /* East Asian ideograph */
  {"\x5F", 0, 0x6EDE}, /* East Asian ideograph */
  {"\x63", 0, 0x6D46}, /* East Asian ideograph */
  {"\x64", 0, 0x6E17}, /* East Asian ideograph */
  {"\x65", 0, 0x6E14}, /* East Asian ideograph */
  {"\x6C", 0, 0x6CFC}, /* East Asian ideograph */
  {"\x6D", 0, 0x6DA6}, /* East Asian ideograph */
  {"\x6E", 0, 0x6DA7}, /* East Asian ideograph */
  {"\x6F", 0, 0x6D01}, /* East Asian ideograph */
  {"\x71", 0, 0x6D47}, /* East Asian ideograph */
  {"\x78", 0, 0x6E83}, /* East Asian ideograph */
  {"\x7B", 0, 0x6DC0}, /* East Asian ideograph */
  {"\x7C", 0, 0x6D53}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page265 = {
  marc8_31page265_flat, 0
};
/* PAGE 264 */
struct yaz_iconv_trie_flat marc8_31page264_flat[] = {
  {"\x4E", 0, 0x6CFE}, /* East Asian ideograph */
  {"\x59", 0, 0x6CEA}, /* East Asian ideograph */
  {"\x68", 0, 0x6D45}, /* East Asian ideograph */
  {"\x74", 0, 0x6E0A}, /* East Asian ideograph */
  {"\x77", 0, 0x6CA6}, /* East Asian ideograph */
  {"\x7D", 0, 0x6D8C}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page264 = {
  marc8_31page264_flat, 0
};
/* PAGE 263 */
struct yaz_iconv_trie_flat marc8_31page263_flat[] = {
  {"\x21", 0, 0x6B22}, /* East Asian ideograph */
  {"\x29", 0, 0x5C81}, /* East Asian ideograph */
  {"\x2A", 0, 0x5386}, /* East Asian ideograph */
  {"\x2B", 0, 0x5F52}, /* East Asian ideograph */
  {"\x33", 0, 0x6B8B}, /* East Asian ideograph */
  {"\x35", 0, 0x6B87}, /* East Asian ideograph */
  {"\x36", 0, 0x6B93}, /* East Asian ideograph */
  {"\x37", 0, 0x6BA1}, /* East Asian ideograph */
  {"\x38", 0, 0x6B7C}, /* East Asian ideograph */
  {"\x3B", 0, 0x6740}, /* East Asian ideograph */
  {"\x3C", 0, 0x58F3}, /* East Asian ideograph */
  {"\x40", 0, 0x6BB4}, /* East Asian ideograph */
  {"\x55", 0, 0x6C14}, /* East Asian ideograph */
  {"\x58", 0, 0x6C22}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page263 = {
  marc8_31page263_flat, 0
};
/* PAGE 262 */
struct yaz_iconv_trie_flat marc8_31page262_flat[] = {
  {"\x26", 0, 0x6781}, /* East Asian ideograph */
  {"\x2A", 0, 0x6768}, /* East Asian ideograph */
  {"\x2B", 0, 0x6862}, /* East Asian ideograph */
  {"\x2D", 0, 0x4E1A}, /* East Asian ideograph */
  {"\x2F", 0, 0x67AB}, /* East Asian ideograph */
  {"\x37", 0, 0x8363}, /* East Asian ideograph */
  {"\x39", 0, 0x6784}, /* East Asian ideograph */
  {"\x40", 0, 0x67AA}, /* East Asian ideograph */
  {"\x44", 0, 0x6837}, /* East Asian ideograph */
  {"\x46", 0, 0x6869}, /* East Asian ideograph */
  {"\x47", 0, 0x6807}, /* East Asian ideograph */
  {"\x49", 0, 0x67A2}, /* East Asian ideograph */
  {"\x4A", 0, 0x697C}, /* East Asian ideograph */
  {"\x4C", 0, 0x6868}, /* East Asian ideograph */
  {"\x4E", 0, 0x4E50}, /* East Asian ideograph */
  {"\x4F", 0, 0x679E}, /* East Asian ideograph */
  {"\x53", 0, 0x692D}, /* East Asian ideograph */
  {"\x55", 0, 0x6811}, /* East Asian ideograph */
  {"\x57", 0, 0x6866}, /* East Asian ideograph */
  {"\x58", 0, 0x6734}, /* East Asian ideograph */
  {"\x5B", 0, 0x6865}, /* East Asian ideograph */
  {"\x5D", 0, 0x673A}, /* East Asian ideograph */
  {"\x5F", 0, 0x6863}, /* East Asian ideograph */
  {"\x61", 0, 0x68C0}, /* East Asian ideograph */
  {"\x62", 0, 0x6867}, /* East Asian ideograph */
  {"\x63", 0, 0x67E0}, /* East Asian ideograph */
  {"\x64", 0, 0x69DF}, /* East Asian ideograph */
  {"\x65", 0, 0x67DC}, /* East Asian ideograph */
  {"\x66", 0, 0x69DB}, /* East Asian ideograph */
  {"\x6A", 0, 0x6988}, /* East Asian ideograph */
  {"\x6B", 0, 0x691F}, /* East Asian ideograph */
  {"\x6C", 0, 0x6809}, /* East Asian ideograph */
  {"\x6D", 0, 0x6A79}, /* East Asian ideograph */
  {"\x6E", 0, 0x680F}, /* East Asian ideograph */
  {"\x6F", 0, 0x6A31}, /* East Asian ideograph */
  {"\x70", 0, 0x6743}, /* East Asian ideograph */
  {"\x71", 0, 0x6984}, /* East Asian ideograph */
  {"\x78", 0, 0x94A6}, /* East Asian ideograph */
  {"\x7A", 0, 0x6B20}, /* East Asian ideograph (duplicate simplified) */
  {"\x7C", 0, 0x6B27}, /* East Asian ideograph */
  {"\x7E", 0, 0x6B24}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page262 = {
  marc8_31page262_flat, 0
};
/* PAGE 261 */
struct yaz_iconv_trie_flat marc8_31page261_flat[] = {
  {"\x26", 0, 0x4E1C}, /* East Asian ideograph */
  {"\x63", 0, 0x6761}, /* East Asian ideograph */
  {"\x68", 0, 0x67AD}, /* East Asian ideograph */
  {"\x69", 0, 0x6800}, /* East Asian ideograph */
  {"\x6D", 0, 0x5F03}, /* East Asian ideograph */
  {"\x6E", 0, 0x6816}, /* East Asian ideograph */
  {"\x71", 0, 0x680B}, /* East Asian ideograph */
  {"\x76", 0, 0x6808}, /* East Asian ideograph */
  {"\x7A", 0, 0x67A3}, /* East Asian ideograph */
  {"\x7C", 0, 0x832D}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page261 = {
  marc8_31page261_flat, 0
};
/* PAGE 260 */
struct yaz_iconv_trie_flat marc8_31page260_flat[] = {
  {"\x2D", 0, 0x65F6}, /* East Asian ideograph */
  {"\x32", 0, 0x663C}, /* East Asian ideograph */
  {"\x40", 0, 0x6656}, /* East Asian ideograph */
  {"\x41", 0, 0x6655}, /* East Asian ideograph */
  {"\x43", 0, 0x7545}, /* East Asian ideograph */
  {"\x44", 0, 0x6682}, /* East Asian ideograph */
  {"\x48", 0, 0x6653}, /* East Asian ideograph */
  {"\x49", 0, 0x5386}, /* East Asian ideograph (duplicate simplified) */
  {"\x4B", 0, 0x66A7}, /* East Asian ideograph */
  {"\x4D", 0, 0x65F7}, /* East Asian ideograph */
  {"\x55", 0, 0x4E66}, /* East Asian ideograph */
  {"\x5A", 0, 0x4F1A}, /* East Asian ideograph */
  {"\x66", 0, 0x80E7}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page260 = {
  marc8_31page260_flat, 0
};
/* PAGE 259 */
struct yaz_iconv_trie_flat marc8_31page259_flat[] = {
  {"\x22", 0, 0x62C5}, /* East Asian ideograph */
  {"\x24", 0, 0x6361}, /* East Asian ideograph */
  {"\x25", 0, 0x6324}, /* East Asian ideograph */
  {"\x26", 0, 0x62E7}, /* East Asian ideograph */
  {"\x28", 0, 0x62DF}, /* East Asian ideograph */
  {"\x29", 0, 0x6401}, /* East Asian ideograph */
  {"\x2A", 0, 0x6269}, /* East Asian ideograph */
  {"\x2B", 0, 0x63B7}, /* East Asian ideograph */
  {"\x2C", 0, 0x64B5}, /* East Asian ideograph */
  {"\x2E", 0, 0x6270}, /* East Asian ideograph */
  {"\x2F", 0, 0x64DE}, /* East Asian ideograph */
  {"\x30", 0, 0x6446}, /* East Asian ideograph */
  {"\x31", 0, 0x62E2}, /* East Asian ideograph */
  {"\x33", 0, 0x62E6}, /* East Asian ideograph */
  {"\x34", 0, 0x6400}, /* East Asian ideograph */
  {"\x35", 0, 0x6444}, /* East Asian ideograph */
  {"\x37", 0, 0x631B}, /* East Asian ideograph */
  {"\x38", 0, 0x644A}, /* East Asian ideograph */
  {"\x3A", 0, 0x6405}, /* East Asian ideograph */
  {"\x3B", 0, 0x63FD}, /* East Asian ideograph */
  {"\x47", 0, 0x8D25}, /* East Asian ideograph */
  {"\x4F", 0, 0x542F}, /* East Asian ideograph */
  {"\x52", 0, 0x654C}, /* East Asian ideograph */
  {"\x54", 0, 0x6570}, /* East Asian ideograph */
  {"\x56", 0, 0x655B}, /* East Asian ideograph */
  {"\x57", 0, 0x6BD9}, /* East Asian ideograph */
  {"\x63", 0, 0x65A9}, /* East Asian ideograph */
  {"\x66", 0, 0x65AD}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page259 = {
  marc8_31page259_flat, 0
};
/* PAGE 258 */
struct yaz_iconv_trie_flat marc8_31page258_flat[] = {
  {"\x23", 0, 0x6302}, /* East Asian ideograph */
  {"\x36", 0, 0x62A1}, /* East Asian ideograph */
  {"\x3C", 0, 0x62E3}, /* East Asian ideograph */
  {"\x3F", 0, 0x626C}, /* East Asian ideograph */
  {"\x42", 0, 0x6325}, /* East Asian ideograph */
  {"\x4F", 0, 0x635F}, /* East Asian ideograph */
  {"\x53", 0, 0x6363}, /* East Asian ideograph */
  {"\x55", 0, 0x62A2}, /* East Asian ideograph */
  {"\x5A", 0, 0x5C4F}, /* East Asian ideograph */
  {"\x5B", 0, 0x631A}, /* East Asian ideograph */
  {"\x5F", 0, 0x6402}, /* East Asian ideograph */
  {"\x60", 0, 0x63B4}, /* East Asian ideograph */
  {"\x65", 0, 0x635E}, /* East Asian ideograph */
  {"\x66", 0, 0x62E8}, /* East Asian ideograph */
  {"\x68", 0, 0x6320}, /* East Asian ideograph */
  {"\x6E", 0, 0x6251}, /* East Asian ideograph */
  {"\x71", 0, 0x629A}, /* East Asian ideograph */
  {"\x74", 0, 0x62E5}, /* East Asian ideograph */
  {"\x76", 0, 0x51FB}, /* East Asian ideograph */
  {"\x77", 0, 0x631E}, /* East Asian ideograph */
  {"\x7A", 0, 0x6321}, /* East Asian ideograph */
  {"\x7C", 0, 0x636E}, /* East Asian ideograph */
  {"\x7D", 0, 0x63B3}, /* East Asian ideograph */
  {"\x7E", 0, 0x62E9}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page258 = {
  marc8_31page258_flat, 0
};
/* PAGE 257 */
struct yaz_iconv_trie_flat marc8_31page257_flat[] = {
  {"\x6C", 0, 0x631F}, /* East Asian ideograph */
  {"\x7B", 0, 0x5377}, /* East Asian ideograph */
  {"\x7D", 0, 0x626B}, /* East Asian ideograph */
  {"\x7E", 0, 0x626A}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page257 = {
  marc8_31page257_flat, 0
};
/* PAGE 256 */
struct yaz_iconv_trie_flat marc8_31page256_flat[] = {
  {"\x28", 0, 0x6001}, /* East Asian ideograph */
  {"\x29", 0, 0x5FFE}, /* East Asian ideograph */
  {"\x2B", 0, 0x6006}, /* East Asian ideograph */
  {"\x2E", 0, 0x5E86}, /* East Asian ideograph */
  {"\x31", 0, 0x60ED}, /* East Asian ideograph */
  {"\x33", 0, 0x5FE7}, /* East Asian ideograph */
  {"\x36", 0, 0x8651}, /* East Asian ideograph */
  {"\x38", 0, 0x60E8}, /* East Asian ideograph */
  {"\x39", 0, 0x60EF}, /* East Asian ideograph */
  {"\x3A", 0, 0x6078}, /* East Asian ideograph */
  {"\x3B", 0, 0x6002}, /* East Asian ideograph */
  {"\x3C", 0, 0x6B32}, /* East Asian ideograph */
  {"\x3E", 0, 0x5BAA}, /* East Asian ideograph */
  {"\x3F", 0, 0x51ED}, /* East Asian ideograph */
  {"\x41", 0, 0x60AF}, /* East Asian ideograph */
  {"\x42", 0, 0x6124}, /* East Asian ideograph */
  {"\x44", 0, 0x60EE}, /* East Asian ideograph */
  {"\x45", 0, 0x6187}, /* East Asian ideograph */
  {"\x47", 0, 0x60EB}, /* East Asian ideograph */
  {"\x48", 0, 0x5FC6}, /* East Asian ideograph */
  {"\x4A", 0, 0x5E94}, /* East Asian ideograph */
  {"\x4B", 0, 0x601C}, /* East Asian ideograph */
  {"\x4E", 0, 0x6073}, /* East Asian ideograph */
  {"\x54", 0, 0x6000}, /* East Asian ideograph */
  {"\x55", 0, 0x61D2}, /* East Asian ideograph */
  {"\x56", 0, 0x60AC}, /* East Asian ideograph */
  {"\x58", 0, 0x5FCF}, /* East Asian ideograph */
  {"\x59", 0, 0x6151}, /* East Asian ideograph */
  {"\x5B", 0, 0x60E7}, /* East Asian ideograph */
  {"\x5C", 0, 0x604B}, /* East Asian ideograph */
  {"\x6E", 0, 0x6218}, /* East Asian ideograph */
  {"\x6F", 0, 0x620F}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page256 = {
  marc8_31page256_flat, 0
};
/* PAGE 255 */
struct yaz_iconv_trie_flat marc8_31page255_flat[] = {
  {"\x57", 0, 0x5FF0}, /* East Asian ideograph */
  {"\x5C", 0, 0x95F7}, /* East Asian ideograph */
  {"\x5E", 0, 0x6005}, /* East Asian ideograph */
  {"\x61", 0, 0x6076}, /* East Asian ideograph */
  {"\x6C", 0, 0x60EC}, /* East Asian ideograph */
  {"\x70", 0, 0x607B}, /* East Asian ideograph */
  {"\x77", 0, 0x7231}, /* East Asian ideograph */
  {"\x7E", 0, 0x607C}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page255 = {
  marc8_31page255_flat, 0
};
/* PAGE 254 */
struct yaz_iconv_trie_flat marc8_31page254_flat[] = {
  {"\x27", 0, 0x5E9F}, /* East Asian ideograph */
  {"\x2A", 0, 0x5E7F}, /* East Asian ideograph */
  {"\x2B", 0, 0x5E99}, /* East Asian ideograph */
  {"\x2C", 0, 0x5382}, /* East Asian ideograph */
  {"\x2D", 0, 0x5E9E}, /* East Asian ideograph */
  {"\x2E", 0, 0x5E90}, /* East Asian ideograph */
  {"\x2F", 0, 0x5385}, /* East Asian ideograph */
  {"\x47", 0, 0x5F20}, /* East Asian ideograph */
  {"\x4B", 0, 0x5F39}, /* East Asian ideograph */
  {"\x4C", 0, 0x5F25}, /* East Asian ideograph */
  {"\x4D", 0, 0x5F2F}, /* East Asian ideograph */
  {"\x4F", 0, 0x6C47}, /* East Asian ideograph (duplicate simplified) */
  {"\x65", 0, 0x540E}, /* East Asian ideograph */
  {"\x67", 0, 0x5F84}, /* East Asian ideograph */
  {"\x6C", 0, 0x4ECE}, /* East Asian ideograph */
  {"\x6F", 0, 0x590D}, /* East Asian ideograph */
  {"\x74", 0, 0x5F7B}, /* East Asian ideograph */
  {"\x76", 0, 0x5F81}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page254 = {
  marc8_31page254_flat, 0
};
/* PAGE 253 */
struct yaz_iconv_trie_flat marc8_31page253_flat[] = {
  {"\x28", 0, 0x5C9A}, /* East Asian ideograph */
  {"\x2A", 0, 0x5D2D}, /* East Asian ideograph */
  {"\x2B", 0, 0x5C96}, /* East Asian ideograph */
  {"\x2D", 0, 0x5C7F}, /* East Asian ideograph */
  {"\x2E", 0, 0x5CB3}, /* East Asian ideograph */
  {"\x31", 0, 0x5CE6}, /* East Asian ideograph */
  {"\x32", 0, 0x5DC5}, /* East Asian ideograph */
  {"\x33", 0, 0x5CA9}, /* East Asian ideograph */
  {"\x4F", 0, 0x5E05}, /* East Asian ideograph */
  {"\x51", 0, 0x5E08}, /* East Asian ideograph */
  {"\x52", 0, 0x5E10}, /* East Asian ideograph */
  {"\x53", 0, 0x5E26}, /* East Asian ideograph */
  {"\x58", 0, 0x5E27}, /* East Asian ideograph */
  {"\x5C", 0, 0x5E3C}, /* East Asian ideograph */
  {"\x5E", 0, 0x5E01}, /* East Asian ideograph */
  {"\x60", 0, 0x5E1C}, /* East Asian ideograph */
  {"\x61", 0, 0x5E2E}, /* East Asian ideograph */
  {"\x67", 0, 0x5E72}, /* East Asian ideograph (Version J extension) */
  {"\x6B", 0, 0x51E0}, /* East Asian ideograph */
  {"\x76", 0, 0x5E93}, /* East Asian ideograph */
  {"\x77", 0, 0x5750}, /* East Asian ideograph */
  {"\x7E", 0, 0x5395}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page253 = {
  marc8_31page253_flat, 0
};
/* PAGE 252 */
struct yaz_iconv_trie_flat marc8_31page252_flat[] = {
  {"\x2E", 0, 0x5BDD}, /* East Asian ideograph */
  {"\x31", 0, 0x5B9E}, /* East Asian ideograph */
  {"\x32", 0, 0x5B81}, /* East Asian ideograph */
  {"\x35", 0, 0x5BBD}, /* East Asian ideograph */
  {"\x36", 0, 0x5BA1}, /* East Asian ideograph */
  {"\x37", 0, 0x5199}, /* East Asian ideograph */
  {"\x38", 0, 0x5BA0}, /* East Asian ideograph */
  {"\x39", 0, 0x5B9D}, /* East Asian ideograph */
  {"\x3F", 0, 0x4E13}, /* East Asian ideograph */
  {"\x40", 0, 0x5C06}, /* East Asian ideograph */
  {"\x42", 0, 0x5BFB}, /* East Asian ideograph */
  {"\x43", 0, 0x5BF9}, /* East Asian ideograph */
  {"\x44", 0, 0x5BFC}, /* East Asian ideograph */
  {"\x4C", 0, 0x5C34}, /* East Asian ideograph */
  {"\x60", 0, 0x5C61}, /* East Asian ideograph */
  {"\x61", 0, 0x5C42}, /* East Asian ideograph */
  {"\x63", 0, 0x5C5E}, /* East Asian ideograph */
  {"\x6E", 0, 0x5188}, /* East Asian ideograph */
  {"\x74", 0, 0x5CE1}, /* East Asian ideograph */
  {"\x79", 0, 0x5C9B}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page252 = {
  marc8_31page252_flat, 0
};
/* PAGE 251 */
struct yaz_iconv_trie_flat marc8_31page251_flat[] = {
  {"\x27", 0, 0x5987}, /* East Asian ideograph */
  {"\x28", 0, 0x5A04}, /* East Asian ideograph */
  {"\x36", 0, 0x5988}, /* East Asian ideograph */
  {"\x3B", 0, 0x59AA}, /* East Asian ideograph */
  {"\x41", 0, 0x5A34}, /* East Asian ideograph */
  {"\x43", 0, 0x5A75}, /* East Asian ideograph */
  {"\x44", 0, 0x5A07}, /* East Asian ideograph */
  {"\x45", 0, 0x59A9}, /* East Asian ideograph */
  {"\x48", 0, 0x5AD4}, /* East Asian ideograph */
  {"\x4A", 0, 0x5A74}, /* East Asian ideograph */
  {"\x4B", 0, 0x5A76}, /* East Asian ideograph */
  {"\x5B", 0, 0x5B59}, /* East Asian ideograph */
  {"\x5F", 0, 0x5B5A}, /* East Asian ideograph */
  {"\x60", 0, 0x5B66}, /* East Asian ideograph */
  {"\x63", 0, 0x5B6A}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page251 = {
  marc8_31page251_flat, 0
};
/* PAGE 250 */
struct yaz_iconv_trie_flat marc8_31page250_flat[] = {
  {"\x23", 0, 0x4F19}, /* East Asian ideograph */
  {"\x24", 0, 0x68A6}, /* East Asian ideograph */
  {"\x2E", 0, 0x5939}, /* East Asian ideograph */
  {"\x3F", 0, 0x5941}, /* East Asian ideograph */
  {"\x40", 0, 0x593A}, /* East Asian ideograph */
  {"\x41", 0, 0x594B}, /* East Asian ideograph */
  {"\x53", 0, 0x5986}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page250 = {
  marc8_31page250_flat, 0
};
/* PAGE 249 */
struct yaz_iconv_trie_flat marc8_31page249_flat[] = {
  {"\x3B", 0, 0x6267}, /* East Asian ideograph */
  {"\x3E", 0, 0x57A9}, /* East Asian ideograph */
  {"\x44", 0, 0x62A5}, /* East Asian ideograph */
  {"\x45", 0, 0x5C27}, /* East Asian ideograph */
  {"\x4A", 0, 0x573A}, /* East Asian ideograph */
  {"\x4D", 0, 0x6D82}, /* East Asian ideograph */
  {"\x55", 0, 0x575E}, /* East Asian ideograph */
  {"\x56", 0, 0x5757}, /* East Asian ideograph */
  {"\x59", 0, 0x5C18}, /* East Asian ideograph */
  {"\x5A", 0, 0x57AB}, /* East Asian ideograph */
  {"\x5B", 0, 0x5811}, /* East Asian ideograph */
  {"\x60", 0, 0x575F}, /* East Asian ideograph */
  {"\x61", 0, 0x5760}, /* East Asian ideograph */
  {"\x62", 0, 0x5815}, /* East Asian ideograph */
  {"\x64", 0, 0x575B}, /* East Asian ideograph */
  {"\x67", 0, 0x57A6}, /* East Asian ideograph */
  {"\x69", 0, 0x538B}, /* East Asian ideograph */
  {"\x6B", 0, 0x5739}, /* East Asian ideograph */
  {"\x6C", 0, 0x5792}, /* East Asian ideograph */
  {"\x6D", 0, 0x5784}, /* East Asian ideograph */
  {"\x6E", 0, 0x574F}, /* East Asian ideograph */
  {"\x6F", 0, 0x575C}, /* East Asian ideograph */
  {"\x71", 0, 0x575D}, /* East Asian ideograph */
  {"\x74", 0, 0x58EE}, /* East Asian ideograph */
  {"\x76", 0, 0x58F6}, /* East Asian ideograph */
  {"\x77", 0, 0x5BFF}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page249 = {
  marc8_31page249_flat, 0
};
/* PAGE 248 */
struct yaz_iconv_trie_flat marc8_31page248_flat[] = {
  {"\x21", 0, 0x545C}, /* East Asian ideograph */
  {"\x22", 0, 0x545B}, /* East Asian ideograph */
  {"\x27", 0, 0x5567}, /* East Asian ideograph */
  {"\x2C", 0, 0x53F9}, /* East Asian ideograph */
  {"\x2E", 0, 0x5455}, /* East Asian ideograph */
  {"\x30", 0, 0x5C1D}, /* East Asian ideograph */
  {"\x31", 0, 0x55BD}, /* East Asian ideograph */
  {"\x32", 0, 0x5520}, /* East Asian ideograph */
  {"\x33", 0, 0x5578}, /* East Asian ideograph */
  {"\x3D", 0, 0x5480}, /* East Asian ideograph */
  {"\x40", 0, 0x53FD}, /* East Asian ideograph */
  {"\x44", 0, 0x5428}, /* East Asian ideograph */
  {"\x45", 0, 0x55B7}, /* East Asian ideograph */
  {"\x46", 0, 0x5F53}, /* East Asian ideograph (duplicate simplified) */
  {"\x47", 0, 0x54DD}, /* East Asian ideograph */
  {"\x4B", 0, 0x55F3}, /* East Asian ideograph */
  {"\x4E", 0, 0x549B}, /* East Asian ideograph */
  {"\x51", 0, 0x5413}, /* East Asian ideograph */
  {"\x54", 0, 0x565C}, /* East Asian ideograph */
  {"\x55", 0, 0x5411}, /* East Asian ideograph */
  {"\x56", 0, 0x5499}, /* East Asian ideograph */
  {"\x5A", 0, 0x4E25}, /* East Asian ideograph */
  {"\x5B", 0, 0x5624}, /* East Asian ideograph */
  {"\x5C", 0, 0x556D}, /* East Asian ideograph */
  {"\x5D", 0, 0x55EB}, /* East Asian ideograph */
  {"\x5E", 0, 0x56A3}, /* East Asian ideograph */
  {"\x61", 0, 0x7F57}, /* East Asian ideograph (duplicate simplified) */
  {"\x62", 0, 0x5453}, /* East Asian ideograph */
  {"\x64", 0, 0x5631}, /* East Asian ideograph */
  {"\x6F", 0, 0x56EF}, /* East Asian ideograph */
  {"\x70", 0, 0x56F4}, /* East Asian ideograph */
  {"\x71", 0, 0x56ED}, /* East Asian ideograph */
  {"\x72", 0, 0x5706}, /* East Asian ideograph */
  {"\x73", 0, 0x56E2}, /* East Asian ideograph */
  {"\x74", 0, 0x56FE}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page248 = {
  marc8_31page248_flat, 0
};
/* PAGE 247 */
struct yaz_iconv_trie_flat marc8_31page247_flat[] = {
  {"\x3E", 0, 0x5458}, /* East Asian ideograph */
  {"\x48", 0, 0x95EE}, /* East Asian ideograph */
  {"\x49", 0, 0x54D1}, /* East Asian ideograph */
  {"\x63", 0, 0x4E27}, /* East Asian ideograph */
  {"\x68", 0, 0x5355}, /* East Asian ideograph */
  {"\x6D", 0, 0x5524}, /* East Asian ideograph */
  {"\x6F", 0, 0x4E54}, /* East Asian ideograph */
  {"\x71", 0, 0x54DF}, /* East Asian ideograph */
  {"\x78", 0, 0x556C}, /* East Asian ideograph */
  {"\x7A", 0, 0x5417}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page247 = {
  marc8_31page247_flat, 0
};
/* PAGE 246 */
struct yaz_iconv_trie_flat marc8_31page246_flat[] = {
  {"\x2B", 0, 0x4E1B}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page246 = {
  marc8_31page246_flat, 0
};
/* PAGE 245 */
struct yaz_iconv_trie_flat marc8_31page245_flat[] = {
  {"\x21", 0, 0x5251}, /* East Asian ideograph */
  {"\x22", 0, 0x5218}, /* East Asian ideograph */
  {"\x23", 0, 0x5242}, /* East Asian ideograph */
  {"\x2F", 0, 0x52B2}, /* East Asian ideograph */
  {"\x33", 0, 0x52A1}, /* East Asian ideograph */
  {"\x34", 0, 0x52A8}, /* East Asian ideograph */
  {"\x35", 0, 0x52B3}, /* East Asian ideograph */
  {"\x36", 0, 0x52CB}, /* East Asian ideograph */
  {"\x37", 0, 0x80DC}, /* East Asian ideograph */
  {"\x38", 0, 0x52BF}, /* East Asian ideograph */
  {"\x3C", 0, 0x52B1}, /* East Asian ideograph */
  {"\x3D", 0, 0x529D}, /* East Asian ideograph */
  {"\x51", 0, 0x6C47}, /* East Asian ideograph */
  {"\x52", 0, 0x532E}, /* East Asian ideograph */
  {"\x55", 0, 0x533A}, /* East Asian ideograph */
  {"\x5F", 0, 0x5346}, /* East Asian ideograph */
  {"\x60", 0, 0x534F}, /* East Asian ideograph */
  {"\x7A", 0, 0x538C}, /* East Asian ideograph */
  {"\x7B", 0, 0x5389}, /* East Asian ideograph */
  {"\x7D", 0, 0x53C2}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page245 = {
  marc8_31page245_flat, 0
};
/* PAGE 244 */
struct yaz_iconv_trie_flat marc8_31page244_flat[] = {
  {"\x23", 0, 0x4E24}, /* East Asian ideograph */
  {"\x40", 0, 0x51BB}, /* East Asian ideograph */
  {"\x48", 0, 0x51EF}, /* East Asian ideograph */
  {"\x6B", 0, 0x514B}, /* East Asian ideograph */
  {"\x6D", 0, 0x5219}, /* East Asian ideograph */
  {"\x70", 0, 0x521A}, /* East Asian ideograph */
  {"\x76", 0, 0x5240}, /* East Asian ideograph */
  {"\x78", 0, 0x521B}, /* East Asian ideograph */
  {"\x7C", 0, 0x5212}, /* East Asian ideograph */
  {"\x7E", 0, 0x5267}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page244 = {
  marc8_31page244_flat, 0
};
/* PAGE 243 */
struct yaz_iconv_trie_flat marc8_31page243_flat[] = {
  {"\x24", 0, 0x4E2A}, /* East Asian ideograph */
  {"\x26", 0, 0x4F25}, /* East Asian ideograph */
  {"\x2D", 0, 0x4F26}, /* East Asian ideograph */
  {"\x2E", 0, 0x4EC3}, /* East Asian ideograph (duplicate simplified) */
  {"\x33", 0, 0x4F1F}, /* East Asian ideograph */
  {"\x35", 0, 0x4FA7}, /* East Asian ideograph */
  {"\x38", 0, 0x4FA6}, /* East Asian ideograph */
  {"\x3E", 0, 0x5BB6}, /* East Asian ideograph */
  {"\x40", 0, 0x5907}, /* East Asian ideograph */
  {"\x41", 0, 0x6770}, /* East Asian ideograph */
  {"\x43", 0, 0x4F27}, /* East Asian ideograph */
  {"\x44", 0, 0x4F1E}, /* East Asian ideograph */
  {"\x46", 0, 0x4F20}, /* East Asian ideograph */
  {"\x47", 0, 0x503A}, /* East Asian ideograph */
  {"\x49", 0, 0x4EC5}, /* East Asian ideograph */
  {"\x4A", 0, 0x503E}, /* East Asian ideograph */
  {"\x4C", 0, 0x4F24}, /* East Asian ideograph */
  {"\x51", 0, 0x4FA5}, /* East Asian ideograph */
  {"\x55", 0, 0x4EC6}, /* East Asian ideograph */
  {"\x56", 0, 0x4F2A}, /* East Asian ideograph */
  {"\x57", 0, 0x8C61}, /* East Asian ideograph */
  {"\x58", 0, 0x4FA8}, /* East Asian ideograph */
  {"\x59", 0, 0x4EEA}, /* East Asian ideograph */
  {"\x5A", 0, 0x4EBF}, /* East Asian ideograph */
  {"\x5D", 0, 0x4EF7}, /* East Asian ideograph */
  {"\x5E", 0, 0x4FAC}, /* East Asian ideograph */
  {"\x60", 0, 0x4FA9}, /* East Asian ideograph */
  {"\x61", 0, 0x4FED}, /* East Asian ideograph */
  {"\x62", 0, 0x50A7}, /* East Asian ideograph */
  {"\x63", 0, 0x5C3D}, /* East Asian ideograph (duplicate simplified) */
  {"\x65", 0, 0x4FE6}, /* East Asian ideograph */
  {"\x66", 0, 0x4F18}, /* East Asian ideograph */
  {"\x67", 0, 0x507F}, /* East Asian ideograph */
  {"\x69", 0, 0x50A8}, /* East Asian ideograph */
  {"\x6A", 0, 0x4FEA}, /* East Asian ideograph */
  {"\x6B", 0, 0x4FE8}, /* East Asian ideograph */
  {"\x73", 0, 0x51F6}, /* East Asian ideograph */
  {"\x7A", 0, 0x513F}, /* East Asian ideograph */
  {"\x7B", 0, 0x5156}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page243 = {
  marc8_31page243_flat, 0
};
/* PAGE 242 */
struct yaz_iconv_trie_flat marc8_31page242_flat[] = {
  {"\x38", 0, 0x5E03}, /* East Asian ideograph */
  {"\x3C", 0, 0x5360}, /* East Asian ideograph */
  {"\x4C", 0, 0x6765}, /* East Asian ideograph */
  {"\x4F", 0, 0x4ED1}, /* East Asian ideograph */
  {"\x5D", 0, 0x4FA0}, /* East Asian ideograph */
  {"\x69", 0, 0x7CFB}, /* East Asian ideograph (duplicate simplified) */
  {"\x6C", 0, 0x4ED3}, /* East Asian ideograph */
  {"\x73", 0, 0x4EEC}, /* East Asian ideograph */
  {"\x79", 0, 0x4FE9}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page242 = {
  marc8_31page242_flat, 0
};
/* PAGE 241 */
struct yaz_iconv_trie_flat marc8_31page241_flat[] = {
  {"\x32", 0, 0x5E76}, /* East Asian ideograph */
  {"\x4C", 0, 0x5E72}, /* East Asian ideograph */
  {"\x4D", 0, 0x4E71}, /* East Asian ideograph */
  {"\x58", 0, 0x4E9A}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page241 = {
  marc8_31page241_flat, 0
};
/* PAGE 240 */
struct yaz_iconv_trie_dir marc8_31page240_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {242, 0, 0},
  {243, 0, 0},
  {244, 0, 0},
  {245, 0, 0},
  {246, 0, 0},
  {247, 0, 0},
  {248, 0, 0},
  {249, 0, 0},
  {250, 0, 0},
  {251, 0, 0},
  {252, 0, 0},
  {253, 0, 0},
  {254, 0, 0},
  {255, 0, 0},
  {256, 0, 0},
  {257, 0, 0},
  {258, 0, 0},
  {259, 0, 0},
  {260, 0, 0},
  {261, 0, 0},
  {262, 0, 0},
  {263, 0, 0},
  {264, 0, 0},
  {265, 0, 0},
  {266, 0, 0},
  {267, 0, 0},
  {268, 0, 0},
  {269, 0, 0},
  {270, 0, 0},
  {271, 0, 0},
  {272, 0, 0},
  {273, 0, 0},
  {274, 0, 0},
  {275, 0, 0},
  {276, 0, 0},
  {277, 0, 0},
  {278, 0, 0},
  {279, 0, 0},
  {280, 0, 0},
  {281, 0, 0},
  {282, 0, 0},
  {283, 0, 0},
  {284, 0, 0},
  {285, 0, 0},
  {286, 0, 0},
  {287, 0, 0},
  {288, 0, 0},
  {289, 0, 0},
  {290, 0, 0},
  {291, 0, 0},
  {292, 0, 0},
  {293, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {294, 0, 0},
  {295, 0, 0},
  {296, 0, 0},
  {297, 0, 0},
  {0, 0, 0},
  {298, 0, 0},
  {0, 0, 0},
  {299, 0, 0},
  {300, 0, 0},
  {301, 0, 0},
  {302, 0, 0},
  {303, 0, 0},
  {304, 0, 0},
  {305, 0, 0},
  {306, 0, 0},
  {0, 0, 0},
  {307, 0, 0},
  {308, 0, 0},
  {309, 0, 0},
  {310, 0, 0},
  {0, 0, 0},
  {311, 0, 0},
  {312, 0, 0},
  {313, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8_31page240 = {
  0, marc8_31page240_dir
};
/* PAGE 239 */
struct yaz_iconv_trie_flat marc8_31page239_flat[] = {
  {"\x23", 0, 0x9F57}, /* East Asian ideograph */
  {"\x28", 0, 0x9F60}, /* East Asian ideograph */
  {"\x3F", 0, 0x9F6E}, /* East Asian ideograph */
  {"\x40", 0, 0x9F6F}, /* East Asian ideograph */
  {"\x47", 0, 0x9F76}, /* East Asian ideograph */
  {"\x5B", 0, 0x9F8E}, /* East Asian ideograph */
  {"\x61", 0, 0x9F93}, /* East Asian ideograph */
  {"\x62", 0, 0x9F95}, /* East Asian ideograph */
  {"\x6B", 0, 0x9FA0}, /* East Asian ideograph */
  {"\x71", 0, 0x9FA5}, /* East Asian ideograph */
  {"\x72", 0, 0x9FA4}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page239 = {
  marc8_31page239_flat, 0
};
/* PAGE 238 */
struct yaz_iconv_trie_flat marc8_31page238_flat[] = {
  {"\x2F", 0, 0x9F0F}, /* East Asian ideograph */
  {"\x31", 0, 0x9F10}, /* East Asian ideograph */
  {"\x32", 0, 0x9F12}, /* East Asian ideograph */
  {"\x33", 0, 0x9F16}, /* East Asian ideograph */
  {"\x34", 0, 0x9F17}, /* East Asian ideograph */
  {"\x37", 0, 0x9F1A}, /* East Asian ideograph */
  {"\x45", 0, 0x9F22}, /* East Asian ideograph */
  {"\x48", 0, 0x9F2B}, /* East Asian ideograph */
  {"\x49", 0, 0x9F26}, /* East Asian ideograph */
  {"\x53", 0, 0x9F2F}, /* East Asian ideograph */
  {"\x5E", 0, 0x9F39}, /* East Asian ideograph */
  {"\x5F", 0, 0x9F37}, /* East Asian ideograph */
  {"\x64", 0, 0x9F3D}, /* East Asian ideograph */
  {"\x69", 0, 0x9F41}, /* East Asian ideograph */
  {"\x6D", 0, 0x9F45}, /* East Asian ideograph */
  {"\x6F", 0, 0x9F46}, /* East Asian ideograph */
  {"\x71", 0, 0x9F48}, /* East Asian ideograph */
  {"\x73", 0, 0x9F49}, /* East Asian ideograph */
  {"\x79", 0, 0x9F4E}, /* East Asian ideograph */
  {"\x7B", 0, 0x9F4F}, /* East Asian ideograph */
  {"\x7C", 0, 0x9F54}, /* East Asian ideograph */
  {"\x7E", 0, 0x9F55}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page238 = {
  marc8_31page238_flat, 0
};
/* PAGE 237 */
struct yaz_iconv_trie_flat marc8_31page237_flat[] = {
  {"\x30", 0, 0x9EC1}, /* East Asian ideograph */
  {"\x35", 0, 0x9EC6}, /* East Asian ideograph */
  {"\x37", 0, 0x9EC8}, /* East Asian ideograph */
  {"\x42", 0, 0x9ECC}, /* East Asian ideograph */
  {"\x4A", 0, 0x9ED0}, /* East Asian ideograph */
  {"\x4C", 0, 0x9ED3}, /* East Asian ideograph */
  {"\x53", 0, 0x9EDA}, /* East Asian ideograph */
  {"\x55", 0, 0x9EDF}, /* East Asian ideograph */
  {"\x57", 0, 0x9EE3}, /* East Asian ideograph */
  {"\x59", 0, 0x9EE5}, /* East Asian ideograph */
  {"\x5C", 0, 0x9EE7}, /* East Asian ideograph */
  {"\x60", 0, 0x9EEE}, /* East Asian ideograph */
  {"\x66", 0, 0x9EF0}, /* East Asian ideograph */
  {"\x6F", 0, 0x9EF6}, /* East Asian ideograph */
  {"\x74", 0, 0x9EF9}, /* East Asian ideograph */
  {"\x76", 0, 0x9EFB}, /* East Asian ideograph */
  {"\x77", 0, 0x9EFC}, /* East Asian ideograph */
  {"\x7A", 0, 0x9EFD}, /* East Asian ideograph */
  {"\x7B", 0, 0x9EFE}, /* East Asian ideograph */
  {"\x7C", 0, 0x9EFF}, /* East Asian ideograph */
  {"\x7D", 0, 0x9F02}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page237 = {
  marc8_31page237_flat, 0
};
/* PAGE 236 */
struct yaz_iconv_trie_flat marc8_31page236_flat[] = {
  {"\x27", 0, 0x9E0E}, /* East Asian ideograph */
  {"\x2B", 0, 0x9E11}, /* East Asian ideograph */
  {"\x36", 0, 0x9E15}, /* East Asian ideograph */
  {"\x37", 0, 0x9E18}, /* East Asian ideograph */
  {"\x39", 0, 0x9E1C}, /* East Asian ideograph */
  {"\x3A", 0, 0x9E1B}, /* East Asian ideograph */
  {"\x3B", 0, 0x9E1D}, /* East Asian ideograph */
  {"\x3C", 0, 0x9E75}, /* East Asian ideograph */
  {"\x42", 0, 0x9E7A}, /* East Asian ideograph */
  {"\x43", 0, 0x9E7B}, /* East Asian ideograph */
  {"\x47", 0, 0x9E80}, /* East Asian ideograph */
  {"\x48", 0, 0x9E83}, /* East Asian ideograph */
  {"\x49", 0, 0x9E84}, /* East Asian ideograph */
  {"\x4B", 0, 0x9E88}, /* East Asian ideograph */
  {"\x4F", 0, 0x9E87}, /* East Asian ideograph */
  {"\x55", 0, 0x9E90}, /* East Asian ideograph */
  {"\x58", 0, 0x9E8C}, /* East Asian ideograph */
  {"\x5A", 0, 0x9E95}, /* East Asian ideograph */
  {"\x5C", 0, 0x9E91}, /* East Asian ideograph */
  {"\x5D", 0, 0x9E9B}, /* East Asian ideograph */
  {"\x66", 0, 0x9E9E}, /* East Asian ideograph */
  {"\x77", 0, 0x9EAD}, /* East Asian ideograph */
  {"\x79", 0, 0x9EAF}, /* East Asian ideograph */
  {"\x7A", 0, 0x9EB0}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page236 = {
  marc8_31page236_flat, 0
};
/* PAGE 235 */
struct yaz_iconv_trie_flat marc8_31page235_flat[] = {
  {"\x22", 0, 0x9DC7}, /* East Asian ideograph */
  {"\x27", 0, 0x9DC3}, /* East Asian ideograph */
  {"\x28", 0, 0x9DBB}, /* East Asian ideograph */
  {"\x32", 0, 0x9DB9}, /* East Asian ideograph */
  {"\x34", 0, 0x9DAC}, /* East Asian ideograph */
  {"\x36", 0, 0x9DB2}, /* East Asian ideograph */
  {"\x3A", 0, 0x9DDF}, /* East Asian ideograph */
  {"\x3E", 0, 0x9DD9}, /* East Asian ideograph */
  {"\x45", 0, 0x9DD6}, /* East Asian ideograph */
  {"\x46", 0, 0x9DDE}, /* East Asian ideograph */
  {"\x4F", 0, 0x9DE9}, /* East Asian ideograph */
  {"\x57", 0, 0x9DF2}, /* East Asian ideograph */
  {"\x5B", 0, 0x9DF8}, /* East Asian ideograph */
  {"\x5C", 0, 0x9DFC}, /* East Asian ideograph */
  {"\x5F", 0, 0x9DEB}, /* East Asian ideograph */
  {"\x65", 0, 0x9DEF}, /* East Asian ideograph */
  {"\x6A", 0, 0x9DED}, /* East Asian ideograph */
  {"\x6C", 0, 0x9DE6}, /* East Asian ideograph */
  {"\x6D", 0, 0x9DEE}, /* East Asian ideograph */
  {"\x71", 0, 0x9E07}, /* East Asian ideograph */
  {"\x7E", 0, 0x9DFD}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page235 = {
  marc8_31page235_flat, 0
};
/* PAGE 234 */
struct yaz_iconv_trie_flat marc8_31page234_flat[] = {
  {"\x26", 0, 0x9D5A}, /* East Asian ideograph */
  {"\x2A", 0, 0x9D52}, /* East Asian ideograph */
  {"\x2C", 0, 0x9D77}, /* East Asian ideograph */
  {"\x2E", 0, 0x9D8A}, /* East Asian ideograph */
  {"\x2F", 0, 0x9D7A}, /* East Asian ideograph */
  {"\x35", 0, 0x9D87}, /* East Asian ideograph */
  {"\x3F", 0, 0x9D78}, /* East Asian ideograph */
  {"\x42", 0, 0x9D7E}, /* East Asian ideograph */
  {"\x47", 0, 0x9D69}, /* East Asian ideograph */
  {"\x4D", 0, 0x9D7B}, /* East Asian ideograph */
  {"\x4F", 0, 0x9D83}, /* East Asian ideograph */
  {"\x52", 0, 0x9D6F}, /* East Asian ideograph */
  {"\x59", 0, 0x9DA9}, /* East Asian ideograph */
  {"\x5E", 0, 0x9D92}, /* East Asian ideograph */
  {"\x60", 0, 0x9D98}, /* East Asian ideograph */
  {"\x66", 0, 0x9DA4}, /* East Asian ideograph */
  {"\x67", 0, 0x9DAA}, /* East Asian ideograph */
  {"\x6A", 0, 0x9DA1}, /* East Asian ideograph */
  {"\x6B", 0, 0x9D9A}, /* East Asian ideograph */
  {"\x70", 0, 0x9D96}, /* East Asian ideograph */
  {"\x74", 0, 0x9DB1}, /* East Asian ideograph */
  {"\x76", 0, 0x9DB6}, /* East Asian ideograph */
  {"\x77", 0, 0x9DBC}, /* East Asian ideograph */
  {"\x79", 0, 0x9DC0}, /* East Asian ideograph */
  {"\x7A", 0, 0x9DC1}, /* East Asian ideograph */
  {"\x7B", 0, 0x9DB8}, /* East Asian ideograph */
  {"\x7C", 0, 0x9DBA}, /* East Asian ideograph */
  {"\x7E", 0, 0x9DCF}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page234 = {
  marc8_31page234_flat, 0
};
/* PAGE 233 */
struct yaz_iconv_trie_flat marc8_31page233_flat[] = {
  {"\x21", 0, 0x9D02}, /* East Asian ideograph */
  {"\x22", 0, 0x9D03}, /* East Asian ideograph */
  {"\x23", 0, 0x9CF7}, /* East Asian ideograph */
  {"\x24", 0, 0x9D04}, /* East Asian ideograph */
  {"\x28", 0, 0x9D07}, /* East Asian ideograph */
  {"\x2C", 0, 0x9CF8}, /* East Asian ideograph */
  {"\x2F", 0, 0x9D2A}, /* East Asian ideograph */
  {"\x30", 0, 0x9D25}, /* East Asian ideograph */
  {"\x3F", 0, 0x9D1E}, /* East Asian ideograph */
  {"\x44", 0, 0x9D1D}, /* East Asian ideograph */
  {"\x48", 0, 0x9D1F}, /* East Asian ideograph */
  {"\x4F", 0, 0x9D41}, /* East Asian ideograph */
  {"\x53", 0, 0x9D36}, /* East Asian ideograph */
  {"\x63", 0, 0x9D3E}, /* East Asian ideograph */
  {"\x65", 0, 0x9D30}, /* East Asian ideograph */
  {"\x68", 0, 0x9D42}, /* East Asian ideograph */
  {"\x69", 0, 0x9D40}, /* East Asian ideograph */
  {"\x6B", 0, 0x9D3D}, /* East Asian ideograph */
  {"\x70", 0, 0x9D5C}, /* East Asian ideograph */
  {"\x75", 0, 0x9D53}, /* East Asian ideograph */
  {"\x7B", 0, 0x9D59}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page233 = {
  marc8_31page233_flat, 0
};
/* PAGE 232 */
struct yaz_iconv_trie_flat marc8_31page232_flat[] = {
  {"\x25", 0, 0x9C32}, /* East Asian ideograph */
  {"\x26", 0, 0x9C44}, /* East Asian ideograph */
  {"\x28", 0, 0x9C48}, /* East Asian ideograph */
  {"\x29", 0, 0x9C39}, /* East Asian ideograph */
  {"\x2A", 0, 0x9C33}, /* East Asian ideograph */
  {"\x30", 0, 0x9C47}, /* East Asian ideograph */
  {"\x32", 0, 0x9C35}, /* East Asian ideograph */
  {"\x34", 0, 0x9C37}, /* East Asian ideograph */
  {"\x38", 0, 0x9C52}, /* East Asian ideograph */
  {"\x3B", 0, 0x9C58}, /* East Asian ideograph */
  {"\x45", 0, 0x9C51}, /* East Asian ideograph */
  {"\x49", 0, 0x9C63}, /* East Asian ideograph */
  {"\x4F", 0, 0x9C67}, /* East Asian ideograph */
  {"\x55", 0, 0x9C5F}, /* East Asian ideograph */
  {"\x56", 0, 0x9C60}, /* East Asian ideograph */
  {"\x58", 0, 0x9C6D}, /* East Asian ideograph */
  {"\x5B", 0, 0x9C68}, /* East Asian ideograph */
  {"\x5C", 0, 0x9C6F}, /* East Asian ideograph */
  {"\x5E", 0, 0x9C6E}, /* East Asian ideograph */
  {"\x6B", 0, 0x9C7A}, /* East Asian ideograph */
  {"\x73", 0, 0x9CE7}, /* East Asian ideograph */
  {"\x74", 0, 0x9CF0}, /* East Asian ideograph */
  {"\x77", 0, 0x9CF2}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page232 = {
  marc8_31page232_flat, 0
};
/* PAGE 231 */
struct yaz_iconv_trie_flat marc8_31page231_flat[] = {
  {"\x23", 0, 0x9BD5}, /* East Asian ideograph */
  {"\x27", 0, 0x9BE4}, /* East Asian ideograph */
  {"\x2B", 0, 0x9BF1}, /* East Asian ideograph */
  {"\x2C", 0, 0x9BE1}, /* East Asian ideograph */
  {"\x2D", 0, 0x9BDB}, /* East Asian ideograph */
  {"\x2F", 0, 0x9BE2}, /* East Asian ideograph */
  {"\x31", 0, 0x9BF0}, /* East Asian ideograph */
  {"\x34", 0, 0x9BD4}, /* East Asian ideograph */
  {"\x3E", 0, 0x9BFF}, /* East Asian ideograph */
  {"\x43", 0, 0x9C06}, /* East Asian ideograph */
  {"\x44", 0, 0x9C15}, /* East Asian ideograph */
  {"\x49", 0, 0x9C0A}, /* East Asian ideograph */
  {"\x4B", 0, 0x9C08}, /* East Asian ideograph */
  {"\x4C", 0, 0x9C14}, /* East Asian ideograph */
  {"\x4D", 0, 0x9C04}, /* East Asian ideograph */
  {"\x52", 0, 0x9C02}, /* East Asian ideograph */
  {"\x54", 0, 0x9C10}, /* East Asian ideograph */
  {"\x59", 0, 0x9C12}, /* East Asian ideograph */
  {"\x5C", 0, 0x9C09}, /* East Asian ideograph */
  {"\x66", 0, 0x9C1C}, /* East Asian ideograph */
  {"\x69", 0, 0x9C2F}, /* East Asian ideograph */
  {"\x6E", 0, 0x9C23}, /* East Asian ideograph */
  {"\x70", 0, 0x9C2E}, /* East Asian ideograph */
  {"\x71", 0, 0x9C28}, /* East Asian ideograph */
  {"\x78", 0, 0x9C21}, /* East Asian ideograph */
  {"\x79", 0, 0x9C24}, /* East Asian ideograph */
  {"\x7E", 0, 0x9C46}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page231 = {
  marc8_31page231_flat, 0
};
/* PAGE 230 */
struct yaz_iconv_trie_flat marc8_31page230_flat[] = {
  {"\x21", 0, 0x9B83}, /* East Asian ideograph */
  {"\x29", 0, 0x9B8E}, /* East Asian ideograph */
  {"\x2B", 0, 0x9B90}, /* East Asian ideograph */
  {"\x2E", 0, 0x9B93}, /* East Asian ideograph */
  {"\x2F", 0, 0x9B97}, /* East Asian ideograph */
  {"\x31", 0, 0x9B92}, /* East Asian ideograph */
  {"\x32", 0, 0x9B98}, /* East Asian ideograph */
  {"\x36", 0, 0x9B9F}, /* East Asian ideograph */
  {"\x39", 0, 0x9B9D}, /* East Asian ideograph */
  {"\x3C", 0, 0x9BAD}, /* East Asian ideograph */
  {"\x3D", 0, 0x9B9A}, /* East Asian ideograph */
  {"\x3F", 0, 0x9BA8}, /* East Asian ideograph */
  {"\x42", 0, 0x9B9E}, /* East Asian ideograph */
  {"\x43", 0, 0x9B99}, /* East Asian ideograph */
  {"\x49", 0, 0x9B86}, /* East Asian ideograph */
  {"\x4E", 0, 0x9BA0}, /* East Asian ideograph */
  {"\x56", 0, 0x9BC7}, /* East Asian ideograph */
  {"\x59", 0, 0x9BD2}, /* East Asian ideograph */
  {"\x5D", 0, 0x9BC6}, /* East Asian ideograph */
  {"\x5E", 0, 0x9BBF}, /* East Asian ideograph */
  {"\x5F", 0, 0x9BC1}, /* East Asian ideograph */
  {"\x66", 0, 0x9BB9}, /* East Asian ideograph */
  {"\x6B", 0, 0x9BBB}, /* East Asian ideograph */
  {"\x6C", 0, 0x9BD3}, /* East Asian ideograph */
  {"\x6E", 0, 0x9BC0}, /* East Asian ideograph */
  {"\x72", 0, 0x9BC8}, /* East Asian ideograph */
  {"\x77", 0, 0x9BD7}, /* East Asian ideograph */
  {"\x7A", 0, 0x9BD6}, /* East Asian ideograph */
  {"\x7C", 0, 0x9BEB}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page230 = {
  marc8_31page230_flat, 0
};
/* PAGE 229 */
struct yaz_iconv_trie_flat marc8_31page229_flat[] = {
  {"\x22", 0, 0x9B35}, /* East Asian ideograph */
  {"\x23", 0, 0x9B37}, /* East Asian ideograph */
  {"\x36", 0, 0x9B43}, /* East Asian ideograph */
  {"\x3A", 0, 0x9B48}, /* East Asian ideograph */
  {"\x3C", 0, 0x9B4E}, /* East Asian ideograph */
  {"\x3E", 0, 0x9B4D}, /* East Asian ideograph */
  {"\x41", 0, 0x9B4B}, /* East Asian ideograph */
  {"\x47", 0, 0x9B51}, /* East Asian ideograph */
  {"\x5D", 0, 0x9B74}, /* East Asian ideograph */
  {"\x63", 0, 0x9B68}, /* East Asian ideograph */
  {"\x72", 0, 0x9B80}, /* East Asian ideograph */
  {"\x73", 0, 0x9B8C}, /* East Asian ideograph */
  {"\x7A", 0, 0x9B95}, /* East Asian ideograph */
  {"\x7B", 0, 0x9B7D}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page229 = {
  marc8_31page229_flat, 0
};
/* PAGE 228 */
struct yaz_iconv_trie_flat marc8_31page228_flat[] = {
  {"\x21", 0, 0x9AE7}, /* East Asian ideograph */
  {"\x27", 0, 0x9AEB}, /* East Asian ideograph */
  {"\x28", 0, 0x9AF2}, /* East Asian ideograph */
  {"\x2A", 0, 0x9AEF}, /* East Asian ideograph */
  {"\x32", 0, 0x9AF9}, /* East Asian ideograph */
  {"\x35", 0, 0x9AFD}, /* East Asian ideograph */
  {"\x36", 0, 0x9B01}, /* East Asian ideograph */
  {"\x38", 0, 0x9B02}, /* East Asian ideograph */
  {"\x3B", 0, 0x9B00}, /* East Asian ideograph */
  {"\x3C", 0, 0x9B08}, /* East Asian ideograph */
  {"\x3E", 0, 0x9B04}, /* East Asian ideograph */
  {"\x41", 0, 0x9B05}, /* East Asian ideograph */
  {"\x43", 0, 0x9B0B}, /* East Asian ideograph */
  {"\x47", 0, 0x9B0E}, /* East Asian ideograph */
  {"\x4E", 0, 0x9B11}, /* East Asian ideograph */
  {"\x4F", 0, 0x9B10}, /* East Asian ideograph */
  {"\x54", 0, 0x9B18}, /* East Asian ideograph */
  {"\x56", 0, 0x9B1D}, /* East Asian ideograph */
  {"\x5E", 0, 0x9B1F}, /* East Asian ideograph */
  {"\x66", 0, 0x9B23}, /* East Asian ideograph */
  {"\x6C", 0, 0x9B29}, /* East Asian ideograph */
  {"\x73", 0, 0x9B2D}, /* East Asian ideograph */
  {"\x74", 0, 0x9B2E}, /* East Asian ideograph */
  {"\x76", 0, 0x9B2F}, /* East Asian ideograph */
  {"\x7D", 0, 0x9B34}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page228 = {
  marc8_31page228_flat, 0
};
/* PAGE 227 */
struct yaz_iconv_trie_flat marc8_31page227_flat[] = {
  {"\x22", 0, 0x9A4D}, /* East Asian ideograph */
  {"\x24", 0, 0x9A52}, /* East Asian ideograph */
  {"\x27", 0, 0x9A4A}, /* East Asian ideograph */
  {"\x2A", 0, 0x9A58}, /* East Asian ideograph */
  {"\x2C", 0, 0x9A56}, /* East Asian ideograph */
  {"\x33", 0, 0x9A64}, /* East Asian ideograph */
  {"\x34", 0, 0x9A66}, /* East Asian ideograph */
  {"\x3A", 0, 0x9A6B}, /* East Asian ideograph */
  {"\x3F", 0, 0x9AAD}, /* East Asian ideograph */
  {"\x41", 0, 0x9AAB}, /* East Asian ideograph */
  {"\x43", 0, 0x9AB1}, /* East Asian ideograph */
  {"\x45", 0, 0x9AB3}, /* East Asian ideograph */
  {"\x49", 0, 0x9AB6}, /* East Asian ideograph */
  {"\x4C", 0, 0x9ABB}, /* East Asian ideograph */
  {"\x50", 0, 0x9ABA}, /* East Asian ideograph */
  {"\x54", 0, 0x9ABD}, /* East Asian ideograph */
  {"\x57", 0, 0x9AC1}, /* East Asian ideograph */
  {"\x59", 0, 0x9AC0}, /* East Asian ideograph */
  {"\x5A", 0, 0x9AC2}, /* East Asian ideograph */
  {"\x5D", 0, 0x9AC8}, /* East Asian ideograph */
  {"\x66", 0, 0x9AD0}, /* East Asian ideograph */
  {"\x6A", 0, 0x9AD1}, /* East Asian ideograph */
  {"\x6D", 0, 0x9AD6}, /* East Asian ideograph */
  {"\x72", 0, 0x9ADC}, /* East Asian ideograph */
  {"\x74", 0, 0x9ADF}, /* East Asian ideograph */
  {"\x76", 0, 0x9AE0}, /* East Asian ideograph */
  {"\x77", 0, 0x9AE2}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page227 = {
  marc8_31page227_flat, 0
};
/* PAGE 226 */
struct yaz_iconv_trie_flat marc8_31page226_flat[] = {
  {"\x24", 0, 0x9A02}, /* East Asian ideograph */
  {"\x29", 0, 0x99F8}, /* East Asian ideograph */
  {"\x2A", 0, 0x99F4}, /* East Asian ideograph */
  {"\x30", 0, 0x99FB}, /* East Asian ideograph */
  {"\x31", 0, 0x99FD}, /* East Asian ideograph */
  {"\x3D", 0, 0x9A0F}, /* East Asian ideograph */
  {"\x3E", 0, 0x9A0B}, /* East Asian ideograph */
  {"\x3F", 0, 0x9A09}, /* East Asian ideograph */
  {"\x44", 0, 0x9A04}, /* East Asian ideograph */
  {"\x45", 0, 0x9A11}, /* East Asian ideograph */
  {"\x47", 0, 0x9A05}, /* East Asian ideograph */
  {"\x48", 0, 0x9A10}, /* East Asian ideograph */
  {"\x4C", 0, 0x9A24}, /* East Asian ideograph */
  {"\x4D", 0, 0x9A22}, /* East Asian ideograph */
  {"\x4F", 0, 0x9A20}, /* East Asian ideograph */
  {"\x52", 0, 0x9A27}, /* East Asian ideograph */
  {"\x59", 0, 0x9A2F}, /* East Asian ideograph */
  {"\x5A", 0, 0x9A38}, /* East Asian ideograph */
  {"\x60", 0, 0x9A2D}, /* East Asian ideograph */
  {"\x61", 0, 0x9A35}, /* East Asian ideograph */
  {"\x64", 0, 0x9A32}, /* East Asian ideograph */
  {"\x69", 0, 0x9A36}, /* East Asian ideograph */
  {"\x6A", 0, 0x9A2E}, /* East Asian ideograph */
  {"\x70", 0, 0x9A41}, /* East Asian ideograph */
  {"\x74", 0, 0x9A3B}, /* East Asian ideograph */
  {"\x79", 0, 0x9A42}, /* East Asian ideograph */
  {"\x7A", 0, 0x9A44}, /* East Asian ideograph */
  {"\x7D", 0, 0x9A48}, /* East Asian ideograph */
  {"\x7E", 0, 0x9A4C}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page226 = {
  marc8_31page226_flat, 0
};
/* PAGE 225 */
struct yaz_iconv_trie_flat marc8_31page225_flat[] = {
  {"\x22", 0, 0x9957}, /* East Asian ideograph (variant of EACC 475222) */
  {"\x29", 0, 0x995D}, /* East Asian ideograph */
  {"\x2B", 0, 0x995F}, /* East Asian ideograph */
  {"\x2F", 0, 0x9997}, /* East Asian ideograph */
  {"\x30", 0, 0x9998}, /* East Asian ideograph */
  {"\x3B", 0, 0x99A3}, /* East Asian ideograph */
  {"\x3C", 0, 0x99A1}, /* East Asian ideograph */
  {"\x3E", 0, 0x99A6}, /* East Asian ideograph */
  {"\x41", 0, 0x99A9}, /* East Asian ideograph */
  {"\x42", 0, 0x99AA}, /* East Asian ideograph */
  {"\x49", 0, 0x99B5}, /* East Asian ideograph */
  {"\x4D", 0, 0x99BF}, /* East Asian ideograph */
  {"\x4E", 0, 0x99BC}, /* East Asian ideograph */
  {"\x4F", 0, 0x99C3}, /* East Asian ideograph */
  {"\x53", 0, 0x99B9}, /* East Asian ideograph */
  {"\x54", 0, 0x99BD}, /* East Asian ideograph */
  {"\x61", 0, 0x99D3}, /* East Asian ideograph */
  {"\x63", 0, 0x99D4}, /* East Asian ideograph */
  {"\x65", 0, 0x99C9}, /* East Asian ideograph */
  {"\x69", 0, 0x99D8}, /* East Asian ideograph */
  {"\x74", 0, 0x99EC}, /* East Asian ideograph */
  {"\x7A", 0, 0x99F0}, /* East Asian ideograph */
  {"\x7B", 0, 0x99E3}, /* East Asian ideograph */
  {"\x7C", 0, 0x99EA}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page225 = {
  marc8_31page225_flat, 0
};
/* PAGE 224 */
struct yaz_iconv_trie_flat marc8_31page224_flat[] = {
  {"\x24", 0, 0x9907}, /* East Asian ideograph */
  {"\x28", 0, 0x9902}, /* East Asian ideograph */
  {"\x2F", 0, 0x9916}, /* East Asian ideograph */
  {"\x30", 0, 0x9914}, /* East Asian ideograph */
  {"\x31", 0, 0x9917}, /* East Asian ideograph */
  {"\x32", 0, 0x9911}, /* East Asian ideograph */
  {"\x38", 0, 0x9915}, /* East Asian ideograph */
  {"\x3A", 0, 0x9924}, /* East Asian ideograph */
  {"\x3B", 0, 0x991F}, /* East Asian ideograph */
  {"\x40", 0, 0x991C}, /* East Asian ideograph */
  {"\x43", 0, 0x9929}, /* East Asian ideograph */
  {"\x45", 0, 0x9927}, /* East Asian ideograph */
  {"\x47", 0, 0x991A}, /* East Asian ideograph */
  {"\x4F", 0, 0x992E}, /* East Asian ideograph */
  {"\x50", 0, 0x992C}, /* East Asian ideograph */
  {"\x51", 0, 0x992A}, /* East Asian ideograph */
  {"\x53", 0, 0x9933}, /* East Asian ideograph */
  {"\x54", 0, 0x9942}, /* East Asian ideograph (variant of EACC 4D5154) */
  {"\x55", 0, 0x9932}, /* East Asian ideograph */
  {"\x56", 0, 0x992B}, /* East Asian ideograph */
  {"\x58", 0, 0x9931}, /* East Asian ideograph */
  {"\x5C", 0, 0x993B}, /* East Asian ideograph */
  {"\x60", 0, 0x993A}, /* East Asian ideograph */
  {"\x61", 0, 0x9941}, /* East Asian ideograph */
  {"\x64", 0, 0x9940}, /* East Asian ideograph */
  {"\x66", 0, 0x993C}, /* East Asian ideograph */
  {"\x6A", 0, 0x9948}, /* East Asian ideograph */
  {"\x6C", 0, 0x9947}, /* East Asian ideograph */
  {"\x6D", 0, 0x9949}, /* East Asian ideograph */
  {"\x70", 0, 0x9943}, /* East Asian ideograph */
  {"\x71", 0, 0x994D}, /* East Asian ideograph */
  {"\x72", 0, 0x994C}, /* East Asian ideograph */
  {"\x73", 0, 0x994E}, /* East Asian ideograph */
  {"\x74", 0, 0x9950}, /* East Asian ideograph */
  {"\x7A", 0, 0x9958}, /* East Asian ideograph */
  {"\x7B", 0, 0x9954}, /* East Asian ideograph */
  {"\x7E", 0, 0x9955}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page224 = {
  marc8_31page224_flat, 0
};
/* PAGE 223 */
struct yaz_iconv_trie_flat marc8_31page223_flat[] = {
  {"\x21", 0, 0x9865}, /* East Asian ideograph */
  {"\x22", 0, 0x9866}, /* East Asian ideograph */
  {"\x29", 0, 0x986C}, /* East Asian ideograph */
  {"\x30", 0, 0x9873}, /* East Asian ideograph */
  {"\x31", 0, 0x9874}, /* East Asian ideograph */
  {"\x39", 0, 0x98AD}, /* East Asian ideograph */
  {"\x40", 0, 0x98B4}, /* East Asian ideograph */
  {"\x48", 0, 0x98B8}, /* East Asian ideograph */
  {"\x4A", 0, 0x98BF}, /* East Asian ideograph */
  {"\x4D", 0, 0x98BB}, /* East Asian ideograph */
  {"\x4E", 0, 0x98C0}, /* East Asian ideograph */
  {"\x53", 0, 0x98C6}, /* East Asian ideograph */
  {"\x5F", 0, 0x98E1}, /* East Asian ideograph */
  {"\x60", 0, 0x98E3}, /* East Asian ideograph */
  {"\x61", 0, 0x98E4}, /* East Asian ideograph */
  {"\x63", 0, 0x98E5}, /* East Asian ideograph */
  {"\x68", 0, 0x98F1}, /* East Asian ideograph */
  {"\x6C", 0, 0x98EB}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page223 = {
  marc8_31page223_flat, 0
};
/* PAGE 222 */
struct yaz_iconv_trie_flat marc8_31page222_flat[] = {
  {"\x23", 0, 0x980E}, /* East Asian ideograph */
  {"\x26", 0, 0x9816}, /* East Asian ideograph */
  {"\x2C", 0, 0x9826}, /* East Asian ideograph */
  {"\x2D", 0, 0x981E}, /* East Asian ideograph */
  {"\x34", 0, 0x982B}, /* East Asian ideograph */
  {"\x37", 0, 0x9820}, /* East Asian ideograph */
  {"\x38", 0, 0x981F}, /* East Asian ideograph */
  {"\x3D", 0, 0x9833}, /* East Asian ideograph */
  {"\x40", 0, 0x982E}, /* East Asian ideograph */
  {"\x44", 0, 0x982F}, /* East Asian ideograph */
  {"\x45", 0, 0x9832}, /* East Asian ideograph */
  {"\x4B", 0, 0x9847}, /* East Asian ideograph */
  {"\x4E", 0, 0x9844}, /* East Asian ideograph */
  {"\x60", 0, 0x9852}, /* East Asian ideograph */
  {"\x62", 0, 0x984B}, /* East Asian ideograph */
  {"\x66", 0, 0x983F}, /* East Asian ideograph */
  {"\x6A", 0, 0x985C}, /* East Asian ideograph */
  {"\x6B", 0, 0x9859}, /* East Asian ideograph */
  {"\x6F", 0, 0x9857}, /* East Asian ideograph */
  {"\x72", 0, 0x9856}, /* East Asian ideograph */
  {"\x77", 0, 0x9862}, /* East Asian ideograph */
  {"\x7E", 0, 0x9868}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page222 = {
  marc8_31page222_flat, 0
};
/* PAGE 221 */
struct yaz_iconv_trie_flat marc8_31page221_flat[] = {
  {"\x24", 0, 0x97B3}, /* East Asian ideograph */
  {"\x26", 0, 0x97B5}, /* East Asian ideograph */
  {"\x29", 0, 0x97B9}, /* East Asian ideograph */
  {"\x2D", 0, 0x97B8}, /* East Asian ideograph */
  {"\x35", 0, 0x97BE}, /* East Asian ideograph */
  {"\x38", 0, 0x97C0}, /* East Asian ideograph */
  {"\x3B", 0, 0x97C5}, /* East Asian ideograph */
  {"\x43", 0, 0x97C9}, /* East Asian ideograph */
  {"\x4B", 0, 0x97CE}, /* East Asian ideograph */
  {"\x4C", 0, 0x97CD}, /* East Asian ideograph */
  {"\x4E", 0, 0x97D0}, /* East Asian ideograph */
  {"\x51", 0, 0x97D4}, /* East Asian ideograph */
  {"\x53", 0, 0x97D8}, /* East Asian ideograph */
  {"\x54", 0, 0x97D9}, /* East Asian ideograph */
  {"\x59", 0, 0x97DD}, /* East Asian ideograph */
  {"\x5C", 0, 0x97DE}, /* East Asian ideograph */
  {"\x5E", 0, 0x97E0}, /* East Asian ideograph */
  {"\x60", 0, 0x97E1}, /* East Asian ideograph */
  {"\x6C", 0, 0x97F5}, /* East Asian ideograph */
  {"\x73", 0, 0x97FA}, /* East Asian ideograph */
  {"\x79", 0, 0x9807}, /* East Asian ideograph */
  {"\x7B", 0, 0x980F}, /* East Asian ideograph */
  {"\x7E", 0, 0x980D}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page221 = {
  marc8_31page221_flat, 0
};
/* PAGE 220 */
struct yaz_iconv_trie_flat marc8_31page220_flat[] = {
  {"\x25", 0, 0x9767}, /* East Asian ideograph */
  {"\x2C", 0, 0x976B}, /* East Asian ideograph */
  {"\x30", 0, 0x976E}, /* East Asian ideograph */
  {"\x31", 0, 0x9777}, /* East Asian ideograph */
  {"\x32", 0, 0x9778}, /* East Asian ideograph */
  {"\x35", 0, 0x9773}, /* East Asian ideograph */
  {"\x37", 0, 0x9783}, /* East Asian ideograph */
  {"\x38", 0, 0x977A}, /* East Asian ideograph */
  {"\x3A", 0, 0x9780}, /* East Asian ideograph */
  {"\x3C", 0, 0x9781}, /* East Asian ideograph */
  {"\x40", 0, 0x9784}, /* East Asian ideograph */
  {"\x43", 0, 0x977F}, /* East Asian ideograph */
  {"\x49", 0, 0x9789}, /* East Asian ideograph */
  {"\x54", 0, 0x9794}, /* East Asian ideograph */
  {"\x59", 0, 0x979B}, /* East Asian ideograph */
  {"\x5A", 0, 0x979F}, /* East Asian ideograph */
  {"\x5C", 0, 0x979A}, /* East Asian ideograph */
  {"\x62", 0, 0x979C}, /* East Asian ideograph */
  {"\x6A", 0, 0x97AC}, /* East Asian ideograph */
  {"\x70", 0, 0x97AE}, /* East Asian ideograph */
  {"\x71", 0, 0x97A8}, /* East Asian ideograph */
  {"\x74", 0, 0x97AB}, /* East Asian ideograph */
  {"\x78", 0, 0x97A5}, /* East Asian ideograph */
  {"\x7A", 0, 0x97B2}, /* East Asian ideograph */
  {"\x7C", 0, 0x97B4}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page220 = {
  marc8_31page220_flat, 0
};
/* PAGE 219 */
struct yaz_iconv_trie_flat marc8_31page219_flat[] = {
  {"\x22", 0, 0x96FF}, /* East Asian ideograph */
  {"\x27", 0, 0x9702}, /* East Asian ideograph */
  {"\x29", 0, 0x9708}, /* East Asian ideograph */
  {"\x2A", 0, 0x9705}, /* East Asian ideograph */
  {"\x38", 0, 0x971B}, /* East Asian ideograph */
  {"\x3D", 0, 0x971D}, /* East Asian ideograph */
  {"\x3E", 0, 0x9719}, /* East Asian ideograph */
  {"\x47", 0, 0x9723}, /* East Asian ideograph */
  {"\x49", 0, 0x9722}, /* East Asian ideograph */
  {"\x4A", 0, 0x9724}, /* East Asian ideograph */
  {"\x4E", 0, 0x9728}, /* East Asian ideograph */
  {"\x50", 0, 0x9726}, /* East Asian ideograph */
  {"\x52", 0, 0x9731}, /* East Asian ideograph */
  {"\x58", 0, 0x9730}, /* East Asian ideograph */
  {"\x5C", 0, 0x9736}, /* East Asian ideograph */
  {"\x6A", 0, 0x9741}, /* East Asian ideograph */
  {"\x6B", 0, 0x9747}, /* East Asian ideograph */
  {"\x6C", 0, 0x9746}, /* East Asian ideograph */
  {"\x6E", 0, 0x9749}, /* East Asian ideograph */
  {"\x75", 0, 0x9758}, /* East Asian ideograph */
  {"\x76", 0, 0x975A}, /* East Asian ideograph */
  {"\x78", 0, 0x975D}, /* East Asian ideograph */
  {"\x7B", 0, 0x975F}, /* East Asian ideograph */
  {"\x7D", 0, 0x9764}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page219 = {
  marc8_31page219_flat, 0
};
/* PAGE 218 */
struct yaz_iconv_trie_flat marc8_31page218_flat[] = {
  {"\x2F", 0, 0x96A4}, /* East Asian ideograph */
  {"\x35", 0, 0x96A9}, /* East Asian ideograph */
  {"\x37", 0, 0x96AE}, /* East Asian ideograph */
  {"\x3B", 0, 0x96B0}, /* East Asian ideograph */
  {"\x3C", 0, 0x96B2}, /* East Asian ideograph */
  {"\x3E", 0, 0x96B3}, /* East Asian ideograph */
  {"\x48", 0, 0x96B9}, /* East Asian ideograph */
  {"\x49", 0, 0x96BC}, /* East Asian ideograph */
  {"\x52", 0, 0x96CE}, /* East Asian ideograph */
  {"\x53", 0, 0x96CA}, /* East Asian ideograph */
  {"\x57", 0, 0x96D2}, /* East Asian ideograph */
  {"\x64", 0, 0x96DF}, /* East Asian ideograph */
  {"\x66", 0, 0x96D8}, /* East Asian ideograph */
  {"\x67", 0, 0x96DD}, /* East Asian ideograph */
  {"\x71", 0, 0x96E9}, /* East Asian ideograph */
  {"\x74", 0, 0x96F1}, /* East Asian ideograph */
  {"\x76", 0, 0x96F0}, /* East Asian ideograph */
  {"\x77", 0, 0x96F4}, /* East Asian ideograph */
  {"\x78", 0, 0x96FA}, /* East Asian ideograph */
  {"\x7A", 0, 0x96F5}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page218 = {
  marc8_31page218_flat, 0
};
/* PAGE 217 */
struct yaz_iconv_trie_flat marc8_31page217_flat[] = {
  {"\x21", 0, 0x9627}, /* East Asian ideograph */
  {"\x2F", 0, 0x9642}, /* East Asian ideograph */
  {"\x30", 0, 0x963D}, /* East Asian ideograph */
  {"\x32", 0, 0x963C}, /* East Asian ideograph */
  {"\x3C", 0, 0x9651}, /* East Asian ideograph */
  {"\x42", 0, 0x9660}, /* East Asian ideograph */
  {"\x44", 0, 0x965C}, /* East Asian ideograph */
  {"\x46", 0, 0x9658}, /* East Asian ideograph */
  {"\x4A", 0, 0x965F}, /* East Asian ideograph */
  {"\x4B", 0, 0x9656}, /* East Asian ideograph */
  {"\x51", 0, 0x966C}, /* East Asian ideograph */
  {"\x5D", 0, 0x967B}, /* East Asian ideograph */
  {"\x5E", 0, 0x967F}, /* East Asian ideograph */
  {"\x62", 0, 0x967E}, /* East Asian ideograph */
  {"\x63", 0, 0x9684}, /* East Asian ideograph */
  {"\x65", 0, 0x9688}, /* East Asian ideograph */
  {"\x6C", 0, 0x9689}, /* East Asian ideograph */
  {"\x6D", 0, 0x9682}, /* East Asian ideograph */
  {"\x6E", 0, 0x9683}, /* East Asian ideograph */
  {"\x79", 0, 0x9696}, /* East Asian ideograph */
  {"\x7A", 0, 0x9697}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page217 = {
  marc8_31page217_flat, 0
};
/* PAGE 216 */
struct yaz_iconv_trie_flat marc8_31page216_flat[] = {
  {"\x2E", 0, 0x9585}, /* East Asian ideograph */
  {"\x30", 0, 0x9588}, /* East Asian ideograph */
  {"\x31", 0, 0x958C}, /* East Asian ideograph */
  {"\x34", 0, 0x9597}, /* East Asian ideograph */
  {"\x36", 0, 0x958E}, /* East Asian ideograph */
  {"\x38", 0, 0x959F}, /* East Asian ideograph */
  {"\x3A", 0, 0x95A0}, /* East Asian ideograph */
  {"\x42", 0, 0x95AC}, /* East Asian ideograph */
  {"\x44", 0, 0x95AB}, /* East Asian ideograph */
  {"\x48", 0, 0x95BC}, /* East Asian ideograph */
  {"\x49", 0, 0x95BE}, /* East Asian ideograph */
  {"\x4A", 0, 0x95CD}, /* East Asian ideograph */
  {"\x4D", 0, 0x95B9}, /* East Asian ideograph */
  {"\x4E", 0, 0x95BA}, /* East Asian ideograph */
  {"\x4F", 0, 0x95B6}, /* East Asian ideograph */
  {"\x50", 0, 0x95BF}, /* East Asian ideograph */
  {"\x52", 0, 0x95BD}, /* East Asian ideograph */
  {"\x59", 0, 0x95C9}, /* East Asian ideograph */
  {"\x5D", 0, 0x95CE}, /* East Asian ideograph */
  {"\x60", 0, 0x95D5}, /* East Asian ideograph */
  {"\x62", 0, 0x95D2}, /* East Asian ideograph */
  {"\x63", 0, 0x95D3}, /* East Asian ideograph */
  {"\x64", 0, 0x95D1}, /* East Asian ideograph */
  {"\x65", 0, 0x95C3}, /* East Asian ideograph */
  {"\x66", 0, 0x95DA}, /* East Asian ideograph */
  {"\x69", 0, 0x95DE}, /* East Asian ideograph */
  {"\x6A", 0, 0x95E0}, /* East Asian ideograph */
  {"\x6F", 0, 0x95E5}, /* East Asian ideograph */
  {"\x72", 0, 0x95E4}, /* East Asian ideograph */
  {"\x76", 0, 0x95E7}, /* East Asian ideograph */
  {"\x7A", 0, 0x961E}, /* East Asian ideograph */
  {"\x7B", 0, 0x9624}, /* East Asian ideograph */
  {"\x7C", 0, 0x9622}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page216 = {
  marc8_31page216_flat, 0
};
/* PAGE 215 */
struct yaz_iconv_trie_flat marc8_31page215_flat[] = {
  {"\x27", 0, 0x93F4}, /* East Asian ideograph */
  {"\x28", 0, 0x9436}, /* East Asian ideograph */
  {"\x2B", 0, 0x943B}, /* East Asian ideograph */
  {"\x2D", 0, 0x9424}, /* East Asian ideograph */
  {"\x30", 0, 0x9437}, /* East Asian ideograph */
  {"\x32", 0, 0x9440}, /* East Asian ideograph */
  {"\x35", 0, 0x942B}, /* East Asian ideograph */
  {"\x36", 0, 0x942D}, /* East Asian ideograph */
  {"\x37", 0, 0x9441}, /* East Asian ideograph */
  {"\x38", 0, 0x9431}, /* East Asian ideograph */
  {"\x3D", 0, 0x9467}, /* East Asian ideograph */
  {"\x3E", 0, 0x944C}, /* East Asian ideograph */
  {"\x40", 0, 0x9445}, /* East Asian ideograph */
  {"\x42", 0, 0x9450}, /* East Asian ideograph */
  {"\x4A", 0, 0x944A}, /* East Asian ideograph */
  {"\x53", 0, 0x9466}, /* East Asian ideograph */
  {"\x57", 0, 0x9464}, /* East Asian ideograph */
  {"\x58", 0, 0x9462}, /* East Asian ideograph */
  {"\x5C", 0, 0x9465}, /* East Asian ideograph */
  {"\x5D", 0, 0x9455}, /* East Asian ideograph */
  {"\x5E", 0, 0x945E}, /* East Asian ideograph */
  {"\x62", 0, 0x946A}, /* East Asian ideograph */
  {"\x68", 0, 0x946B}, /* East Asian ideograph */
  {"\x69", 0, 0x946D}, /* East Asian ideograph */
  {"\x6C", 0, 0x946F}, /* East Asian ideograph */
  {"\x6D", 0, 0x9471}, /* East Asian ideograph */
  {"\x71", 0, 0x9477}, /* East Asian ideograph */
  {"\x7B", 0, 0x9482}, /* East Asian ideograph */
  {"\x7C", 0, 0x9481}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page215 = {
  marc8_31page215_flat, 0
};
/* PAGE 214 */
struct yaz_iconv_trie_flat marc8_31page214_flat[] = {
  {"\x2C", 0, 0x93D3}, /* East Asian ideograph */
  {"\x2F", 0, 0x93A9}, /* East Asian ideograph */
  {"\x30", 0, 0x93E6}, /* East Asian ideograph */
  {"\x32", 0, 0x940B}, /* East Asian ideograph */
  {"\x34", 0, 0x9413}, /* East Asian ideograph */
  {"\x3B", 0, 0x940F}, /* East Asian ideograph */
  {"\x3C", 0, 0x9420}, /* East Asian ideograph */
  {"\x3D", 0, 0x93FB}, /* East Asian ideograph */
  {"\x49", 0, 0x93FA}, /* East Asian ideograph */
  {"\x4D", 0, 0x9419}, /* East Asian ideograph */
  {"\x4E", 0, 0x940D}, /* East Asian ideograph */
  {"\x50", 0, 0x9426}, /* East Asian ideograph */
  {"\x51", 0, 0x9427}, /* East Asian ideograph */
  {"\x55", 0, 0x9409}, /* East Asian ideograph */
  {"\x58", 0, 0x9414}, /* East Asian ideograph */
  {"\x59", 0, 0x9404}, /* East Asian ideograph */
  {"\x5C", 0, 0x9422}, /* East Asian ideograph */
  {"\x5D", 0, 0x9406}, /* East Asian ideograph */
  {"\x60", 0, 0x9410}, /* East Asian ideograph */
  {"\x62", 0, 0x9423}, /* East Asian ideograph */
  {"\x67", 0, 0x93F5}, /* East Asian ideograph */
  {"\x69", 0, 0x93F7}, /* East Asian ideograph */
  {"\x6A", 0, 0x9407}, /* East Asian ideograph */
  {"\x6F", 0, 0x940E}, /* East Asian ideograph */
  {"\x71", 0, 0x9411}, /* East Asian ideograph */
  {"\x74", 0, 0x943F}, /* East Asian ideograph */
  {"\x79", 0, 0x9429}, /* East Asian ideograph */
  {"\x7C", 0, 0x943D}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page214 = {
  marc8_31page214_flat, 0
};
/* PAGE 213 */
struct yaz_iconv_trie_flat marc8_31page213_flat[] = {
  {"\x21", 0, 0x93B5}, /* East Asian ideograph */
  {"\x22", 0, 0x938C}, /* East Asian ideograph */
  {"\x23", 0, 0x9388}, /* East Asian ideograph */
  {"\x25", 0, 0x93B9}, /* East Asian ideograph */
  {"\x27", 0, 0x93A1}, /* East Asian ideograph */
  {"\x28", 0, 0x93B0}, /* East Asian ideograph */
  {"\x29", 0, 0x93A3}, /* East Asian ideograph */
  {"\x2A", 0, 0x93B7}, /* East Asian ideograph */
  {"\x2B", 0, 0x939B}, /* East Asian ideograph */
  {"\x2D", 0, 0x9398}, /* East Asian ideograph */
  {"\x3C", 0, 0x9389}, /* East Asian ideograph */
  {"\x3D", 0, 0x93A4}, /* East Asian ideograph */
  {"\x40", 0, 0x93BC}, /* East Asian ideograph */
  {"\x42", 0, 0x93A7}, /* East Asian ideograph */
  {"\x44", 0, 0x93BD}, /* East Asian ideograph */
  {"\x47", 0, 0x93A6}, /* East Asian ideograph */
  {"\x48", 0, 0x939A}, /* East Asian ideograph */
  {"\x4A", 0, 0x93AA}, /* East Asian ideograph */
  {"\x4D", 0, 0x939E}, /* East Asian ideograph */
  {"\x4F", 0, 0x9397}, /* East Asian ideograph */
  {"\x51", 0, 0x93BB}, /* East Asian ideograph */
  {"\x53", 0, 0x93F1}, /* East Asian ideograph */
  {"\x56", 0, 0x93DE}, /* East Asian ideograph */
  {"\x57", 0, 0x93EE}, /* East Asian ideograph */
  {"\x5A", 0, 0x93C7}, /* East Asian ideograph */
  {"\x5B", 0, 0x93F2}, /* East Asian ideograph */
  {"\x5D", 0, 0x93D4}, /* East Asian ideograph */
  {"\x5F", 0, 0x93E5}, /* East Asian ideograph */
  {"\x62", 0, 0x93F9}, /* East Asian ideograph */
  {"\x63", 0, 0x93CA}, /* East Asian ideograph */
  {"\x64", 0, 0x93C4}, /* East Asian ideograph */
  {"\x66", 0, 0x93E8}, /* East Asian ideograph */
  {"\x67", 0, 0x93E7}, /* East Asian ideograph */
  {"\x72", 0, 0x93DA}, /* East Asian ideograph */
  {"\x73", 0, 0x93D0}, /* East Asian ideograph */
  {"\x74", 0, 0x93EF}, /* East Asian ideograph */
  {"\x75", 0, 0x93DB}, /* East Asian ideograph */
  {"\x7C", 0, 0x93CC}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page213 = {
  marc8_31page213_flat, 0
};
/* PAGE 212 */
struct yaz_iconv_trie_flat marc8_31page212_flat[] = {
  {"\x22", 0, 0x9314}, /* East Asian ideograph */
  {"\x28", 0, 0x92FE}, /* East Asian ideograph */
  {"\x2F", 0, 0x9342}, /* East Asian ideograph */
  {"\x31", 0, 0x9341}, /* East Asian ideograph */
  {"\x32", 0, 0x9319}, /* East Asian ideograph */
  {"\x35", 0, 0x934C}, /* East Asian ideograph */
  {"\x41", 0, 0x9379}, /* East Asian ideograph */
  {"\x44", 0, 0x9386}, /* East Asian ideograph */
  {"\x47", 0, 0x936A}, /* East Asian ideograph */
  {"\x48", 0, 0x935C}, /* East Asian ideograph */
  {"\x4C", 0, 0x934F}, /* East Asian ideograph */
  {"\x4D", 0, 0x9347}, /* East Asian ideograph */
  {"\x51", 0, 0x937A}, /* East Asian ideograph */
  {"\x53", 0, 0x9356}, /* East Asian ideograph */
  {"\x54", 0, 0x9371}, /* East Asian ideograph */
  {"\x56", 0, 0x937C}, /* East Asian ideograph */
  {"\x5C", 0, 0x9377}, /* East Asian ideograph */
  {"\x5D", 0, 0x9349}, /* East Asian ideograph */
  {"\x5E", 0, 0x9358}, /* East Asian ideograph */
  {"\x5F", 0, 0x935A}, /* East Asian ideograph */
  {"\x60", 0, 0x93BE}, /* East Asian ideograph */
  {"\x62", 0, 0x935F}, /* East Asian ideograph */
  {"\x64", 0, 0x9376}, /* East Asian ideograph */
  {"\x66", 0, 0x9355}, /* East Asian ideograph */
  {"\x67", 0, 0x9354}, /* East Asian ideograph */
  {"\x6A", 0, 0x9348}, /* East Asian ideograph */
  {"\x6B", 0, 0x9374}, /* East Asian ideograph */
  {"\x6E", 0, 0x9351}, /* East Asian ideograph */
  {"\x6F", 0, 0x9364}, /* East Asian ideograph */
  {"\x71", 0, 0x936B}, /* East Asian ideograph */
  {"\x72", 0, 0x936D}, /* East Asian ideograph */
  {"\x73", 0, 0x9360}, /* East Asian ideograph */
  {"\x77", 0, 0x936E}, /* East Asian ideograph */
  {"\x79", 0, 0x938F}, /* East Asian ideograph */
  {"\x7A", 0, 0x93AC}, /* East Asian ideograph */
  {"\x7B", 0, 0x9395}, /* East Asian ideograph */
  {"\x7E", 0, 0x938B}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page212 = {
  marc8_31page212_flat, 0
};
/* PAGE 211 */
struct yaz_iconv_trie_flat marc8_31page211_flat[] = {
  {"\x21", 0, 0x92C6}, /* East Asian ideograph */
  {"\x25", 0, 0x92F4}, /* East Asian ideograph */
  {"\x27", 0, 0x92CF}, /* East Asian ideograph */
  {"\x2A", 0, 0x92B2}, /* East Asian ideograph */
  {"\x2C", 0, 0x92E7}, /* East Asian ideograph */
  {"\x2D", 0, 0x92C7}, /* East Asian ideograph */
  {"\x2E", 0, 0x92F0}, /* East Asian ideograph */
  {"\x2F", 0, 0x92DB}, /* East Asian ideograph */
  {"\x30", 0, 0x92DC}, /* East Asian ideograph */
  {"\x31", 0, 0x92D8}, /* East Asian ideograph */
  {"\x33", 0, 0x92E9}, /* East Asian ideograph */
  {"\x35", 0, 0x92DD}, /* East Asian ideograph */
  {"\x39", 0, 0x92D1}, /* East Asian ideograph */
  {"\x3A", 0, 0x92CA}, /* East Asian ideograph */
  {"\x3C", 0, 0x92C2}, /* East Asian ideograph */
  {"\x3E", 0, 0x92CC}, /* East Asian ideograph */
  {"\x40", 0, 0x92EF}, /* East Asian ideograph */
  {"\x41", 0, 0x92E8}, /* East Asian ideograph */
  {"\x43", 0, 0x92EB}, /* East Asian ideograph */
  {"\x45", 0, 0x92F5}, /* East Asian ideograph */
  {"\x48", 0, 0x92F2}, /* East Asian ideograph */
  {"\x4C", 0, 0x9303}, /* East Asian ideograph */
  {"\x4D", 0, 0x9307}, /* East Asian ideograph */
  {"\x4E", 0, 0x931E}, /* East Asian ideograph */
  {"\x4F", 0, 0x9344}, /* East Asian ideograph */
  {"\x53", 0, 0x931D}, /* East Asian ideograph */
  {"\x54", 0, 0x92FA}, /* East Asian ideograph */
  {"\x58", 0, 0x931F}, /* East Asian ideograph */
  {"\x5A", 0, 0x9331}, /* East Asian ideograph */
  {"\x5B", 0, 0x9306}, /* East Asian ideograph */
  {"\x5D", 0, 0x92F9}, /* East Asian ideograph */
  {"\x5F", 0, 0x930F}, /* East Asian ideograph */
  {"\x62", 0, 0x9302}, /* East Asian ideograph */
  {"\x64", 0, 0x9324}, /* East Asian ideograph */
  {"\x66", 0, 0x9312}, /* East Asian ideograph */
  {"\x69", 0, 0x9338}, /* East Asian ideograph */
  {"\x6A", 0, 0x9323}, /* East Asian ideograph */
  {"\x6C", 0, 0x9321}, /* East Asian ideograph */
  {"\x71", 0, 0x9340}, /* East Asian ideograph */
  {"\x72", 0, 0x9301}, /* East Asian ideograph */
  {"\x74", 0, 0x9315}, /* East Asian ideograph */
  {"\x76", 0, 0x9329}, /* East Asian ideograph */
  {"\x78", 0, 0x932E}, /* East Asian ideograph */
  {"\x79", 0, 0x932A}, /* East Asian ideograph */
  {"\x7B", 0, 0x933F}, /* East Asian ideograph */
  {"\x7C", 0, 0x933A}, /* East Asian ideograph */
  {"\x7E", 0, 0x9335}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page211 = {
  marc8_31page211_flat, 0
};
/* PAGE 210 */
struct yaz_iconv_trie_flat marc8_31page210_flat[] = {
  {"\x23", 0, 0x924E}, /* East Asian ideograph */
  {"\x26", 0, 0x924C}, /* East Asian ideograph */
  {"\x27", 0, 0x9256}, /* East Asian ideograph */
  {"\x2B", 0, 0x925A}, /* East Asian ideograph */
  {"\x2E", 0, 0x9241}, /* East Asian ideograph */
  {"\x2F", 0, 0x9283}, /* East Asian ideograph */
  {"\x31", 0, 0x92A5}, /* East Asian ideograph */
  {"\x33", 0, 0x9282}, /* East Asian ideograph */
  {"\x35", 0, 0x92A8}, /* East Asian ideograph */
  {"\x37", 0, 0x927C}, /* East Asian ideograph */
  {"\x38", 0, 0x92A4}, /* East Asian ideograph */
  {"\x3E", 0, 0x9276}, /* East Asian ideograph */
  {"\x3F", 0, 0x928D}, /* East Asian ideograph */
  {"\x40", 0, 0x92EE}, /* East Asian ideograph */
  {"\x42", 0, 0x9288}, /* East Asian ideograph */
  {"\x43", 0, 0x927A}, /* East Asian ideograph */
  {"\x45", 0, 0x928E}, /* East Asian ideograph */
  {"\x46", 0, 0x92A0}, /* East Asian ideograph */
  {"\x47", 0, 0x9277}, /* East Asian ideograph */
  {"\x49", 0, 0x92AA}, /* East Asian ideograph */
  {"\x50", 0, 0x92A6}, /* East Asian ideograph */
  {"\x54", 0, 0x927E}, /* East Asian ideograph */
  {"\x55", 0, 0x929A}, /* East Asian ideograph */
  {"\x58", 0, 0x92AB}, /* East Asian ideograph */
  {"\x5B", 0, 0x9291}, /* East Asian ideograph */
  {"\x5D", 0, 0x929B}, /* East Asian ideograph */
  {"\x62", 0, 0x927F}, /* East Asian ideograph */
  {"\x64", 0, 0x92A3}, /* East Asian ideograph */
  {"\x66", 0, 0x92C8}, /* East Asian ideograph */
  {"\x6A", 0, 0x92C3}, /* East Asian ideograph */
  {"\x6F", 0, 0x92D0}, /* East Asian ideograph */
  {"\x71", 0, 0x92F1}, /* East Asian ideograph */
  {"\x72", 0, 0x92DF}, /* East Asian ideograph */
  {"\x75", 0, 0x92E6}, /* East Asian ideograph */
  {"\x76", 0, 0x92B6}, /* East Asian ideograph */
  {"\x77", 0, 0x92C0}, /* East Asian ideograph */
  {"\x79", 0, 0x92BE}, /* East Asian ideograph */
  {"\x7A", 0, 0x92D9}, /* East Asian ideograph */
  {"\x7E", 0, 0x92D5}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page210 = {
  marc8_31page210_flat, 0
};
/* PAGE 209 */
struct yaz_iconv_trie_flat marc8_31page209_flat[] = {
  {"\x21", 0, 0x91F9}, /* East Asian ideograph */
  {"\x22", 0, 0x91E4}, /* East Asian ideograph */
  {"\x23", 0, 0x9204}, /* East Asian ideograph */
  {"\x25", 0, 0x9201}, /* East Asian ideograph */
  {"\x26", 0, 0x922B}, /* East Asian ideograph */
  {"\x27", 0, 0x920A}, /* East Asian ideograph */
  {"\x28", 0, 0x9225}, /* East Asian ideograph */
  {"\x2A", 0, 0x9292}, /* East Asian ideograph */
  {"\x2C", 0, 0x9228}, /* East Asian ideograph */
  {"\x2E", 0, 0x9207}, /* East Asian ideograph */
  {"\x2F", 0, 0x9203}, /* East Asian ideograph */
  {"\x31", 0, 0x9200}, /* East Asian ideograph */
  {"\x32", 0, 0x9218}, /* East Asian ideograph */
  {"\x33", 0, 0x91FE}, /* East Asian ideograph */
  {"\x36", 0, 0x9208}, /* East Asian ideograph */
  {"\x37", 0, 0x9226}, /* East Asian ideograph */
  {"\x38", 0, 0x921C}, /* East Asian ideograph */
  {"\x3B", 0, 0x9224}, /* East Asian ideograph */
  {"\x43", 0, 0x9212}, /* East Asian ideograph */
  {"\x48", 0, 0x91FF}, /* East Asian ideograph */
  {"\x4A", 0, 0x9216}, /* East Asian ideograph */
  {"\x4B", 0, 0x9211}, /* East Asian ideograph */
  {"\x4E", 0, 0x9206}, /* East Asian ideograph */
  {"\x4F", 0, 0x92A2}, /* East Asian ideograph */
  {"\x51", 0, 0x9230}, /* East Asian ideograph */
  {"\x52", 0, 0x9249}, /* East Asian ideograph */
  {"\x54", 0, 0x924D}, /* East Asian ideograph */
  {"\x55", 0, 0x9248}, /* East Asian ideograph */
  {"\x58", 0, 0x923A}, /* East Asian ideograph */
  {"\x5C", 0, 0x922E}, /* East Asian ideograph */
  {"\x5F", 0, 0x9233}, /* East Asian ideograph */
  {"\x61", 0, 0x9266}, /* East Asian ideograph */
  {"\x64", 0, 0x925E}, /* East Asian ideograph */
  {"\x68", 0, 0x9235}, /* East Asian ideograph */
  {"\x6B", 0, 0x9250}, /* East Asian ideograph */
  {"\x6C", 0, 0x926B}, /* East Asian ideograph */
  {"\x6D", 0, 0x9239}, /* East Asian ideograph */
  {"\x6F", 0, 0x926D}, /* East Asian ideograph */
  {"\x70", 0, 0x926C}, /* East Asian ideograph */
  {"\x71", 0, 0x924F}, /* East Asian ideograph */
  {"\x74", 0, 0x923F}, /* East Asian ideograph */
  {"\x77", 0, 0x9260}, /* East Asian ideograph */
  {"\x7E", 0, 0x9236}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page209 = {
  marc8_31page209_flat, 0
};
/* PAGE 208 */
struct yaz_iconv_trie_flat marc8_31page208_flat[] = {
  {"\x24", 0, 0x918D}, /* East Asian ideograph */
  {"\x25", 0, 0x9193}, /* East Asian ideograph */
  {"\x2B", 0, 0x919D}, /* East Asian ideograph */
  {"\x2C", 0, 0x919A}, /* East Asian ideograph */
  {"\x30", 0, 0x91A2}, /* East Asian ideograph */
  {"\x34", 0, 0x919B}, /* East Asian ideograph (variant of EACC 4D4134) */
  {"\x37", 0, 0x91A8}, /* East Asian ideograph */
  {"\x3D", 0, 0x91AA}, /* East Asian ideograph */
  {"\x41", 0, 0x91AF}, /* East Asian ideograph */
  {"\x42", 0, 0x91B1}, /* East Asian ideograph */
  {"\x47", 0, 0x91AD}, /* East Asian ideograph */
  {"\x48", 0, 0x91AE}, /* East Asian ideograph */
  {"\x4B", 0, 0x91B4}, /* East Asian ideograph */
  {"\x4C", 0, 0x91B2}, /* East Asian ideograph */
  {"\x4D", 0, 0x91B5}, /* East Asian ideograph */
  {"\x56", 0, 0x91BF}, /* East Asian ideograph */
  {"\x57", 0, 0x91BD}, /* East Asian ideograph */
  {"\x5A", 0, 0x91C2}, /* East Asian ideograph */
  {"\x5B", 0, 0x91C4}, /* East Asian ideograph */
  {"\x5C", 0, 0x91C3}, /* East Asian ideograph */
  {"\x61", 0, 0x91D4}, /* East Asian ideograph */
  {"\x62", 0, 0x91D3}, /* East Asian ideograph */
  {"\x63", 0, 0x91D5}, /* East Asian ideograph */
  {"\x64", 0, 0x91D9}, /* East Asian ideograph */
  {"\x68", 0, 0x91E2}, /* East Asian ideograph */
  {"\x69", 0, 0x91ED}, /* East Asian ideograph */
  {"\x6A", 0, 0x91F7}, /* East Asian ideograph */
  {"\x6B", 0, 0x91FA}, /* East Asian ideograph */
  {"\x6F", 0, 0x91F2}, /* East Asian ideograph */
  {"\x71", 0, 0x91E8}, /* East Asian ideograph */
  {"\x72", 0, 0x91F6}, /* East Asian ideograph */
  {"\x73", 0, 0x91EE}, /* East Asian ideograph */
  {"\x74", 0, 0x91F4}, /* East Asian ideograph */
  {"\x77", 0, 0x91F1}, /* East Asian ideograph */
  {"\x79", 0, 0x91E9}, /* East Asian ideograph */
  {"\x7A", 0, 0x91F8}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page208 = {
  marc8_31page208_flat, 0
};
/* PAGE 207 */
struct yaz_iconv_trie_flat marc8_31page207_flat[] = {
  {"\x21", 0, 0x9132}, /* East Asian ideograph */
  {"\x24", 0, 0x9126}, /* East Asian ideograph */
  {"\x2B", 0, 0x9134}, /* East Asian ideograph */
  {"\x2C", 0, 0x9136}, /* East Asian ideograph */
  {"\x31", 0, 0x913A}, /* East Asian ideograph */
  {"\x32", 0, 0x913B}, /* East Asian ideograph */
  {"\x3B", 0, 0x9143}, /* East Asian ideograph */
  {"\x3E", 0, 0x9146}, /* East Asian ideograph */
  {"\x3F", 0, 0x9145}, /* East Asian ideograph */
  {"\x40", 0, 0x9148}, /* East Asian ideograph */
  {"\x41", 0, 0x9147}, /* East Asian ideograph */
  {"\x42", 0, 0x9150}, /* East Asian ideograph */
  {"\x43", 0, 0x914E}, /* East Asian ideograph */
  {"\x48", 0, 0x9159}, /* East Asian ideograph */
  {"\x49", 0, 0x915C}, /* East Asian ideograph */
  {"\x4D", 0, 0x9156}, /* East Asian ideograph */
  {"\x50", 0, 0x9158}, /* East Asian ideograph */
  {"\x52", 0, 0x915A}, /* East Asian ideograph */
  {"\x53", 0, 0x9161}, /* East Asian ideograph */
  {"\x56", 0, 0x9164}, /* East Asian ideograph */
  {"\x61", 0, 0x916F}, /* East Asian ideograph */
  {"\x62", 0, 0x916E}, /* East Asian ideograph */
  {"\x66", 0, 0x917A}, /* East Asian ideograph */
  {"\x68", 0, 0x9172}, /* East Asian ideograph */
  {"\x69", 0, 0x9179}, /* East Asian ideograph */
  {"\x6A", 0, 0x9176}, /* East Asian ideograph */
  {"\x6B", 0, 0x9174}, /* East Asian ideograph */
  {"\x6C", 0, 0x9173}, /* East Asian ideograph */
  {"\x6D", 0, 0x9185}, /* East Asian ideograph */
  {"\x6F", 0, 0x9182}, /* East Asian ideograph */
  {"\x70", 0, 0x918A}, /* East Asian ideograph */
  {"\x71", 0, 0x9186}, /* East Asian ideograph */
  {"\x72", 0, 0x918C}, /* East Asian ideograph */
  {"\x73", 0, 0x9181}, /* East Asian ideograph */
  {"\x7B", 0, 0x9191}, /* East Asian ideograph */
  {"\x7D", 0, 0x9190}, /* East Asian ideograph */
  {"\x7E", 0, 0x918E}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page207 = {
  marc8_31page207_flat, 0
};
/* PAGE 206 */
struct yaz_iconv_trie_flat marc8_31page206_flat[] = {
  {"\x22", 0, 0x90DD}, /* East Asian ideograph */
  {"\x23", 0, 0x90DF}, /* East Asian ideograph */
  {"\x26", 0, 0x90E2}, /* East Asian ideograph */
  {"\x27", 0, 0x90D8}, /* East Asian ideograph */
  {"\x28", 0, 0x90DB}, /* East Asian ideograph */
  {"\x2A", 0, 0x90DC}, /* East Asian ideograph */
  {"\x2C", 0, 0x90D7}, /* East Asian ideograph */
  {"\x2D", 0, 0x90E4}, /* East Asian ideograph */
  {"\x2E", 0, 0x90EF}, /* East Asian ideograph */
  {"\x2F", 0, 0x90EA}, /* East Asian ideograph */
  {"\x32", 0, 0x90F0}, /* East Asian ideograph */
  {"\x33", 0, 0x90F4}, /* East Asian ideograph */
  {"\x34", 0, 0x90F2}, /* East Asian ideograph */
  {"\x3E", 0, 0x90EB}, /* East Asian ideograph */
  {"\x3F", 0, 0x90F3}, /* East Asian ideograph */
  {"\x46", 0, 0x90FC}, /* East Asian ideograph */
  {"\x47", 0, 0x90FE}, /* East Asian ideograph */
  {"\x49", 0, 0x9104}, /* East Asian ideograph */
  {"\x4A", 0, 0x90FF}, /* East Asian ideograph */
  {"\x4C", 0, 0x9106}, /* East Asian ideograph */
  {"\x4E", 0, 0x9100}, /* East Asian ideograph */
  {"\x50", 0, 0x9107}, /* East Asian ideograph */
  {"\x57", 0, 0x910F}, /* East Asian ideograph */
  {"\x58", 0, 0x9111}, /* East Asian ideograph */
  {"\x5A", 0, 0x9116}, /* East Asian ideograph */
  {"\x5C", 0, 0x9114}, /* East Asian ideograph */
  {"\x60", 0, 0x910B}, /* East Asian ideograph */
  {"\x62", 0, 0x9123}, /* East Asian ideograph (Version J extension) */
  {"\x63", 0, 0x9118}, /* East Asian ideograph */
  {"\x64", 0, 0x911C}, /* East Asian ideograph */
  {"\x66", 0, 0x9120}, /* East Asian ideograph */
  {"\x67", 0, 0x9122}, /* East Asian ideograph */
  {"\x6A", 0, 0x911E}, /* East Asian ideograph */
  {"\x71", 0, 0x9124}, /* East Asian ideograph */
  {"\x72", 0, 0x911A}, /* East Asian ideograph */
  {"\x74", 0, 0x9125}, /* East Asian ideograph */
  {"\x77", 0, 0x912F}, /* East Asian ideograph */
  {"\x79", 0, 0x912B}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page206 = {
  marc8_31page206_flat, 0
};
/* PAGE 205 */
struct yaz_iconv_trie_flat marc8_31page205_flat[] = {
  {"\x21", 0, 0x9070}, /* East Asian ideograph */
  {"\x25", 0, 0x906F}, /* East Asian ideograph */
  {"\x26", 0, 0x9079}, /* East Asian ideograph */
  {"\x28", 0, 0x9076}, /* East Asian ideograph */
  {"\x2A", 0, 0x907B}, /* East Asian ideograph */
  {"\x2C", 0, 0x9085}, /* East Asian ideograph */
  {"\x34", 0, 0x9083}, /* East Asian ideograph */
  {"\x37", 0, 0x9088}, /* East Asian ideograph */
  {"\x3A", 0, 0x908B}, /* East Asian ideograph */
  {"\x3F", 0, 0x9099}, /* East Asian ideograph */
  {"\x40", 0, 0x9097}, /* East Asian ideograph */
  {"\x43", 0, 0x909B}, /* East Asian ideograph */
  {"\x44", 0, 0x909C}, /* East Asian ideograph */
  {"\x48", 0, 0x90A1}, /* East Asian ideograph */
  {"\x51", 0, 0x90A8}, /* East Asian ideograph */
  {"\x54", 0, 0x90A0}, /* East Asian ideograph */
  {"\x58", 0, 0x90AF}, /* East Asian ideograph */
  {"\x59", 0, 0x90B3}, /* East Asian ideograph */
  {"\x5B", 0, 0x90B6}, /* East Asian ideograph */
  {"\x5D", 0, 0x90B0}, /* East Asian ideograph */
  {"\x5F", 0, 0x90AD}, /* East Asian ideograph */
  {"\x61", 0, 0x90B2}, /* East Asian ideograph */
  {"\x68", 0, 0x90C9}, /* East Asian ideograph */
  {"\x6A", 0, 0x90BD}, /* East Asian ideograph */
  {"\x6F", 0, 0x90D5}, /* East Asian ideograph */
  {"\x72", 0, 0x90BE}, /* East Asian ideograph */
  {"\x75", 0, 0x90C7}, /* East Asian ideograph */
  {"\x78", 0, 0x90C8}, /* East Asian ideograph */
  {"\x79", 0, 0x90C3}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page205 = {
  marc8_31page205_flat, 0
};
/* PAGE 204 */
struct yaz_iconv_trie_flat marc8_31page204_flat[] = {
  {"\x21", 0, 0x8FDA}, /* East Asian ideograph */
  {"\x22", 0, 0x8FD5}, /* East Asian ideograph */
  {"\x2F", 0, 0x8FE4}, /* East Asian ideograph */
  {"\x30", 0, 0x8FEE}, /* East Asian ideograph */
  {"\x35", 0, 0x8FF9}, /* East Asian ideograph */
  {"\x3C", 0, 0x8FFB}, /* East Asian ideograph */
  {"\x3F", 0, 0x9004}, /* East Asian ideograph */
  {"\x40", 0, 0x9008}, /* East Asian ideograph */
  {"\x44", 0, 0x9011}, /* East Asian ideograph */
  {"\x45", 0, 0x900B}, /* East Asian ideograph */
  {"\x48", 0, 0x900C}, /* East Asian ideograph */
  {"\x49", 0, 0x9021}, /* East Asian ideograph */
  {"\x4A", 0, 0x902D}, /* East Asian ideograph */
  {"\x4E", 0, 0x902C}, /* East Asian ideograph */
  {"\x56", 0, 0x9037}, /* East Asian ideograph */
  {"\x57", 0, 0x9034}, /* East Asian ideograph */
  {"\x58", 0, 0x902F}, /* East Asian ideograph */
  {"\x59", 0, 0x9036}, /* East Asian ideograph */
  {"\x5B", 0, 0x9046}, /* East Asian ideograph */
  {"\x5D", 0, 0x9052}, /* East Asian ideograph */
  {"\x67", 0, 0x9049}, /* East Asian ideograph */
  {"\x6A", 0, 0x9044}, /* East Asian ideograph */
  {"\x74", 0, 0x9062}, /* East Asian ideograph */
  {"\x75", 0, 0x905D}, /* East Asian ideograph */
  {"\x78", 0, 0x905B}, /* East Asian ideograph */
  {"\x7B", 0, 0x906B}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page204 = {
  marc8_31page204_flat, 0
};
/* PAGE 203 */
struct yaz_iconv_trie_flat marc8_31page203_flat[] = {
  {"\x26", 0, 0x8F39}, /* East Asian ideograph */
  {"\x27", 0, 0x8F34}, /* East Asian ideograph */
  {"\x2D", 0, 0x8F40}, /* East Asian ideograph */
  {"\x30", 0, 0x8F46}, /* East Asian ideograph */
  {"\x31", 0, 0x8F4A}, /* East Asian ideograph */
  {"\x33", 0, 0x8F47}, /* East Asian ideograph */
  {"\x3D", 0, 0x8F52}, /* East Asian ideograph */
  {"\x48", 0, 0x8F56}, /* East Asian ideograph */
  {"\x49", 0, 0x8F57}, /* East Asian ideograph */
  {"\x4B", 0, 0x8F55}, /* East Asian ideograph */
  {"\x4C", 0, 0x8F58}, /* East Asian ideograph */
  {"\x4D", 0, 0x8F5C}, /* East Asian ideograph */
  {"\x4E", 0, 0x8F5E}, /* East Asian ideograph */
  {"\x53", 0, 0x8F5D}, /* East Asian ideograph */
  {"\x57", 0, 0x8F62}, /* East Asian ideograph */
  {"\x59", 0, 0x8F63}, /* East Asian ideograph */
  {"\x5A", 0, 0x8F64}, /* East Asian ideograph */
  {"\x65", 0, 0x8FA4}, /* East Asian ideograph */
  {"\x66", 0, 0x8FA5}, /* East Asian ideograph */
  {"\x6C", 0, 0x8FB5}, /* East Asian ideograph */
  {"\x6D", 0, 0x8FB7}, /* East Asian ideograph */
  {"\x6E", 0, 0x8FBB}, /* East Asian ideograph */
  {"\x70", 0, 0x8FBC}, /* East Asian ideograph */
  {"\x74", 0, 0x8FBF}, /* East Asian ideograph */
  {"\x75", 0, 0x8FD2}, /* East Asian ideograph */
  {"\x77", 0, 0x8FCB}, /* East Asian ideograph */
  {"\x7A", 0, 0x8FCA}, /* East Asian ideograph */
  {"\x7B", 0, 0x8FD3}, /* East Asian ideograph */
  {"\x7D", 0, 0x8FCD}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page203 = {
  marc8_31page203_flat, 0
};
/* PAGE 202 */
struct yaz_iconv_trie_flat marc8_31page202_flat[] = {
  {"\x2E", 0, 0x8EC9}, /* East Asian ideograph */
  {"\x2F", 0, 0x8ECF}, /* East Asian ideograph */
  {"\x31", 0, 0x8ECE}, /* East Asian ideograph */
  {"\x33", 0, 0x8ED5}, /* East Asian ideograph */
  {"\x3F", 0, 0x8EFA}, /* East Asian ideograph */
  {"\x42", 0, 0x8EF9}, /* East Asian ideograph */
  {"\x4B", 0, 0x8EE8}, /* East Asian ideograph */
  {"\x4F", 0, 0x8EEB}, /* East Asian ideograph */
  {"\x51", 0, 0x8EFF}, /* East Asian ideograph */
  {"\x56", 0, 0x8F00}, /* East Asian ideograph */
  {"\x59", 0, 0x8F05}, /* East Asian ideograph */
  {"\x5A", 0, 0x8F08}, /* East Asian ideograph */
  {"\x5B", 0, 0x8F07}, /* East Asian ideograph */
  {"\x63", 0, 0x8F27}, /* East Asian ideograph */
  {"\x64", 0, 0x8F2C}, /* East Asian ideograph */
  {"\x6B", 0, 0x8F1E}, /* East Asian ideograph */
  {"\x6D", 0, 0x8F25}, /* East Asian ideograph */
  {"\x6E", 0, 0x8F20}, /* East Asian ideograph */
  {"\x75", 0, 0x8F17}, /* East Asian ideograph */
  {"\x78", 0, 0x8F36}, /* East Asian ideograph */
  {"\x79", 0, 0x8F2E}, /* East Asian ideograph */
  {"\x7A", 0, 0x8F33}, /* East Asian ideograph */
  {"\x7D", 0, 0x8F2D}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page202 = {
  marc8_31page202_flat, 0
};
/* PAGE 201 */
struct yaz_iconv_trie_flat marc8_31page201_flat[] = {
  {"\x21", 0, 0x8E30}, /* East Asian ideograph */
  {"\x24", 0, 0x8E47}, /* East Asian ideograph */
  {"\x26", 0, 0x8E46}, /* East Asian ideograph */
  {"\x2E", 0, 0x8E4C}, /* East Asian ideograph */
  {"\x30", 0, 0x8E50}, /* East Asian ideograph */
  {"\x32", 0, 0x8E4F}, /* East Asian ideograph */
  {"\x34", 0, 0x8E5C}, /* East Asian ideograph */
  {"\x35", 0, 0x8E62}, /* East Asian ideograph */
  {"\x36", 0, 0x8E60}, /* East Asian ideograph */
  {"\x3A", 0, 0x8E54}, /* East Asian ideograph */
  {"\x3B", 0, 0x8E67}, /* East Asian ideograph */
  {"\x3E", 0, 0x8E5A}, /* East Asian ideograph */
  {"\x3F", 0, 0x8E5E}, /* East Asian ideograph */
  {"\x40", 0, 0x8E55}, /* East Asian ideograph */
  {"\x41", 0, 0x8E61}, /* East Asian ideograph */
  {"\x43", 0, 0x8E5D}, /* East Asian ideograph */
  {"\x44", 0, 0x8E75}, /* East Asian ideograph */
  {"\x45", 0, 0x8E74}, /* East Asian ideograph */
  {"\x46", 0, 0x8E95}, /* East Asian ideograph */
  {"\x48", 0, 0x8E6D}, /* East Asian ideograph */
  {"\x4B", 0, 0x8E69}, /* East Asian ideograph */
  {"\x52", 0, 0x8E83}, /* East Asian ideograph */
  {"\x53", 0, 0x8E84}, /* East Asian ideograph */
  {"\x57", 0, 0x8E8B}, /* East Asian ideograph */
  {"\x5D", 0, 0x8E94}, /* East Asian ideograph */
  {"\x5E", 0, 0x8E9A}, /* East Asian ideograph */
  {"\x5F", 0, 0x8E92}, /* East Asian ideograph */
  {"\x60", 0, 0x8E93}, /* East Asian ideograph */
  {"\x62", 0, 0x8E90}, /* East Asian ideograph */
  {"\x63", 0, 0x8E98}, /* East Asian ideograph */
  {"\x64", 0, 0x8E9E}, /* East Asian ideograph */
  {"\x6B", 0, 0x8EA5}, /* East Asian ideograph */
  {"\x6F", 0, 0x8EA7}, /* East Asian ideograph */
  {"\x71", 0, 0x8EA9}, /* East Asian ideograph */
  {"\x72", 0, 0x8E99}, /* East Asian ideograph */
  {"\x78", 0, 0x8EB3}, /* East Asian ideograph */
  {"\x7A", 0, 0x8EBC}, /* East Asian ideograph */
  {"\x7D", 0, 0x8EB6}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page201 = {
  marc8_31page201_flat, 0
};
/* PAGE 200 */
struct yaz_iconv_trie_flat marc8_31page200_flat[] = {
  {"\x21", 0, 0x8DCF}, /* East Asian ideograph */
  {"\x22", 0, 0x8DD6}, /* East Asian ideograph */
  {"\x27", 0, 0x8DD0}, /* East Asian ideograph */
  {"\x2B", 0, 0x8DC5}, /* East Asian ideograph */
  {"\x2F", 0, 0x8DE4}, /* East Asian ideograph */
  {"\x34", 0, 0x8DEC}, /* East Asian ideograph */
  {"\x35", 0, 0x8DEB}, /* East Asian ideograph */
  {"\x36", 0, 0x8DF4}, /* East Asian ideograph */
  {"\x38", 0, 0x8DE9}, /* East Asian ideograph */
  {"\x3A", 0, 0x8DE6}, /* East Asian ideograph */
  {"\x3B", 0, 0x8DE3}, /* East Asian ideograph */
  {"\x3D", 0, 0x8DE7}, /* East Asian ideograph */
  {"\x3E", 0, 0x8DF2}, /* East Asian ideograph */
  {"\x3F", 0, 0x8E09}, /* East Asian ideograph */
  {"\x41", 0, 0x8DFD}, /* East Asian ideograph */
  {"\x44", 0, 0x8DFF}, /* East Asian ideograph */
  {"\x46", 0, 0x8E05}, /* East Asian ideograph */
  {"\x49", 0, 0x8E01}, /* East Asian ideograph */
  {"\x4E", 0, 0x8E04}, /* East Asian ideograph */
  {"\x50", 0, 0x8E06}, /* East Asian ideograph */
  {"\x52", 0, 0x8E2A}, /* East Asian ideograph */
  {"\x54", 0, 0x8E23}, /* East Asian ideograph */
  {"\x57", 0, 0x8E2E}, /* East Asian ideograph */
  {"\x58", 0, 0x8E21}, /* East Asian ideograph */
  {"\x5C", 0, 0x8E1E}, /* East Asian ideograph */
  {"\x64", 0, 0x8E16}, /* East Asian ideograph */
  {"\x66", 0, 0x8E26}, /* East Asian ideograph */
  {"\x67", 0, 0x8E27}, /* East Asian ideograph */
  {"\x68", 0, 0x8E14}, /* East Asian ideograph */
  {"\x69", 0, 0x8E18}, /* East Asian ideograph */
  {"\x6F", 0, 0x8E41}, /* East Asian ideograph */
  {"\x77", 0, 0x8E40}, /* East Asian ideograph */
  {"\x79", 0, 0x8E36}, /* East Asian ideograph */
  {"\x7E", 0, 0x8E3D}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page200 = {
  marc8_31page200_flat, 0
};
/* PAGE 199 */
struct yaz_iconv_trie_flat marc8_31page199_flat[] = {
  {"\x22", 0, 0x8D96}, /* East Asian ideograph */
  {"\x2F", 0, 0x8DA1}, /* East Asian ideograph */
  {"\x33", 0, 0x8DA6}, /* East Asian ideograph */
  {"\x52", 0, 0x8DAB}, /* East Asian ideograph */
  {"\x59", 0, 0x8DAF}, /* East Asian ideograph */
  {"\x5A", 0, 0x8DB0}, /* East Asian ideograph */
  {"\x66", 0, 0x8DB2}, /* East Asian ideograph */
  {"\x6E", 0, 0x8DBC}, /* East Asian ideograph */
  {"\x6F", 0, 0x8DBA}, /* East Asian ideograph */
  {"\x70", 0, 0x8DB9}, /* East Asian ideograph */
  {"\x71", 0, 0x8DC2}, /* East Asian ideograph */
  {"\x72", 0, 0x8DC1}, /* East Asian ideograph */
  {"\x73", 0, 0x8DBF}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page199 = {
  marc8_31page199_flat, 0
};
/* PAGE 198 */
struct yaz_iconv_trie_flat marc8_31page198_flat[] = {
  {"\x21", 0, 0x8CF7}, /* East Asian ideograph */
  {"\x25", 0, 0x8D04}, /* East Asian ideograph */
  {"\x26", 0, 0x8CFE}, /* East Asian ideograph */
  {"\x2B", 0, 0x8D07}, /* East Asian ideograph */
  {"\x2D", 0, 0x8D09}, /* East Asian ideograph */
  {"\x32", 0, 0x8D0C}, /* East Asian ideograph */
  {"\x39", 0, 0x8D11}, /* East Asian ideograph */
  {"\x3A", 0, 0x8D10}, /* East Asian ideograph */
  {"\x3B", 0, 0x8D12}, /* East Asian ideograph */
  {"\x3D", 0, 0x8D14}, /* East Asian ideograph */
  {"\x3E", 0, 0x8D18}, /* East Asian ideograph */
  {"\x48", 0, 0x8D6C}, /* East Asian ideograph */
  {"\x52", 0, 0x8D78}, /* East Asian ideograph */
  {"\x5C", 0, 0x8D7A}, /* East Asian ideograph */
  {"\x61", 0, 0x8D84}, /* East Asian ideograph */
  {"\x71", 0, 0x8D94}, /* East Asian ideograph */
  {"\x75", 0, 0x8D8D}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page198 = {
  marc8_31page198_flat, 0
};
/* PAGE 197 */
struct yaz_iconv_trie_flat marc8_31page197_flat[] = {
  {"\x2A", 0, 0x8C86}, /* East Asian ideograph */
  {"\x2D", 0, 0x8C85}, /* East Asian ideograph */
  {"\x2E", 0, 0x8C88}, /* East Asian ideograph */
  {"\x39", 0, 0x8C94}, /* East Asian ideograph */
  {"\x41", 0, 0x8C9B}, /* East Asian ideograph */
  {"\x43", 0, 0x8C9F}, /* East Asian ideograph */
  {"\x44", 0, 0x8CA4}, /* East Asian ideograph */
  {"\x4E", 0, 0x8CB0}, /* East Asian ideograph */
  {"\x51", 0, 0x8CBA}, /* East Asian ideograph */
  {"\x52", 0, 0x8CB5}, /* East Asian ideograph */
  {"\x53", 0, 0x8CB9}, /* East Asian ideograph */
  {"\x57", 0, 0x8CCD}, /* East Asian ideograph */
  {"\x5E", 0, 0x8CD8}, /* East Asian ideograph */
  {"\x5F", 0, 0x8CD5}, /* East Asian ideograph */
  {"\x67", 0, 0x8CE8}, /* East Asian ideograph */
  {"\x68", 0, 0x8CE9}, /* East Asian ideograph */
  {"\x6A", 0, 0x8CE1}, /* East Asian ideograph */
  {"\x6F", 0, 0x8CEB}, /* East Asian ideograph */
  {"\x70", 0, 0x8CDA}, /* East Asian ideograph */
  {"\x72", 0, 0x8CDD}, /* East Asian ideograph */
  {"\x74", 0, 0x8CD9}, /* East Asian ideograph */
  {"\x76", 0, 0x8CEE}, /* East Asian ideograph */
  {"\x7B", 0, 0x8CF1}, /* East Asian ideograph */
  {"\x7C", 0, 0x8CF5}, /* East Asian ideograph */
  {"\x7E", 0, 0x8CFB}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page197 = {
  marc8_31page197_flat, 0
};
/* PAGE 196 */
struct yaz_iconv_trie_flat marc8_31page196_flat[] = {
  {"\x23", 0, 0x8B8B}, /* East Asian ideograph */
  {"\x26", 0, 0x8B87}, /* East Asian ideograph */
  {"\x2D", 0, 0x8B95}, /* East Asian ideograph */
  {"\x2E", 0, 0x8B94}, /* East Asian ideograph */
  {"\x37", 0, 0x8B9C}, /* East Asian ideograph */
  {"\x3A", 0, 0x8B9F}, /* East Asian ideograph */
  {"\x3D", 0, 0x8C3A}, /* East Asian ideograph */
  {"\x44", 0, 0x8C40}, /* East Asian ideograph */
  {"\x45", 0, 0x8C42}, /* East Asian ideograph */
  {"\x4B", 0, 0x8C47}, /* East Asian ideograph */
  {"\x4D", 0, 0x8C4B}, /* East Asian ideograph */
  {"\x50", 0, 0x8C4F}, /* East Asian ideograph */
  {"\x52", 0, 0x8C55}, /* East Asian ideograph */
  {"\x54", 0, 0x8C57}, /* East Asian ideograph */
  {"\x55", 0, 0x8C5C}, /* East Asian ideograph */
  {"\x56", 0, 0x8C5D}, /* East Asian ideograph */
  {"\x5C", 0, 0x86C3}, /* East Asian ideograph */
  {"\x63", 0, 0x8C68}, /* East Asian ideograph */
  {"\x65", 0, 0x8C6D}, /* East Asian ideograph */
  {"\x6D", 0, 0x8C73}, /* East Asian ideograph */
  {"\x6F", 0, 0x8C74}, /* East Asian ideograph */
  {"\x71", 0, 0x8C75}, /* East Asian ideograph */
  {"\x73", 0, 0x8C77}, /* East Asian ideograph */
  {"\x74", 0, 0x8C76}, /* East Asian ideograph */
  {"\x7B", 0, 0x8C78}, /* East Asian ideograph */
  {"\x7D", 0, 0x8C7B}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page196 = {
  marc8_31page196_flat, 0
};
/* PAGE 195 */
struct yaz_iconv_trie_flat marc8_31page195_flat[] = {
  {"\x22", 0, 0x8B2B}, /* East Asian ideograph */
  {"\x2A", 0, 0x8B37}, /* East Asian ideograph */
  {"\x2D", 0, 0x8B26}, /* East Asian ideograph */
  {"\x30", 0, 0x8B33}, /* East Asian ideograph */
  {"\x38", 0, 0x8B3E}, /* East Asian ideograph */
  {"\x3A", 0, 0x8B29}, /* East Asian ideograph */
  {"\x42", 0, 0x8B48}, /* East Asian ideograph */
  {"\x44", 0, 0x8B54}, /* East Asian ideograph */
  {"\x48", 0, 0x8B53}, /* East Asian ideograph */
  {"\x49", 0, 0x8B4A}, /* East Asian ideograph */
  {"\x4A", 0, 0x8B46}, /* East Asian ideograph */
  {"\x4D", 0, 0x8B56}, /* East Asian ideograph */
  {"\x4F", 0, 0x8B3F}, /* East Asian ideograph */
  {"\x59", 0, 0x8B59}, /* East Asian ideograph */
  {"\x5F", 0, 0x8B4D}, /* East Asian ideograph */
  {"\x68", 0, 0x8B6B}, /* East Asian ideograph */
  {"\x6B", 0, 0x8B6D}, /* East Asian ideograph */
  {"\x70", 0, 0x8B78}, /* East Asian ideograph */
  {"\x73", 0, 0x8B45}, /* East Asian ideograph */
  {"\x78", 0, 0x8B85}, /* East Asian ideograph */
  {"\x79", 0, 0x8B81}, /* East Asian ideograph */
  {"\x7B", 0, 0x8B7E}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page195 = {
  marc8_31page195_flat, 0
};
/* PAGE 194 */
struct yaz_iconv_trie_flat marc8_31page194_flat[] = {
  {"\x21", 0, 0x8ABE}, /* East Asian ideograph */
  {"\x25", 0, 0x8ACF}, /* East Asian ideograph */
  {"\x27", 0, 0x8AC6}, /* East Asian ideograph */
  {"\x2C", 0, 0x8AD1}, /* East Asian ideograph */
  {"\x2D", 0, 0x8AD3}, /* East Asian ideograph */
  {"\x31", 0, 0x8AAF}, /* East Asian ideograph */
  {"\x33", 0, 0x8AD4}, /* East Asian ideograph */
  {"\x36", 0, 0x8ACD}, /* East Asian ideograph */
  {"\x38", 0, 0x8AB9}, /* East Asian ideograph */
  {"\x3B", 0, 0x8ADB}, /* East Asian ideograph */
  {"\x3F", 0, 0x8AD0}, /* East Asian ideograph */
  {"\x40", 0, 0x8AD7}, /* East Asian ideograph */
  {"\x44", 0, 0x8AF3}, /* East Asian ideograph */
  {"\x45", 0, 0x8AE2}, /* East Asian ideograph */
  {"\x49", 0, 0x8B4C}, /* East Asian ideograph */
  {"\x4C", 0, 0x8ADD}, /* East Asian ideograph */
  {"\x4E", 0, 0x8AF6}, /* East Asian ideograph */
  {"\x4F", 0, 0x8AF4}, /* East Asian ideograph */
  {"\x50", 0, 0x8AF5}, /* East Asian ideograph */
  {"\x53", 0, 0x8ADF}, /* East Asian ideograph */
  {"\x56", 0, 0x8B03}, /* East Asian ideograph */
  {"\x57", 0, 0x8AE4}, /* East Asian ideograph */
  {"\x59", 0, 0x8B14}, /* East Asian ideograph */
  {"\x5D", 0, 0x8AFC}, /* East Asian ideograph */
  {"\x62", 0, 0x8ADE}, /* East Asian ideograph */
  {"\x63", 0, 0x8AE1}, /* East Asian ideograph */
  {"\x64", 0, 0x8B07}, /* East Asian ideograph */
  {"\x6B", 0, 0x8B0C}, /* East Asian ideograph */
  {"\x6F", 0, 0x8B1C}, /* East Asian ideograph */
  {"\x73", 0, 0x8B16}, /* East Asian ideograph */
  {"\x76", 0, 0x8B1F}, /* East Asian ideograph */
  {"\x78", 0, 0x8B0B}, /* East Asian ideograph */
  {"\x79", 0, 0x8B06}, /* East Asian ideograph */
  {"\x7A", 0, 0x8B05}, /* East Asian ideograph */
  {"\x7C", 0, 0x8B0F}, /* East Asian ideograph */
  {"\x7D", 0, 0x8B10}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page194 = {
  marc8_31page194_flat, 0
};
/* PAGE 193 */
struct yaz_iconv_trie_flat marc8_31page193_flat[] = {
  {"\x25", 0, 0x8A22}, /* East Asian ideograph */
  {"\x27", 0, 0x8A51}, /* East Asian ideograph */
  {"\x28", 0, 0x8A4A}, /* East Asian ideograph */
  {"\x2A", 0, 0x8A4E}, /* East Asian ideograph */
  {"\x30", 0, 0x8A56}, /* East Asian ideograph */
  {"\x37", 0, 0x8A57}, /* East Asian ideograph */
  {"\x39", 0, 0x8A48}, /* East Asian ideograph */
  {"\x3B", 0, 0x8A58}, /* East Asian ideograph */
  {"\x3C", 0, 0x8A52}, /* East Asian ideograph */
  {"\x40", 0, 0x8A3D}, /* East Asian ideograph */
  {"\x42", 0, 0x8A45}, /* East Asian ideograph */
  {"\x4F", 0, 0x8A7F}, /* East Asian ideograph */
  {"\x50", 0, 0x8A86}, /* East Asian ideograph */
  {"\x56", 0, 0x8A61}, /* East Asian ideograph */
  {"\x58", 0, 0x8A3E}, /* East Asian ideograph */
  {"\x59", 0, 0x8A82}, /* East Asian ideograph */
  {"\x5D", 0, 0x8A84}, /* East Asian ideograph */
  {"\x5E", 0, 0x8A75}, /* East Asian ideograph */
  {"\x69", 0, 0x8A8F}, /* East Asian ideograph */
  {"\x6F", 0, 0x8A96}, /* East Asian ideograph */
  {"\x71", 0, 0x8A9A}, /* East Asian ideograph */
  {"\x7E", 0, 0x8AB6}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page193 = {
  marc8_31page193_flat, 0
};
/* PAGE 192 */
struct yaz_iconv_trie_flat marc8_31page192_flat[] = {
  {"\x2A", 0, 0x89B8}, /* East Asian ideograph */
  {"\x2B", 0, 0x89B7}, /* East Asian ideograph */
  {"\x2C", 0, 0x89B6}, /* East Asian ideograph */
  {"\x2F", 0, 0x89BC}, /* East Asian ideograph */
  {"\x32", 0, 0x89BF}, /* East Asian ideograph */
  {"\x3A", 0, 0x89D6}, /* East Asian ideograph */
  {"\x3B", 0, 0x89D5}, /* East Asian ideograph */
  {"\x3F", 0, 0x89DA}, /* East Asian ideograph */
  {"\x43", 0, 0x89E5}, /* East Asian ideograph */
  {"\x45", 0, 0x89DC}, /* East Asian ideograph */
  {"\x47", 0, 0x89E1}, /* East Asian ideograph */
  {"\x4C", 0, 0x89E9}, /* East Asian ideograph */
  {"\x4D", 0, 0x89EB}, /* East Asian ideograph */
  {"\x53", 0, 0x89ED}, /* East Asian ideograph */
  {"\x58", 0, 0x89F1}, /* East Asian ideograph */
  {"\x5C", 0, 0x89F3}, /* East Asian ideograph */
  {"\x5E", 0, 0x89F5}, /* East Asian ideograph */
  {"\x60", 0, 0x89F6}, /* East Asian ideograph */
  {"\x64", 0, 0x89F7}, /* East Asian ideograph */
  {"\x6B", 0, 0x89FF}, /* East Asian ideograph */
  {"\x6C", 0, 0x8A06}, /* East Asian ideograph */
  {"\x6D", 0, 0x8A07}, /* East Asian ideograph */
  {"\x6E", 0, 0x8A04}, /* East Asian ideograph */
  {"\x70", 0, 0x8A0F}, /* East Asian ideograph */
  {"\x71", 0, 0x8A11}, /* East Asian ideograph */
  {"\x72", 0, 0x8A12}, /* East Asian ideograph */
  {"\x73", 0, 0x8A0D}, /* East Asian ideograph */
  {"\x7A", 0, 0x8A27}, /* East Asian ideograph */
  {"\x7D", 0, 0x8A29}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page192 = {
  marc8_31page192_flat, 0
};
/* PAGE 191 */
struct yaz_iconv_trie_flat marc8_31page191_flat[] = {
  {"\x21", 0, 0x894D}, /* East Asian ideograph */
  {"\x23", 0, 0x8962}, /* East Asian ideograph */
  {"\x24", 0, 0x895A}, /* East Asian ideograph */
  {"\x25", 0, 0x895E}, /* East Asian ideograph */
  {"\x29", 0, 0x895B}, /* East Asian ideograph */
  {"\x2C", 0, 0x895C}, /* East Asian ideograph */
  {"\x2D", 0, 0x895D}, /* East Asian ideograph */
  {"\x31", 0, 0x8966}, /* East Asian ideograph */
  {"\x37", 0, 0x896D}, /* East Asian ideograph */
  {"\x3A", 0, 0x896B}, /* East Asian ideograph */
  {"\x3B", 0, 0x896E}, /* East Asian ideograph */
  {"\x3C", 0, 0x896C}, /* East Asian ideograph */
  {"\x41", 0, 0x8976}, /* East Asian ideograph */
  {"\x42", 0, 0x8974}, /* East Asian ideograph */
  {"\x49", 0, 0x897B}, /* East Asian ideograph */
  {"\x4A", 0, 0x897C}, /* East Asian ideograph */
  {"\x53", 0, 0x8984}, /* East Asian ideograph */
  {"\x55", 0, 0x8985}, /* East Asian ideograph */
  {"\x62", 0, 0x8991}, /* East Asian ideograph */
  {"\x64", 0, 0x8997}, /* East Asian ideograph */
  {"\x66", 0, 0x8998}, /* East Asian ideograph */
  {"\x6B", 0, 0x899C}, /* East Asian ideograph */
  {"\x6F", 0, 0x89A1}, /* East Asian ideograph */
  {"\x76", 0, 0x89A5}, /* East Asian ideograph */
  {"\x79", 0, 0x89A9}, /* East Asian ideograph */
  {"\x7D", 0, 0x89AF}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page191 = {
  marc8_31page191_flat, 0
};
/* PAGE 190 */
struct yaz_iconv_trie_flat marc8_31page190_flat[] = {
  {"\x21", 0, 0x88FC}, /* East Asian ideograph */
  {"\x23", 0, 0x88EF}, /* East Asian ideograph */
  {"\x24", 0, 0x8903}, /* East Asian ideograph */
  {"\x2D", 0, 0x8909}, /* East Asian ideograph */
  {"\x2F", 0, 0x8918}, /* East Asian ideograph */
  {"\x35", 0, 0x8906}, /* East Asian ideograph */
  {"\x36", 0, 0x890C}, /* East Asian ideograph */
  {"\x37", 0, 0x8919}, /* East Asian ideograph */
  {"\x3D", 0, 0x890A}, /* East Asian ideograph */
  {"\x43", 0, 0x8915}, /* East Asian ideograph */
  {"\x45", 0, 0x892F}, /* East Asian ideograph */
  {"\x47", 0, 0x8930}, /* East Asian ideograph */
  {"\x4E", 0, 0x8921}, /* East Asian ideograph */
  {"\x4F", 0, 0x8927}, /* East Asian ideograph */
  {"\x51", 0, 0x891F}, /* East Asian ideograph */
  {"\x53", 0, 0x8931}, /* East Asian ideograph */
  {"\x54", 0, 0x891E}, /* East Asian ideograph */
  {"\x56", 0, 0x8926}, /* East Asian ideograph */
  {"\x57", 0, 0x8922}, /* East Asian ideograph */
  {"\x5A", 0, 0x8935}, /* East Asian ideograph */
  {"\x5D", 0, 0x8941}, /* East Asian ideograph */
  {"\x60", 0, 0x8933}, /* East Asian ideograph */
  {"\x66", 0, 0x8954}, /* East Asian ideograph */
  {"\x6F", 0, 0x894F}, /* East Asian ideograph */
  {"\x72", 0, 0x8947}, /* East Asian ideograph */
  {"\x7A", 0, 0x894C}, /* East Asian ideograph */
  {"\x7B", 0, 0x8946}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page190 = {
  marc8_31page190_flat, 0
};
/* PAGE 189 */
struct yaz_iconv_trie_flat marc8_31page189_flat[] = {
  {"\x28", 0, 0x88A2}, /* East Asian ideograph */
  {"\x2A", 0, 0x88A4}, /* East Asian ideograph */
  {"\x2F", 0, 0x88AA}, /* East Asian ideograph */
  {"\x34", 0, 0x889A}, /* East Asian ideograph */
  {"\x3A", 0, 0x8890}, /* East Asian ideograph */
  {"\x3B", 0, 0x888C}, /* East Asian ideograph */
  {"\x3D", 0, 0x88A0}, /* East Asian ideograph */
  {"\x40", 0, 0x8899}, /* East Asian ideograph */
  {"\x45", 0, 0x8897}, /* East Asian ideograph */
  {"\x48", 0, 0x88C9}, /* East Asian ideograph */
  {"\x49", 0, 0x88BF}, /* East Asian ideograph */
  {"\x4A", 0, 0x88BA}, /* East Asian ideograph */
  {"\x4F", 0, 0x88C0}, /* East Asian ideograph */
  {"\x51", 0, 0x88B2}, /* East Asian ideograph */
  {"\x54", 0, 0x88BC}, /* East Asian ideograph */
  {"\x57", 0, 0x88B7}, /* East Asian ideograph */
  {"\x59", 0, 0x88BD}, /* East Asian ideograph */
  {"\x5A", 0, 0x88C4}, /* East Asian ideograph */
  {"\x5E", 0, 0x88CB}, /* East Asian ideograph */
  {"\x60", 0, 0x88CC}, /* East Asian ideograph */
  {"\x62", 0, 0x88DB}, /* East Asian ideograph */
  {"\x64", 0, 0x88CE}, /* East Asian ideograph */
  {"\x68", 0, 0x88D2}, /* East Asian ideograph */
  {"\x71", 0, 0x88F1}, /* East Asian ideograph */
  {"\x72", 0, 0x88FE}, /* East Asian ideograph */
  {"\x75", 0, 0x88F2}, /* East Asian ideograph */
  {"\x78", 0, 0x8900}, /* East Asian ideograph */
  {"\x7A", 0, 0x88F0}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page189 = {
  marc8_31page189_flat, 0
};
/* PAGE 188 */
struct yaz_iconv_trie_flat marc8_31page188_flat[] = {
  {"\x23", 0, 0x8828}, /* East Asian ideograph */
  {"\x2A", 0, 0x8832}, /* East Asian ideograph */
  {"\x2E", 0, 0x882E}, /* East Asian ideograph */
  {"\x32", 0, 0x882D}, /* East Asian ideograph */
  {"\x3C", 0, 0x883C}, /* East Asian ideograph */
  {"\x41", 0, 0x8841}, /* East Asian ideograph */
  {"\x42", 0, 0x4610}, /* East Asian ideograph */
  {"\x44", 0, 0x8844}, /* East Asian ideograph */
  {"\x4B", 0, 0x8847}, /* East Asian ideograph */
  {"\x51", 0, 0x884A}, /* East Asian ideograph */
  {"\x53", 0, 0x884E}, /* East Asian ideograph */
  {"\x56", 0, 0x8852}, /* East Asian ideograph */
  {"\x57", 0, 0x8850}, /* East Asian ideograph */
  {"\x59", 0, 0x8856}, /* East Asian ideograph */
  {"\x5A", 0, 0x8855}, /* East Asian ideograph */
  {"\x5E", 0, 0x885C}, /* East Asian ideograph */
  {"\x5F", 0, 0x885A}, /* East Asian ideograph */
  {"\x69", 0, 0x8869}, /* East Asian ideograph */
  {"\x6D", 0, 0x886D}, /* East Asian ideograph */
  {"\x6E", 0, 0x887A}, /* East Asian ideograph */
  {"\x71", 0, 0x8875}, /* East Asian ideograph */
  {"\x75", 0, 0x8872}, /* East Asian ideograph */
  {"\x79", 0, 0x887D}, /* East Asian ideograph */
  {"\x7C", 0, 0x8879}, /* East Asian ideograph */
  {"\x7D", 0, 0x887F}, /* East Asian ideograph */
  {"\x7E", 0, 0x887E}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page188 = {
  marc8_31page188_flat, 0
};
/* PAGE 187 */
struct yaz_iconv_trie_flat marc8_31page187_flat[] = {
  {"\x24", 0, 0x87BD}, /* East Asian ideograph */
  {"\x2C", 0, 0x87EE}, /* East Asian ideograph */
  {"\x30", 0, 0x87F3}, /* East Asian ideograph */
  {"\x31", 0, 0x87F0}, /* East Asian ideograph */
  {"\x34", 0, 0x87EA}, /* East Asian ideograph */
  {"\x36", 0, 0x87DB}, /* East Asian ideograph */
  {"\x37", 0, 0x87E2}, /* East Asian ideograph */
  {"\x39", 0, 0x87EB}, /* East Asian ideograph */
  {"\x3A", 0, 0x87D6}, /* East Asian ideograph */
  {"\x3F", 0, 0x87F5}, /* East Asian ideograph */
  {"\x47", 0, 0x87E0}, /* East Asian ideograph */
  {"\x48", 0, 0x87D3}, /* East Asian ideograph */
  {"\x49", 0, 0x87DC}, /* East Asian ideograph */
  {"\x4C", 0, 0x87E3}, /* East Asian ideograph */
  {"\x4D", 0, 0x8801}, /* East Asian ideograph */
  {"\x4F", 0, 0x8803}, /* East Asian ideograph */
  {"\x50", 0, 0x880A}, /* East Asian ideograph */
  {"\x55", 0, 0x87F6}, /* East Asian ideograph */
  {"\x57", 0, 0x87F7}, /* East Asian ideograph */
  {"\x5C", 0, 0x880B}, /* East Asian ideograph */
  {"\x5D", 0, 0x8806}, /* East Asian ideograph */
  {"\x5F", 0, 0x87FE}, /* East Asian ideograph */
  {"\x61", 0, 0x8810}, /* East Asian ideograph */
  {"\x63", 0, 0x8819}, /* East Asian ideograph */
  {"\x64", 0, 0x8811}, /* East Asian ideograph */
  {"\x66", 0, 0x8818}, /* East Asian ideograph */
  {"\x6A", 0, 0x8813}, /* East Asian ideograph */
  {"\x6B", 0, 0x8816}, /* East Asian ideograph */
  {"\x72", 0, 0x8834}, /* East Asian ideograph */
  {"\x73", 0, 0x881C}, /* East Asian ideograph */
  {"\x7A", 0, 0x881B}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page187 = {
  marc8_31page187_flat, 0
};
/* PAGE 186 */
struct yaz_iconv_trie_flat marc8_31page186_flat[] = {
  {"\x21", 0, 0x8761}, /* East Asian ideograph */
  {"\x24", 0, 0x876A}, /* East Asian ideograph */
  {"\x27", 0, 0x874E}, /* East Asian ideograph */
  {"\x28", 0, 0x875F}, /* East Asian ideograph */
  {"\x2D", 0, 0x876F}, /* East Asian ideograph */
  {"\x2E", 0, 0x875D}, /* East Asian ideograph */
  {"\x30", 0, 0x876E}, /* East Asian ideograph */
  {"\x33", 0, 0x874D}, /* East Asian ideograph */
  {"\x35", 0, 0x8753}, /* East Asian ideograph */
  {"\x3A", 0, 0x87A3}, /* East Asian ideograph */
  {"\x3D", 0, 0x8793}, /* East Asian ideograph */
  {"\x45", 0, 0x8799}, /* East Asian ideograph */
  {"\x48", 0, 0x8788}, /* East Asian ideograph */
  {"\x4C", 0, 0x8798}, /* East Asian ideograph */
  {"\x53", 0, 0x8785}, /* East Asian ideograph */
  {"\x54", 0, 0x878B}, /* East Asian ideograph */
  {"\x55", 0, 0x8784}, /* East Asian ideograph */
  {"\x58", 0, 0x87A9}, /* East Asian ideograph */
  {"\x5D", 0, 0x8789}, /* East Asian ideograph */
  {"\x60", 0, 0x87AD}, /* East Asian ideograph */
  {"\x66", 0, 0x87BE}, /* East Asian ideograph */
  {"\x6E", 0, 0x87C4}, /* East Asian ideograph */
  {"\x6F", 0, 0x87AF}, /* East Asian ideograph */
  {"\x72", 0, 0x87AC}, /* East Asian ideograph */
  {"\x78", 0, 0x87AE}, /* East Asian ideograph */
  {"\x7E", 0, 0x87BF}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page186 = {
  marc8_31page186_flat, 0
};
/* PAGE 185 */
struct yaz_iconv_trie_flat marc8_31page185_flat[] = {
  {"\x25", 0, 0x870B}, /* East Asian ideograph */
  {"\x2F", 0, 0x86FA}, /* East Asian ideograph */
  {"\x33", 0, 0x86F8}, /* East Asian ideograph */
  {"\x34", 0, 0x8706}, /* East Asian ideograph */
  {"\x36", 0, 0x870E}, /* East Asian ideograph */
  {"\x38", 0, 0x8709}, /* East Asian ideograph */
  {"\x3A", 0, 0x870A}, /* East Asian ideograph */
  {"\x3E", 0, 0x870D}, /* East Asian ideograph */
  {"\x42", 0, 0x874A}, /* East Asian ideograph */
  {"\x43", 0, 0x8723}, /* East Asian ideograph */
  {"\x44", 0, 0x8737}, /* East Asian ideograph */
  {"\x45", 0, 0x8728}, /* East Asian ideograph */
  {"\x49", 0, 0x8740}, /* East Asian ideograph */
  {"\x4B", 0, 0x872E}, /* East Asian ideograph */
  {"\x4C", 0, 0x873D}, /* East Asian ideograph */
  {"\x4E", 0, 0x871E}, /* East Asian ideograph */
  {"\x53", 0, 0x8743}, /* East Asian ideograph */
  {"\x55", 0, 0x8744}, /* East Asian ideograph */
  {"\x57", 0, 0x873E}, /* East Asian ideograph */
  {"\x59", 0, 0x8729}, /* East Asian ideograph */
  {"\x5A", 0, 0x8739}, /* East Asian ideograph */
  {"\x5F", 0, 0x871A}, /* East Asian ideograph */
  {"\x64", 0, 0x8731}, /* East Asian ideograph */
  {"\x65", 0, 0x8711}, /* East Asian ideograph */
  {"\x66", 0, 0x8712}, /* East Asian ideograph */
  {"\x6B", 0, 0x874F}, /* East Asian ideograph */
  {"\x6C", 0, 0x8771}, /* East Asian ideograph */
  {"\x6D", 0, 0x8763}, /* East Asian ideograph */
  {"\x71", 0, 0x8764}, /* East Asian ideograph */
  {"\x73", 0, 0x8765}, /* East Asian ideograph */
  {"\x74", 0, 0x877D}, /* East Asian ideograph */
  {"\x79", 0, 0x8758}, /* East Asian ideograph */
  {"\x7B", 0, 0x877B}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page185 = {
  marc8_31page185_flat, 0
};
/* PAGE 184 */
struct yaz_iconv_trie_flat marc8_31page184_flat[] = {
  {"\x25", 0, 0x867A}, /* East Asian ideograph */
  {"\x26", 0, 0x8673}, /* East Asian ideograph */
  {"\x27", 0, 0x867C}, /* East Asian ideograph */
  {"\x2E", 0, 0x8696}, /* East Asian ideograph */
  {"\x2F", 0, 0x86A8}, /* East Asian ideograph */
  {"\x36", 0, 0x8691}, /* East Asian ideograph */
  {"\x37", 0, 0x869C}, /* East Asian ideograph */
  {"\x39", 0, 0x8698}, /* East Asian ideograph */
  {"\x3C", 0, 0x868D}, /* East Asian ideograph */
  {"\x3D", 0, 0x868B}, /* East Asian ideograph */
  {"\x40", 0, 0x86A6}, /* East Asian ideograph */
  {"\x42", 0, 0x869D}, /* East Asian ideograph */
  {"\x46", 0, 0x86A0}, /* East Asian ideograph */
  {"\x48", 0, 0x86A7}, /* East Asian ideograph */
  {"\x4B", 0, 0x86BF}, /* East Asian ideograph */
  {"\x58", 0, 0x86BA}, /* East Asian ideograph */
  {"\x59", 0, 0x86B0}, /* East Asian ideograph */
  {"\x60", 0, 0x86B3}, /* East Asian ideograph */
  {"\x62", 0, 0x86C9}, /* East Asian ideograph */
  {"\x63", 0, 0x86B4}, /* East Asian ideograph */
  {"\x67", 0, 0x86D8}, /* East Asian ideograph */
  {"\x6E", 0, 0x86E3}, /* East Asian ideograph */
  {"\x6F", 0, 0x86E9}, /* East Asian ideograph */
  {"\x71", 0, 0x86EC}, /* East Asian ideograph */
  {"\x74", 0, 0x86D5}, /* East Asian ideograph */
  {"\x77", 0, 0x86D0}, /* East Asian ideograph */
  {"\x7A", 0, 0x86D1}, /* East Asian ideograph */
  {"\x7E", 0, 0x86DE}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page184 = {
  marc8_31page184_flat, 0
};
/* PAGE 183 */
struct yaz_iconv_trie_flat marc8_31page183_flat[] = {
  {"\x22", 0, 0x8627}, /* East Asian ideograph */
  {"\x26", 0, 0x8629}, /* East Asian ideograph */
  {"\x32", 0, 0x8637}, /* East Asian ideograph */
  {"\x38", 0, 0x8636}, /* East Asian ideograph */
  {"\x3E", 0, 0x863C}, /* East Asian ideograph */
  {"\x3F", 0, 0x8640}, /* East Asian ideograph */
  {"\x40", 0, 0x863A}, /* East Asian ideograph */
  {"\x4C", 0, 0x8645}, /* East Asian ideograph */
  {"\x59", 0, 0x864D}, /* East Asian ideograph */
  {"\x5A", 0, 0x8653}, /* East Asian ideograph */
  {"\x5E", 0, 0x8659}, /* East Asian ideograph */
  {"\x66", 0, 0x8661}, /* East Asian ideograph */
  {"\x69", 0, 0x8662}, /* East Asian ideograph */
  {"\x6A", 0, 0x8663}, /* East Asian ideograph */
  {"\x71", 0, 0x8669}, /* East Asian ideograph */
  {"\x78", 0, 0x866C}, /* East Asian ideograph */
  {"\x7B", 0, 0x8672}, /* East Asian ideograph */
  {"\x7C", 0, 0x866F}, /* East Asian ideograph */
  {"\x7E", 0, 0x867B}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page183 = {
  marc8_31page183_flat, 0
};
/* PAGE 182 */
struct yaz_iconv_trie_flat marc8_31page182_flat[] = {
  {"\x24", 0, 0x8624}, /* East Asian ideograph */
  {"\x28", 0, 0x85F7}, /* East Asian ideograph */
  {"\x2C", 0, 0x85E6}, /* East Asian ideograph */
  {"\x2E", 0, 0x85D4}, /* East Asian ideograph */
  {"\x31", 0, 0x85ED}, /* East Asian ideograph */
  {"\x39", 0, 0x85DA}, /* East Asian ideograph */
  {"\x43", 0, 0x85DF}, /* East Asian ideograph */
  {"\x45", 0, 0x85D8}, /* East Asian ideograph */
  {"\x4C", 0, 0x85DC}, /* East Asian ideograph */
  {"\x4E", 0, 0x85F5}, /* East Asian ideograph */
  {"\x52", 0, 0x8622}, /* East Asian ideograph */
  {"\x54", 0, 0x8610}, /* East Asian ideograph */
  {"\x57", 0, 0x85FC}, /* East Asian ideograph */
  {"\x5B", 0, 0x85FF}, /* East Asian ideograph */
  {"\x5E", 0, 0x85FE}, /* East Asian ideograph */
  {"\x60", 0, 0x8600}, /* East Asian ideograph */
  {"\x68", 0, 0x8604}, /* East Asian ideograph */
  {"\x71", 0, 0x8605}, /* East Asian ideograph */
  {"\x75", 0, 0x862B}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page182 = {
  marc8_31page182_flat, 0
};
/* PAGE 181 */
struct yaz_iconv_trie_flat marc8_31page181_flat[] = {
  {"\x25", 0, 0x8580}, /* East Asian ideograph */
  {"\x28", 0, 0x858F}, /* East Asian ideograph */
  {"\x2D", 0, 0x8579}, /* East Asian ideograph */
  {"\x32", 0, 0x857F}, /* East Asian ideograph */
  {"\x33", 0, 0x8577}, /* East Asian ideograph */
  {"\x34", 0, 0x8578}, /* East Asian ideograph */
  {"\x35", 0, 0x8598}, /* East Asian ideograph */
  {"\x36", 0, 0x857B}, /* East Asian ideograph */
  {"\x3D", 0, 0x85A4}, /* East Asian ideograph */
  {"\x42", 0, 0x857A}, /* East Asian ideograph */
  {"\x44", 0, 0x8597}, /* East Asian ideograph */
  {"\x45", 0, 0x8557}, /* East Asian ideograph */
  {"\x49", 0, 0x85A8}, /* East Asian ideograph */
  {"\x4E", 0, 0x8586}, /* East Asian ideograph */
  {"\x50", 0, 0x8599}, /* East Asian ideograph */
  {"\x51", 0, 0x858A}, /* East Asian ideograph */
  {"\x52", 0, 0x85A2}, /* East Asian ideograph */
  {"\x54", 0, 0x8590}, /* East Asian ideograph */
  {"\x56", 0, 0x8585}, /* East Asian ideograph */
  {"\x57", 0, 0x8588}, /* East Asian ideograph */
  {"\x5A", 0, 0x85B8}, /* East Asian ideograph */
  {"\x5D", 0, 0x85C1}, /* East Asian ideograph */
  {"\x61", 0, 0x85BA}, /* East Asian ideograph */
  {"\x68", 0, 0x85CE}, /* East Asian ideograph */
  {"\x6A", 0, 0x85C2}, /* East Asian ideograph */
  {"\x6B", 0, 0x85B7}, /* East Asian ideograph */
  {"\x6C", 0, 0x85B9}, /* East Asian ideograph */
  {"\x6E", 0, 0x85B3}, /* East Asian ideograph */
  {"\x6F", 0, 0x85BD}, /* East Asian ideograph */
  {"\x70", 0, 0x85C4}, /* East Asian ideograph */
  {"\x72", 0, 0x85BF}, /* East Asian ideograph */
  {"\x75", 0, 0x85BE}, /* East Asian ideograph */
  {"\x7E", 0, 0x85B6}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page181 = {
  marc8_31page181_flat, 0
};
/* PAGE 180 */
struct yaz_iconv_trie_flat marc8_31page180_flat[] = {
  {"\x24", 0, 0x851E}, /* East Asian ideograph */
  {"\x2A", 0, 0x8518}, /* East Asian ideograph */
  {"\x2D", 0, 0x8526}, /* East Asian ideograph */
  {"\x2E", 0, 0x8507}, /* East Asian ideograph (variant of EACC 2F252E) */
  {"\x2F", 0, 0x84E7}, /* East Asian ideograph */
  {"\x34", 0, 0x84F0}, /* East Asian ideograph */
  {"\x35", 0, 0x84EF}, /* East Asian ideograph */
  {"\x36", 0, 0x8556}, /* East Asian ideograph */
  {"\x46", 0, 0x8541}, /* East Asian ideograph */
  {"\x4B", 0, 0x8558}, /* East Asian ideograph */
  {"\x4D", 0, 0x8553}, /* East Asian ideograph */
  {"\x4E", 0, 0x8561}, /* East Asian ideograph */
  {"\x4F", 0, 0x8540}, /* East Asian ideograph */
  {"\x5A", 0, 0x8546}, /* East Asian ideograph */
  {"\x5C", 0, 0x8564}, /* East Asian ideograph */
  {"\x5D", 0, 0x855E}, /* East Asian ideograph */
  {"\x5E", 0, 0x8573}, /* East Asian ideograph */
  {"\x5F", 0, 0x8551}, /* East Asian ideograph */
  {"\x64", 0, 0x8562}, /* East Asian ideograph */
  {"\x6B", 0, 0x8563}, /* East Asian ideograph */
  {"\x6C", 0, 0x848D}, /* East Asian ideograph */
  {"\x6D", 0, 0x8542}, /* East Asian ideograph */
  {"\x71", 0, 0x854E}, /* East Asian ideograph */
  {"\x74", 0, 0x8555}, /* East Asian ideograph */
  {"\x76", 0, 0x855D}, /* East Asian ideograph */
  {"\x77", 0, 0x858C}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page180 = {
  marc8_31page180_flat, 0
};
/* PAGE 179 */
struct yaz_iconv_trie_flat marc8_31page179_flat[] = {
  {"\x21", 0, 0x8495}, /* East Asian ideograph */
  {"\x27", 0, 0x84AF}, /* East Asian ideograph */
  {"\x29", 0, 0x84AD}, /* East Asian ideograph */
  {"\x32", 0, 0x84A8}, /* East Asian ideograph */
  {"\x33", 0, 0x84D6}, /* East Asian ideograph */
  {"\x35", 0, 0x84DA}, /* East Asian ideograph */
  {"\x3A", 0, 0x8493}, /* East Asian ideograph */
  {"\x3F", 0, 0x84CF}, /* East Asian ideograph */
  {"\x41", 0, 0x84CA}, /* East Asian ideograph */
  {"\x46", 0, 0x8506}, /* East Asian ideograph */
  {"\x47", 0, 0x850B}, /* East Asian ideograph */
  {"\x4D", 0, 0x8500}, /* East Asian ideograph */
  {"\x59", 0, 0x851F}, /* East Asian ideograph */
  {"\x5C", 0, 0x853B}, /* East Asian ideograph */
  {"\x5F", 0, 0x84EA}, /* East Asian ideograph */
  {"\x66", 0, 0x84F4}, /* East Asian ideograph */
  {"\x6A", 0, 0x850C}, /* East Asian ideograph */
  {"\x72", 0, 0x852F}, /* East Asian ideograph */
  {"\x75", 0, 0x8515}, /* East Asian ideograph */
  {"\x77", 0, 0x84F7}, /* East Asian ideograph */
  {"\x7A", 0, 0x84FC}, /* East Asian ideograph */
  {"\x7C", 0, 0x84EB}, /* East Asian ideograph */
  {"\x7D", 0, 0x84FD}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page179 = {
  marc8_31page179_flat, 0
};
/* PAGE 178 */
struct yaz_iconv_trie_flat marc8_31page178_flat[] = {
  {"\x24", 0, 0x8432}, /* East Asian ideograph */
  {"\x29", 0, 0x845C}, /* East Asian ideograph */
  {"\x2D", 0, 0x842A}, /* East Asian ideograph */
  {"\x2E", 0, 0x8429}, /* East Asian ideograph */
  {"\x32", 0, 0x8471}, /* East Asian ideograph */
  {"\x35", 0, 0x845F}, /* East Asian ideograph */
  {"\x36", 0, 0x8460}, /* East Asian ideograph */
  {"\x37", 0, 0x846E}, /* East Asian ideograph */
  {"\x3A", 0, 0x8446}, /* East Asian ideograph */
  {"\x3C", 0, 0x8452}, /* East Asian ideograph */
  {"\x3F", 0, 0x844A}, /* East Asian ideograph */
  {"\x45", 0, 0x844E}, /* East Asian ideograph */
  {"\x49", 0, 0x8497}, /* East Asian ideograph */
  {"\x50", 0, 0x84A1}, /* East Asian ideograph */
  {"\x53", 0, 0x849F}, /* East Asian ideograph */
  {"\x56", 0, 0x84BA}, /* East Asian ideograph */
  {"\x58", 0, 0x84B9}, /* East Asian ideograph */
  {"\x5C", 0, 0x84B4}, /* East Asian ideograph */
  {"\x5E", 0, 0x84C1}, /* East Asian ideograph */
  {"\x5F", 0, 0x84BB}, /* East Asian ideograph */
  {"\x68", 0, 0x84CD}, /* East Asian ideograph */
  {"\x70", 0, 0x84B1}, /* East Asian ideograph */
  {"\x71", 0, 0x849D}, /* East Asian ideograph */
  {"\x72", 0, 0x84D0}, /* East Asian ideograph */
  {"\x75", 0, 0x8494}, /* East Asian ideograph */
  {"\x79", 0, 0x84C7}, /* East Asian ideograph */
  {"\x7A", 0, 0x84BD}, /* East Asian ideograph */
  {"\x7C", 0, 0x84C2}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page178 = {
  marc8_31page178_flat, 0
};
/* PAGE 177 */
struct yaz_iconv_trie_flat marc8_31page177_flat[] = {
  {"\x23", 0, 0x83FD}, /* East Asian ideograph */
  {"\x25", 0, 0x841E}, /* East Asian ideograph */
  {"\x29", 0, 0x83C9}, /* East Asian ideograph */
  {"\x2A", 0, 0x83DF}, /* East Asian ideograph */
  {"\x2C", 0, 0x841F}, /* East Asian ideograph */
  {"\x2E", 0, 0x840F}, /* East Asian ideograph */
  {"\x30", 0, 0x8411}, /* East Asian ideograph */
  {"\x36", 0, 0x839A}, /* East Asian ideograph */
  {"\x3C", 0, 0x83F3}, /* East Asian ideograph */
  {"\x43", 0, 0x83D1}, /* East Asian ideograph */
  {"\x48", 0, 0x8453}, /* East Asian ideograph */
  {"\x4A", 0, 0x848E}, /* East Asian ideograph */
  {"\x4C", 0, 0x8439}, /* East Asian ideograph */
  {"\x4D", 0, 0x8476}, /* East Asian ideograph */
  {"\x4E", 0, 0x8479}, /* East Asian ideograph */
  {"\x5C", 0, 0x8451}, /* East Asian ideograph */
  {"\x5F", 0, 0x847D}, /* East Asian ideograph */
  {"\x62", 0, 0x845A}, /* East Asian ideograph */
  {"\x66", 0, 0x8459}, /* East Asian ideograph */
  {"\x69", 0, 0x8473}, /* East Asian ideograph */
  {"\x6E", 0, 0x843E}, /* East Asian ideograph */
  {"\x71", 0, 0x846D}, /* East Asian ideograph */
  {"\x78", 0, 0x847A}, /* East Asian ideograph */
  {"\x7B", 0, 0x8484}, /* East Asian ideograph */
  {"\x7C", 0, 0x8478}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page177 = {
  marc8_31page177_flat, 0
};
/* PAGE 176 */
struct yaz_iconv_trie_dir marc8_31page176_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {178, 0, 0},
  {179, 0, 0},
  {180, 0, 0},
  {181, 0, 0},
  {182, 0, 0},
  {183, 0, 0},
  {184, 0, 0},
  {185, 0, 0},
  {186, 0, 0},
  {187, 0, 0},
  {188, 0, 0},
  {189, 0, 0},
  {190, 0, 0},
  {191, 0, 0},
  {192, 0, 0},
  {193, 0, 0},
  {194, 0, 0},
  {195, 0, 0},
  {196, 0, 0},
  {197, 0, 0},
  {198, 0, 0},
  {199, 0, 0},
  {200, 0, 0},
  {201, 0, 0},
  {202, 0, 0},
  {203, 0, 0},
  {204, 0, 0},
  {205, 0, 0},
  {206, 0, 0},
  {207, 0, 0},
  {208, 0, 0},
  {209, 0, 0},
  {210, 0, 0},
  {211, 0, 0},
  {212, 0, 0},
  {213, 0, 0},
  {214, 0, 0},
  {215, 0, 0},
  {216, 0, 0},
  {217, 0, 0},
  {218, 0, 0},
  {219, 0, 0},
  {220, 0, 0},
  {221, 0, 0},
  {222, 0, 0},
  {223, 0, 0},
  {224, 0, 0},
  {225, 0, 0},
  {226, 0, 0},
  {227, 0, 0},
  {228, 0, 0},
  {229, 0, 0},
  {230, 0, 0},
  {231, 0, 0},
  {232, 0, 0},
  {233, 0, 0},
  {234, 0, 0},
  {235, 0, 0},
  {236, 0, 0},
  {237, 0, 0},
  {238, 0, 0},
  {239, 0, 0},
  {240, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8_31page176 = {
  0, marc8_31page176_dir
};
/* PAGE 175 */
struct yaz_iconv_trie_flat marc8_31page175_flat[] = {
  {"\x21", 0, 0x837F}, /* East Asian ideograph */
  {"\x22", 0, 0x8399}, /* East Asian ideograph */
  {"\x23", 0, 0x83A6}, /* East Asian ideograph */
  {"\x25", 0, 0x8387}, /* East Asian ideograph */
  {"\x26", 0, 0x83B9}, /* East Asian ideograph */
  {"\x2B", 0, 0x83A9}, /* East Asian ideograph */
  {"\x2F", 0, 0x839B}, /* East Asian ideograph */
  {"\x33", 0, 0x83AA}, /* East Asian ideograph */
  {"\x37", 0, 0x839C}, /* East Asian ideograph */
  {"\x38", 0, 0x839F}, /* East Asian ideograph */
  {"\x41", 0, 0x83CF}, /* East Asian ideograph */
  {"\x43", 0, 0x83F9}, /* East Asian ideograph */
  {"\x45", 0, 0x8421}, /* East Asian ideograph */
  {"\x51", 0, 0x8423}, /* East Asian ideograph */
  {"\x52", 0, 0x83EA}, /* East Asian ideograph */
  {"\x53", 0, 0x8413}, /* East Asian ideograph */
  {"\x56", 0, 0x83FC}, /* East Asian ideograph */
  {"\x57", 0, 0x83F6}, /* East Asian ideograph */
  {"\x59", 0, 0x8410}, /* East Asian ideograph */
  {"\x5A", 0, 0x83E1}, /* East Asian ideograph */
  {"\x60", 0, 0x83C6}, /* East Asian ideograph */
  {"\x61", 0, 0x8407}, /* East Asian ideograph */
  {"\x63", 0, 0x83EB}, /* East Asian ideograph */
  {"\x6A", 0, 0x83BF}, /* East Asian ideograph */
  {"\x6B", 0, 0x83E2}, /* East Asian ideograph */
  {"\x6D", 0, 0x8401}, /* East Asian ideograph */
  {"\x71", 0, 0x83D8}, /* East Asian ideograph */
  {"\x72", 0, 0x83E5}, /* East Asian ideograph */
  {"\x74", 0, 0x8418}, /* East Asian ideograph */
  {"\x79", 0, 0x83CE}, /* East Asian ideograph */
  {"\x7B", 0, 0x83D3}, /* East Asian ideograph */
  {"\x7D", 0, 0x83D6}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page175 = {
  marc8_31page175_flat, 0
};
/* PAGE 174 */
struct yaz_iconv_trie_flat marc8_31page174_flat[] = {
  {"\x21", 0, 0x830C}, /* East Asian ideograph */
  {"\x22", 0, 0x82FB}, /* East Asian ideograph */
  {"\x24", 0, 0x82FD}, /* East Asian ideograph */
  {"\x26", 0, 0x8333}, /* East Asian ideograph */
  {"\x29", 0, 0x8328}, /* East Asian ideograph */
  {"\x2B", 0, 0x8344}, /* East Asian ideograph */
  {"\x2E", 0, 0x8351}, /* East Asian ideograph */
  {"\x35", 0, 0x831B}, /* East Asian ideograph */
  {"\x3B", 0, 0x8356}, /* East Asian ideograph */
  {"\x3F", 0, 0x8322}, /* East Asian ideograph */
  {"\x40", 0, 0x832C}, /* East Asian ideograph */
  {"\x48", 0, 0x833C}, /* East Asian ideograph */
  {"\x4A", 0, 0x834D}, /* East Asian ideograph */
  {"\x4D", 0, 0x8343}, /* East Asian ideograph (variant of EACC 4C7D4D) */
  {"\x52", 0, 0x832F}, /* East Asian ideograph */
  {"\x53", 0, 0x8348}, /* East Asian ideograph */
  {"\x54", 0, 0x8312}, /* East Asian ideograph */
  {"\x56", 0, 0x8316}, /* East Asian ideograph */
  {"\x58", 0, 0x831A}, /* East Asian ideograph */
  {"\x5F", 0, 0x8347}, /* East Asian ideograph */
  {"\x62", 0, 0x83A8}, /* East Asian ideograph */
  {"\x67", 0, 0x83AD}, /* East Asian ideograph */
  {"\x6D", 0, 0x8373}, /* East Asian ideograph */
  {"\x72", 0, 0x83B0}, /* East Asian ideograph */
  {"\x76", 0, 0x831D}, /* East Asian ideograph */
  {"\x7A", 0, 0x838F}, /* East Asian ideograph */
  {"\x7C", 0, 0x8395}, /* East Asian ideograph */
  {"\x7E", 0, 0x8375}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page174 = {
  marc8_31page174_flat, 0
};
/* PAGE 173 */
struct yaz_iconv_trie_flat marc8_31page173_flat[] = {
  {"\x24", 0, 0x828E}, /* East Asian ideograph */
  {"\x25", 0, 0x8291}, /* East Asian ideograph */
  {"\x27", 0, 0x828F}, /* East Asian ideograph */
  {"\x28", 0, 0x8284}, /* East Asian ideograph */
  {"\x2D", 0, 0x8283}, /* East Asian ideograph */
  {"\x2E", 0, 0x828A}, /* East Asian ideograph */
  {"\x31", 0, 0x82AF}, /* East Asian ideograph */
  {"\x34", 0, 0x82A7}, /* East Asian ideograph */
  {"\x38", 0, 0x82AB}, /* East Asian ideograph */
  {"\x3A", 0, 0x82B0}, /* East Asian ideograph */
  {"\x3C", 0, 0x82A4}, /* East Asian ideograph */
  {"\x3F", 0, 0x829A}, /* East Asian ideograph */
  {"\x42", 0, 0x82A3}, /* East Asian ideograph */
  {"\x44", 0, 0x82B7}, /* East Asian ideograph */
  {"\x45", 0, 0x82AE}, /* East Asian ideograph (variant of EACC 4C7C45) */
  {"\x46", 0, 0x82A9}, /* East Asian ideograph */
  {"\x49", 0, 0x82BC}, /* East Asian ideograph */
  {"\x4C", 0, 0x82A8}, /* East Asian ideograph */
  {"\x4E", 0, 0x82B4}, /* East Asian ideograph */
  {"\x50", 0, 0x82A1}, /* East Asian ideograph */
  {"\x53", 0, 0x82AA}, /* East Asian ideograph */
  {"\x55", 0, 0x82D9}, /* East Asian ideograph */
  {"\x57", 0, 0x82FE}, /* East Asian ideograph */
  {"\x5A", 0, 0x82E0}, /* East Asian ideograph */
  {"\x5B", 0, 0x82D0}, /* East Asian ideograph */
  {"\x5C", 0, 0x8300}, /* East Asian ideograph */
  {"\x5F", 0, 0x82EA}, /* East Asian ideograph */
  {"\x60", 0, 0x82F7}, /* East Asian ideograph */
  {"\x62", 0, 0x82EF}, /* East Asian ideograph */
  {"\x63", 0, 0x833A}, /* East Asian ideograph */
  {"\x64", 0, 0x82E4}, /* East Asian ideograph */
  {"\x65", 0, 0x82D5}, /* East Asian ideograph */
  {"\x67", 0, 0x8307}, /* East Asian ideograph */
  {"\x68", 0, 0x82FA}, /* East Asian ideograph */
  {"\x69", 0, 0x82F4}, /* East Asian ideograph */
  {"\x6A", 0, 0x82E2}, /* East Asian ideograph */
  {"\x6D", 0, 0x82D2}, /* East Asian ideograph */
  {"\x6E", 0, 0x8314}, /* East Asian ideograph */
  {"\x71", 0, 0x82EB}, /* East Asian ideograph */
  {"\x72", 0, 0x82D8}, /* East Asian ideograph */
  {"\x73", 0, 0x82E1}, /* East Asian ideograph */
  {"\x75", 0, 0x82F6}, /* East Asian ideograph */
  {"\x7B", 0, 0x8310}, /* East Asian ideograph */
  {"\x7C", 0, 0x82F3}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page173 = {
  marc8_31page173_flat, 0
};
/* PAGE 172 */
struct yaz_iconv_trie_flat marc8_31page172_flat[] = {
  {"\x27", 0, 0x821D}, /* East Asian ideograph */
  {"\x29", 0, 0x8220}, /* East Asian ideograph */
  {"\x2E", 0, 0x822D}, /* East Asian ideograph */
  {"\x2F", 0, 0x822F}, /* East Asian ideograph */
  {"\x32", 0, 0x8238}, /* East Asian ideograph */
  {"\x34", 0, 0x823A}, /* East Asian ideograph */
  {"\x35", 0, 0x8233}, /* East Asian ideograph */
  {"\x36", 0, 0x8234}, /* East Asian ideograph */
  {"\x3A", 0, 0x8232}, /* East Asian ideograph */
  {"\x42", 0, 0x8248}, /* East Asian ideograph */
  {"\x43", 0, 0x8249}, /* East Asian ideograph */
  {"\x45", 0, 0x8244}, /* East Asian ideograph */
  {"\x47", 0, 0x8240}, /* East Asian ideograph */
  {"\x48", 0, 0x8241}, /* East Asian ideograph */
  {"\x4A", 0, 0x8245}, /* East Asian ideograph */
  {"\x4B", 0, 0x824B}, /* East Asian ideograph */
  {"\x50", 0, 0x824F}, /* East Asian ideograph */
  {"\x53", 0, 0x824E}, /* East Asian ideograph */
  {"\x56", 0, 0x8256}, /* East Asian ideograph */
  {"\x57", 0, 0x8257}, /* East Asian ideograph */
  {"\x5E", 0, 0x825A}, /* East Asian ideograph */
  {"\x62", 0, 0x825F}, /* East Asian ideograph */
  {"\x67", 0, 0x8262}, /* East Asian ideograph */
  {"\x6B", 0, 0x8268}, /* East Asian ideograph */
  {"\x6F", 0, 0x826D}, /* East Asian ideograph */
  {"\x77", 0, 0x8278}, /* East Asian ideograph */
  {"\x7D", 0, 0x827F}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page172 = {
  marc8_31page172_flat, 0
};
/* PAGE 171 */
struct yaz_iconv_trie_flat marc8_31page171_flat[] = {
  {"\x2C", 0, 0x81B5}, /* East Asian ideograph */
  {"\x2E", 0, 0x81B0}, /* East Asian ideograph */
  {"\x2F", 0, 0x81B4}, /* East Asian ideograph */
  {"\x33", 0, 0x81B7}, /* East Asian ideograph */
  {"\x37", 0, 0x81BB}, /* East Asian ideograph */
  {"\x38", 0, 0x81C1}, /* East Asian ideograph */
  {"\x39", 0, 0x81CC}, /* East Asian ideograph */
  {"\x3A", 0, 0x81CA}, /* East Asian ideograph */
  {"\x3B", 0, 0x81C4}, /* East Asian ideograph */
  {"\x40", 0, 0x81D1}, /* East Asian ideograph */
  {"\x41", 0, 0x81CE}, /* East Asian ideograph */
  {"\x43", 0, 0x81D0}, /* East Asian ideograph */
  {"\x4B", 0, 0x81DB}, /* East Asian ideograph */
  {"\x4F", 0, 0x81DD}, /* East Asian ideograph */
  {"\x53", 0, 0x81DE}, /* East Asian ideograph */
  {"\x56", 0, 0x81E0}, /* East Asian ideograph */
  {"\x57", 0, 0x81E2}, /* East Asian ideograph */
  {"\x5B", 0, 0x81E7}, /* East Asian ideograph */
  {"\x60", 0, 0x81EF}, /* East Asian ideograph */
  {"\x65", 0, 0x81F2}, /* East Asian ideograph */
  {"\x68", 0, 0x81F6}, /* East Asian ideograph */
  {"\x70", 0, 0x8201}, /* East Asian ideograph */
  {"\x72", 0, 0x8201}, /* East Asian ideograph */
  {"\x74", 0, 0x8203}, /* East Asian ideograph */
  {"\x75", 0, 0x8204}, /* East Asian ideograph */
  {"\x77", 0, 0x820B}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page171 = {
  marc8_31page171_flat, 0
};
/* PAGE 170 */
struct yaz_iconv_trie_flat marc8_31page170_flat[] = {
  {"\x25", 0, 0x814D}, /* East Asian ideograph */
  {"\x2E", 0, 0x6720}, /* East Asian ideograph */
  {"\x32", 0, 0x8160}, /* East Asian ideograph */
  {"\x3B", 0, 0x8169}, /* East Asian ideograph */
  {"\x3C", 0, 0x817C}, /* East Asian ideograph */
  {"\x41", 0, 0x8161}, /* East Asian ideograph */
  {"\x46", 0, 0x8176}, /* East Asian ideograph */
  {"\x47", 0, 0x8174}, /* East Asian ideograph */
  {"\x48", 0, 0x8167}, /* East Asian ideograph */
  {"\x4B", 0, 0x816F}, /* East Asian ideograph */
  {"\x4D", 0, 0x8182}, /* East Asian ideograph */
  {"\x51", 0, 0x818B}, /* East Asian ideograph */
  {"\x52", 0, 0x8186}, /* East Asian ideograph */
  {"\x59", 0, 0x8183}, /* East Asian ideograph */
  {"\x6A", 0, 0x819F}, /* East Asian ideograph */
  {"\x6B", 0, 0x81A3}, /* East Asian ideograph */
  {"\x70", 0, 0x8198}, /* East Asian ideograph */
  {"\x75", 0, 0x8195}, /* East Asian ideograph */
  {"\x77", 0, 0x8197}, /* East Asian ideograph */
  {"\x7C", 0, 0x81AA}, /* East Asian ideograph */
  {"\x7D", 0, 0x81A6}, /* East Asian ideograph */
  {"\x7E", 0, 0x6725}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page170 = {
  marc8_31page170_flat, 0
};
/* PAGE 169 */
struct yaz_iconv_trie_flat marc8_31page169_flat[] = {
  {"\x27", 0, 0x80D9}, /* East Asian ideograph */
  {"\x2A", 0, 0x80DD}, /* East Asian ideograph */
  {"\x2D", 0, 0x80CF}, /* East Asian ideograph */
  {"\x2F", 0, 0x80CD}, /* East Asian ideograph */
  {"\x30", 0, 0x80D7}, /* East Asian ideograph */
  {"\x33", 0, 0x80F2}, /* East Asian ideograph */
  {"\x34", 0, 0x80FA}, /* East Asian ideograph */
  {"\x38", 0, 0x80FE}, /* East Asian ideograph */
  {"\x3C", 0, 0x8103}, /* East Asian ideograph */
  {"\x40", 0, 0x80F9}, /* East Asian ideograph */
  {"\x41", 0, 0x80EF}, /* East Asian ideograph */
  {"\x42", 0, 0x80D4}, /* East Asian ideograph */
  {"\x49", 0, 0x811D}, /* East Asian ideograph */
  {"\x4B", 0, 0x8118}, /* East Asian ideograph */
  {"\x50", 0, 0x8130}, /* East Asian ideograph */
  {"\x54", 0, 0x8124}, /* East Asian ideograph */
  {"\x55", 0, 0x811B}, /* East Asian ideograph */
  {"\x60", 0, 0x812A}, /* East Asian ideograph */
  {"\x61", 0, 0x811E}, /* East Asian ideograph */
  {"\x64", 0, 0x8121}, /* East Asian ideograph */
  {"\x66", 0, 0x8117}, /* East Asian ideograph */
  {"\x69", 0, 0x813A}, /* East Asian ideograph */
  {"\x6A", 0, 0x815A}, /* East Asian ideograph */
  {"\x6D", 0, 0x8148}, /* East Asian ideograph */
  {"\x77", 0, 0x814C}, /* East Asian ideograph */
  {"\x7C", 0, 0x8153}, /* East Asian ideograph */
  {"\x7D", 0, 0x8141}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page169 = {
  marc8_31page169_flat, 0
};
/* PAGE 168 */
struct yaz_iconv_trie_flat marc8_31page168_flat[] = {
  {"\x28", 0, 0x8063}, /* East Asian ideograph */
  {"\x32", 0, 0x806C}, /* East Asian ideograph */
  {"\x39", 0, 0x8075}, /* East Asian ideograph */
  {"\x3E", 0, 0x807B}, /* East Asian ideograph */
  {"\x3F", 0, 0x8079}, /* East Asian ideograph */
  {"\x47", 0, 0x808A}, /* East Asian ideograph */
  {"\x49", 0, 0x808E}, /* East Asian ideograph */
  {"\x4E", 0, 0x809F}, /* East Asian ideograph */
  {"\x5C", 0, 0x670A}, /* East Asian ideograph */
  {"\x60", 0, 0x80A7}, /* East Asian ideograph */
  {"\x61", 0, 0x80B0}, /* East Asian ideograph */
  {"\x68", 0, 0x80B8}, /* East Asian ideograph */
  {"\x69", 0, 0x80B5}, /* East Asian ideograph */
  {"\x6A", 0, 0x80A6}, /* East Asian ideograph */
  {"\x73", 0, 0x80E0}, /* East Asian ideograph */
  {"\x75", 0, 0x6711}, /* East Asian ideograph */
  {"\x7B", 0, 0x80DF}, /* East Asian ideograph */
  {"\x7D", 0, 0x80C2}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page168 = {
  marc8_31page168_flat, 0
};
/* PAGE 167 */
struct yaz_iconv_trie_flat marc8_31page167_flat[] = {
  {"\x29", 0, 0x7FFD}, /* East Asian ideograph */
  {"\x2A", 0, 0x7FFE}, /* East Asian ideograph */
  {"\x2C", 0, 0x7FFF}, /* East Asian ideograph */
  {"\x2E", 0, 0x8004}, /* East Asian ideograph */
  {"\x31", 0, 0x8008}, /* East Asian ideograph */
  {"\x33", 0, 0x800B}, /* East Asian ideograph */
  {"\x34", 0, 0x800E}, /* East Asian ideograph */
  {"\x35", 0, 0x8011}, /* East Asian ideograph */
  {"\x36", 0, 0x800F}, /* East Asian ideograph */
  {"\x37", 0, 0x8014}, /* East Asian ideograph */
  {"\x39", 0, 0x8016}, /* East Asian ideograph */
  {"\x3B", 0, 0x801F}, /* East Asian ideograph */
  {"\x3D", 0, 0x801E}, /* East Asian ideograph */
  {"\x3E", 0, 0x801D}, /* East Asian ideograph */
  {"\x4B", 0, 0x8025}, /* East Asian ideograph */
  {"\x4C", 0, 0x8026}, /* East Asian ideograph */
  {"\x4D", 0, 0x802A}, /* East Asian ideograph */
  {"\x4E", 0, 0x8029}, /* East Asian ideograph */
  {"\x4F", 0, 0x8028}, /* East Asian ideograph */
  {"\x5B", 0, 0x8030}, /* East Asian ideograph */
  {"\x5D", 0, 0x8031}, /* East Asian ideograph */
  {"\x60", 0, 0x8035}, /* East Asian ideograph */
  {"\x69", 0, 0x8039}, /* East Asian ideograph */
  {"\x6B", 0, 0x8041}, /* East Asian ideograph */
  {"\x70", 0, 0x8043}, /* East Asian ideograph */
  {"\x7B", 0, 0x8052}, /* East Asian ideograph */
  {"\x7E", 0, 0x8062}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page167 = {
  marc8_31page167_flat, 0
};
/* PAGE 166 */
struct yaz_iconv_trie_flat marc8_31page166_flat[] = {
  {"\x23", 0, 0x7F97}, /* East Asian ideograph */
  {"\x24", 0, 0x7F95}, /* East Asian ideograph */
  {"\x2C", 0, 0x7FA2}, /* East Asian ideograph */
  {"\x33", 0, 0x7FA7}, /* East Asian ideograph */
  {"\x3B", 0, 0x7FB0}, /* East Asian ideograph */
  {"\x3C", 0, 0x7FAD}, /* East Asian ideograph */
  {"\x3F", 0, 0x7FB1}, /* East Asian ideograph */
  {"\x40", 0, 0x7FB4}, /* East Asian ideograph */
  {"\x42", 0, 0x7FB5}, /* East Asian ideograph */
  {"\x4A", 0, 0x7FBC}, /* East Asian ideograph */
  {"\x4C", 0, 0x7FBE}, /* East Asian ideograph */
  {"\x51", 0, 0x7FC3}, /* East Asian ideograph */
  {"\x57", 0, 0x7FCA}, /* East Asian ideograph */
  {"\x67", 0, 0x7FDB}, /* East Asian ideograph */
  {"\x68", 0, 0x7FE3}, /* East Asian ideograph */
  {"\x6C", 0, 0x7FE6}, /* East Asian ideograph */
  {"\x6F", 0, 0x7FE5}, /* East Asian ideograph */
  {"\x72", 0, 0x7FEC}, /* East Asian ideograph */
  {"\x73", 0, 0x7FEB}, /* East Asian ideograph */
  {"\x77", 0, 0x7FEF}, /* East Asian ideograph */
  {"\x7A", 0, 0x7FEE}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page166 = {
  marc8_31page166_flat, 0
};
/* PAGE 165 */
struct yaz_iconv_trie_flat marc8_31page165_flat[] = {
  {"\x25", 0, 0x7F43}, /* East Asian ideograph */
  {"\x27", 0, 0x7F46}, /* East Asian ideograph */
  {"\x28", 0, 0x7F45}, /* East Asian ideograph */
  {"\x2B", 0, 0x7F4B}, /* East Asian ideograph */
  {"\x2E", 0, 0x7F4C}, /* East Asian ideograph */
  {"\x2F", 0, 0x7F4D}, /* East Asian ideograph */
  {"\x31", 0, 0x7F4E}, /* East Asian ideograph */
  {"\x32", 0, 0x7F4F}, /* East Asian ideograph */
  {"\x3E", 0, 0x7F60}, /* East Asian ideograph */
  {"\x3F", 0, 0x7F61}, /* East Asian ideograph */
  {"\x43", 0, 0x7F5D}, /* East Asian ideograph */
  {"\x45", 0, 0x7F5B}, /* East Asian ideograph */
  {"\x47", 0, 0x7F63}, /* East Asian ideograph */
  {"\x50", 0, 0x7F65}, /* East Asian ideograph */
  {"\x51", 0, 0x7F66}, /* East Asian ideograph */
  {"\x53", 0, 0x7F6D}, /* East Asian ideograph */
  {"\x54", 0, 0x7F6B}, /* East Asian ideograph */
  {"\x55", 0, 0x7F67}, /* East Asian ideograph */
  {"\x57", 0, 0x7F68}, /* East Asian ideograph */
  {"\x5E", 0, 0x7F71}, /* East Asian ideograph */
  {"\x60", 0, 0x7F73}, /* East Asian ideograph */
  {"\x63", 0, 0x7F76}, /* East Asian ideograph */
  {"\x6A", 0, 0x7F7F}, /* East Asian ideograph */
  {"\x6B", 0, 0x7F7E}, /* East Asian ideograph */
  {"\x6C", 0, 0x7F7D}, /* East Asian ideograph */
  {"\x72", 0, 0x7F86}, /* East Asian ideograph */
  {"\x7A", 0, 0x7F91}, /* East Asian ideograph */
  {"\x7E", 0, 0x7F96}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page165 = {
  marc8_31page165_flat, 0
};
/* PAGE 164 */
struct yaz_iconv_trie_flat marc8_31page164_flat[] = {
  {"\x21", 0, 0x7E35}, /* East Asian ideograph */
  {"\x26", 0, 0x7E3F}, /* East Asian ideograph */
  {"\x28", 0, 0x7E47}, /* East Asian ideograph */
  {"\x2D", 0, 0x7E52}, /* East Asian ideograph */
  {"\x2F", 0, 0x7E51}, /* East Asian ideograph */
  {"\x33", 0, 0x7E50}, /* East Asian ideograph */
  {"\x34", 0, 0x7E67}, /* East Asian ideograph */
  {"\x37", 0, 0x7E56}, /* East Asian ideograph */
  {"\x48", 0, 0x7E68}, /* East Asian ideograph */
  {"\x49", 0, 0x7E6E}, /* East Asian ideograph */
  {"\x4E", 0, 0x7E70}, /* East Asian ideograph */
  {"\x51", 0, 0x7E6F}, /* East Asian ideograph */
  {"\x52", 0, 0x7E73}, /* East Asian ideograph */
  {"\x58", 0, 0x7E7B}, /* East Asian ideograph */
  {"\x59", 0, 0x7E7E}, /* East Asian ideograph */
  {"\x5B", 0, 0x7E81}, /* East Asian ideograph */
  {"\x5D", 0, 0x7E8A}, /* East Asian ideograph */
  {"\x5E", 0, 0x7E87}, /* East Asian ideograph */
  {"\x60", 0, 0x7E88}, /* East Asian ideograph */
  {"\x64", 0, 0x7E86}, /* East Asian ideograph */
  {"\x6A", 0, 0x7E91}, /* East Asian ideograph */
  {"\x6B", 0, 0x7E95}, /* East Asian ideograph */
  {"\x6D", 0, 0x7E94}, /* East Asian ideograph */
  {"\x70", 0, 0x7E9B}, /* East Asian ideograph */
  {"\x71", 0, 0x7E9A}, /* East Asian ideograph */
  {"\x73", 0, 0x7E99}, /* East Asian ideograph */
  {"\x74", 0, 0x7E98}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page164 = {
  marc8_31page164_flat, 0
};
/* PAGE 163 */
struct yaz_iconv_trie_flat marc8_31page163_flat[] = {
  {"\x22", 0, 0x7D9F}, /* East Asian ideograph */
  {"\x29", 0, 0x7DE1}, /* East Asian ideograph */
  {"\x2A", 0, 0x7DD9}, /* East Asian ideograph */
  {"\x2B", 0, 0x7DE4}, /* East Asian ideograph */
  {"\x31", 0, 0x7DD7}, /* East Asian ideograph */
  {"\x36", 0, 0x7DF9}, /* East Asian ideograph */
  {"\x3A", 0, 0x7E06}, /* East Asian ideograph */
  {"\x3C", 0, 0x7DF2}, /* East Asian ideograph */
  {"\x3E", 0, 0x7DE6}, /* East Asian ideograph */
  {"\x46", 0, 0x7DDC}, /* East Asian ideograph */
  {"\x47", 0, 0x7DF1}, /* East Asian ideograph */
  {"\x48", 0, 0x7DF6}, /* East Asian ideograph */
  {"\x49", 0, 0x7DE5}, /* East Asian ideograph */
  {"\x4B", 0, 0x7DF5}, /* East Asian ideograph */
  {"\x50", 0, 0x7E17}, /* East Asian ideograph */
  {"\x51", 0, 0x7E1E}, /* East Asian ideograph */
  {"\x52", 0, 0x7E21}, /* East Asian ideograph */
  {"\x53", 0, 0x7E0B}, /* East Asian ideograph */
  {"\x55", 0, 0x7E12}, /* East Asian ideograph */
  {"\x56", 0, 0x7E22}, /* East Asian ideograph */
  {"\x5B", 0, 0x7E20}, /* East Asian ideograph */
  {"\x5D", 0, 0x7E1D}, /* East Asian ideograph */
  {"\x5E", 0, 0x7E09}, /* East Asian ideograph */
  {"\x5F", 0, 0x7E1F}, /* East Asian ideograph */
  {"\x65", 0, 0x7E15}, /* East Asian ideograph */
  {"\x69", 0, 0x7E10}, /* East Asian ideograph */
  {"\x6A", 0, 0x7E0F}, /* East Asian ideograph */
  {"\x6D", 0, 0x7E3B}, /* East Asian ideograph */
  {"\x71", 0, 0x7E34}, /* East Asian ideograph */
  {"\x72", 0, 0x7E2D}, /* East Asian ideograph */
  {"\x73", 0, 0x7E2F}, /* East Asian ideograph */
  {"\x75", 0, 0x7E36}, /* East Asian ideograph */
  {"\x77", 0, 0x7E3A}, /* East Asian ideograph */
  {"\x79", 0, 0x7E39}, /* East Asian ideograph */
  {"\x7D", 0, 0x7E44}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page163 = {
  marc8_31page163_flat, 0
};
/* PAGE 162 */
struct yaz_iconv_trie_flat marc8_31page162_flat[] = {
  {"\x22", 0, 0x7D70}, /* East Asian ideograph */
  {"\x29", 0, 0x7D67}, /* East Asian ideograph */
  {"\x2B", 0, 0x7D6A}, /* East Asian ideograph */
  {"\x2C", 0, 0x7D6B}, /* East Asian ideograph */
  {"\x30", 0, 0x7D73}, /* East Asian ideograph */
  {"\x34", 0, 0x7D4E}, /* East Asian ideograph */
  {"\x37", 0, 0x7D8B}, /* East Asian ideograph */
  {"\x39", 0, 0x7D88}, /* East Asian ideograph */
  {"\x3B", 0, 0x7D85}, /* East Asian ideograph */
  {"\x3D", 0, 0x7D8E}, /* East Asian ideograph */
  {"\x42", 0, 0x7D7F}, /* East Asian ideograph */
  {"\x44", 0, 0x7D86}, /* East Asian ideograph */
  {"\x48", 0, 0x7D8D}, /* East Asian ideograph */
  {"\x4B", 0, 0x7D9B}, /* East Asian ideograph */
  {"\x4D", 0, 0x7D83}, /* East Asian ideograph */
  {"\x4F", 0, 0x7D7D}, /* East Asian ideograph */
  {"\x54", 0, 0x7D7B}, /* East Asian ideograph */
  {"\x58", 0, 0x7D7A}, /* East Asian ideograph */
  {"\x59", 0, 0x7D96}, /* East Asian ideograph */
  {"\x5A", 0, 0x7D5B}, /* East Asian ideograph */
  {"\x5B", 0, 0x7D8C}, /* East Asian ideograph */
  {"\x61", 0, 0x7DA3}, /* East Asian ideograph */
  {"\x62", 0, 0x7DAE}, /* East Asian ideograph */
  {"\x67", 0, 0x7DCB}, /* East Asian ideograph */
  {"\x69", 0, 0x7DAA}, /* East Asian ideograph */
  {"\x6A", 0, 0x7DCE}, /* East Asian ideograph */
  {"\x6B", 0, 0x7DC9}, /* East Asian ideograph */
  {"\x6E", 0, 0x7DC5}, /* East Asian ideograph */
  {"\x6F", 0, 0x7DA6}, /* East Asian ideograph */
  {"\x74", 0, 0x7DC4}, /* East Asian ideograph */
  {"\x78", 0, 0x7DAC}, /* East Asian ideograph */
  {"\x7D", 0, 0x7DB9}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page162 = {
  marc8_31page162_flat, 0
};
/* PAGE 161 */
struct yaz_iconv_trie_flat marc8_31page161_flat[] = {
  {"\x22", 0, 0x7CDD}, /* East Asian ideograph */
  {"\x28", 0, 0x7CED}, /* East Asian ideograph */
  {"\x2E", 0, 0x7CF0}, /* East Asian ideograph */
  {"\x30", 0, 0x7CF2}, /* East Asian ideograph */
  {"\x35", 0, 0x7CF4}, /* East Asian ideograph */
  {"\x39", 0, 0x7CF6}, /* East Asian ideograph */
  {"\x42", 0, 0x7D06}, /* East Asian ideograph */
  {"\x44", 0, 0x7D03}, /* East Asian ideograph */
  {"\x45", 0, 0x7D08}, /* East Asian ideograph */
  {"\x49", 0, 0x7D0F}, /* East Asian ideograph */
  {"\x4A", 0, 0x7D13}, /* East Asian ideograph */
  {"\x50", 0, 0x7D18}, /* East Asian ideograph */
  {"\x51", 0, 0x7D1E}, /* East Asian ideograph */
  {"\x52", 0, 0x7D1D}, /* East Asian ideograph */
  {"\x59", 0, 0x7D35}, /* East Asian ideograph */
  {"\x5A", 0, 0x7D3D}, /* East Asian ideograph */
  {"\x61", 0, 0x7D3A}, /* East Asian ideograph */
  {"\x62", 0, 0x7D32}, /* East Asian ideograph */
  {"\x65", 0, 0x7D31}, /* East Asian ideograph */
  {"\x68", 0, 0x7D45}, /* East Asian ideograph */
  {"\x6A", 0, 0x7D3F}, /* East Asian ideograph */
  {"\x6C", 0, 0x7D29}, /* East Asian ideograph */
  {"\x6F", 0, 0x7D41}, /* East Asian ideograph */
  {"\x71", 0, 0x7D3E}, /* East Asian ideograph */
  {"\x7A", 0, 0x7D5C}, /* East Asian ideograph */
  {"\x7C", 0, 0x7D53}, /* East Asian ideograph */
  {"\x7E", 0, 0x7D5A}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page161 = {
  marc8_31page161_flat, 0
};
/* PAGE 160 */
struct yaz_iconv_trie_flat marc8_31page160_flat[] = {
  {"\x21", 0, 0x7C81}, /* East Asian ideograph */
  {"\x28", 0, 0x7C8E}, /* East Asian ideograph */
  {"\x29", 0, 0x7C91}, /* East Asian ideograph */
  {"\x2A", 0, 0x7C83}, /* East Asian ideograph */
  {"\x2C", 0, 0x7C8D}, /* East Asian ideograph */
  {"\x3A", 0, 0x7C99}, /* East Asian ideograph */
  {"\x3B", 0, 0x7C98}, /* East Asian ideograph */
  {"\x3E", 0, 0x7C9C}, /* East Asian ideograph */
  {"\x40", 0, 0x7C95}, /* East Asian ideograph */
  {"\x42", 0, 0x7CA7}, /* East Asian ideograph */
  {"\x43", 0, 0x7CA2}, /* East Asian ideograph */
  {"\x45", 0, 0x7C9E}, /* East Asian ideograph */
  {"\x46", 0, 0x7CA9}, /* East Asian ideograph */
  {"\x48", 0, 0x7CA8}, /* East Asian ideograph */
  {"\x49", 0, 0x7CA1}, /* East Asian ideograph */
  {"\x4A", 0, 0x7CAC}, /* East Asian ideograph */
  {"\x4C", 0, 0x7CA6}, /* East Asian ideograph */
  {"\x54", 0, 0x7CB2}, /* East Asian ideograph */
  {"\x58", 0, 0x7CBB}, /* East Asian ideograph */
  {"\x59", 0, 0x7CBF}, /* East Asian ideograph */
  {"\x5E", 0, 0x7CBA}, /* East Asian ideograph */
  {"\x5F", 0, 0x7CBC}, /* East Asian ideograph */
  {"\x64", 0, 0x7CC2}, /* East Asian ideograph */
  {"\x66", 0, 0x7CCE}, /* East Asian ideograph */
  {"\x68", 0, 0x7CC8}, /* East Asian ideograph */
  {"\x69", 0, 0x7CC5}, /* East Asian ideograph */
  {"\x6D", 0, 0x7CCC}, /* East Asian ideograph */
  {"\x6F", 0, 0x7CC9}, /* East Asian ideograph */
  {"\x71", 0, 0x7CD2}, /* East Asian ideograph */
  {"\x75", 0, 0x7CD7}, /* East Asian ideograph */
  {"\x77", 0, 0x7CE1}, /* East Asian ideograph */
  {"\x7B", 0, 0x7CE8}, /* East Asian ideograph (variant of EACC 4C6F7B) */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page160 = {
  marc8_31page160_flat, 0
};
/* PAGE 159 */
struct yaz_iconv_trie_flat marc8_31page159_flat[] = {
  {"\x27", 0, 0x7C35}, /* East Asian ideograph */
  {"\x2A", 0, 0x7C40}, /* East Asian ideograph */
  {"\x30", 0, 0x7C39}, /* East Asian ideograph */
  {"\x34", 0, 0x7C3B}, /* East Asian ideograph */
  {"\x35", 0, 0x7C34}, /* East Asian ideograph */
  {"\x3B", 0, 0x7C42}, /* East Asian ideograph */
  {"\x46", 0, 0x7C4E}, /* East Asian ideograph */
  {"\x54", 0, 0x7C5D}, /* East Asian ideograph */
  {"\x56", 0, 0x7C5C}, /* East Asian ideograph */
  {"\x57", 0, 0x7C5A}, /* East Asian ideograph */
  {"\x58", 0, 0x7C5B}, /* East Asian ideograph */
  {"\x59", 0, 0x7C59}, /* East Asian ideograph */
  {"\x5B", 0, 0x7C5E}, /* East Asian ideograph */
  {"\x5C", 0, 0x7C67}, /* East Asian ideograph */
  {"\x5E", 0, 0x7C63}, /* East Asian ideograph */
  {"\x61", 0, 0x7C68}, /* East Asian ideograph */
  {"\x62", 0, 0x7C65}, /* East Asian ideograph */
  {"\x6F", 0, 0x7C6F}, /* East Asian ideograph */
  {"\x75", 0, 0x7C75}, /* East Asian ideograph */
  {"\x79", 0, 0x7C7E}, /* East Asian ideograph */
  {"\x7A", 0, 0x7C78}, /* East Asian ideograph */
  {"\x7D", 0, 0x7C7D}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page159 = {
  marc8_31page159_flat, 0
};
/* PAGE 158 */
struct yaz_iconv_trie_flat marc8_31page158_flat[] = {
  {"\x22", 0, 0x7BDD}, /* East Asian ideograph */
  {"\x24", 0, 0x7BE5}, /* East Asian ideograph */
  {"\x29", 0, 0x7BE8}, /* East Asian ideograph */
  {"\x2E", 0, 0x7BF9}, /* East Asian ideograph */
  {"\x2F", 0, 0x7BD4}, /* East Asian ideograph */
  {"\x32", 0, 0x7BDF}, /* East Asian ideograph */
  {"\x35", 0, 0x7BD8}, /* East Asian ideograph */
  {"\x37", 0, 0x7BEA}, /* East Asian ideograph (unrelated variant of EACC 3A6A7C) */
  {"\x3B", 0, 0x7C06}, /* East Asian ideograph */
  {"\x3E", 0, 0x7BF0}, /* East Asian ideograph */
  {"\x41", 0, 0x7C0F}, /* East Asian ideograph */
  {"\x46", 0, 0x7C0B}, /* East Asian ideograph */
  {"\x47", 0, 0x7C00}, /* East Asian ideograph */
  {"\x4B", 0, 0x7C0C}, /* East Asian ideograph */
  {"\x4F", 0, 0x7BF4}, /* East Asian ideograph */
  {"\x54", 0, 0x7BF3}, /* East Asian ideograph */
  {"\x5A", 0, 0x7C09}, /* East Asian ideograph */
  {"\x5B", 0, 0x7C03}, /* East Asian ideograph */
  {"\x5C", 0, 0x7BFC}, /* East Asian ideograph */
  {"\x5F", 0, 0x7C1C}, /* East Asian ideograph */
  {"\x61", 0, 0x7C26}, /* East Asian ideograph */
  {"\x62", 0, 0x7C28}, /* East Asian ideograph */
  {"\x63", 0, 0x7C20}, /* East Asian ideograph */
  {"\x66", 0, 0x7C1F}, /* East Asian ideograph */
  {"\x68", 0, 0x7C2F}, /* East Asian ideograph */
  {"\x75", 0, 0x7C30}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page158 = {
  marc8_31page158_flat, 0
};
/* PAGE 157 */
struct yaz_iconv_trie_flat marc8_31page157_flat[] = {
  {"\x26", 0, 0x7B71}, /* East Asian ideograph */
  {"\x27", 0, 0x7B70}, /* East Asian ideograph */
  {"\x29", 0, 0x7B73}, /* East Asian ideograph */
  {"\x2D", 0, 0x7B9C}, /* East Asian ideograph */
  {"\x33", 0, 0x7B92}, /* East Asian ideograph */
  {"\x34", 0, 0x7B91}, /* East Asian ideograph */
  {"\x35", 0, 0x7B90}, /* East Asian ideograph */
  {"\x38", 0, 0x7BA3}, /* East Asian ideograph */
  {"\x3A", 0, 0x7B8D}, /* East Asian ideograph */
  {"\x41", 0, 0x7B85}, /* East Asian ideograph */
  {"\x43", 0, 0x7B8E}, /* East Asian ideograph */
  {"\x44", 0, 0x7B98}, /* East Asian ideograph */
  {"\x46", 0, 0x7B86}, /* East Asian ideograph */
  {"\x48", 0, 0x7B99}, /* East Asian ideograph */
  {"\x52", 0, 0x7BB2}, /* East Asian ideograph */
  {"\x58", 0, 0x7BCB}, /* East Asian ideograph */
  {"\x59", 0, 0x7BB8}, /* East Asian ideograph */
  {"\x5A", 0, 0x7BCF}, /* East Asian ideograph */
  {"\x5C", 0, 0x7BD0}, /* East Asian ideograph */
  {"\x60", 0, 0x7BBE}, /* East Asian ideograph */
  {"\x6F", 0, 0x7BCC}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page157 = {
  marc8_31page157_flat, 0
};
/* PAGE 156 */
struct yaz_iconv_trie_flat marc8_31page156_flat[] = {
  {"\x27", 0, 0x7B39}, /* East Asian ideograph */
  {"\x2D", 0, 0x7B0F}, /* East Asian ideograph */
  {"\x2E", 0, 0x7B08}, /* East Asian ideograph */
  {"\x33", 0, 0x7B0A}, /* East Asian ideograph */
  {"\x35", 0, 0x7B35}, /* East Asian ideograph */
  {"\x36", 0, 0x7B25}, /* East Asian ideograph */
  {"\x39", 0, 0x7B38}, /* East Asian ideograph */
  {"\x3B", 0, 0x7B3B}, /* East Asian ideograph */
  {"\x3F", 0, 0x7B24}, /* East Asian ideograph */
  {"\x40", 0, 0x7B33}, /* East Asian ideograph */
  {"\x42", 0, 0x7B2A}, /* East Asian ideograph */
  {"\x44", 0, 0x7B18}, /* East Asian ideograph */
  {"\x47", 0, 0x7B31}, /* East Asian ideograph */
  {"\x4A", 0, 0x7B2B}, /* East Asian ideograph */
  {"\x4B", 0, 0x7B37}, /* East Asian ideograph */
  {"\x4D", 0, 0x7B1F}, /* East Asian ideograph */
  {"\x52", 0, 0x7B4A}, /* East Asian ideograph */
  {"\x53", 0, 0x7B59}, /* East Asian ideograph */
  {"\x54", 0, 0x7B04}, /* East Asian ideograph (variant of EACC 2E6B54) */
  {"\x55", 0, 0x7B47}, /* East Asian ideograph */
  {"\x59", 0, 0x7B58}, /* East Asian ideograph */
  {"\x5B", 0, 0x7B6C}, /* East Asian ideograph */
  {"\x60", 0, 0x7B48}, /* East Asian ideograph */
  {"\x61", 0, 0x7B45}, /* East Asian ideograph */
  {"\x62", 0, 0x7B4C}, /* East Asian ideograph */
  {"\x63", 0, 0x7B4E}, /* East Asian ideograph */
  {"\x68", 0, 0x7B66}, /* East Asian ideograph */
  {"\x6C", 0, 0x7B64}, /* East Asian ideograph */
  {"\x6E", 0, 0x7B69}, /* East Asian ideograph */
  {"\x70", 0, 0x7B6D}, /* East Asian ideograph */
  {"\x74", 0, 0x7B62}, /* East Asian ideograph */
  {"\x75", 0, 0x7B6E}, /* East Asian ideograph */
  {"\x76", 0, 0x7B74}, /* East Asian ideograph */
  {"\x79", 0, 0x7B72}, /* East Asian ideograph */
  {"\x7A", 0, 0x7B78}, /* East Asian ideograph */
  {"\x7B", 0, 0x7B6F}, /* East Asian ideograph */
  {"\x7C", 0, 0x7B67}, /* East Asian ideograph */
  {"\x7E", 0, 0x7B65}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page156 = {
  marc8_31page156_flat, 0
};
/* PAGE 155 */
struct yaz_iconv_trie_flat marc8_31page155_flat[] = {
  {"\x28", 0, 0x7AA3}, /* East Asian ideograph */
  {"\x2B", 0, 0x7A9E}, /* East Asian ideograph */
  {"\x2C", 0, 0x7AA7}, /* East Asian ideograph */
  {"\x2E", 0, 0x7AA8}, /* East Asian ideograph */
  {"\x31", 0, 0x7AAC}, /* East Asian ideograph */
  {"\x36", 0, 0x7AB3}, /* East Asian ideograph */
  {"\x3A", 0, 0x7ABD}, /* East Asian ideograph */
  {"\x3C", 0, 0x7AB6}, /* East Asian ideograph */
  {"\x3D", 0, 0x7AB8}, /* East Asian ideograph */
  {"\x3E", 0, 0x7AB5}, /* East Asian ideograph */
  {"\x3F", 0, 0x7ABB}, /* East Asian ideograph */
  {"\x43", 0, 0x7ABF}, /* East Asian ideograph */
  {"\x49", 0, 0x7ACD}, /* East Asian ideograph */
  {"\x4B", 0, 0x7ACF}, /* East Asian ideograph */
  {"\x4F", 0, 0x7AD1}, /* East Asian ideograph */
  {"\x51", 0, 0x7AD3}, /* East Asian ideograph */
  {"\x52", 0, 0x7AD4}, /* East Asian ideograph */
  {"\x54", 0, 0x7AD5}, /* East Asian ideograph */
  {"\x55", 0, 0x7ADA}, /* East Asian ideograph */
  {"\x5A", 0, 0x7AE1}, /* East Asian ideograph */
  {"\x5E", 0, 0x7AE6}, /* East Asian ideograph */
  {"\x66", 0, 0x7AEB}, /* East Asian ideograph */
  {"\x6B", 0, 0x7AF0}, /* East Asian ideograph */
  {"\x76", 0, 0x7AF5}, /* East Asian ideograph */
  {"\x7C", 0, 0x7AFE}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page155 = {
  marc8_31page155_flat, 0
};
/* PAGE 154 */
struct yaz_iconv_trie_flat marc8_31page154_flat[] = {
  {"\x22", 0, 0x7A2C}, /* East Asian ideograph */
  {"\x39", 0, 0x7A48}, /* East Asian ideograph */
  {"\x3D", 0, 0x7A4B}, /* East Asian ideograph */
  {"\x3E", 0, 0x7A47}, /* East Asian ideograph */
  {"\x3F", 0, 0x7A44}, /* East Asian ideograph */
  {"\x40", 0, 0x7A5C}, /* East Asian ideograph */
  {"\x4D", 0, 0x7A5F}, /* East Asian ideograph */
  {"\x4F", 0, 0x7A60}, /* East Asian ideograph */
  {"\x57", 0, 0x7A6E}, /* East Asian ideograph */
  {"\x5F", 0, 0x7A70}, /* East Asian ideograph */
  {"\x66", 0, 0x7A75}, /* East Asian ideograph */
  {"\x69", 0, 0x7A78}, /* East Asian ideograph */
  {"\x6B", 0, 0x7A80}, /* East Asian ideograph */
  {"\x70", 0, 0x7A85}, /* East Asian ideograph */
  {"\x75", 0, 0x7A86}, /* East Asian ideograph */
  {"\x78", 0, 0x7A8A}, /* East Asian ideograph */
  {"\x7A", 0, 0x7A94}, /* East Asian ideograph */
  {"\x7E", 0, 0x68A5}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page154 = {
  marc8_31page154_flat, 0
};
/* PAGE 153 */
struct yaz_iconv_trie_flat marc8_31page153_flat[] = {
  {"\x22", 0, 0x79B8}, /* East Asian ideograph */
  {"\x23", 0, 0x79BA}, /* East Asian ideograph */
  {"\x25", 0, 0x79BC}, /* East Asian ideograph */
  {"\x28", 0, 0x79C6}, /* East Asian ideograph */
  {"\x2A", 0, 0x79C8}, /* East Asian ideograph */
  {"\x2D", 0, 0x79D4}, /* East Asian ideograph */
  {"\x2E", 0, 0x79D5}, /* East Asian ideograph */
  {"\x32", 0, 0x79D6}, /* East Asian ideograph */
  {"\x3D", 0, 0x79EC}, /* East Asian ideograph */
  {"\x3E", 0, 0x79EB}, /* East Asian ideograph (variant of EACC 4C683E) */
  {"\x42", 0, 0x79E1}, /* East Asian ideograph */
  {"\x44", 0, 0x79DD}, /* East Asian ideograph */
  {"\x45", 0, 0x79ED}, /* East Asian ideograph */
  {"\x48", 0, 0x79F8}, /* East Asian ideograph */
  {"\x4F", 0, 0x7A02}, /* East Asian ideograph */
  {"\x50", 0, 0x7A0A}, /* East Asian ideograph */
  {"\x54", 0, 0x7A09}, /* East Asian ideograph */
  {"\x5C", 0, 0x7A03}, /* East Asian ideograph */
  {"\x61", 0, 0x7A0C}, /* East Asian ideograph */
  {"\x6B", 0, 0x7A11}, /* East Asian ideograph */
  {"\x6C", 0, 0x7A18}, /* East Asian ideograph */
  {"\x6F", 0, 0x7A19}, /* East Asian ideograph (variant of EACC 2E686F) */
  {"\x71", 0, 0x7A1E}, /* East Asian ideograph */
  {"\x76", 0, 0x7A17}, /* East Asian ideograph */
  {"\x7E", 0, 0x7A2D}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page153 = {
  marc8_31page153_flat, 0
};
/* PAGE 152 */
struct yaz_iconv_trie_flat marc8_31page152_flat[] = {
  {"\x21", 0, 0x7951}, /* East Asian ideograph */
  {"\x23", 0, 0x7954}, /* East Asian ideograph */
  {"\x2A", 0, 0x7967}, /* East Asian ideograph */
  {"\x2D", 0, 0x796B}, /* East Asian ideograph */
  {"\x30", 0, 0x7972}, /* East Asian ideograph */
  {"\x3E", 0, 0x797C}, /* East Asian ideograph */
  {"\x4A", 0, 0x7998}, /* East Asian ideograph */
  {"\x4B", 0, 0x798A}, /* East Asian ideograph */
  {"\x4D", 0, 0x7999}, /* East Asian ideograph */
  {"\x4E", 0, 0x7995}, /* East Asian ideograph */
  {"\x4F", 0, 0x798B}, /* East Asian ideograph */
  {"\x50", 0, 0x7996}, /* East Asian ideograph */
  {"\x54", 0, 0x7994}, /* East Asian ideograph */
  {"\x55", 0, 0x7993}, /* East Asian ideograph */
  {"\x5C", 0, 0x799A}, /* East Asian ideograph */
  {"\x5F", 0, 0x79A1}, /* East Asian ideograph */
  {"\x60", 0, 0x799B}, /* East Asian ideograph */
  {"\x61", 0, 0x79A3}, /* East Asian ideograph */
  {"\x64", 0, 0x799D}, /* East Asian ideograph */
  {"\x6E", 0, 0x79A9}, /* East Asian ideograph */
  {"\x70", 0, 0x79AB}, /* East Asian ideograph */
  {"\x71", 0, 0x79A8}, /* East Asian ideograph */
  {"\x75", 0, 0x79B0}, /* East Asian ideograph */
  {"\x7A", 0, 0x79B3}, /* East Asian ideograph */
  {"\x7B", 0, 0x79B4}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page152 = {
  marc8_31page152_flat, 0
};
/* PAGE 151 */
struct yaz_iconv_trie_flat marc8_31page151_flat[] = {
  {"\x21", 0, 0x78F9}, /* East Asian ideograph */
  {"\x22", 0, 0x78FD}, /* East Asian ideograph */
  {"\x27", 0, 0x78FE}, /* East Asian ideograph */
  {"\x29", 0, 0x78FB}, /* East Asian ideograph */
  {"\x2B", 0, 0x7904}, /* East Asian ideograph */
  {"\x2E", 0, 0x7912}, /* East Asian ideograph */
  {"\x32", 0, 0x790C}, /* East Asian ideograph */
  {"\x34", 0, 0x7913}, /* East Asian ideograph */
  {"\x35", 0, 0x7911}, /* East Asian ideograph */
  {"\x43", 0, 0x791E}, /* East Asian ideograph */
  {"\x46", 0, 0x7922}, /* East Asian ideograph */
  {"\x4C", 0, 0x7924}, /* East Asian ideograph */
  {"\x4D", 0, 0x7927}, /* East Asian ideograph */
  {"\x50", 0, 0x7929}, /* East Asian ideograph */
  {"\x55", 0, 0x7931}, /* East Asian ideograph */
  {"\x5D", 0, 0x7934}, /* East Asian ideograph */
  {"\x60", 0, 0x7936}, /* East Asian ideograph */
  {"\x65", 0, 0x793D}, /* East Asian ideograph */
  {"\x67", 0, 0x7942}, /* East Asian ideograph */
  {"\x68", 0, 0x793F}, /* East Asian ideograph */
  {"\x6A", 0, 0x794A}, /* East Asian ideograph */
  {"\x6B", 0, 0x794D}, /* East Asian ideograph */
  {"\x75", 0, 0x7946}, /* East Asian ideograph */
  {"\x77", 0, 0x7958}, /* East Asian ideograph */
  {"\x79", 0, 0x795B}, /* East Asian ideograph */
  {"\x7A", 0, 0x795C}, /* East Asian ideograph */
  {"\x7B", 0, 0x794F}, /* East Asian ideograph */
  {"\x7C", 0, 0x7953}, /* East Asian ideograph */
  {"\x7D", 0, 0x7953}, /* East Asian ideograph (unrelated variant of EACC 22667C) */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page151 = {
  marc8_31page151_flat, 0
};
/* PAGE 150 */
struct yaz_iconv_trie_flat marc8_31page150_flat[] = {
  {"\x29", 0, 0x7893}, /* East Asian ideograph */
  {"\x2C", 0, 0x7892}, /* East Asian ideograph */
  {"\x2D", 0, 0x7896}, /* East Asian ideograph */
  {"\x2F", 0, 0x78B2}, /* East Asian ideograph */
  {"\x31", 0, 0x78A1}, /* East Asian ideograph */
  {"\x32", 0, 0x78B6}, /* East Asian ideograph */
  {"\x39", 0, 0x78B7}, /* East Asian ideograph */
  {"\x3B", 0, 0x78A4}, /* East Asian ideograph */
  {"\x3E", 0, 0x78B4}, /* East Asian ideograph */
  {"\x40", 0, 0x78AD}, /* East Asian ideograph */
  {"\x41", 0, 0x78A3}, /* East Asian ideograph */
  {"\x43", 0, 0x789E}, /* East Asian ideograph */
  {"\x44", 0, 0x78A8}, /* East Asian ideograph */
  {"\x48", 0, 0x78AB}, /* East Asian ideograph */
  {"\x4E", 0, 0x78BB}, /* East Asian ideograph */
  {"\x55", 0, 0x78CC}, /* East Asian ideograph */
  {"\x56", 0, 0x78C9}, /* East Asian ideograph */
  {"\x58", 0, 0x78D1}, /* East Asian ideograph */
  {"\x5A", 0, 0x78D8}, /* East Asian ideograph */
  {"\x5E", 0, 0x78C8}, /* East Asian ideograph */
  {"\x60", 0, 0x78D4}, /* East Asian ideograph */
  {"\x68", 0, 0x78DF}, /* East Asian ideograph */
  {"\x6A", 0, 0x78E7}, /* East Asian ideograph */
  {"\x6E", 0, 0x78DB}, /* East Asian ideograph */
  {"\x6F", 0, 0x78E1}, /* East Asian ideograph */
  {"\x73", 0, 0x78E0}, /* East Asian ideograph */
  {"\x76", 0, 0x78EE}, /* East Asian ideograph */
  {"\x77", 0, 0x78E3}, /* East Asian ideograph */
  {"\x79", 0, 0x78F2}, /* East Asian ideograph */
  {"\x7E", 0, 0x7905}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page150 = {
  marc8_31page150_flat, 0
};
/* PAGE 149 */
struct yaz_iconv_trie_flat marc8_31page149_flat[] = {
  {"\x24", 0, 0x781B}, /* East Asian ideograph */
  {"\x26", 0, 0x782C}, /* East Asian ideograph */
  {"\x27", 0, 0x7823}, /* East Asian ideograph */
  {"\x28", 0, 0x782B}, /* East Asian ideograph */
  {"\x2A", 0, 0x7829}, /* East Asian ideograph */
  {"\x2D", 0, 0x7822}, /* East Asian ideograph */
  {"\x31", 0, 0x7835}, /* East Asian ideograph */
  {"\x32", 0, 0x7833}, /* East Asian ideograph */
  {"\x33", 0, 0x782E}, /* East Asian ideograph */
  {"\x35", 0, 0x7820}, /* East Asian ideograph */
  {"\x38", 0, 0x783D}, /* East Asian ideograph */
  {"\x3B", 0, 0x781F}, /* East Asian ideograph */
  {"\x3D", 0, 0x7831}, /* East Asian ideograph */
  {"\x44", 0, 0x784D}, /* East Asian ideograph */
  {"\x48", 0, 0x7848}, /* East Asian ideograph */
  {"\x49", 0, 0x7853}, /* East Asian ideograph */
  {"\x4A", 0, 0x7854}, /* East Asian ideograph */
  {"\x4B", 0, 0x7845}, /* East Asian ideograph */
  {"\x4C", 0, 0x7852}, /* East Asian ideograph */
  {"\x4E", 0, 0x7850}, /* East Asian ideograph */
  {"\x4F", 0, 0x7858}, /* East Asian ideograph */
  {"\x50", 0, 0x7826}, /* East Asian ideograph */
  {"\x52", 0, 0x7847}, /* East Asian ideograph */
  {"\x56", 0, 0x784C}, /* East Asian ideograph */
  {"\x5A", 0, 0x7868}, /* East Asian ideograph */
  {"\x5B", 0, 0x786D}, /* East Asian ideograph */
  {"\x60", 0, 0x7864}, /* East Asian ideograph */
  {"\x61", 0, 0x785C}, /* East Asian ideograph */
  {"\x64", 0, 0x7876}, /* East Asian ideograph */
  {"\x66", 0, 0x786A}, /* East Asian ideograph */
  {"\x69", 0, 0x7886}, /* East Asian ideograph */
  {"\x6B", 0, 0x789A}, /* East Asian ideograph */
  {"\x6C", 0, 0x787F}, /* East Asian ideograph */
  {"\x6D", 0, 0x7887}, /* East Asian ideograph */
  {"\x70", 0, 0x7894}, /* East Asian ideograph */
  {"\x76", 0, 0x788F}, /* East Asian ideograph */
  {"\x7E", 0, 0x7899}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page149 = {
  marc8_31page149_flat, 0
};
/* PAGE 148 */
struct yaz_iconv_trie_flat marc8_31page148_flat[] = {
  {"\x23", 0, 0x77B6}, /* East Asian ideograph */
  {"\x29", 0, 0x77BE}, /* East Asian ideograph */
  {"\x2B", 0, 0x77B9}, /* East Asian ideograph */
  {"\x2C", 0, 0x77BC}, /* East Asian ideograph */
  {"\x35", 0, 0x77CD}, /* East Asian ideograph */
  {"\x3A", 0, 0x77D1}, /* East Asian ideograph */
  {"\x45", 0, 0x77DE}, /* East Asian ideograph */
  {"\x46", 0, 0x77DF}, /* East Asian ideograph */
  {"\x4F", 0, 0x77E7}, /* East Asian ideograph */
  {"\x52", 0, 0x77E6}, /* East Asian ideograph */
  {"\x55", 0, 0x77EC}, /* East Asian ideograph */
  {"\x59", 0, 0x77F0}, /* East Asian ideograph */
  {"\x5A", 0, 0x77F1}, /* East Asian ideograph */
  {"\x5C", 0, 0x77F4}, /* East Asian ideograph */
  {"\x60", 0, 0x77FC}, /* East Asian ideograph */
  {"\x67", 0, 0x77F8}, /* East Asian ideograph */
  {"\x68", 0, 0x77FB}, /* East Asian ideograph */
  {"\x70", 0, 0x7809}, /* East Asian ideograph */
  {"\x71", 0, 0x7806}, /* East Asian ideograph */
  {"\x73", 0, 0x7819}, /* East Asian ideograph */
  {"\x74", 0, 0x7811}, /* East Asian ideograph */
  {"\x78", 0, 0x7812}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page148 = {
  marc8_31page148_flat, 0
};
/* PAGE 147 */
struct yaz_iconv_trie_flat marc8_31page147_flat[] = {
  {"\x22", 0, 0x7725}, /* East Asian ideograph */
  {"\x25", 0, 0x7735}, /* East Asian ideograph */
  {"\x26", 0, 0x7734}, /* East Asian ideograph */
  {"\x2D", 0, 0x7747}, /* East Asian ideograph */
  {"\x31", 0, 0x7745}, /* East Asian ideograph */
  {"\x32", 0, 0x774D}, /* East Asian ideograph */
  {"\x33", 0, 0x774A}, /* East Asian ideograph */
  {"\x35", 0, 0x7743}, /* East Asian ideograph */
  {"\x37", 0, 0x774E}, /* East Asian ideograph */
  {"\x3A", 0, 0x775F}, /* East Asian ideograph */
  {"\x3D", 0, 0x7760}, /* East Asian ideograph */
  {"\x3E", 0, 0x7752}, /* East Asian ideograph */
  {"\x42", 0, 0x7758}, /* East Asian ideograph */
  {"\x44", 0, 0x7756}, /* East Asian ideograph */
  {"\x45", 0, 0x775A}, /* East Asian ideograph */
  {"\x4F", 0, 0x7762}, /* East Asian ideograph */
  {"\x52", 0, 0x7780}, /* East Asian ideograph */
  {"\x56", 0, 0x776F}, /* East Asian ideograph */
  {"\x5D", 0, 0x777E}, /* East Asian ideograph */
  {"\x5F", 0, 0x7785}, /* East Asian ideograph */
  {"\x60", 0, 0x777A}, /* East Asian ideograph */
  {"\x66", 0, 0x778B}, /* East Asian ideograph (variant of EACC 4C6266) */
  {"\x6A", 0, 0x778D}, /* East Asian ideograph */
  {"\x72", 0, 0x7798}, /* East Asian ideograph */
  {"\x73", 0, 0x7796}, /* East Asian ideograph */
  {"\x75", 0, 0x77A2}, /* East Asian ideograph */
  {"\x76", 0, 0x7799}, /* East Asian ideograph */
  {"\x7A", 0, 0x77B5}, /* East Asian ideograph */
  {"\x7D", 0, 0x77B7}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page147 = {
  marc8_31page147_flat, 0
};
/* PAGE 146 */
struct yaz_iconv_trie_flat marc8_31page146_flat[] = {
  {"\x23", 0, 0x76CB}, /* East Asian ideograph */
  {"\x26", 0, 0x76CC}, /* East Asian ideograph */
  {"\x3B", 0, 0x76E6}, /* East Asian ideograph */
  {"\x3C", 0, 0x76E9}, /* East Asian ideograph */
  {"\x40", 0, 0x76EC}, /* East Asian ideograph */
  {"\x44", 0, 0x76ED}, /* East Asian ideograph */
  {"\x48", 0, 0x76F1}, /* East Asian ideograph */
  {"\x4B", 0, 0x7704}, /* East Asian ideograph */
  {"\x4F", 0, 0x7708}, /* East Asian ideograph */
  {"\x50", 0, 0x7707}, /* East Asian ideograph */
  {"\x53", 0, 0x76F7}, /* East Asian ideograph */
  {"\x54", 0, 0x770A}, /* East Asian ideograph */
  {"\x59", 0, 0x76FB}, /* East Asian ideograph */
  {"\x5E", 0, 0x772B}, /* East Asian ideograph */
  {"\x60", 0, 0x770E}, /* East Asian ideograph */
  {"\x62", 0, 0x771B}, /* East Asian ideograph */
  {"\x63", 0, 0x7724}, /* East Asian ideograph */
  {"\x6C", 0, 0x7722}, /* East Asian ideograph */
  {"\x6D", 0, 0x771A}, /* East Asian ideograph */
  {"\x6F", 0, 0x7721}, /* East Asian ideograph */
  {"\x74", 0, 0x7740}, /* East Asian ideograph */
  {"\x75", 0, 0x7739}, /* East Asian ideograph */
  {"\x76", 0, 0x772F}, /* East Asian ideograph */
  {"\x77", 0, 0x7731}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page146 = {
  marc8_31page146_flat, 0
};
/* PAGE 145 */
struct yaz_iconv_trie_flat marc8_31page145_flat[] = {
  {"\x22", 0, 0x7664}, /* East Asian ideograph */
  {"\x24", 0, 0x7659}, /* East Asian ideograph */
  {"\x2B", 0, 0x765F}, /* East Asian ideograph */
  {"\x32", 0, 0x7667}, /* East Asian ideograph */
  {"\x35", 0, 0x766A}, /* East Asian ideograph */
  {"\x37", 0, 0x766D}, /* East Asian ideograph */
  {"\x38", 0, 0x766F}, /* East Asian ideograph */
  {"\x3A", 0, 0x7670}, /* East Asian ideograph */
  {"\x40", 0, 0x7676}, /* East Asian ideograph */
  {"\x41", 0, 0x7677}, /* East Asian ideograph */
  {"\x48", 0, 0x7680}, /* East Asian ideograph */
  {"\x4A", 0, 0x768B}, /* East Asian ideograph */
  {"\x52", 0, 0x7695}, /* East Asian ideograph */
  {"\x55", 0, 0x656B}, /* East Asian ideograph */
  {"\x59", 0, 0x7699}, /* East Asian ideograph */
  {"\x5D", 0, 0x769C}, /* East Asian ideograph */
  {"\x5F", 0, 0x769D}, /* East Asian ideograph */
  {"\x65", 0, 0x76A4}, /* East Asian ideograph */
  {"\x66", 0, 0x76A5}, /* East Asian ideograph */
  {"\x67", 0, 0x76A6}, /* East Asian ideograph */
  {"\x6A", 0, 0x76AA}, /* East Asian ideograph */
  {"\x6D", 0, 0x76AD}, /* East Asian ideograph */
  {"\x74", 0, 0x76B8}, /* East Asian ideograph */
  {"\x77", 0, 0x76BD}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page145 = {
  marc8_31page145_flat, 0
};
/* PAGE 144 */
struct yaz_iconv_trie_flat marc8_31page144_flat[] = {
  {"\x21", 0, 0x75F9}, /* East Asian ideograph */
  {"\x22", 0, 0x75FC}, /* East Asian ideograph */
  {"\x29", 0, 0x7616}, /* East Asian ideograph */
  {"\x2C", 0, 0x7608}, /* East Asian ideograph */
  {"\x2D", 0, 0x7615}, /* East Asian ideograph */
  {"\x2E", 0, 0x760C}, /* East Asian ideograph */
  {"\x2F", 0, 0x760F}, /* East Asian ideograph */
  {"\x3B", 0, 0x7610}, /* East Asian ideograph */
  {"\x3C", 0, 0x760A}, /* East Asian ideograph */
  {"\x3E", 0, 0x7625}, /* East Asian ideograph */
  {"\x3F", 0, 0x761A}, /* East Asian ideograph */
  {"\x40", 0, 0x761B}, /* East Asian ideograph */
  {"\x47", 0, 0x7619}, /* East Asian ideograph */
  {"\x48", 0, 0x761E}, /* East Asian ideograph */
  {"\x4C", 0, 0x761D}, /* East Asian ideograph */
  {"\x50", 0, 0x7622}, /* East Asian ideograph */
  {"\x51", 0, 0x762F}, /* East Asian ideograph */
  {"\x54", 0, 0x762D}, /* East Asian ideograph */
  {"\x5C", 0, 0x7633}, /* East Asian ideograph */
  {"\x5E", 0, 0x763B}, /* East Asian ideograph */
  {"\x5F", 0, 0x7630}, /* East Asian ideograph */
  {"\x60", 0, 0x763C}, /* East Asian ideograph */
  {"\x62", 0, 0x7635}, /* East Asian ideograph */
  {"\x67", 0, 0x7648}, /* East Asian ideograph */
  {"\x68", 0, 0x764E}, /* East Asian ideograph */
  {"\x69", 0, 0x7647}, /* East Asian ideograph */
  {"\x6A", 0, 0x7643}, /* East Asian ideograph */
  {"\x6E", 0, 0x764D}, /* East Asian ideograph */
  {"\x6F", 0, 0x7649}, /* East Asian ideograph */
  {"\x75", 0, 0x7654}, /* East Asian ideograph */
  {"\x7A", 0, 0x765C}, /* East Asian ideograph */
  {"\x7B", 0, 0x7657}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page144 = {
  marc8_31page144_flat, 0
};
/* PAGE 143 */
struct yaz_iconv_trie_flat marc8_31page143_flat[] = {
  {"\x25", 0, 0x7583}, /* East Asian ideograph */
  {"\x2C", 0, 0x7590}, /* East Asian ideograph */
  {"\x2D", 0, 0x7592}, /* East Asian ideograph */
  {"\x2E", 0, 0x7594}, /* East Asian ideograph */
  {"\x31", 0, 0x7595}, /* East Asian ideograph */
  {"\x35", 0, 0x7598}, /* East Asian ideograph */
  {"\x37", 0, 0x75A2}, /* East Asian ideograph */
  {"\x3B", 0, 0x75A3}, /* East Asian ideograph */
  {"\x3E", 0, 0x75BA}, /* East Asian ideograph */
  {"\x43", 0, 0x75B0}, /* East Asian ideograph */
  {"\x44", 0, 0x75C3}, /* East Asian ideograph */
  {"\x46", 0, 0x75BF}, /* East Asian ideograph */
  {"\x47", 0, 0x75B4}, /* East Asian ideograph */
  {"\x4A", 0, 0x75C2}, /* East Asian ideograph */
  {"\x4E", 0, 0x75C1}, /* East Asian ideograph */
  {"\x50", 0, 0x75B1}, /* East Asian ideograph */
  {"\x51", 0, 0x75C4}, /* East Asian ideograph */
  {"\x58", 0, 0x75CD}, /* East Asian ideograph */
  {"\x5C", 0, 0x75CF}, /* East Asian ideograph */
  {"\x5E", 0, 0x75CC}, /* East Asian ideograph */
  {"\x5F", 0, 0x75D0}, /* East Asian ideograph */
  {"\x63", 0, 0x75E7}, /* East Asian ideograph */
  {"\x66", 0, 0x75E1}, /* East Asian ideograph */
  {"\x67", 0, 0x75E6}, /* East Asian ideograph */
  {"\x71", 0, 0x75E4}, /* East Asian ideograph */
  {"\x72", 0, 0x75E0}, /* East Asian ideograph */
  {"\x73", 0, 0x75D7}, /* East Asian ideograph */
  {"\x7A", 0, 0x7602}, /* East Asian ideograph */
  {"\x7E", 0, 0x7603}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page143 = {
  marc8_31page143_flat, 0
};
/* PAGE 142 */
struct yaz_iconv_trie_flat marc8_31page142_flat[] = {
  {"\x25", 0, 0x750E}, /* East Asian ideograph */
  {"\x28", 0, 0x750D}, /* East Asian ideograph */
  {"\x2C", 0, 0x7511}, /* East Asian ideograph */
  {"\x2D", 0, 0x750F}, /* East Asian ideograph */
  {"\x32", 0, 0x7512}, /* East Asian ideograph */
  {"\x33", 0, 0x7513}, /* East Asian ideograph */
  {"\x39", 0, 0x7517}, /* East Asian ideograph */
  {"\x42", 0, 0x7521}, /* East Asian ideograph */
  {"\x44", 0, 0x7524}, /* East Asian ideograph */
  {"\x49", 0, 0x752F}, /* East Asian ideograph */
  {"\x4D", 0, 0x753A}, /* East Asian ideograph */
  {"\x4F", 0, 0x753F}, /* East Asian ideograph */
  {"\x51", 0, 0x7540}, /* East Asian ideograph */
  {"\x52", 0, 0x753E}, /* East Asian ideograph */
  {"\x55", 0, 0x754A}, /* East Asian ideograph */
  {"\x57", 0, 0x754E}, /* East Asian ideograph */
  {"\x58", 0, 0x7547}, /* East Asian ideograph */
  {"\x59", 0, 0x754B}, /* East Asian ideograph */
  {"\x5A", 0, 0x7548}, /* East Asian ideograph */
  {"\x5F", 0, 0x755F}, /* East Asian ideograph */
  {"\x60", 0, 0x755B}, /* East Asian ideograph */
  {"\x62", 0, 0x7564}, /* East Asian ideograph */
  {"\x67", 0, 0x7563}, /* East Asian ideograph */
  {"\x69", 0, 0x756F}, /* East Asian ideograph */
  {"\x6B", 0, 0x756C}, /* East Asian ideograph */
  {"\x6D", 0, 0x7579}, /* East Asian ideograph */
  {"\x6E", 0, 0x757A}, /* East Asian ideograph */
  {"\x71", 0, 0x7577}, /* East Asian ideograph */
  {"\x75", 0, 0x7571}, /* East Asian ideograph */
  {"\x79", 0, 0x757D}, /* East Asian ideograph */
  {"\x7E", 0, 0x757F}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page142 = {
  marc8_31page142_flat, 0
};
/* PAGE 141 */
struct yaz_iconv_trie_flat marc8_31page141_flat[] = {
  {"\x25", 0, 0x74BF}, /* East Asian ideograph */
  {"\x28", 0, 0x74B5}, /* East Asian ideograph */
  {"\x29", 0, 0x74BA}, /* East Asian ideograph */
  {"\x30", 0, 0x74C8}, /* East Asian ideograph */
  {"\x31", 0, 0x74C5}, /* East Asian ideograph */
  {"\x32", 0, 0x74CC}, /* East Asian ideograph */
  {"\x38", 0, 0x74D6}, /* East Asian ideograph */
  {"\x3A", 0, 0x74D4}, /* East Asian ideograph */
  {"\x3D", 0, 0x74D8}, /* East Asian ideograph */
  {"\x40", 0, 0x74DA}, /* East Asian ideograph */
  {"\x41", 0, 0x74DB}, /* East Asian ideograph */
  {"\x47", 0, 0x74DE}, /* East Asian ideograph */
  {"\x50", 0, 0x74E4}, /* East Asian ideograph */
  {"\x52", 0, 0x74E7}, /* East Asian ideograph */
  {"\x54", 0, 0x74E9}, /* East Asian ideograph */
  {"\x58", 0, 0x74F1}, /* East Asian ideograph */
  {"\x5A", 0, 0x74F0}, /* East Asian ideograph */
  {"\x5C", 0, 0x74EE}, /* East Asian ideograph */
  {"\x61", 0, 0x74F4}, /* East Asian ideograph */
  {"\x63", 0, 0x74F8}, /* East Asian ideograph */
  {"\x66", 0, 0x74FB}, /* East Asian ideograph */
  {"\x67", 0, 0x74FF}, /* East Asian ideograph */
  {"\x71", 0, 0x7505}, /* East Asian ideograph */
  {"\x77", 0, 0x7503}, /* East Asian ideograph */
  {"\x7D", 0, 0x7507}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page141 = {
  marc8_31page141_flat, 0
};
/* PAGE 140 */
struct yaz_iconv_trie_flat marc8_31page140_flat[] = {
  {"\x21", 0, 0x7489}, /* East Asian ideograph */
  {"\x22", 0, 0x747C}, /* East Asian ideograph */
  {"\x27", 0, 0x7482}, /* East Asian ideograph */
  {"\x28", 0, 0x747E}, /* East Asian ideograph */
  {"\x2A", 0, 0x748A}, /* East Asian ideograph */
  {"\x2D", 0, 0x7486}, /* East Asian ideograph */
  {"\x30", 0, 0x747A}, /* East Asian ideograph */
  {"\x38", 0, 0x7480}, /* East Asian ideograph */
  {"\x3C", 0, 0x7481}, /* East Asian ideograph */
  {"\x3E", 0, 0x747D}, /* East Asian ideograph */
  {"\x3F", 0, 0x7485}, /* East Asian ideograph */
  {"\x40", 0, 0x7497}, /* East Asian ideograph */
  {"\x43", 0, 0x7498}, /* East Asian ideograph */
  {"\x45", 0, 0x749A}, /* East Asian ideograph */
  {"\x4D", 0, 0x74A4}, /* East Asian ideograph */
  {"\x54", 0, 0x749F}, /* East Asian ideograph */
  {"\x55", 0, 0x749D}, /* East Asian ideograph */
  {"\x56", 0, 0x748D}, /* East Asian ideograph */
  {"\x57", 0, 0x749E}, /* East Asian ideograph */
  {"\x59", 0, 0x74A0}, /* East Asian ideograph */
  {"\x5D", 0, 0x74A1}, /* East Asian ideograph */
  {"\x60", 0, 0x74B2}, /* East Asian ideograph */
  {"\x61", 0, 0x74B1}, /* East Asian ideograph */
  {"\x66", 0, 0x74B4}, /* East Asian ideograph */
  {"\x67", 0, 0x74AB}, /* East Asian ideograph */
  {"\x69", 0, 0x74AA}, /* East Asian ideograph */
  {"\x6A", 0, 0x7490}, /* East Asian ideograph */
  {"\x6C", 0, 0x74A5}, /* East Asian ideograph */
  {"\x6E", 0, 0x74A8}, /* East Asian ideograph */
  {"\x76", 0, 0x74B8}, /* East Asian ideograph */
  {"\x7A", 0, 0x74C0}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page140 = {
  marc8_31page140_flat, 0
};
/* PAGE 139 */
struct yaz_iconv_trie_flat marc8_31page139_flat[] = {
  {"\x21", 0, 0x7428}, /* East Asian ideograph */
  {"\x23", 0, 0x7429}, /* East Asian ideograph */
  {"\x28", 0, 0x7420}, /* East Asian ideograph */
  {"\x2A", 0, 0x741B}, /* East Asian ideograph */
  {"\x2B", 0, 0x7424}, /* East Asian ideograph */
  {"\x2C", 0, 0x7432}, /* East Asian ideograph */
  {"\x2D", 0, 0x742D}, /* East Asian ideograph */
  {"\x30", 0, 0x7415}, /* East Asian ideograph */
  {"\x32", 0, 0x743B}, /* East Asian ideograph */
  {"\x36", 0, 0x7444}, /* East Asian ideograph */
  {"\x40", 0, 0x7447}, /* East Asian ideograph */
  {"\x43", 0, 0x7458}, /* East Asian ideograph */
  {"\x45", 0, 0x7442}, /* East Asian ideograph */
  {"\x47", 0, 0x744B}, /* East Asian ideograph */
  {"\x4A", 0, 0x744A}, /* East Asian ideograph */
  {"\x4F", 0, 0x7452}, /* East Asian ideograph */
  {"\x55", 0, 0x7457}, /* East Asian ideograph */
  {"\x56", 0, 0x7451}, /* East Asian ideograph */
  {"\x5A", 0, 0x745D}, /* East Asian ideograph */
  {"\x5B", 0, 0x7454}, /* East Asian ideograph */
  {"\x5D", 0, 0x7440}, /* East Asian ideograph */
  {"\x60", 0, 0x746D}, /* East Asian ideograph */
  {"\x61", 0, 0x7462}, /* East Asian ideograph */
  {"\x62", 0, 0x7473}, /* East Asian ideograph */
  {"\x68", 0, 0x7474}, /* East Asian ideograph */
  {"\x69", 0, 0x746E}, /* East Asian ideograph */
  {"\x6A", 0, 0x7471}, /* East Asian ideograph */
  {"\x6B", 0, 0x7468}, /* East Asian ideograph */
  {"\x78", 0, 0x7460}, /* East Asian ideograph */
  {"\x79", 0, 0x7472}, /* East Asian ideograph */
  {"\x7A", 0, 0x7484}, /* East Asian ideograph */
  {"\x7B", 0, 0x7487}, /* East Asian ideograph */
  {"\x7E", 0, 0x7488}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page139 = {
  marc8_31page139_flat, 0
};
/* PAGE 138 */
struct yaz_iconv_trie_flat marc8_31page138_flat[] = {
  {"\x21", 0, 0x73D3}, /* East Asian ideograph */
  {"\x27", 0, 0x73EA}, /* East Asian ideograph */
  {"\x28", 0, 0x73E5}, /* East Asian ideograph */
  {"\x2A", 0, 0x73D9}, /* East Asian ideograph */
  {"\x2B", 0, 0x73EF}, /* East Asian ideograph */
  {"\x2F", 0, 0x73D4}, /* East Asian ideograph */
  {"\x30", 0, 0x73DB}, /* East Asian ideograph */
  {"\x32", 0, 0x73D6}, /* East Asian ideograph */
  {"\x35", 0, 0x73BC}, /* East Asian ideograph */
  {"\x36", 0, 0x73E7}, /* East Asian ideograph */
  {"\x38", 0, 0x73E3}, /* East Asian ideograph */
  {"\x3A", 0, 0x73DE}, /* East Asian ideograph */
  {"\x3C", 0, 0x73E6}, /* East Asian ideograph */
  {"\x3F", 0, 0x73E9}, /* East Asian ideograph */
  {"\x45", 0, 0x73F6}, /* East Asian ideograph */
  {"\x47", 0, 0x73FA}, /* East Asian ideograph */
  {"\x4A", 0, 0x73F8}, /* East Asian ideograph */
  {"\x54", 0, 0x73F5}, /* East Asian ideograph */
  {"\x5A", 0, 0x73FD}, /* East Asian ideograph */
  {"\x5C", 0, 0x7407}, /* East Asian ideograph */
  {"\x5E", 0, 0x7412}, /* East Asian ideograph */
  {"\x63", 0, 0x743C}, /* East Asian ideograph */
  {"\x66", 0, 0x742E}, /* East Asian ideograph */
  {"\x67", 0, 0x742F}, /* East Asian ideograph */
  {"\x69", 0, 0x7414}, /* East Asian ideograph */
  {"\x6A", 0, 0x742C}, /* East Asian ideograph */
  {"\x6C", 0, 0x7430}, /* East Asian ideograph */
  {"\x6E", 0, 0x742B}, /* East Asian ideograph */
  {"\x70", 0, 0x73F7}, /* East Asian ideograph */
  {"\x71", 0, 0x741A}, /* East Asian ideograph */
  {"\x78", 0, 0x7416}, /* East Asian ideograph */
  {"\x7A", 0, 0x7426}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page138 = {
  marc8_31page138_flat, 0
};
/* PAGE 137 */
struct yaz_iconv_trie_flat marc8_31page137_flat[] = {
  {"\x21", 0, 0x734B}, /* East Asian ideograph */
  {"\x25", 0, 0x7367}, /* East Asian ideograph */
  {"\x29", 0, 0x736C}, /* East Asian ideograph */
  {"\x2B", 0, 0x736B}, /* East Asian ideograph */
  {"\x2F", 0, 0x736F}, /* East Asian ideograph */
  {"\x36", 0, 0x737C}, /* East Asian ideograph */
  {"\x38", 0, 0x737E}, /* East Asian ideograph */
  {"\x3B", 0, 0x7381}, /* East Asian ideograph */
  {"\x3F", 0, 0x7388}, /* East Asian ideograph */
  {"\x42", 0, 0x738E}, /* East Asian ideograph */
  {"\x46", 0, 0x7395}, /* East Asian ideograph */
  {"\x47", 0, 0x7392}, /* East Asian ideograph */
  {"\x48", 0, 0x7397}, /* East Asian ideograph */
  {"\x4C", 0, 0x7393}, /* East Asian ideograph */
  {"\x4D", 0, 0x7394}, /* East Asian ideograph */
  {"\x51", 0, 0x739E}, /* East Asian ideograph */
  {"\x52", 0, 0x73A6}, /* East Asian ideograph */
  {"\x5D", 0, 0x73A5}, /* East Asian ideograph */
  {"\x62", 0, 0x73A2}, /* East Asian ideograph */
  {"\x63", 0, 0x73A0}, /* East Asian ideograph */
  {"\x67", 0, 0x73B6}, /* East Asian ideograph */
  {"\x68", 0, 0x73CF}, /* East Asian ideograph */
  {"\x6A", 0, 0x73C2}, /* East Asian ideograph */
  {"\x6B", 0, 0x73D0}, /* East Asian ideograph */
  {"\x6F", 0, 0x73BF}, /* East Asian ideograph */
  {"\x70", 0, 0x73C8}, /* East Asian ideograph */
  {"\x7D", 0, 0x73CC}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page137 = {
  marc8_31page137_flat, 0
};
/* PAGE 136 */
struct yaz_iconv_trie_flat marc8_31page136_flat[] = {
  {"\x24", 0, 0x72F4}, /* East Asian ideograph */
  {"\x25", 0, 0x72FE}, /* East Asian ideograph */
  {"\x29", 0, 0x7302}, /* East Asian ideograph */
  {"\x2C", 0, 0x72FB}, /* East Asian ideograph */
  {"\x2D", 0, 0x7301}, /* East Asian ideograph */
  {"\x2E", 0, 0x72F3}, /* East Asian ideograph */
  {"\x31", 0, 0x731D}, /* East Asian ideograph */
  {"\x35", 0, 0x730B}, /* East Asian ideograph */
  {"\x36", 0, 0x7317}, /* East Asian ideograph */
  {"\x3B", 0, 0x7307}, /* East Asian ideograph */
  {"\x3E", 0, 0x7318}, /* East Asian ideograph */
  {"\x42", 0, 0x731E}, /* East Asian ideograph */
  {"\x46", 0, 0x7331}, /* East Asian ideograph */
  {"\x49", 0, 0x7338}, /* East Asian ideograph */
  {"\x4A", 0, 0x7322}, /* East Asian ideograph */
  {"\x4C", 0, 0x7332}, /* East Asian ideograph */
  {"\x4D", 0, 0x732C}, /* East Asian ideograph */
  {"\x4E", 0, 0x7327}, /* East Asian ideograph */
  {"\x4F", 0, 0x732B}, /* East Asian ideograph */
  {"\x52", 0, 0x732F}, /* East Asian ideograph */
  {"\x55", 0, 0x7328}, /* East Asian ideograph */
  {"\x5A", 0, 0x7347}, /* East Asian ideograph */
  {"\x5B", 0, 0x7348}, /* East Asian ideograph */
  {"\x5C", 0, 0x7349}, /* East Asian ideograph */
  {"\x5F", 0, 0x733B}, /* East Asian ideograph */
  {"\x62", 0, 0x733A}, /* East Asian ideograph */
  {"\x65", 0, 0x7340}, /* East Asian ideograph */
  {"\x68", 0, 0x734D}, /* East Asian ideograph */
  {"\x6B", 0, 0x7352}, /* East Asian ideograph */
  {"\x72", 0, 0x735E}, /* East Asian ideograph */
  {"\x74", 0, 0x735D}, /* East Asian ideograph */
  {"\x79", 0, 0x7360}, /* East Asian ideograph */
  {"\x7B", 0, 0x7358}, /* East Asian ideograph */
  {"\x7E", 0, 0x7362}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page136 = {
  marc8_31page136_flat, 0
};
/* PAGE 135 */
struct yaz_iconv_trie_flat marc8_31page135_flat[] = {
  {"\x22", 0, 0x728D}, /* East Asian ideograph */
  {"\x28", 0, 0x728F}, /* East Asian ideograph */
  {"\x48", 0, 0x72A8}, /* East Asian ideograph */
  {"\x4C", 0, 0x72AB}, /* East Asian ideograph */
  {"\x4E", 0, 0x72B0}, /* East Asian ideograph */
  {"\x4F", 0, 0x72B4}, /* East Asian ideograph */
  {"\x51", 0, 0x72C6}, /* East Asian ideograph */
  {"\x52", 0, 0x72B5}, /* East Asian ideograph */
  {"\x56", 0, 0x72BC}, /* East Asian ideograph */
  {"\x58", 0, 0x72C3}, /* East Asian ideograph */
  {"\x5B", 0, 0x72C1}, /* East Asian ideograph */
  {"\x60", 0, 0x72D6}, /* East Asian ideograph */
  {"\x64", 0, 0x72D2}, /* East Asian ideograph */
  {"\x67", 0, 0x72C9}, /* East Asian ideograph */
  {"\x6C", 0, 0x72CC}, /* East Asian ideograph */
  {"\x6E", 0, 0x72DB}, /* East Asian ideograph */
  {"\x6F", 0, 0x72CD}, /* East Asian ideograph */
  {"\x73", 0, 0x72E8}, /* East Asian ideograph */
  {"\x76", 0, 0x72EB}, /* East Asian ideograph */
  {"\x79", 0, 0x72E5}, /* East Asian ideograph */
  {"\x7E", 0, 0x72FA}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page135 = {
  marc8_31page135_flat, 0
};
/* PAGE 134 */
struct yaz_iconv_trie_flat marc8_31page134_flat[] = {
  {"\x21", 0, 0x721D}, /* East Asian ideograph */
  {"\x29", 0, 0x7225}, /* East Asian ideograph */
  {"\x2A", 0, 0x7226}, /* East Asian ideograph */
  {"\x41", 0, 0x723F}, /* East Asian ideograph */
  {"\x43", 0, 0x7241}, /* East Asian ideograph */
  {"\x44", 0, 0x7242}, /* East Asian ideograph */
  {"\x4F", 0, 0x7250}, /* East Asian ideograph */
  {"\x51", 0, 0x724F}, /* East Asian ideograph */
  {"\x52", 0, 0x7253}, /* East Asian ideograph */
  {"\x53", 0, 0x7255}, /* East Asian ideograph */
  {"\x56", 0, 0x725A}, /* East Asian ideograph */
  {"\x59", 0, 0x7263}, /* East Asian ideograph */
  {"\x61", 0, 0x7273}, /* East Asian ideograph */
  {"\x63", 0, 0x726E}, /* East Asian ideograph */
  {"\x66", 0, 0x7276}, /* East Asian ideograph */
  {"\x68", 0, 0x7277}, /* East Asian ideograph */
  {"\x6B", 0, 0x727E}, /* East Asian ideograph */
  {"\x6D", 0, 0x727C}, /* East Asian ideograph */
  {"\x71", 0, 0x727F}, /* East Asian ideograph */
  {"\x74", 0, 0x7289}, /* East Asian ideograph */
  {"\x7C", 0, 0x728B}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page134 = {
  marc8_31page134_flat, 0
};
/* PAGE 133 */
struct yaz_iconv_trie_flat marc8_31page133_flat[] = {
  {"\x21", 0, 0x71DD}, /* East Asian ideograph */
  {"\x22", 0, 0x71C0}, /* East Asian ideograph */
  {"\x24", 0, 0x71C1}, /* East Asian ideograph */
  {"\x26", 0, 0x71D4}, /* East Asian ideograph */
  {"\x29", 0, 0x71CB}, /* East Asian ideograph */
  {"\x2A", 0, 0x71DE}, /* East Asian ideograph */
  {"\x32", 0, 0x71EB}, /* East Asian ideograph */
  {"\x36", 0, 0x71E8}, /* East Asian ideograph */
  {"\x3A", 0, 0x71F5}, /* East Asian ideograph */
  {"\x3D", 0, 0x71F3}, /* East Asian ideograph */
  {"\x3F", 0, 0x71E1}, /* East Asian ideograph */
  {"\x47", 0, 0x71E0}, /* East Asian ideograph */
  {"\x4B", 0, 0x720C}, /* East Asian ideograph */
  {"\x4F", 0, 0x71FC}, /* East Asian ideograph */
  {"\x56", 0, 0x71F9}, /* East Asian ideograph */
  {"\x5B", 0, 0x720E}, /* East Asian ideograph */
  {"\x5C", 0, 0x5911}, /* East Asian ideograph */
  {"\x5E", 0, 0x720A}, /* East Asian ideograph */
  {"\x60", 0, 0x7217}, /* East Asian ideograph */
  {"\x61", 0, 0x7207}, /* East Asian ideograph */
  {"\x66", 0, 0x7215}, /* East Asian ideograph */
  {"\x69", 0, 0x7213}, /* East Asian ideograph */
  {"\x6E", 0, 0x7218}, /* East Asian ideograph */
  {"\x71", 0, 0x720B}, /* East Asian ideograph */
  {"\x79", 0, 0x721A}, /* East Asian ideograph */
  {"\x7D", 0, 0x721F}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page133 = {
  marc8_31page133_flat, 0
};
/* PAGE 132 */
struct yaz_iconv_trie_flat marc8_31page132_flat[] = {
  {"\x23", 0, 0x7192}, /* East Asian ideograph */
  {"\x2B", 0, 0x7180}, /* East Asian ideograph */
  {"\x2C", 0, 0x7189}, /* East Asian ideograph */
  {"\x32", 0, 0x7185}, /* East Asian ideograph */
  {"\x33", 0, 0x7196}, /* East Asian ideograph */
  {"\x36", 0, 0x717C}, /* East Asian ideograph */
  {"\x39", 0, 0x7198}, /* East Asian ideograph */
  {"\x3C", 0, 0x7197}, /* East Asian ideograph */
  {"\x3E", 0, 0x71B5}, /* East Asian ideograph */
  {"\x3F", 0, 0x71A9}, /* East Asian ideograph */
  {"\x42", 0, 0x71A5}, /* East Asian ideograph */
  {"\x46", 0, 0x719E}, /* East Asian ideograph */
  {"\x47", 0, 0x71B2}, /* East Asian ideograph */
  {"\x4A", 0, 0x719B}, /* East Asian ideograph */
  {"\x4E", 0, 0x71AF}, /* East Asian ideograph */
  {"\x51", 0, 0x71A4}, /* East Asian ideograph */
  {"\x52", 0, 0x71A0}, /* East Asian ideograph */
  {"\x55", 0, 0x719A}, /* East Asian ideograph */
  {"\x57", 0, 0x71B3}, /* East Asian ideograph */
  {"\x59", 0, 0x71B4}, /* East Asian ideograph */
  {"\x67", 0, 0x71D1}, /* East Asian ideograph */
  {"\x69", 0, 0x71C7}, /* East Asian ideograph */
  {"\x6A", 0, 0x71B7}, /* East Asian ideograph */
  {"\x6D", 0, 0x71CA}, /* East Asian ideograph */
  {"\x6F", 0, 0x71CF}, /* East Asian ideograph */
  {"\x70", 0, 0x71D6}, /* East Asian ideograph */
  {"\x72", 0, 0x71BA}, /* East Asian ideograph */
  {"\x75", 0, 0x71C2}, /* East Asian ideograph */
  {"\x77", 0, 0x71C5}, /* East Asian ideograph */
  {"\x7A", 0, 0x71BF}, /* East Asian ideograph */
  {"\x7C", 0, 0x71B8}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page132 = {
  marc8_31page132_flat, 0
};
/* PAGE 131 */
struct yaz_iconv_trie_flat marc8_31page131_flat[] = {
  {"\x27", 0, 0x7139}, /* East Asian ideograph */
  {"\x28", 0, 0x7135}, /* East Asian ideograph */
  {"\x2C", 0, 0x713B}, /* East Asian ideograph */
  {"\x2E", 0, 0x711C}, /* East Asian ideograph */
  {"\x32", 0, 0x713D}, /* East Asian ideograph */
  {"\x35", 0, 0x712F}, /* East Asian ideograph */
  {"\x3B", 0, 0x7129}, /* East Asian ideograph */
  {"\x43", 0, 0x712E}, /* East Asian ideograph */
  {"\x48", 0, 0x7177}, /* East Asian ideograph */
  {"\x51", 0, 0x7146}, /* East Asian ideograph */
  {"\x52", 0, 0x7152}, /* East Asian ideograph */
  {"\x54", 0, 0x714F}, /* East Asian ideograph */
  {"\x55", 0, 0x715D}, /* East Asian ideograph */
  {"\x56", 0, 0x7141}, /* East Asian ideograph */
  {"\x57", 0, 0x7160}, /* East Asian ideograph */
  {"\x59", 0, 0x7175}, /* East Asian ideograph */
  {"\x5A", 0, 0x7173}, /* East Asian ideograph */
  {"\x5C", 0, 0x7143}, /* East Asian ideograph */
  {"\x5D", 0, 0x715A}, /* East Asian ideograph */
  {"\x5E", 0, 0x7176}, /* East Asian ideograph */
  {"\x60", 0, 0x714B}, /* East Asian ideograph */
  {"\x62", 0, 0x7147}, /* East Asian ideograph */
  {"\x65", 0, 0x7168}, /* East Asian ideograph */
  {"\x66", 0, 0x7171}, /* East Asian ideograph */
  {"\x67", 0, 0x715F}, /* East Asian ideograph */
  {"\x69", 0, 0x7150}, /* East Asian ideograph */
  {"\x6B", 0, 0x7153}, /* East Asian ideograph */
  {"\x70", 0, 0x7144}, /* East Asian ideograph */
  {"\x76", 0, 0x7172}, /* East Asian ideograph */
  {"\x78", 0, 0x7178}, /* East Asian ideograph */
  {"\x7B", 0, 0x7187}, /* East Asian ideograph */
  {"\x7C", 0, 0x717B}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page131 = {
  marc8_31page131_flat, 0
};
/* PAGE 130 */
struct yaz_iconv_trie_flat marc8_31page130_flat[] = {
  {"\x22", 0, 0x70DD}, /* East Asian ideograph */
  {"\x23", 0, 0x70E1}, /* East Asian ideograph */
  {"\x26", 0, 0x70E3}, /* East Asian ideograph */
  {"\x28", 0, 0x70E0}, /* East Asian ideograph */
  {"\x2B", 0, 0x70D4}, /* East Asian ideograph */
  {"\x2E", 0, 0x70D1}, /* East Asian ideograph */
  {"\x38", 0, 0x70CB}, /* East Asian ideograph */
  {"\x3A", 0, 0x70D0}, /* East Asian ideograph */
  {"\x3B", 0, 0x70C7}, /* East Asian ideograph */
  {"\x3C", 0, 0x70DA}, /* East Asian ideograph */
  {"\x3D", 0, 0x70C6}, /* East Asian ideograph */
  {"\x3F", 0, 0x70FA}, /* East Asian ideograph */
  {"\x42", 0, 0x70F7}, /* East Asian ideograph */
  {"\x44", 0, 0x7104}, /* East Asian ideograph */
  {"\x48", 0, 0x70F3}, /* East Asian ideograph */
  {"\x4A", 0, 0x7110}, /* East Asian ideograph */
  {"\x4C", 0, 0x7103}, /* East Asian ideograph */
  {"\x50", 0, 0x70F4}, /* East Asian ideograph */
  {"\x55", 0, 0x7111}, /* East Asian ideograph */
  {"\x56", 0, 0x7112}, /* East Asian ideograph */
  {"\x5C", 0, 0x710C}, /* East Asian ideograph */
  {"\x60", 0, 0x70F6}, /* East Asian ideograph */
  {"\x66", 0, 0x7113}, /* East Asian ideograph */
  {"\x67", 0, 0x70EF}, /* East Asian ideograph */
  {"\x68", 0, 0x7100}, /* East Asian ideograph */
  {"\x6C", 0, 0x711E}, /* East Asian ideograph */
  {"\x6D", 0, 0x7134}, /* East Asian ideograph */
  {"\x6E", 0, 0x7120}, /* East Asian ideograph */
  {"\x6F", 0, 0x713F}, /* East Asian ideograph */
  {"\x74", 0, 0x7131}, /* East Asian ideograph */
  {"\x75", 0, 0x712D}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page130 = {
  marc8_31page130_flat, 0
};
/* PAGE 129 */
struct yaz_iconv_trie_flat marc8_31page129_flat[] = {
  {"\x21", 0, 0x9E02}, /* East Asian ideograph */
  {"\x25", 0, 0x7066}, /* East Asian ideograph */
  {"\x27", 0, 0x7065}, /* East Asian ideograph */
  {"\x28", 0, 0x7068}, /* East Asian ideograph */
  {"\x29", 0, 0x7054}, /* East Asian ideograph */
  {"\x39", 0, 0x7074}, /* East Asian ideograph */
  {"\x3B", 0, 0x707A}, /* East Asian ideograph */
  {"\x40", 0, 0x7093}, /* East Asian ideograph */
  {"\x42", 0, 0x7086}, /* East Asian ideograph */
  {"\x48", 0, 0x7096}, /* East Asian ideograph */
  {"\x49", 0, 0x7084}, /* East Asian ideograph */
  {"\x4A", 0, 0x7081}, /* East Asian ideograph */
  {"\x56", 0, 0x7088}, /* East Asian ideograph */
  {"\x57", 0, 0x7098}, /* East Asian ideograph */
  {"\x59", 0, 0x708C}, /* East Asian ideograph */
  {"\x5C", 0, 0x70B7}, /* East Asian ideograph */
  {"\x62", 0, 0x70A1}, /* East Asian ideograph */
  {"\x63", 0, 0x70A3}, /* East Asian ideograph */
  {"\x68", 0, 0x7551}, /* East Asian ideograph */
  {"\x6F", 0, 0x70A7}, /* East Asian ideograph */
  {"\x70", 0, 0x79CC}, /* East Asian ideograph */
  {"\x71", 0, 0x70B5}, /* East Asian ideograph */
  {"\x72", 0, 0x70BF}, /* East Asian ideograph */
  {"\x73", 0, 0x70A9}, /* East Asian ideograph */
  {"\x78", 0, 0x70EA}, /* East Asian ideograph */
  {"\x7B", 0, 0x70E5}, /* East Asian ideograph */
  {"\x7C", 0, 0x70DC}, /* East Asian ideograph */
  {"\x7D", 0, 0x70D3}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page129 = {
  marc8_31page129_flat, 0
};
/* PAGE 128 */
struct yaz_iconv_trie_flat marc8_31page128_flat[] = {
  {"\x24", 0, 0x7020}, /* East Asian ideograph */
  {"\x26", 0, 0x7027}, /* East Asian ideograph */
  {"\x2B", 0, 0x701E}, /* East Asian ideograph (variant of EACC 4C4F2B) */
  {"\x2F", 0, 0x702E}, /* East Asian ideograph */
  {"\x31", 0, 0x702D}, /* East Asian ideograph */
  {"\x35", 0, 0x7021}, /* East Asian ideograph */
  {"\x39", 0, 0x7018}, /* East Asian ideograph */
  {"\x3A", 0, 0x7023}, /* East Asian ideograph */
  {"\x41", 0, 0x703C}, /* East Asian ideograph */
  {"\x44", 0, 0x7035}, /* East Asian ideograph */
  {"\x51", 0, 0x7034}, /* East Asian ideograph */
  {"\x53", 0, 0x7039}, /* East Asian ideograph */
  {"\x54", 0, 0x703A}, /* East Asian ideograph */
  {"\x5D", 0, 0x7043}, /* East Asian ideograph */
  {"\x61", 0, 0x7044}, /* East Asian ideograph */
  {"\x67", 0, 0x7047}, /* East Asian ideograph */
  {"\x69", 0, 0x7049}, /* East Asian ideograph */
  {"\x6B", 0, 0x7055}, /* East Asian ideograph */
  {"\x71", 0, 0x7052}, /* East Asian ideograph */
  {"\x73", 0, 0x705C}, /* East Asian ideograph */
  {"\x78", 0, 0x7059}, /* East Asian ideograph */
  {"\x7B", 0, 0x705E}, /* East Asian ideograph */
  {"\x7C", 0, 0x7061}, /* East Asian ideograph */
  {"\x7D", 0, 0x705D}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page128 = {
  marc8_31page128_flat, 0
};
/* PAGE 127 */
struct yaz_iconv_trie_flat marc8_31page127_flat[] = {
  {"\x21", 0, 0x6FAA}, /* East Asian ideograph */
  {"\x25", 0, 0x6FBF}, /* East Asian ideograph */
  {"\x26", 0, 0x6FC7}, /* East Asian ideograph */
  {"\x2D", 0, 0x6FC9}, /* East Asian ideograph */
  {"\x2E", 0, 0x6F5E}, /* East Asian ideograph */
  {"\x2F", 0, 0x6FC8}, /* East Asian ideograph */
  {"\x30", 0, 0x6FA0}, /* East Asian ideograph */
  {"\x32", 0, 0x6FCA}, /* East Asian ideograph */
  {"\x35", 0, 0x6FB4}, /* East Asian ideograph */
  {"\x37", 0, 0x6FAF}, /* East Asian ideograph */
  {"\x3C", 0, 0x6FA8}, /* East Asian ideograph */
  {"\x40", 0, 0x6FA5}, /* East Asian ideograph */
  {"\x41", 0, 0x6FB0}, /* East Asian ideograph */
  {"\x42", 0, 0x6FAE}, /* East Asian ideograph */
  {"\x43", 0, 0x6FD9}, /* East Asian ideograph */
  {"\x44", 0, 0x6FDA}, /* East Asian ideograph */
  {"\x50", 0, 0x6FD4}, /* East Asian ideograph */
  {"\x56", 0, 0x6FE9}, /* East Asian ideograph */
  {"\x57", 0, 0x6FF8}, /* East Asian ideograph */
  {"\x5D", 0, 0x6FDE}, /* East Asian ideograph */
  {"\x5E", 0, 0x6FEE}, /* East Asian ideograph */
  {"\x62", 0, 0x6FF0}, /* East Asian ideograph */
  {"\x66", 0, 0x7005}, /* East Asian ideograph */
  {"\x67", 0, 0x700C}, /* East Asian ideograph */
  {"\x6A", 0, 0x700D}, /* East Asian ideograph */
  {"\x72", 0, 0x7026}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page127 = {
  marc8_31page127_flat, 0
};
/* PAGE 126 */
struct yaz_iconv_trie_flat marc8_31page126_flat[] = {
  {"\x23", 0, 0x6F7E}, /* East Asian ideograph */
  {"\x24", 0, 0x6F9D}, /* East Asian ideograph */
  {"\x27", 0, 0x6F87}, /* East Asian ideograph */
  {"\x2B", 0, 0x6F6F}, /* East Asian ideograph */
  {"\x2F", 0, 0x6F5A}, /* East Asian ideograph */
  {"\x30", 0, 0x6F60}, /* East Asian ideograph */
  {"\x35", 0, 0x6F90}, /* East Asian ideograph */
  {"\x37", 0, 0x6F8D}, /* East Asian ideograph */
  {"\x39", 0, 0x6F92}, /* East Asian ideograph */
  {"\x3A", 0, 0x6F89}, /* East Asian ideograph */
  {"\x3C", 0, 0x6F8C}, /* East Asian ideograph */
  {"\x3D", 0, 0x6F62}, /* East Asian ideograph (variant of EACC 4C4D3D) */
  {"\x44", 0, 0x6F0B}, /* East Asian ideograph */
  {"\x4B", 0, 0x6F6C}, /* East Asian ideograph */
  {"\x4D", 0, 0x6F8B}, /* East Asian ideograph */
  {"\x58", 0, 0x6E88}, /* East Asian ideograph */
  {"\x5A", 0, 0x6F55}, /* East Asian ideograph */
  {"\x5F", 0, 0x6F72}, /* East Asian ideograph */
  {"\x62", 0, 0x6F57}, /* East Asian ideograph */
  {"\x63", 0, 0x6F5F}, /* East Asian ideograph */
  {"\x68", 0, 0x6F5D}, /* East Asian ideograph */
  {"\x73", 0, 0x6FB6}, /* East Asian ideograph */
  {"\x74", 0, 0x6F9F}, /* East Asian ideograph */
  {"\x79", 0, 0x6FA6}, /* East Asian ideograph */
  {"\x7C", 0, 0x6FC6}, /* East Asian ideograph */
  {"\x7D", 0, 0x6FBC}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page126 = {
  marc8_31page126_flat, 0
};
/* PAGE 125 */
struct yaz_iconv_trie_flat marc8_31page125_flat[] = {
  {"\x21", 0, 0x6EC3}, /* East Asian ideograph */
  {"\x24", 0, 0x6EB4}, /* East Asian ideograph */
  {"\x26", 0, 0x6EB2}, /* East Asian ideograph */
  {"\x29", 0, 0x6EB5}, /* East Asian ideograph */
  {"\x2E", 0, 0x6EF8}, /* East Asian ideograph */
  {"\x30", 0, 0x6F37}, /* East Asian ideograph */
  {"\x34", 0, 0x6EFD}, /* East Asian ideograph */
  {"\x35", 0, 0x6F09}, /* East Asian ideograph */
  {"\x3C", 0, 0x6F3B}, /* East Asian ideograph */
  {"\x3D", 0, 0x6F63}, /* East Asian ideograph */
  {"\x3E", 0, 0x6F12}, /* East Asian ideograph */
  {"\x3F", 0, 0x6F26}, /* East Asian ideograph */
  {"\x41", 0, 0x6F1A}, /* East Asian ideograph */
  {"\x42", 0, 0x6EF6}, /* East Asian ideograph */
  {"\x43", 0, 0x6F19}, /* East Asian ideograph */
  {"\x44", 0, 0x6F00}, /* East Asian ideograph */
  {"\x4B", 0, 0x6F24}, /* East Asian ideograph */
  {"\x51", 0, 0x6F18}, /* East Asian ideograph */
  {"\x57", 0, 0x6F1F}, /* East Asian ideograph */
  {"\x5A", 0, 0x6F0A}, /* East Asian ideograph */
  {"\x5E", 0, 0x6F36}, /* East Asian ideograph */
  {"\x60", 0, 0x6EF9}, /* East Asian ideograph */
  {"\x61", 0, 0x6EEE}, /* East Asian ideograph */
  {"\x62", 0, 0x6F41}, /* East Asian ideograph */
  {"\x64", 0, 0x6F95}, /* East Asian ideograph */
  {"\x65", 0, 0x6F2D}, /* East Asian ideograph */
  {"\x67", 0, 0x6F34}, /* East Asian ideograph */
  {"\x6B", 0, 0x6F49}, /* East Asian ideograph */
  {"\x6D", 0, 0x6F30}, /* East Asian ideograph */
  {"\x76", 0, 0x6EFA}, /* East Asian ideograph */
  {"\x77", 0, 0x6EEB}, /* East Asian ideograph */
  {"\x78", 0, 0x6F08}, /* East Asian ideograph */
  {"\x79", 0, 0x6F0E}, /* East Asian ideograph */
  {"\x7B", 0, 0x6F35}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page125 = {
  marc8_31page125_flat, 0
};
/* PAGE 124 */
struct yaz_iconv_trie_flat marc8_31page124_flat[] = {
  {"\x22", 0, 0x6E28}, /* East Asian ideograph */
  {"\x24", 0, 0x6E5C}, /* East Asian ideograph */
  {"\x26", 0, 0x6E31}, /* East Asian ideograph */
  {"\x28", 0, 0x6E5E}, /* East Asian ideograph */
  {"\x2C", 0, 0x6E84}, /* East Asian ideograph */
  {"\x2E", 0, 0x6E2E}, /* East Asian ideograph */
  {"\x30", 0, 0x6E36}, /* East Asian ideograph */
  {"\x31", 0, 0x6E5D}, /* East Asian ideograph */
  {"\x32", 0, 0x6E72}, /* East Asian ideograph */
  {"\x33", 0, 0x6E30}, /* East Asian ideograph */
  {"\x34", 0, 0x6E53}, /* East Asian ideograph */
  {"\x36", 0, 0x6E39}, /* East Asian ideograph */
  {"\x37", 0, 0x6E71}, /* East Asian ideograph */
  {"\x38", 0, 0x6E69}, /* East Asian ideograph */
  {"\x39", 0, 0x6E6B}, /* East Asian ideograph */
  {"\x3B", 0, 0x6E8B}, /* East Asian ideograph */
  {"\x3E", 0, 0x6E76}, /* East Asian ideograph */
  {"\x40", 0, 0x6E2A}, /* East Asian ideograph */
  {"\x41", 0, 0x6E4C}, /* East Asian ideograph */
  {"\x42", 0, 0x6E22}, /* East Asian ideograph */
  {"\x43", 0, 0x6ECE}, /* East Asian ideograph */
  {"\x45", 0, 0x6E9B}, /* East Asian ideograph */
  {"\x46", 0, 0x6E9F}, /* East Asian ideograph */
  {"\x48", 0, 0x6EC8}, /* East Asian ideograph */
  {"\x49", 0, 0x6ED8}, /* East Asian ideograph */
  {"\x4A", 0, 0x6E8F}, /* East Asian ideograph */
  {"\x4D", 0, 0x6E93}, /* East Asian ideograph */
  {"\x4F", 0, 0x6EA0}, /* East Asian ideograph */
  {"\x51", 0, 0x6EB1}, /* East Asian ideograph */
  {"\x57", 0, 0x6EA8}, /* East Asian ideograph */
  {"\x59", 0, 0x6E92}, /* East Asian ideograph */
  {"\x5A", 0, 0x6EA7}, /* East Asian ideograph */
  {"\x5E", 0, 0x6E8E}, /* East Asian ideograph */
  {"\x60", 0, 0x6ED9}, /* East Asian ideograph */
  {"\x61", 0, 0x6EBD}, /* East Asian ideograph */
  {"\x63", 0, 0x6EC1}, /* East Asian ideograph */
  {"\x69", 0, 0x6EBB}, /* East Asian ideograph */
  {"\x6A", 0, 0x6EC9}, /* East Asian ideograph */
  {"\x6C", 0, 0x6EB3}, /* East Asian ideograph */
  {"\x6D", 0, 0x6EB7}, /* East Asian ideograph */
  {"\x75", 0, 0x6EA4}, /* East Asian ideograph */
  {"\x79", 0, 0x6ECF}, /* East Asian ideograph */
  {"\x7C", 0, 0x6ECA}, /* East Asian ideograph */
  {"\x7D", 0, 0x6ED5}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page124 = {
  marc8_31page124_flat, 0
};
/* PAGE 123 */
struct yaz_iconv_trie_flat marc8_31page123_flat[] = {
  {"\x2A", 0, 0x6DDF}, /* East Asian ideograph */
  {"\x2D", 0, 0x6DD3}, /* East Asian ideograph */
  {"\x32", 0, 0x6DFC}, /* East Asian ideograph */
  {"\x35", 0, 0x6DDD}, /* East Asian ideograph */
  {"\x36", 0, 0x6DDC}, /* East Asian ideograph */
  {"\x39", 0, 0x6DDB}, /* East Asian ideograph */
  {"\x3D", 0, 0x6DA4}, /* East Asian ideograph */
  {"\x44", 0, 0x6E12}, /* East Asian ideograph */
  {"\x46", 0, 0x6DF0}, /* East Asian ideograph */
  {"\x4A", 0, 0x6DE6}, /* East Asian ideograph */
  {"\x4C", 0, 0x6E1F}, /* East Asian ideograph */
  {"\x50", 0, 0x6E27}, /* East Asian ideograph */
  {"\x55", 0, 0x6E49}, /* East Asian ideograph */
  {"\x58", 0, 0x6E3C}, /* East Asian ideograph */
  {"\x60", 0, 0x6E8A}, /* East Asian ideograph */
  {"\x62", 0, 0x6E4B}, /* East Asian ideograph */
  {"\x66", 0, 0x6E62}, /* East Asian ideograph */
  {"\x6A", 0, 0x6E51}, /* East Asian ideograph */
  {"\x6B", 0, 0x6E44}, /* East Asian ideograph */
  {"\x6D", 0, 0x6E63}, /* East Asian ideograph */
  {"\x71", 0, 0x6E73}, /* East Asian ideograph */
  {"\x74", 0, 0x6E4F}, /* East Asian ideograph */
  {"\x77", 0, 0x6E4E}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page123 = {
  marc8_31page123_flat, 0
};
/* PAGE 122 */
struct yaz_iconv_trie_flat marc8_31page122_flat[] = {
  {"\x25", 0, 0x6D6D}, /* East Asian ideograph */
  {"\x26", 0, 0x6D6F}, /* East Asian ideograph */
  {"\x28", 0, 0x6D61}, /* East Asian ideograph */
  {"\x29", 0, 0x6D91}, /* East Asian ideograph */
  {"\x2C", 0, 0x6D81}, /* East Asian ideograph */
  {"\x2E", 0, 0x6D8A}, /* East Asian ideograph */
  {"\x2F", 0, 0x6D34}, /* East Asian ideograph (variant of EACC 34492F) */
  {"\x34", 0, 0x6D79}, /* East Asian ideograph */
  {"\x35", 0, 0x6DEF}, /* East Asian ideograph */
  {"\x39", 0, 0x6D7F}, /* East Asian ideograph */
  {"\x3B", 0, 0x6D85}, /* East Asian ideograph */
  {"\x3C", 0, 0x6D65}, /* East Asian ideograph */
  {"\x3E", 0, 0x6D5E}, /* East Asian ideograph */
  {"\x40", 0, 0x6D67}, /* East Asian ideograph */
  {"\x43", 0, 0x6D94}, /* East Asian ideograph */
  {"\x46", 0, 0x6D60}, /* East Asian ideograph */
  {"\x48", 0, 0x6D98}, /* East Asian ideograph */
  {"\x4B", 0, 0x6D7C}, /* East Asian ideograph */
  {"\x4C", 0, 0x6D70}, /* East Asian ideograph */
  {"\x4F", 0, 0x6D96}, /* East Asian ideograph */
  {"\x59", 0, 0x6DAB}, /* East Asian ideograph */
  {"\x5A", 0, 0x6DB4}, /* East Asian ideograph */
  {"\x5C", 0, 0x6DAA}, /* East Asian ideograph */
  {"\x60", 0, 0x6DEC}, /* East Asian ideograph */
  {"\x6A", 0, 0x6DAC}, /* East Asian ideograph */
  {"\x6B", 0, 0x6DB7}, /* East Asian ideograph */
  {"\x6C", 0, 0x6DE2}, /* East Asian ideograph */
  {"\x6D", 0, 0x6DD5}, /* East Asian ideograph */
  {"\x6E", 0, 0x6DE9}, /* East Asian ideograph */
  {"\x71", 0, 0x6DF6}, /* East Asian ideograph */
  {"\x79", 0, 0x6E0F}, /* East Asian ideograph */
  {"\x7B", 0, 0x6DBF}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page122 = {
  marc8_31page122_flat, 0
};
/* PAGE 121 */
struct yaz_iconv_trie_flat marc8_31page121_flat[] = {
  {"\x24", 0, 0x6CD8}, /* East Asian ideograph */
  {"\x26", 0, 0x6CC6}, /* East Asian ideograph */
  {"\x28", 0, 0x6CCE}, /* East Asian ideograph */
  {"\x29", 0, 0x6CE9}, /* East Asian ideograph */
  {"\x2D", 0, 0x6CF2}, /* East Asian ideograph */
  {"\x2F", 0, 0x6CE0}, /* East Asian ideograph */
  {"\x30", 0, 0x6CD1}, /* East Asian ideograph */
  {"\x32", 0, 0x6CD2}, /* East Asian ideograph */
  {"\x33", 0, 0x6CB4}, /* East Asian ideograph */
  {"\x37", 0, 0x6D1D}, /* East Asian ideograph */
  {"\x3B", 0, 0x6D28}, /* East Asian ideograph */
  {"\x44", 0, 0x6D39}, /* East Asian ideograph */
  {"\x4D", 0, 0x6D26}, /* East Asian ideograph */
  {"\x4E", 0, 0x6D27}, /* East Asian ideograph */
  {"\x4F", 0, 0x6D0F}, /* East Asian ideograph */
  {"\x50", 0, 0x6D0A}, /* East Asian ideograph */
  {"\x51", 0, 0x6D3F}, /* East Asian ideograph */
  {"\x5A", 0, 0x6D07}, /* East Asian ideograph */
  {"\x5B", 0, 0x6D04}, /* East Asian ideograph */
  {"\x5C", 0, 0x6CDA}, /* East Asian ideograph */
  {"\x60", 0, 0x6D2E}, /* East Asian ideograph */
  {"\x61", 0, 0x6D35}, /* East Asian ideograph */
  {"\x62", 0, 0x6D3A}, /* East Asian ideograph */
  {"\x64", 0, 0x6D19}, /* East Asian ideograph */
  {"\x67", 0, 0x6D0E}, /* East Asian ideograph */
  {"\x6A", 0, 0x6D2B}, /* East Asian ideograph */
  {"\x6B", 0, 0x6D11}, /* East Asian ideograph */
  {"\x6C", 0, 0x6D00}, /* East Asian ideograph */
  {"\x6D", 0, 0x6D24}, /* East Asian ideograph */
  {"\x6F", 0, 0x6D33}, /* East Asian ideograph */
  {"\x73", 0, 0x6D63}, /* East Asian ideograph */
  {"\x77", 0, 0x6DA5}, /* East Asian ideograph */
  {"\x7D", 0, 0x6D92}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page121 = {
  marc8_31page121_flat, 0
};
/* PAGE 120 */
struct yaz_iconv_trie_flat marc8_31page120_flat[] = {
  {"\x24", 0, 0x6C5C}, /* East Asian ideograph */
  {"\x26", 0, 0x6C5B}, /* East Asian ideograph */
  {"\x27", 0, 0x6C4D}, /* East Asian ideograph */
  {"\x2B", 0, 0x6C4B}, /* East Asian ideograph */
  {"\x2C", 0, 0x6C54}, /* East Asian ideograph */
  {"\x2D", 0, 0x6C63}, /* East Asian ideograph */
  {"\x30", 0, 0x6C78}, /* East Asian ideograph */
  {"\x31", 0, 0x6C74}, /* East Asian ideograph */
  {"\x32", 0, 0x6C86}, /* East Asian ideograph */
  {"\x33", 0, 0x6C76}, /* East Asian ideograph */
  {"\x38", 0, 0x6C6C}, /* East Asian ideograph */
  {"\x39", 0, 0x6C67}, /* East Asian ideograph */
  {"\x3B", 0, 0x6C84}, /* East Asian ideograph */
  {"\x3E", 0, 0x6C94}, /* East Asian ideograph */
  {"\x40", 0, 0x6C8F}, /* East Asian ideograph */
  {"\x42", 0, 0x6C65}, /* East Asian ideograph */
  {"\x47", 0, 0x6C6F}, /* East Asian ideograph */
  {"\x49", 0, 0x6C9D}, /* East Asian ideograph */
  {"\x4A", 0, 0x6C69}, /* East Asian ideograph */
  {"\x4B", 0, 0x6C9A}, /* East Asian ideograph */
  {"\x4C", 0, 0x6C6D}, /* East Asian ideograph */
  {"\x4D", 0, 0x6C93}, /* East Asian ideograph */
  {"\x51", 0, 0x6C87}, /* East Asian ideograph */
  {"\x52", 0, 0x6C6E}, /* East Asian ideograph */
  {"\x56", 0, 0x6C95}, /* East Asian ideograph */
  {"\x5A", 0, 0x6C82}, /* East Asian ideograph */
  {"\x5C", 0, 0x6CA0}, /* East Asian ideograph */
  {"\x62", 0, 0x6CEB}, /* East Asian ideograph */
  {"\x63", 0, 0x6CEE}, /* East Asian ideograph */
  {"\x64", 0, 0x6CC0}, /* East Asian ideograph */
  {"\x66", 0, 0x6CEF}, /* East Asian ideograph */
  {"\x67", 0, 0x6CAC}, /* East Asian ideograph */
  {"\x6E", 0, 0x6CAD}, /* East Asian ideograph (variant of EACC 4C476E) */
  {"\x70", 0, 0x6CAF}, /* East Asian ideograph */
  {"\x72", 0, 0x6CF5}, /* East Asian ideograph */
  {"\x7A", 0, 0x6CBA}, /* East Asian ideograph */
  {"\x7B", 0, 0x7553}, /* East Asian ideograph */
  {"\x7D", 0, 0x6CC2}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page120 = {
  marc8_31page120_flat, 0
};
/* PAGE 119 */
struct yaz_iconv_trie_flat marc8_31page119_flat[] = {
  {"\x2A", 0, 0x6BF6}, /* East Asian ideograph */
  {"\x2C", 0, 0x6BF3}, /* East Asian ideograph */
  {"\x33", 0, 0x6BF8}, /* East Asian ideograph */
  {"\x37", 0, 0x6BFA}, /* East Asian ideograph */
  {"\x38", 0, 0x6BF9}, /* East Asian ideograph */
  {"\x42", 0, 0x6BFF}, /* East Asian ideograph */
  {"\x44", 0, 0x6C06}, /* East Asian ideograph */
  {"\x48", 0, 0x6C04}, /* East Asian ideograph */
  {"\x4A", 0, 0x6C05}, /* East Asian ideograph */
  {"\x4C", 0, 0x6C08}, /* East Asian ideograph */
  {"\x51", 0, 0x6C0C}, /* East Asian ideograph */
  {"\x52", 0, 0x6C0D}, /* East Asian ideograph */
  {"\x59", 0, 0x6C15}, /* East Asian ideograph */
  {"\x5A", 0, 0x6C18}, /* East Asian ideograph */
  {"\x5B", 0, 0x6C19}, /* East Asian ideograph */
  {"\x5C", 0, 0x6C1A}, /* East Asian ideograph */
  {"\x5E", 0, 0x6C1D}, /* East Asian ideograph */
  {"\x60", 0, 0x6C20}, /* East Asian ideograph */
  {"\x62", 0, 0x6C21}, /* East Asian ideograph */
  {"\x64", 0, 0x6C2A}, /* East Asian ideograph */
  {"\x66", 0, 0x6C2D}, /* East Asian ideograph */
  {"\x67", 0, 0x6C30}, /* East Asian ideograph */
  {"\x68", 0, 0x6C2C}, /* East Asian ideograph */
  {"\x69", 0, 0x6C31}, /* East Asian ideograph */
  {"\x70", 0, 0x6C3B}, /* East Asian ideograph */
  {"\x74", 0, 0x6C3F}, /* East Asian ideograph */
  {"\x78", 0, 0x6C46}, /* East Asian ideograph */
  {"\x7A", 0, 0x6C52}, /* East Asian ideograph */
  {"\x7B", 0, 0x6C62}, /* East Asian ideograph */
  {"\x7C", 0, 0x6C4A}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page119 = {
  marc8_31page119_flat, 0
};
/* PAGE 118 */
struct yaz_iconv_trie_flat marc8_31page118_flat[] = {
  {"\x25", 0, 0x6B99}, /* East Asian ideograph */
  {"\x29", 0, 0x6B9B}, /* East Asian ideograph */
  {"\x35", 0, 0x6BA3}, /* East Asian ideograph */
  {"\x36", 0, 0x6BA2}, /* East Asian ideograph */
  {"\x38", 0, 0x6BAA}, /* East Asian ideograph */
  {"\x39", 0, 0x6BAB}, /* East Asian ideograph */
  {"\x3B", 0, 0x6BAD}, /* East Asian ideograph */
  {"\x3D", 0, 0x6BB0}, /* East Asian ideograph */
  {"\x3F", 0, 0x6BB3}, /* East Asian ideograph */
  {"\x47", 0, 0x6BBD}, /* East Asian ideograph */
  {"\x4D", 0, 0x6996}, /* East Asian ideograph */
  {"\x54", 0, 0x6BC8}, /* East Asian ideograph */
  {"\x5B", 0, 0x6BD6}, /* East Asian ideograph */
  {"\x60", 0, 0x6BDA}, /* East Asian ideograph */
  {"\x62", 0, 0x6BDC}, /* East Asian ideograph */
  {"\x63", 0, 0x6BDD}, /* East Asian ideograph */
  {"\x65", 0, 0x6BDF}, /* East Asian ideograph */
  {"\x6F", 0, 0x6BE7}, /* East Asian ideograph */
  {"\x70", 0, 0x6BEA}, /* East Asian ideograph */
  {"\x71", 0, 0x6BE8}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page118 = {
  marc8_31page118_flat, 0
};
/* PAGE 117 */
struct yaz_iconv_trie_flat marc8_31page117_flat[] = {
  {"\x2A", 0, 0x6B35}, /* East Asian ideograph */
  {"\x2C", 0, 0x6B37}, /* East Asian ideograph */
  {"\x2D", 0, 0x6B3B}, /* East Asian ideograph */
  {"\x32", 0, 0x6B39}, /* East Asian ideograph */
  {"\x35", 0, 0x6B3F}, /* East Asian ideograph */
  {"\x37", 0, 0x6B46}, /* East Asian ideograph */
  {"\x38", 0, 0x6B41}, /* East Asian ideograph */
  {"\x3A", 0, 0x6B40}, /* East Asian ideograph */
  {"\x3B", 0, 0x6B42}, /* East Asian ideograph */
  {"\x3C", 0, 0x6B43}, /* East Asian ideograph */
  {"\x3E", 0, 0x6B48}, /* East Asian ideograph */
  {"\x3F", 0, 0x6B4A}, /* East Asian ideograph */
  {"\x46", 0, 0x6B4E}, /* East Asian ideograph (variant of EACC 4C4446) */
  {"\x4A", 0, 0x6B57}, /* East Asian ideograph */
  {"\x4C", 0, 0x6B54}, /* East Asian ideograph */
  {"\x4E", 0, 0x6B55}, /* East Asian ideograph */
  {"\x51", 0, 0x6B5C}, /* East Asian ideograph */
  {"\x53", 0, 0x6B5E}, /* East Asian ideograph */
  {"\x54", 0, 0x6B60}, /* East Asian ideograph */
  {"\x5B", 0, 0x6B6B}, /* East Asian ideograph */
  {"\x5D", 0, 0x6B6C}, /* East Asian ideograph */
  {"\x5F", 0, 0x6B6E}, /* East Asian ideograph */
  {"\x61", 0, 0x6B71}, /* East Asian ideograph */
  {"\x6B", 0, 0x6B7E}, /* East Asian ideograph */
  {"\x71", 0, 0x6B82}, /* East Asian ideograph */
  {"\x73", 0, 0x6B84}, /* East Asian ideograph */
  {"\x79", 0, 0x6B8D}, /* East Asian ideograph */
  {"\x7B", 0, 0x6B95}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page117 = {
  marc8_31page117_flat, 0
};
/* PAGE 116 */
struct yaz_iconv_trie_flat marc8_31page116_flat[] = {
  {"\x25", 0, 0x6ACC}, /* East Asian ideograph */
  {"\x28", 0, 0x6AD1}, /* East Asian ideograph */
  {"\x33", 0, 0x6ADF}, /* East Asian ideograph */
  {"\x34", 0, 0x6ACD}, /* East Asian ideograph */
  {"\x35", 0, 0x6ADE}, /* East Asian ideograph */
  {"\x37", 0, 0x6AEC}, /* East Asian ideograph */
  {"\x39", 0, 0x6AF3}, /* East Asian ideograph */
  {"\x3A", 0, 0x6AE7}, /* East Asian ideograph */
  {"\x3F", 0, 0x6AEB}, /* East Asian ideograph */
  {"\x40", 0, 0x6AEA}, /* East Asian ideograph */
  {"\x44", 0, 0x6AF1}, /* East Asian ideograph */
  {"\x45", 0, 0x6AE8}, /* East Asian ideograph */
  {"\x48", 0, 0x6AF5}, /* East Asian ideograph */
  {"\x4E", 0, 0x6AFD}, /* East Asian ideograph */
  {"\x50", 0, 0x6AFA}, /* East Asian ideograph */
  {"\x52", 0, 0x6B01}, /* East Asian ideograph */
  {"\x58", 0, 0x6B03}, /* East Asian ideograph */
  {"\x59", 0, 0x6AF8}, /* East Asian ideograph */
  {"\x5F", 0, 0x6B0D}, /* East Asian ideograph */
  {"\x60", 0, 0x6B09}, /* East Asian ideograph */
  {"\x61", 0, 0x6B0E}, /* East Asian ideograph */
  {"\x67", 0, 0x6B11}, /* East Asian ideograph */
  {"\x6D", 0, 0x6B19}, /* East Asian ideograph */
  {"\x6E", 0, 0x6B17}, /* East Asian ideograph */
  {"\x72", 0, 0x6B1E}, /* East Asian ideograph */
  {"\x7E", 0, 0x6B2C}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page116 = {
  marc8_31page116_flat, 0
};
/* PAGE 115 */
struct yaz_iconv_trie_flat marc8_31page115_flat[] = {
  {"\x22", 0, 0x6A7F}, /* East Asian ideograph */
  {"\x23", 0, 0x6A89}, /* East Asian ideograph */
  {"\x24", 0, 0x6A91}, /* East Asian ideograph */
  {"\x26", 0, 0x6A9F}, /* East Asian ideograph */
  {"\x2A", 0, 0x6A92}, /* East Asian ideograph */
  {"\x2B", 0, 0x6AA3}, /* East Asian ideograph */
  {"\x34", 0, 0x6A99}, /* East Asian ideograph */
  {"\x35", 0, 0x6A9D}, /* East Asian ideograph */
  {"\x36", 0, 0x6A7E}, /* East Asian ideograph */
  {"\x37", 0, 0x6A9B}, /* East Asian ideograph */
  {"\x42", 0, 0x6AA0}, /* East Asian ideograph */
  {"\x47", 0, 0x6A90}, /* East Asian ideograph */
  {"\x49", 0, 0x6A9E}, /* East Asian ideograph */
  {"\x4A", 0, 0x6A87}, /* East Asian ideograph */
  {"\x4B", 0, 0x6A8E}, /* East Asian ideograph */
  {"\x51", 0, 0x6AAB}, /* East Asian ideograph */
  {"\x55", 0, 0x6AC8}, /* East Asian ideograph */
  {"\x57", 0, 0x6AAE}, /* East Asian ideograph */
  {"\x5D", 0, 0x6ABF}, /* East Asian ideograph */
  {"\x64", 0, 0x6ACA}, /* East Asian ideograph */
  {"\x68", 0, 0x6AB4}, /* East Asian ideograph */
  {"\x79", 0, 0x6AE6}, /* East Asian ideograph */
  {"\x7E", 0, 0x6AED}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page115 = {
  marc8_31page115_flat, 0
};
/* PAGE 114 */
struct yaz_iconv_trie_flat marc8_31page114_flat[] = {
  {"\x23", 0, 0x69F0}, /* East Asian ideograph */
  {"\x24", 0, 0x69F2}, /* East Asian ideograph */
  {"\x28", 0, 0x6A14}, /* East Asian ideograph */
  {"\x29", 0, 0x6A63}, /* East Asian ideograph */
  {"\x37", 0, 0x6A67}, /* East Asian ideograph */
  {"\x39", 0, 0x6A43}, /* East Asian ideograph */
  {"\x3A", 0, 0x6A33}, /* East Asian ideograph */
  {"\x3B", 0, 0x6A32}, /* East Asian ideograph */
  {"\x3C", 0, 0x6A5A}, /* East Asian ideograph */
  {"\x3F", 0, 0x6A28}, /* East Asian ideograph */
  {"\x40", 0, 0x6A48}, /* East Asian ideograph */
  {"\x41", 0, 0x6A50}, /* East Asian ideograph */
  {"\x42", 0, 0x6A52}, /* East Asian ideograph */
  {"\x43", 0, 0x6A72}, /* East Asian ideograph */
  {"\x45", 0, 0x6A3E}, /* East Asian ideograph */
  {"\x46", 0, 0x6A77}, /* East Asian ideograph */
  {"\x47", 0, 0x6A5B}, /* East Asian ideograph */
  {"\x4A", 0, 0x6A5E}, /* East Asian ideograph */
  {"\x4B", 0, 0x6A5C}, /* East Asian ideograph */
  {"\x4F", 0, 0x6A51}, /* East Asian ideograph */
  {"\x51", 0, 0x6A56}, /* East Asian ideograph */
  {"\x53", 0, 0x6A36}, /* East Asian ideograph */
  {"\x56", 0, 0x6A7A}, /* East Asian ideograph */
  {"\x58", 0, 0x6A3F}, /* East Asian ideograph */
  {"\x6C", 0, 0x69F9}, /* East Asian ideograph */
  {"\x6D", 0, 0x6A64}, /* East Asian ideograph */
  {"\x73", 0, 0x6A8D}, /* East Asian ideograph */
  {"\x75", 0, 0x6AA8}, /* East Asian ideograph */
  {"\x77", 0, 0x6AA5}, /* East Asian ideograph */
  {"\x79", 0, 0x6A96}, /* East Asian ideograph */
  {"\x7E", 0, 0x6A7D}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page114 = {
  marc8_31page114_flat, 0
};
/* PAGE 113 */
struct yaz_iconv_trie_flat marc8_31page113_flat[] = {
  {"\x27", 0, 0x69BF}, /* East Asian ideograph */
  {"\x2D", 0, 0x69A3}, /* East Asian ideograph */
  {"\x2E", 0, 0x69A4}, /* East Asian ideograph */
  {"\x34", 0, 0x69D4}, /* East Asian ideograph */
  {"\x38", 0, 0x69C3}, /* East Asian ideograph */
  {"\x3D", 0, 0x6A12}, /* East Asian ideograph */
  {"\x3E", 0, 0x6A11}, /* East Asian ideograph */
  {"\x41", 0, 0x6A00}, /* East Asian ideograph */
  {"\x46", 0, 0x69E6}, /* East Asian ideograph */
  {"\x4B", 0, 0x6A0B}, /* East Asian ideograph */
  {"\x4C", 0, 0x69E5}, /* East Asian ideograph */
  {"\x4D", 0, 0x69E9}, /* East Asian ideograph */
  {"\x50", 0, 0x69FC}, /* East Asian ideograph */
  {"\x54", 0, 0x6A17}, /* East Asian ideograph */
  {"\x56", 0, 0x69E7}, /* East Asian ideograph */
  {"\x57", 0, 0x69EB}, /* East Asian ideograph */
  {"\x5B", 0, 0x69F1}, /* East Asian ideograph */
  {"\x5E", 0, 0x6A2B}, /* East Asian ideograph */
  {"\x5F", 0, 0x69FF}, /* East Asian ideograph */
  {"\x60", 0, 0x6A20}, /* East Asian ideograph */
  {"\x64", 0, 0x69ED}, /* East Asian ideograph */
  {"\x67", 0, 0x6A1B}, /* East Asian ideograph */
  {"\x68", 0, 0x6A2D}, /* East Asian ideograph */
  {"\x6E", 0, 0x6A18}, /* East Asian ideograph */
  {"\x72", 0, 0x6A1D}, /* East Asian ideograph */
  {"\x75", 0, 0x6A0C}, /* East Asian ideograph */
  {"\x76", 0, 0x6A0F}, /* East Asian ideograph */
  {"\x7C", 0, 0x69EE}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page113 = {
  marc8_31page113_flat, 0
};
/* PAGE 112 */
struct yaz_iconv_trie_flat marc8_31page112_flat[] = {
  {"\x21", 0, 0x6952}, /* East Asian ideograph */
  {"\x25", 0, 0x695B}, /* East Asian ideograph */
  {"\x2D", 0, 0x6985}, /* East Asian ideograph */
  {"\x32", 0, 0x693D}, /* East Asian ideograph */
  {"\x35", 0, 0x6978}, /* East Asian ideograph */
  {"\x37", 0, 0x697B}, /* East Asian ideograph */
  {"\x3A", 0, 0x6934}, /* East Asian ideograph */
  {"\x3B", 0, 0x6969}, /* East Asian ideograph */
  {"\x3D", 0, 0x6944}, /* East Asian ideograph */
  {"\x3E", 0, 0x696F}, /* East Asian ideograph */
  {"\x44", 0, 0x698A}, /* East Asian ideograph */
  {"\x45", 0, 0x69A0}, /* East Asian ideograph */
  {"\x46", 0, 0x69B1}, /* East Asian ideograph */
  {"\x50", 0, 0x69CE}, /* East Asian ideograph */
  {"\x51", 0, 0x69CA}, /* East Asian ideograph */
  {"\x59", 0, 0x698D}, /* East Asian ideograph */
  {"\x5A", 0, 0x6991}, /* East Asian ideograph */
  {"\x5C", 0, 0x69AA}, /* East Asian ideograph */
  {"\x60", 0, 0x69BC}, /* East Asian ideograph */
  {"\x61", 0, 0x69A7}, /* East Asian ideograph */
  {"\x65", 0, 0x699E}, /* East Asian ideograph */
  {"\x68", 0, 0x69D9}, /* East Asian ideograph */
  {"\x6A", 0, 0x698E}, /* East Asian ideograph */
  {"\x6D", 0, 0x69D6}, /* East Asian ideograph */
  {"\x75", 0, 0x69A5}, /* East Asian ideograph */
  {"\x77", 0, 0x69BE}, /* East Asian ideograph */
  {"\x78", 0, 0x69D1}, /* East Asian ideograph */
  {"\x7A", 0, 0x69F6}, /* East Asian ideograph */
  {"\x7E", 0, 0x69D5}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page112 = {
  marc8_31page112_flat, 0
};
/* PAGE 111 */
struct yaz_iconv_trie_flat marc8_31page111_flat[] = {
  {"\x21", 0, 0x6907}, /* East Asian ideograph */
  {"\x23", 0, 0x691A}, /* East Asian ideograph */
  {"\x24", 0, 0x6919}, /* East Asian ideograph */
  {"\x2A", 0, 0x68DE}, /* East Asian ideograph */
  {"\x2B", 0, 0x691B}, /* East Asian ideograph */
  {"\x2D", 0, 0x68FB}, /* East Asian ideograph */
  {"\x33", 0, 0x68E1}, /* East Asian ideograph */
  {"\x37", 0, 0x68D1}, /* East Asian ideograph */
  {"\x38", 0, 0x68D0}, /* East Asian ideograph */
  {"\x39", 0, 0x6908}, /* East Asian ideograph */
  {"\x3E", 0, 0x68E8}, /* East Asian ideograph */
  {"\x3F", 0, 0x68F0}, /* East Asian ideograph */
  {"\x40", 0, 0x68C3}, /* East Asian ideograph */
  {"\x44", 0, 0x6911}, /* East Asian ideograph */
  {"\x46", 0, 0x68D4}, /* East Asian ideograph */
  {"\x47", 0, 0x68EF}, /* East Asian ideograph */
  {"\x49", 0, 0x68C6}, /* East Asian ideograph */
  {"\x4B", 0, 0x68C7}, /* East Asian ideograph */
  {"\x53", 0, 0x6974}, /* East Asian ideograph */
  {"\x55", 0, 0x6938}, /* East Asian ideograph */
  {"\x58", 0, 0x6962}, /* East Asian ideograph */
  {"\x5D", 0, 0x6958}, /* East Asian ideograph */
  {"\x5F", 0, 0x6957}, /* East Asian ideograph */
  {"\x60", 0, 0x693F}, /* East Asian ideograph */
  {"\x61", 0, 0x6971}, /* East Asian ideograph */
  {"\x64", 0, 0x6945}, /* East Asian ideograph */
  {"\x65", 0, 0x695D}, /* East Asian ideograph */
  {"\x66", 0, 0x6932}, /* East Asian ideograph */
  {"\x69", 0, 0x696E}, /* East Asian ideograph */
  {"\x6A", 0, 0x6963}, /* East Asian ideograph */
  {"\x6B", 0, 0x6948}, /* East Asian ideograph */
  {"\x6E", 0, 0x6939}, /* East Asian ideograph */
  {"\x70", 0, 0x696A}, /* East Asian ideograph */
  {"\x73", 0, 0x6937}, /* East Asian ideograph */
  {"\x7A", 0, 0x696C}, /* East Asian ideograph */
  {"\x7B", 0, 0x694E}, /* East Asian ideograph */
  {"\x7D", 0, 0x6980}, /* East Asian ideograph */
  {"\x7E", 0, 0x6933}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page111 = {
  marc8_31page111_flat, 0
};
/* PAGE 110 */
struct yaz_iconv_trie_flat marc8_31page110_flat[] = {
  {"\x21", 0, 0x6872}, /* East Asian ideograph */
  {"\x22", 0, 0x689C}, /* East Asian ideograph */
  {"\x25", 0, 0x686D}, /* East Asian ideograph */
  {"\x2E", 0, 0x68A9}, /* East Asian ideograph */
  {"\x30", 0, 0x6898}, /* East Asian ideograph */
  {"\x32", 0, 0x688B}, /* East Asian ideograph */
  {"\x33", 0, 0x68A0}, /* East Asian ideograph */
  {"\x34", 0, 0x686F}, /* East Asian ideograph */
  {"\x39", 0, 0x68A3}, /* East Asian ideograph */
  {"\x3B", 0, 0x6874}, /* East Asian ideograph */
  {"\x3C", 0, 0x6875}, /* East Asian ideograph */
  {"\x3F", 0, 0x6877}, /* East Asian ideograph */
  {"\x40", 0, 0x688F}, /* East Asian ideograph */
  {"\x43", 0, 0x687B}, /* East Asian ideograph */
  {"\x44", 0, 0x688E}, /* East Asian ideograph */
  {"\x4B", 0, 0x68B4}, /* East Asian ideograph */
  {"\x50", 0, 0x692C}, /* East Asian ideograph */
  {"\x51", 0, 0x6917}, /* East Asian ideograph */
  {"\x53", 0, 0x690C}, /* East Asian ideograph */
  {"\x56", 0, 0x690B}, /* East Asian ideograph */
  {"\x58", 0, 0x68D3}, /* East Asian ideograph */
  {"\x59", 0, 0x6904}, /* East Asian ideograph */
  {"\x5B", 0, 0x690A}, /* East Asian ideograph */
  {"\x5C", 0, 0x6909}, /* East Asian ideograph */
  {"\x5D", 0, 0x6929}, /* East Asian ideograph */
  {"\x62", 0, 0x68EC}, /* East Asian ideograph */
  {"\x63", 0, 0x692A}, /* East Asian ideograph */
  {"\x64", 0, 0x68EA}, /* East Asian ideograph */
  {"\x65", 0, 0x681F}, /* East Asian ideograph */
  {"\x66", 0, 0x7439}, /* East Asian ideograph */
  {"\x6A", 0, 0x6910}, /* East Asian ideograph */
  {"\x6E", 0, 0x68D6}, /* East Asian ideograph */
  {"\x6F", 0, 0x68EB}, /* East Asian ideograph */
  {"\x73", 0, 0x68F1}, /* East Asian ideograph */
  {"\x78", 0, 0x68FD}, /* East Asian ideograph */
  {"\x79", 0, 0x68FC}, /* East Asian ideograph */
  {"\x7B", 0, 0x68F3}, /* East Asian ideograph */
  {"\x7C", 0, 0x6913}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page110 = {
  marc8_31page110_flat, 0
};
/* PAGE 109 */
struct yaz_iconv_trie_flat marc8_31page109_flat[] = {
  {"\x21", 0, 0x67B9}, /* East Asian ideograph */
  {"\x23", 0, 0x67C2}, /* East Asian ideograph */
  {"\x24", 0, 0x67E3}, /* East Asian ideograph */
  {"\x26", 0, 0x67CA}, /* East Asian ideograph */
  {"\x28", 0, 0x67CE}, /* East Asian ideograph */
  {"\x29", 0, 0x67E2}, /* East Asian ideograph */
  {"\x2A", 0, 0x67F2}, /* East Asian ideograph */
  {"\x2B", 0, 0x67C3}, /* East Asian ideograph */
  {"\x2D", 0, 0x67DD}, /* East Asian ideograph */
  {"\x2F", 0, 0x67E7}, /* East Asian ideograph */
  {"\x30", 0, 0x6849}, /* East Asian ideograph */
  {"\x31", 0, 0x683E}, /* East Asian ideograph */
  {"\x36", 0, 0x6814}, /* East Asian ideograph */
  {"\x37", 0, 0x684B}, /* East Asian ideograph */
  {"\x38", 0, 0x681E}, /* East Asian ideograph */
  {"\x3B", 0, 0x6833}, /* East Asian ideograph */
  {"\x40", 0, 0x6831}, /* East Asian ideograph */
  {"\x41", 0, 0x6832}, /* East Asian ideograph */
  {"\x42", 0, 0x6835}, /* East Asian ideograph */
  {"\x43", 0, 0x683B}, /* East Asian ideograph */
  {"\x44", 0, 0x684E}, /* East Asian ideograph */
  {"\x47", 0, 0x682B}, /* East Asian ideograph */
  {"\x48", 0, 0x682D}, /* East Asian ideograph */
  {"\x4A", 0, 0x684D}, /* East Asian ideograph */
  {"\x4F", 0, 0x6844}, /* East Asian ideograph */
  {"\x55", 0, 0x685D}, /* East Asian ideograph */
  {"\x56", 0, 0x685E}, /* East Asian ideograph */
  {"\x58", 0, 0x6834}, /* East Asian ideograph */
  {"\x59", 0, 0x6812}, /* East Asian ideograph */
  {"\x65", 0, 0x685A}, /* East Asian ideograph */
  {"\x68", 0, 0x686B}, /* East Asian ideograph */
  {"\x69", 0, 0x686C}, /* East Asian ideograph */
  {"\x6B", 0, 0x6879}, /* East Asian ideograph */
  {"\x6E", 0, 0x68B2}, /* East Asian ideograph */
  {"\x71", 0, 0x689B}, /* East Asian ideograph */
  {"\x72", 0, 0x687E}, /* East Asian ideograph */
  {"\x74", 0, 0x68B6}, /* East Asian ideograph */
  {"\x76", 0, 0x6882}, /* East Asian ideograph */
  {"\x7A", 0, 0x6890}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page109 = {
  marc8_31page109_flat, 0
};
/* PAGE 108 */
struct yaz_iconv_trie_flat marc8_31page108_flat[] = {
  {"\x21", 0, 0x677B}, /* East Asian ideograph */
  {"\x22", 0, 0x6792}, /* East Asian ideograph */
  {"\x23", 0, 0x6776}, /* East Asian ideograph */
  {"\x25", 0, 0x6791}, /* East Asian ideograph */
  {"\x26", 0, 0x6799}, /* East Asian ideograph */
  {"\x28", 0, 0x67A4}, /* East Asian ideograph */
  {"\x2E", 0, 0x678F}, /* East Asian ideograph */
  {"\x30", 0, 0x6772}, /* East Asian ideograph */
  {"\x31", 0, 0x6798}, /* East Asian ideograph (variant of EACC 4C3B31) */
  {"\x32", 0, 0x676A}, /* East Asian ideograph */
  {"\x39", 0, 0x67AC}, /* East Asian ideograph */
  {"\x3B", 0, 0x67A0}, /* East Asian ideograph */
  {"\x3F", 0, 0x67A1}, /* East Asian ideograph */
  {"\x44", 0, 0x67F9}, /* East Asian ideograph */
  {"\x48", 0, 0x678D}, /* East Asian ideograph */
  {"\x49", 0, 0x678C}, /* East Asian ideograph */
  {"\x4C", 0, 0x67FC}, /* East Asian ideograph */
  {"\x4E", 0, 0x6810}, /* East Asian ideograph */
  {"\x51", 0, 0x67C8}, /* East Asian ideograph */
  {"\x54", 0, 0x67CC}, /* East Asian ideograph */
  {"\x58", 0, 0x67C5}, /* East Asian ideograph */
  {"\x5C", 0, 0x67BB}, /* East Asian ideograph */
  {"\x5F", 0, 0x67B0}, /* East Asian ideograph */
  {"\x60", 0, 0x6803}, /* East Asian ideograph */
  {"\x61", 0, 0x67F8}, /* East Asian ideograph */
  {"\x63", 0, 0x67D8}, /* East Asian ideograph */
  {"\x64", 0, 0x67B7}, /* East Asian ideograph */
  {"\x6D", 0, 0x6802}, /* East Asian ideograph */
  {"\x6F", 0, 0x67E4}, /* East Asian ideograph */
  {"\x70", 0, 0x67D9}, /* East Asian ideograph */
  {"\x71", 0, 0x67DB}, /* East Asian ideograph */
  {"\x72", 0, 0x67B5}, /* East Asian ideograph */
  {"\x74", 0, 0x67DF}, /* East Asian ideograph */
  {"\x75", 0, 0x67F7}, /* East Asian ideograph */
  {"\x77", 0, 0x67B3}, /* East Asian ideograph */
  {"\x78", 0, 0x6806}, /* East Asian ideograph */
  {"\x79", 0, 0x67AE}, /* East Asian ideograph */
  {"\x7A", 0, 0x67F6}, /* East Asian ideograph */
  {"\x7C", 0, 0x67EE}, /* East Asian ideograph */
  {"\x7D", 0, 0x6AAF}, /* East Asian ideograph */
  {"\x7E", 0, 0x67B2}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page108 = {
  marc8_31page108_flat, 0
};
/* PAGE 107 */
struct yaz_iconv_trie_flat marc8_31page107_flat[] = {
  {"\x28", 0, 0x6705}, /* East Asian ideograph */
  {"\x30", 0, 0x670F}, /* East Asian ideograph */
  {"\x31", 0, 0x6710}, /* East Asian ideograph */
  {"\x33", 0, 0x6712}, /* East Asian ideograph */
  {"\x34", 0, 0x6713}, /* East Asian ideograph */
  {"\x38", 0, 0x6719}, /* East Asian ideograph */
  {"\x39", 0, 0x6718}, /* East Asian ideograph */
  {"\x47", 0, 0x6723}, /* East Asian ideograph */
  {"\x4C", 0, 0x673E}, /* East Asian ideograph */
  {"\x4E", 0, 0x673F}, /* East Asian ideograph */
  {"\x58", 0, 0x6757}, /* East Asian ideograph */
  {"\x5B", 0, 0x6745}, /* East Asian ideograph */
  {"\x5C", 0, 0x6747}, /* East Asian ideograph */
  {"\x60", 0, 0x675D}, /* East Asian ideograph */
  {"\x61", 0, 0x6755}, /* East Asian ideograph */
  {"\x66", 0, 0x674C}, /* East Asian ideograph */
  {"\x67", 0, 0x6759}, /* East Asian ideograph */
  {"\x68", 0, 0x6748}, /* East Asian ideograph */
  {"\x6B", 0, 0x6763}, /* East Asian ideograph */
  {"\x6E", 0, 0x6753}, /* East Asian ideograph */
  {"\x71", 0, 0x674A}, /* East Asian ideograph */
  {"\x75", 0, 0x6793}, /* East Asian ideograph */
  {"\x78", 0, 0x677C}, /* East Asian ideograph */
  {"\x7A", 0, 0x679F}, /* East Asian ideograph */
  {"\x7C", 0, 0x6785}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page107 = {
  marc8_31page107_flat, 0
};
/* PAGE 106 */
struct yaz_iconv_trie_flat marc8_31page106_flat[] = {
  {"\x24", 0, 0x7A25}, /* East Asian ideograph */
  {"\x2A", 0, 0x66A0}, /* East Asian ideograph */
  {"\x30", 0, 0x5C21}, /* East Asian ideograph */
  {"\x32", 0, 0x669D}, /* East Asian ideograph */
  {"\x3A", 0, 0x66B2}, /* East Asian ideograph */
  {"\x40", 0, 0x66B5}, /* East Asian ideograph */
  {"\x41", 0, 0x66AA}, /* East Asian ideograph */
  {"\x43", 0, 0x66AC}, /* East Asian ideograph */
  {"\x47", 0, 0x66B1}, /* East Asian ideograph */
  {"\x4E", 0, 0x66C8}, /* East Asian ideograph */
  {"\x4F", 0, 0x66BE}, /* East Asian ideograph */
  {"\x54", 0, 0x66C0}, /* East Asian ideograph */
  {"\x55", 0, 0x66C7}, /* East Asian ideograph */
  {"\x5A", 0, 0x66BB}, /* East Asian ideograph */
  {"\x5C", 0, 0x66C4}, /* East Asian ideograph */
  {"\x60", 0, 0x66CF}, /* East Asian ideograph */
  {"\x71", 0, 0x66DA}, /* East Asian ideograph */
  {"\x72", 0, 0x66DB}, /* East Asian ideograph */
  {"\x73", 0, 0x66E2}, /* East Asian ideograph */
  {"\x76", 0, 0x66E1}, /* East Asian ideograph */
  {"\x78", 0, 0x66E8}, /* East Asian ideograph */
  {"\x7C", 0, 0x66E9}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page106 = {
  marc8_31page106_flat, 0
};
/* PAGE 105 */
struct yaz_iconv_trie_flat marc8_31page105_flat[] = {
  {"\x27", 0, 0x6633}, /* East Asian ideograph */
  {"\x28", 0, 0x662B}, /* East Asian ideograph */
  {"\x2B", 0, 0x6634}, /* East Asian ideograph */
  {"\x2C", 0, 0x6624}, /* East Asian ideograph */
  {"\x31", 0, 0x6645}, /* East Asian ideograph */
  {"\x32", 0, 0x665F}, /* East Asian ideograph */
  {"\x3D", 0, 0x6665}, /* East Asian ideograph */
  {"\x3E", 0, 0x665C}, /* East Asian ideograph */
  {"\x3F", 0, 0x6661}, /* East Asian ideograph */
  {"\x48", 0, 0x665B}, /* East Asian ideograph */
  {"\x49", 0, 0x6659}, /* East Asian ideograph */
  {"\x4A", 0, 0x6667}, /* East Asian ideograph */
  {"\x4C", 0, 0x665E}, /* East Asian ideograph */
  {"\x4D", 0, 0x6657}, /* East Asian ideograph */
  {"\x50", 0, 0x667E}, /* East Asian ideograph */
  {"\x51", 0, 0x666C}, /* East Asian ideograph */
  {"\x5A", 0, 0x6678}, /* East Asian ideograph */
  {"\x60", 0, 0x6673}, /* East Asian ideograph */
  {"\x66", 0, 0x666D}, /* East Asian ideograph */
  {"\x68", 0, 0x6677}, /* East Asian ideograph */
  {"\x70", 0, 0x6684}, /* East Asian ideograph */
  {"\x71", 0, 0x668C}, /* East Asian ideograph */
  {"\x72", 0, 0x6693}, /* East Asian ideograph */
  {"\x75", 0, 0x668B}, /* East Asian ideograph */
  {"\x76", 0, 0x6690}, /* East Asian ideograph */
  {"\x79", 0, 0x6694}, /* East Asian ideograph */
  {"\x7A", 0, 0x668A}, /* East Asian ideograph */
  {"\x7C", 0, 0x6698}, /* East Asian ideograph */
  {"\x7D", 0, 0x668D}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page105 = {
  marc8_31page105_flat, 0
};
/* PAGE 104 */
struct yaz_iconv_trie_flat marc8_31page104_flat[] = {
  {"\x22", 0, 0x65A8}, /* East Asian ideograph */
  {"\x23", 0, 0x65A6}, /* East Asian ideograph */
  {"\x27", 0, 0x65AE}, /* East Asian ideograph */
  {"\x2A", 0, 0x65B6}, /* East Asian ideograph */
  {"\x2C", 0, 0x65B8}, /* East Asian ideograph */
  {"\x2F", 0, 0x65BF}, /* East Asian ideograph */
  {"\x31", 0, 0x65C6}, /* East Asian ideograph */
  {"\x32", 0, 0x65C3}, /* East Asian ideograph */
  {"\x33", 0, 0x65C4}, /* East Asian ideograph */
  {"\x34", 0, 0x65C2}, /* East Asian ideograph */
  {"\x3B", 0, 0x65D0}, /* East Asian ideograph */
  {"\x3C", 0, 0x65D2}, /* East Asian ideograph */
  {"\x44", 0, 0x65DB}, /* East Asian ideograph */
  {"\x45", 0, 0x65DC}, /* East Asian ideograph */
  {"\x47", 0, 0x65DD}, /* East Asian ideograph */
  {"\x48", 0, 0x65DF}, /* East Asian ideograph */
  {"\x4A", 0, 0x65E1}, /* East Asian ideograph */
  {"\x4E", 0, 0x65E4}, /* East Asian ideograph */
  {"\x54", 0, 0x65F4}, /* East Asian ideograph */
  {"\x55", 0, 0x65F0}, /* East Asian ideograph */
  {"\x5A", 0, 0x6609}, /* East Asian ideograph */
  {"\x5B", 0, 0x65FB}, /* East Asian ideograph */
  {"\x5C", 0, 0x65FC}, /* East Asian ideograph */
  {"\x5E", 0, 0x660A}, /* East Asian ideograph */
  {"\x64", 0, 0x6603}, /* East Asian ideograph */
  {"\x6A", 0, 0x6611}, /* East Asian ideograph */
  {"\x6B", 0, 0x6615}, /* East Asian ideograph */
  {"\x6D", 0, 0x6604}, /* East Asian ideograph */
  {"\x6E", 0, 0x6631}, /* East Asian ideograph */
  {"\x72", 0, 0x6621}, /* East Asian ideograph */
  {"\x75", 0, 0x662C}, /* East Asian ideograph */
  {"\x77", 0, 0x6635}, /* East Asian ideograph */
  {"\x7C", 0, 0x661E}, /* East Asian ideograph */
  {"\x7D", 0, 0x663A}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page104 = {
  marc8_31page104_flat, 0
};
/* PAGE 103 */
struct yaz_iconv_trie_flat marc8_31page103_flat[] = {
  {"\x2C", 0, 0x6538}, /* East Asian ideograph */
  {"\x34", 0, 0x6542}, /* East Asian ideograph */
  {"\x36", 0, 0x6549}, /* East Asian ideograph */
  {"\x3E", 0, 0x6554}, /* East Asian ideograph */
  {"\x3F", 0, 0x6555}, /* East Asian ideograph */
  {"\x45", 0, 0x6567}, /* East Asian ideograph */
  {"\x47", 0, 0x6561}, /* East Asian ideograph */
  {"\x4F", 0, 0x656D}, /* East Asian ideograph */
  {"\x54", 0, 0x657A}, /* East Asian ideograph */
  {"\x64", 0, 0x6585}, /* East Asian ideograph */
  {"\x6E", 0, 0x658C}, /* East Asian ideograph */
  {"\x70", 0, 0x6592}, /* East Asian ideograph */
  {"\x71", 0, 0x6595}, /* East Asian ideograph */
  {"\x75", 0, 0x659B}, /* East Asian ideograph */
  {"\x77", 0, 0x659D}, /* East Asian ideograph */
  {"\x7A", 0, 0x65A0}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page103 = {
  marc8_31page103_flat, 0
};
/* PAGE 102 */
struct yaz_iconv_trie_flat marc8_31page102_flat[] = {
  {"\x2A", 0, 0x64EF}, /* East Asian ideograph */
  {"\x2D", 0, 0x64E1}, /* East Asian ideograph */
  {"\x2E", 0, 0x64E5}, /* East Asian ideograph */
  {"\x31", 0, 0x64EB}, /* East Asian ideograph */
  {"\x33", 0, 0x64E2}, /* East Asian ideograph */
  {"\x36", 0, 0x64ED}, /* East Asian ideograph */
  {"\x38", 0, 0x64E4}, /* East Asian ideograph */
  {"\x42", 0, 0x64F7}, /* East Asian ideograph */
  {"\x46", 0, 0x6504}, /* East Asian ideograph */
  {"\x4B", 0, 0x64FD}, /* East Asian ideograph */
  {"\x4F", 0, 0x6508}, /* East Asian ideograph */
  {"\x53", 0, 0x6509}, /* East Asian ideograph */
  {"\x59", 0, 0x651A}, /* East Asian ideograph */
  {"\x5B", 0, 0x6516}, /* East Asian ideograph */
  {"\x61", 0, 0x651B}, /* East Asian ideograph */
  {"\x69", 0, 0x6527}, /* East Asian ideograph */
  {"\x6D", 0, 0x6522}, /* East Asian ideograph */
  {"\x6F", 0, 0x6529}, /* East Asian ideograph */
  {"\x72", 0, 0x6525}, /* East Asian ideograph */
  {"\x77", 0, 0x652E}, /* East Asian ideograph */
  {"\x7C", 0, 0x6541}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page102 = {
  marc8_31page102_flat, 0
};
/* PAGE 101 */
struct yaz_iconv_trie_flat marc8_31page101_flat[] = {
  {"\x23", 0, 0x644E}, /* East Asian ideograph */
  {"\x24", 0, 0x6464}, /* East Asian ideograph */
  {"\x27", 0, 0x6482}, /* East Asian ideograph */
  {"\x28", 0, 0x645E}, /* East Asian ideograph */
  {"\x2C", 0, 0x647B}, /* East Asian ideograph */
  {"\x2E", 0, 0x645C}, /* East Asian ideograph */
  {"\x3C", 0, 0x649D}, /* East Asian ideograph */
  {"\x3F", 0, 0x6499}, /* East Asian ideograph */
  {"\x42", 0, 0x648F}, /* East Asian ideograph */
  {"\x4D", 0, 0x6496}, /* East Asian ideograph */
  {"\x4E", 0, 0x64A2}, /* East Asian ideograph */
  {"\x54", 0, 0x6490}, /* East Asian ideograph */
  {"\x5B", 0, 0x64B6}, /* East Asian ideograph */
  {"\x61", 0, 0x6498}, /* East Asian ideograph */
  {"\x62", 0, 0x649F}, /* East Asian ideograph */
  {"\x65", 0, 0x64A7}, /* East Asian ideograph */
  {"\x66", 0, 0x64B3}, /* East Asian ideograph */
  {"\x6A", 0, 0x64D7}, /* East Asian ideograph */
  {"\x6C", 0, 0x64D3}, /* East Asian ideograph */
  {"\x74", 0, 0x64BE}, /* East Asian ideograph */
  {"\x75", 0, 0x64D0}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page101 = {
  marc8_31page101_flat, 0
};
/* PAGE 100 */
struct yaz_iconv_trie_flat marc8_31page100_flat[] = {
  {"\x22", 0, 0x6410}, /* East Asian ideograph */
  {"\x24", 0, 0x6434}, /* East Asian ideograph */
  {"\x29", 0, 0x641B}, /* East Asian ideograph */
  {"\x2B", 0, 0x6420}, /* East Asian ideograph */
  {"\x2C", 0, 0x6424}, /* East Asian ideograph */
  {"\x2F", 0, 0x6426}, /* East Asian ideograph */
  {"\x31", 0, 0x640C}, /* East Asian ideograph */
  {"\x36", 0, 0x6415}, /* East Asian ideograph */
  {"\x37", 0, 0x6418}, /* East Asian ideograph */
  {"\x38", 0, 0x640E}, /* East Asian ideograph */
  {"\x39", 0, 0x22C4D}, /* East Asian ideograph (Unicode CJK Extension B) */
  {"\x3B", 0, 0x6422}, /* East Asian ideograph */
  {"\x3D", 0, 0x6421}, /* East Asian ideograph */
  {"\x44", 0, 0x6430}, /* East Asian ideograph */
  {"\x45", 0, 0x6441}, /* East Asian ideograph */
  {"\x48", 0, 0x6435}, /* East Asian ideograph */
  {"\x4C", 0, 0x6409}, /* East Asian ideograph */
  {"\x51", 0, 0x640A}, /* East Asian ideograph */
  {"\x53", 0, 0x6440}, /* East Asian ideograph */
  {"\x59", 0, 0x6407}, /* East Asian ideograph */
  {"\x5B", 0, 0x643B}, /* East Asian ideograph */
  {"\x5D", 0, 0x643F}, /* East Asian ideograph */
  {"\x68", 0, 0x645B}, /* East Asian ideograph */
  {"\x6A", 0, 0x644F}, /* East Asian ideograph */
  {"\x6C", 0, 0x646B}, /* East Asian ideograph */
  {"\x6F", 0, 0x6476}, /* East Asian ideograph */
  {"\x76", 0, 0x6474}, /* East Asian ideograph */
  {"\x78", 0, 0x647D}, /* East Asian ideograph */
  {"\x7B", 0, 0x6473}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page100 = {
  marc8_31page100_flat, 0
};
/* PAGE 99 */
struct yaz_iconv_trie_flat marc8_31page99_flat[] = {
  {"\x25", 0, 0x6387}, /* East Asian ideograph */
  {"\x26", 0, 0x637A}, /* East Asian ideograph */
  {"\x27", 0, 0x638E}, /* East Asian ideograph */
  {"\x2A", 0, 0x6386}, /* East Asian ideograph */
  {"\x2F", 0, 0x6375}, /* East Asian ideograph */
  {"\x30", 0, 0x63AF}, /* East Asian ideograph */
  {"\x37", 0, 0x63B1}, /* East Asian ideograph */
  {"\x38", 0, 0x63B0}, /* East Asian ideograph */
  {"\x39", 0, 0x63AE}, /* East Asian ideograph */
  {"\x3A", 0, 0x637C}, /* East Asian ideograph */
  {"\x3B", 0, 0x6390}, /* East Asian ideograph */
  {"\x3D", 0, 0x63AD}, /* East Asian ideograph */
  {"\x41", 0, 0x636D}, /* East Asian ideograph */
  {"\x43", 0, 0x63DE}, /* East Asian ideograph */
  {"\x44", 0, 0x63E5}, /* East Asian ideograph */
  {"\x47", 0, 0x63D3}, /* East Asian ideograph */
  {"\x4F", 0, 0x63BD}, /* East Asian ideograph */
  {"\x50", 0, 0x63C3}, /* East Asian ideograph */
  {"\x52", 0, 0x63F5}, /* East Asian ideograph */
  {"\x58", 0, 0x63E6}, /* East Asian ideograph */
  {"\x5B", 0, 0x63E0}, /* East Asian ideograph */
  {"\x5C", 0, 0x63D5}, /* East Asian ideograph */
  {"\x5D", 0, 0x63F6}, /* East Asian ideograph */
  {"\x5E", 0, 0x63F2}, /* East Asian ideograph */
  {"\x5F", 0, 0x63F8}, /* East Asian ideograph */
  {"\x66", 0, 0x63C5}, /* East Asian ideograph */
  {"\x6A", 0, 0x63F9}, /* East Asian ideograph */
  {"\x70", 0, 0x63BE}, /* East Asian ideograph */
  {"\x72", 0, 0x63EB}, /* East Asian ideograph */
  {"\x73", 0, 0x63DD}, /* East Asian ideograph */
  {"\x76", 0, 0x63D1}, /* East Asian ideograph */
  {"\x79", 0, 0x63C4}, /* East Asian ideograph */
  {"\x7A", 0, 0x63DC}, /* East Asian ideograph */
  {"\x7B", 0, 0x63D7}, /* East Asian ideograph */
  {"\x7E", 0, 0x6412}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page99 = {
  marc8_31page99_flat, 0
};
/* PAGE 98 */
struct yaz_iconv_trie_flat marc8_31page98_flat[] = {
  {"\x25", 0, 0x62F5}, /* East Asian ideograph */
  {"\x31", 0, 0x630C}, /* East Asian ideograph */
  {"\x32", 0, 0x6360}, /* East Asian ideograph */
  {"\x37", 0, 0x62F6}, /* East Asian ideograph */
  {"\x3A", 0, 0x6331}, /* East Asian ideograph */
  {"\x42", 0, 0x6345}, /* East Asian ideograph */
  {"\x44", 0, 0x6343}, /* East Asian ideograph */
  {"\x45", 0, 0x6335}, /* East Asian ideograph */
  {"\x47", 0, 0x6353}, /* East Asian ideograph */
  {"\x48", 0, 0x6364}, /* East Asian ideograph */
  {"\x49", 0, 0x6336}, /* East Asian ideograph */
  {"\x4A", 0, 0x6344}, /* East Asian ideograph */
  {"\x54", 0, 0x6339}, /* East Asian ideograph */
  {"\x58", 0, 0x6357}, /* East Asian ideograph */
  {"\x5A", 0, 0x633C}, /* East Asian ideograph */
  {"\x5B", 0, 0x6358}, /* East Asian ideograph */
  {"\x5C", 0, 0x634B}, /* East Asian ideograph */
  {"\x5F", 0, 0x6354}, /* East Asian ideograph */
  {"\x68", 0, 0x637D}, /* East Asian ideograph */
  {"\x6A", 0, 0x63B6}, /* East Asian ideograph */
  {"\x6B", 0, 0x6382}, /* East Asian ideograph */
  {"\x6C", 0, 0x636C}, /* East Asian ideograph */
  {"\x6E", 0, 0x639F}, /* East Asian ideograph */
  {"\x72", 0, 0x639E}, /* East Asian ideograph */
  {"\x73", 0, 0x637F}, /* East Asian ideograph */
  {"\x79", 0, 0x6381}, /* East Asian ideograph */
  {"\x7B", 0, 0x6397}, /* East Asian ideograph */
  {"\x7D", 0, 0x63AB}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page98 = {
  marc8_31page98_flat, 0
};
/* PAGE 97 */
struct yaz_iconv_trie_flat marc8_31page97_flat[] = {
  {"\x26", 0, 0x6268}, /* East Asian ideograph */
  {"\x28", 0, 0x6260}, /* East Asian ideograph */
  {"\x2B", 0, 0x625A}, /* East Asian ideograph */
  {"\x2C", 0, 0x6262}, /* East Asian ideograph */
  {"\x2D", 0, 0x6266}, /* East Asian ideograph */
  {"\x31", 0, 0x6286}, /* East Asian ideograph */
  {"\x32", 0, 0x628E}, /* East Asian ideograph */
  {"\x41", 0, 0x62A3}, /* East Asian ideograph */
  {"\x43", 0, 0x6282}, /* East Asian ideograph */
  {"\x46", 0, 0x6285}, /* East Asian ideograph */
  {"\x4B", 0, 0x629D}, /* East Asian ideograph */
  {"\x56", 0, 0x62A6}, /* East Asian ideograph */
  {"\x57", 0, 0x62D1}, /* East Asian ideograph */
  {"\x61", 0, 0x62E4}, /* East Asian ideograph */
  {"\x69", 0, 0x62B6}, /* East Asian ideograph */
  {"\x6A", 0, 0x62C3}, /* East Asian ideograph */
  {"\x72", 0, 0x630D}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page97 = {
  marc8_31page97_flat, 0
};
/* PAGE 96 */
struct yaz_iconv_trie_flat marc8_31page96_flat[] = {
  {"\x29", 0, 0x61F3}, /* East Asian ideograph */
  {"\x3D", 0, 0x6201}, /* East Asian ideograph */
  {"\x41", 0, 0x6204}, /* East Asian ideograph */
  {"\x43", 0, 0x6207}, /* East Asian ideograph */
  {"\x44", 0, 0x6209}, /* East Asian ideograph */
  {"\x47", 0, 0x6214}, /* East Asian ideograph */
  {"\x56", 0, 0x6223}, /* East Asian ideograph */
  {"\x5B", 0, 0x6225}, /* East Asian ideograph */
  {"\x5D", 0, 0x6224}, /* East Asian ideograph */
  {"\x61", 0, 0x6229}, /* East Asian ideograph */
  {"\x67", 0, 0x622D}, /* East Asian ideograph */
  {"\x69", 0, 0x97EF}, /* East Asian ideograph */
  {"\x6E", 0, 0x6239}, /* East Asian ideograph */
  {"\x6F", 0, 0x623A}, /* East Asian ideograph */
  {"\x70", 0, 0x623D}, /* East Asian ideograph */
  {"\x75", 0, 0x6243}, /* East Asian ideograph */
  {"\x77", 0, 0x6246}, /* East Asian ideograph */
  {"\x78", 0, 0x6245}, /* East Asian ideograph */
  {"\x79", 0, 0x624A}, /* East Asian ideograph */
  {"\x7A", 0, 0x6250}, /* East Asian ideograph */
  {"\x7C", 0, 0x625E}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page96 = {
  marc8_31page96_flat, 0
};
/* PAGE 95 */
struct yaz_iconv_trie_flat marc8_31page95_flat[] = {
  {"\x23", 0, 0x618B}, /* East Asian ideograph */
  {"\x2C", 0, 0x616F}, /* East Asian ideograph */
  {"\x2D", 0, 0x6165}, /* East Asian ideograph */
  {"\x2F", 0, 0x615C}, /* East Asian ideograph */
  {"\x32", 0, 0x619D}, /* East Asian ideograph */
  {"\x33", 0, 0x61A6}, /* East Asian ideograph */
  {"\x3D", 0, 0x61A2}, /* East Asian ideograph */
  {"\x40", 0, 0x61A8}, /* East Asian ideograph */
  {"\x42", 0, 0x619C}, /* East Asian ideograph */
  {"\x43", 0, 0x61AF}, /* East Asian ideograph */
  {"\x45", 0, 0x6196}, /* East Asian ideograph */
  {"\x46", 0, 0x6197}, /* East Asian ideograph */
  {"\x47", 0, 0x61AD}, /* East Asian ideograph */
  {"\x4C", 0, 0x6192}, /* East Asian ideograph */
  {"\x52", 0, 0x61AE}, /* East Asian ideograph */
  {"\x55", 0, 0x618D}, /* East Asian ideograph */
  {"\x5A", 0, 0x61CB}, /* East Asian ideograph */
  {"\x5C", 0, 0x61CC}, /* East Asian ideograph */
  {"\x5D", 0, 0x61C6}, /* East Asian ideograph */
  {"\x68", 0, 0x61BA}, /* East Asian ideograph */
  {"\x6A", 0, 0x61B8}, /* East Asian ideograph */
  {"\x71", 0, 0x61E0}, /* East Asian ideograph */
  {"\x77", 0, 0x61E5}, /* East Asian ideograph */
  {"\x7D", 0, 0x61DC}, /* East Asian ideograph */
  {"\x7E", 0, 0x61DF}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page95 = {
  marc8_31page95_flat, 0
};
/* PAGE 94 */
struct yaz_iconv_trie_flat marc8_31page94_flat[] = {
  {"\x2A", 0, 0x610A}, /* East Asian ideograph */
  {"\x2C", 0, 0x6110}, /* East Asian ideograph */
  {"\x32", 0, 0x6112}, /* East Asian ideograph */
  {"\x34", 0, 0x60F2}, /* East Asian ideograph */
  {"\x37", 0, 0x6125}, /* East Asian ideograph */
  {"\x3B", 0, 0x60F8}, /* East Asian ideograph */
  {"\x3F", 0, 0x6121}, /* East Asian ideograph */
  {"\x41", 0, 0x60FC}, /* East Asian ideograph */
  {"\x43", 0, 0x6106}, /* East Asian ideograph */
  {"\x48", 0, 0x6149}, /* East Asian ideograph */
  {"\x4A", 0, 0x614A}, /* East Asian ideograph */
  {"\x4E", 0, 0x612B}, /* East Asian ideograph */
  {"\x50", 0, 0x6129}, /* East Asian ideograph */
  {"\x51", 0, 0x6150}, /* East Asian ideograph */
  {"\x56", 0, 0x53AF}, /* East Asian ideograph */
  {"\x58", 0, 0x6130}, /* East Asian ideograph */
  {"\x5B", 0, 0x6141}, /* East Asian ideograph */
  {"\x5E", 0, 0x6137}, /* East Asian ideograph */
  {"\x61", 0, 0x6146}, /* East Asian ideograph */
  {"\x66", 0, 0x615E}, /* East Asian ideograph */
  {"\x67", 0, 0x6175}, /* East Asian ideograph */
  {"\x68", 0, 0x6174}, /* East Asian ideograph */
  {"\x6B", 0, 0x6183}, /* East Asian ideograph */
  {"\x70", 0, 0x6171}, /* East Asian ideograph */
  {"\x74", 0, 0x616A}, /* East Asian ideograph */
  {"\x77", 0, 0x6173}, /* East Asian ideograph */
  {"\x79", 0, 0x6164}, /* East Asian ideograph */
  {"\x7B", 0, 0x6153}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page94 = {
  marc8_31page94_flat, 0
};
/* PAGE 93 */
struct yaz_iconv_trie_flat marc8_31page93_flat[] = {
  {"\x24", 0, 0x608A}, /* East Asian ideograph */
  {"\x2B", 0, 0x6092}, /* East Asian ideograph */
  {"\x2C", 0, 0x609D}, /* East Asian ideograph */
  {"\x2D", 0, 0x6081}, /* East Asian ideograph */
  {"\x2F", 0, 0x609E}, /* East Asian ideograph */
  {"\x30", 0, 0x6083}, /* East Asian ideograph */
  {"\x32", 0, 0x6097}, /* East Asian ideograph */
  {"\x34", 0, 0x60A7}, /* East Asian ideograph */
  {"\x3A", 0, 0x6095}, /* East Asian ideograph */
  {"\x3E", 0, 0x60C7}, /* East Asian ideograph */
  {"\x42", 0, 0x60B0}, /* East Asian ideograph */
  {"\x46", 0, 0x60BE}, /* East Asian ideograph */
  {"\x47", 0, 0x60D3}, /* East Asian ideograph */
  {"\x48", 0, 0x60D4}, /* East Asian ideograph */
  {"\x4E", 0, 0x60CE}, /* East Asian ideograph */
  {"\x51", 0, 0x60CF}, /* East Asian ideograph */
  {"\x53", 0, 0x60D9}, /* East Asian ideograph */
  {"\x54", 0, 0x60B3}, /* East Asian ideograph */
  {"\x56", 0, 0x60DD}, /* East Asian ideograph */
  {"\x5D", 0, 0x60C4}, /* East Asian ideograph */
  {"\x60", 0, 0x60B1}, /* East Asian ideograph */
  {"\x62", 0, 0x60E3}, /* East Asian ideograph */
  {"\x66", 0, 0x60E2}, /* East Asian ideograph */
  {"\x67", 0, 0x60E5}, /* East Asian ideograph */
  {"\x69", 0, 0x60DB}, /* East Asian ideograph */
  {"\x6E", 0, 0x60E9}, /* East Asian ideograph */
  {"\x70", 0, 0x6114}, /* East Asian ideograph */
  {"\x73", 0, 0x6103}, /* East Asian ideograph */
  {"\x75", 0, 0x6119}, /* East Asian ideograph */
  {"\x7C", 0, 0x60FD}, /* East Asian ideograph */
  {"\x7D", 0, 0x610D}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page93 = {
  marc8_31page93_flat, 0
};
/* PAGE 92 */
struct yaz_iconv_trie_flat marc8_31page92_flat[] = {
  {"\x24", 0, 0x5FEA}, /* East Asian ideograph */
  {"\x2A", 0, 0x6026}, /* East Asian ideograph */
  {"\x2C", 0, 0x6029}, /* East Asian ideograph */
  {"\x2D", 0, 0x602B}, /* East Asian ideograph */
  {"\x30", 0, 0x6019}, /* East Asian ideograph */
  {"\x31", 0, 0x6008}, /* East Asian ideograph */
  {"\x36", 0, 0x600A}, /* East Asian ideograph */
  {"\x37", 0, 0x600C}, /* East Asian ideograph */
  {"\x38", 0, 0x601B}, /* East Asian ideograph */
  {"\x3C", 0, 0x6017}, /* East Asian ideograph */
  {"\x3D", 0, 0x6033}, /* East Asian ideograph */
  {"\x45", 0, 0x600D}, /* East Asian ideograph */
  {"\x46", 0, 0x6010}, /* East Asian ideograph */
  {"\x4B", 0, 0x6039}, /* East Asian ideograph */
  {"\x50", 0, 0x6013}, /* East Asian ideograph */
  {"\x53", 0, 0x6054}, /* East Asian ideograph */
  {"\x57", 0, 0x605D}, /* East Asian ideograph */
  {"\x5A", 0, 0x6047}, /* East Asian ideograph */
  {"\x5E", 0, 0x6049}, /* East Asian ideograph */
  {"\x5F", 0, 0x6053}, /* East Asian ideograph */
  {"\x68", 0, 0x6067}, /* East Asian ideograph */
  {"\x6F", 0, 0x604C}, /* East Asian ideograph */
  {"\x71", 0, 0x6041}, /* East Asian ideograph */
  {"\x72", 0, 0x6077}, /* East Asian ideograph */
  {"\x74", 0, 0x6042}, /* East Asian ideograph */
  {"\x76", 0, 0x605F}, /* East Asian ideograph */
  {"\x7A", 0, 0x6061}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page92 = {
  marc8_31page92_flat, 0
};
/* PAGE 91 */
struct yaz_iconv_trie_flat marc8_31page91_flat[] = {
  {"\x23", 0, 0x5F82}, /* East Asian ideograph */
  {"\x27", 0, 0x5F89}, /* East Asian ideograph */
  {"\x2B", 0, 0x5F94}, /* East Asian ideograph */
  {"\x34", 0, 0x2251B}, /* East Asian ideograph (Unicode CJK Extension B) */
  {"\x39", 0, 0x5F9C}, /* East Asian ideograph */
  {"\x3D", 0, 0x5F9A}, /* East Asian ideograph */
  {"\x46", 0, 0x5FAF}, /* East Asian ideograph */
  {"\x50", 0, 0x5FBC}, /* East Asian ideograph */
  {"\x57", 0, 0x5FC9}, /* East Asian ideograph */
  {"\x5F", 0, 0x5FD1}, /* East Asian ideograph */
  {"\x61", 0, 0x5FD2}, /* East Asian ideograph */
  {"\x63", 0, 0x5FD0}, /* East Asian ideograph */
  {"\x67", 0, 0x5FCE}, /* East Asian ideograph */
  {"\x68", 0, 0x5FED}, /* East Asian ideograph */
  {"\x72", 0, 0x5FEE}, /* East Asian ideograph */
  {"\x73", 0, 0x5FF8}, /* East Asian ideograph */
  {"\x78", 0, 0x5FE1}, /* East Asian ideograph */
  {"\x7B", 0, 0x5FE4}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page91 = {
  marc8_31page91_flat, 0
};
/* PAGE 90 */
struct yaz_iconv_trie_flat marc8_31page90_flat[] = {
  {"\x21", 0, 0x5EF1}, /* East Asian ideograph */
  {"\x23", 0, 0x5EF4}, /* East Asian ideograph */
  {"\x35", 0, 0x5F07}, /* East Asian ideograph */
  {"\x3A", 0, 0x5F0B}, /* East Asian ideograph */
  {"\x4A", 0, 0x5F28}, /* East Asian ideograph */
  {"\x4B", 0, 0x5F22}, /* East Asian ideograph */
  {"\x4C", 0, 0x5F23}, /* East Asian ideograph */
  {"\x4D", 0, 0x5F24}, /* East Asian ideograph */
  {"\x51", 0, 0x5F33}, /* East Asian ideograph */
  {"\x52", 0, 0x5F30}, /* East Asian ideograph */
  {"\x58", 0, 0x5F38}, /* East Asian ideograph */
  {"\x5C", 0, 0x5F40}, /* East Asian ideograph */
  {"\x5F", 0, 0x5F44}, /* East Asian ideograph */
  {"\x62", 0, 0x5F4D}, /* East Asian ideograph */
  {"\x68", 0, 0x5F50}, /* East Asian ideograph */
  {"\x69", 0, 0x5F54}, /* East Asian ideograph */
  {"\x6A", 0, 0x5F56}, /* East Asian ideograph */
  {"\x6C", 0, 0x5F58}, /* East Asian ideograph */
  {"\x70", 0, 0x5F60}, /* East Asian ideograph */
  {"\x71", 0, 0x5F61}, /* East Asian ideograph */
  {"\x72", 0, 0x5F63}, /* East Asian ideograph */
  {"\x73", 0, 0x809C}, /* East Asian ideograph */
  {"\x74", 0, 0x5F67}, /* East Asian ideograph */
  {"\x78", 0, 0x5F72}, /* East Asian ideograph */
  {"\x79", 0, 0x5F73}, /* East Asian ideograph */
  {"\x7C", 0, 0x5F74}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page90 = {
  marc8_31page90_flat, 0
};
/* PAGE 89 */
struct yaz_iconv_trie_flat marc8_31page89_flat[] = {
  {"\x2F", 0, 0x5EA4}, /* East Asian ideograph */
  {"\x35", 0, 0x5EA5}, /* East Asian ideograph */
  {"\x36", 0, 0x5EAF}, /* East Asian ideograph */
  {"\x42", 0, 0x5EB9}, /* East Asian ideograph */
  {"\x4B", 0, 0x5EB3}, /* East Asian ideograph */
  {"\x4C", 0, 0x5EC4}, /* East Asian ideograph */
  {"\x51", 0, 0x5ECC}, /* East Asian ideograph */
  {"\x55", 0, 0x5ECB}, /* East Asian ideograph */
  {"\x57", 0, 0x5ECD}, /* East Asian ideograph */
  {"\x5A", 0, 0x5ED2}, /* East Asian ideograph */
  {"\x5B", 0, 0x5ED1}, /* East Asian ideograph */
  {"\x5C", 0, 0x5ED5}, /* East Asian ideograph */
  {"\x5F", 0, 0x5ED4}, /* East Asian ideograph */
  {"\x60", 0, 0x5ED9}, /* East Asian ideograph */
  {"\x61", 0, 0x5ECE}, /* East Asian ideograph */
  {"\x68", 0, 0x5EE1}, /* East Asian ideograph */
  {"\x6D", 0, 0x5EE7}, /* East Asian ideograph */
  {"\x71", 0, 0x5EE8}, /* East Asian ideograph */
  {"\x7C", 0, 0x5EED}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page89 = {
  marc8_31page89_flat, 0
};
/* PAGE 88 */
struct yaz_iconv_trie_flat marc8_31page88_flat[] = {
  {"\x22", 0, 0x5E22}, /* East Asian ideograph */
  {"\x24", 0, 0x5E28}, /* East Asian ideograph */
  {"\x35", 0, 0x5E44}, /* East Asian ideograph */
  {"\x36", 0, 0x5E43}, /* East Asian ideograph */
  {"\x39", 0, 0x5E42}, /* East Asian ideograph */
  {"\x3F", 0, 0x5E4E}, /* East Asian ideograph */
  {"\x47", 0, 0x5E58}, /* East Asian ideograph */
  {"\x48", 0, 0x5E48}, /* East Asian ideograph */
  {"\x57", 0, 0x5E5E}, /* East Asian ideograph */
  {"\x58", 0, 0x5E61}, /* East Asian ideograph */
  {"\x5D", 0, 0x5E68}, /* East Asian ideograph */
  {"\x5F", 0, 0x5E6C}, /* East Asian ideograph */
  {"\x60", 0, 0x5E6A}, /* East Asian ideograph */
  {"\x63", 0, 0x5E6E}, /* East Asian ideograph */
  {"\x64", 0, 0x5E6D}, /* East Asian ideograph */
  {"\x65", 0, 0x5E70}, /* East Asian ideograph */
  {"\x6D", 0, 0x5E75}, /* East Asian ideograph */
  {"\x77", 0, 0x5E80}, /* East Asian ideograph */
  {"\x7E", 0, 0x5E8B}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page88 = {
  marc8_31page88_flat, 0
};
/* PAGE 87 */
struct yaz_iconv_trie_flat marc8_31page87_flat[] = {
  {"\x26", 0, 0x5DA7}, /* East Asian ideograph */
  {"\x2A", 0, 0x5DB0}, /* East Asian ideograph */
  {"\x2E", 0, 0x5DB4}, /* East Asian ideograph */
  {"\x2F", 0, 0x5DAE}, /* East Asian ideograph */
  {"\x30", 0, 0x5DB6}, /* East Asian ideograph */
  {"\x32", 0, 0x5DB8}, /* East Asian ideograph */
  {"\x34", 0, 0x5DBF}, /* East Asian ideograph */
  {"\x36", 0, 0x5DB7}, /* East Asian ideograph */
  {"\x3E", 0, 0x5DC3}, /* East Asian ideograph */
  {"\x44", 0, 0x5DC7}, /* East Asian ideograph */
  {"\x46", 0, 0x5DC9}, /* East Asian ideograph */
  {"\x47", 0, 0x5DCB}, /* East Asian ideograph */
  {"\x4E", 0, 0x5DD8}, /* East Asian ideograph */
  {"\x50", 0, 0x5DDB}, /* East Asian ideograph */
  {"\x52", 0, 0x5DDC}, /* East Asian ideograph */
  {"\x56", 0, 0x5DE4}, /* East Asian ideograph */
  {"\x62", 0, 0x5E00}, /* East Asian ideograph */
  {"\x64", 0, 0x51E7}, /* East Asian ideograph */
  {"\x72", 0, 0x5E14}, /* East Asian ideograph */
  {"\x73", 0, 0x5E17}, /* East Asian ideograph */
  {"\x76", 0, 0x5E19}, /* East Asian ideograph */
  {"\x77", 0, 0x5E12}, /* East Asian ideograph */
  {"\x78", 0, 0x5E1F}, /* East Asian ideograph */
  {"\x7A", 0, 0x5E23}, /* East Asian ideograph */
  {"\x7B", 0, 0x5E21}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page87 = {
  marc8_31page87_flat, 0
};
/* PAGE 86 */
struct yaz_iconv_trie_flat marc8_31page86_flat[] = {
  {"\x25", 0, 0x5D3F}, /* East Asian ideograph */
  {"\x26", 0, 0x5D52}, /* East Asian ideograph */
  {"\x27", 0, 0x5D3D}, /* East Asian ideograph */
  {"\x28", 0, 0x5D4E}, /* East Asian ideograph */
  {"\x2C", 0, 0x5D59}, /* East Asian ideograph */
  {"\x2D", 0, 0x5D47}, /* East Asian ideograph */
  {"\x2F", 0, 0x5D32}, /* East Asian ideograph */
  {"\x31", 0, 0x5D42}, /* East Asian ideograph */
  {"\x34", 0, 0x5D74}, /* East Asian ideograph */
  {"\x39", 0, 0x5D6F}, /* East Asian ideograph */
  {"\x3A", 0, 0x5D6B}, /* East Asian ideograph */
  {"\x3F", 0, 0x5D75}, /* East Asian ideograph */
  {"\x44", 0, 0x5D4A}, /* East Asian ideograph */
  {"\x49", 0, 0x5D6C}, /* East Asian ideograph */
  {"\x4A", 0, 0x5D62}, /* East Asian ideograph */
  {"\x4D", 0, 0x5D82}, /* East Asian ideograph */
  {"\x50", 0, 0x5D79}, /* East Asian ideograph */
  {"\x51", 0, 0x5D8E}, /* East Asian ideograph */
  {"\x5A", 0, 0x5D81}, /* East Asian ideograph */
  {"\x60", 0, 0x5D7E}, /* East Asian ideograph */
  {"\x66", 0, 0x5D92}, /* East Asian ideograph */
  {"\x68", 0, 0x5D99}, /* East Asian ideograph */
  {"\x69", 0, 0x5D97}, /* East Asian ideograph */
  {"\x6A", 0, 0x5DA2}, /* East Asian ideograph */
  {"\x73", 0, 0x5DA1}, /* East Asian ideograph */
  {"\x75", 0, 0x5D93}, /* East Asian ideograph */
  {"\x77", 0, 0x5DA0}, /* East Asian ideograph */
  {"\x7B", 0, 0x5D94}, /* East Asian ideograph */
  {"\x7E", 0, 0x5DAC}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page86 = {
  marc8_31page86_flat, 0
};
/* PAGE 85 */
struct yaz_iconv_trie_flat marc8_31page85_flat[] = {
  {"\x26", 0, 0x5CE0}, /* East Asian ideograph */
  {"\x28", 0, 0x5CD2}, /* East Asian ideograph */
  {"\x29", 0, 0x5CDD}, /* East Asian ideograph */
  {"\x2B", 0, 0x5CCB}, /* East Asian ideograph */
  {"\x30", 0, 0x5CC7}, /* East Asian ideograph */
  {"\x31", 0, 0x5CDC}, /* East Asian ideograph */
  {"\x34", 0, 0x5D00}, /* East Asian ideograph */
  {"\x3B", 0, 0x5CFF}, /* East Asian ideograph */
  {"\x3C", 0, 0x5CEB}, /* East Asian ideograph */
  {"\x41", 0, 0x5CF4}, /* East Asian ideograph */
  {"\x46", 0, 0x5CF1}, /* East Asian ideograph */
  {"\x49", 0, 0x5D1E}, /* East Asian ideograph */
  {"\x4A", 0, 0x5D12}, /* East Asian ideograph */
  {"\x50", 0, 0x5D1A}, /* East Asian ideograph */
  {"\x52", 0, 0x5D0C}, /* East Asian ideograph */
  {"\x53", 0, 0x5D20}, /* East Asian ideograph */
  {"\x54", 0, 0x5D21}, /* East Asian ideograph */
  {"\x57", 0, 0x5D27}, /* East Asian ideograph */
  {"\x58", 0, 0x5D0D}, /* East Asian ideograph */
  {"\x5A", 0, 0x5D26}, /* East Asian ideograph */
  {"\x5D", 0, 0x5D2E}, /* East Asian ideograph */
  {"\x69", 0, 0x5D24}, /* East Asian ideograph */
  {"\x71", 0, 0x5D36}, /* East Asian ideograph */
  {"\x72", 0, 0x5D3E}, /* East Asian ideograph */
  {"\x74", 0, 0x5D4B}, /* East Asian ideograph */
  {"\x76", 0, 0x5D57}, /* East Asian ideograph */
  {"\x77", 0, 0x5D34}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page85 = {
  marc8_31page85_flat, 0
};
/* PAGE 84 */
struct yaz_iconv_trie_flat marc8_31page84_flat[] = {
  {"\x23", 0, 0x5C63}, /* East Asian ideograph */
  {"\x29", 0, 0x5C67}, /* East Asian ideograph */
  {"\x2B", 0, 0x5C68}, /* East Asian ideograph */
  {"\x30", 0, 0x5C6D}, /* East Asian ideograph */
  {"\x31", 0, 0x5C6E}, /* East Asian ideograph */
  {"\x37", 0, 0x5C74}, /* East Asian ideograph */
  {"\x39", 0, 0x5C73}, /* East Asian ideograph */
  {"\x3B", 0, 0x5C77}, /* East Asian ideograph */
  {"\x3C", 0, 0x5C7A}, /* East Asian ideograph */
  {"\x40", 0, 0x5C7C}, /* East Asian ideograph */
  {"\x46", 0, 0x5C8F}, /* East Asian ideograph */
  {"\x49", 0, 0x5C88}, /* East Asian ideograph */
  {"\x4B", 0, 0x5C8D}, /* East Asian ideograph */
  {"\x4D", 0, 0x5C99}, /* East Asian ideograph */
  {"\x55", 0, 0x5CA6}, /* East Asian ideograph */
  {"\x57", 0, 0x5CA0}, /* East Asian ideograph */
  {"\x5C", 0, 0x5CA2}, /* East Asian ideograph */
  {"\x60", 0, 0x5CB5}, /* East Asian ideograph */
  {"\x61", 0, 0x5CA7}, /* East Asian ideograph */
  {"\x66", 0, 0x5CA8}, /* East Asian ideograph */
  {"\x67", 0, 0x5CAC}, /* East Asian ideograph */
  {"\x6B", 0, 0x5CA3}, /* East Asian ideograph */
  {"\x6C", 0, 0x5CB6}, /* East Asian ideograph */
  {"\x6D", 0, 0x5CC1}, /* East Asian ideograph */
  {"\x6F", 0, 0x5CAD}, /* East Asian ideograph */
  {"\x70", 0, 0x5CD5}, /* East Asian ideograph */
  {"\x78", 0, 0x5CD3}, /* East Asian ideograph */
  {"\x79", 0, 0x5C8D}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page84 = {
  marc8_31page84_flat, 0
};
/* PAGE 83 */
struct yaz_iconv_trie_flat marc8_31page83_flat[] = {
  {"\x24", 0, 0x5BF0}, /* East Asian ideograph */
  {"\x25", 0, 0x5BEF}, /* East Asian ideograph */
  {"\x33", 0, 0x5C00}, /* East Asian ideograph */
  {"\x35", 0, 0x5C57}, /* East Asian ideograph */
  {"\x3C", 0, 0x5C15}, /* East Asian ideograph */
  {"\x46", 0, 0x5C22}, /* East Asian ideograph */
  {"\x48", 0, 0x5C25}, /* East Asian ideograph */
  {"\x4B", 0, 0x5C2A}, /* East Asian ideograph */
  {"\x52", 0, 0x5C2F}, /* East Asian ideograph */
  {"\x5B", 0, 0x5C32}, /* East Asian ideograph */
  {"\x63", 0, 0x5C3B}, /* East Asian ideograph */
  {"\x65", 0, 0x5C44}, /* East Asian ideograph */
  {"\x67", 0, 0x5C49}, /* East Asian ideograph */
  {"\x79", 0, 0x5C59}, /* East Asian ideograph */
  {"\x7B", 0, 0x5C5D}, /* East Asian ideograph */
  {"\x7C", 0, 0x5C5F}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page83 = {
  marc8_31page83_flat, 0
};
/* PAGE 82 */
struct yaz_iconv_trie_dir marc8_31page82_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {84, 0, 0},
  {85, 0, 0},
  {86, 0, 0},
  {87, 0, 0},
  {88, 0, 0},
  {89, 0, 0},
  {90, 0, 0},
  {91, 0, 0},
  {92, 0, 0},
  {93, 0, 0},
  {94, 0, 0},
  {95, 0, 0},
  {96, 0, 0},
  {97, 0, 0},
  {98, 0, 0},
  {99, 0, 0},
  {100, 0, 0},
  {101, 0, 0},
  {102, 0, 0},
  {103, 0, 0},
  {104, 0, 0},
  {105, 0, 0},
  {106, 0, 0},
  {107, 0, 0},
  {108, 0, 0},
  {109, 0, 0},
  {110, 0, 0},
  {111, 0, 0},
  {112, 0, 0},
  {113, 0, 0},
  {114, 0, 0},
  {115, 0, 0},
  {116, 0, 0},
  {117, 0, 0},
  {118, 0, 0},
  {119, 0, 0},
  {120, 0, 0},
  {121, 0, 0},
  {122, 0, 0},
  {123, 0, 0},
  {124, 0, 0},
  {125, 0, 0},
  {126, 0, 0},
  {127, 0, 0},
  {128, 0, 0},
  {129, 0, 0},
  {130, 0, 0},
  {131, 0, 0},
  {132, 0, 0},
  {133, 0, 0},
  {134, 0, 0},
  {135, 0, 0},
  {136, 0, 0},
  {137, 0, 0},
  {138, 0, 0},
  {139, 0, 0},
  {140, 0, 0},
  {141, 0, 0},
  {142, 0, 0},
  {143, 0, 0},
  {144, 0, 0},
  {145, 0, 0},
  {146, 0, 0},
  {147, 0, 0},
  {148, 0, 0},
  {149, 0, 0},
  {150, 0, 0},
  {151, 0, 0},
  {152, 0, 0},
  {153, 0, 0},
  {154, 0, 0},
  {155, 0, 0},
  {156, 0, 0},
  {157, 0, 0},
  {158, 0, 0},
  {159, 0, 0},
  {160, 0, 0},
  {161, 0, 0},
  {162, 0, 0},
  {163, 0, 0},
  {164, 0, 0},
  {165, 0, 0},
  {166, 0, 0},
  {167, 0, 0},
  {168, 0, 0},
  {169, 0, 0},
  {170, 0, 0},
  {171, 0, 0},
  {172, 0, 0},
  {173, 0, 0},
  {174, 0, 0},
  {175, 0, 0},
  {176, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8_31page82 = {
  0, marc8_31page82_dir
};
/* PAGE 81 */
struct yaz_iconv_trie_flat marc8_31page81_flat[] = {
  {"\x21", 0, 0x5B5B}, /* East Asian ideograph */
  {"\x23", 0, 0x5B62}, /* East Asian ideograph */
  {"\x24", 0, 0x5B65}, /* East Asian ideograph */
  {"\x25", 0, 0x5B67}, /* East Asian ideograph */
  {"\x27", 0, 0x5C58}, /* East Asian ideograph */
  {"\x28", 0, 0x5B6C}, /* East Asian ideograph */
  {"\x2A", 0, 0x5B6E}, /* East Asian ideograph */
  {"\x30", 0, 0x5B7B}, /* East Asian ideograph */
  {"\x31", 0, 0x5B7C}, /* East Asian ideograph */
  {"\x32", 0, 0x5B80}, /* East Asian ideograph */
  {"\x34", 0, 0x5B84}, /* East Asian ideograph */
  {"\x35", 0, 0x5B82}, /* East Asian ideograph */
  {"\x40", 0, 0x5B95}, /* East Asian ideograph */
  {"\x43", 0, 0x5B93}, /* East Asian ideograph */
  {"\x49", 0, 0x5BAC}, /* East Asian ideograph */
  {"\x52", 0, 0x5BA7}, /* East Asian ideograph */
  {"\x55", 0, 0x5BB7}, /* East Asian ideograph */
  {"\x59", 0, 0x5BC1}, /* East Asian ideograph */
  {"\x5B", 0, 0x3761}, /* East Asian ideograph (Unicode CJK Extension A) */
  {"\x60", 0, 0x5BC9}, /* East Asian ideograph */
  {"\x68", 0, 0x5BD4}, /* East Asian ideograph */
  {"\x6A", 0, 0x5BC3}, /* East Asian ideograph */
  {"\x6E", 0, 0x5BD6}, /* East Asian ideograph */
  {"\x75", 0, 0x5BD7}, /* East Asian ideograph */
  {"\x79", 0, 0x5BE0}, /* East Asian ideograph */
  {"\x7E", 0, 0x5BEA}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page81 = {
  marc8_31page81_flat, 0
};
/* PAGE 80 */
struct yaz_iconv_trie_flat marc8_31page80_flat[] = {
  {"\x26", 0, 0x5AFF}, /* East Asian ideograph */
  {"\x2A", 0, 0x5AFD}, /* East Asian ideograph */
  {"\x2B", 0, 0x5B08}, /* East Asian ideograph */
  {"\x2E", 0, 0x5B0D}, /* East Asian ideograph */
  {"\x38", 0, 0x5B03}, /* East Asian ideograph */
  {"\x3D", 0, 0x5B17}, /* East Asian ideograph */
  {"\x3E", 0, 0x5B16}, /* East Asian ideograph */
  {"\x40", 0, 0x5B19}, /* East Asian ideograph */
  {"\x47", 0, 0x5B1B}, /* East Asian ideograph */
  {"\x48", 0, 0x5B21}, /* East Asian ideograph */
  {"\x52", 0, 0x5B2C}, /* East Asian ideograph */
  {"\x59", 0, 0x5B32}, /* East Asian ideograph */
  {"\x63", 0, 0x5B3F}, /* East Asian ideograph */
  {"\x6E", 0, 0x5B45}, /* East Asian ideograph */
  {"\x74", 0, 0x5B4C}, /* East Asian ideograph */
  {"\x76", 0, 0x5B4B}, /* East Asian ideograph */
  {"\x7C", 0, 0x5B56}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page80 = {
  marc8_31page80_flat, 0
};
/* PAGE 79 */
struct yaz_iconv_trie_flat marc8_31page79_flat[] = {
  {"\x21", 0, 0x5AA6}, /* East Asian ideograph */
  {"\x22", 0, 0x5A8C}, /* East Asian ideograph */
  {"\x24", 0, 0x5AA7}, /* East Asian ideograph */
  {"\x25", 0, 0x5A9E}, /* East Asian ideograph */
  {"\x26", 0, 0x5AA2}, /* East Asian ideograph */
  {"\x27", 0, 0x5A9C}, /* East Asian ideograph */
  {"\x28", 0, 0x5A7C}, /* East Asian ideograph */
  {"\x29", 0, 0x5A96}, /* East Asian ideograph */
  {"\x30", 0, 0x5A93}, /* East Asian ideograph */
  {"\x31", 0, 0x5AAC}, /* East Asian ideograph */
  {"\x34", 0, 0x5AAE}, /* East Asian ideograph */
  {"\x35", 0, 0x5A95}, /* East Asian ideograph */
  {"\x36", 0, 0x5AAF}, /* East Asian ideograph */
  {"\x39", 0, 0x5AC8}, /* East Asian ideograph */
  {"\x3E", 0, 0x5AB5}, /* East Asian ideograph */
  {"\x41", 0, 0x5AC4}, /* East Asian ideograph */
  {"\x45", 0, 0x5AB7}, /* East Asian ideograph */
  {"\x49", 0, 0x5AD1}, /* East Asian ideograph */
  {"\x4A", 0, 0x5A90}, /* East Asian ideograph */
  {"\x4F", 0, 0x5AB8}, /* East Asian ideograph */
  {"\x50", 0, 0x5ABA}, /* East Asian ideograph */
  {"\x52", 0, 0x5AAA}, /* East Asian ideograph */
  {"\x59", 0, 0x5AD3}, /* East Asian ideograph */
  {"\x5B", 0, 0x5AB1}, /* East Asian ideograph */
  {"\x60", 0, 0x5ADC}, /* East Asian ideograph */
  {"\x6D", 0, 0x5AE5}, /* East Asian ideograph */
  {"\x6E", 0, 0x5AE0}, /* East Asian ideograph */
  {"\x72", 0, 0x5AEA}, /* East Asian ideograph */
  {"\x7B", 0, 0x5ADA}, /* East Asian ideograph */
  {"\x7C", 0, 0x5AEB}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page79 = {
  marc8_31page79_flat, 0
};
/* PAGE 78 */
struct yaz_iconv_trie_flat marc8_31page78_flat[] = {
  {"\x2C", 0, 0x5A60}, /* East Asian ideograph */
  {"\x31", 0, 0x5A67}, /* East Asian ideograph */
  {"\x3A", 0, 0x5A38}, /* East Asian ideograph */
  {"\x3B", 0, 0x5A5E}, /* East Asian ideograph */
  {"\x3C", 0, 0x5A6D}, /* East Asian ideograph */
  {"\x3D", 0, 0x5A35}, /* East Asian ideograph */
  {"\x3E", 0, 0x5A55}, /* East Asian ideograph */
  {"\x41", 0, 0x5A2C}, /* East Asian ideograph */
  {"\x48", 0, 0x5A50}, /* East Asian ideograph */
  {"\x49", 0, 0x5A65}, /* East Asian ideograph */
  {"\x52", 0, 0x5A64}, /* East Asian ideograph */
  {"\x65", 0, 0x5A8A}, /* East Asian ideograph */
  {"\x69", 0, 0x5ACF}, /* East Asian ideograph */
  {"\x6A", 0, 0x5A7A}, /* East Asian ideograph */
  {"\x71", 0, 0x5A9F}, /* East Asian ideograph */
  {"\x75", 0, 0x5AA0}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page78 = {
  marc8_31page78_flat, 0
};
/* PAGE 77 */
struct yaz_iconv_trie_flat marc8_31page77_flat[] = {
  {"\x21", 0, 0x5990}, /* East Asian ideograph */
  {"\x24", 0, 0x59C5}, /* East Asian ideograph */
  {"\x25", 0, 0x59B5}, /* East Asian ideograph */
  {"\x28", 0, 0x59CF}, /* East Asian ideograph */
  {"\x2A", 0, 0x59BA}, /* East Asian ideograph */
  {"\x2C", 0, 0x59B8}, /* East Asian ideograph */
  {"\x35", 0, 0x59B2}, /* East Asian ideograph */
  {"\x3A", 0, 0x59B7}, /* East Asian ideograph */
  {"\x3E", 0, 0x59C1}, /* East Asian ideograph */
  {"\x43", 0, 0x59F9}, /* East Asian ideograph */
  {"\x44", 0, 0x59F8}, /* East Asian ideograph */
  {"\x4F", 0, 0x59EE}, /* East Asian ideograph */
  {"\x50", 0, 0x59F1}, /* East Asian ideograph */
  {"\x51", 0, 0x5A00}, /* East Asian ideograph */
  {"\x52", 0, 0x59DE}, /* East Asian ideograph */
  {"\x56", 0, 0x59FD}, /* East Asian ideograph */
  {"\x5D", 0, 0x59F6}, /* East Asian ideograph */
  {"\x5E", 0, 0x59DD}, /* East Asian ideograph */
  {"\x5F", 0, 0x59FA}, /* East Asian ideograph */
  {"\x61", 0, 0x59E4}, /* East Asian ideograph */
  {"\x6E", 0, 0x5A2A}, /* East Asian ideograph */
  {"\x75", 0, 0x5A16}, /* East Asian ideograph */
  {"\x78", 0, 0x5A09}, /* East Asian ideograph */
  {"\x7E", 0, 0x5A12}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page77 = {
  marc8_31page77_flat, 0
};
/* PAGE 76 */
struct yaz_iconv_trie_flat marc8_31page76_flat[] = {
  {"\x28", 0, 0x592C}, /* East Asian ideograph */
  {"\x2B", 0, 0x592F}, /* East Asian ideograph */
  {"\x30", 0, 0x593C}, /* East Asian ideograph */
  {"\x33", 0, 0x5940}, /* East Asian ideograph */
  {"\x38", 0, 0x594D}, /* East Asian ideograph */
  {"\x43", 0, 0x5953}, /* East Asian ideograph */
  {"\x4B", 0, 0x595C}, /* East Asian ideograph */
  {"\x4F", 0, 0x5961}, /* East Asian ideograph */
  {"\x54", 0, 0x596C}, /* East Asian ideograph */
  {"\x55", 0, 0x596D}, /* East Asian ideograph */
  {"\x65", 0, 0x597C}, /* East Asian ideograph */
  {"\x69", 0, 0x59A7}, /* East Asian ideograph */
  {"\x6B", 0, 0x5998}, /* East Asian ideograph */
  {"\x6F", 0, 0x599A}, /* East Asian ideograph */
  {"\x71", 0, 0x59A0}, /* East Asian ideograph */
  {"\x7C", 0, 0x5997}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page76 = {
  marc8_31page76_flat, 0
};
/* PAGE 75 */
struct yaz_iconv_trie_flat marc8_31page75_flat[] = {
  {"\x24", 0, 0x58B1}, /* East Asian ideograph */
  {"\x2B", 0, 0x58AD}, /* East Asian ideograph */
  {"\x2E", 0, 0x58A0}, /* East Asian ideograph */
  {"\x30", 0, 0x58A3}, /* East Asian ideograph */
  {"\x32", 0, 0x58A6}, /* East Asian ideograph */
  {"\x3A", 0, 0x58C8}, /* East Asian ideograph */
  {"\x41", 0, 0x58BC}, /* East Asian ideograph */
  {"\x49", 0, 0x58BF}, /* East Asian ideograph */
  {"\x4B", 0, 0x58C6}, /* East Asian ideograph */
  {"\x4C", 0, 0x58BA}, /* East Asian ideograph */
  {"\x50", 0, 0x58D6}, /* East Asian ideograph */
  {"\x54", 0, 0x58D2}, /* East Asian ideograph */
  {"\x56", 0, 0x58CE}, /* East Asian ideograph */
  {"\x5A", 0, 0x58E0}, /* East Asian ideograph */
  {"\x5E", 0, 0x58DA}, /* East Asian ideograph */
  {"\x6C", 0, 0x58FC}, /* East Asian ideograph */
  {"\x70", 0, 0x5902}, /* East Asian ideograph */
  {"\x73", 0, 0x5906}, /* East Asian ideograph */
  {"\x74", 0, 0x6535}, /* East Asian ideograph */
  {"\x7A", 0, 0x5910}, /* East Asian ideograph */
  {"\x7C", 0, 0x8641}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page75 = {
  marc8_31page75_flat, 0
};
/* PAGE 74 */
struct yaz_iconv_trie_flat marc8_31page74_flat[] = {
  {"\x21", 0, 0x5848}, /* East Asian ideograph */
  {"\x23", 0, 0x5818}, /* East Asian ideograph */
  {"\x26", 0, 0x57F5}, /* East Asian ideograph */
  {"\x29", 0, 0x582D}, /* East Asian ideograph */
  {"\x2B", 0, 0x5820}, /* East Asian ideograph */
  {"\x30", 0, 0x584E}, /* East Asian ideograph */
  {"\x33", 0, 0x585D}, /* East Asian ideograph */
  {"\x35", 0, 0x5859}, /* East Asian ideograph */
  {"\x37", 0, 0x584B}, /* East Asian ideograph */
  {"\x3D", 0, 0x5865}, /* East Asian ideograph */
  {"\x40", 0, 0x586C}, /* East Asian ideograph */
  {"\x42", 0, 0x5852}, /* East Asian ideograph */
  {"\x45", 0, 0x5864}, /* East Asian ideograph */
  {"\x47", 0, 0x5853}, /* East Asian ideograph */
  {"\x48", 0, 0x584F}, /* East Asian ideograph */
  {"\x49", 0, 0x583D}, /* East Asian ideograph */
  {"\x4D", 0, 0x584D}, /* East Asian ideograph */
  {"\x4E", 0, 0x5856}, /* East Asian ideograph */
  {"\x55", 0, 0x589A}, /* East Asian ideograph */
  {"\x58", 0, 0x5892}, /* East Asian ideograph */
  {"\x5A", 0, 0x588E}, /* East Asian ideograph */
  {"\x5C", 0, 0x5889}, /* East Asian ideograph */
  {"\x5F", 0, 0x5840}, /* East Asian ideograph */
  {"\x60", 0, 0x589B}, /* East Asian ideograph */
  {"\x61", 0, 0x587C}, /* East Asian ideograph */
  {"\x63", 0, 0x5888}, /* East Asian ideograph */
  {"\x65", 0, 0x5890}, /* East Asian ideograph */
  {"\x68", 0, 0x5898}, /* East Asian ideograph */
  {"\x6B", 0, 0x587D}, /* East Asian ideograph */
  {"\x6F", 0, 0x587F}, /* East Asian ideograph */
  {"\x70", 0, 0x5881}, /* East Asian ideograph */
  {"\x7B", 0, 0x58A9}, /* East Asian ideograph */
  {"\x7E", 0, 0x58A1}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page74 = {
  marc8_31page74_flat, 0
};
/* PAGE 73 */
struct yaz_iconv_trie_flat marc8_31page73_flat[] = {
  {"\x22", 0, 0x57C4}, /* East Asian ideograph */
  {"\x27", 0, 0x70FE}, /* East Asian ideograph */
  {"\x29", 0, 0x57E3}, /* East Asian ideograph */
  {"\x2A", 0, 0x57FB}, /* East Asian ideograph */
  {"\x2B", 0, 0x5803}, /* East Asian ideograph */
  {"\x2C", 0, 0x57F6}, /* East Asian ideograph */
  {"\x2D", 0, 0x57E6}, /* East Asian ideograph */
  {"\x31", 0, 0x57ED}, /* East Asian ideograph */
  {"\x33", 0, 0x5800}, /* East Asian ideograph */
  {"\x35", 0, 0x57EC}, /* East Asian ideograph */
  {"\x36", 0, 0x5807}, /* East Asian ideograph */
  {"\x39", 0, 0x580E}, /* East Asian ideograph */
  {"\x3B", 0, 0x580F}, /* East Asian ideograph */
  {"\x3D", 0, 0x57F4}, /* East Asian ideograph */
  {"\x3E", 0, 0x5810}, /* East Asian ideograph */
  {"\x40", 0, 0x580D}, /* East Asian ideograph */
  {"\x43", 0, 0x57EF}, /* East Asian ideograph */
  {"\x48", 0, 0x5801}, /* East Asian ideograph */
  {"\x49", 0, 0x5812}, /* East Asian ideograph */
  {"\x4D", 0, 0x57FD}, /* East Asian ideograph */
  {"\x4E", 0, 0x57F8}, /* East Asian ideograph */
  {"\x50", 0, 0x580C}, /* East Asian ideograph */
  {"\x51", 0, 0x5813}, /* East Asian ideograph */
  {"\x52", 0, 0x57F0}, /* East Asian ideograph */
  {"\x56", 0, 0x580B}, /* East Asian ideograph */
  {"\x58", 0, 0x57F3}, /* East Asian ideograph */
  {"\x59", 0, 0x5804}, /* East Asian ideograph */
  {"\x5A", 0, 0x57CF}, /* East Asian ideograph */
  {"\x5B", 0, 0x57DD}, /* East Asian ideograph */
  {"\x5F", 0, 0x5847}, /* East Asian ideograph */
  {"\x67", 0, 0x581B}, /* East Asian ideograph */
  {"\x69", 0, 0x5819}, /* East Asian ideograph */
  {"\x6A", 0, 0x5833}, /* East Asian ideograph */
  {"\x6C", 0, 0x581E}, /* East Asian ideograph */
  {"\x6D", 0, 0x583F}, /* East Asian ideograph */
  {"\x71", 0, 0x5827}, /* East Asian ideograph */
  {"\x76", 0, 0x5828}, /* East Asian ideograph */
  {"\x78", 0, 0x582E}, /* East Asian ideograph */
  {"\x7A", 0, 0x581D}, /* East Asian ideograph */
  {"\x7D", 0, 0x5844}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page73 = {
  marc8_31page73_flat, 0
};
/* PAGE 72 */
struct yaz_iconv_trie_flat marc8_31page72_flat[] = {
  {"\x26", 0, 0x5770}, /* East Asian ideograph */
  {"\x28", 0, 0x5771}, /* East Asian ideograph */
  {"\x2A", 0, 0x576E}, /* East Asian ideograph */
  {"\x2D", 0, 0x5776}, /* East Asian ideograph */
  {"\x2E", 0, 0x5789}, /* East Asian ideograph */
  {"\x30", 0, 0x577F}, /* East Asian ideograph */
  {"\x31", 0, 0x5775}, /* East Asian ideograph */
  {"\x32", 0, 0x577B}, /* East Asian ideograph */
  {"\x33", 0, 0x5788}, /* East Asian ideograph */
  {"\x35", 0, 0x5773}, /* East Asian ideograph */
  {"\x38", 0, 0x579F}, /* East Asian ideograph */
  {"\x39", 0, 0x5790}, /* East Asian ideograph */
  {"\x3A", 0, 0x5793}, /* East Asian ideograph */
  {"\x3F", 0, 0x579E}, /* East Asian ideograph */
  {"\x40", 0, 0x57B5}, /* East Asian ideograph */
  {"\x43", 0, 0x579A}, /* East Asian ideograph */
  {"\x45", 0, 0x5794}, /* East Asian ideograph */
  {"\x47", 0, 0x57A4}, /* East Asian ideograph */
  {"\x48", 0, 0x5799}, /* East Asian ideograph */
  {"\x49", 0, 0x578C}, /* East Asian ideograph */
  {"\x4B", 0, 0x5797}, /* East Asian ideograph */
  {"\x4E", 0, 0x579D}, /* East Asian ideograph */
  {"\x52", 0, 0x579C}, /* East Asian ideograph */
  {"\x54", 0, 0x57A7}, /* East Asian ideograph */
  {"\x57", 0, 0x57A1}, /* East Asian ideograph */
  {"\x59", 0, 0x212C4}, /* East Asian ideograph (Unicode CJK Extension B) */
  {"\x5B", 0, 0x5795}, /* East Asian ideograph */
  {"\x5F", 0, 0x57B8}, /* East Asian ideograph */
  {"\x60", 0, 0x57C7}, /* East Asian ideograph */
  {"\x6A", 0, 0x5809}, /* East Asian ideograph */
  {"\x6C", 0, 0x57BE}, /* East Asian ideograph */
  {"\x71", 0, 0x57DB}, /* East Asian ideograph */
  {"\x73", 0, 0x57D5}, /* East Asian ideograph */
  {"\x77", 0, 0x57D2}, /* East Asian ideograph */
  {"\x7E", 0, 0x57C6}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page72 = {
  marc8_31page72_flat, 0
};
/* PAGE 71 */
struct yaz_iconv_trie_flat marc8_31page71_flat[] = {
  {"\x21", 0, 0x56F9}, /* East Asian ideograph */
  {"\x24", 0, 0x56FF}, /* East Asian ideograph */
  {"\x27", 0, 0x5705}, /* East Asian ideograph */
  {"\x28", 0, 0x5704}, /* East Asian ideograph */
  {"\x29", 0, 0x5702}, /* East Asian ideograph */
  {"\x2C", 0, 0x570A}, /* East Asian ideograph */
  {"\x2D", 0, 0x5709}, /* East Asian ideograph */
  {"\x2E", 0, 0x5707}, /* East Asian ideograph */
  {"\x30", 0, 0x570C}, /* East Asian ideograph */
  {"\x31", 0, 0x5715}, /* East Asian ideograph */
  {"\x32", 0, 0x5714}, /* East Asian ideograph */
  {"\x35", 0, 0x571A}, /* East Asian ideograph */
  {"\x36", 0, 0x571B}, /* East Asian ideograph */
  {"\x37", 0, 0x571C}, /* East Asian ideograph */
  {"\x39", 0, 0x571D}, /* East Asian ideograph */
  {"\x3A", 0, 0x571E}, /* East Asian ideograph */
  {"\x41", 0, 0x5724}, /* East Asian ideograph */
  {"\x42", 0, 0x572E}, /* East Asian ideograph */
  {"\x43", 0, 0x5729}, /* East Asian ideograph */
  {"\x48", 0, 0x5738}, /* East Asian ideograph */
  {"\x4C", 0, 0x572A}, /* East Asian ideograph */
  {"\x63", 0, 0x5749}, /* East Asian ideograph */
  {"\x65", 0, 0x5745}, /* East Asian ideograph */
  {"\x68", 0, 0x574B}, /* East Asian ideograph */
  {"\x69", 0, 0x574C}, /* East Asian ideograph */
  {"\x6A", 0, 0x573F}, /* East Asian ideograph */
  {"\x70", 0, 0x5768}, /* East Asian ideograph */
  {"\x75", 0, 0x578A}, /* East Asian ideograph */
  {"\x77", 0, 0x576D}, /* East Asian ideograph */
  {"\x79", 0, 0x5774}, /* East Asian ideograph */
  {"\x7A", 0, 0x5767}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page71 = {
  marc8_31page71_flat, 0
};
/* PAGE 70 */
struct yaz_iconv_trie_flat marc8_31page70_flat[] = {
  {"\x25", 0, 0x5693}, /* East Asian ideograph */
  {"\x28", 0, 0x568C}, /* East Asian ideograph */
  {"\x32", 0, 0x56BA}, /* East Asian ideograph */
  {"\x34", 0, 0x5686}, /* East Asian ideograph */
  {"\x35", 0, 0x5684}, /* East Asian ideograph */
  {"\x36", 0, 0x5691}, /* East Asian ideograph */
  {"\x37", 0, 0x568A}, /* East Asian ideograph */
  {"\x3E", 0, 0x569E}, /* East Asian ideograph */
  {"\x41", 0, 0x569C}, /* East Asian ideograph */
  {"\x42", 0, 0x569A}, /* East Asian ideograph */
  {"\x45", 0, 0x5699}, /* East Asian ideograph */
  {"\x4B", 0, 0x56AD}, /* East Asian ideograph */
  {"\x4C", 0, 0x56A6}, /* East Asian ideograph */
  {"\x4E", 0, 0x56AC}, /* East Asian ideograph */
  {"\x53", 0, 0x56B2}, /* East Asian ideograph */
  {"\x5A", 0, 0x56B3}, /* East Asian ideograph */
  {"\x5B", 0, 0x56C3}, /* East Asian ideograph */
  {"\x60", 0, 0x56C5}, /* East Asian ideograph */
  {"\x62", 0, 0x56CF}, /* East Asian ideograph */
  {"\x67", 0, 0x56CD}, /* East Asian ideograph */
  {"\x6A", 0, 0x56D4}, /* East Asian ideograph */
  {"\x6B", 0, 0x56D7}, /* East Asian ideograph */
  {"\x6D", 0, 0x56DD}, /* East Asian ideograph */
  {"\x6F", 0, 0x56E1}, /* East Asian ideograph */
  {"\x70", 0, 0x56DF}, /* East Asian ideograph */
  {"\x75", 0, 0x56EB}, /* East Asian ideograph */
  {"\x76", 0, 0x56EE}, /* East Asian ideograph */
  {"\x77", 0, 0x56E7}, /* East Asian ideograph */
  {"\x79", 0, 0x56FB}, /* East Asian ideograph */
  {"\x7E", 0, 0x56F7}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page70 = {
  marc8_31page70_flat, 0
};
/* PAGE 69 */
struct yaz_iconv_trie_flat marc8_31page69_flat[] = {
  {"\x24", 0, 0x55FB}, /* East Asian ideograph */
  {"\x25", 0, 0x5612}, /* East Asian ideograph */
  {"\x27", 0, 0x55F8}, /* East Asian ideograph */
  {"\x28", 0, 0x560F}, /* East Asian ideograph */
  {"\x2B", 0, 0x55F9}, /* East Asian ideograph */
  {"\x2E", 0, 0x561E}, /* East Asian ideograph */
  {"\x31", 0, 0x560C}, /* East Asian ideograph */
  {"\x34", 0, 0x561C}, /* East Asian ideograph */
  {"\x35", 0, 0x5610}, /* East Asian ideograph */
  {"\x36", 0, 0x5601}, /* East Asian ideograph */
  {"\x38", 0, 0x5613}, /* East Asian ideograph */
  {"\x39", 0, 0x55F6}, /* East Asian ideograph */
  {"\x3C", 0, 0x5602}, /* East Asian ideograph */
  {"\x42", 0, 0x561D}, /* East Asian ideograph */
  {"\x44", 0, 0x55FF}, /* East Asian ideograph */
  {"\x47", 0, 0x5642}, /* East Asian ideograph */
  {"\x48", 0, 0x564C}, /* East Asian ideograph */
  {"\x4B", 0, 0x564B}, /* East Asian ideograph */
  {"\x52", 0, 0x5640}, /* East Asian ideograph */
  {"\x55", 0, 0x5635}, /* East Asian ideograph */
  {"\x57", 0, 0x5649}, /* East Asian ideograph */
  {"\x58", 0, 0x5641}, /* East Asian ideograph */
  {"\x5C", 0, 0x5658}, /* East Asian ideograph */
  {"\x5D", 0, 0x5620}, /* East Asian ideograph */
  {"\x5E", 0, 0x5654}, /* East Asian ideograph */
  {"\x60", 0, 0x562A}, /* East Asian ideograph */
  {"\x61", 0, 0x563D}, /* East Asian ideograph */
  {"\x64", 0, 0x562C}, /* East Asian ideograph */
  {"\x67", 0, 0x5638}, /* East Asian ideograph */
  {"\x69", 0, 0x564D}, /* East Asian ideograph */
  {"\x6B", 0, 0x562B}, /* East Asian ideograph */
  {"\x6C", 0, 0x564F}, /* East Asian ideograph */
  {"\x6E", 0, 0x5670}, /* East Asian ideograph */
  {"\x6F", 0, 0x565F}, /* East Asian ideograph */
  {"\x70", 0, 0x567C}, /* East Asian ideograph */
  {"\x72", 0, 0x5660}, /* East Asian ideograph */
  {"\x78", 0, 0x5676}, /* East Asian ideograph */
  {"\x7A", 0, 0x5666}, /* East Asian ideograph */
  {"\x7B", 0, 0x5673}, /* East Asian ideograph */
  {"\x7C", 0, 0x566D}, /* East Asian ideograph */
  {"\x7E", 0, 0x5672}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page69 = {
  marc8_31page69_flat, 0
};
/* PAGE 68 */
struct yaz_iconv_trie_flat marc8_31page68_flat[] = {
  {"\x23", 0, 0x5591}, /* East Asian ideograph */
  {"\x25", 0, 0x5577}, /* East Asian ideograph */
  {"\x26", 0, 0x55A8}, /* East Asian ideograph */
  {"\x27", 0, 0x55AD}, /* East Asian ideograph */
  {"\x2A", 0, 0x5605}, /* East Asian ideograph */
  {"\x2D", 0, 0x5593}, /* East Asian ideograph */
  {"\x2F", 0, 0x5586}, /* East Asian ideograph */
  {"\x34", 0, 0x5588}, /* East Asian ideograph */
  {"\x36", 0, 0x55B4}, /* East Asian ideograph */
  {"\x43", 0, 0x55E2}, /* East Asian ideograph (variant of EACC 2D7143) */
  {"\x44", 0, 0x5581}, /* East Asian ideograph */
  {"\x45", 0, 0x558E}, /* East Asian ideograph */
  {"\x47", 0, 0x55B5}, /* East Asian ideograph */
  {"\x49", 0, 0x558F}, /* East Asian ideograph */
  {"\x4B", 0, 0x5559}, /* East Asian ideograph */
  {"\x50", 0, 0x55A4}, /* East Asian ideograph */
  {"\x51", 0, 0x5592}, /* East Asian ideograph */
  {"\x52", 0, 0x5599}, /* East Asian ideograph */
  {"\x56", 0, 0x55F4}, /* East Asian ideograph */
  {"\x58", 0, 0x55CC}, /* East Asian ideograph */
  {"\x59", 0, 0x55D0}, /* East Asian ideograph */
  {"\x5A", 0, 0x55DB}, /* East Asian ideograph */
  {"\x5B", 0, 0x55CD}, /* East Asian ideograph */
  {"\x5C", 0, 0x55DE}, /* East Asian ideograph */
  {"\x5D", 0, 0x55D9}, /* East Asian ideograph */
  {"\x5E", 0, 0x55C3}, /* East Asian ideograph */
  {"\x5F", 0, 0x55C9}, /* East Asian ideograph */
  {"\x61", 0, 0x55CA}, /* East Asian ideograph */
  {"\x62", 0, 0x55DD}, /* East Asian ideograph */
  {"\x64", 0, 0x55D4}, /* East Asian ideograph */
  {"\x65", 0, 0x55C4}, /* East Asian ideograph */
  {"\x69", 0, 0x55E9}, /* East Asian ideograph */
  {"\x6F", 0, 0x55CF}, /* East Asian ideograph */
  {"\x70", 0, 0x55D2}, /* East Asian ideograph */
  {"\x75", 0, 0x55E5}, /* East Asian ideograph */
  {"\x77", 0, 0x55D6}, /* East Asian ideograph */
  {"\x78", 0, 0x55C1}, /* East Asian ideograph */
  {"\x79", 0, 0x55F2}, /* East Asian ideograph */
  {"\x7E", 0, 0x5627}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page68 = {
  marc8_31page68_flat, 0
};
/* PAGE 67 */
struct yaz_iconv_trie_flat marc8_31page67_flat[] = {
  {"\x23", 0, 0x5517}, /* East Asian ideograph */
  {"\x24", 0, 0x54FD}, /* East Asian ideograph */
  {"\x25", 0, 0x54E7}, /* East Asian ideograph */
  {"\x27", 0, 0x54F3}, /* East Asian ideograph */
  {"\x2A", 0, 0x54E4}, /* East Asian ideograph */
  {"\x2B", 0, 0x550A}, /* East Asian ideograph */
  {"\x2D", 0, 0x54FF}, /* East Asian ideograph */
  {"\x2E", 0, 0x5518}, /* East Asian ideograph */
  {"\x30", 0, 0x5504}, /* East Asian ideograph */
  {"\x32", 0, 0x54EF}, /* East Asian ideograph */
  {"\x34", 0, 0x5508}, /* East Asian ideograph */
  {"\x38", 0, 0x54F6}, /* East Asian ideograph */
  {"\x39", 0, 0x54F7}, /* East Asian ideograph */
  {"\x3E", 0, 0x550E}, /* East Asian ideograph */
  {"\x44", 0, 0x5523}, /* East Asian ideograph */
  {"\x46", 0, 0x550F}, /* East Asian ideograph */
  {"\x47", 0, 0x5511}, /* East Asian ideograph */
  {"\x4B", 0, 0x5575}, /* East Asian ideograph */
  {"\x4D", 0, 0x5573}, /* East Asian ideograph */
  {"\x4E", 0, 0x554C}, /* East Asian ideograph */
  {"\x4F", 0, 0x5576}, /* East Asian ideograph */
  {"\x50", 0, 0x554D}, /* East Asian ideograph */
  {"\x51", 0, 0x555A}, /* East Asian ideograph */
  {"\x53", 0, 0x553C}, /* East Asian ideograph */
  {"\x55", 0, 0x5550}, /* East Asian ideograph */
  {"\x57", 0, 0x5539}, /* East Asian ideograph */
  {"\x58", 0, 0x5548}, /* East Asian ideograph */
  {"\x59", 0, 0x552D}, /* East Asian ideograph */
  {"\x5A", 0, 0x5551}, /* East Asian ideograph */
  {"\x5D", 0, 0x552A}, /* East Asian ideograph */
  {"\x60", 0, 0x5562}, /* East Asian ideograph */
  {"\x61", 0, 0x5536}, /* East Asian ideograph */
  {"\x64", 0, 0x5549}, /* East Asian ideograph */
  {"\x68", 0, 0x5530}, /* East Asian ideograph */
  {"\x6A", 0, 0x5540}, /* East Asian ideograph */
  {"\x6B", 0, 0x5535}, /* East Asian ideograph */
  {"\x70", 0, 0x5545}, /* East Asian ideograph */
  {"\x79", 0, 0x553F}, /* East Asian ideograph */
  {"\x7B", 0, 0x5541}, /* East Asian ideograph */
  {"\x7D", 0, 0x5565}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page67 = {
  marc8_31page67_flat, 0
};
/* PAGE 66 */
struct yaz_iconv_trie_flat marc8_31page66_flat[] = {
  {"\x21", 0, 0x544F}, /* East Asian ideograph */
  {"\x24", 0, 0x542A}, /* East Asian ideograph */
  {"\x26", 0, 0x5422}, /* East Asian ideograph */
  {"\x27", 0, 0x5423}, /* East Asian ideograph */
  {"\x2E", 0, 0x545F}, /* East Asian ideograph */
  {"\x2F", 0, 0x549C}, /* East Asian ideograph */
  {"\x35", 0, 0x5488}, /* East Asian ideograph */
  {"\x37", 0, 0x547F}, /* East Asian ideograph */
  {"\x39", 0, 0x5482}, /* East Asian ideograph */
  {"\x3A", 0, 0x546D}, /* East Asian ideograph */
  {"\x3B", 0, 0x5491}, /* East Asian ideograph */
  {"\x42", 0, 0x5494}, /* East Asian ideograph */
  {"\x43", 0, 0x546B}, /* East Asian ideograph */
  {"\x49", 0, 0x548D}, /* East Asian ideograph */
  {"\x4A", 0, 0x5463}, /* East Asian ideograph */
  {"\x4B", 0, 0x5474}, /* East Asian ideograph */
  {"\x52", 0, 0x5466}, /* East Asian ideograph */
  {"\x53", 0, 0x5464}, /* East Asian ideograph */
  {"\x55", 0, 0x54A4}, /* East Asian ideograph */
  {"\x58", 0, 0x54A1}, /* East Asian ideograph */
  {"\x5A", 0, 0x54AD}, /* East Asian ideograph */
  {"\x5B", 0, 0x54BA}, /* East Asian ideograph */
  {"\x5C", 0, 0x54CF}, /* East Asian ideograph */
  {"\x5E", 0, 0x54BE}, /* East Asian ideograph */
  {"\x60", 0, 0x54A5}, /* East Asian ideograph */
  {"\x63", 0, 0x54A7}, /* East Asian ideograph */
  {"\x64", 0, 0x54B5}, /* East Asian ideograph */
  {"\x66", 0, 0x54A2}, /* East Asian ideograph */
  {"\x67", 0, 0x5472}, /* East Asian ideograph */
  {"\x68", 0, 0x5470}, /* East Asian ideograph */
  {"\x69", 0, 0x54BC}, /* East Asian ideograph */
  {"\x6A", 0, 0x54B7}, /* East Asian ideograph */
  {"\x6B", 0, 0x54DE}, /* East Asian ideograph */
  {"\x6C", 0, 0x54D6}, /* East Asian ideograph */
  {"\x6D", 0, 0x54AE}, /* East Asian ideograph */
  {"\x71", 0, 0x54BF}, /* East Asian ideograph */
  {"\x74", 0, 0x54C6}, /* East Asian ideograph */
  {"\x7B", 0, 0x551A}, /* East Asian ideograph */
  {"\x7C", 0, 0x54E2}, /* East Asian ideograph */
  {"\x7D", 0, 0x5507}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page66 = {
  marc8_31page66_flat, 0
};
/* PAGE 65 */
struct yaz_iconv_trie_flat marc8_31page65_flat[] = {
  {"\x2C", 0, 0x53B5}, /* East Asian ideograph */
  {"\x2E", 0, 0x53B9}, /* East Asian ideograph */
  {"\x3E", 0, 0x53D0}, /* East Asian ideograph */
  {"\x48", 0, 0x53DA}, /* East Asian ideograph */
  {"\x57", 0, 0x53FB}, /* East Asian ideograph */
  {"\x58", 0, 0x535F}, /* East Asian ideograph */
  {"\x61", 0, 0x5414}, /* East Asian ideograph */
  {"\x68", 0, 0x5406}, /* East Asian ideograph */
  {"\x6C", 0, 0x544C}, /* East Asian ideograph */
  {"\x6D", 0, 0x5445}, /* East Asian ideograph */
  {"\x6F", 0, 0x541A}, /* East Asian ideograph */
  {"\x70", 0, 0x5432}, /* East Asian ideograph */
  {"\x76", 0, 0x5421}, /* East Asian ideograph */
  {"\x78", 0, 0x5430}, /* East Asian ideograph */
  {"\x79", 0, 0x5454}, /* East Asian ideograph */
  {"\x7D", 0, 0x543D}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page65 = {
  marc8_31page65_flat, 0
};
/* PAGE 64 */
struct yaz_iconv_trie_flat marc8_31page64_flat[] = {
  {"\x23", 0, 0x531A}, /* East Asian ideograph */
  {"\x24", 0, 0x531C}, /* East Asian ideograph */
  {"\x25", 0, 0x531F}, /* East Asian ideograph */
  {"\x2E", 0, 0x532D}, /* East Asian ideograph */
  {"\x33", 0, 0x5330}, /* East Asian ideograph */
  {"\x36", 0, 0x5335}, /* East Asian ideograph */
  {"\x3A", 0, 0x5338}, /* East Asian ideograph */
  {"\x3E", 0, 0x533D}, /* East Asian ideograph */
  {"\x41", 0, 0x534C}, /* East Asian ideograph */
  {"\x42", 0, 0x534D}, /* East Asian ideograph */
  {"\x4B", 0, 0x535D}, /* East Asian ideograph */
  {"\x4C", 0, 0x5363}, /* East Asian ideograph */
  {"\x4E", 0, 0x5365}, /* East Asian ideograph */
  {"\x53", 0, 0x536C}, /* East Asian ideograph */
  {"\x57", 0, 0x5372}, /* East Asian ideograph */
  {"\x58", 0, 0x537A}, /* East Asian ideograph */
  {"\x5D", 0, 0x5380}, /* East Asian ideograph */
  {"\x64", 0, 0x538E}, /* East Asian ideograph */
  {"\x66", 0, 0x5393}, /* East Asian ideograph */
  {"\x67", 0, 0x5394}, /* East Asian ideograph */
  {"\x6D", 0, 0x5399}, /* East Asian ideograph */
  {"\x74", 0, 0x8652}, /* East Asian ideograph */
  {"\x7A", 0, 0x53A4}, /* East Asian ideograph */
  {"\x7B", 0, 0x53AB}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page64 = {
  marc8_31page64_flat, 0
};
/* PAGE 63 */
struct yaz_iconv_trie_flat marc8_31page63_flat[] = {
  {"\x21", 0, 0x5293}, /* East Asian ideograph */
  {"\x27", 0, 0x5296}, /* East Asian ideograph */
  {"\x29", 0, 0x5298}, /* East Asian ideograph */
  {"\x2B", 0, 0x529A}, /* East Asian ideograph */
  {"\x2C", 0, 0x5299}, /* East Asian ideograph */
  {"\x2E", 0, 0x52A6}, /* East Asian ideograph */
  {"\x31", 0, 0x52AD}, /* East Asian ideograph */
  {"\x33", 0, 0x52AE}, /* East Asian ideograph */
  {"\x37", 0, 0x52BB}, /* East Asian ideograph */
  {"\x38", 0, 0x52BC}, /* East Asian ideograph */
  {"\x3C", 0, 0x52CA}, /* East Asian ideograph */
  {"\x3D", 0, 0x52CD}, /* East Asian ideograph */
  {"\x40", 0, 0x52D0}, /* East Asian ideograph */
  {"\x41", 0, 0x52D1}, /* East Asian ideograph */
  {"\x46", 0, 0x52D4}, /* East Asian ideograph */
  {"\x48", 0, 0x52D6}, /* East Asian ideograph */
  {"\x4C", 0, 0x52E3}, /* East Asian ideograph */
  {"\x4E", 0, 0x52E1}, /* East Asian ideograph */
  {"\x50", 0, 0x55E7}, /* East Asian ideograph */
  {"\x53", 0, 0x52E9}, /* East Asian ideograph */
  {"\x58", 0, 0x52F0}, /* East Asian ideograph */
  {"\x5A", 0, 0x52F1}, /* East Asian ideograph */
  {"\x5E", 0, 0x52F7}, /* East Asian ideograph */
  {"\x61", 0, 0x52F9}, /* East Asian ideograph */
  {"\x62", 0, 0x52FA}, /* East Asian ideograph */
  {"\x64", 0, 0x52FC}, /* East Asian ideograph */
  {"\x69", 0, 0x5307}, /* East Asian ideograph */
  {"\x6A", 0, 0x5303}, /* East Asian ideograph */
  {"\x6B", 0, 0x5306}, /* East Asian ideograph */
  {"\x6E", 0, 0x530A}, /* East Asian ideograph */
  {"\x6F", 0, 0x530B}, /* East Asian ideograph */
  {"\x77", 0, 0x5311}, /* East Asian ideograph */
  {"\x7B", 0, 0x6706}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page63 = {
  marc8_31page63_flat, 0
};
/* PAGE 62 */
struct yaz_iconv_trie_flat marc8_31page62_flat[] = {
  {"\x24", 0, 0x5213}, /* East Asian ideograph */
  {"\x26", 0, 0x5216}, /* East Asian ideograph */
  {"\x2A", 0, 0x521C}, /* East Asian ideograph */
  {"\x33", 0, 0x5231}, /* East Asian ideograph */
  {"\x36", 0, 0x5235}, /* East Asian ideograph */
  {"\x37", 0, 0x5232}, /* East Asian ideograph */
  {"\x39", 0, 0x5233}, /* East Asian ideograph */
  {"\x3E", 0, 0x5244}, /* East Asian ideograph */
  {"\x43", 0, 0x5249}, /* East Asian ideograph */
  {"\x47", 0, 0x5260}, /* East Asian ideograph */
  {"\x4B", 0, 0x525A}, /* East Asian ideograph */
  {"\x4C", 0, 0x5252}, /* East Asian ideograph */
  {"\x4D", 0, 0x525E}, /* East Asian ideograph */
  {"\x50", 0, 0x525F}, /* East Asian ideograph */
  {"\x53", 0, 0x5255}, /* East Asian ideograph */
  {"\x5B", 0, 0x526E}, /* East Asian ideograph */
  {"\x5E", 0, 0x5268}, /* East Asian ideograph */
  {"\x5F", 0, 0x7B9A}, /* East Asian ideograph */
  {"\x6B", 0, 0x5278}, /* East Asian ideograph */
  {"\x74", 0, 0x5282}, /* East Asian ideograph */
  {"\x75", 0, 0x5281}, /* East Asian ideograph */
  {"\x79", 0, 0x528C}, /* East Asian ideograph */
  {"\x7A", 0, 0x528A}, /* East Asian ideograph */
  {"\x7C", 0, 0x5290}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page62 = {
  marc8_31page62_flat, 0
};
/* PAGE 61 */
struct yaz_iconv_trie_flat marc8_31page61_flat[] = {
  {"\x22", 0, 0x51AA}, /* East Asian ideograph */
  {"\x23", 0, 0x51AB}, /* East Asian ideograph */
  {"\x26", 0, 0x51B1}, /* East Asian ideograph */
  {"\x35", 0, 0x51BC}, /* East Asian ideograph */
  {"\x43", 0, 0x51CA}, /* East Asian ideograph */
  {"\x46", 0, 0x51C7}, /* East Asian ideograph */
  {"\x4E", 0, 0x51D1}, /* East Asian ideograph */
  {"\x4F", 0, 0x51D0}, /* East Asian ideograph */
  {"\x54", 0, 0x51D3}, /* East Asian ideograph */
  {"\x63", 0, 0x51D9}, /* East Asian ideograph */
  {"\x66", 0, 0x51DF}, /* East Asian ideograph */
  {"\x68", 0, 0x51E2}, /* East Asian ideograph */
  {"\x73", 0, 0x5160}, /* East Asian ideograph */
  {"\x78", 0, 0x51F5}, /* East Asian ideograph */
  {"\x79", 0, 0x51F7}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page61 = {
  marc8_31page61_flat, 0
};
/* PAGE 60 */
struct yaz_iconv_trie_flat marc8_31page60_flat[] = {
  {"\x29", 0, 0x5124}, /* East Asian ideograph */
  {"\x2B", 0, 0x5129}, /* East Asian ideograph */
  {"\x30", 0, 0x5131}, /* East Asian ideograph */
  {"\x3E", 0, 0x5135}, /* East Asian ideograph */
  {"\x40", 0, 0x5133}, /* East Asian ideograph */
  {"\x44", 0, 0x513A}, /* East Asian ideograph */
  {"\x47", 0, 0x5139}, /* East Asian ideograph */
  {"\x48", 0, 0x513B}, /* East Asian ideograph */
  {"\x51", 0, 0x5159}, /* East Asian ideograph */
  {"\x52", 0, 0x515B}, /* East Asian ideograph */
  {"\x55", 0, 0x515D}, /* East Asian ideograph */
  {"\x56", 0, 0x515E}, /* East Asian ideograph */
  {"\x58", 0, 0x515F}, /* East Asian ideograph */
  {"\x59", 0, 0x5161}, /* East Asian ideograph */
  {"\x5C", 0, 0x5163}, /* East Asian ideograph */
  {"\x67", 0, 0x5182}, /* East Asian ideograph */
  {"\x69", 0, 0x5184}, /* East Asian ideograph */
  {"\x6E", 0, 0x518F}, /* East Asian ideograph */
  {"\x70", 0, 0x5194}, /* East Asian ideograph */
  {"\x71", 0, 0x5193}, /* East Asian ideograph */
  {"\x75", 0, 0x5196}, /* East Asian ideograph */
  {"\x7B", 0, 0x51A1}, /* East Asian ideograph */
  {"\x7C", 0, 0x51A3}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page60 = {
  marc8_31page60_flat, 0
};
/* PAGE 59 */
struct yaz_iconv_trie_flat marc8_31page59_flat[] = {
  {"\x22", 0, 0x50C2}, /* East Asian ideograph */
  {"\x2C", 0, 0x50BA}, /* East Asian ideograph */
  {"\x2E", 0, 0x50CD}, /* East Asian ideograph */
  {"\x32", 0, 0x50D4}, /* East Asian ideograph */
  {"\x34", 0, 0x50EF}, /* East Asian ideograph */
  {"\x35", 0, 0x50E6}, /* East Asian ideograph */
  {"\x3A", 0, 0x50F4}, /* East Asian ideograph */
  {"\x3B", 0, 0x50CE}, /* East Asian ideograph */
  {"\x3C", 0, 0x50DD}, /* East Asian ideograph */
  {"\x41", 0, 0x50F3}, /* East Asian ideograph */
  {"\x42", 0, 0x50E8}, /* East Asian ideograph */
  {"\x44", 0, 0x50F0}, /* East Asian ideograph */
  {"\x46", 0, 0x50D9}, /* East Asian ideograph */
  {"\x55", 0, 0x50EC}, /* East Asian ideograph */
  {"\x5B", 0, 0x510E}, /* East Asian ideograph */
  {"\x5F", 0, 0x5105}, /* East Asian ideograph */
  {"\x61", 0, 0x50FC}, /* East Asian ideograph */
  {"\x65", 0, 0x5106}, /* East Asian ideograph */
  {"\x66", 0, 0x5107}, /* East Asian ideograph */
  {"\x67", 0, 0x510F}, /* East Asian ideograph */
  {"\x68", 0, 0x50FE}, /* East Asian ideograph */
  {"\x69", 0, 0x510B}, /* East Asian ideograph */
  {"\x6A", 0, 0x50FD}, /* East Asian ideograph */
  {"\x6D", 0, 0x5101}, /* East Asian ideograph */
  {"\x71", 0, 0x5115}, /* East Asian ideograph */
  {"\x72", 0, 0x5113}, /* East Asian ideograph */
  {"\x78", 0, 0x511A}, /* East Asian ideograph */
  {"\x79", 0, 0x9797}, /* East Asian ideograph */
  {"\x7E", 0, 0x5126}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page59 = {
  marc8_31page59_flat, 0
};
/* PAGE 58 */
struct yaz_iconv_trie_flat marc8_31page58_flat[] = {
  {"\x22", 0, 0x506F}, /* East Asian ideograph */
  {"\x23", 0, 0x5050}, /* East Asian ideograph */
  {"\x25", 0, 0x5070}, /* East Asian ideograph */
  {"\x29", 0, 0x5053}, /* East Asian ideograph */
  {"\x2A", 0, 0x506A}, /* East Asian ideograph */
  {"\x2C", 0, 0x5056}, /* East Asian ideograph */
  {"\x31", 0, 0x506D}, /* East Asian ideograph */
  {"\x38", 0, 0x505D}, /* East Asian ideograph */
  {"\x39", 0, 0x5048}, /* East Asian ideograph */
  {"\x3B", 0, 0x5058}, /* East Asian ideograph */
  {"\x3C", 0, 0x5072}, /* East Asian ideograph */
  {"\x41", 0, 0x5041}, /* East Asian ideograph */
  {"\x46", 0, 0x5015}, /* East Asian ideograph */
  {"\x48", 0, 0x507A}, /* East Asian ideograph */
  {"\x4A", 0, 0x506C}, /* East Asian ideograph */
  {"\x4B", 0, 0x505F}, /* East Asian ideograph */
  {"\x4D", 0, 0x506B}, /* East Asian ideograph */
  {"\x4E", 0, 0x5094}, /* East Asian ideograph */
  {"\x50", 0, 0x509E}, /* East Asian ideograph */
  {"\x52", 0, 0x509B}, /* East Asian ideograph */
  {"\x53", 0, 0x509A}, /* East Asian ideograph */
  {"\x57", 0, 0x50A3}, /* East Asian ideograph */
  {"\x5A", 0, 0x508C}, /* East Asian ideograph */
  {"\x5C", 0, 0x5088}, /* East Asian ideograph */
  {"\x62", 0, 0x508E}, /* East Asian ideograph */
  {"\x64", 0, 0x5095}, /* East Asian ideograph */
  {"\x67", 0, 0x50A6}, /* East Asian ideograph */
  {"\x6A", 0, 0x5092}, /* East Asian ideograph */
  {"\x6C", 0, 0x509C}, /* East Asian ideograph */
  {"\x71", 0, 0x50C7}, /* East Asian ideograph */
  {"\x75", 0, 0x50C9}, /* East Asian ideograph */
  {"\x7B", 0, 0x50CA}, /* East Asian ideograph */
  {"\x7C", 0, 0x50B4}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page58 = {
  marc8_31page58_flat, 0
};
/* PAGE 57 */
struct yaz_iconv_trie_flat marc8_31page57_flat[] = {
  {"\x22", 0, 0x4FE4}, /* East Asian ideograph */
  {"\x26", 0, 0x4FB7}, /* East Asian ideograph */
  {"\x27", 0, 0x4FC5}, /* East Asian ideograph */
  {"\x29", 0, 0x4FC9}, /* East Asian ideograph */
  {"\x2A", 0, 0x4FE5}, /* East Asian ideograph */
  {"\x2C", 0, 0x4FE7}, /* East Asian ideograph */
  {"\x33", 0, 0x4FDC}, /* East Asian ideograph */
  {"\x35", 0, 0x4FD4}, /* East Asian ideograph */
  {"\x37", 0, 0x4FC1}, /* East Asian ideograph */
  {"\x3B", 0, 0x4FDB}, /* East Asian ideograph */
  {"\x3E", 0, 0x4FC6}, /* East Asian ideograph */
  {"\x43", 0, 0x4FB9}, /* East Asian ideograph */
  {"\x46", 0, 0x501E}, /* East Asian ideograph */
  {"\x48", 0, 0x503F}, /* East Asian ideograph */
  {"\x49", 0, 0x5005}, /* East Asian ideograph */
  {"\x4C", 0, 0x5007}, /* East Asian ideograph */
  {"\x4D", 0, 0x5013}, /* East Asian ideograph */
  {"\x4E", 0, 0x5022}, /* East Asian ideograph */
  {"\x52", 0, 0x4FF5}, /* East Asian ideograph */
  {"\x59", 0, 0x4FF4}, /* East Asian ideograph */
  {"\x5B", 0, 0x5037}, /* East Asian ideograph */
  {"\x5E", 0, 0x502E}, /* East Asian ideograph */
  {"\x61", 0, 0x4FF6}, /* East Asian ideograph */
  {"\x62", 0, 0x501C}, /* East Asian ideograph */
  {"\x66", 0, 0x502C}, /* East Asian ideograph */
  {"\x69", 0, 0x5010}, /* East Asian ideograph */
  {"\x79", 0, 0x503D}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page57 = {
  marc8_31page57_flat, 0
};
/* PAGE 56 */
struct yaz_iconv_trie_flat marc8_31page56_flat[] = {
  {"\x27", 0, 0x4EF5}, /* East Asian ideograph */
  {"\x28", 0, 0x4F07}, /* East Asian ideograph */
  {"\x2A", 0, 0x4F00}, /* East Asian ideograph */
  {"\x2C", 0, 0x4F0B}, /* East Asian ideograph */
  {"\x32", 0, 0x4F3B}, /* East Asian ideograph */
  {"\x36", 0, 0x4F58}, /* East Asian ideograph */
  {"\x37", 0, 0x4F62}, /* East Asian ideograph */
  {"\x39", 0, 0x4F64}, /* East Asian ideograph */
  {"\x3A", 0, 0x4F49}, /* East Asian ideograph */
  {"\x3F", 0, 0x4F3E}, /* East Asian ideograph */
  {"\x40", 0, 0x4F66}, /* East Asian ideograph */
  {"\x44", 0, 0x4F67}, /* East Asian ideograph */
  {"\x4D", 0, 0x4F68}, /* East Asian ideograph */
  {"\x4E", 0, 0x4F5A}, /* East Asian ideograph */
  {"\x4F", 0, 0x4F5F}, /* East Asian ideograph */
  {"\x56", 0, 0x4F82}, /* East Asian ideograph */
  {"\x57", 0, 0x4F7C}, /* East Asian ideograph */
  {"\x5A", 0, 0x4F98}, /* East Asian ideograph */
  {"\x5B", 0, 0x4F92}, /* East Asian ideograph */
  {"\x5C", 0, 0x4F7D}, /* East Asian ideograph */
  {"\x60", 0, 0x4F80}, /* East Asian ideograph */
  {"\x61", 0, 0x4F74}, /* East Asian ideograph */
  {"\x62", 0, 0x4F76}, /* East Asian ideograph */
  {"\x64", 0, 0x4FA2}, /* East Asian ideograph */
  {"\x66", 0, 0x4F91}, /* East Asian ideograph */
  {"\x67", 0, 0x4F95}, /* East Asian ideograph */
  {"\x6C", 0, 0x4F4C}, /* East Asian ideograph */
  {"\x6D", 0, 0x4F97}, /* East Asian ideograph */
  {"\x6E", 0, 0x4F94}, /* East Asian ideograph */
  {"\x70", 0, 0x4F79}, /* East Asian ideograph */
  {"\x71", 0, 0x4F9A}, /* East Asian ideograph */
  {"\x72", 0, 0x4F81}, /* East Asian ideograph */
  {"\x73", 0, 0x4F78}, /* East Asian ideograph */
  {"\x76", 0, 0x4F9C}, /* East Asian ideograph */
  {"\x77", 0, 0x4F90}, /* East Asian ideograph */
  {"\x7B", 0, 0x4F7A}, /* East Asian ideograph */
  {"\x7C", 0, 0x4FCD}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page56 = {
  marc8_31page56_flat, 0
};
/* PAGE 55 */
struct yaz_iconv_trie_flat marc8_31page55_flat[] = {
  {"\x24", 0, 0x4E0F}, /* East Asian ideograph */
  {"\x25", 0, 0x5187}, /* East Asian ideograph */
  {"\x29", 0, 0x4E28}, /* East Asian ideograph */
  {"\x2E", 0, 0x4E31}, /* East Asian ideograph */
  {"\x31", 0, 0x4E36}, /* East Asian ideograph */
  {"\x33", 0, 0x4E3F}, /* East Asian ideograph */
  {"\x34", 0, 0x4E42}, /* East Asian ideograph */
  {"\x37", 0, 0x738D}, /* East Asian ideograph */
  {"\x3C", 0, 0x4E5C}, /* East Asian ideograph */
  {"\x3F", 0, 0x6C39}, /* East Asian ideograph */
  {"\x46", 0, 0x4E85}, /* East Asian ideograph */
  {"\x50", 0, 0x4EA0}, /* East Asian ideograph */
  {"\x51", 0, 0x4EA2}, /* East Asian ideograph */
  {"\x52", 0, 0x4EB3}, /* East Asian ideograph */
  {"\x55", 0, 0x4EB6}, /* East Asian ideograph (variant of EACC 4B6455) */
  {"\x58", 0, 0x4EB9}, /* East Asian ideograph */
  {"\x5A", 0, 0x4EBC}, /* East Asian ideograph */
  {"\x5E", 0, 0x4EC9}, /* East Asian ideograph */
  {"\x61", 0, 0x4EC8}, /* East Asian ideograph */
  {"\x62", 0, 0x4ECE}, /* East Asian ideograph */
  {"\x63", 0, 0x4EE8}, /* East Asian ideograph */
  {"\x6B", 0, 0x4EE1}, /* East Asian ideograph */
  {"\x72", 0, 0x4F08}, /* East Asian ideograph */
  {"\x73", 0, 0x4F0E}, /* East Asian ideograph */
  {"\x75", 0, 0x4F03}, /* East Asian ideograph */
  {"\x7C", 0, 0x4F22}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page55 = {
  marc8_31page55_flat, 0
};
/* PAGE 54 */
struct yaz_iconv_trie_flat marc8_31page54_flat[] = {
  {"\x21", 0, 0x9F52}, /* East Asian ideograph */
  {"\x22", 0, 0x9F5F}, /* East Asian ideograph */
  {"\x23", 0, 0x9F63}, /* East Asian ideograph */
  {"\x24", 0, 0x9F61}, /* East Asian ideograph (variant of EACC 456324) */
  {"\x25", 0, 0x9F66}, /* East Asian ideograph */
  {"\x26", 0, 0x9F5C}, /* East Asian ideograph */
  {"\x27", 0, 0x9F6C}, /* East Asian ideograph */
  {"\x28", 0, 0x9F6A}, /* East Asian ideograph */
  {"\x29", 0, 0x9F77}, /* East Asian ideograph */
  {"\x2A", 0, 0x9F72}, /* East Asian ideograph */
  {"\x2B", 0, 0x9F8D}, /* East Asian ideograph */
  {"\x2C", 0, 0x9F94}, /* East Asian ideograph */
  {"\x2D", 0, 0x9F9C}, /* East Asian ideograph */
  {"\x30", 0, 0x8288}, /* East Asian ideograph */
  {"", 0}
};
struct yaz_iconv_trie marc8_31page54 = {
  marc8_31page54_flat, 0
};
/* PAGE 53 */
struct yaz_iconv_trie_dir marc8_31page53_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x9C13} /* East Asian ideograph */,
  {0, 0, 0x9C0D} /* East Asian ideograph */,
  {0, 0, 0x9BFD} /* East Asian ideograph */,
  {0, 0, 0x9C2D} /* East Asian ideograph */,
  {0, 0, 0x9C25} /* East Asian ideograph */,
  {0, 0, 0x9C31} /* East Asian ideograph */,
  {0, 0, 0x9C3E} /* East Asian ideograph */,
  {0, 0, 0x9C3B} /* East Asian ideograph */,
  {0, 0, 0x9C54} /* East Asian ideograph */,
  {0, 0, 0x9C57} /* East Asian ideograph */,
  {0, 0, 0x9C56} /* East Asian ideograph */,
  {0, 0, 0x9C49} /* East Asian ideograph */,
  {0, 0, 0x9C77} /* East Asian ideograph */,
  {0, 0, 0x9C78} /* East Asian ideograph */,
  {0, 0, 0x9CE5} /* East Asian ideograph */,
  {0, 0, 0x9CE9} /* East Asian ideograph */,
  {0, 0, 0x9CF6} /* East Asian ideograph */,
  {0, 0, 0x9CF4} /* East Asian ideograph */,
  {0, 0, 0x9CF3} /* East Asian ideograph */,
  {0, 0, 0x9D06} /* East Asian ideograph */,
  {0, 0, 0x9D09} /* East Asian ideograph */,
  {0, 0, 0x9D15} /* East Asian ideograph */,
  {0, 0, 0x9D23} /* East Asian ideograph */,
  {0, 0, 0x9D28} /* East Asian ideograph */,
  {0, 0, 0x9D26} /* East Asian ideograph */,
  {0, 0, 0x9D1B} /* East Asian ideograph */,
  {0, 0, 0x9D12} /* East Asian ideograph (variant of EACC 4B623B) */,
  {0, 0, 0x9D3B} /* East Asian ideograph */,
  {0, 0, 0x9D3F} /* East Asian ideograph */,
  {0, 0, 0x9D61} /* East Asian ideograph */,
  {0, 0, 0x9D51} /* East Asian ideograph */,
  {0, 0, 0x9D60} /* East Asian ideograph */,
  {0, 0, 0x9D5D} /* East Asian ideograph */,
  {0, 0, 0x9D89} /* East Asian ideograph */,
  {0, 0, 0x9D72} /* East Asian ideograph */,
  {0, 0, 0x9D6A} /* East Asian ideograph */,
  {0, 0, 0x9D6C} /* East Asian ideograph */,
  {0, 0, 0x9DB4} /* East Asian ideograph */,
  {0, 0, 0x9DAF} /* East Asian ideograph */,
  {0, 0, 0x9DC2} /* East Asian ideograph */,
  {0, 0, 0x9DD3} /* East Asian ideograph */,
  {0, 0, 0x9DD7} /* East Asian ideograph */,
  {0, 0, 0x9DE5} /* East Asian ideograph */,
  {0, 0, 0x9DF9} /* East Asian ideograph */,
  {0, 0, 0x9DFA} /* East Asian ideograph */,
  {0, 0, 0x9E1A} /* East Asian ideograph */,
  {0, 0, 0x9E1E} /* East Asian ideograph */,
  {0, 0, 0x9E79} /* East Asian ideograph */,
  {0, 0, 0x9E7D} /* East Asian ideograph */,
  {0, 0, 0x9E7C} /* East Asian ideograph */,
  {0, 0, 0x9E7F} /* East Asian ideograph */,
  {0, 0, 0x9E82} /* East Asian ideograph */,
  {0, 0, 0x9E8B} /* East Asian ideograph */,
  {0, 0, 0x9E97} /* East Asian ideograph */,
  {0, 0, 0x9E92} /* East Asian ideograph */,
  {0, 0, 0x9E93} /* East Asian ideograph */,
  {0, 0, 0x9E9D} /* East Asian ideograph */,
  {0, 0, 0x9E9F} /* East Asian ideograph */,
  {0, 0, 0x9EA5} /* East Asian ideograph */,
  {0, 0, 0x9EA9} /* East Asian ideograph */,
  {0, 0, 0x9EB4} /* East Asian ideograph */,
  {0, 0, 0x9EB5} /* East Asian ideograph */,
  {0, 0, 0x9EBB} /* East Asian ideograph */,
  {0, 0, 0x9EBC} /* East Asian ideograph */,
  {0, 0, 0x9EBE} /* East Asian ideograph */,
  {0, 0, 0x9EC3} /* East Asian ideograph */,
  {0, 0, 0x9ECD} /* East Asian ideograph */,
  {0, 0, 0x9ECE} /* East Asian ideograph */,
  {0, 0, 0x9ECF} /* East Asian ideograph */,
  {0, 0, 0x9ED1} /* East Asian ideograph */,
  {0, 0, 0x58A8} /* East Asian ideograph */,
  {0, 0, 0x9ED8} /* East Asian ideograph */,
  {0, 0, 0x9ED4} /* East Asian ideograph */,
  {0, 0, 0x9EDE} /* East Asian ideograph */,
  {0, 0, 0x9EDC} /* East Asian ideograph */,
  {0, 0, 0x9EDB} /* East Asian ideograph */,
  {0, 0, 0x9EDD} /* East Asian ideograph */,
  {0, 0, 0x9EE0} /* East Asian ideograph */,
  {0, 0, 0x9EE8} /* East Asian ideograph */,
  {0, 0, 0x9EEF} /* East Asian ideograph */,
  {0, 0, 0x9EF4} /* East Asian ideograph */,
  {0, 0, 0x9EF7} /* East Asian ideograph */,
  {0, 0, 0x9F07} /* East Asian ideograph */,
  {0, 0, 0x9F0E} /* East Asian ideograph */,
  {0, 0, 0x9F13} /* East Asian ideograph */,
  {0, 0, 0x9F15} /* East Asian ideograph */,
  {0, 0, 0x9F19} /* East Asian ideograph */,
  {0, 0, 0x9F20} /* East Asian ideograph */,
  {0, 0, 0x9F2C} /* East Asian ideograph */,
  {0, 0, 0x9F34} /* East Asian ideograph */,
  {0, 0, 0x9F3B} /* East Asian ideograph */,
  {0, 0, 0x9F3E} /* East Asian ideograph */,
  {0, 0, 0x9F4A} /* East Asian ideograph */,
  {0, 0, 0x9F4B} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8_31page53 = {
  0, marc8_31page53_dir
};
/* PAGE 52 */
struct yaz_iconv_trie_dir marc8_31page52_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x993F} /* East Asian ideograph */,
  {0, 0, 0x993D} /* East Asian ideograph */,
  {0, 0, 0x9945} /* East Asian ideograph */,
  {0, 0, 0x9952} /* East Asian ideograph */,
  {0, 0, 0x9951} /* East Asian ideograph */,
  {0, 0, 0x995C} /* East Asian ideograph */,
  {0, 0, 0x995E} /* East Asian ideograph */,
  {0, 0, 0x9996} /* East Asian ideograph */,
  {0, 0, 0x9999} /* East Asian ideograph */,
  {0, 0, 0x99A5} /* East Asian ideograph */,
  {0, 0, 0x99A8} /* East Asian ideograph */,
  {0, 0, 0x99AC} /* East Asian ideograph */,
  {0, 0, 0x99AE} /* East Asian ideograph */,
  {0, 0, 0x99AD} /* East Asian ideograph */,
  {0, 0, 0x99B3} /* East Asian ideograph */,
  {0, 0, 0x99B1} /* East Asian ideograph */,
  {0, 0, 0x99B4} /* East Asian ideograph */,
  {0, 0, 0x99C1} /* East Asian ideograph */,
  {0, 0, 0x99D0} /* East Asian ideograph */,
  {0, 0, 0x99DD} /* East Asian ideograph */,
  {0, 0, 0x99D5} /* East Asian ideograph */,
  {0, 0, 0x99DF} /* East Asian ideograph */,
  {0, 0, 0x99DB} /* East Asian ideograph */,
  {0, 0, 0x99D2} /* East Asian ideograph */,
  {0, 0, 0x99D9} /* East Asian ideograph */,
  {0, 0, 0x99D1} /* East Asian ideograph */,
  {0, 0, 0x99ED} /* East Asian ideograph */,
  {0, 0, 0x99F1} /* East Asian ideograph */,
  {0, 0, 0x9A01} /* East Asian ideograph */,
  {0, 0, 0x99FF} /* East Asian ideograph */,
  {0, 0, 0x99E2} /* East Asian ideograph */,
  {0, 0, 0x9A0E} /* East Asian ideograph */,
  {0, 0, 0x9A19} /* East Asian ideograph */,
  {0, 0, 0x9A16} /* East Asian ideograph */,
  {0, 0, 0x9A2B} /* East Asian ideograph */,
  {0, 0, 0x9A30} /* East Asian ideograph */,
  {0, 0, 0x9A37} /* East Asian ideograph */,
  {0, 0, 0x9A43} /* East Asian ideograph */,
  {0, 0, 0x9A45} /* East Asian ideograph */,
  {0, 0, 0x9A40} /* East Asian ideograph */,
  {0, 0, 0x9A3E} /* East Asian ideograph */,
  {0, 0, 0x9A55} /* East Asian ideograph */,
  {0, 0, 0x9A5A} /* East Asian ideograph */,
  {0, 0, 0x9A5B} /* East Asian ideograph */,
  {0, 0, 0x9A57} /* East Asian ideograph */,
  {0, 0, 0x9A5F} /* East Asian ideograph */,
  {0, 0, 0x9A62} /* East Asian ideograph */,
  {0, 0, 0x9A65} /* East Asian ideograph */,
  {0, 0, 0x9A6A} /* East Asian ideograph */,
  {0, 0, 0x9AA8} /* East Asian ideograph */,
  {0, 0, 0x9AAF} /* East Asian ideograph */,
  {0, 0, 0x9AB0} /* East Asian ideograph */,
  {0, 0, 0x9AB7} /* East Asian ideograph */,
  {0, 0, 0x9AB8} /* East Asian ideograph */,
  {0, 0, 0x9ABC} /* East Asian ideograph */,
  {0, 0, 0x9ACF} /* East Asian ideograph */,
  {0, 0, 0x9AD3} /* East Asian ideograph */,
  {0, 0, 0x9AD4} /* East Asian ideograph */,
  {0, 0, 0x9AD2} /* East Asian ideograph */,
  {0, 0, 0x9AD8} /* East Asian ideograph */,
  {0, 0, 0x9AE5} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x9AEE} /* East Asian ideograph */,
  {0, 0, 0x9AFB} /* East Asian ideograph */,
  {0, 0, 0x9AED} /* East Asian ideograph */,
  {0, 0, 0x9B03} /* East Asian ideograph */,
  {0, 0, 0x9B06} /* East Asian ideograph */,
  {0, 0, 0x9B0D} /* East Asian ideograph */,
  {0, 0, 0x9B1A} /* East Asian ideograph */,
  {0, 0, 0x9B22} /* East Asian ideograph */,
  {0, 0, 0x9B25} /* East Asian ideograph */,
  {0, 0, 0x9B27} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x9B31} /* East Asian ideograph */,
  {0, 0, 0x9B32} /* East Asian ideograph */,
  {0, 0, 0x9B3C} /* East Asian ideograph */,
  {0, 0, 0x9B41} /* East Asian ideograph */,
  {0, 0, 0x9B42} /* East Asian ideograph */,
  {0, 0, 0x9B45} /* East Asian ideograph */,
  {0, 0, 0x9B44} /* East Asian ideograph */,
  {0, 0, 0x9B4F} /* East Asian ideograph */,
  {0, 0, 0x9B54} /* East Asian ideograph */,
  {0, 0, 0x9B58} /* East Asian ideograph */,
  {0, 0, 0x9B5A} /* East Asian ideograph */,
  {0, 0, 0x9B77} /* East Asian ideograph */,
  {0, 0, 0x9B6F} /* East Asian ideograph */,
  {0, 0, 0x9B91} /* East Asian ideograph */,
  {0, 0, 0x9BAB} /* East Asian ideograph */,
  {0, 0, 0x9BAE} /* East Asian ideograph */,
  {0, 0, 0x9BAA} /* East Asian ideograph */,
  {0, 0, 0x9BCA} /* East Asian ideograph */,
  {0, 0, 0x9BC9} /* East Asian ideograph */,
  {0, 0, 0x9BE8} /* East Asian ideograph */,
  {0, 0, 0x9BE7} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8_31page52 = {
  0, marc8_31page52_dir
};
/* PAGE 51 */
struct yaz_iconv_trie_dir marc8_31page51_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x978D} /* East Asian ideograph */,
  {0, 0, 0x978B} /* East Asian ideograph */,
  {0, 0, 0x978F} /* East Asian ideograph */,
  {0, 0, 0x9798} /* East Asian ideograph */,
  {0, 0, 0x97A0} /* East Asian ideograph */,
  {0, 0, 0x97A3} /* East Asian ideograph */,
  {0, 0, 0x97A6} /* East Asian ideograph */,
  {0, 0, 0x97AD} /* East Asian ideograph */,
  {0, 0, 0x97C3} /* East Asian ideograph */,
  {0, 0, 0x97C1} /* East Asian ideograph */,
  {0, 0, 0x97C6} /* East Asian ideograph */,
  {0, 0, 0x97CB} /* East Asian ideograph */,
  {0, 0, 0x97CC} /* East Asian ideograph */,
  {0, 0, 0x97D3} /* East Asian ideograph */,
  {0, 0, 0x97DC} /* East Asian ideograph */,
  {0, 0, 0x97ED} /* East Asian ideograph */,
  {0, 0, 0x97F3} /* East Asian ideograph */,
  {0, 0, 0x7AE0} /* East Asian ideograph */,
  {0, 0, 0x7ADF} /* East Asian ideograph */,
  {0, 0, 0x97F6} /* East Asian ideograph */,
  {0, 0, 0x97FB} /* East Asian ideograph */,
  {0, 0, 0x97FF} /* East Asian ideograph (variant of EACC 456036) */,
  {0, 0, 0x9801} /* East Asian ideograph */,
  {0, 0, 0x9802} /* East Asian ideograph */,
  {0, 0, 0x9803} /* East Asian ideograph */,
  {0, 0, 0x9805} /* East Asian ideograph */,
  {0, 0, 0x9806} /* East Asian ideograph */,
  {0, 0, 0x9808} /* East Asian ideograph */,
  {0, 0, 0x9810} /* East Asian ideograph */,
  {0, 0, 0x980A} /* East Asian ideograph */,
  {0, 0, 0x9811} /* East Asian ideograph */,
  {0, 0, 0x9813} /* East Asian ideograph */,
  {0, 0, 0x9812} /* East Asian ideograph */,
  {0, 0, 0x980C} /* East Asian ideograph */,
  {0, 0, 0x9817} /* East Asian ideograph */,
  {0, 0, 0x9818} /* East Asian ideograph (variant of EACC 4B6044) */,
  {0, 0, 0x9821} /* East Asian ideograph */,
  {0, 0, 0x982D} /* East Asian ideograph */,
  {0, 0, 0x9830} /* East Asian ideograph */,
  {0, 0, 0x9838} /* East Asian ideograph */,
  {0, 0, 0x983B} /* East Asian ideograph */,
  {0, 0, 0x9839} /* East Asian ideograph */,
  {0, 0, 0x9837} /* East Asian ideograph */,
  {0, 0, 0x9824} /* East Asian ideograph */,
  {0, 0, 0x9846} /* East Asian ideograph */,
  {0, 0, 0x9854} /* East Asian ideograph */,
  {0, 0, 0x984D} /* East Asian ideograph */,
  {0, 0, 0x984C} /* East Asian ideograph */,
  {0, 0, 0x984E} /* East Asian ideograph */,
  {0, 0, 0x9853} /* East Asian ideograph */,
  {0, 0, 0x985E} /* East Asian ideograph (variant of EACC 4B6053) */,
  {0, 0, 0x985A} /* East Asian ideograph */,
  {0, 0, 0x9858} /* East Asian ideograph */,
  {0, 0, 0x9867} /* East Asian ideograph */,
  {0, 0, 0x986B} /* East Asian ideograph */,
  {0, 0, 0x986F} /* East Asian ideograph */,
  {0, 0, 0x9871} /* East Asian ideograph */,
  {0, 0, 0x9870} /* East Asian ideograph */,
  {0, 0, 0x98A8} /* East Asian ideograph */,
  {0, 0, 0x98AF} /* East Asian ideograph */,
  {0, 0, 0x98B1} /* East Asian ideograph */,
  {0, 0, 0x98B3} /* East Asian ideograph */,
  {0, 0, 0x98B6} /* East Asian ideograph */,
  {0, 0, 0x98BA} /* East Asian ideograph */,
  {0, 0, 0x98BC} /* East Asian ideograph */,
  {0, 0, 0x98C4} /* East Asian ideograph */,
  {0, 0, 0x98DB} /* East Asian ideograph */,
  {0, 0, 0x98DF} /* East Asian ideograph */,
  {0, 0, 0x98E2} /* East Asian ideograph */,
  {0, 0, 0x98E7} /* East Asian ideograph */,
  {0, 0, 0x98E9} /* East Asian ideograph */,
  {0, 0, 0x98ED} /* East Asian ideograph */,
  {0, 0, 0x98EA} /* East Asian ideograph */,
  {0, 0, 0x98EE} /* East Asian ideograph */,
  {0, 0, 0x98EF} /* East Asian ideograph */,
  {0, 0, 0x98FC} /* East Asian ideograph */,
  {0, 0, 0x98F4} /* East Asian ideograph */,
  {0, 0, 0x98FD} /* East Asian ideograph */,
  {0, 0, 0x98FE} /* East Asian ideograph */,
  {0, 0, 0x9903} /* East Asian ideograph */,
  {0, 0, 0x990A} /* East Asian ideograph */,
  {0, 0, 0x990C} /* East Asian ideograph */,
  {0, 0, 0x9909} /* East Asian ideograph */,
  {0, 0, 0x9910} /* East Asian ideograph */,
  {0, 0, 0x9912} /* East Asian ideograph */,
  {0, 0, 0x9918} /* East Asian ideograph */,
  {0, 0, 0x9913} /* East Asian ideograph */,
  {0, 0, 0x9905} /* East Asian ideograph */,
  {0, 0, 0x9928} /* East Asian ideograph */,
  {0, 0, 0x991E} /* East Asian ideograph */,
  {0, 0, 0x991B} /* East Asian ideograph */,
  {0, 0, 0x9921} /* East Asian ideograph */,
  {0, 0, 0x9935} /* East Asian ideograph */,
  {0, 0, 0x993E} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8_31page51 = {
  0, marc8_31page51_dir
};
/* PAGE 50 */
struct yaz_iconv_trie_dir marc8_31page50_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x9664} /* East Asian ideograph */,
  {0, 0, 0x966A} /* East Asian ideograph */,
  {0, 0, 0x9673} /* East Asian ideograph */,
  {0, 0, 0x9678} /* East Asian ideograph */,
  {0, 0, 0x9675} /* East Asian ideograph */,
  {0, 0, 0x9672} /* East Asian ideograph */,
  {0, 0, 0x9676} /* East Asian ideograph */,
  {0, 0, 0x9677} /* East Asian ideograph */,
  {0, 0, 0x9674} /* East Asian ideograph */,
  {0, 0, 0x9670} /* East Asian ideograph */,
  {0, 0, 0x968A} /* East Asian ideograph */,
  {0, 0, 0x968E} /* East Asian ideograph */,
  {0, 0, 0x968B} /* East Asian ideograph */,
  {0, 0, 0x967D} /* East Asian ideograph */,
  {0, 0, 0x9685} /* East Asian ideograph */,
  {0, 0, 0x9686} /* East Asian ideograph */,
  {0, 0, 0x968D} /* East Asian ideograph */,
  {0, 0, 0x9698} /* East Asian ideograph */,
  {0, 0, 0x9694} /* East Asian ideograph */,
  {0, 0, 0x9699} /* East Asian ideograph */,
  {0, 0, 0x9695} /* East Asian ideograph */,
  {0, 0, 0x969C} /* East Asian ideograph */,
  {0, 0, 0x969B} /* East Asian ideograph */,
  {0, 0, 0x96A7} /* East Asian ideograph */,
  {0, 0, 0x96A8} /* East Asian ideograph */,
  {0, 0, 0x96AA} /* East Asian ideograph */,
  {0, 0, 0x96B1} /* East Asian ideograph */,
  {0, 0, 0x96B4} /* East Asian ideograph */,
  {0, 0, 0x96B8} /* East Asian ideograph */,
  {0, 0, 0x96BB} /* East Asian ideograph */,
  {0, 0, 0x96C0} /* East Asian ideograph */,
  {0, 0, 0x96C7} /* East Asian ideograph */,
  {0, 0, 0x96C6} /* East Asian ideograph */,
  {0, 0, 0x96C4} /* East Asian ideograph */,
  {0, 0, 0x96C1} /* East Asian ideograph */,
  {0, 0, 0x96C5} /* East Asian ideograph */,
  {0, 0, 0x96CD} /* East Asian ideograph */,
  {0, 0, 0x96CB} /* East Asian ideograph */,
  {0, 0, 0x96C9} /* East Asian ideograph */,
  {0, 0, 0x96CC} /* East Asian ideograph */,
  {0, 0, 0x96D5} /* East Asian ideograph */,
  {0, 0, 0x96D6} /* East Asian ideograph */,
  {0, 0, 0x96DC} /* East Asian ideograph */,
  {0, 0, 0x96DE} /* East Asian ideograph */,
  {0, 0, 0x96DB} /* East Asian ideograph */,
  {0, 0, 0x96D9} /* East Asian ideograph */,
  {0, 0, 0x96E2} /* East Asian ideograph */,
  {0, 0, 0x96E3} /* East Asian ideograph (variant of EACC 4B5F50) */,
  {0, 0, 0x96E8} /* East Asian ideograph */,
  {0, 0, 0x96EA} /* East Asian ideograph */,
  {0, 0, 0x96EF} /* East Asian ideograph */,
  {0, 0, 0x96F2} /* East Asian ideograph */,
  {0, 0, 0x96FB} /* East Asian ideograph */,
  {0, 0, 0x96F7} /* East Asian ideograph */,
  {0, 0, 0x96F9} /* East Asian ideograph */,
  {0, 0, 0x96F6} /* East Asian ideograph */,
  {0, 0, 0x9700} /* East Asian ideograph */,
  {0, 0, 0x9707} /* East Asian ideograph */,
  {0, 0, 0x9704} /* East Asian ideograph */,
  {0, 0, 0x9709} /* East Asian ideograph */,
  {0, 0, 0x9706} /* East Asian ideograph */,
  {0, 0, 0x9711} /* East Asian ideograph */,
  {0, 0, 0x970E} /* East Asian ideograph */,
  {0, 0, 0x9716} /* East Asian ideograph */,
  {0, 0, 0x970F} /* East Asian ideograph */,
  {0, 0, 0x970D} /* East Asian ideograph */,
  {0, 0, 0x9713} /* East Asian ideograph */,
  {0, 0, 0x971C} /* East Asian ideograph */,
  {0, 0, 0x971E} /* East Asian ideograph */,
  {0, 0, 0x972A} /* East Asian ideograph */,
  {0, 0, 0x9727} /* East Asian ideograph */,
  {0, 0, 0x9738} /* East Asian ideograph */,
  {0, 0, 0x9739} /* East Asian ideograph */,
  {0, 0, 0x9732} /* East Asian ideograph */,
  {0, 0, 0x973D} /* East Asian ideograph */,
  {0, 0, 0x973E} /* East Asian ideograph */,
  {0, 0, 0x9744} /* East Asian ideograph */,
  {0, 0, 0x9742} /* East Asian ideograph */,
  {0, 0, 0x9748} /* East Asian ideograph */,
  {0, 0, 0x9751} /* East Asian ideograph */,
  {0, 0, 0x9756} /* East Asian ideograph (variant of EACC 4B5F71) */,
  {0, 0, 0x975B} /* East Asian ideograph (variant of EACC 4B5F72) */,
  {0, 0, 0x975C} /* East Asian ideograph */,
  {0, 0, 0x975E} /* East Asian ideograph */,
  {0, 0, 0x9760} /* East Asian ideograph */,
  {0, 0, 0x9761} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x9766} /* East Asian ideograph */,
  {0, 0, 0x9768} /* East Asian ideograph */,
  {0, 0, 0x9769} /* East Asian ideograph */,
  {0, 0, 0x9776} /* East Asian ideograph */,
  {0, 0, 0x9774} /* East Asian ideograph */,
  {0, 0, 0x977C} /* East Asian ideograph */,
  {0, 0, 0x9785} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8_31page50 = {
  0, marc8_31page50_dir
};
/* PAGE 49 */
struct yaz_iconv_trie_dir marc8_31page49_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x937E} /* East Asian ideograph */,
  {0, 0, 0x9318} /* East Asian ideograph */,
  {0, 0, 0x936C} /* East Asian ideograph */,
  {0, 0, 0x935B} /* East Asian ideograph */,
  {0, 0, 0x938A} /* East Asian ideograph */,
  {0, 0, 0x9394} /* East Asian ideograph */,
  {0, 0, 0x93AE} /* East Asian ideograph */,
  {0, 0, 0x9396} /* East Asian ideograph */,
  {0, 0, 0x93A2} /* East Asian ideograph */,
  {0, 0, 0x93B3} /* East Asian ideograph */,
  {0, 0, 0x93E1} /* East Asian ideograph */,
  {0, 0, 0x93D1} /* East Asian ideograph */,
  {0, 0, 0x93D6} /* East Asian ideograph */,
  {0, 0, 0x93C3} /* East Asian ideograph */,
  {0, 0, 0x93DF} /* East Asian ideograph */,
  {0, 0, 0x93D7} /* East Asian ideograph */,
  {0, 0, 0x93C8} /* East Asian ideograph */,
  {0, 0, 0x93E2} /* East Asian ideograph */,
  {0, 0, 0x93DC} /* East Asian ideograph */,
  {0, 0, 0x93E4} /* East Asian ideograph */,
  {0, 0, 0x93DD} /* East Asian ideograph */,
  {0, 0, 0x93CD} /* East Asian ideograph */,
  {0, 0, 0x93D8} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x9403} /* East Asian ideograph */,
  {0, 0, 0x942E} /* East Asian ideograph */,
  {0, 0, 0x93FD} /* East Asian ideograph */,
  {0, 0, 0x9433} /* East Asian ideograph */,
  {0, 0, 0x9435} /* East Asian ideograph */,
  {0, 0, 0x943A} /* East Asian ideograph */,
  {0, 0, 0x9438} /* East Asian ideograph */,
  {0, 0, 0x9432} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x9451} /* East Asian ideograph */,
  {0, 0, 0x9444} /* East Asian ideograph */,
  {0, 0, 0x9463} /* East Asian ideograph */,
  {0, 0, 0x9460} /* East Asian ideograph */,
  {0, 0, 0x9472} /* East Asian ideograph */,
  {0, 0, 0x9470} /* East Asian ideograph */,
  {0, 0, 0x947E} /* East Asian ideograph */,
  {0, 0, 0x947C} /* East Asian ideograph */,
  {0, 0, 0x947D} /* East Asian ideograph */,
  {0, 0, 0x947F} /* East Asian ideograph */,
  {0, 0, 0x9577} /* East Asian ideograph */,
  {0, 0, 0x9580} /* East Asian ideograph */,
  {0, 0, 0x9582} /* East Asian ideograph */,
  {0, 0, 0x9583} /* East Asian ideograph */,
  {0, 0, 0x9589} /* East Asian ideograph */,
  {0, 0, 0x9594} /* East Asian ideograph */,
  {0, 0, 0x958F} /* East Asian ideograph */,
  {0, 0, 0x958B} /* East Asian ideograph */,
  {0, 0, 0x9591} /* East Asian ideograph */,
  {0, 0, 0x9593} /* East Asian ideograph */,
  {0, 0, 0x9592} /* East Asian ideograph */,
  {0, 0, 0x9598} /* East Asian ideograph */,
  {0, 0, 0x95A1} /* East Asian ideograph */,
  {0, 0, 0x95A8} /* East Asian ideograph */,
  {0, 0, 0x95A9} /* East Asian ideograph */,
  {0, 0, 0x95A3} /* East Asian ideograph */,
  {0, 0, 0x95A5} /* East Asian ideograph */,
  {0, 0, 0x95A4} /* East Asian ideograph */,
  {0, 0, 0x95B1} /* East Asian ideograph */,
  {0, 0, 0x95AD} /* East Asian ideograph */,
  {0, 0, 0x95BB} /* East Asian ideograph */,
  {0, 0, 0x95CA} /* East Asian ideograph */,
  {0, 0, 0x95CB} /* East Asian ideograph */,
  {0, 0, 0x95CC} /* East Asian ideograph */,
  {0, 0, 0x95C8} /* East Asian ideograph */,
  {0, 0, 0x95C6} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x95D6} /* East Asian ideograph */,
  {0, 0, 0x95D0} /* East Asian ideograph */,
  {0, 0, 0x95DC} /* East Asian ideograph */,
  {0, 0, 0x95E1} /* East Asian ideograph */,
  {0, 0, 0x95E2} /* East Asian ideograph */,
  {0, 0, 0x961C} /* East Asian ideograph */,
  {0, 0, 0x9621} /* East Asian ideograph */,
  {0, 0, 0x9632} /* East Asian ideograph */,
  {0, 0, 0x9631} /* East Asian ideograph */,
  {0, 0, 0x962E} /* East Asian ideograph */,
  {0, 0, 0x962A} /* East Asian ideograph */,
  {0, 0, 0x9640} /* East Asian ideograph */,
  {0, 0, 0x963F} /* East Asian ideograph */,
  {0, 0, 0x963B} /* East Asian ideograph */,
  {0, 0, 0x9644} /* East Asian ideograph */,
  {0, 0, 0x9650} /* East Asian ideograph */,
  {0, 0, 0x964C} /* East Asian ideograph */,
  {0, 0, 0x964B} /* East Asian ideograph */,
  {0, 0, 0x964D} /* East Asian ideograph */,
  {0, 0, 0x9662} /* East Asian ideograph */,
  {0, 0, 0x9663} /* East Asian ideograph */,
  {0, 0, 0x965B} /* East Asian ideograph */,
  {0, 0, 0x9661} /* East Asian ideograph */,
  {0, 0, 0x965D} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8_31page49 = {
  0, marc8_31page49_dir
};
/* PAGE 48 */
struct yaz_iconv_trie_dir marc8_31page48_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x9163} /* East Asian ideograph */,
  {0, 0, 0x9165} /* East Asian ideograph */,
  {0, 0, 0x916C} /* East Asian ideograph */,
  {0, 0, 0x9169} /* East Asian ideograph */,
  {0, 0, 0x916A} /* East Asian ideograph */,
  {0, 0, 0x9175} /* East Asian ideograph */,
  {0, 0, 0x9178} /* East Asian ideograph */,
  {0, 0, 0x9177} /* East Asian ideograph */,
  {0, 0, 0x9187} /* East Asian ideograph */,
  {0, 0, 0x9189} /* East Asian ideograph */,
  {0, 0, 0x918B} /* East Asian ideograph */,
  {0, 0, 0x9183} /* East Asian ideograph */,
  {0, 0, 0x9192} /* East Asian ideograph */,
  {0, 0, 0x91A3} /* East Asian ideograph */,
  {0, 0, 0x919E} /* East Asian ideograph */,
  {0, 0, 0x919C} /* East Asian ideograph */,
  {0, 0, 0x91AB} /* East Asian ideograph */,
  {0, 0, 0x91AC} /* East Asian ideograph */,
  {0, 0, 0x91BA} /* East Asian ideograph */,
  {0, 0, 0x91C0} /* East Asian ideograph */,
  {0, 0, 0x91C1} /* East Asian ideograph */,
  {0, 0, 0x91C7} /* East Asian ideograph */,
  {0, 0, 0x91C9} /* East Asian ideograph */,
  {0, 0, 0x91CB} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x91CD} /* East Asian ideograph */,
  {0, 0, 0x91CE} /* East Asian ideograph */,
  {0, 0, 0x91CF} /* East Asian ideograph */,
  {0, 0, 0x91D0} /* East Asian ideograph */,
  {0, 0, 0x91D1} /* East Asian ideograph */,
  {0, 0, 0x91DD} /* East Asian ideograph */,
  {0, 0, 0x91D8} /* East Asian ideograph */,
  {0, 0, 0x91D7} /* East Asian ideograph */,
  {0, 0, 0x91DC} /* East Asian ideograph */,
  {0, 0, 0x91F5} /* East Asian ideograph */,
  {0, 0, 0x91E6} /* East Asian ideograph */,
  {0, 0, 0x91E3} /* East Asian ideograph */,
  {0, 0, 0x91E7} /* East Asian ideograph */,
  {0, 0, 0x9223} /* East Asian ideograph */,
  {0, 0, 0x920D} /* East Asian ideograph */,
  {0, 0, 0x9215} /* East Asian ideograph */,
  {0, 0, 0x9209} /* East Asian ideograph */,
  {0, 0, 0x9214} /* East Asian ideograph */,
  {0, 0, 0x921E} /* East Asian ideograph */,
  {0, 0, 0x9210} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x9237} /* East Asian ideograph */,
  {0, 0, 0x9238} /* East Asian ideograph */,
  {0, 0, 0x923D} /* East Asian ideograph */,
  {0, 0, 0x923E} /* East Asian ideograph */,
  {0, 0, 0x9240} /* East Asian ideograph */,
  {0, 0, 0x924B} /* East Asian ideograph */,
  {0, 0, 0x925B} /* East Asian ideograph */,
  {0, 0, 0x9264} /* East Asian ideograph */,
  {0, 0, 0x9251} /* East Asian ideograph */,
  {0, 0, 0x9234} /* East Asian ideograph (variant of EACC 4B5D58) */,
  {0, 0, 0x9278} /* East Asian ideograph */,
  {0, 0, 0x9280} /* East Asian ideograph */,
  {0, 0, 0x92AC} /* East Asian ideograph */,
  {0, 0, 0x9285} /* East Asian ideograph */,
  {0, 0, 0x9298} /* East Asian ideograph */,
  {0, 0, 0x9296} /* East Asian ideograph */,
  {0, 0, 0x927B} /* East Asian ideograph */,
  {0, 0, 0x9293} /* East Asian ideograph */,
  {0, 0, 0x929C} /* East Asian ideograph */,
  {0, 0, 0x92C5} /* East Asian ideograph */,
  {0, 0, 0x92BB} /* East Asian ideograph */,
  {0, 0, 0x92B3} /* East Asian ideograph */,
  {0, 0, 0x92EA} /* East Asian ideograph */,
  {0, 0, 0x92B7} /* East Asian ideograph */,
  {0, 0, 0x92C1} /* East Asian ideograph */,
  {0, 0, 0x92E4} /* East Asian ideograph */,
  {0, 0, 0x92BC} /* East Asian ideograph */,
  {0, 0, 0x92D2} /* East Asian ideograph */,
  {0, 0, 0x9320} /* East Asian ideograph */,
  {0, 0, 0x9336} /* East Asian ideograph */,
  {0, 0, 0x92F8} /* East Asian ideograph */,
  {0, 0, 0x9333} /* East Asian ideograph */,
  {0, 0, 0x932F} /* East Asian ideograph */,
  {0, 0, 0x9322} /* East Asian ideograph */,
  {0, 0, 0x92FC} /* East Asian ideograph */,
  {0, 0, 0x932B} /* East Asian ideograph */,
  {0, 0, 0x931A} /* East Asian ideograph */,
  {0, 0, 0x9304} /* East Asian ideograph */,
  {0, 0, 0x9310} /* East Asian ideograph */,
  {0, 0, 0x9326} /* East Asian ideograph */,
  {0, 0, 0x934D} /* East Asian ideograph */,
  {0, 0, 0x9382} /* East Asian ideograph */,
  {0, 0, 0x9375} /* East Asian ideograph */,
  {0, 0, 0x9365} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x934B} /* East Asian ideograph */,
  {0, 0, 0x9328} /* East Asian ideograph */,
  {0, 0, 0x9370} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8_31page48 = {
  0, marc8_31page48_dir
};
/* PAGE 47 */
struct yaz_iconv_trie_dir marc8_31page47_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x901F} /* East Asian ideograph */,
  {0, 0, 0x9017} /* East Asian ideograph */,
  {0, 0, 0x901D} /* East Asian ideograph */,
  {0, 0, 0x9010} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x900D} /* East Asian ideograph */,
  {0, 0, 0x901E} /* East Asian ideograph */,
  {0, 0, 0x901A} /* East Asian ideograph */,
  {0, 0, 0x9020} /* East Asian ideograph */,
  {0, 0, 0x900F} /* East Asian ideograph */,
  {0, 0, 0x9022} /* East Asian ideograph */,
  {0, 0, 0x9016} /* East Asian ideograph */,
  {0, 0, 0x901B} /* East Asian ideograph */,
  {0, 0, 0x9014} /* East Asian ideograph */,
  {0, 0, 0x902E} /* East Asian ideograph */,
  {0, 0, 0x9035} /* East Asian ideograph */,
  {0, 0, 0x9031} /* East Asian ideograph */,
  {0, 0, 0x9038} /* East Asian ideograph (variant of EACC 4B5C32) */,
  {0, 0, 0x9032} /* East Asian ideograph */,
  {0, 0, 0x904B} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x9053} /* East Asian ideograph */,
  {0, 0, 0x9042} /* East Asian ideograph */,
  {0, 0, 0x9050} /* East Asian ideograph */,
  {0, 0, 0x9054} /* East Asian ideograph */,
  {0, 0, 0x9055} /* East Asian ideograph */,
  {0, 0, 0x903C} /* East Asian ideograph */,
  {0, 0, 0x9047} /* East Asian ideograph */,
  {0, 0, 0x904F} /* East Asian ideograph */,
  {0, 0, 0x904E} /* East Asian ideograph */,
  {0, 0, 0x904D} /* East Asian ideograph */,
  {0, 0, 0x9051} /* East Asian ideograph */,
  {0, 0, 0x9041} /* East Asian ideograph */,
  {0, 0, 0x903E} /* East Asian ideograph */,
  {0, 0, 0x9058} /* East Asian ideograph */,
  {0, 0, 0x9060} /* East Asian ideograph */,
  {0, 0, 0x905C} /* East Asian ideograph */,
  {0, 0, 0x9063} /* East Asian ideograph */,
  {0, 0, 0x9065} /* East Asian ideograph */,
  {0, 0, 0x905E} /* East Asian ideograph */,
  {0, 0, 0x9069} /* East Asian ideograph */,
  {0, 0, 0x906E} /* East Asian ideograph */,
  {0, 0, 0x9068} /* East Asian ideograph */,
  {0, 0, 0x906D} /* East Asian ideograph */,
  {0, 0, 0x9075} /* East Asian ideograph */,
  {0, 0, 0x9074} /* East Asian ideograph */,
  {0, 0, 0x9078} /* East Asian ideograph */,
  {0, 0, 0x9072} /* East Asian ideograph */,
  {0, 0, 0x9077} /* East Asian ideograph */,
  {0, 0, 0x907C} /* East Asian ideograph */,
  {0, 0, 0x907A} /* East Asian ideograph */,
  {0, 0, 0x907F} /* East Asian ideograph */,
  {0, 0, 0x907D} /* East Asian ideograph */,
  {0, 0, 0x9081} /* East Asian ideograph */,
  {0, 0, 0x9084} /* East Asian ideograph */,
  {0, 0, 0x9082} /* East Asian ideograph */,
  {0, 0, 0x9080} /* East Asian ideograph */,
  {0, 0, 0x9087} /* East Asian ideograph */,
  {0, 0, 0x908A} /* East Asian ideograph */,
  {0, 0, 0x9090} /* East Asian ideograph */,
  {0, 0, 0x908F} /* East Asian ideograph */,
  {0, 0, 0x9091} /* East Asian ideograph */,
  {0, 0, 0x9095} /* East Asian ideograph */,
  {0, 0, 0x90A3} /* East Asian ideograph */,
  {0, 0, 0x90A2} /* East Asian ideograph */,
  {0, 0, 0x90AA} /* East Asian ideograph */,
  {0, 0, 0x90A6} /* East Asian ideograph */,
  {0, 0, 0x90B5} /* East Asian ideograph */,
  {0, 0, 0x90B1} /* East Asian ideograph */,
  {0, 0, 0x90B8} /* East Asian ideograph */,
  {0, 0, 0x90CE} /* East Asian ideograph */,
  {0, 0, 0x90CA} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x90E1} /* East Asian ideograph */,
  {0, 0, 0x90E8} /* East Asian ideograph */,
  {0, 0, 0x90ED} /* East Asian ideograph */,
  {0, 0, 0x90F5} /* East Asian ideograph */,
  {0, 0, 0x90FD} /* East Asian ideograph */,
  {0, 0, 0x9102} /* East Asian ideograph */,
  {0, 0, 0x9109} /* East Asian ideograph */,
  {0, 0, 0x9112} /* East Asian ideograph */,
  {0, 0, 0x9119} /* East Asian ideograph */,
  {0, 0, 0x912D} /* East Asian ideograph */,
  {0, 0, 0x9130} /* East Asian ideograph */,
  {0, 0, 0x9127} /* East Asian ideograph */,
  {0, 0, 0x9131} /* East Asian ideograph */,
  {0, 0, 0x9139} /* East Asian ideograph (variant of EACC 4B5C77) */,
  {0, 0, 0x9149} /* East Asian ideograph */,
  {0, 0, 0x914B} /* East Asian ideograph */,
  {0, 0, 0x914A} /* East Asian ideograph */,
  {0, 0, 0x9152} /* East Asian ideograph */,
  {0, 0, 0x914D} /* East Asian ideograph */,
  {0, 0, 0x914C} /* East Asian ideograph */,
  {0, 0, 0x9157} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8_31page47 = {
  0, marc8_31page47_dir
};
/* PAGE 46 */
struct yaz_iconv_trie_dir marc8_31page46_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x8E76} /* East Asian ideograph */,
  {0, 0, 0x8E7C} /* East Asian ideograph */,
  {0, 0, 0x8E82} /* East Asian ideograph */,
  {0, 0, 0x8E81} /* East Asian ideograph */,
  {0, 0, 0x8E87} /* East Asian ideograph */,
  {0, 0, 0x8E89} /* East Asian ideograph */,
  {0, 0, 0x8E85} /* East Asian ideograph */,
  {0, 0, 0x8E8A} /* East Asian ideograph */,
  {0, 0, 0x8E8D} /* East Asian ideograph (variant of EACC 4B5B29) */,
  {0, 0, 0x8E91} /* East Asian ideograph */,
  {0, 0, 0x8EA1} /* East Asian ideograph */,
  {0, 0, 0x8EAA} /* East Asian ideograph */,
  {0, 0, 0x8EAB} /* East Asian ideograph */,
  {0, 0, 0x8EAC} /* East Asian ideograph */,
  {0, 0, 0x8EB2} /* East Asian ideograph */,
  {0, 0, 0x8EBA} /* East Asian ideograph */,
  {0, 0, 0x8EC0} /* East Asian ideograph */,
  {0, 0, 0x8ECA} /* East Asian ideograph */,
  {0, 0, 0x8ECB} /* East Asian ideograph */,
  {0, 0, 0x8ECD} /* East Asian ideograph */,
  {0, 0, 0x8ECC} /* East Asian ideograph */,
  {0, 0, 0x8ED2} /* East Asian ideograph */,
  {0, 0, 0x8ED4} /* East Asian ideograph */,
  {0, 0, 0x8EDF} /* East Asian ideograph */,
  {0, 0, 0x8EDB} /* East Asian ideograph */,
  {0, 0, 0x8EFB} /* East Asian ideograph */,
  {0, 0, 0x8EF8} /* East Asian ideograph */,
  {0, 0, 0x8EFC} /* East Asian ideograph */,
  {0, 0, 0x8F03} /* East Asian ideograph */,
  {0, 0, 0x8EFE} /* East Asian ideograph */,
  {0, 0, 0x8F09} /* East Asian ideograph */,
  {0, 0, 0x8F0A} /* East Asian ideograph */,
  {0, 0, 0x8F14} /* East Asian ideograph */,
  {0, 0, 0x8F12} /* East Asian ideograph */,
  {0, 0, 0x8F15} /* East Asian ideograph */,
  {0, 0, 0x8F13} /* East Asian ideograph */,
  {0, 0, 0x8F26} /* East Asian ideograph */,
  {0, 0, 0x8F1B} /* East Asian ideograph */,
  {0, 0, 0x8F1F} /* East Asian ideograph */,
  {0, 0, 0x8F1D} /* East Asian ideograph */,
  {0, 0, 0x8F29} /* East Asian ideograph */,
  {0, 0, 0x8F2A} /* East Asian ideograph */,
  {0, 0, 0x8F1C} /* East Asian ideograph */,
  {0, 0, 0x8F3B} /* East Asian ideograph */,
  {0, 0, 0x8F2F} /* East Asian ideograph */,
  {0, 0, 0x8F38} /* East Asian ideograph */,
  {0, 0, 0x8F44} /* East Asian ideograph */,
  {0, 0, 0x8F3E} /* East Asian ideograph */,
  {0, 0, 0x8F45} /* East Asian ideograph */,
  {0, 0, 0x8F42} /* East Asian ideograph (variant of EACC 4B5B52) */,
  {0, 0, 0x8F3F} /* East Asian ideograph */,
  {0, 0, 0x8F4D} /* East Asian ideograph */,
  {0, 0, 0x8F49} /* East Asian ideograph */,
  {0, 0, 0x8F54} /* East Asian ideograph */,
  {0, 0, 0x8F4E} /* East Asian ideograph */,
  {0, 0, 0x8F5F} /* East Asian ideograph */,
  {0, 0, 0x8F61} /* East Asian ideograph */,
  {0, 0, 0x8F9B} /* East Asian ideograph */,
  {0, 0, 0x8F9C} /* East Asian ideograph */,
  {0, 0, 0x8F9F} /* East Asian ideograph */,
  {0, 0, 0x8FA3} /* East Asian ideograph */,
  {0, 0, 0x8FA8} /* East Asian ideograph */,
  {0, 0, 0x8FA6} /* East Asian ideograph */,
  {0, 0, 0x8FAD} /* East Asian ideograph */,
  {0, 0, 0x8FAF} /* East Asian ideograph */,
  {0, 0, 0x8FB0} /* East Asian ideograph */,
  {0, 0, 0x8FB1} /* East Asian ideograph */,
  {0, 0, 0x8FB2} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x8FC6} /* East Asian ideograph */,
  {0, 0, 0x8FC5} /* East Asian ideograph */,
  {0, 0, 0x8FC4} /* East Asian ideograph */,
  {0, 0, 0x5DE1} /* East Asian ideograph */,
  {0, 0, 0x8FCE} /* East Asian ideograph */,
  {0, 0, 0x8FD1} /* East Asian ideograph */,
  {0, 0, 0x8FD4} /* East Asian ideograph */,
  {0, 0, 0x8FF0} /* East Asian ideograph (variant of EACC 275B6D) */,
  {0, 0, 0x8FE6} /* East Asian ideograph */,
  {0, 0, 0x8FE2} /* East Asian ideograph */,
  {0, 0, 0x8FEA} /* East Asian ideograph */,
  {0, 0, 0x8FE5} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x8FEB} /* East Asian ideograph */,
  {0, 0, 0x9001} /* East Asian ideograph */,
  {0, 0, 0x9006} /* East Asian ideograph */,
  {0, 0, 0x8FF7} /* East Asian ideograph */,
  {0, 0, 0x9000} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x9003} /* East Asian ideograph */,
  {0, 0, 0x8FFD} /* East Asian ideograph */,
  {0, 0, 0x9005} /* East Asian ideograph */,
  {0, 0, 0x9019} /* East Asian ideograph */,
  {0, 0, 0x9023} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8_31page46 = {
  0, marc8_31page46_dir
};
/* PAGE 45 */
struct yaz_iconv_trie_dir marc8_31page45_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x8CC5} /* East Asian ideograph */,
  {0, 0, 0x8CC7} /* East Asian ideograph */,
  {0, 0, 0x8CCA} /* East Asian ideograph */,
  {0, 0, 0x8CC8} /* East Asian ideograph */,
  {0, 0, 0x8CC4} /* East Asian ideograph */,
  {0, 0, 0x8CB2} /* East Asian ideograph */,
  {0, 0, 0x8CC3} /* East Asian ideograph */,
  {0, 0, 0x8CC2} /* East Asian ideograph */,
  {0, 0, 0x8CD3} /* East Asian ideograph */,
  {0, 0, 0x8CD1} /* East Asian ideograph */,
  {0, 0, 0x8CD2} /* East Asian ideograph */,
  {0, 0, 0x8CE0} /* East Asian ideograph */,
  {0, 0, 0x8CE6} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x8CE3} /* East Asian ideograph */,
  {0, 0, 0x8CE2} /* East Asian ideograph */,
  {0, 0, 0x8CE4} /* East Asian ideograph */,
  {0, 0, 0x8CDE} /* East Asian ideograph */,
  {0, 0, 0x8CDC} /* East Asian ideograph */,
  {0, 0, 0x8CEA} /* East Asian ideograph */,
  {0, 0, 0x8CED} /* East Asian ideograph */,
  {0, 0, 0x8CF4} /* East Asian ideograph */,
  {0, 0, 0x8CFD} /* East Asian ideograph */,
  {0, 0, 0x8CFA} /* East Asian ideograph */,
  {0, 0, 0x8D05} /* East Asian ideograph */,
  {0, 0, 0x8CFC} /* East Asian ideograph */,
  {0, 0, 0x8D08} /* East Asian ideograph (variant of EACC 4B5A3B) */,
  {0, 0, 0x8D0B} /* East Asian ideograph */,
  {0, 0, 0x8D0A} /* East Asian ideograph */,
  {0, 0, 0x8D0F} /* East Asian ideograph */,
  {0, 0, 0x8D0D} /* East Asian ideograph */,
  {0, 0, 0x8D13} /* East Asian ideograph */,
  {0, 0, 0x8D16} /* East Asian ideograph */,
  {0, 0, 0x8D1B} /* East Asian ideograph */,
  {0, 0, 0x8D64} /* East Asian ideograph */,
  {0, 0, 0x8D67} /* East Asian ideograph */,
  {0, 0, 0x8D66} /* East Asian ideograph */,
  {0, 0, 0x8D6B} /* East Asian ideograph */,
  {0, 0, 0x8D6D} /* East Asian ideograph */,
  {0, 0, 0x8D70} /* East Asian ideograph */,
  {0, 0, 0x8D74} /* East Asian ideograph */,
  {0, 0, 0x8D73} /* East Asian ideograph */,
  {0, 0, 0x8D77} /* East Asian ideograph */,
  {0, 0, 0x8D85} /* East Asian ideograph */,
  {0, 0, 0x8D8A} /* East Asian ideograph */,
  {0, 0, 0x8D81} /* East Asian ideograph */,
  {0, 0, 0x8D99} /* East Asian ideograph */,
  {0, 0, 0x8D95} /* East Asian ideograph */,
  {0, 0, 0x8DA3} /* East Asian ideograph */,
  {0, 0, 0x8D9F} /* East Asian ideograph */,
  {0, 0, 0x8DA8} /* East Asian ideograph */,
  {0, 0, 0x8DB3} /* East Asian ideograph */,
  {0, 0, 0x8DB4} /* East Asian ideograph */,
  {0, 0, 0x8DBE} /* East Asian ideograph */,
  {0, 0, 0x8DCE} /* East Asian ideograph */,
  {0, 0, 0x8DDD} /* East Asian ideograph */,
  {0, 0, 0x8DDB} /* East Asian ideograph */,
  {0, 0, 0x8DCB} /* East Asian ideograph */,
  {0, 0, 0x8DDA} /* East Asian ideograph */,
  {0, 0, 0x8DC6} /* East Asian ideograph */,
  {0, 0, 0x8DD1} /* East Asian ideograph */,
  {0, 0, 0x8DCC} /* East Asian ideograph */,
  {0, 0, 0x8DE1} /* East Asian ideograph */,
  {0, 0, 0x8DDF} /* East Asian ideograph */,
  {0, 0, 0x8DE8} /* East Asian ideograph */,
  {0, 0, 0x8DF3} /* East Asian ideograph */,
  {0, 0, 0x8DFA} /* East Asian ideograph */,
  {0, 0, 0x8DEA} /* East Asian ideograph */,
  {0, 0, 0x8DEF} /* East Asian ideograph */,
  {0, 0, 0x8DFC} /* East Asian ideograph */,
  {0, 0, 0x8E2B} /* East Asian ideograph */,
  {0, 0, 0x8E10} /* East Asian ideograph */,
  {0, 0, 0x8E22} /* East Asian ideograph */,
  {0, 0, 0x8E1D} /* East Asian ideograph */,
  {0, 0, 0x8E0F} /* East Asian ideograph */,
  {0, 0, 0x8E29} /* East Asian ideograph */,
  {0, 0, 0x8E1F} /* East Asian ideograph */,
  {0, 0, 0x8E44} /* East Asian ideograph */,
  {0, 0, 0x8E31} /* East Asian ideograph */,
  {0, 0, 0x8E42} /* East Asian ideograph */,
  {0, 0, 0x8E34} /* East Asian ideograph */,
  {0, 0, 0x8E39} /* East Asian ideograph */,
  {0, 0, 0x8E35} /* East Asian ideograph */,
  {0, 0, 0x8E49} /* East Asian ideograph */,
  {0, 0, 0x8E4B} /* East Asian ideograph */,
  {0, 0, 0x8E48} /* East Asian ideograph */,
  {0, 0, 0x8E4A} /* East Asian ideograph */,
  {0, 0, 0x8E63} /* East Asian ideograph */,
  {0, 0, 0x8E59} /* East Asian ideograph */,
  {0, 0, 0x8E66} /* East Asian ideograph */,
  {0, 0, 0x8E64} /* East Asian ideograph */,
  {0, 0, 0x8E72} /* East Asian ideograph */,
  {0, 0, 0x8E6C} /* East Asian ideograph */,
  {0, 0, 0x8E7A} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8_31page45 = {
  0, marc8_31page45_dir
};
/* PAGE 44 */
struct yaz_iconv_trie_dir marc8_31page44_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x8AC2} /* East Asian ideograph */,
  {0, 0, 0x8AB0} /* East Asian ideograph */,
  {0, 0, 0x8A95} /* East Asian ideograph */,
  {0, 0, 0x8AD6} /* East Asian ideograph */,
  {0, 0, 0x8AE6} /* East Asian ideograph */,
  {0, 0, 0x8AFA} /* East Asian ideograph */,
  {0, 0, 0x8AEB} /* East Asian ideograph */,
  {0, 0, 0x8AF1} /* East Asian ideograph */,
  {0, 0, 0x8AE7} /* East Asian ideograph */,
  {0, 0, 0x8ADC} /* East Asian ideograph */,
  {0, 0, 0x8B00} /* East Asian ideograph */,
  {0, 0, 0x8B01} /* East Asian ideograph (variant of EACC 2D592C) */,
  {0, 0, 0x8B02} /* East Asian ideograph */,
  {0, 0, 0x8AFE} /* East Asian ideograph */,
  {0, 0, 0x8AF7} /* East Asian ideograph */,
  {0, 0, 0x8AED} /* East Asian ideograph */,
  {0, 0, 0x8B17} /* East Asian ideograph */,
  {0, 0, 0x8B19} /* East Asian ideograph */,
  {0, 0, 0x8B0E} /* East Asian ideograph */,
  {0, 0, 0x8B1B} /* East Asian ideograph */,
  {0, 0, 0x8B0A} /* East Asian ideograph */,
  {0, 0, 0x8B21} /* East Asian ideograph */,
  {0, 0, 0x8B04} /* East Asian ideograph */,
  {0, 0, 0x8B1D} /* East Asian ideograph */,
  {0, 0, 0x8B39} /* East Asian ideograph */,
  {0, 0, 0x8B2C} /* East Asian ideograph */,
  {0, 0, 0x8B28} /* East Asian ideograph */,
  {0, 0, 0x8B58} /* East Asian ideograph */,
  {0, 0, 0x8B5C} /* East Asian ideograph */,
  {0, 0, 0x8B4E} /* East Asian ideograph */,
  {0, 0, 0x8B49} /* East Asian ideograph */,
  {0, 0, 0x8B5A} /* East Asian ideograph */,
  {0, 0, 0x8B41} /* East Asian ideograph */,
  {0, 0, 0x8B4F} /* East Asian ideograph */,
  {0, 0, 0x8B70} /* East Asian ideograph */,
  {0, 0, 0x8B6C} /* East Asian ideograph */,
  {0, 0, 0x8B66} /* East Asian ideograph */,
  {0, 0, 0x8B6F} /* East Asian ideograph */,
  {0, 0, 0x8B74} /* East Asian ideograph */,
  {0, 0, 0x8B77} /* East Asian ideograph */,
  {0, 0, 0x8B7D} /* East Asian ideograph */,
  {0, 0, 0x8B80} /* East Asian ideograph */,
  {0, 0, 0x8B8A} /* East Asian ideograph */,
  {0, 0, 0x8B93} /* East Asian ideograph */,
  {0, 0, 0x8B96} /* East Asian ideograph */,
  {0, 0, 0x8B92} /* East Asian ideograph */,
  {0, 0, 0x8B9A} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x8C41} /* East Asian ideograph */,
  {0, 0, 0x8C3F} /* East Asian ideograph */,
  {0, 0, 0x8C46} /* East Asian ideograph */,
  {0, 0, 0x8C48} /* East Asian ideograph */,
  {0, 0, 0x8C49} /* East Asian ideograph */,
  {0, 0, 0x8C4C} /* East Asian ideograph */,
  {0, 0, 0x8C4E} /* East Asian ideograph */,
  {0, 0, 0x8C50} /* East Asian ideograph */,
  {0, 0, 0x8C54} /* East Asian ideograph */,
  {0, 0, 0x8C5A} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x8C62} /* East Asian ideograph */,
  {0, 0, 0x8C6A} /* East Asian ideograph */,
  {0, 0, 0x8C6B} /* East Asian ideograph */,
  {0, 0, 0x8C6C} /* East Asian ideograph */,
  {0, 0, 0x8C7A} /* East Asian ideograph */,
  {0, 0, 0x8C79} /* East Asian ideograph */,
  {0, 0, 0x8C82} /* East Asian ideograph */,
  {0, 0, 0x8C8A} /* East Asian ideograph */,
  {0, 0, 0x8C89} /* East Asian ideograph */,
  {0, 0, 0x8C8D} /* East Asian ideograph */,
  {0, 0, 0x8C8C} /* East Asian ideograph */,
  {0, 0, 0x8C93} /* East Asian ideograph */,
  {0, 0, 0x8C9D} /* East Asian ideograph */,
  {0, 0, 0x8C9E} /* East Asian ideograph */,
  {0, 0, 0x8CA0} /* East Asian ideograph */,
  {0, 0, 0x8CA2} /* East Asian ideograph */,
  {0, 0, 0x8CA1} /* East Asian ideograph */,
  {0, 0, 0x8CAC} /* East Asian ideograph */,
  {0, 0, 0x8CAB} /* East Asian ideograph */,
  {0, 0, 0x8CA8} /* East Asian ideograph */,
  {0, 0, 0x8CAA} /* East Asian ideograph */,
  {0, 0, 0x8CA7} /* East Asian ideograph */,
  {0, 0, 0x8CA9} /* East Asian ideograph */,
  {0, 0, 0x8CAF} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x8CBB} /* East Asian ideograph */,
  {0, 0, 0x8CC1} /* East Asian ideograph */,
  {0, 0, 0x8CC0} /* East Asian ideograph */,
  {0, 0, 0x8CB4} /* East Asian ideograph */,
  {0, 0, 0x8CBC} /* East Asian ideograph */,
  {0, 0, 0x8CB7} /* East Asian ideograph */,
  {0, 0, 0x8CB6} /* East Asian ideograph */,
  {0, 0, 0x8CBD} /* East Asian ideograph */,
  {0, 0, 0x8CB8} /* East Asian ideograph */,
  {0, 0, 0x8CBF} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8_31page44 = {
  0, marc8_31page44_dir
};
/* PAGE 43 */
struct yaz_iconv_trie_dir marc8_31page43_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x896A} /* East Asian ideograph */,
  {0, 0, 0x896F} /* East Asian ideograph */,
  {0, 0, 0x8972} /* East Asian ideograph */,
  {0, 0, 0x897F} /* East Asian ideograph */,
  {0, 0, 0x8981} /* East Asian ideograph */,
  {0, 0, 0x8983} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x898B} /* East Asian ideograph */,
  {0, 0, 0x898F} /* East Asian ideograph */,
  {0, 0, 0x8993} /* East Asian ideograph */,
  {0, 0, 0x8996} /* East Asian ideograph */,
  {0, 0, 0x89AA} /* East Asian ideograph */,
  {0, 0, 0x89A6} /* East Asian ideograph */,
  {0, 0, 0x89AC} /* East Asian ideograph */,
  {0, 0, 0x89B2} /* East Asian ideograph */,
  {0, 0, 0x89BA} /* East Asian ideograph */,
  {0, 0, 0x89BD} /* East Asian ideograph */,
  {0, 0, 0x89C0} /* East Asian ideograph */,
  {0, 0, 0x89D2} /* East Asian ideograph */,
  {0, 0, 0x89E3} /* East Asian ideograph */,
  {0, 0, 0x89F4} /* East Asian ideograph */,
  {0, 0, 0x89F8} /* East Asian ideograph */,
  {0, 0, 0x8A00} /* East Asian ideograph */,
  {0, 0, 0x8A08} /* East Asian ideograph */,
  {0, 0, 0x8A02} /* East Asian ideograph */,
  {0, 0, 0x8A03} /* East Asian ideograph */,
  {0, 0, 0x8A10} /* East Asian ideograph */,
  {0, 0, 0x8A18} /* East Asian ideograph */,
  {0, 0, 0x8A0E} /* East Asian ideograph */,
  {0, 0, 0x8A0C} /* East Asian ideograph */,
  {0, 0, 0x8A15} /* East Asian ideograph */,
  {0, 0, 0x8A0A} /* East Asian ideograph */,
  {0, 0, 0x8A16} /* East Asian ideograph */,
  {0, 0, 0x8A17} /* East Asian ideograph */,
  {0, 0, 0x8A13} /* East Asian ideograph */,
  {0, 0, 0x8A2A} /* East Asian ideograph */,
  {0, 0, 0x8A23} /* East Asian ideograph */,
  {0, 0, 0x8A1D} /* East Asian ideograph */,
  {0, 0, 0x8A25} /* East Asian ideograph */,
  {0, 0, 0x8A31} /* East Asian ideograph */,
  {0, 0, 0x8A2D} /* East Asian ideograph */,
  {0, 0, 0x8A1B} /* East Asian ideograph */,
  {0, 0, 0x8A1F} /* East Asian ideograph */,
  {0, 0, 0x8A3B} /* East Asian ideograph */,
  {0, 0, 0x8A60} /* East Asian ideograph */,
  {0, 0, 0x8A55} /* East Asian ideograph */,
  {0, 0, 0x8A5E} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x8A41} /* East Asian ideograph */,
  {0, 0, 0x8A54} /* East Asian ideograph */,
  {0, 0, 0x8A5B} /* East Asian ideograph */,
  {0, 0, 0x8A50} /* East Asian ideograph */,
  {0, 0, 0x8A46} /* East Asian ideograph */,
  {0, 0, 0x8A34} /* East Asian ideograph */,
  {0, 0, 0x8A3A} /* East Asian ideograph */,
  {0, 0, 0x8A6B} /* East Asian ideograph */,
  {0, 0, 0x8A72} /* East Asian ideograph */,
  {0, 0, 0x8A73} /* East Asian ideograph */,
  {0, 0, 0x8A66} /* East Asian ideograph */,
  {0, 0, 0x8A69} /* East Asian ideograph */,
  {0, 0, 0x8A70} /* East Asian ideograph */,
  {0, 0, 0x8A63} /* East Asian ideograph */,
  {0, 0, 0x8A7C} /* East Asian ideograph */,
  {0, 0, 0x8AA0} /* East Asian ideograph */,
  {0, 0, 0x8A87} /* East Asian ideograph */,
  {0, 0, 0x8A85} /* East Asian ideograph */,
  {0, 0, 0x8A6D} /* East Asian ideograph */,
  {0, 0, 0x8A79} /* East Asian ideograph */,
  {0, 0, 0x8A62} /* East Asian ideograph */,
  {0, 0, 0x8A71} /* East Asian ideograph */,
  {0, 0, 0x8A6E} /* East Asian ideograph */,
  {0, 0, 0x8A6C} /* East Asian ideograph */,
  {0, 0, 0x8AAA} /* East Asian ideograph */,
  {0, 0, 0x8AA6} /* East Asian ideograph */,
  {0, 0, 0x8AA1} /* East Asian ideograph */,
  {0, 0, 0x8A9E} /* East Asian ideograph */,
  {0, 0, 0x8A8C} /* East Asian ideograph */,
  {0, 0, 0x8A93} /* East Asian ideograph */,
  {0, 0, 0x8AA3} /* East Asian ideograph */,
  {0, 0, 0x8A8D} /* East Asian ideograph */,
  {0, 0, 0x8AA4} /* East Asian ideograph (variant of EACC 4B5871) */,
  {0, 0, 0x8AA8} /* East Asian ideograph */,
  {0, 0, 0x8AA5} /* East Asian ideograph */,
  {0, 0, 0x8A98} /* East Asian ideograph */,
  {0, 0, 0x8A91} /* East Asian ideograph */,
  {0, 0, 0x8ABC} /* East Asian ideograph */,
  {0, 0, 0x8AC4} /* East Asian ideograph */,
  {0, 0, 0x8AD2} /* East Asian ideograph */,
  {0, 0, 0x8AC7} /* East Asian ideograph */,
  {0, 0, 0x8ACB} /* East Asian ideograph (variant of EACC 4B587A) */,
  {0, 0, 0x8AF8} /* East Asian ideograph */,
  {0, 0, 0x8AB2} /* East Asian ideograph */,
  {0, 0, 0x8ABF} /* East Asian ideograph */,
  {0, 0, 0x8AC9} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8_31page43 = {
  0, marc8_31page43_dir
};
/* PAGE 42 */
struct yaz_iconv_trie_dir marc8_31page42_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x8759} /* East Asian ideograph */,
  {0, 0, 0x8783} /* East Asian ideograph */,
  {0, 0, 0x8782} /* East Asian ideograph */,
  {0, 0, 0x87A2} /* East Asian ideograph */,
  {0, 0, 0x879E} /* East Asian ideograph */,
  {0, 0, 0x878D} /* East Asian ideograph */,
  {0, 0, 0x879F} /* East Asian ideograph */,
  {0, 0, 0x87D1} /* East Asian ideograph */,
  {0, 0, 0x87C0} /* East Asian ideograph */,
  {0, 0, 0x87AB} /* East Asian ideograph */,
  {0, 0, 0x87B3} /* East Asian ideograph */,
  {0, 0, 0x87BB} /* East Asian ideograph */,
  {0, 0, 0x87C8} /* East Asian ideograph */,
  {0, 0, 0x87D2} /* East Asian ideograph */,
  {0, 0, 0x87BA} /* East Asian ideograph */,
  {0, 0, 0x87C6} /* East Asian ideograph */,
  {0, 0, 0x87CB} /* East Asian ideograph */,
  {0, 0, 0x87EF} /* East Asian ideograph */,
  {0, 0, 0x87F2} /* East Asian ideograph */,
  {0, 0, 0x87EC} /* East Asian ideograph */,
  {0, 0, 0x87FB} /* East Asian ideograph */,
  {0, 0, 0x8805} /* East Asian ideograph */,
  {0, 0, 0x880D} /* East Asian ideograph */,
  {0, 0, 0x87F9} /* East Asian ideograph */,
  {0, 0, 0x8814} /* East Asian ideograph */,
  {0, 0, 0x8815} /* East Asian ideograph */,
  {0, 0, 0x8822} /* East Asian ideograph */,
  {0, 0, 0x8823} /* East Asian ideograph */,
  {0, 0, 0x8821} /* East Asian ideograph */,
  {0, 0, 0x881F} /* East Asian ideograph */,
  {0, 0, 0x8831} /* East Asian ideograph */,
  {0, 0, 0x8839} /* East Asian ideograph */,
  {0, 0, 0x8836} /* East Asian ideograph */,
  {0, 0, 0x883B} /* East Asian ideograph */,
  {0, 0, 0x8840} /* East Asian ideograph */,
  {0, 0, 0x884C} /* East Asian ideograph */,
  {0, 0, 0x884D} /* East Asian ideograph */,
  {0, 0, 0x8853} /* East Asian ideograph (variant of EACC 4B5746) */,
  {0, 0, 0x8857} /* East Asian ideograph */,
  {0, 0, 0x8859} /* East Asian ideograph */,
  {0, 0, 0x885B} /* East Asian ideograph */,
  {0, 0, 0x885D} /* East Asian ideograph */,
  {0, 0, 0x8861} /* East Asian ideograph */,
  {0, 0, 0x8862} /* East Asian ideograph */,
  {0, 0, 0x8863} /* East Asian ideograph */,
  {0, 0, 0x521D} /* East Asian ideograph */,
  {0, 0, 0x8868} /* East Asian ideograph */,
  {0, 0, 0x886B} /* East Asian ideograph */,
  {0, 0, 0x8882} /* East Asian ideograph */,
  {0, 0, 0x8881} /* East Asian ideograph */,
  {0, 0, 0x8870} /* East Asian ideograph */,
  {0, 0, 0x8877} /* East Asian ideograph */,
  {0, 0, 0x8888} /* East Asian ideograph */,
  {0, 0, 0x88AB} /* East Asian ideograph */,
  {0, 0, 0x8892} /* East Asian ideograph */,
  {0, 0, 0x8896} /* East Asian ideograph */,
  {0, 0, 0x888D} /* East Asian ideograph */,
  {0, 0, 0x888B} /* East Asian ideograph */,
  {0, 0, 0x889E} /* East Asian ideograph */,
  {0, 0, 0x88C1} /* East Asian ideograph */,
  {0, 0, 0x88C2} /* East Asian ideograph */,
  {0, 0, 0x88B1} /* East Asian ideograph */,
  {0, 0, 0x88DF} /* East Asian ideograph */,
  {0, 0, 0x88D9} /* East Asian ideograph */,
  {0, 0, 0x88D8} /* East Asian ideograph */,
  {0, 0, 0x88DC} /* East Asian ideograph */,
  {0, 0, 0x88CF} /* East Asian ideograph */,
  {0, 0, 0x88D4} /* East Asian ideograph */,
  {0, 0, 0x88DD} /* East Asian ideograph */,
  {0, 0, 0x88D5} /* East Asian ideograph */,
  {0, 0, 0x8902} /* East Asian ideograph */,
  {0, 0, 0x88F3} /* East Asian ideograph */,
  {0, 0, 0x88F8} /* East Asian ideograph */,
  {0, 0, 0x88F9} /* East Asian ideograph */,
  {0, 0, 0x88F4} /* East Asian ideograph */,
  {0, 0, 0x88FD} /* East Asian ideograph */,
  {0, 0, 0x88E8} /* East Asian ideograph */,
  {0, 0, 0x891A} /* East Asian ideograph */,
  {0, 0, 0x8910} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x8913} /* East Asian ideograph */,
  {0, 0, 0x8912} /* East Asian ideograph */,
  {0, 0, 0x8932} /* East Asian ideograph */,
  {0, 0, 0x892A} /* East Asian ideograph */,
  {0, 0, 0x8925} /* East Asian ideograph */,
  {0, 0, 0x892B} /* East Asian ideograph */,
  {0, 0, 0x893B} /* East Asian ideograph */,
  {0, 0, 0x8936} /* East Asian ideograph */,
  {0, 0, 0x8938} /* East Asian ideograph */,
  {0, 0, 0x8944} /* East Asian ideograph */,
  {0, 0, 0x895F} /* East Asian ideograph */,
  {0, 0, 0x8960} /* East Asian ideograph */,
  {0, 0, 0x8956} /* East Asian ideograph */,
  {0, 0, 0x8964} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8_31page42 = {
  0, marc8_31page42_dir
};
/* PAGE 41 */
struct yaz_iconv_trie_dir marc8_31page41_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x85AA} /* East Asian ideograph */,
  {0, 0, 0x856D} /* East Asian ideograph */,
  {0, 0, 0x859B} /* East Asian ideograph */,
  {0, 0, 0x8591} /* East Asian ideograph */,
  {0, 0, 0x857E} /* East Asian ideograph */,
  {0, 0, 0x8594} /* East Asian ideograph */,
  {0, 0, 0x859C} /* East Asian ideograph */,
  {0, 0, 0x8587} /* East Asian ideograph */,
  {0, 0, 0x85CD} /* East Asian ideograph (variant of EACC 4B5629) */,
  {0, 0, 0x85A9} /* East Asian ideograph */,
  {0, 0, 0x85CF} /* East Asian ideograph */,
  {0, 0, 0x85AF} /* East Asian ideograph */,
  {0, 0, 0x85D0} /* East Asian ideograph */,
  {0, 0, 0x85C9} /* East Asian ideograph */,
  {0, 0, 0x85B0} /* East Asian ideograph */,
  {0, 0, 0x85E9} /* East Asian ideograph */,
  {0, 0, 0x85DD} /* East Asian ideograph */,
  {0, 0, 0x85EA} /* East Asian ideograph */,
  {0, 0, 0x85E4} /* East Asian ideograph */,
  {0, 0, 0x85D5} /* East Asian ideograph */,
  {0, 0, 0x85E5} /* East Asian ideograph */,
  {0, 0, 0x85FB} /* East Asian ideograph */,
  {0, 0, 0x85F9} /* East Asian ideograph */,
  {0, 0, 0x8611} /* East Asian ideograph */,
  {0, 0, 0x85FA} /* East Asian ideograph */,
  {0, 0, 0x8606} /* East Asian ideograph */,
  {0, 0, 0x860B} /* East Asian ideograph */,
  {0, 0, 0x8607} /* East Asian ideograph */,
  {0, 0, 0x860A} /* East Asian ideograph */,
  {0, 0, 0x862D} /* East Asian ideograph */,
  {0, 0, 0x8617} /* East Asian ideograph */,
  {0, 0, 0x861A} /* East Asian ideograph */,
  {0, 0, 0x8638} /* East Asian ideograph */,
  {0, 0, 0x863F} /* East Asian ideograph */,
  {0, 0, 0x864E} /* East Asian ideograph */,
  {0, 0, 0x8650} /* East Asian ideograph */,
  {0, 0, 0x8654} /* East Asian ideograph */,
  {0, 0, 0x5F6A} /* East Asian ideograph */,
  {0, 0, 0x8655} /* East Asian ideograph */,
  {0, 0, 0x865C} /* East Asian ideograph */,
  {0, 0, 0x865B} /* East Asian ideograph */,
  {0, 0, 0x865F} /* East Asian ideograph */,
  {0, 0, 0x865E} /* East Asian ideograph */,
  {0, 0, 0x8667} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x8679} /* East Asian ideograph */,
  {0, 0, 0x86A9} /* East Asian ideograph */,
  {0, 0, 0x86AA} /* East Asian ideograph */,
  {0, 0, 0x868A} /* East Asian ideograph */,
  {0, 0, 0x8693} /* East Asian ideograph */,
  {0, 0, 0x86A4} /* East Asian ideograph */,
  {0, 0, 0x868C} /* East Asian ideograph */,
  {0, 0, 0x86A3} /* East Asian ideograph */,
  {0, 0, 0x86C0} /* East Asian ideograph */,
  {0, 0, 0x86C7} /* East Asian ideograph */,
  {0, 0, 0x86B5} /* East Asian ideograph */,
  {0, 0, 0x86CB} /* East Asian ideograph */,
  {0, 0, 0x86B6} /* East Asian ideograph */,
  {0, 0, 0x86C4} /* East Asian ideograph */,
  {0, 0, 0x86C6} /* East Asian ideograph */,
  {0, 0, 0x86B1} /* East Asian ideograph */,
  {0, 0, 0x86AF} /* East Asian ideograph */,
  {0, 0, 0x86DF} /* East Asian ideograph */,
  {0, 0, 0x86D9} /* East Asian ideograph */,
  {0, 0, 0x86ED} /* East Asian ideograph */,
  {0, 0, 0x86D4} /* East Asian ideograph */,
  {0, 0, 0x86DB} /* East Asian ideograph */,
  {0, 0, 0x86E4} /* East Asian ideograph */,
  {0, 0, 0x86FB} /* East Asian ideograph */,
  {0, 0, 0x86F9} /* East Asian ideograph */,
  {0, 0, 0x8707} /* East Asian ideograph */,
  {0, 0, 0x8703} /* East Asian ideograph */,
  {0, 0, 0x8708} /* East Asian ideograph */,
  {0, 0, 0x8700} /* East Asian ideograph */,
  {0, 0, 0x86FE} /* East Asian ideograph */,
  {0, 0, 0x8713} /* East Asian ideograph */,
  {0, 0, 0x8702} /* East Asian ideograph */,
  {0, 0, 0x871C} /* East Asian ideograph */,
  {0, 0, 0x873F} /* East Asian ideograph */,
  {0, 0, 0x873B} /* East Asian ideograph */,
  {0, 0, 0x8722} /* East Asian ideograph */,
  {0, 0, 0x8725} /* East Asian ideograph */,
  {0, 0, 0x8734} /* East Asian ideograph */,
  {0, 0, 0x8718} /* East Asian ideograph */,
  {0, 0, 0x8755} /* East Asian ideograph */,
  {0, 0, 0x8760} /* East Asian ideograph */,
  {0, 0, 0x8776} /* East Asian ideograph */,
  {0, 0, 0x8774} /* East Asian ideograph */,
  {0, 0, 0x8766} /* East Asian ideograph */,
  {0, 0, 0x8778} /* East Asian ideograph */,
  {0, 0, 0x8768} /* East Asian ideograph */,
  {0, 0, 0x874C} /* East Asian ideograph */,
  {0, 0, 0x8757} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8_31page41 = {
  0, marc8_31page41_dir
};
/* PAGE 40 */
struct yaz_iconv_trie_dir marc8_31page40_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x5179} /* East Asian ideograph */,
  {0, 0, 0x834F} /* East Asian ideograph */,
  {0, 0, 0x8339} /* East Asian ideograph */,
  {0, 0, 0x838E} /* East Asian ideograph */,
  {0, 0, 0x8398} /* East Asian ideograph */,
  {0, 0, 0x839E} /* East Asian ideograph */,
  {0, 0, 0x8378} /* East Asian ideograph */,
  {0, 0, 0x83A2} /* East Asian ideograph */,
  {0, 0, 0x8396} /* East Asian ideograph */,
  {0, 0, 0x83A7} /* East Asian ideograph */,
  {0, 0, 0x83AB} /* East Asian ideograph */,
  {0, 0, 0x8392} /* East Asian ideograph (variant of EACC 4B552C) */,
  {0, 0, 0x838A} /* East Asian ideograph */,
  {0, 0, 0x8393} /* East Asian ideograph */,
  {0, 0, 0x83A0} /* East Asian ideograph */,
  {0, 0, 0x8389} /* East Asian ideograph */,
  {0, 0, 0x8377} /* East Asian ideograph */,
  {0, 0, 0x837C} /* East Asian ideograph */,
  {0, 0, 0x837B} /* East Asian ideograph */,
  {0, 0, 0x840D} /* East Asian ideograph */,
  {0, 0, 0x83E0} /* East Asian ideograph */,
  {0, 0, 0x83E9} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x8403} /* East Asian ideograph */,
  {0, 0, 0x83C5} /* East Asian ideograph */,
  {0, 0, 0x83C1} /* East Asian ideograph */,
  {0, 0, 0x840B} /* East Asian ideograph */,
  {0, 0, 0x83EF} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x83F1} /* East Asian ideograph */,
  {0, 0, 0x83BD} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x840A} /* East Asian ideograph */,
  {0, 0, 0x840C} /* East Asian ideograph */,
  {0, 0, 0x83CC} /* East Asian ideograph */,
  {0, 0, 0x83DC} /* East Asian ideograph */,
  {0, 0, 0x83CA} /* East Asian ideograph */,
  {0, 0, 0x83F2} /* East Asian ideograph */,
  {0, 0, 0x840E} /* East Asian ideograph */,
  {0, 0, 0x8404} /* East Asian ideograph */,
  {0, 0, 0x843D} /* East Asian ideograph */,
  {0, 0, 0x8482} /* East Asian ideograph */,
  {0, 0, 0x8431} /* East Asian ideograph */,
  {0, 0, 0x8475} /* East Asian ideograph */,
  {0, 0, 0x8466} /* East Asian ideograph */,
  {0, 0, 0x8457} /* East Asian ideograph */,
  {0, 0, 0x8449} /* East Asian ideograph */,
  {0, 0, 0x846C} /* East Asian ideograph */,
  {0, 0, 0x846B} /* East Asian ideograph */,
  {0, 0, 0x845B} /* East Asian ideograph */,
  {0, 0, 0x8477} /* East Asian ideograph */,
  {0, 0, 0x843C} /* East Asian ideograph */,
  {0, 0, 0x8435} /* East Asian ideograph */,
  {0, 0, 0x8461} /* East Asian ideograph */,
  {0, 0, 0x8463} /* East Asian ideograph */,
  {0, 0, 0x8469} /* East Asian ideograph */,
  {0, 0, 0x8438} /* East Asian ideograph */,
  {0, 0, 0x84B2} /* East Asian ideograph */,
  {0, 0, 0x849E} /* East Asian ideograph */,
  {0, 0, 0x84BF} /* East Asian ideograph */,
  {0, 0, 0x84C6} /* East Asian ideograph */,
  {0, 0, 0x84C4} /* East Asian ideograph */,
  {0, 0, 0x84C9} /* East Asian ideograph */,
  {0, 0, 0x849C} /* East Asian ideograph */,
  {0, 0, 0x84CB} /* East Asian ideograph */,
  {0, 0, 0x84B8} /* East Asian ideograph */,
  {0, 0, 0x84C0} /* East Asian ideograph */,
  {0, 0, 0x8499} /* East Asian ideograph */,
  {0, 0, 0x84D3} /* East Asian ideograph */,
  {0, 0, 0x8490} /* East Asian ideograph */,
  {0, 0, 0x84BC} /* East Asian ideograph */,
  {0, 0, 0x853D} /* East Asian ideograph */,
  {0, 0, 0x84FF} /* East Asian ideograph */,
  {0, 0, 0x8517} /* East Asian ideograph */,
  {0, 0, 0x851A} /* East Asian ideograph */,
  {0, 0, 0x84EE} /* East Asian ideograph */,
  {0, 0, 0x852C} /* East Asian ideograph */,
  {0, 0, 0x852D} /* East Asian ideograph */,
  {0, 0, 0x8513} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x8523} /* East Asian ideograph */,
  {0, 0, 0x8521} /* East Asian ideograph */,
  {0, 0, 0x8514} /* East Asian ideograph */,
  {0, 0, 0x84EC} /* East Asian ideograph */,
  {0, 0, 0x8525} /* East Asian ideograph */,
  {0, 0, 0x8569} /* East Asian ideograph */,
  {0, 0, 0x854A} /* East Asian ideograph */,
  {0, 0, 0x8559} /* East Asian ideograph */,
  {0, 0, 0x8548} /* East Asian ideograph */,
  {0, 0, 0x8568} /* East Asian ideograph */,
  {0, 0, 0x8543} /* East Asian ideograph */,
  {0, 0, 0x856A} /* East Asian ideograph */,
  {0, 0, 0x8549} /* East Asian ideograph */,
  {0, 0, 0x8584} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8_31page40 = {
  0, marc8_31page40_dir
};
/* PAGE 39 */
struct yaz_iconv_trie_dir marc8_31page39_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x81DA} /* East Asian ideograph */,
  {0, 0, 0x81DF} /* East Asian ideograph */,
  {0, 0, 0x81E3} /* East Asian ideograph */,
  {0, 0, 0x81E5} /* East Asian ideograph */,
  {0, 0, 0x81E8} /* East Asian ideograph */,
  {0, 0, 0x81EA} /* East Asian ideograph */,
  {0, 0, 0x81EC} /* East Asian ideograph */,
  {0, 0, 0x81ED} /* East Asian ideograph */,
  {0, 0, 0x81F3} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x81FA} /* East Asian ideograph */,
  {0, 0, 0x81FB} /* East Asian ideograph */,
  {0, 0, 0x81FC} /* East Asian ideograph */,
  {0, 0, 0x81FE} /* East Asian ideograph */,
  {0, 0, 0x8200} /* East Asian ideograph */,
  {0, 0, 0x8202} /* East Asian ideograph */,
  {0, 0, 0x8205} /* East Asian ideograph */,
  {0, 0, 0x8207} /* East Asian ideograph */,
  {0, 0, 0x8208} /* East Asian ideograph */,
  {0, 0, 0x8209} /* East Asian ideograph */,
  {0, 0, 0x820A} /* East Asian ideograph */,
  {0, 0, 0x820C} /* East Asian ideograph */,
  {0, 0, 0x820D} /* East Asian ideograph */,
  {0, 0, 0x8210} /* East Asian ideograph */,
  {0, 0, 0x8212} /* East Asian ideograph */,
  {0, 0, 0x8214} /* East Asian ideograph */,
  {0, 0, 0x821B} /* East Asian ideograph */,
  {0, 0, 0x821C} /* East Asian ideograph */,
  {0, 0, 0x821E} /* East Asian ideograph */,
  {0, 0, 0x821F} /* East Asian ideograph */,
  {0, 0, 0x8222} /* East Asian ideograph */,
  {0, 0, 0x822A} /* East Asian ideograph */,
  {0, 0, 0x822B} /* East Asian ideograph */,
  {0, 0, 0x822C} /* East Asian ideograph */,
  {0, 0, 0x8228} /* East Asian ideograph */,
  {0, 0, 0x8237} /* East Asian ideograph */,
  {0, 0, 0x8235} /* East Asian ideograph */,
  {0, 0, 0x8239} /* East Asian ideograph */,
  {0, 0, 0x8236} /* East Asian ideograph */,
  {0, 0, 0x8247} /* East Asian ideograph */,
  {0, 0, 0x8258} /* East Asian ideograph */,
  {0, 0, 0x8259} /* East Asian ideograph */,
  {0, 0, 0x8266} /* East Asian ideograph */,
  {0, 0, 0x826E} /* East Asian ideograph */,
  {0, 0, 0x826F} /* East Asian ideograph */,
  {0, 0, 0x8271} /* East Asian ideograph */,
  {0, 0, 0x8272} /* East Asian ideograph */,
  {0, 0, 0x827E} /* East Asian ideograph */,
  {0, 0, 0x8292} /* East Asian ideograph */,
  {0, 0, 0x828B} /* East Asian ideograph */,
  {0, 0, 0x828D} /* East Asian ideograph */,
  {0, 0, 0x82B3} /* East Asian ideograph */,
  {0, 0, 0x829D} /* East Asian ideograph */,
  {0, 0, 0x8299} /* East Asian ideograph */,
  {0, 0, 0x82BD} /* East Asian ideograph */,
  {0, 0, 0x82AD} /* East Asian ideograph */,
  {0, 0, 0x82AC} /* East Asian ideograph */,
  {0, 0, 0x82A5} /* East Asian ideograph */,
  {0, 0, 0x829F} /* East Asian ideograph */,
  {0, 0, 0x82BB} /* East Asian ideograph */,
  {0, 0, 0x82B1} /* East Asian ideograph */,
  {0, 0, 0x82B9} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x82E7} /* East Asian ideograph */,
  {0, 0, 0x8305} /* East Asian ideograph */,
  {0, 0, 0x8309} /* East Asian ideograph */,
  {0, 0, 0x82E3} /* East Asian ideograph */,
  {0, 0, 0x82DB} /* East Asian ideograph */,
  {0, 0, 0x82E6} /* East Asian ideograph */,
  {0, 0, 0x8304} /* East Asian ideograph */,
  {0, 0, 0x82E5} /* East Asian ideograph */,
  {0, 0, 0x8302} /* East Asian ideograph */,
  {0, 0, 0x82DC} /* East Asian ideograph */,
  {0, 0, 0x82D7} /* East Asian ideograph */,
  {0, 0, 0x82F1} /* East Asian ideograph */,
  {0, 0, 0x8301} /* East Asian ideograph */,
  {0, 0, 0x82D3} /* East Asian ideograph */,
  {0, 0, 0x82D4} /* East Asian ideograph */,
  {0, 0, 0x82D1} /* East Asian ideograph */,
  {0, 0, 0x82DE} /* East Asian ideograph */,
  {0, 0, 0x82DF} /* East Asian ideograph */,
  {0, 0, 0x832B} /* East Asian ideograph */,
  {0, 0, 0x8352} /* East Asian ideograph */,
  {0, 0, 0x834A} /* East Asian ideograph */,
  {0, 0, 0x8338} /* East Asian ideograph */,
  {0, 0, 0x8354} /* East Asian ideograph */,
  {0, 0, 0x8350} /* East Asian ideograph */,
  {0, 0, 0x8349} /* East Asian ideograph */,
  {0, 0, 0x8335} /* East Asian ideograph */,
  {0, 0, 0x8334} /* East Asian ideograph */,
  {0, 0, 0x8336} /* East Asian ideograph */,
  {0, 0, 0x8331} /* East Asian ideograph */,
  {0, 0, 0x8340} /* East Asian ideograph */,
  {0, 0, 0x8317} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8_31page39 = {
  0, marc8_31page39_dir
};
/* PAGE 38 */
struct yaz_iconv_trie_dir marc8_31page38_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x8085} /* East Asian ideograph */,
  {0, 0, 0x8087} /* East Asian ideograph */,
  {0, 0, 0x8089} /* East Asian ideograph */,
  {0, 0, 0x808B} /* East Asian ideograph */,
  {0, 0, 0x808C} /* East Asian ideograph */,
  {0, 0, 0x8093} /* East Asian ideograph */,
  {0, 0, 0x809D} /* East Asian ideograph */,
  {0, 0, 0x8098} /* East Asian ideograph */,
  {0, 0, 0x809B} /* East Asian ideograph */,
  {0, 0, 0x809A} /* East Asian ideograph */,
  {0, 0, 0x8096} /* East Asian ideograph */,
  {0, 0, 0x80B2} /* East Asian ideograph */,
  {0, 0, 0x80AA} /* East Asian ideograph */,
  {0, 0, 0x80BA} /* East Asian ideograph */,
  {0, 0, 0x80A5} /* East Asian ideograph */,
  {0, 0, 0x80A2} /* East Asian ideograph */,
  {0, 0, 0x80AB} /* East Asian ideograph */,
  {0, 0, 0x80B1} /* East Asian ideograph */,
  {0, 0, 0x80AF} /* East Asian ideograph */,
  {0, 0, 0x80A1} /* East Asian ideograph */,
  {0, 0, 0x80A9} /* East Asian ideograph */,
  {0, 0, 0x80B4} /* East Asian ideograph */,
  {0, 0, 0x80D6} /* East Asian ideograph */,
  {0, 0, 0x80CC} /* East Asian ideograph */,
  {0, 0, 0x80E5} /* East Asian ideograph */,
  {0, 0, 0x80DA} /* East Asian ideograph */,
  {0, 0, 0x80E1} /* East Asian ideograph */,
  {0, 0, 0x80C3} /* East Asian ideograph */,
  {0, 0, 0x80DB} /* East Asian ideograph */,
  {0, 0, 0x80C4} /* East Asian ideograph */,
  {0, 0, 0x80CE} /* East Asian ideograph */,
  {0, 0, 0x80DE} /* East Asian ideograph */,
  {0, 0, 0x80E4} /* East Asian ideograph */,
  {0, 0, 0x80F0} /* East Asian ideograph */,
  {0, 0, 0x8102} /* East Asian ideograph */,
  {0, 0, 0x8105} /* East Asian ideograph */,
  {0, 0, 0x80F1} /* East Asian ideograph */,
  {0, 0, 0x80F4} /* East Asian ideograph */,
  {0, 0, 0x80ED} /* East Asian ideograph */,
  {0, 0, 0x80FD} /* East Asian ideograph */,
  {0, 0, 0x8106} /* East Asian ideograph */,
  {0, 0, 0x80F3} /* East Asian ideograph */,
  {0, 0, 0x80F8} /* East Asian ideograph */,
  {0, 0, 0x810A} /* East Asian ideograph */,
  {0, 0, 0x8108} /* East Asian ideograph */,
  {0, 0, 0x812B} /* East Asian ideograph */,
  {0, 0, 0x812F} /* East Asian ideograph */,
  {0, 0, 0x8116} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x8129} /* East Asian ideograph */,
  {0, 0, 0x8155} /* East Asian ideograph */,
  {0, 0, 0x8154} /* East Asian ideograph */,
  {0, 0, 0x814B} /* East Asian ideograph */,
  {0, 0, 0x8151} /* East Asian ideograph */,
  {0, 0, 0x8150} /* East Asian ideograph */,
  {0, 0, 0x814E} /* East Asian ideograph */,
  {0, 0, 0x8139} /* East Asian ideograph */,
  {0, 0, 0x8146} /* East Asian ideograph */,
  {0, 0, 0x813E} /* East Asian ideograph */,
  {0, 0, 0x8171} /* East Asian ideograph */,
  {0, 0, 0x8170} /* East Asian ideograph */,
  {0, 0, 0x8178} /* East Asian ideograph */,
  {0, 0, 0x8165} /* East Asian ideograph */,
  {0, 0, 0x816E} /* East Asian ideograph */,
  {0, 0, 0x8173} /* East Asian ideograph */,
  {0, 0, 0x816B} /* East Asian ideograph */,
  {0, 0, 0x8179} /* East Asian ideograph */,
  {0, 0, 0x817A} /* East Asian ideograph */,
  {0, 0, 0x8166} /* East Asian ideograph */,
  {0, 0, 0x8180} /* East Asian ideograph */,
  {0, 0, 0x818F} /* East Asian ideograph */,
  {0, 0, 0x817F} /* East Asian ideograph */,
  {0, 0, 0x818A} /* East Asian ideograph */,
  {0, 0, 0x8188} /* East Asian ideograph */,
  {0, 0, 0x819D} /* East Asian ideograph */,
  {0, 0, 0x81A0} /* East Asian ideograph */,
  {0, 0, 0x819B} /* East Asian ideograph */,
  {0, 0, 0x819A} /* East Asian ideograph */,
  {0, 0, 0x819C} /* East Asian ideograph */,
  {0, 0, 0x81B3} /* East Asian ideograph */,
  {0, 0, 0x81A9} /* East Asian ideograph */,
  {0, 0, 0x81A8} /* East Asian ideograph */,
  {0, 0, 0x81C6} /* East Asian ideograph */,
  {0, 0, 0x81BA} /* East Asian ideograph */,
  {0, 0, 0x81C3} /* East Asian ideograph */,
  {0, 0, 0x81C0} /* East Asian ideograph */,
  {0, 0, 0x81C2} /* East Asian ideograph */,
  {0, 0, 0x81BF} /* East Asian ideograph */,
  {0, 0, 0x81BD} /* East Asian ideograph */,
  {0, 0, 0x81C9} /* East Asian ideograph */,
  {0, 0, 0x81BE} /* East Asian ideograph */,
  {0, 0, 0x81CD} /* East Asian ideograph */,
  {0, 0, 0x81CF} /* East Asian ideograph */,
  {0, 0, 0x81D8} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8_31page38 = {
  0, marc8_31page38_dir
};
/* PAGE 37 */
struct yaz_iconv_trie_dir marc8_31page37_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x7E8C} /* East Asian ideograph */,
  {0, 0, 0x7E93} /* East Asian ideograph */,
  {0, 0, 0x7E96} /* East Asian ideograph */,
  {0, 0, 0x7E9C} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x7F38} /* East Asian ideograph */,
  {0, 0, 0x7F3A} /* East Asian ideograph */,
  {0, 0, 0x7F3D} /* East Asian ideograph */,
  {0, 0, 0x7F44} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x7F50} /* East Asian ideograph */,
  {0, 0, 0x7F55} /* East Asian ideograph */,
  {0, 0, 0x7F54} /* East Asian ideograph */,
  {0, 0, 0x7F5F} /* East Asian ideograph */,
  {0, 0, 0x7F72} /* East Asian ideograph */,
  {0, 0, 0x7F6E} /* East Asian ideograph */,
  {0, 0, 0x7F69} /* East Asian ideograph */,
  {0, 0, 0x7F6A} /* East Asian ideograph */,
  {0, 0, 0x7F70} /* East Asian ideograph */,
  {0, 0, 0x7F75} /* East Asian ideograph */,
  {0, 0, 0x7F77} /* East Asian ideograph */,
  {0, 0, 0x7F79} /* East Asian ideograph */,
  {0, 0, 0x7F85} /* East Asian ideograph */,
  {0, 0, 0x7F88} /* East Asian ideograph */,
  {0, 0, 0x7F8A} /* East Asian ideograph */,
  {0, 0, 0x7F8C} /* East Asian ideograph */,
  {0, 0, 0x7F8E} /* East Asian ideograph */,
  {0, 0, 0x7F94} /* East Asian ideograph */,
  {0, 0, 0x7F9E} /* East Asian ideograph */,
  {0, 0, 0x7F9A} /* East Asian ideograph */,
  {0, 0, 0x5584} /* East Asian ideograph */,
  {0, 0, 0x7FA8} /* East Asian ideograph */,
  {0, 0, 0x7FA4} /* East Asian ideograph */,
  {0, 0, 0x7FA9} /* East Asian ideograph */,
  {0, 0, 0x7FAF} /* East Asian ideograph */,
  {0, 0, 0x7FB2} /* East Asian ideograph */,
  {0, 0, 0x7FB6} /* East Asian ideograph */,
  {0, 0, 0x7FB8} /* East Asian ideograph */,
  {0, 0, 0x7FB9} /* East Asian ideograph */,
  {0, 0, 0x7FBD} /* East Asian ideograph */,
  {0, 0, 0x7FBF} /* East Asian ideograph */,
  {0, 0, 0x7FC5} /* East Asian ideograph */,
  {0, 0, 0x7FC1} /* East Asian ideograph */,
  {0, 0, 0x7FCC} /* East Asian ideograph */,
  {0, 0, 0x7FD2} /* East Asian ideograph */,
  {0, 0, 0x7FCE} /* East Asian ideograph (variant of EACC 4B524E) */,
  {0, 0, 0x7FD4} /* East Asian ideograph */,
  {0, 0, 0x7FD5} /* East Asian ideograph */,
  {0, 0, 0x7FE0} /* East Asian ideograph */,
  {0, 0, 0x7FE1} /* East Asian ideograph */,
  {0, 0, 0x7FDF} /* East Asian ideograph */,
  {0, 0, 0x7FE9} /* East Asian ideograph */,
  {0, 0, 0x7FF0} /* East Asian ideograph */,
  {0, 0, 0x7FF3} /* East Asian ideograph */,
  {0, 0, 0x7FFC} /* East Asian ideograph */,
  {0, 0, 0x7FF9} /* East Asian ideograph */,
  {0, 0, 0x7FFB} /* East Asian ideograph */,
  {0, 0, 0x7FF1} /* East Asian ideograph */,
  {0, 0, 0x8000} /* East Asian ideograph */,
  {0, 0, 0x8001} /* East Asian ideograph */,
  {0, 0, 0x8003} /* East Asian ideograph */,
  {0, 0, 0x8006} /* East Asian ideograph */,
  {0, 0, 0x8005} /* East Asian ideograph */,
  {0, 0, 0x800C} /* East Asian ideograph */,
  {0, 0, 0x8010} /* East Asian ideograph */,
  {0, 0, 0x800D} /* East Asian ideograph */,
  {0, 0, 0x8012} /* East Asian ideograph */,
  {0, 0, 0x8015} /* East Asian ideograph */,
  {0, 0, 0x8018} /* East Asian ideograph */,
  {0, 0, 0x8019} /* East Asian ideograph */,
  {0, 0, 0x8017} /* East Asian ideograph */,
  {0, 0, 0x801C} /* East Asian ideograph */,
  {0, 0, 0x8033} /* East Asian ideograph */,
  {0, 0, 0x8036} /* East Asian ideograph */,
  {0, 0, 0x803F} /* East Asian ideograph */,
  {0, 0, 0x803D} /* East Asian ideograph */,
  {0, 0, 0x804A} /* East Asian ideograph */,
  {0, 0, 0x8046} /* East Asian ideograph */,
  {0, 0, 0x8056} /* East Asian ideograph */,
  {0, 0, 0x8058} /* East Asian ideograph */,
  {0, 0, 0x805E} /* East Asian ideograph */,
  {0, 0, 0x805A} /* East Asian ideograph */,
  {0, 0, 0x8071} /* East Asian ideograph */,
  {0, 0, 0x8072} /* East Asian ideograph */,
  {0, 0, 0x8073} /* East Asian ideograph */,
  {0, 0, 0x8070} /* East Asian ideograph */,
  {0, 0, 0x806F} /* East Asian ideograph */,
  {0, 0, 0x8077} /* East Asian ideograph */,
  {0, 0, 0x8076} /* East Asian ideograph */,
  {0, 0, 0x807E} /* East Asian ideograph */,
  {0, 0, 0x807D} /* East Asian ideograph */,
  {0, 0, 0x807F} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x8084} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8_31page37 = {
  0, marc8_31page37_dir
};
/* PAGE 36 */
struct yaz_iconv_trie_dir marc8_31page36_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x7D17} /* East Asian ideograph */,
  {0, 0, 0x7D0D} /* East Asian ideograph (variant of EACC 455122) */,
  {0, 0, 0x7D1A} /* East Asian ideograph */,
  {0, 0, 0x7D19} /* East Asian ideograph */,
  {0, 0, 0x7D1B} /* East Asian ideograph */,
  {0, 0, 0x7D46} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x7D3C} /* East Asian ideograph */,
  {0, 0, 0x7D2E} /* East Asian ideograph */,
  {0, 0, 0x7D39} /* East Asian ideograph */,
  {0, 0, 0x7D44} /* East Asian ideograph */,
  {0, 0, 0x7D30} /* East Asian ideograph */,
  {0, 0, 0x7D33} /* East Asian ideograph */,
  {0, 0, 0x7D2F} /* East Asian ideograph */,
  {0, 0, 0x7D40} /* East Asian ideograph */,
  {0, 0, 0x7D42} /* East Asian ideograph */,
  {0, 0, 0x7D71} /* East Asian ideograph */,
  {0, 0, 0x7D5E} /* East Asian ideograph */,
  {0, 0, 0x7D68} /* East Asian ideograph */,
  {0, 0, 0x7D50} /* East Asian ideograph */,
  {0, 0, 0x7D2B} /* East Asian ideograph */,
  {0, 0, 0x7D62} /* East Asian ideograph */,
  {0, 0, 0x7D76} /* East Asian ideograph */,
  {0, 0, 0x7D61} /* East Asian ideograph */,
  {0, 0, 0x7D66} /* East Asian ideograph */,
  {0, 0, 0x7D6E} /* East Asian ideograph */,
  {0, 0, 0x7D72} /* East Asian ideograph */,
  {0, 0, 0x7D93} /* East Asian ideograph */,
  {0, 0, 0x7D91} /* East Asian ideograph */,
  {0, 0, 0x7D79} /* East Asian ideograph */,
  {0, 0, 0x7D8F} /* East Asian ideograph */,
  {0, 0, 0x7D81} /* East Asian ideograph */,
  {0, 0, 0x7D9C} /* East Asian ideograph */,
  {0, 0, 0x7DBB} /* East Asian ideograph */,
  {0, 0, 0x7DB0} /* East Asian ideograph */,
  {0, 0, 0x7DCA} /* East Asian ideograph */,
  {0, 0, 0x7DBE} /* East Asian ideograph */,
  {0, 0, 0x7DB4} /* East Asian ideograph */,
  {0, 0, 0x7DBA} /* East Asian ideograph */,
  {0, 0, 0x7DB2} /* East Asian ideograph */,
  {0, 0, 0x7DB1} /* East Asian ideograph */,
  {0, 0, 0x7DBD} /* East Asian ideograph */,
  {0, 0, 0x7DB5} /* East Asian ideograph */,
  {0, 0, 0x7DA0} /* East Asian ideograph */,
  {0, 0, 0x7DA2} /* East Asian ideograph */,
  {0, 0, 0x7DAD} /* East Asian ideograph */,
  {0, 0, 0x7DBF} /* East Asian ideograph */,
  {0, 0, 0x7DB8} /* East Asian ideograph */,
  {0, 0, 0x7DC7} /* East Asian ideograph */,
  {0, 0, 0x7DE0} /* East Asian ideograph */,
  {0, 0, 0x7DEF} /* East Asian ideograph */,
  {0, 0, 0x7DF4} /* East Asian ideograph (variant of EACC 4B5154) */,
  {0, 0, 0x7DD6} /* East Asian ideograph */,
  {0, 0, 0x7DD8} /* East Asian ideograph */,
  {0, 0, 0x7DEC} /* East Asian ideograph */,
  {0, 0, 0x7DDD} /* East Asian ideograph */,
  {0, 0, 0x7DE9} /* East Asian ideograph */,
  {0, 0, 0x7DE3} /* East Asian ideograph */,
  {0, 0, 0x7DE8} /* East Asian ideograph */,
  {0, 0, 0x7DDA} /* East Asian ideograph */,
  {0, 0, 0x7D9E} /* East Asian ideograph */,
  {0, 0, 0x7DDE} /* East Asian ideograph */,
  {0, 0, 0x7E11} /* East Asian ideograph */,
  {0, 0, 0x7E0A} /* East Asian ideograph */,
  {0, 0, 0x7E08} /* East Asian ideograph */,
  {0, 0, 0x7E1B} /* East Asian ideograph */,
  {0, 0, 0x7DFB} /* East Asian ideograph */,
  {0, 0, 0x7E23} /* East Asian ideograph */,
  {0, 0, 0x7E2E} /* East Asian ideograph */,
  {0, 0, 0x7E3E} /* East Asian ideograph */,
  {0, 0, 0x7E46} /* East Asian ideograph */,
  {0, 0, 0x7E37} /* East Asian ideograph */,
  {0, 0, 0x7E32} /* East Asian ideograph */,
  {0, 0, 0x7E43} /* East Asian ideograph */,
  {0, 0, 0x7E41} /* East Asian ideograph */,
  {0, 0, 0x7E2B} /* East Asian ideograph */,
  {0, 0, 0x7E3D} /* East Asian ideograph */,
  {0, 0, 0x7E31} /* East Asian ideograph */,
  {0, 0, 0x7E45} /* East Asian ideograph */,
  {0, 0, 0x7E55} /* East Asian ideograph */,
  {0, 0, 0x7E54} /* East Asian ideograph */,
  {0, 0, 0x7E61} /* East Asian ideograph */,
  {0, 0, 0x7E5E} /* East Asian ideograph */,
  {0, 0, 0x7E5A} /* East Asian ideograph */,
  {0, 0, 0x7E6B} /* East Asian ideograph */,
  {0, 0, 0x7E69} /* East Asian ideograph */,
  {0, 0, 0x7E6D} /* East Asian ideograph */,
  {0, 0, 0x7E79} /* East Asian ideograph */,
  {0, 0, 0x7E6A} /* East Asian ideograph */,
  {0, 0, 0x8FAE} /* East Asian ideograph */,
  {0, 0, 0x7E7D} /* East Asian ideograph */,
  {0, 0, 0x7E82} /* East Asian ideograph */,
  {0, 0, 0x7E7C} /* East Asian ideograph */,
  {0, 0, 0x7E8F} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8_31page36 = {
  0, marc8_31page36_dir
};
/* PAGE 35 */
struct yaz_iconv_trie_dir marc8_31page35_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x7B4D} /* East Asian ideograph */,
  {0, 0, 0x7B4F} /* East Asian ideograph */,
  {0, 0, 0x7B54} /* East Asian ideograph */,
  {0, 0, 0x7B60} /* East Asian ideograph */,
  {0, 0, 0x7B77} /* East Asian ideograph */,
  {0, 0, 0x7B75} /* East Asian ideograph */,
  {0, 0, 0x7BA1} /* East Asian ideograph */,
  {0, 0, 0x7B94} /* East Asian ideograph */,
  {0, 0, 0x7B95} /* East Asian ideograph */,
  {0, 0, 0x7B9D} /* East Asian ideograph */,
  {0, 0, 0x7B8B} /* East Asian ideograph */,
  {0, 0, 0x7B97} /* East Asian ideograph */,
  {0, 0, 0x7B8F} /* East Asian ideograph */,
  {0, 0, 0x7BC7} /* East Asian ideograph */,
  {0, 0, 0x7BAD} /* East Asian ideograph */,
  {0, 0, 0x7BC4} /* East Asian ideograph */,
  {0, 0, 0x7BB1} /* East Asian ideograph */,
  {0, 0, 0x7BB4} /* East Asian ideograph */,
  {0, 0, 0x7BC0} /* East Asian ideograph */,
  {0, 0, 0x7BC6} /* East Asian ideograph */,
  {0, 0, 0x7BC1} /* East Asian ideograph */,
  {0, 0, 0x7C11} /* East Asian ideograph */,
  {0, 0, 0x7BD9} /* East Asian ideograph */,
  {0, 0, 0x7BDB} /* East Asian ideograph */,
  {0, 0, 0x7BE4} /* East Asian ideograph */,
  {0, 0, 0x7BC9} /* East Asian ideograph */,
  {0, 0, 0x7BE1} /* East Asian ideograph */,
  {0, 0, 0x7BE9} /* East Asian ideograph */,
  {0, 0, 0x7C07} /* East Asian ideograph */,
  {0, 0, 0x7C0D} /* East Asian ideograph */,
  {0, 0, 0x7BFE} /* East Asian ideograph */,
  {0, 0, 0x7BF7} /* East Asian ideograph */,
  {0, 0, 0x7C21} /* East Asian ideograph */,
  {0, 0, 0x7C2B} /* East Asian ideograph */,
  {0, 0, 0x7C2A} /* East Asian ideograph */,
  {0, 0, 0x7C27} /* East Asian ideograph */,
  {0, 0, 0x7C1E} /* East Asian ideograph */,
  {0, 0, 0x7C23} /* East Asian ideograph */,
  {0, 0, 0x7C3F} /* East Asian ideograph */,
  {0, 0, 0x7C3E} /* East Asian ideograph */,
  {0, 0, 0x7C38} /* East Asian ideograph */,
  {0, 0, 0x7C37} /* East Asian ideograph */,
  {0, 0, 0x7C3D} /* East Asian ideograph */,
  {0, 0, 0x7C43} /* East Asian ideograph */,
  {0, 0, 0x7C4C} /* East Asian ideograph */,
  {0, 0, 0x7C4D} /* East Asian ideograph */,
  {0, 0, 0x7C50} /* East Asian ideograph */,
  {0, 0, 0x7C60} /* East Asian ideograph */,
  {0, 0, 0x7C5F} /* East Asian ideograph */,
  {0, 0, 0x7C64} /* East Asian ideograph */,
  {0, 0, 0x7C6C} /* East Asian ideograph */,
  {0, 0, 0x7C6E} /* East Asian ideograph */,
  {0, 0, 0x7C72} /* East Asian ideograph */,
  {0, 0, 0x7C73} /* East Asian ideograph */,
  {0, 0, 0x7C89} /* East Asian ideograph */,
  {0, 0, 0x7C92} /* East Asian ideograph */,
  {0, 0, 0x7C97} /* East Asian ideograph */,
  {0, 0, 0x7C9F} /* East Asian ideograph */,
  {0, 0, 0x7CA5} /* East Asian ideograph */,
  {0, 0, 0x7CA4} /* East Asian ideograph */,
  {0, 0, 0x7CB1} /* East Asian ideograph */,
  {0, 0, 0x7CB3} /* East Asian ideograph */,
  {0, 0, 0x7CBD} /* East Asian ideograph */,
  {0, 0, 0x7CB9} /* East Asian ideograph */,
  {0, 0, 0x7CBE} /* East Asian ideograph (variant of EACC 4B5061) */,
  {0, 0, 0x7CCA} /* East Asian ideograph */,
  {0, 0, 0x7CD6} /* East Asian ideograph */,
  {0, 0, 0x7CD5} /* East Asian ideograph */,
  {0, 0, 0x7CE0} /* East Asian ideograph */,
  {0, 0, 0x7CDC} /* East Asian ideograph */,
  {0, 0, 0x7CDF} /* East Asian ideograph */,
  {0, 0, 0x7CDE} /* East Asian ideograph */,
  {0, 0, 0x7CE2} /* East Asian ideograph */,
  {0, 0, 0x7CD9} /* East Asian ideograph */,
  {0, 0, 0x7CE7} /* East Asian ideograph */,
  {0, 0, 0x7CEF} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x7CFB} /* East Asian ideograph */,
  {0, 0, 0x7CFE} /* East Asian ideograph */,
  {0, 0, 0x7D00} /* East Asian ideograph */,
  {0, 0, 0x7D02} /* East Asian ideograph */,
  {0, 0, 0x7D05} /* East Asian ideograph */,
  {0, 0, 0x7D09} /* East Asian ideograph */,
  {0, 0, 0x7D04} /* East Asian ideograph */,
  {0, 0, 0x7D07} /* East Asian ideograph */,
  {0, 0, 0x7D21} /* East Asian ideograph */,
  {0, 0, 0x7D0B} /* East Asian ideograph */,
  {0, 0, 0x7D0A} /* East Asian ideograph */,
  {0, 0, 0x7D20} /* East Asian ideograph */,
  {0, 0, 0x7D1C} /* East Asian ideograph */,
  {0, 0, 0x7D22} /* East Asian ideograph */,
  {0, 0, 0x7D15} /* East Asian ideograph */,
  {0, 0, 0x7D14} /* East Asian ideograph */,
  {0, 0, 0x7D10} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8_31page35 = {
  0, marc8_31page35_dir
};
/* PAGE 34 */
struct yaz_iconv_trie_dir marc8_31page34_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x79BD} /* East Asian ideograph */,
  {0, 0, 0x842C} /* East Asian ideograph */,
  {0, 0, 0x79BE} /* East Asian ideograph */,
  {0, 0, 0x79C0} /* East Asian ideograph */,
  {0, 0, 0x79C1} /* East Asian ideograph */,
  {0, 0, 0x79BF} /* East Asian ideograph */,
  {0, 0, 0x79C9} /* East Asian ideograph */,
  {0, 0, 0x79D1} /* East Asian ideograph */,
  {0, 0, 0x79CB} /* East Asian ideograph */,
  {0, 0, 0x79D2} /* East Asian ideograph */,
  {0, 0, 0x79E4} /* East Asian ideograph */,
  {0, 0, 0x79E6} /* East Asian ideograph */,
  {0, 0, 0x79E3} /* East Asian ideograph */,
  {0, 0, 0x79DF} /* East Asian ideograph */,
  {0, 0, 0x79E7} /* East Asian ideograph */,
  {0, 0, 0x79E9} /* East Asian ideograph */,
  {0, 0, 0x79FB} /* East Asian ideograph */,
  {0, 0, 0x7A05} /* East Asian ideograph */,
  {0, 0, 0x7A0D} /* East Asian ideograph */,
  {0, 0, 0x7A08} /* East Asian ideograph */,
  {0, 0, 0x7A0B} /* East Asian ideograph */,
  {0, 0, 0x7A00} /* East Asian ideograph */,
  {0, 0, 0x7A1F} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x7A20} /* East Asian ideograph */,
  {0, 0, 0x7A1A} /* East Asian ideograph */,
  {0, 0, 0x7A14} /* East Asian ideograph */,
  {0, 0, 0x7A31} /* East Asian ideograph */,
  {0, 0, 0x7A2E} /* East Asian ideograph */,
  {0, 0, 0x7A3F} /* East Asian ideograph */,
  {0, 0, 0x7A3C} /* East Asian ideograph */,
  {0, 0, 0x7A40} /* East Asian ideograph */,
  {0, 0, 0x7A3D} /* East Asian ideograph */,
  {0, 0, 0x7A37} /* East Asian ideograph */,
  {0, 0, 0x7A3B} /* East Asian ideograph */,
  {0, 0, 0x7A4D} /* East Asian ideograph */,
  {0, 0, 0x7A4E} /* East Asian ideograph */,
  {0, 0, 0x7A4C} /* East Asian ideograph */,
  {0, 0, 0x7A46} /* East Asian ideograph */,
  {0, 0, 0x7A57} /* East Asian ideograph */,
  {0, 0, 0x7A61} /* East Asian ideograph */,
  {0, 0, 0x7A62} /* East Asian ideograph */,
  {0, 0, 0x7A6B} /* East Asian ideograph */,
  {0, 0, 0x7A69} /* East Asian ideograph */,
  {0, 0, 0x7A74} /* East Asian ideograph */,
  {0, 0, 0x7A76} /* East Asian ideograph */,
  {0, 0, 0x7A79} /* East Asian ideograph */,
  {0, 0, 0x7A7A} /* East Asian ideograph */,
  {0, 0, 0x7A7F} /* East Asian ideograph */,
  {0, 0, 0x7A81} /* East Asian ideograph */,
  {0, 0, 0x7A84} /* East Asian ideograph */,
  {0, 0, 0x7A88} /* East Asian ideograph */,
  {0, 0, 0x7A92} /* East Asian ideograph */,
  {0, 0, 0x7A95} /* East Asian ideograph */,
  {0, 0, 0x7A98} /* East Asian ideograph */,
  {0, 0, 0x7A96} /* East Asian ideograph */,
  {0, 0, 0x7A97} /* East Asian ideograph */,
  {0, 0, 0x7A9F} /* East Asian ideograph */,
  {0, 0, 0x7AA0} /* East Asian ideograph */,
  {0, 0, 0x7AAA} /* East Asian ideograph */,
  {0, 0, 0x7AA9} /* East Asian ideograph */,
  {0, 0, 0x7AAF} /* East Asian ideograph */,
  {0, 0, 0x7AAE} /* East Asian ideograph */,
  {0, 0, 0x7ABA} /* East Asian ideograph */,
  {0, 0, 0x7AC5} /* East Asian ideograph */,
  {0, 0, 0x7AC4} /* East Asian ideograph */,
  {0, 0, 0x7AC7} /* East Asian ideograph */,
  {0, 0, 0x7ACA} /* East Asian ideograph */,
  {0, 0, 0x7ACB} /* East Asian ideograph */,
  {0, 0, 0x7AD9} /* East Asian ideograph */,
  {0, 0, 0x7AE5} /* East Asian ideograph */,
  {0, 0, 0x7AE3} /* East Asian ideograph */,
  {0, 0, 0x7AED} /* East Asian ideograph */,
  {0, 0, 0x7AEF} /* East Asian ideograph */,
  {0, 0, 0x7AF6} /* East Asian ideograph */,
  {0, 0, 0x7AF9} /* East Asian ideograph */,
  {0, 0, 0x7AFA} /* East Asian ideograph */,
  {0, 0, 0x7AFF} /* East Asian ideograph */,
  {0, 0, 0x7AFD} /* East Asian ideograph */,
  {0, 0, 0x7B06} /* East Asian ideograph */,
  {0, 0, 0x7B11} /* East Asian ideograph */,
  {0, 0, 0x7B20} /* East Asian ideograph */,
  {0, 0, 0x7B2C} /* East Asian ideograph */,
  {0, 0, 0x7B28} /* East Asian ideograph */,
  {0, 0, 0x7B1B} /* East Asian ideograph */,
  {0, 0, 0x7B1E} /* East Asian ideograph */,
  {0, 0, 0x7B19} /* East Asian ideograph */,
  {0, 0, 0x7B26} /* East Asian ideograph */,
  {0, 0, 0x7B46} /* East Asian ideograph */,
  {0, 0, 0x7B49} /* East Asian ideograph */,
  {0, 0, 0x7B50} /* East Asian ideograph */,
  {0, 0, 0x7B56} /* East Asian ideograph */,
  {0, 0, 0x7B52} /* East Asian ideograph */,
  {0, 0, 0x7B4B} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8_31page34 = {
  0, marc8_31page34_dir
};
/* PAGE 33 */
struct yaz_iconv_trie_dir marc8_31page33_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x77E2} /* East Asian ideograph */,
  {0, 0, 0x77E3} /* East Asian ideograph */,
  {0, 0, 0x77E5} /* East Asian ideograph */,
  {0, 0, 0x77E9} /* East Asian ideograph */,
  {0, 0, 0x77ED} /* East Asian ideograph */,
  {0, 0, 0x77EE} /* East Asian ideograph */,
  {0, 0, 0x77EF} /* East Asian ideograph */,
  {0, 0, 0x77F3} /* East Asian ideograph */,
  {0, 0, 0x77FD} /* East Asian ideograph */,
  {0, 0, 0x7802} /* East Asian ideograph */,
  {0, 0, 0x780D} /* East Asian ideograph */,
  {0, 0, 0x780C} /* East Asian ideograph */,
  {0, 0, 0x65AB} /* East Asian ideograph */,
  {0, 0, 0x7830} /* East Asian ideograph */,
  {0, 0, 0x781D} /* East Asian ideograph */,
  {0, 0, 0x7834} /* East Asian ideograph */,
  {0, 0, 0x7838} /* East Asian ideograph */,
  {0, 0, 0x7837} /* East Asian ideograph */,
  {0, 0, 0x7827} /* East Asian ideograph */,
  {0, 0, 0x782D} /* East Asian ideograph */,
  {0, 0, 0x7825} /* East Asian ideograph */,
  {0, 0, 0x786B} /* East Asian ideograph */,
  {0, 0, 0x784F} /* East Asian ideograph */,
  {0, 0, 0x7843} /* East Asian ideograph */,
  {0, 0, 0x786C} /* East Asian ideograph */,
  {0, 0, 0x785D} /* East Asian ideograph */,
  {0, 0, 0x786F} /* East Asian ideograph */,
  {0, 0, 0x78B0} /* East Asian ideograph */,
  {0, 0, 0x7897} /* East Asian ideograph */,
  {0, 0, 0x788E} /* East Asian ideograph */,
  {0, 0, 0x7898} /* East Asian ideograph */,
  {0, 0, 0x7889} /* East Asian ideograph */,
  {0, 0, 0x7891} /* East Asian ideograph */,
  {0, 0, 0x787C} /* East Asian ideograph */,
  {0, 0, 0x788C} /* East Asian ideograph */,
  {0, 0, 0x78A7} /* East Asian ideograph */,
  {0, 0, 0x78A9} /* East Asian ideograph */,
  {0, 0, 0x789F} /* East Asian ideograph */,
  {0, 0, 0x78B3} /* East Asian ideograph */,
  {0, 0, 0x78CB} /* East Asian ideograph */,
  {0, 0, 0x78BA} /* East Asian ideograph */,
  {0, 0, 0x78C1} /* East Asian ideograph */,
  {0, 0, 0x78C5} /* East Asian ideograph */,
  {0, 0, 0x78BC} /* East Asian ideograph */,
  {0, 0, 0x78D5} /* East Asian ideograph */,
  {0, 0, 0x78BE} /* East Asian ideograph */,
  {0, 0, 0x78CA} /* East Asian ideograph */,
  {0, 0, 0x78D0} /* East Asian ideograph */,
  {0, 0, 0x78E8} /* East Asian ideograph */,
  {0, 0, 0x78EC} /* East Asian ideograph */,
  {0, 0, 0x78DA} /* East Asian ideograph */,
  {0, 0, 0x78F7} /* East Asian ideograph */,
  {0, 0, 0x78F4} /* East Asian ideograph */,
  {0, 0, 0x78FA} /* East Asian ideograph (variant of EACC 4B4E56) */,
  {0, 0, 0x7901} /* East Asian ideograph */,
  {0, 0, 0x78EF} /* East Asian ideograph */,
  {0, 0, 0x790E} /* East Asian ideograph */,
  {0, 0, 0x7919} /* East Asian ideograph */,
  {0, 0, 0x7926} /* East Asian ideograph */,
  {0, 0, 0x792C} /* East Asian ideograph */,
  {0, 0, 0x792A} /* East Asian ideograph */,
  {0, 0, 0x792B} /* East Asian ideograph */,
  {0, 0, 0x793A} /* East Asian ideograph */,
  {0, 0, 0x7940} /* East Asian ideograph */,
  {0, 0, 0x793E} /* East Asian ideograph */,
  {0, 0, 0x7941} /* East Asian ideograph */,
  {0, 0, 0x7945} /* East Asian ideograph */,
  {0, 0, 0x7949} /* East Asian ideograph */,
  {0, 0, 0x7948} /* East Asian ideograph */,
  {0, 0, 0x7947} /* East Asian ideograph */,
  {0, 0, 0x7955} /* East Asian ideograph */,
  {0, 0, 0x7960} /* East Asian ideograph */,
  {0, 0, 0x7950} /* East Asian ideograph */,
  {0, 0, 0x7956} /* East Asian ideograph */,
  {0, 0, 0x795E} /* East Asian ideograph */,
  {0, 0, 0x795D} /* East Asian ideograph */,
  {0, 0, 0x795F} /* East Asian ideograph */,
  {0, 0, 0x795A} /* East Asian ideograph */,
  {0, 0, 0x7957} /* East Asian ideograph */,
  {0, 0, 0x7965} /* East Asian ideograph */,
  {0, 0, 0x7968} /* East Asian ideograph */,
  {0, 0, 0x796D} /* East Asian ideograph */,
  {0, 0, 0x797A} /* East Asian ideograph */,
  {0, 0, 0x7981} /* East Asian ideograph */,
  {0, 0, 0x797F} /* East Asian ideograph */,
  {0, 0, 0x798F} /* East Asian ideograph */,
  {0, 0, 0x798D} /* East Asian ideograph */,
  {0, 0, 0x798E} /* East Asian ideograph */,
  {0, 0, 0x79A6} /* East Asian ideograph */,
  {0, 0, 0x79A7} /* East Asian ideograph */,
  {0, 0, 0x79AA} /* East Asian ideograph */,
  {0, 0, 0x79AE} /* East Asian ideograph */,
  {0, 0, 0x79B1} /* East Asian ideograph */,
  {0, 0, 0x79B9} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8_31page33 = {
  0, marc8_31page33_dir
};
/* PAGE 32 */
struct yaz_iconv_trie_dir marc8_31page32_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x7682} /* East Asian ideograph */,
  {0, 0, 0x7684} /* East Asian ideograph */,
  {0, 0, 0x7687} /* East Asian ideograph */,
  {0, 0, 0x7686} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x768E} /* East Asian ideograph */,
  {0, 0, 0x7696} /* East Asian ideograph */,
  {0, 0, 0x7693} /* East Asian ideograph */,
  {0, 0, 0x769A} /* East Asian ideograph */,
  {0, 0, 0x76AE} /* East Asian ideograph */,
  {0, 0, 0x76B0} /* East Asian ideograph */,
  {0, 0, 0x76B4} /* East Asian ideograph */,
  {0, 0, 0x76BA} /* East Asian ideograph */,
  {0, 0, 0x76BF} /* East Asian ideograph */,
  {0, 0, 0x76C2} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x76C8} /* East Asian ideograph */,
  {0, 0, 0x76C6} /* East Asian ideograph */,
  {0, 0, 0x76CA} /* East Asian ideograph */,
  {0, 0, 0x76CD} /* East Asian ideograph */,
  {0, 0, 0x76CE} /* East Asian ideograph */,
  {0, 0, 0x76D4} /* East Asian ideograph */,
  {0, 0, 0x76D2} /* East Asian ideograph */,
  {0, 0, 0x76DC} /* East Asian ideograph */,
  {0, 0, 0x76DB} /* East Asian ideograph */,
  {0, 0, 0x76DE} /* East Asian ideograph */,
  {0, 0, 0x76DF} /* East Asian ideograph */,
  {0, 0, 0x76E1} /* East Asian ideograph */,
  {0, 0, 0x76E3} /* East Asian ideograph */,
  {0, 0, 0x76E4} /* East Asian ideograph */,
  {0, 0, 0x76E7} /* East Asian ideograph */,
  {0, 0, 0x76E5} /* East Asian ideograph */,
  {0, 0, 0x76EA} /* East Asian ideograph */,
  {0, 0, 0x76EE} /* East Asian ideograph */,
  {0, 0, 0x76EF} /* East Asian ideograph */,
  {0, 0, 0x76F2} /* East Asian ideograph */,
  {0, 0, 0x76F4} /* East Asian ideograph */,
  {0, 0, 0x7709} /* East Asian ideograph */,
  {0, 0, 0x76F9} /* East Asian ideograph */,
  {0, 0, 0x76F8} /* East Asian ideograph */,
  {0, 0, 0x7701} /* East Asian ideograph */,
  {0, 0, 0x770B} /* East Asian ideograph */,
  {0, 0, 0x76FC} /* East Asian ideograph */,
  {0, 0, 0x76FE} /* East Asian ideograph */,
  {0, 0, 0x7729} /* East Asian ideograph */,
  {0, 0, 0x7720} /* East Asian ideograph */,
  {0, 0, 0x771E} /* East Asian ideograph */,
  {0, 0, 0x7728} /* East Asian ideograph */,
  {0, 0, 0x7737} /* East Asian ideograph */,
  {0, 0, 0x773C} /* East Asian ideograph */,
  {0, 0, 0x7736} /* East Asian ideograph */,
  {0, 0, 0x7738} /* East Asian ideograph */,
  {0, 0, 0x773A} /* East Asian ideograph */,
  {0, 0, 0x773E} /* East Asian ideograph */,
  {0, 0, 0x774F} /* East Asian ideograph */,
  {0, 0, 0x776B} /* East Asian ideograph */,
  {0, 0, 0x775B} /* East Asian ideograph */,
  {0, 0, 0x776A} /* East Asian ideograph */,
  {0, 0, 0x7766} /* East Asian ideograph */,
  {0, 0, 0x7779} /* East Asian ideograph */,
  {0, 0, 0x775E} /* East Asian ideograph */,
  {0, 0, 0x7763} /* East Asian ideograph */,
  {0, 0, 0x775C} /* East Asian ideograph */,
  {0, 0, 0x776C} /* East Asian ideograph */,
  {0, 0, 0x7768} /* East Asian ideograph */,
  {0, 0, 0x7765} /* East Asian ideograph */,
  {0, 0, 0x777D} /* East Asian ideograph */,
  {0, 0, 0x7771} /* East Asian ideograph */,
  {0, 0, 0x777F} /* East Asian ideograph */,
  {0, 0, 0x7784} /* East Asian ideograph */,
  {0, 0, 0x7761} /* East Asian ideograph */,
  {0, 0, 0x7787} /* East Asian ideograph */,
  {0, 0, 0x778E} /* East Asian ideograph */,
  {0, 0, 0x778C} /* East Asian ideograph */,
  {0, 0, 0x7791} /* East Asian ideograph */,
  {0, 0, 0x779F} /* East Asian ideograph */,
  {0, 0, 0x779E} /* East Asian ideograph */,
  {0, 0, 0x77A0} /* East Asian ideograph */,
  {0, 0, 0x77A5} /* East Asian ideograph */,
  {0, 0, 0x77B3} /* East Asian ideograph */,
  {0, 0, 0x77AA} /* East Asian ideograph */,
  {0, 0, 0x77B0} /* East Asian ideograph */,
  {0, 0, 0x77AD} /* East Asian ideograph */,
  {0, 0, 0x77AC} /* East Asian ideograph */,
  {0, 0, 0x77A7} /* East Asian ideograph */,
  {0, 0, 0x77BD} /* East Asian ideograph */,
  {0, 0, 0x77BF} /* East Asian ideograph */,
  {0, 0, 0x77BB} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x77D3} /* East Asian ideograph */,
  {0, 0, 0x77D7} /* East Asian ideograph */,
  {0, 0, 0x77DA} /* East Asian ideograph */,
  {0, 0, 0x77DB} /* East Asian ideograph */,
  {0, 0, 0x77DC} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8_31page32 = {
  0, marc8_31page32_dir
};
/* PAGE 31 */
struct yaz_iconv_trie_dir marc8_31page31_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x752C} /* East Asian ideograph */,
  {0, 0, 0x752B} /* East Asian ideograph */,
  {0, 0, 0x752D} /* East Asian ideograph */,
  {0, 0, 0x7530} /* East Asian ideograph */,
  {0, 0, 0x7532} /* East Asian ideograph */,
  {0, 0, 0x7531} /* East Asian ideograph */,
  {0, 0, 0x7533} /* East Asian ideograph */,
  {0, 0, 0x7537} /* East Asian ideograph */,
  {0, 0, 0x7538} /* East Asian ideograph */,
  {0, 0, 0x753D} /* East Asian ideograph */,
  {0, 0, 0x754F} /* East Asian ideograph */,
  {0, 0, 0x754C} /* East Asian ideograph */,
  {0, 0, 0x755D} /* East Asian ideograph */,
  {0, 0, 0x755C} /* East Asian ideograph */,
  {0, 0, 0x7554} /* East Asian ideograph */,
  {0, 0, 0x755A} /* East Asian ideograph */,
  {0, 0, 0x7559} /* East Asian ideograph */,
  {0, 0, 0x7566} /* East Asian ideograph */,
  {0, 0, 0x7562} /* East Asian ideograph */,
  {0, 0, 0x7570} /* East Asian ideograph */,
  {0, 0, 0x7565} /* East Asian ideograph */,
  {0, 0, 0x756B} /* East Asian ideograph */,
  {0, 0, 0x756A} /* East Asian ideograph */,
  {0, 0, 0x7578} /* East Asian ideograph */,
  {0, 0, 0x7576} /* East Asian ideograph */,
  {0, 0, 0x7586} /* East Asian ideograph */,
  {0, 0, 0x7587} /* East Asian ideograph */,
  {0, 0, 0x758A} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x758F} /* East Asian ideograph */,
  {0, 0, 0x7591} /* East Asian ideograph */,
  {0, 0, 0x759D} /* East Asian ideograph */,
  {0, 0, 0x7599} /* East Asian ideograph */,
  {0, 0, 0x759A} /* East Asian ideograph */,
  {0, 0, 0x75A4} /* East Asian ideograph */,
  {0, 0, 0x75AB} /* East Asian ideograph */,
  {0, 0, 0x75A5} /* East Asian ideograph */,
  {0, 0, 0x75C7} /* East Asian ideograph */,
  {0, 0, 0x75C5} /* East Asian ideograph */,
  {0, 0, 0x75B3} /* East Asian ideograph */,
  {0, 0, 0x75B2} /* East Asian ideograph */,
  {0, 0, 0x75BD} /* East Asian ideograph */,
  {0, 0, 0x75BE} /* East Asian ideograph */,
  {0, 0, 0x75BC} /* East Asian ideograph */,
  {0, 0, 0x75B9} /* East Asian ideograph */,
  {0, 0, 0x75D5} /* East Asian ideograph */,
  {0, 0, 0x75D4} /* East Asian ideograph */,
  {0, 0, 0x75B5} /* East Asian ideograph */,
  {0, 0, 0x75CA} /* East Asian ideograph (variant of EACC 4B4C51) */,
  {0, 0, 0x75DB} /* East Asian ideograph */,
  {0, 0, 0x75E3} /* East Asian ideograph */,
  {0, 0, 0x75D8} /* East Asian ideograph */,
  {0, 0, 0x75DE} /* East Asian ideograph */,
  {0, 0, 0x75D9} /* East Asian ideograph */,
  {0, 0, 0x75E2} /* East Asian ideograph */,
  {0, 0, 0x7601} /* East Asian ideograph */,
  {0, 0, 0x7600} /* East Asian ideograph */,
  {0, 0, 0x75F0} /* East Asian ideograph */,
  {0, 0, 0x75F2} /* East Asian ideograph */,
  {0, 0, 0x75F1} /* East Asian ideograph */,
  {0, 0, 0x75F4} /* East Asian ideograph */,
  {0, 0, 0x75FF} /* East Asian ideograph */,
  {0, 0, 0x75FA} /* East Asian ideograph */,
  {0, 0, 0x760D} /* East Asian ideograph */,
  {0, 0, 0x7627} /* East Asian ideograph */,
  {0, 0, 0x7613} /* East Asian ideograph */,
  {0, 0, 0x760B} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x7620} /* East Asian ideograph */,
  {0, 0, 0x7629} /* East Asian ideograph */,
  {0, 0, 0x761F} /* East Asian ideograph */,
  {0, 0, 0x7624} /* East Asian ideograph */,
  {0, 0, 0x7626} /* East Asian ideograph */,
  {0, 0, 0x7621} /* East Asian ideograph */,
  {0, 0, 0x7634} /* East Asian ideograph */,
  {0, 0, 0x7638} /* East Asian ideograph */,
  {0, 0, 0x7646} /* East Asian ideograph */,
  {0, 0, 0x7642} /* East Asian ideograph */,
  {0, 0, 0x764C} /* East Asian ideograph */,
  {0, 0, 0x7656} /* East Asian ideograph */,
  {0, 0, 0x7658} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x7662} /* East Asian ideograph */,
  {0, 0, 0x7665} /* East Asian ideograph */,
  {0, 0, 0x7669} /* East Asian ideograph */,
  {0, 0, 0x766E} /* East Asian ideograph */,
  {0, 0, 0x766C} /* East Asian ideograph */,
  {0, 0, 0x7671} /* East Asian ideograph */,
  {0, 0, 0x7672} /* East Asian ideograph (variant of EACC 4B4C79) */,
  {0, 0, 0x7678} /* East Asian ideograph */,
  {0, 0, 0x767C} /* East Asian ideograph */,
  {0, 0, 0x767B} /* East Asian ideograph */,
  {0, 0, 0x767D} /* East Asian ideograph */,
  {0, 0, 0x767E} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8_31page31 = {
  0, marc8_31page31_dir
};
/* PAGE 30 */
struct yaz_iconv_trie_dir marc8_31page30_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x733F} /* East Asian ideograph */,
  {0, 0, 0x733E} /* East Asian ideograph */,
  {0, 0, 0x7345} /* East Asian ideograph */,
  {0, 0, 0x7350} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x7357} /* East Asian ideograph */,
  {0, 0, 0x7368} /* East Asian ideograph */,
  {0, 0, 0x7370} /* East Asian ideograph */,
  {0, 0, 0x7372} /* East Asian ideograph */,
  {0, 0, 0x7377} /* East Asian ideograph */,
  {0, 0, 0x7378} /* East Asian ideograph */,
  {0, 0, 0x7375} /* East Asian ideograph */,
  {0, 0, 0x737A} /* East Asian ideograph */,
  {0, 0, 0x737B} /* East Asian ideograph */,
  {0, 0, 0x7380} /* East Asian ideograph */,
  {0, 0, 0x7384} /* East Asian ideograph */,
  {0, 0, 0x7387} /* East Asian ideograph */,
  {0, 0, 0x7389} /* East Asian ideograph */,
  {0, 0, 0x738B} /* East Asian ideograph */,
  {0, 0, 0x7396} /* East Asian ideograph */,
  {0, 0, 0x739F} /* East Asian ideograph */,
  {0, 0, 0x73A8} /* East Asian ideograph */,
  {0, 0, 0x73A9} /* East Asian ideograph */,
  {0, 0, 0x73AB} /* East Asian ideograph */,
  {0, 0, 0x73BB} /* East Asian ideograph */,
  {0, 0, 0x73CA} /* East Asian ideograph */,
  {0, 0, 0x73B7} /* East Asian ideograph */,
  {0, 0, 0x73C0} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x73B2} /* East Asian ideograph */,
  {0, 0, 0x73CD} /* East Asian ideograph */,
  {0, 0, 0x73ED} /* East Asian ideograph */,
  {0, 0, 0x73EE} /* East Asian ideograph */,
  {0, 0, 0x73E0} /* East Asian ideograph */,
  {0, 0, 0x7405} /* East Asian ideograph */,
  {0, 0, 0x7409} /* East Asian ideograph */,
  {0, 0, 0x7403} /* East Asian ideograph */,
  {0, 0, 0x740A} /* East Asian ideograph */,
  {0, 0, 0x73FE} /* East Asian ideograph */,
  {0, 0, 0x7406} /* East Asian ideograph */,
  {0, 0, 0x740D} /* East Asian ideograph */,
  {0, 0, 0x743A} /* East Asian ideograph */,
  {0, 0, 0x7435} /* East Asian ideograph */,
  {0, 0, 0x7436} /* East Asian ideograph */,
  {0, 0, 0x7434} /* East Asian ideograph */,
  {0, 0, 0x742A} /* East Asian ideograph */,
  {0, 0, 0x7433} /* East Asian ideograph */,
  {0, 0, 0x7422} /* East Asian ideograph */,
  {0, 0, 0x7425} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x7455} /* East Asian ideograph */,
  {0, 0, 0x745F} /* East Asian ideograph */,
  {0, 0, 0x745A} /* East Asian ideograph */,
  {0, 0, 0x7441} /* East Asian ideograph */,
  {0, 0, 0x743F} /* East Asian ideograph */,
  {0, 0, 0x745B} /* East Asian ideograph */,
  {0, 0, 0x745E} /* East Asian ideograph */,
  {0, 0, 0x745C} /* East Asian ideograph */,
  {0, 0, 0x7459} /* East Asian ideograph */,
  {0, 0, 0x7483} /* East Asian ideograph */,
  {0, 0, 0x7469} /* East Asian ideograph */,
  {0, 0, 0x746A} /* East Asian ideograph */,
  {0, 0, 0x7463} /* East Asian ideograph */,
  {0, 0, 0x7464} /* East Asian ideograph */,
  {0, 0, 0x7470} /* East Asian ideograph */,
  {0, 0, 0x748B} /* East Asian ideograph */,
  {0, 0, 0x749C} /* East Asian ideograph (variant of EACC 4B4B63) */,
  {0, 0, 0x74A3} /* East Asian ideograph */,
  {0, 0, 0x74A7} /* East Asian ideograph */,
  {0, 0, 0x74A9} /* East Asian ideograph */,
  {0, 0, 0x74B0} /* East Asian ideograph */,
  {0, 0, 0x74A6} /* East Asian ideograph */,
  {0, 0, 0x74BD} /* East Asian ideograph */,
  {0, 0, 0x74CA} /* East Asian ideograph */,
  {0, 0, 0x74CF} /* East Asian ideograph */,
  {0, 0, 0x74DC} /* East Asian ideograph */,
  {0, 0, 0x74E0} /* East Asian ideograph */,
  {0, 0, 0x74E2} /* East Asian ideograph */,
  {0, 0, 0x74E3} /* East Asian ideograph */,
  {0, 0, 0x74E6} /* East Asian ideograph */,
  {0, 0, 0x74F6} /* East Asian ideograph */,
  {0, 0, 0x74F7} /* East Asian ideograph */,
  {0, 0, 0x7504} /* East Asian ideograph */,
  {0, 0, 0x750C} /* East Asian ideograph */,
  {0, 0, 0x7515} /* East Asian ideograph */,
  {0, 0, 0x7518} /* East Asian ideograph */,
  {0, 0, 0x751A} /* East Asian ideograph */,
  {0, 0, 0x751C} /* East Asian ideograph */,
  {0, 0, 0x751F} /* East Asian ideograph */,
  {0, 0, 0x7522} /* East Asian ideograph */,
  {0, 0, 0x7526} /* East Asian ideograph */,
  {0, 0, 0x7525} /* East Asian ideograph */,
  {0, 0, 0x7528} /* East Asian ideograph */,
  {0, 0, 0x7529} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8_31page30 = {
  0, marc8_31page30_dir
};
/* PAGE 29 */
struct yaz_iconv_trie_dir marc8_31page29_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x71BE} /* East Asian ideograph */,
  {0, 0, 0x71C9} /* East Asian ideograph */,
  {0, 0, 0x71D0} /* East Asian ideograph */,
  {0, 0, 0x71C8} /* East Asian ideograph */,
  {0, 0, 0x71DC} /* East Asian ideograph */,
  {0, 0, 0x71D2} /* East Asian ideograph */,
  {0, 0, 0x71B9} /* East Asian ideograph */,
  {0, 0, 0x71D5} /* East Asian ideograph */,
  {0, 0, 0x71CE} /* East Asian ideograph */,
  {0, 0, 0x71C3} /* East Asian ideograph */,
  {0, 0, 0x71C4} /* East Asian ideograph */,
  {0, 0, 0x71EE} /* East Asian ideograph */,
  {0, 0, 0x71E7} /* East Asian ideograph */,
  {0, 0, 0x71DF} /* East Asian ideograph */,
  {0, 0, 0x71E5} /* East Asian ideograph */,
  {0, 0, 0x71ED} /* East Asian ideograph */,
  {0, 0, 0x71E6} /* East Asian ideograph */,
  {0, 0, 0x71EC} /* East Asian ideograph */,
  {0, 0, 0x71F4} /* East Asian ideograph */,
  {0, 0, 0x71FB} /* East Asian ideograph */,
  {0, 0, 0x7206} /* East Asian ideograph */,
  {0, 0, 0x720D} /* East Asian ideograph */,
  {0, 0, 0x7210} /* East Asian ideograph */,
  {0, 0, 0x721B} /* East Asian ideograph */,
  {0, 0, 0x7228} /* East Asian ideograph */,
  {0, 0, 0x722A} /* East Asian ideograph */,
  {0, 0, 0x722D} /* East Asian ideograph */,
  {0, 0, 0x722C} /* East Asian ideograph */,
  {0, 0, 0x7230} /* East Asian ideograph */,
  {0, 0, 0x7235} /* East Asian ideograph (variant of EACC 4B4A3E) */,
  {0, 0, 0x7236} /* East Asian ideograph */,
  {0, 0, 0x7238} /* East Asian ideograph */,
  {0, 0, 0x7239} /* East Asian ideograph */,
  {0, 0, 0x723A} /* East Asian ideograph */,
  {0, 0, 0x723B} /* East Asian ideograph */,
  {0, 0, 0x723D} /* East Asian ideograph */,
  {0, 0, 0x723E} /* East Asian ideograph */,
  {0, 0, 0x7246} /* East Asian ideograph */,
  {0, 0, 0x7247} /* East Asian ideograph */,
  {0, 0, 0x7248} /* East Asian ideograph */,
  {0, 0, 0x724C} /* East Asian ideograph */,
  {0, 0, 0x7252} /* East Asian ideograph */,
  {0, 0, 0x7256} /* East Asian ideograph */,
  {0, 0, 0x7258} /* East Asian ideograph */,
  {0, 0, 0x7259} /* East Asian ideograph */,
  {0, 0, 0x725B} /* East Asian ideograph */,
  {0, 0, 0x725F} /* East Asian ideograph */,
  {0, 0, 0x725D} /* East Asian ideograph */,
  {0, 0, 0x7262} /* East Asian ideograph */,
  {0, 0, 0x7261} /* East Asian ideograph */,
  {0, 0, 0x7260} /* East Asian ideograph */,
  {0, 0, 0x7267} /* East Asian ideograph */,
  {0, 0, 0x7269} /* East Asian ideograph */,
  {0, 0, 0x726F} /* East Asian ideograph */,
  {0, 0, 0x7272} /* East Asian ideograph */,
  {0, 0, 0x7274} /* East Asian ideograph */,
  {0, 0, 0x7279} /* East Asian ideograph */,
  {0, 0, 0x727D} /* East Asian ideograph */,
  {0, 0, 0x7281} /* East Asian ideograph */,
  {0, 0, 0x7280} /* East Asian ideograph */,
  {0, 0, 0x7284} /* East Asian ideograph */,
  {0, 0, 0x7296} /* East Asian ideograph */,
  {0, 0, 0x7292} /* East Asian ideograph */,
  {0, 0, 0x729B} /* East Asian ideograph */,
  {0, 0, 0x72A2} /* East Asian ideograph */,
  {0, 0, 0x72A7} /* East Asian ideograph */,
  {0, 0, 0x72AC} /* East Asian ideograph */,
  {0, 0, 0x72AF} /* East Asian ideograph */,
  {0, 0, 0x72C4} /* East Asian ideograph */,
  {0, 0, 0x72C2} /* East Asian ideograph */,
  {0, 0, 0x72D9} /* East Asian ideograph */,
  {0, 0, 0x72C0} /* East Asian ideograph */,
  {0, 0, 0x72CE} /* East Asian ideograph */,
  {0, 0, 0x72D7} /* East Asian ideograph */,
  {0, 0, 0x72D0} /* East Asian ideograph */,
  {0, 0, 0x72E1} /* East Asian ideograph */,
  {0, 0, 0x72E9} /* East Asian ideograph */,
  {0, 0, 0x72E0} /* East Asian ideograph */,
  {0, 0, 0x72FC} /* East Asian ideograph */,
  {0, 0, 0x72F9} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x72FD} /* East Asian ideograph */,
  {0, 0, 0x72F7} /* East Asian ideograph */,
  {0, 0, 0x731C} /* East Asian ideograph */,
  {0, 0, 0x731B} /* East Asian ideograph */,
  {0, 0, 0x7313} /* East Asian ideograph */,
  {0, 0, 0x7316} /* East Asian ideograph */,
  {0, 0, 0x7319} /* East Asian ideograph */,
  {0, 0, 0x7336} /* East Asian ideograph */,
  {0, 0, 0x7337} /* East Asian ideograph */,
  {0, 0, 0x7329} /* East Asian ideograph */,
  {0, 0, 0x7325} /* East Asian ideograph */,
  {0, 0, 0x7334} /* East Asian ideograph */,
  {0, 0, 0x7344} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8_31page29 = {
  0, marc8_31page29_dir
};
/* PAGE 28 */
struct yaz_iconv_trie_dir marc8_31page28_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x6FA4} /* East Asian ideograph */,
  {0, 0, 0x6FC1} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x6FC0} /* East Asian ideograph */,
  {0, 0, 0x6FB3} /* East Asian ideograph */,
  {0, 0, 0x6FDF} /* East Asian ideograph */,
  {0, 0, 0x6FD8} /* East Asian ideograph */,
  {0, 0, 0x6FF1} /* East Asian ideograph */,
  {0, 0, 0x6FE0} /* East Asian ideograph */,
  {0, 0, 0x6FEF} /* East Asian ideograph */,
  {0, 0, 0x6FEB} /* East Asian ideograph (variant of EACC 4B492B) */,
  {0, 0, 0x6FE1} /* East Asian ideograph */,
  {0, 0, 0x6FE4} /* East Asian ideograph */,
  {0, 0, 0x6F80} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x700B} /* East Asian ideograph */,
  {0, 0, 0x7009} /* East Asian ideograph */,
  {0, 0, 0x7006} /* East Asian ideograph */,
  {0, 0, 0x6FFA} /* East Asian ideograph */,
  {0, 0, 0x7011} /* East Asian ideograph */,
  {0, 0, 0x6FFE} /* East Asian ideograph */,
  {0, 0, 0x700F} /* East Asian ideograph */,
  {0, 0, 0x701B} /* East Asian ideograph */,
  {0, 0, 0x701A} /* East Asian ideograph */,
  {0, 0, 0x7028} /* East Asian ideograph */,
  {0, 0, 0x701D} /* East Asian ideograph */,
  {0, 0, 0x7015} /* East Asian ideograph */,
  {0, 0, 0x701F} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x703E} /* East Asian ideograph */,
  {0, 0, 0x704C} /* East Asian ideograph */,
  {0, 0, 0x7051} /* East Asian ideograph */,
  {0, 0, 0x7058} /* East Asian ideograph */,
  {0, 0, 0x7063} /* East Asian ideograph */,
  {0, 0, 0x7064} /* East Asian ideograph */,
  {0, 0, 0x706B} /* East Asian ideograph */,
  {0, 0, 0x7070} /* East Asian ideograph */,
  {0, 0, 0x7076} /* East Asian ideograph */,
  {0, 0, 0x707C} /* East Asian ideograph */,
  {0, 0, 0x7078} /* East Asian ideograph */,
  {0, 0, 0x707D} /* East Asian ideograph */,
  {0, 0, 0x7095} /* East Asian ideograph */,
  {0, 0, 0x708E} /* East Asian ideograph */,
  {0, 0, 0x7092} /* East Asian ideograph */,
  {0, 0, 0x7099} /* East Asian ideograph */,
  {0, 0, 0x708A} /* East Asian ideograph */,
  {0, 0, 0x70AB} /* East Asian ideograph */,
  {0, 0, 0x70BA} /* East Asian ideograph */,
  {0, 0, 0x70AC} /* East Asian ideograph */,
  {0, 0, 0x70B3} /* East Asian ideograph */,
  {0, 0, 0x70AF} /* East Asian ideograph */,
  {0, 0, 0x70AD} /* East Asian ideograph */,
  {0, 0, 0x70AE} /* East Asian ideograph */,
  {0, 0, 0x70B8} /* East Asian ideograph */,
  {0, 0, 0x70CA} /* East Asian ideograph */,
  {0, 0, 0x70E4} /* East Asian ideograph */,
  {0, 0, 0x70D8} /* East Asian ideograph */,
  {0, 0, 0x70C8} /* East Asian ideograph */,
  {0, 0, 0x70D9} /* East Asian ideograph */,
  {0, 0, 0x70CF} /* East Asian ideograph */,
  {0, 0, 0x70F9} /* East Asian ideograph */,
  {0, 0, 0x7109} /* East Asian ideograph */,
  {0, 0, 0x710A} /* East Asian ideograph */,
  {0, 0, 0x70FD} /* East Asian ideograph */,
  {0, 0, 0x7119} /* East Asian ideograph */,
  {0, 0, 0x716E} /* East Asian ideograph */,
  {0, 0, 0x711A} /* East Asian ideograph */,
  {0, 0, 0x7136} /* East Asian ideograph */,
  {0, 0, 0x7121} /* East Asian ideograph */,
  {0, 0, 0x7130} /* East Asian ideograph */,
  {0, 0, 0x7126} /* East Asian ideograph */,
  {0, 0, 0x714E} /* East Asian ideograph */,
  {0, 0, 0x7149} /* East Asian ideograph */,
  {0, 0, 0x7159} /* East Asian ideograph */,
  {0, 0, 0x7164} /* East Asian ideograph */,
  {0, 0, 0x7169} /* East Asian ideograph */,
  {0, 0, 0x715C} /* East Asian ideograph */,
  {0, 0, 0x716C} /* East Asian ideograph */,
  {0, 0, 0x7166} /* East Asian ideograph */,
  {0, 0, 0x7167} /* East Asian ideograph */,
  {0, 0, 0x715E} /* East Asian ideograph */,
  {0, 0, 0x7165} /* East Asian ideograph */,
  {0, 0, 0x714C} /* East Asian ideograph */,
  {0, 0, 0x717D} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x7199} /* East Asian ideograph */,
  {0, 0, 0x718A} /* East Asian ideograph */,
  {0, 0, 0x7184} /* East Asian ideograph */,
  {0, 0, 0x719F} /* East Asian ideograph */,
  {0, 0, 0x71A8} /* East Asian ideograph */,
  {0, 0, 0x71AC} /* East Asian ideograph */,
  {0, 0, 0x71B1} /* East Asian ideograph */,
  {0, 0, 0x71D9} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz_iconv_trie marc8_31page28 = {
  0, marc8_31page28_dir
};
/* PAGE 27 */
struct yaz_iconv_trie_dir marc8_31page27_dir[256] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0x6E5B} /* East Asian ideograph */,
  {0, 0, 0x6E1A} /* East Asian ideograph */,
  {0, 0, 0x6E56} /* East Asian ideograph */,
  {0, 0, 0x6E2F} /* East Asian ideograph */,
  {0, 0, 0x6E6E} /* East Asian ideograph */,
  {0, 0, 0x6E58} /* East Asian ideograph */,
  {0, 0, 0x6E23} /* East Asian ideograph */,
  {0, 0, 0x6E24} /* East Asian ideograph */,
  {0, 0, 0x6E1B} /* East Asian ideograph */,
  {0, 0, 0x6E25} /* East Asian ideograph */,
  {0, 0, 0x6E4A} /* East Asian ideograph */,
  {0, 0, 0x6E3A} /* East Asian ideograph */,
  {0, 0, 0x6E6F} /* East Asian ideograph */,
  {0, 0, 0x6E2D} /* East Asian ideograph */,
  {0, 0, 0x6E34} /* East Asian ideograph */,
  {0, 0, 0x6E2C} /* East Asian ideograph */,
  {0, 0, 0x6E26} /* East Asian ideograph */,
  {0, 0, 0x6E4D} /* East Asian ideograph */,
  {0, 0, 0x6E3E} /* East Asian ideograph */,
  {0, 0, 0x6E43} /* East Asian ideograph */,
  {0, 0, 0x6E19} /* East Asian ideograph */,
  {0, 0, 0x6E1D} /* East Asian ideograph */,
  {0, 0, 0x6ED3} /* East Asian ideograph */,
  {0, 0, 0x6EB6} /* East Asian ideograph */,
  {0, 0, 0x6EC2} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x6EAF} /* East Asian ideograph */,
  {0, 0, 0x6EA2} /* East Asian ideograph */,
  {0, 0, 0x6E9D} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0x6EA5} /* East Asian ideograph */,
  {0, 0, 0x6E98} /* East Asian ideograph */,
  {0, 0, 0x6E90} /* East Asian ideograph */,
  {0, 0, 0x6EC5} /* East Asian ideograph */,
  {0, 0, 0x6EC7} /* East Asian ideograph */,
  {0, 0, 0x6EBC} /* East Asian ideograph */,
  {0, 0, 0x6EAB} /* East Asian ideograph */,
  {0, 0, 0x6ED1} /* East Asian ideograph */,
  {0, 0, 0x6ECB} /* East Asian ideograph */,
  {0, 0, 0x6EC4} /* East Asian ideograph */,
  {0, 0, 0x6ED4} /* East Asian ideograph */,
  {0, 0, 0x6EAA} /* East Asian ideograph */,
  {0, 0, 0x6E96} /* East Asian ideograph */,
  {0, 0, 0x6E9C} /* East Asian ideograph */,
  {0, 0, 0x6F33} /* East Asian ideograph */,
  {0, 0, 0x6EF4} /* East Asian ideograph */,
  {0, 0, 0x6EEC} /* East Asian ideograph */,
  {0, 0, 0x6EFE} /* East Asian ideograph */,
  {0, 0, 0x6F29} /* East Asian ideograph */,
  {0, 0, 0x6F14} /* East Asian ideograph */,
  {0, 0, 0x6F3E} /* East Asian ideograph */,
  {0, 0, 0x6F2C} /* East Asian ideograph */,
  {0, 0, 0x6F32} /* East Asian ideograph */,
  {0, 0, 0x6F0F} /* East Asian ideograph */,
  {0, 0, 0x6F22} /* East Asian ideograph (variant of EACC 4B4857) */,
  {0, 0, 0x6EFF} /* East Asian ideograph */,
  {0, 0, 0x6F23} /* East Asian ideograph */,
  {0, 0, 0x6F38} /* East Asian ideograph */,
  {0, 0, 0x6F15} /* East Asian ideograph */,
  {0, 0, 0x6F31} /* East Asian ideograph */,
  {0, 0, 0x6F02} /* East Asian ideograph */,
  {0, 0, 0x6F06} /* East Asian ideograph */,
  {0, 0, 0x6EEF} /* East Asian ideograph */,
  {0, 0, 0x6F2B} /* East Asian ideograph */,
  {0, 0, 0x6F2F} /* East Asian ideograph */,
  {0, 0, 0x6F20} /* East Asian ideograph */,
  {0, 0, 0x6F3F} /* East Asian ideograph */,
  {0, 0, 0x6EF2} /* East Asian ideograph */,
  {0, 0, 0x6F01} /* East Asian ideograph */,
  {0, 0, 0x6F11} /* East Asian ideograph */,
  {0, 0, 0x6ECC} /* East Asian ideograph */,
  {0, 0, 0x6F2A} /* East Asian ideograph */,
  {0, 0, 0x6F7C} /* East Asian ideograph */,
  {0, 0, 0x6F88} /* East Asian ideograph */,
  {0, 0, 0x6F84} /* East Asian ideograph */,
  {0, 0, 0x6F51} /* East Asian ideograph */,
  {0, 0, 0x6F64} /* East Asian ideograph */,
  {0, 0, 0x6F97} /* East Asian ideograph */,
  {0, 0, 0x6F54} /* East Asian ideograph */,
  {0, 0, 0x6F7A} /* East Asian ideograph */,
  {0, 0, 0x6F86} /* East Asian ideograph */,
  {0, 0, 0x6F8E} /* East Asian ideograph */,
  {0, 0, 0x6F6D} /* East Asian ideograph */,
  {0, 0, 0x6F5B} /* East Asian ideograph */,
  {0, 0, 0x6F6E} /* East Asian ideograph */,
  {0, 0, 0x6F78} /* East Asian ideograph */,
  {0, 0, 0x6F66} /* East Asian ideograph */,
  {0, 0, 0x6F70} /* East Asian ideograph */,
  {0, 0, 0x6F58} /* East Asian ideograph */,
  {0, 0, 0x6FC2} /* East Asian ideograph */,
  {0, 0, 0x6FB1} /* East Asian ideograph */,
  {0, 0, 0x6FC3} /* East Asian ideograph */,
  {0, 0, 0x6FA7} /* East Asian ideograph */,
  {0, 0, 0x6FA1} /* East Asian ideograph */,
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0}
};
struct yaz