/* AbiSource
 * 
 * Copyright (C) 2005 Daniel d'Andrada T. de Carvalho
 * <daniel.carvalho@indt.org.br>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
 * 02111-1307, USA.
 */

#ifndef _OD_LISTENERSTATE_H_
#define _OD_LISTENERSTATE_H_

// AbiWord includes
#include <ut_types.h>
#include <ut_string_class.h>

// Internal classes
class OD_ListenerStateAction;
class OD_ElementStack;


/**
 * Base class for all OD_*_ListenerState classes.
 */
class OD_ListenerState {

public:
    
    OD_ListenerState(const char* pStateName, OD_ElementStack& rElementStack)
    	: m_stateName(pStateName), m_rElementStack(rElementStack) {}
        
    virtual ~OD_ListenerState() {}
    
    virtual void startElement (const XML_Char* pName, const XML_Char** ppAtts,
                               OD_ListenerStateAction& rAction) = 0;
                               
    virtual void endElement (const XML_Char* pName,
                             OD_ListenerStateAction& rAction) = 0;
                             
    virtual void charData (const XML_Char* pBuffer, int length) = 0;
    
    const UT_String& getStateName() const {return m_stateName;}
    
protected:

    UT_String m_stateName;
    OD_ElementStack& m_rElementStack;
};

#endif //_OD_LISTENERSTATE_H_
