/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename functions or slots use
** Qt Designer which will update this file, preserving your code. Create an
** init() function in place of a constructor, and a destroy() function in
** place of a destructor.
*****************************************************************************/


void AboutDlg::init()
{
	lb_name->setText ( lb_name->text().arg(PROG_NAME).arg(PROG_VERSION) );

	te_license->setText ( loadText(g.pathBase + "/COPYING") );

	QString lang_name = qApp->translate( "@default", "language_name" );
	if ( lang_name == "language_name" ) // remove the translation tab, if no translation is used
		tw_tabs->removePage ( tw_tabs->page(3) );

	// fill in Authors tab...
	QString authors;
	authors += details(QString::fromUtf8("Justin Karneges"),
			   "justin@affinix.com", "", "",
			   tr("Founder and Original Author"));
	authors += details(QString::fromUtf8("Kevin Smith"),
			   "aboutpsi@kismith.co.uk", "", "",
			   tr("Project Lead/Maintainer"));
	authors += details(QString::fromUtf8("Michail Pishchagin"),
			   "mblsha@users.sourceforge.net", "", "",
			   tr("Lead Developer"));
	authors += details(QString::fromUtf8("Akito Nozaki"),
			   "anpluto@usa.net", "", "",
			   tr("Miscellaneous Developer"));
	te_authors->setText( authors );

	// fill in Thanks To tab...
	QString thanks;
	thanks += details(QString::fromUtf8("Jan Niehusmann"),
			  "jan@gondor.com", "", "",
			  tr("Build setup, miscellaneous assistance"));
	thanks += details(QString::fromUtf8("Everaldo Coelho"),
			  "", "", "http://www.everaldo.com",
			  tr("Many icons are from his Crystal icon theme"));
	thanks += details(QString::fromUtf8("Jason Kim"),
			  "", "", "",
			  tr("Graphics"));
	thanks += details(QString::fromUtf8("Hideaki Omuro"),
			  "", "", "",
			  tr("Graphics"));
	thanks += details(QString::fromUtf8("Bill Myers"),
			  "", "", "",
			  tr("Original Mac Port"));
	thanks += details(QString::fromUtf8("Eric Smith (Tarkvara Design, Inc.)"),
			 "eric@tarkvara.org", "", "",
			 tr("MacOS X Port"));
	thanks += details(QString::fromUtf8("Tony Collins"),
	 		 "", "", "",
	 		 tr("Original End User Documentation"));
	thanks += details(QString::fromUtf8("Hal Rottenberg"),
			  "", "", "",
			 tr("Webmaster, Marketing"));
	thanks += details(QString::fromUtf8("Mircea Bardac"),
			 "", "", "",
			 tr("Bug Tracker Management"));
	thanks += details(QString::fromUtf8("Remko Troncon"),
			 "", "", "",
			 tr("Patches, current Mac OS X builds"));
	thanks += details(QString::fromUtf8("Jacek Tomasiak"),
			 "", "", "",
			 tr("Patches"));
					  
	//thanks += tr("Thanks to many others.\n"
	//	     "The above list only reflects the contributors I managed to keep track of.\n"
	//	     "If you're not included but you think that you must be in the list, contact the developers.");
	te_thanks->setText( thanks );
}

QString AboutDlg::loadText( const QString & fileName )
{
	QString text;

	QFile f(fileName);
	if(f.open(IO_ReadOnly)) {
		QTextStream t(&f);
		while(!t.eof())
			text += t.readLine() + '\n';
		f.close();
	}

	return text;
}


QString AboutDlg::details( QString name, QString email, QString jabber, QString www, QString desc )
{
	QString ret;
	const QString nbsp = "&nbsp;&nbsp;";
	ret += name + "<br>\n";
	if ( !email.isEmpty() )
		ret += nbsp + "E-mail: " + "<a href=\"mailto:" + email + "\">" + email + "</a><br>\n";
	if ( !jabber.isEmpty() )
		ret += nbsp + "Jabber: " + "<a href=\"jabber:" + jabber + "\">" + jabber + "</a><br>\n";
	if ( !www.isEmpty() )
		ret += nbsp + "WWW: " + "<a href=\"" + www + "\">" + www + "</a><br>\n";
	if ( !desc.isEmpty() )
		ret += nbsp + desc + "<br>\n";
	ret += "<br>\n";

	return ret;
}
