#include "knap_hotlistpanel.h"

#include "knap_adduserdlg.h"
#include "support_funcs.h"

#include <qsplitter.h> 
#include <qlayout.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qpopupmenu.h>

#include <kconfig.h>
#include <kglobal.h>
#include <klocale.h>

#include "knap_listview.h"

#include "songinfo.h"

#include <iostream>

#include <math.h>

#include "mp3.xpm"

KNAP_HotlistPanel::KNAP_HotlistPanel(QWidget *parent,const char *name)
   : QFrame(parent,name)
{
  setFrameStyle( QFrame::Panel | QFrame::Sunken );  
  QGridLayout *grid=new QGridLayout(this,2,2,5,5);

  QSplitter *main = new QSplitter(QSplitter::Horizontal,this);
  grid->addMultiCellWidget(main,0,0,0,1);
 
  // the online/offline users list 
  QWidget * temp = new QWidget(main,"tmp"); 

  QGridLayout *gridtemp=new QGridLayout(temp,1,1,0,0);

  QSplitter *usersmain = new QSplitter(QSplitter::Vertical,temp);
  gridtemp->addWidget(usersmain,0,0);

  onlineview = new KNAP_ListView(usersmain,"online_list");
  onlineview->addColumn(i18n("Online"),100);
  onlineview->setColumnWidthMode(0,QListView::Manual); 
  
  connect(onlineview,SIGNAL( executed ( QListViewItem *) ),
	        this,SLOT(getInfo( QListViewItem *) )); 

  offlineview = new KNAP_ListView(usersmain,"offline_list");
  offlineview->addColumn(i18n("Offline"),100);
  offlineview->setColumnWidthMode(0,QListView::Manual); 

  songview = new KNAP_ListView(main,"hotlist_songs");

  songview->addColumn(i18n("filename"),180);
  songview->setColumnWidthMode(0,QListView::Manual); 
  songview->addColumn(i18n("size"),80);
  songview->setColumnWidthMode(1,QListView::Manual); 
  songview->addColumn(i18n("bitrate"),80);
  songview->setColumnWidthMode(2,QListView::Manual); 
  songview->addColumn(i18n("frequency"),80);
  songview->setColumnWidthMode(3,QListView::Manual); 
  songview->addColumn(i18n("time"),80);
  songview->setColumnWidthMode(4,QListView::Manual); 
  songview->loadWidths();

  main->setResizeMode(songview,QSplitter::Stretch);
  main->setResizeMode(temp,QSplitter::KeepSize);
 
  stats = new QLabel(this,"stats");
  grid->addWidget(stats,1,0);
  stats->setFrameStyle( QFrame::Panel | QFrame::Sunken );  

  add = new QPushButton(i18n("Add User"),this,"add");
  connect(add,SIGNAL( clicked() ),this,SLOT( addUser() ));
  grid->addWidget(add,1,1);
  grid->setColStretch(0,2);

  loadUsers();

  popupmenu=new QPopupMenu();

   connect(offlineview,
	 SIGNAL(rightButtonPressed( QListViewItem *, const QPoint &, int )),
	 this,SLOT(popupMenu( QListViewItem *, const QPoint &, int )));

   connect(onlineview,
	 SIGNAL(rightButtonPressed( QListViewItem *, const QPoint &, int )),
	 this,SLOT(popupMenu( QListViewItem *, const QPoint &, int )));
   connect(songview,
	 SIGNAL(rightButtonPressed( QListViewItem *, const QPoint &, int )),
	 this,SLOT(popupMenu( QListViewItem *, const QPoint &, int )));

   connect(songview,
	 SIGNAL(dblClicked( QListViewItem * )),
	 this,SLOT(dblclickDownload( QListViewItem * )));                    
}
KNAP_HotlistPanel::~KNAP_HotlistPanel()
{
   saveUsers();     // save the hotlist
   delete songview; // will force it to save its positions
}
void KNAP_HotlistPanel::popupMenu( QListViewItem *i, const QPoint &, int )
{
   if(i==0) return;
   
   QListView *view = i->listView();
   QListViewItem *selecteditem=view->currentItem();

   if(popupmenu && selecteditem) 
   {

      popupmenu->clear();

      if(view == songview)
      {
        popupmenu->insertItem(i18n("Download"),this,SLOT(popupDownload()));
      }
      else if(view == onlineview)
      {
        popupmenu->insertItem(i18n("Message user"),this,SLOT(popupMessage()));
        popupmenu->insertItem(i18n("Ping user"),this,SLOT(popupPing()));
        popupmenu->insertItem(i18n("Whois user"),this,SLOT(popupOnlineWhois()));
        popupmenu->insertSeparator();
	
#ifdef DEVEL_CODE	 
        popupmenu->insertItem(i18n("Ignore user"),this,SLOT(popupIgnore()));
        popupmenu->insertItem(i18n("Unignore user"),this,SLOT(popupUnignore()));
        popupmenu->insertSeparator();

	// if show admin menus was allowed
	popupmenu->insertItem(i18n("Kick user"),this,SLOT(popupDownload()));
	popupmenu->insertSeparator();
        popupmenu->insertItem(i18n("Op user"),this,SLOT(popupDownload()));
        popupmenu->insertItem(i18n("Deop user"),this,SLOT(popupDownload()));
        popupmenu->insertSeparator();

	// for chans include ban and muzzle to
#endif
	// remove
	popupmenu->insertItem(i18n("Remove user from hotlist"),this,SLOT(popupOnlineRemove()));
      }
      else // assume was offline view
      {
#ifdef DEVEL_CODE	 
        popupmenu->insertItem(i18n("Whois user"),this,SLOT(popupOfflineWhois()));
	popupmenu->insertSeparator();
#endif
	// remove
	popupmenu->insertItem(i18n("Remove user from hotlist"),this,
	      SLOT( popupOfflineRemove() ) );
	      //SLOT((popupOfflineRemove())));
      }
//     popupmenu->insertItem(i18n("Ping User"),this,SLOT(popupPing()));
      popupmenu->exec(QCursor::pos());
   }
   return;
}
void KNAP_HotlistPanel::dblclickDownload(QListViewItem *item)
{
  if(!item) return; 

  QString song = item->text(0);
	 
  emit sendcommand(QString("/download ") + user + " \"" + song + "\"");
}
void KNAP_HotlistPanel::popupDownload()
{
  QListViewItem *item=songview->firstChild();

  while(item) 
  {
      if(item->isSelected()) 
      {
	 dblclickDownload(item);
      }
      item = item->nextSibling();
   }
}

void KNAP_HotlistPanel::addUser()
{
   KNAP_AddUserDlg p(this);
   p.show();
   // prompt for and add a user
   QString user = p.getUser();
   cerr << "add user " << user << endl; 

   if(user) 
   {
      addUser(user);
      //emit user_added(user);
      emit sendcommand("/add " + user);
   }
}
void KNAP_HotlistPanel::addUser(const char *u,bool online)
{
   // add icon for speed too?
   QListViewItem *i=0;
   QString tmp = u;
   QString username; // = user;

   username = extractString(tmp);

   i = onlineview->find(username);
   if(i && online==false)
   {
      // was in online lise
      delete i;

      i = 0;
      // if this user is the one we are showing the list for 
      // clear the list
      if(user == username) clearSonglist();
   }
   i = offlineview->find(username);
   if(i && online==true)
   {
      delete i;
      i = 0;
   }

   if(i==0)
   {
      i = new QListViewItem(online==true ? onlineview : offlineview,
	    username);
      // if(online) add speed
   }
}
void KNAP_HotlistPanel::remUser(const char *username)
{
   cerr << "KNAP_HotlistPanel::remUser(): " << username << endl;
   QListViewItem *i=0;
   //bool found = false;

   i = onlineview->find(username);
   if(i)
   {
      // was in online lise
      delete i;

      // if this user is the one we are showing the list for 
      // clear the list
      if(user == username) clearSonglist();
   }
   i = offlineview->find(username);
   if(i)
   {
      delete i;
      //  found = true;
   }
}

QStringList KNAP_HotlistPanel::getUsers()
{
   QStringList list;

   QListViewItem *i;

   i=offlineview->firstChild();
   while(i)
   {
      if(i->text(0)) list += i->text(0);
      i=i->nextSibling();
   }  
   i=onlineview->firstChild();
   while(i)
   {
      if(i->text(0)) list += i->text(0);
      i=i->nextSibling();
   }  

   return list;
}
void KNAP_HotlistPanel::loadUsers()
{
   KConfig *config = KGlobal::config();
   QStringList list =  config->readListEntry(name());

   for ( QStringList::Iterator it = list.begin(); it != list.end(); ++it ) 
   {
      cerr << "HotlistPanel::loadUsers(): " << *it << endl;
      addUser(*it);
   }  
}
void KNAP_HotlistPanel::saveUsers()
{
   QStringList list = getUsers();

   for ( QStringList::Iterator it = list.begin(); it != list.end(); ++it ) {
      cerr << "HotlistPanel::saveUsers(): " << *it << endl;
   }

   KConfig *config = KGlobal::config();
   config->writeEntry(name(),list);
}
void KNAP_HotlistPanel::getInfo( QListViewItem *item)
{
   if(item) 
   {
      if(user!=item->text(0))
      {
	 clearSonglist();
	 user = item->text(0);
	 stats->setText(user + i18n(" - loading ... "));
	 emit sendcommand("/browse " + user);
      }
   }   
}
void KNAP_HotlistPanel::addSong(const SongInfo *song)
{
   cerr << "KNAP_HotlistPanel::addSong(): " << song->filename << endl;
   QListViewItem *i;

   if(user == song->user)
   { 
      QString s_time = QString().setNum(floor(song->seconds / 60));
      cerr << "KNAP_HotlistPanel::addSong(): time is " << song->seconds << endl;
      s_time += ":";
      int sec = song->seconds % 60;
      if (sec < 10) s_time += "0";
      s_time += QString().setNum(sec);  

      i = new QListViewItem(songview,song->filename,convertSize(song->size),
	    QString().setNum(song->bitrate),QString().setNum(song->freq),s_time);
      // set the pixmap just to add a bit of 'color'
      if(i) i->setPixmap(0,QPixmap((const char **)mp3_xpm));

      stats->setText(user + i18n(" - loading ... ") + QString().setNum(songview->childCount()) + i18n(" Songs"));
   }
}
void KNAP_HotlistPanel::endSonglist(const char *userdata)
{
   QString tmp = userdata;

   QString end_user = extractString(tmp);
   // what is left is the IP ?
   if(user == end_user) 
      stats->setText(user + " - " + QString().setNum(songview->childCount()) + i18n(" Songs"));

}
void KNAP_HotlistPanel::clearSonglist()
{
   songview->clear();
   stats->setText("");
   user = "";
}

void KNAP_HotlistPanel::setOffline()
{
   clearSonglist();

   // clear the online users
   QListViewItem *i;
   QStringList list;

   i=onlineview->firstChild();
   while(i)
   {
      if(i->text(0)) list += i->text(0);
      i=i->nextSibling();
   }  

   for ( QStringList::Iterator it = list.begin(); it != list.end(); ++it ) 
   {
      addUser(*it);
   }


   onlineview->clear(); // just to make sure

}

void KNAP_HotlistPanel::runCommand(QListView *view,const QString &comm)
{
   QListViewItem *item=view->firstChild();

   while(item) 
   {
      if(item->isSelected()) 
      {
	 QString u = item->text(0);

	 emit sendcommand(comm + " " + u);
      }
      item = item->nextSibling();
   }
}
void KNAP_HotlistPanel::popupMessage()
{
   runCommand(onlineview,"/talk");
}
void KNAP_HotlistPanel::popupPing()
{
   runCommand(onlineview,"/ping");
}
void KNAP_HotlistPanel::popupOnlineWhois()
{
   runCommand(onlineview,"/whois");
}
void KNAP_HotlistPanel::popupIgnore()
{
   runCommand(onlineview,"/ignore");
}
void KNAP_HotlistPanel::popupUnignore()
{
   runCommand(onlineview,"/unignore");
}


void KNAP_HotlistPanel::popupOfflineWhois()
{
   runCommand(offlineview,"/whois");
}

/*
 * have to do remove command on its own - since it has to do more than just send
 * select users to sendcommand();
 */
void KNAP_HotlistPanel::popupOfflineRemove()
{
   QListViewItem *item=offlineview->firstChild();

   while(item) 
   {
      if(item->isSelected()) 
      {
	 QString u = item->text(0);

	 // selected so remove it
	 remUser(u);
	 emit sendcommand("/del " + u);
      }
      item = item->nextSibling();
   } 
}
void KNAP_HotlistPanel::popupOnlineRemove()
{
   QListViewItem *item=onlineview->firstChild();

   while(item) 
   {
      if(item->isSelected()) 
      {
	 QString u = item->text(0);
	 // selected so remove it
	 remUser(u);

	 cerr << " KNAP_HotlistPanel::popupOnlineRemove(): " << u << endl;
	 emit sendcommand("/del " + u);
      }
      item = item->nextSibling();
   } 
}
