/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeCall;
import org.mozilla.javascript.ScriptRuntime;

public class NativeFunction
extends BaseFunction {
    private static final int OFFSET = 4;
    private static final int SETBACK = 2;
    private static final boolean printSource = false;
    protected String[] argNames;
    protected short argCount;
    protected short version;
    protected String source;
    public NativeFunction[] nestedFunctions;
    public int debug_level = -1;
    public String debug_srcName;

    private boolean nextIs(int n, int n2) {
        if (n + 1 < this.source.length()) {
            return this.source.charAt(n + 1) == n2;
        }
        return false;
    }

    public String decompile(Context context, int n, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        this.decompile(n, true, bl, stringBuffer);
        return stringBuffer.toString();
    }

    /*
     * Unable to fully structure code
     */
    private void decompile(int var1_1, boolean var2_2, boolean var3_3, StringBuffer var4_4) {
        block137: {
            if (this.source == null) {
                if (!var3_3) {
                    var4_4.append("function ");
                    var4_4.append(this.getFunctionName());
                    var4_4.append("() {\n\t");
                }
                var4_4.append("[native code]\n");
                if (!var3_3) {
                    var4_4.append("}\n");
                }
                return;
            }
            var5_5 = 0;
            if (this.source.length() <= 0) break block137;
            if (var2_2) {
                if (!var3_3) {
                    var4_4.append('\n');
                }
                var6_6 = 0;
                while (var6_6 < var1_1) {
                    var4_4.append(' ');
                    ++var6_6;
                }
            }
            if (this.source.charAt(0) != 'n' || this.source.length() <= 1 || this.source.charAt(1) != ',' && this.source.charAt(1) != '^') break block137;
            if (var3_3) ** GOTO lbl37
            var4_4.append("function ");
            if (this.nextIs(var5_5, 94) && this.version != 120 && this.functionName != null && this.functionName.equals("anonymous")) {
                var4_4.append("anonymous");
            }
            ++var5_5;
            break block137;
lbl-1000:
            // 1 sources

            {
                ++var5_5;
lbl37:
                // 2 sources

                ** while (var5_5 < this.source.length() && (this.source.charAt((int)var5_5) != '\u0001' || var5_5 > 0 && this.source.charAt((int)(var5_5 - 1)) == ','))
            }
lbl38:
            // 1 sources

            ++var5_5;
        }
        while (var5_5 < this.source.length()) {
            switch (this.source.charAt(var5_5)) {
                case ',': 
                case '8': {
                    var6_6 = ++var5_5 + this.source.charAt(var5_5);
                    var4_4.append(this.source.substring(var5_5 + 1, var6_6 + 1));
                    var5_5 = var6_6;
                    break;
                }
                case '-': {
                    var7_7 = 0L;
                    switch (this.source.charAt(++var5_5)) {
                        case 'S': {
                            var4_4.append((int)this.source.charAt(++var5_5));
                            break;
                        }
                        case 'J': {
                            v0 = ++var5_5;
                            var7_7 |= (long)this.source.charAt(v0) << 48;
                            v1 = ++var5_5;
                            var7_7 |= (long)this.source.charAt(v1) << 32;
                            v2 = ++var5_5;
                            var7_7 |= (long)this.source.charAt(v2) << 16;
                            var4_4.append(var7_7 |= (long)this.source.charAt(++var5_5));
                            break;
                        }
                        case 'D': {
                            v3 = ++var5_5;
                            var7_7 |= (long)this.source.charAt(v3) << 48;
                            v4 = ++var5_5;
                            var7_7 |= (long)this.source.charAt(v4) << 32;
                            v5 = ++var5_5;
                            var7_7 |= (long)this.source.charAt(v5) << 16;
                            var9_8 = Double.longBitsToDouble(var7_7 |= (long)this.source.charAt(++var5_5));
                            var4_4.append(ScriptRuntime.numberToString(var9_8, 10));
                        }
                    }
                    break;
                }
                case '.': {
                    var6_6 = ++var5_5 + this.source.charAt(var5_5);
                    var4_4.append('\"');
                    var4_4.append(ScriptRuntime.escapeString(this.source.substring(var5_5 + 1, var6_6 + 1)));
                    var4_4.append('\"');
                    var5_5 = var6_6;
                    break;
                }
                case 'm': {
                    switch (this.source.charAt(++var5_5)) {
                        case '4': {
                            var4_4.append("true");
                            break;
                        }
                        case '3': {
                            var4_4.append("false");
                            break;
                        }
                        case '1': {
                            var4_4.append("null");
                            break;
                        }
                        case '2': {
                            var4_4.append("this");
                            break;
                        }
                        case ' ': {
                            var4_4.append("typeof");
                            break;
                        }
                        case '\u0084': {
                            var4_4.append("void");
                            break;
                        }
                        case 'J': {
                            var4_4.append("undefined");
                        }
                    }
                    break;
                }
                case 'n': {
                    var11_9 = this.source.charAt(++var5_5);
                    if (this.nestedFunctions == null || var11_9 > this.nestedFunctions.length) {
                        var12_11 = this.functionName != null && this.functionName.length() > 0 ? Context.getMessage2("msg.no.function.ref.found.in", new Integer(this.source.charAt(var5_5)), this.functionName) : Context.getMessage1("msg.no.function.ref.found", new Integer(this.source.charAt(var5_5)));
                        throw Context.reportRuntimeError(var12_11);
                    }
                    this.nestedFunctions[var11_9].decompile(var1_1, false, false, var4_4);
                    break;
                }
                case '`': {
                    var4_4.append(", ");
                    break;
                }
                case '\\': {
                    if (this.nextIs(var5_5, 1)) {
                        var1_1 += 4;
                    }
                    var4_4.append('{');
                    break;
                }
                case ']': {
                    if (var3_3 && var2_2 && var5_5 + 1 == this.source.length()) break;
                    if (this.nextIs(var5_5, 1)) {
                        var1_1 -= 4;
                    }
                    if (this.nextIs(var5_5, 118) || this.nextIs(var5_5, 114)) {
                        var1_1 -= 4;
                        var4_4.append("} ");
                        break;
                    }
                    var4_4.append('}');
                    break;
                }
                case '^': {
                    var4_4.append('(');
                    break;
                }
                case '_': {
                    if (this.nextIs(var5_5, 92)) {
                        var4_4.append(") ");
                        break;
                    }
                    var4_4.append(')');
                    break;
                }
                case 'Z': {
                    var4_4.append('[');
                    break;
                }
                case '[': {
                    var4_4.append(']');
                    break;
                }
                case '\u0001': {
                    var4_4.append('\n');
                    if (var5_5 + 1 >= this.source.length()) break;
                    var11_9 = 0;
                    if (this.nextIs(var5_5, 116) || this.nextIs(var5_5, 117)) {
                        var11_9 = 2;
                    } else if (this.nextIs(var5_5, 93)) {
                        var11_9 = 4;
                    } else if (this.nextIs(var5_5, 44) && this.source.charAt(var5_5 + (var12_10 = this.source.charAt(var5_5 + 2)) + 3) == 'c') {
                        var11_9 = 4;
                    }
                    while (var11_9 < var1_1) {
                        var4_4.append(' ');
                        ++var11_9;
                    }
                    break;
                }
                case 'l': {
                    var4_4.append('.');
                    break;
                }
                case '\u001e': {
                    var4_4.append("new ");
                    break;
                }
                case '\u001f': {
                    var4_4.append("delete ");
                    break;
                }
                case 'q': {
                    var4_4.append("if ");
                    break;
                }
                case 'r': {
                    var4_4.append("else ");
                    break;
                }
                case 'x': {
                    var4_4.append("for ");
                    break;
                }
                case '?': {
                    var4_4.append(" in ");
                    break;
                }
                case '|': {
                    var4_4.append("with ");
                    break;
                }
                case 'v': {
                    var4_4.append("while ");
                    break;
                }
                case 'w': {
                    var4_4.append("do ");
                    break;
                }
                case 'K': {
                    var4_4.append("try ");
                    break;
                }
                case '}': {
                    var4_4.append("catch ");
                    break;
                }
                case '~': {
                    var4_4.append("finally ");
                    break;
                }
                case '>': {
                    var4_4.append("throw ");
                    break;
                }
                case 's': {
                    var4_4.append("switch ");
                    break;
                }
                case 'y': {
                    if (this.nextIs(var5_5, 44)) {
                        var4_4.append("break ");
                        break;
                    }
                    var4_4.append("break");
                    break;
                }
                case 'z': {
                    if (this.nextIs(var5_5, 44)) {
                        var4_4.append("continue ");
                        break;
                    }
                    var4_4.append("continue");
                    break;
                }
                case 't': {
                    var4_4.append("case ");
                    break;
                }
                case 'u': {
                    var4_4.append("default");
                    break;
                }
                case '\u0005': {
                    if (this.nextIs(var5_5, 89)) {
                        var4_4.append("return");
                        break;
                    }
                    var4_4.append("return ");
                    break;
                }
                case '{': {
                    var4_4.append("var ");
                    break;
                }
                case 'Y': {
                    if (this.nextIs(var5_5, 1)) {
                        var4_4.append(';');
                        break;
                    }
                    var4_4.append("; ");
                    break;
                }
                case 'a': {
                    switch (this.source.charAt(++var5_5)) {
                        case '\u0080': {
                            var4_4.append(" = ");
                            break;
                        }
                        case '\u0017': {
                            var4_4.append(" += ");
                            break;
                        }
                        case '\u0018': {
                            var4_4.append(" -= ");
                            break;
                        }
                        case '\u0019': {
                            var4_4.append(" *= ");
                            break;
                        }
                        case '\u001a': {
                            var4_4.append(" /= ");
                            break;
                        }
                        case '\u001b': {
                            var4_4.append(" %= ");
                            break;
                        }
                        case '\u000b': {
                            var4_4.append(" |= ");
                            break;
                        }
                        case '\f': {
                            var4_4.append(" ^= ");
                            break;
                        }
                        case '\r': {
                            var4_4.append(" &= ");
                            break;
                        }
                        case '\u0014': {
                            var4_4.append(" <<= ");
                            break;
                        }
                        case '\u0015': {
                            var4_4.append(" >>= ");
                            break;
                        }
                        case '\u0016': {
                            var4_4.append(" >>>= ");
                        }
                    }
                    break;
                }
                case 'b': {
                    var4_4.append(" ? ");
                    break;
                }
                case '\u0087': {
                    var4_4.append(':');
                    break;
                }
                case 'c': {
                    if (this.nextIs(var5_5, 1)) {
                        var4_4.append(':');
                        break;
                    }
                    var4_4.append(" : ");
                    break;
                }
                case 'd': {
                    var4_4.append(" || ");
                    break;
                }
                case 'e': {
                    var4_4.append(" && ");
                    break;
                }
                case '\u000b': {
                    var4_4.append(" | ");
                    break;
                }
                case '\f': {
                    var4_4.append(" ^ ");
                    break;
                }
                case '\r': {
                    var4_4.append(" & ");
                    break;
                }
                case 'f': {
                    switch (this.source.charAt(++var5_5)) {
                        case '5': {
                            var4_4.append(this.version == 120 ? " == " : " === ");
                            break;
                        }
                        case '6': {
                            var4_4.append(this.version == 120 ? " != " : " !== ");
                            break;
                        }
                        case '\u000e': {
                            var4_4.append(" == ");
                            break;
                        }
                        case '\u000f': {
                            var4_4.append(" != ");
                        }
                    }
                    break;
                }
                case 'g': {
                    switch (this.source.charAt(++var5_5)) {
                        case '\u0011': {
                            var4_4.append(" <= ");
                            break;
                        }
                        case '\u0010': {
                            var4_4.append(" < ");
                            break;
                        }
                        case '\u0013': {
                            var4_4.append(" >= ");
                            break;
                        }
                        case '\u0012': {
                            var4_4.append(" > ");
                            break;
                        }
                        case '@': {
                            var4_4.append(" instanceof ");
                        }
                    }
                    break;
                }
                case 'h': {
                    switch (this.source.charAt(++var5_5)) {
                        case '\u0014': {
                            var4_4.append(" << ");
                            break;
                        }
                        case '\u0015': {
                            var4_4.append(" >> ");
                            break;
                        }
                        case '\u0016': {
                            var4_4.append(" >>> ");
                        }
                    }
                    break;
                }
                case 'i': {
                    switch (this.source.charAt(++var5_5)) {
                        case ' ': {
                            var4_4.append("typeof ");
                            break;
                        }
                        case '\u0084': {
                            var4_4.append("void ");
                            break;
                        }
                        case '\u0081': {
                            var4_4.append('!');
                            break;
                        }
                        case '\u001c': {
                            var4_4.append('~');
                            break;
                        }
                        case '\u0017': {
                            var4_4.append('+');
                            break;
                        }
                        case '\u0018': {
                            var4_4.append('-');
                        }
                    }
                    break;
                }
                case 'j': {
                    var4_4.append("++");
                    break;
                }
                case 'k': {
                    var4_4.append("--");
                    break;
                }
                case '\u0017': {
                    var4_4.append(" + ");
                    break;
                }
                case '\u0018': {
                    var4_4.append(" - ");
                    break;
                }
                case '\u0019': {
                    var4_4.append(" * ");
                    break;
                }
                case '\u001a': {
                    var4_4.append(" / ");
                    break;
                }
                case '\u001b': {
                    var4_4.append(" % ");
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown token " + this.source.charAt(var5_5));
                }
            }
            ++var5_5;
        }
        if (var2_2 && !var3_3) {
            var4_4.append('\n');
        }
    }

    public int getLength() {
        Context context = Context.getContext();
        if (context != null && context.getLanguageVersion() != 120) {
            return this.argCount;
        }
        NativeCall nativeCall = this.getActivation(context);
        if (nativeCall == null) {
            return this.argCount;
        }
        return nativeCall.getOriginalArguments().length;
    }

    public int getArity() {
        return this.argCount;
    }

    public String jsGet_name() {
        return this.getFunctionName();
    }
}

