%  Copyright (C) 2002-2003 David Roundy
%
%  This program is free software; you can redistribute it and/or modify
%  it under the terms of the GNU General Public License as published by
%  the Free Software Foundation; either version 2, or (at your option)
%  any later version.
%
%  This program is distributed in the hope that it will be useful,
%  but WITHOUT ANY WARRANTY; without even the implied warranty of
%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%  GNU General Public License for more details.
%
%  You should have received a copy of the GNU General Public License
%  along with this program; if not, write to the Free Software Foundation,
%  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
\section{darcs remove}
\begin{code}
module Remove ( remove ) where

import FastPackedString ( linesPS )

import DarcsCommands
import DarcsArguments
import Directory
import IO
import System
import Repository
import Patch
import SlurpDirectory
import RegexString
\end{code}

\begin{code}
remove_description =
 "Remove a one or more files or directories from the repository."
\end{code}

\options{remove}

\haskell{rmh}

\begin{code}
rmh = "Remove should be called when you want to remove a file from your project,
but don't actually want to delete the file.  Otherwise just delete the
file or directory, and darcs will notice that it has been removed."
remove_help = rmh++"\n"
\end{code}

\begin{code}
remove = DarcsCommand {command_name = "remove",
                       command_help = remove_help,
                       command_description = remove_description,
                       command_extra_args = -1,
                       command_command = remove_cmd,
                       command_prereq = am_in_repo,
                       command_get_arg_possibilities = list_registered_files,
                       command_argdefaults = nodefaults,
                       command_darcsoptions = [verbose]}
\end{code}

\begin{code}
remove_cmd _ args = do
    ps <- sequence $ map removep args
    pend <- read_pending
    case pend of
        Nothing -> write_pending $ join_patches ps
        Just op -> write_pending $ join_patches $
                   flatten $ join_patches [op,join_patches ps]

removep :: String -> IO Patch
removep f = do
  isdir <- doesDirectoryExist f
  if isdir
     then return $ rmdir f
     else do isfile <- doesFileExist f
             if isfile
                then do ls <- readFileLinesPS $ "_darcs/current/"++f
                        if ls /= []
                          then return $ join_patches [hunk f 1 ls [],
                                                      rmfile f]
                          else return $ rmfile f
                else do putStr $ "File "++ f ++" does not exist!\n"
                        return $ join_patches []
\end{code}
