#include "forms.h"
#include <stdio.h>
#include <ctype.h>
#include <time.h>
#include <sys/file.h>
#include <sys/fcntl.h>
#include <stdlib.h>
#include "xmysqladmin.h"
#include "xmysqladmin2.h"
#include "mysql.h"

#if MYSQL_VERSION_ID >= 32100
  extern int mysql_refresh(MYSQL *mysql,uint options);
#endif

extern struct setup Setup;
extern struct statxmysqladmin Stat;
FD_reload *f_reload;

void reload(void);
void reload()
{
  {
    MYSQL connection;
    if(g_mysql_connect(&connection, Setup.host, Setup.user, Setup.password))
    {
      char str[41];
      long clock;								       /* nombre de secondes depuis ... */
      struct tm *t;							       /* struct tm statique */
      clock = time( (long *) 0 );					       /* determine l'heure courante */
      t = localtime( &clock );						       /* place heure ds struct tm */
#if MYSQL_VERSION_ID < 32100
      sprintf(str, "Reload on %2d.%02d.%02d at %02d:%02d",
	      t->tm_year,t->tm_mon + 1,t->tm_mday,
	      t->tm_hour,t->tm_min);
      mysql_reload(&connection);
#endif
#if MYSQL_VERSION_ID >= 32100
      sprintf(str, "Reload on %2d.%02d.%02d at %02d:%02d",
	      t->tm_year,t->tm_mon + 1,t->tm_mday,
	      t->tm_hour,t->tm_min);
      mysql_refresh(&connection, 1);
#endif

      mysql_close(&connection);
      fl_freeze_form(f_reload->reload);	    
      fl_addto_browser(f_reload->browser, str);

      if(fl_get_browser_maxline(f_reload->browser) > Setup.reloadMaxLines)
      {
	fl_delete_browser_line(f_reload->browser, 1);
      }
      fl_unfreeze_form(f_reload->reload);
    }
  }
}
void refresh(void);
void refresh()
{
  {
    MYSQL connection;
    if(g_mysql_connect(&connection, Setup.host, Setup.user, Setup.password))
    {
      char str[41];
      long clock;								       /* nombre de secondes depuis ... */
      struct tm *t;							       /* struct tm statique */
      clock = time( (long *) 0 );					       /* determine l'heure courante */
      t = localtime( &clock );						       /* place heure ds struct tm */
#if MYSQL_VERSION_ID < 32100
      sprintf(str, "Reload on %2d.%02d.%02d at %02d:%02d",
	      t->tm_year,t->tm_mon + 1,t->tm_mday,
	      t->tm_hour,t->tm_min);
      mysql_reload(&connection);
#endif
#if MYSQL_VERSION_ID >= 32100
      sprintf(str, "Refresh on %2d.%02d.%02d at %02d:%02d",
	      t->tm_year,t->tm_mon + 1,t->tm_mday,
	      t->tm_hour,t->tm_min);
      mysql_refresh(&connection, 0);
#endif

      mysql_close(&connection);
      fl_freeze_form(f_reload->reload);	    
      fl_addto_browser(f_reload->browser, str);

      if(fl_get_browser_maxline(f_reload->browser) > Setup.reloadMaxLines)
      {
	fl_delete_browser_line(f_reload->browser, 1);
      }
      fl_unfreeze_form(f_reload->reload);
    }
  }
}

void main_reload(FL_OBJECT *obj, long data)
{
  if(Stat.flagReload) return;
  Stat.flagReload=1;
  
  f_reload = create_form_reload();

  fl_show_form(f_reload->reload, FL_PLACE_FREE, FL_TRANSIENT, "xMySQLadmin reload");
  fl_set_timer(f_reload->timer, Setup.reloadRefreshTime);

}

void reload_close(FL_OBJECT *obj, long data)
{
  fl_hide_form(f_reload->reload);
  fl_free_form(f_reload->reload);
  free(f_reload);
  Stat.flagReload=0;
}
void reload_now(FL_OBJECT *obj, long data)
{
  reload();
}
void refresh_now(FL_OBJECT *obj, long data)
{
  refresh();
}
void reload_timer(FL_OBJECT *obj, long data)
{
  reload();
  fl_set_timer(f_reload->timer, Setup.reloadRefreshTime);
}

