#*************************************************************************
#
#   OpenOffice.org - a multi-platform office productivity suite
#
#   $RCSfile: makefile.mk,v $
#
#   $Revision: 1.24 $
#
#   last change: $Author: hr $ $Date: 2007/08/03 13:56:02 $
#
#   The Contents of this file are made available subject to
#   the terms of GNU Lesser General Public License Version 2.1.
#
#
#     GNU Lesser General Public License Version 2.1
#     =============================================
#     Copyright 2005 by Sun Microsystems, Inc.
#     901 San Antonio Road, Palo Alto, CA 94303, USA
#
#     This library is free software; you can redistribute it and/or
#     modify it under the terms of the GNU Lesser General Public
#     License version 2.1, as published by the Free Software Foundation.
#
#     This library is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#     Lesser General Public License for more details.
#
#     You should have received a copy of the GNU Lesser General Public
#     License along with this library; if not, write to the Free Software
#     Foundation, Inc., 59 Temple Place, Suite 330, Boston,
#     MA  02111-1307  USA
#
#*************************************************************************

PRJ=.

PRJNAME=so_freetype
TARGET=so_freetype

# --- Settings -----------------------------------------------------

.INCLUDE :	settings.mk

# We use the freetype provided with XDarwin/XFree86 for
# the X11 port because there are some header conflicts
# and linktime conflicts as well.  It is simply less of
# a headache to use the one provided.
.IF "$(SYSTEM_FREETYPE)" == "YES"
dummy:
	@echo "An already available installation of freetype should exist on your system."
	@echo "Therefore the version provided here does not need to be built in addition."
.ELSE
# --- Files --------------------------------------------------------

TARFILE_NAME=freetype-2.2.1

PATCH_FILE_NAME=freetype-2.2.1.patch

CONFIGURE_DIR=
.IF "$(GUI)"=="UNX" && "$(GUIBASE)"!="aqua"
#relative to CONFIGURE_DIR
.IF "$(OS)"=="MACOSX"
CONFIGURE_ACTION=./configure
CONFIGURE_FLAGS=--with-pic --without-zlib
.ELSE
CONFIGURE_ACTION=$(GNUMAKE)
CONFIGURE_FLAGS=setup CFG="--with-pic --without-zlib"
.ENDIF

BUILD_DIR=$(CONFIGURE_DIR)
BUILD_ACTION=$(GNUMAKE) -j$(EXTMAXPROCESS)

OUT2LIB= \
	objs$/.libs$/libfreetype.a
.IF "$(OS)"=="MACOSX"
OUT2LIB+=objs$/.libs$/libfreetype.*.dylib
.ELIF "$(OS)"=="FREEBSD" || "$(OS)"=="NETBSD"
OUT2LIB+=objs$/.libs$/libfreetype.so.9*
.ELSE
OUT2LIB+=objs$/.libs$/libfreetype.so.6*
.ENDIF          # "$(OS)"=="MACOSX" || "$(OS)"=="FREEBSD" || "$(OS)"=="NETBSD"


OUT2INC= \
	include$/freetype$/f*.h \
	include$/freetype$/tt*.h \
	include$/ft2build.h

OUTDIR2INC= \
	include$/freetype$/internal \
	include$/freetype$/config

# --- Targets ------------------------------------------------------

.INCLUDE : set_ext.mk
.INCLUDE :	target.mk
.INCLUDE :	tg_ext.mk

.ELSE			# "$(GUI)"=="UNX"
.INCLUDE :	target.mk
.ENDIF			# "$(GUI)"=="UNX"

.ENDIF	# "$(OS)" == "MACOSX"
