/* 
   SQL Auditing Tools
   Copyright (C) Patrik Karlsson 2001
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "tds.h"
#include "sqllib.h"
#include "util.h"
#include "constants.h"
#include "sqlanlz.h"
#include "html.h"
#include <getopt.h>

/*
  Set a few default values
*/
TDSLOGIN *set_target_defaults(TDSLOGIN *login) {

  login = tds_alloc_login();
  tds_set_passwd(login, "");
  tds_set_user(login, "sa");
  tds_set_app(login, "Microsoft Access");
  tds_set_host(login, "xxx");
  tds_set_library(login,"TDS-Library");
  tds_set_charset(login,"iso_1");
  tds_set_language(login, "us_english");
  tds_set_server(login, "");
  tds_set_packet(login, 512);
  tds_set_port(login, 1433);

  return login;

}

void doHaxxor(TDSLOGIN *pLogin) {

  DATABASE *pDB = NULL, *pFirstDB = NULL;
  EXTENDEDSP *pExtendedSP = NULL;
  SQLTABLE *pTable = NULL;
  TDSSOCKET *pTds = NULL;
  char tmp[256];
  time_t t;

  /* connect to the SQL server */
  if( (pTds = tds_connect(pLogin)) !=NULL ) {

    time(&t);

    htmlHead(stdout, "SQLServer PenTest");
    memset(tmp, 0, sizeof(tmp));
    sprintf(tmp, "Analysis performed as user \'%s\' at %s", 
	    pLogin->user_name, ctime(&t)); 
    htmlHeader(stdout, tmp);

    pDB = getDatabases(pTds);
    pFirstDB = pDB;

    while ( pDB ) {
      pTable = getTablesForDB(pTds, pDB->dbname);
      /* pDB->pLogin = getLoginsForDB(pTds, pDB); */
 
      memset(tmp, 0, sizeof(tmp));
      sprintf(tmp, "Tables in database %s", pDB->dbname);
      htmlHeader(stdout, tmp);

      fprintf(stdout, "db=%s, path=%s\n", pDB->dbname, pDB->dbpath);
      /* outputUsersForDB(stdout, pDB->pLogin); */
      outputTablesForDB(stdout, pTable, MODE_HTML_SHOW_COLNAMES);

      freeTables(pTable);

      pDB = pDB->next;
    }
    
    
    htmlHeader(stdout, "Logins");
    sqlGetResult(stdout, pTds, "select loginname from syslogins", 3);

    pExtendedSP = getExtendedStoredProcedures(pTds);
    htmlHeader(stdout, "Found Extended Stored Procedures");
    outputExtendedStoredProcedures(stdout, pExtendedSP, \
				   MODE_HTML_SHOW_COLNAMES);

    htmlHeader(stdout, "xp_msver");
    sqlGetResult(stdout, pTds, "xp_msver", 3);

    htmlHeader(stdout, "xp_enumdsn");
    sqlGetResult(stdout, pTds, "xp_enumdsn", 3);

    htmlHeader(stdout, "xp_loginconfig");
    sqlGetResult(stdout, pTds, "xp_loginconfig", 3);

    htmlHeader(stdout, "xp_fixeddrives");
    sqlGetResult(stdout, pTds, "xp_fixeddrives", 3);

    htmlHeader(stdout, "xp_availablemedia");
    sqlGetResult(stdout, pTds, "xp_availablemedia", 3);

    htmlHeader(stdout, "xp_readerrorlog");
    sqlGetResult(stdout, pTds, "xp_readerrorlog", 3);

    htmlHeader(stdout, "xp_enum_activesriptengines");
    sqlGetResult(stdout, pTds, "xp_enum_activescriptengines", 3);

    htmlFoot(stdout);

    freeExtendedStoredProcedures(pExtendedSP);

  }
  else
    fprintf(stderr, "ERROR: Login failed\n");
  
  if ( pFirstDB != NULL )
    freeItem(pFirstDB);

  if ( pLogin != NULL )
    free(pLogin);

}

void usage(char **argv) {
  
  printf("\n\tSQLANLZ %s by patrik.karlsson@ixsecurity.com\n", SQLTOOLS_VERSION);
  printf("\t--------------------------------------------\n");
  printf("\t%s\n\n", argv[0]);
  printf("\t\t-i*\t<ip|ipfile>\n");
  printf("\t\t-u\tusername (default sa)\n");
  printf("\t\t-p\tpassword\n");
  printf("\n\n");

}


/* Initialize all arguments */
void initArguments(ARGS *pArgs) {

  memset(pArgs->sIP, 0, sizeof(pArgs->sIP));
  pArgs->pIPFile = NULL;
  pArgs->pRepFile = NULL;
  pArgs->nLogLevel = 0;

}

int main(int argc, char **argv) {

  TDSLOGIN *pLogin;
  ARGS args;
  int c=0;
  char user[128];
  char pass[128];

  initArguments(&args);
  memset(pass, 0, sizeof(pass));
  memset(user, 0, sizeof(user));

  while (1) {

    c = getopt (argc, argv, "i:vu:p:h");

    if ( c == -1 ) 
      break;

    switch (c) {

    case 'v':
      args.nLogLevel = 1;
      break;
      
    case 'u':
      strncpy(user, optarg, sizeof(user));
      break;

    case 'p':
      strncpy(pass, optarg, sizeof(pass));
      break;

    case 'h':
      usage(argv);
      exit(1);
      break;

    case 'i':

      if ( ( args.pIPFile = fopen(optarg, "r") ) == NULL ) {
	
	if ( strlen(optarg) <= sizeof(args.sIP) ) {
	  strncpy(args.sIP, optarg, strlen(optarg));
	}
	else {
	  usage(argv);
	  exit(1);
	}

      }

      break;

    default:
      usage(argv);
      break;

    } /* end switch */

  } /* end while */

  /* do we have a target Roger ? */
  if ( strlen(args.sIP) == 0 && args.pIPFile == NULL ) {
    usage(argv);
    exit(1);
  }

  /* do we have a user and pass ? */
  if ( strlen( user ) == 0 )
    strcpy(user, "sa");
  
  pLogin = set_target_defaults(pLogin);
  tds_set_server(pLogin, args.sIP);
  tds_set_passwd(pLogin, pass);
  tds_set_user(pLogin, user);

  doHaxxor(pLogin);
  
  return TRUE;

}

