Summary: Samba SMB client and server
Name: samba
Version: 2.2.0
Release: 20010417
Copyright: GNU GPL version 2
Group: Networking
Source: ftp://samba.org/pub/samba/samba-%{version}.tar.gz
Packager: John H Terpstra [Samba-Team] <jht@samba.org>
Requires: pam >= 0.72 kernel >= 2.2.1 glibc >= 2.1.2
Prereq: chkconfig fileutils
BuildRoot: /var/tmp/samba
Prefix: /usr

%description
Samba provides an SMB server which can be used to provide
network services to SMB (sometimes called "Lan Manager")
clients, including various versions of MS Windows, OS/2,
and other Linux machines. Samba also provides some SMB
clients, which complement the built-in SMB filesystem
in Linux. Samba uses NetBIOS over TCP/IP (NetBT) protocols
and does NOT need NetBEUI (Microsoft Raw NetBIOS frame)
protocol.

Samba-2.2 features working NT Domain Control capability and 
includes the SWAT (Samba Web Administration Tool) that 
allows samba's smb.conf file to be remotely managed using your 
favourite web browser. For the time being this is being
enabled on TCP port 901 via inetd.

Users are advised to use Samba-2.2 as a Windows NT4
Domain Controller only on networks that do NOT have a Windows
NT Domain Controller. This release does NOT as yet have
Backup Domain control ability.

Please refer to the WHATSNEW.txt document for fixup information.
This binary release includes encrypted password support.

Please read the smb.conf file and ENCRYPTION.txt in the
docs directory for implementation details.

NOTE: Red Hat Linux uses PAM which has integrated support
for Shadow passwords and quotas. Do NOT recompile with the
SHADOW_PWD option enabled

%changelog
* Sat Mar 31 2001 Andrew Bartlett <abartlet@pcug.org.au>
 - Changed prefix/share/man for _mandir/share/man
  - Changed this for a sed macro MANDIR_MACRO
  - This allows us to build both RH7 (RPM4)
     and older versions from same specfile.
 - Made makerpms.sh use the rpm -ta command rather 
    than attempting to devine the correct location to 
    put the file.  Also removes some /tmp symlink games.
  - Allows build on RPM4
 - Increased PAM requirements to allow us to use 
   system-auth (this pam is in 6.x errata at least)

* Tue Mar 27 2001 John H Terpstra <jht@samba.org>
 - Fixed typos introduced by Sum Wun.
 - Build for Red Hat 7.x

* Sun Nov 12 2000 John H Terpstra <jht@samba.org>
 - Updated for Samba-2.2 releases
 - Added libnss_wins.so stuff
 - Added compile-time options

* Sat Nov 29 1999 Matthew Vanecek <mev0003@unt.edu>
 - Added a Prefix and changed "/usr" to "%{prefix}"

* Sat Nov 11 1999 Tridge <tridge@linuxcare.com>
 - changed from mount.smb to mount.smbfs

* Sat Oct 9 1999 Tridge <tridge@linuxcare.com>
 - removed smbwrapper
 - added smbmnt and smbmount

* Sun Apr 25 1999 John H Terpstra <jht@samba.org>
 - added smbsh.1 man page

* Fri Mar 26 1999 Andrew Tridgell <tridge@samba.org>
 - added --with-pam as pam is no longer used by default

* Sat Jan 27 1999 Jeremy Allison <jra@samba.org>
 - Removed smbrun binary and tidied up some loose ends

* Sun Oct 25 1998 John H Terpstra <jht@samba.org>
 - Added parameters to /config to ensure smb.conf, lmhosts, 
	and smbusers never gets over-written.

* Sat Oct 24 1998 John H Terpstra <jht@samba.org>
 - removed README.smbsh file from docs area

* Mon Oct 05 1998 John H Terpstra <jht@samba.org>
 - Added rpcclient to binaries list
 - Added smbwrapper stuff

* Fri Aug 21 1998 John H Terpstra <jht@samba.org>
 - Updated for Samba version 2.0 building

* Tue Jul 07 1998 Erik Troan <ewt@redhat.com>
  - updated postun triggerscript to check $0
  - clear /etc/codepages from %preun instead of %postun

* Sat Jul 04 1998 John H Terpstra <jht@samba.org>
 - fixed codepage preservation during update via -Uvh

* Mon Jun 08 1998 Erik Troan <ewt@redhat.com>
  - made the %postun script a tad less agressive; no reason to remove
    the logs or lock file 
  - the %postun and %preun should only exectute if this is the final
    removal
  - migrated %triggerpostun from Red Hat's samba package to work around
    packaging problems in some Red Hat samba releases

* Sun Apr 26 1998 John H Terpstra <jht@samba.org>
 - Tidy up for early alpha releases
 - added findsmb from SGI packaging

* Thu Apr 09 1998 John H Terpstra <jht@samba.org>
 - Updated spec file
 - Included new codepage.936

* Sat Mar 20 1998 John H Terpstra <jht@samba.org>
 - Added swat facility

* Sat Jan 24 1998 John H Terpstra <jht@samba.org>
 - Many optimisations (some suggested by Manoj Kasichainula <manojk@io.com>
  - Use of chkconfig in place of individual symlinks to /etc/rc.d/init/smb
  - Compounded make line
  - Updated smb.init restart mechanism
  - Use compound mkdir -p line instead of individual calls to mkdir
  - Fixed smb.conf file path for log files
  - Fixed smb.conf file path for incoming smb print spool directory
  - Added a number of options to smb.conf file
  - Added smbuser file and smb.conf file updates for username map

%prep
%setup

%build
cd source

%ifarch ia64
libtoolize --copy --force     # get it to recognize IA-64
autoheader
autoconf
EXTRA="-D_LARGEFILE64_SOURCE"
%endif
NUMCPU=`grep processor /proc/cpuinfo | wc -l`
CFLAGS="$RPM_OPT_FLAGS $EXTRA" ./configure \
	--prefix=%{prefix} \
	--localstatedir=/var \
	--with-configdir=/etc/samba \
	--with-privatedir=/etc/samba \
	--with-codepagedir=/etc/codepages \
	--with-fhs \
	--with-quotas \
	--with-smbmount \
	--with-pam \
	--with-syslog \
	--with-utmp \
	--with-netatalk \
	--with-sambabook=%{prefix}/share/swat/using_samba
make -j${NUMCPU} proto
make -j${NUMCPU} all nsswitch/libnss_wins.so
make -j${NUMCPU} debug2html
make -j${NUMCPU} bin/smbspool


%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/sbin
mkdir -p $RPM_BUILD_ROOT/etc/samba
mkdir -p $RPM_BUILD_ROOT/etc/codepages/src
mkdir -p $RPM_BUILD_ROOT/etc/{logrotate.d,pam.d,samba}
mkdir -p $RPM_BUILD_ROOT/etc/rc.d/init.d
mkdir -p $RPM_BUILD_ROOT%{prefix}/{bin,sbin}
mkdir -p $RPM_BUILD_ROOT%{prefix}/share/swat/{images,help,include,using_samba}
mkdir -p $RPM_BUILD_ROOT%{prefix}/share/swat/using_samba/{figs,gifs}
mkdir -p $RPM_BUILD_ROOTMANDIR_MACRO
mkdir -p $RPM_BUILD_ROOT/var/lock/samba
mkdir -p $RPM_BUILD_ROOT/var/log/samba
mkdir -p $RPM_BUILD_ROOT/var/spool/samba
mkdir -p $RPM_BUILD_ROOT/lib

# Install standard binary files
for i in nmblookup smbclient smbpasswd smbstatus testparm testprns \
      make_smbcodepage make_unicodemap make_printerdef rpcclient smbspool \
      smbcacls smbcontrol
do
install -m755 -s source/bin/$i $RPM_BUILD_ROOT%{prefix}/bin
done
for i in mksmbpasswd.sh smbtar 
do
install -m755 source/script/$i $RPM_BUILD_ROOT%{prefix}/bin
done

# Install secure binary files
for i in smbd nmbd swat smbmount smbumount smbmnt debug2html 
do
install -m755 -s source/bin/$i $RPM_BUILD_ROOT%{prefix}/sbin
done

# we need a symlink for mount to recognise the smb and smbfs filesystem types
ln -sf %{prefix}/sbin/smbmount $RPM_BUILD_ROOT/sbin/mount.smbfs
ln -sf %{prefix}/sbin/smbmount $RPM_BUILD_ROOT/sbin/mount.smb

# This allows us to get away without duplicating code that 
#  sombody else can maintain for us.  
cd source
make LIBDIR=$RPM_BUILD_ROOT/etc/samba \
	BINDIR=$RPM_BUILD_ROOT%{prefix}/bin \
	MANDIR=$RPM_BUILD_ROOTMANDIR_MACRO \
	CODEPAGEDIR=$RPM_BUILD_ROOT/etc/codepages \
	SWATDIR=$RPM_BUILD_ROOT/usr/share/swat \
	SAMBABOOK=$RPM_BUILD_ROOT/usr/share/swat/using_samba \
	installman installcp installswat
cd ..

# Install codepage source files
for i in source/codepages/codepage_def.* source/codepages/*.TXT
do
install -m644 $i $RPM_BUILD_ROOT/etc/codepages/src
done

# Install the nsswitch library extenstion file
install -m755 source/nsswitch/libnss_wins.so $RPM_BUILD_ROOT/lib
# Make link for wins resolver
( cd $RPM_BUILD_ROOT/lib; ln -s libnss_wins.so libnss_wins.so.2; )

# Install SWAT helper files
for i in swat/help/*.html docs/htmldocs/*.html
do
install -m644 $i $RPM_BUILD_ROOT%{prefix}/share/swat/help
done
for i in swat/images/*.gif
do
install -m644 $i $RPM_BUILD_ROOT%{prefix}/share/swat/images
done
for i in swat/include/*.html
do
install -m644 $i $RPM_BUILD_ROOT%{prefix}/share/swat/include
done

# Install the miscellany
install -m644 swat/README $RPM_BUILD_ROOT%{prefix}/share/swat
install -m755 packaging/RedHat/smbprint $RPM_BUILD_ROOT%{prefix}/bin
install -m755 packaging/RedHat/findsmb $RPM_BUILD_ROOT%{prefix}/bin
install -m755 packaging/RedHat/smb.init $RPM_BUILD_ROOT/etc/rc.d/init.d/smb
install -m755 packaging/RedHat/smb.init $RPM_BUILD_ROOT%{prefix}/sbin/samba
install -m644 packaging/RedHat/samba.log $RPM_BUILD_ROOT/etc/logrotate.d/samba
install -m644 packaging/RedHat/smb.conf $RPM_BUILD_ROOT/etc/samba/smb.conf
install -m644 packaging/RedHat/smbusers $RPM_BUILD_ROOT/etc/samba/smbusers
install -m644 packaging/RedHat/samba.pamd $RPM_BUILD_ROOT/etc/pam.d/samba
install -m644 packaging/RedHat/samba.pamd.stack $RPM_BUILD_ROOT/etc/samba/samba.stack
install -m644 packaging/RedHat/samba.xinetd $RPM_BUILD_ROOT/etc/samba/samba.xinetd
echo 127.0.0.1 localhost > $RPM_BUILD_ROOT/etc/samba/lmhosts

%clean
rm -rf $RPM_BUILD_ROOT

%post
/sbin/chkconfig --add smb
/sbin/chkconfig smb off

echo "Looking for old /etc/smb.conf..."
if [ -f /etc/smb.conf ]; then
	echo "Moving old /etc/smb.conf to /etc/samba/smb.conf"
	mv /etc/smb.conf /etc/samba/smb.conf
fi

echo "Looking for old /etc/smbusers..."
if [ -f /etc/smbusers ]; then
	echo "Moving old /etc/smbusers to /etc/samba/smbusers"
	mv /etc/smbusers /etc/samba/smbusers
fi

echo "Looking for old /etc/lmhosts..."
if [ -f /etc/lmhosts ]; then
	echo "Moving old /etc/lmhosts to /etc/samba/lmhosts"
	mv /etc/lmhosts /etc/samba/lmhosts
fi

echo "Looking for old /etc/MACHINE.SID..."
if [ -f /etc/MACHINE.SID ]; then
	echo "Moving old /etc/MACHINE.SID to /etc/samba/MACHINE.SID"
	mv /etc/MACHINE.SID /etc/samba/MACHINE.SID
fi

echo "Looking for old /etc/smbpasswd..."
if [ -f /etc/smbpasswd ]; then
	echo "Moving old /etc/smbpasswd to /etc/samba/smbpasswd"
	mv /etc/smbpasswd /etc/samba/smbpasswd
fi

# Add swat entry to /etc/services if not already there.
if !( grep ^[:space:]*swat /etc/services > /dev/null ) then
	echo 'swat		901/tcp				# Add swat service used via inetd' >> /etc/services
fi

# Add swat entry to /etc/inetd.conf if needed.
if [ -f /etc/inetd.conf ]; then
	if !( grep ^[:space:]*swat /etc/inetd.conf > /dev/null ) then
		echo 'swat	stream	tcp	nowait.400	root	%{prefix}/sbin/swat swat' >> /etc/inetd.conf
	killall -1 inetd || :
	fi
fi

# Add swat entry to xinetd.d if needed.
if [ -d $RPM_BUILD_ROOT/etc/xinetd.d ]; then
    mv /etc/samba/samba.xinetd /etc/xinetd.d/swat
else
	rm -f /etc/samba/samba.xinetd
fi

# Install the correct version of the samba pam file, depending on pam version.
if [ -f /lib/security/pam_stack.so ]; then
	echo "Installing stack version of /etc/pam.d/samba..."
	mv /etc/samba/samba.stack /etc/pam.d/samba
else
	echo "Installing non-stack version of /etc/pam.d/samba..."
	rm -f /etc/samba/samba.stack
fi

%preun
if [ $1 = 0 ] ; then
    /sbin/chkconfig --del smb

    # We want to remove the browse.dat and wins.dat files so they can not interfer with a new version of samba!
    if [ -e /var/lock/samba/browse.dat ]; then
	    rm -f /var/lock/samba/browse.dat
    fi
    if [ -e /var/lock/samba/wins.dat ]; then
	    rm -f /var/lock/samba/wins.dat
    fi

	# Remove the transient tdb files.
	if [ -e /var/lock/samba/brlock.tdb ]; then
		rm -f /var/lock/samba/brlock.tdb
	fi

	if [ -e /var/lock/samba/unexpected.tdb ]; then
		rm -f /var/lock/samba/unexpected.tdb
	fi

	if [ -e /var/lock/samba/connections.tdb ]; then
		rm -f /var/lock/samba/connections.tdb
	fi

	if [ -e /var/lock/samba/locking.tdb ]; then
		rm -f /var/lock/samba/locking.tdb
	fi

	if [ -e /var/lock/samba/messages.tdb ]; then
		rm -f /var/lock/samba/messages.tdb
	fi

fi

%postun
# Only delete remnants of samba if this is the final deletion.
if [ $1 = 0 ] ; then
    if [ -x /etc/pam.d/samba ]; then
      rm -f /etc/pam.d/samba
    fi
    if [ -e /var/log/samba ]; then
      rm -rf /var/log/samba
    fi

    # Remove swat entries from /etc/inetd.conf and /etc/services
    cd /etc
    tmpfile=/etc/tmp.$$
	if [ -f /etc/inetd.conf ]; then
      # preserve inetd.conf permissions.
      cp -p /etc/inetd.conf $tmpfile
      sed -e '/^[:space:]*swat.*$/d' /etc/inetd.conf > $tmpfile
      mv $tmpfile inetd.conf
	fi
    # preserve services permissions.
    cp -p /etc/services $tmpfile
    sed -e '/^[:space:]*swat.*$/d' /etc/services > $tmpfile
    mv $tmpfile /etc/services

	# Remove swat entry from /etc/xinetd.d
	if [ -f /etc/xinetd.d/swat ]; then
		rm -r /etc/xinetd.d/swat
	fi
fi

%triggerpostun -- samba < samba-2.0.0
if [ $0 != 0 ]; then
    /sbin/chkconfig --add smb
fi

%files
%doc README COPYING Manifest Read-Manifest-Now
%doc WHATSNEW.txt Roadmap
%doc docs
%doc swat/README
%doc examples
%attr(-,root,root) %{prefix}/sbin/smbd
%attr(-,root,root) %{prefix}/sbin/nmbd
%attr(-,root,root) %{prefix}/sbin/swat
%attr(-,root,root) %{prefix}/sbin/smbmnt
%attr(-,root,root) %{prefix}/sbin/smbmount
%attr(-,root,root) %{prefix}/sbin/smbumount
%attr(-,root,root) /sbin/mount.smbfs
%attr(-,root,root) /sbin/mount.smb
%attr(-,root,root) %{prefix}/bin/mksmbpasswd.sh
%attr(-,root,root) %{prefix}/bin/smbclient
%attr(-,root,root) %{prefix}/bin/smbspool
%attr(-,root,root) %{prefix}/bin/rpcclient
%attr(-,root,root) %{prefix}/bin/testparm
%attr(-,root,root) %{prefix}/bin/testprns
%attr(-,root,root) %{prefix}/bin/findsmb
%attr(-,root,root) %{prefix}/bin/smbstatus
%attr(-,root,root) %{prefix}/bin/nmblookup
%attr(-,root,root) %{prefix}/bin/make_smbcodepage
%attr(-,root,root) %{prefix}/bin/make_unicodemap
%attr(-,root,root) %{prefix}/bin/make_printerdef
%attr(-,root,root) %{prefix}/bin/smbpasswd
%attr(-,root,root) %{prefix}/bin/smbtar
%attr(-,root,root) %{prefix}/bin/smbprint
%attr(-,root,root) %{prefix}/bin/smbcontrol
%attr(-,root,root) %{prefix}/bin/smbcacls
%attr(755,root,root) /lib/libnss_wins.s*
%attr(-,root,root) %{prefix}/share/swat/help/*
%attr(-,root,root) %{prefix}/share/swat/images/*
%attr(-,root,root) %{prefix}/share/swat/include/header.html
%attr(-,root,root) %{prefix}/share/swat/include/footer.html
%attr(-,root,root) %{prefix}/share/swat/using_samba/*
%attr(-,root,root) %config(noreplace) /etc/samba/lmhosts
%attr(-,root,root) %config(noreplace) /etc/samba/smb.conf
%attr(-,root,root) %config(noreplace) /etc/samba/smbusers
%attr(-,root,root) /etc/samba/samba.stack
%attr(-,root,root) /etc/samba/samba.xinetd
%attr(-,root,root) /etc/rc.d/init.d/smb
%attr(-,root,root) /etc/logrotate.d/samba
%attr(-,root,root) %config(noreplace) /etc/pam.d/samba
%attr(-,root,root) MANDIR_MACRO/man1/*
%attr(-,root,root) MANDIR_MACRO/man5/*
%attr(-,root,root) MANDIR_MACRO/man7/*
%attr(-,root,root) MANDIR_MACRO/man8/*
%attr(-,root,root) %dir /etc/codepages/*
%attr(755,root,root) %dir /var/lock/samba
%attr(-,root,root) %dir /var/log/samba
%attr(1777,root,root) %dir /var/spool/samba
