/*
For general Sqliteman copyright and licensing information please refer
to the COPYING file provided with the program. Following this notice may exist
a copyright and/or license notice that predates the release of Sqliteman
for which a new license (GPL+exception) is in place.
*/
#include <QUrl>
#include <QSettings>

#include "helpbrowser.h"

HelpBrowser::HelpBrowser(QWidget * parent)
	: QMainWindow(parent)
{
	ui.setupUi(this);
	// menu
	QStringList spaths;
	spaths << DOC_DIR;
	ui.menuBrowser->setSearchPaths(spaths);
	ui.textBrowser->setSearchPaths(spaths);
	ui.menuBrowser->setSource(QUrl("menu.html"));
	ui.textBrowser->setSource(QUrl("index.html"));

	// settings
	QSettings settings("yarpen.cz", "sqliteman");
	QPoint pos = settings.value("help/pos", QPoint(200, 200)).toPoint();
	QSize size = settings.value("help/size", QSize(400, 400)).toSize();
	QByteArray splitterData = settings.value("help/splitter").toByteArray();

	move(pos);
	resize(size);	
	ui.splitter->restoreState(splitterData);


	connect(ui.menuBrowser, SIGNAL(anchorClicked(const QUrl &)),
			this, SLOT(menuBrowser_anchorClicked(const QUrl &)));
	connect(ui.actionBack, SIGNAL(triggered()), ui.textBrowser, SLOT(backward()));
	connect(ui.actionForward, SIGNAL(triggered()), ui.textBrowser, SLOT(forward()));
	connect(ui.action_Close, SIGNAL(triggered()), this, SLOT(close()));
}

void HelpBrowser::closeEvent(QCloseEvent *e)
{
	QSettings settings("yarpen.cz", "sqliteman");

	settings.setValue("help/pos", pos());
	settings.setValue("help/size", size());
	settings.setValue("help/splitter", ui.splitter->saveState());

	QMainWindow::closeEvent(e);
}

void HelpBrowser::menuBrowser_anchorClicked(const QUrl & url)
{
	ui.textBrowser->setSource(url);
	ui.menuBrowser->setSource(QUrl("menu.html"));
}
