/*
For general Sqliteman copyright and licensing information please refer
to the COPYING file provided with the program. Following this notice may exist
a copyright and/or license notice that predates the release of Sqliteman
for which a new license (GPL+exception) is in place.
*/

#include <QCheckBox>
#include <QSqlQuery>
#include <QSqlError>

#include "createtabledialog.h"
#include "database.h"


CreateTableDialog::CreateTableDialog(QWidget * parent)
	: TableEditorDialog(parent)
{
	update = false;
	ui.removeButton->setEnabled(false);	// Disable row removal
	addField(); // A table should have at least one field
	setWindowTitle(tr("Create Table"));

	ui.createButton->setDisabled(true);

	ui.textEdit->setText("CREATE TABLE [IF NOT EXISTS] <database-name.table-name>\n\
(\n\
    <column-name> <type> <constraint...>,\n\
    ...\n\
)");
}

QString CreateTableDialog::getSQLfromGUI()
{
	QString sql(QString("CREATE TABLE %1 (").arg(getFullName(ui.nameEdit->text())));
	QString nn;
	QString def;
	DatabaseTableField f;

	for(int i = 0; i < ui.columnTable->rowCount(); i++)
	{
		f = getColumn(i);
		if (f.cid == -1)
			continue;

		nn = f.notnull ? " NOT NULL" : "";
		def = f.defval.length() > 0 ? QString(" DEFAULT (%1)").arg(f.defval) : "";

		sql += ("'" + f.name + "' " + f.type + nn + def + ", ");
	}
	sql = sql.remove(sql.size() - 2, 2); 	// cut the extra ", "
	sql += ");";

	return sql;
}

void CreateTableDialog::createButton_clicked()
{
	QString sql;
	// from GUI
	if (ui.tabWidget->currentIndex() == 0)
		sql = getSQLfromGUI();
	else
		sql = ui.textEdit->toPlainText();

	QSqlQuery query(sql, QSqlDatabase::database(SESSION_NAME));
	if(query.lastError().isValid())
	{
		ui.resultEdit->setText(tr("Error while creating table: %1.\n\n%2").arg(query.lastError().databaseText()).arg(sql));
		return;
	}
	update = true;
	ui.resultEdit->setText(tr("Table created successfully"));
}
