%{
/*	$Id: scan.l,v 1.6 2005/12/01 10:43:47 mbalmer Exp $ */

#include <string.h>

#ifdef __FreeBSD__
#include "parse.h"
#else
#include "y.tab.h"
#endif

%}

%option yylineno noyywrap nounput

%%

log-facility	{ return LOGFAC; }
ldaphost	{ return LDAPHOST; }
ldapport	{ return LDAPPORT; }
ldapurl		{ return LDAPURL; }
searchbase	{ return SEARCHBASE; }
binddn		{ return BINDDN; }
bindpasswd	{ return BINDPASSWD; }
usetls		{ return USETLS; }
spamheader	{ return SPAMHEADER; }
query		{ return QUERY; }
mail		{ return MAIL; }

local0		{ return LOCAL0; }
local1		{ return LOCAL1; }
local2		{ return LOCAL2; }
local3		{ return LOCAL3; }
local4		{ return LOCAL4; }
local5		{ return LOCAL5; }
local6		{ return LOCAL6; }
local7		{ return LOCAL7; }
daemon		{ return DAEMON;}
mail		{ return MAIL; }
user		{ return USER; }

true		{ return TRUE; }
false		{ return FALSE; }

[0-9]+		{ yylval.string = strdup(yytext); return NUMBER; }

^[ \t]*\n	|
#.*\n		{ ; }

\"([^"\n]*)["\n]	{
				yytext[yyleng - 1] = 0;
				yyleng -=2;
				yylval.string = strdup(yytext+1);
				return TEXT;
			}

\n		{ return '\n'; }

[ \t]*=[ \t]*	{ return '='; }
