##############################################################################
#
# Widget to show basic statistics
#
# <Peter.Bienstman@UGent.be>
#
##############################################################################

from qt import *
from mnemosyne.core import *
from statistics_frm import *



##############################################################################
#
# ListItem
#
##############################################################################

class ListItem(QListViewItem):
    def __init__(self, parent, name, number):
        QListViewItem.__init__(self, parent, name, str(number))
        self.setMultiLinesEnabled(1)
        
    def compare(self, item, column, ascending):
        if column == 0:
            return self.key(0,ascending).compare(item.key(0,ascending))
        else: # Funny casts for Windows compatibility.
            return int(str(self.text(1))) - int(str(item.text(1)))


        
##############################################################################
#
# StatisticsDlg
#
##############################################################################

class StatisticsDlg(StatisticsFrm):

    ##########################################################################
    #
    # __init__
    #
    ##########################################################################
    
    def __init__(self, current_item, parent=None, name=None, modal=0):
        
        StatisticsFrm.__init__(self,parent,name,modal,
                              Qt.WStyle_MinMax | Qt.WStyle_SysMenu)

        # Schedule information.

        text = self.trUtf8("Scheduled cards for the next days:\n\n")

        old_cumulative = 0
        for days in range(0,8):
            cumulative = scheduled_items(days)
            text.append(self.trUtf8("In")).\
                 append(QString(" " + str(days) + " ")).\
                 append(self.trUtf8("day(s) :")).\
                 append(QString(" " + str(cumulative-old_cumulative) + "\n"))
            old_cumulative = cumulative
            
        self.schedule_info.setText(text)

        # Grade information.

        text = self.trUtf8("Number of cards with the following grades:\n\n")

        grades = [0, 0, 0, 0, 0, 0]
        for item in get_items():
            if item.is_in_active_category():
                grades[item.grade] += 1

        norm = sum(grades)
        if norm == 0:
            norm = 1 # Avoid division by zero.

        for grade in range(0,6):
            text.append(self.trUtf8("Grade")).\
                 append(QString(" " + str(grade) + " : " \
                    + str(grades[grade]) + " ("\
                    + ("%.1f" % (100.*grades[grade] / norm)) + " %)\n"))
        
        self.grades_info.setText(text)

        # Category information.

        categories = {}
        for item in get_items():
            name = item.cat.name
            if name not in categories.keys():
                categories[name] = 1
            else:
                categories[name] += 1

        for cat in categories.keys():
            ListItem(self.category_info, cat, categories[cat])

        # Current card information.

        item = current_item

        if item == None:
            text = QString(self.trUtf8("No current card."))
        else:
            text = QString()
            text.append(self.trUtf8("Grade:"))
            text.append(QString(" " + str(item.grade) + "\n"))
        
            text.append(self.trUtf8("Easiness:"))
            text.append(QString(" " + "%1.2f" % item.easiness + "\n"))
        
            text.append(self.trUtf8("Repetitions:"))
            text.append(QString(" " + str(item.acq_reps+item.ret_reps) + "\n"))
        
            text.append(self.trUtf8("Lapses:"))
            text.append(QString(" " + str(item.lapses) + "\n"))
        
            text.append(self.trUtf8("Days since last repetition:"))
            text.append(QString(" " + str(item.days_since_last_rep()) + "\n"))
        
            text.append(self.trUtf8("Days until next repetition:"))
            text.append(QString(" " + str(item.days_until_next_rep()) + "\n"))
       
        self.current_info.setText(text)
