/*
 * EveryBuddy 
 *
 * Copyright (C) 1999, Torrey Searle <tsearle@uci.edu>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */


#include <gtk/gtk.h>
#include <string.h>

static GtkWidget * progress_meter;
static GtkWidget * progress_window;

static gint is_open = 0;
static unsigned long file_size;

static void destroy( GtkWidget * widget, gpointer data )
{
	is_open = 0;
}

void progress_window_new( char * filename, unsigned long size )
{
	if(!is_open)
	{
		GtkWidget * vbox = gtk_vbox_new( FALSE, 5);
		GtkWidget * label;
		gchar buff[2048];
		is_open = 1;
		g_snprintf( buff, 2048, "Transfering %s", filename);
		label = gtk_label_new(buff);

		gtk_box_pack_start(GTK_BOX(vbox),label, TRUE, TRUE, 5);
		gtk_widget_show(label);

		progress_meter = gtk_progress_bar_new();
		gtk_progress_bar_set_orientation(GTK_PROGRESS_BAR(progress_meter),
										 GTK_PROGRESS_LEFT_TO_RIGHT );

		gtk_box_pack_start(GTK_BOX(vbox),progress_meter, TRUE, TRUE, 5);
		gtk_widget_show(progress_meter);

		progress_window = gtk_window_new(GTK_WINDOW_DIALOG);
		gtk_container_add(GTK_CONTAINER(progress_window), vbox);
    	gtk_signal_connect( GTK_OBJECT(progress_window), "destroy",
	                        GTK_SIGNAL_FUNC(destroy), NULL );

		gtk_widget_show(vbox);
		gtk_widget_show(progress_window);
	}

	file_size = size;
}
		
void update_progress(unsigned long progress)
{
	if(is_open)
	{
		gtk_progress_bar_update(GTK_PROGRESS_BAR(progress_meter), ((float)progress)/((float)file_size));
	}
}

void progress_window_close()
{
	if(is_open)
	{
		gtk_widget_destroy(progress_window);
	}
}

