/*
 * EveryBuddy 
 *
 * Copyright (C) 1999, Torrey Searle <tsearle@uci.edu>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/*
 * account.h
 * file for account bits
 */

#ifndef __ACCOUNT_H__
#define __ACCOUNT_H__

#include <gtk/gtk.h>
#include "contact.h"


typedef struct _grouplist
{
	gchar name[255];
	GList * members;
	GtkWidget * list_item;
	GtkWidget * tree;
	GtkWidget * label;
	gint contacts_online;
	gint contacts_shown;
} grouplist;

typedef struct account {
        gint service_id;
        gchar handle[255];
				struct contact * account_contact;
        void *protocol_account_data;
				GtkWidget * list_item;
				GtkWidget * status;
				GtkWidget * pix;
				gint icon_handler;
				gboolean online;
				gint status_handler;
		 		struct _info_window * infowindow;
} eb_account;


typedef struct local_account {
        gint service_id;
        gchar *handle;
		gchar alias[255];
        gboolean connected;
		GtkWidget * status_button;
		GSList * status_menu;
        void *protocol_local_account_data;
} eb_local_account;

int load_accounts();
int load_contacts();
void write_contact_list();

#endif /* __ACCOUNT_H__*/
