/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edit.ui.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.edit.command.CommandActionDelegate;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;

public class CommandAction
implements IEditorActionDelegate {
    protected IEditorPart editorPart;
    protected IAction action;
    protected EditingDomain editingDomain;
    protected Collection collection;
    protected Command command;

    protected Command createActionCommand(EditingDomain editingDomain, Collection collection) {
        return UnexecutableCommand.INSTANCE;
    }

    protected ImageDescriptor getDefaultImageDescriptor() {
        return null;
    }

    public void setActiveEditor(IAction action, IEditorPart editorPart) {
        if (this.editorPart != editorPart) {
            this.editingDomain = null;
            if (editorPart != null && editorPart instanceof IEditingDomainProvider) {
                this.editingDomain = ((IEditingDomainProvider)editorPart).getEditingDomain();
            }
            this.editorPart = editorPart;
        }
        this.action = action;
    }

    public void run(IAction action) {
        if (this.editingDomain != null && this.command != null) {
            this.editingDomain.getCommandStack().execute(this.command);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            Object object;
            this.collection = new ArrayList();
            Iterator elements = ((IStructuredSelection)selection).iterator();
            while (elements.hasNext()) {
                this.collection.add(elements.next());
            }
            if (this.editorPart == null) {
                Iterator objects = this.collection.iterator();
                while (objects.hasNext()) {
                    object = objects.next();
                    this.editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor(object);
                    if (this.editingDomain != null) break;
                }
            }
            if (this.editingDomain != null) {
                this.command = this.createActionCommand(this.editingDomain, this.collection);
                ((Action)action).setEnabled(this.command.canExecute());
                if (this.command instanceof CommandActionDelegate) {
                    CommandActionDelegate commandActionDelegate = (CommandActionDelegate)this.command;
                    object = commandActionDelegate.getImage();
                    ImageDescriptor imageDescriptor = this.objectToImageDescriptor(object);
                    if (imageDescriptor != null) {
                        ((Action)action).setImageDescriptor(imageDescriptor);
                    } else if (this.getDefaultImageDescriptor() != null) {
                        ((Action)action).setImageDescriptor(this.getDefaultImageDescriptor());
                    }
                    if (commandActionDelegate.getText() != null) {
                        ((Action)action).setText(commandActionDelegate.getText());
                    }
                    if (commandActionDelegate.getDescription() != null) {
                        ((Action)action).setDescription(commandActionDelegate.getDescription());
                    }
                    if (commandActionDelegate.getToolTipText() != null) {
                        ((Action)action).setToolTipText(commandActionDelegate.getToolTipText());
                    }
                }
                return;
            }
        }
        ((Action)action).setEnabled(false);
        this.command = null;
        this.collection = null;
        if (this.getDefaultImageDescriptor() != null) {
            ((Action)action).setImageDescriptor(this.getDefaultImageDescriptor());
        }
    }

    protected ImageDescriptor objectToImageDescriptor(Object object) {
        return ExtendedImageRegistry.getInstance().getImageDescriptor(object);
    }
}

