/* 

                          Firewall Builder

                 Copyright (C) 2003 NetCitadel, LLC

  Author:  Illiya Yalovoy <yalovoy@gmail.com>

  $Id: instBatchOptionsDialog.cpp,v 1.3 2006/08/28 06:03:10 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "config.h"
#include "global.h"
#include "utils.h"
#include "platforms.h"
#include "definitions.h"

#include "instBatchOptionsDialog.h"

#include "fwbuilder/Library.h"
#include "fwbuilder/FWException.h"
#include "fwbuilder/Firewall.h"

#include <qstring.h>
#include <qlineedit.h>
#include <qlabel.h>

#include <stdlib.h>

using namespace std;
using namespace libfwbuilder;

instBatchOptionsDialog::instBatchOptionsDialog(QWidget *parent) : instOptionsDialog_q(parent)
{
    dialogTitleLine->setText(QString("<p align=\"center\"><b><font size=\"+2\">")+
                             tr("Batch install options")+
                             QString("</font></b></p>")
    );
    altAddressLabel->hide();
    altAddress->hide();
    
}

void instBatchOptionsDialog::applyChanges()
{
    hide();
}

void instBatchOptionsDialog::discardChanges()
{
    hide();
}

QString instBatchOptionsDialog::getUName() { return uname->text(); }
QString instBatchOptionsDialog::getPWD()   { return pwd->text();   }
QString instBatchOptionsDialog::getEPWD()  { return epwd->text();  }

void instBatchOptionsDialog::closeEvent(QCloseEvent *e)
{
    if (fwbdebug)
        qDebug("instBatchOptionsDialog::closeEvent  got close event: %p",e);
    hide();
}

